/*=============================================================================*\
 * CTB EncounterEffectBeforeCode
 * By CT_Bolt
 * Terms of Use:
 *  Free for commercial or non-commercial use
 *
/*=============================================================================*/
var CTB = CTB || {}; CTB.EncounterEffectBeforeCode  = CTB.EncounterEffectBeforeCode || {};
var Imported = Imported || {}; Imported["CT_Bolt EncounterEffectBeforeCode"] = 1.10;
//=============================================================================//

/*:
 * @plugindesc [RPG Maker MV] [Tier 1] [Version 1.10] CT_Bolt's Encounter Effect Before Code Plugin
 * @author CT_Bolt
 *
 * @help
 * Script calls:
 *  playEncounterEffect(code, useBattleBGM)
 *  playCommonEvent(id)
 *
 *  Example:
 *    playEncounterEffect('playCommonEvent(1)')
 * 
 * To keep the battle BGM set the second parameter to true
 *    playEncounterEffect('playCommonEvent(1)', true)
 * That will run common event #1 and retain the battle BGM to play as usual
 *
 * Example of a good use is to make a common event that transfers player to another map
 * but you also want to instead make the battle music play rather then the normal autoplay BGM
 *
 * Hope that makes sense.
 *
 */
//=============================================================================
//=============================================================================

"use strict";
(function ($_$) {
    function getPluginParameters() {var a = document.currentScript || (function() { var b = document.getElementsByTagName('script'); return b[b.length - 1]; })(); return PluginManager.parameters(a.src.substring((a.src.lastIndexOf('/') + 1), a.src.indexOf('.js')));} $_$.params = getPluginParameters();

	$_$['BattleManager.playBattleBgm'] = BattleManager.playBattleBgm;
	BattleManager.playBattleBgm = function() {
		if (!CTB.EncounterEffectBeforeCode._code || CTB.EncounterEffectBeforeCode.useBattleMusic){
			$_$['BattleManager.playBattleBgm'].apply(this, arguments);
		};
	};
	
	$_$['Game_Map.prototype.autoplay'] = Game_Map.prototype.autoplay;
	Game_Map.prototype.autoplay = function() {
		if (CTB.EncounterEffectBeforeCode.useBattleMusic){
			$dataMap.autoplayBgm = false;
		};
		$_$['Game_Map.prototype.autoplay'].apply(this, arguments);
	};

	$_$['Scene_Map.prototype.updateEncounterEffect'] = Scene_Map.prototype.updateEncounterEffect;	
	Scene_Map.prototype.updateEncounterEffect = function() {
		if (CTB.EncounterEffectBeforeCode._code) {
			if (this._encounterEffectDuration > 0) {
				$_$['Scene_Map.prototype.updateEncounterEffect'].apply(this, arguments);
			}else{
				eval(CTB.EncounterEffectBeforeCode._code);
				CTB.EncounterEffectBeforeCode._code = null;
			}
		}else{
			$_$['Scene_Map.prototype.updateEncounterEffect'].apply(this, arguments);
		};
	};

	$_$['Scene_Map.prototype.update'] = Scene_Map.prototype.update;
	Scene_Map.prototype.update = function() {
		if (CTB.EncounterEffectBeforeCode._code) {
			this.updateDestination();
			this.updateMainMultiply();
			this.updateEncounterEffect();
			this.updateWaitCount();
			Scene_Base.prototype.update.call(this);
		}else{
			$_$['Scene_Map.prototype.update'].apply(this, arguments);
		};
	};

})(CTB.EncounterEffectBeforeCode);

function playCommonEvent(id){
	let interpreter = $gameParty.inBattle() ? $gameTroop._interpreter : $gameMap._interpreter;
	interpreter._params = [eval(id)];
	interpreter.command117();
	$gameTemp._commonEventId = eval(id);
};

function playEncounterEffect(code, useBattleBGM){
	CTB.EncounterEffectBeforeCode.useBattleMusic = eval(useBattleBGM);
	CTB.EncounterEffectBeforeCode._code = code;
	SceneManager._scene.launchBattle();
};