//=============================================================================
// NCustomOptions.js
//=============================================================================

/*:
 * @plugindesc オプションにバーをつけるプラグイン。 V1.0.0
 * @author NJ
 *
 * @help
 * - このプラグインは導入するだけで機能します。
 * - 念のため、オプション系を追加するプラグインより下に配置してください。
 *
 *
 * バージョン
 * v1.0.0 初回
 *
 * 利用規約：
 *  プラグイン作者に無断で使用、改変、再配布は不可です。
 */

(function() {
    var SLIDER_MIN = 0;
    var SLIDER_MAX = 100;
    var SLIDER_STEP = 10;
    var SLIDER_FINE_STEP = 1;
    var numericOptions = ['myVolume', 'yourCustomValue'];

    numericOptions.forEach(function(key) {
        if (!(key in ConfigManager)) {
            ConfigManager[key] = undefined;
        }
    });

    var _Window_Options_drawItem = Window_Options.prototype.drawItem;
    Window_Options.prototype.drawItem = function(index) {
        var symbol = this.commandSymbol(index);
        var value = this.getConfigValue(symbol);
        if (typeof value === 'number') {
            var rect = this.itemRectForText(index);
            var statusWidth = this.statusWidth();
            var titleWidth = rect.width - statusWidth;
            var title = this.commandName(index);
            this.resetTextColor();
            this.changePaintOpacity(this.isCommandEnabled(index));
            this.drawText(title, rect.x, rect.y, titleWidth, 'left');
            this.drawSlider(rect, value);
            this.drawText(value, rect.x + rect.width - 48, rect.y, 48, 'right');
        } else {
            _Window_Options_drawItem.call(this, index);
        }
    };

    Window_Options.prototype.drawSlider = function(rect, value) {
        var x = rect.x + rect.width - this.statusWidth();
        var y = rect.y + rect.height / 2 - 6;
        var width = this.statusWidth() - 48;
        var height = 12;
        var rate = (value - SLIDER_MIN) / (SLIDER_MAX - SLIDER_MIN);
        var fillW = Math.floor(width * rate);
        this.contents.fillRect(x, y, width, height, '#666666');
        this.contents.fillRect(x, y, fillW, height, '#cccccc');
    };

    Window_Options.prototype.adjustSliderValue = function(current, step) {
        var base = Math.floor(current / step) * step;
        base += step;
        if (base > SLIDER_MAX) base = SLIDER_MIN;
        return base;
    };

    const _Window_Options_processOk = Window_Options.prototype.processOk;
    Window_Options.prototype.processOk = function() {
        var index = this.index();
        var symbol = this.commandSymbol(index);
        var value = this.getConfigValue(symbol);

        if (typeof value === 'number') {
            var rect = this.itemRect(index);
            var gaugeX = rect.x + rect.width - this.statusWidth();
            var width = this.statusWidth() - 48;
            var x = this.canvasToLocalX(TouchInput.x);
            var margin = 10;

            if (TouchInput.isPressed() && x >= gaugeX - margin && x <= gaugeX + width + margin) {
                return;
            }

            var newValue = this.adjustSliderValue(value, SLIDER_STEP);
            this.changeValue(symbol, newValue);
        } else {
            _Window_Options_processOk.call(this);
        }
    };

    var _Window_Options_cursorRight = Window_Options.prototype.cursorRight;
    Window_Options.prototype.cursorRight = function(wrap) {
        var symbol = this.commandSymbol(this.index());
        var value = this.getConfigValue(symbol);
        if (typeof value === 'number') {
            this.changeValue(symbol, value + SLIDER_FINE_STEP);
        } else {
            _Window_Options_cursorRight.call(this, wrap);
        }
    };

    var _Window_Options_cursorLeft = Window_Options.prototype.cursorLeft;
    Window_Options.prototype.cursorLeft = function(wrap) {
        var symbol = this.commandSymbol(this.index());
        var value = this.getConfigValue(symbol);
        if (typeof value === 'number') {
            this.changeValue(symbol, value - SLIDER_FINE_STEP);
        } else {
            _Window_Options_cursorLeft.call(this, wrap);
        }
    };

    Window_Options.prototype.changeValue = function(symbol, value) {
        value = Math.max(SLIDER_MIN, Math.min(SLIDER_MAX, value));
        var oldValue = this.getConfigValue(symbol);
        if (oldValue !== value) {
            this.setConfigValue(symbol, value);
            this.redrawItem(this.index());
        }
    };

    var _Window_Options_update = Window_Options.prototype.update;
    Window_Options.prototype.update = function() {
        _Window_Options_update.call(this);
        this.processMouseSlider();
    };

    Window_Options.prototype.processMouseSlider = function() {
        if (TouchInput.isPressed()) {
            var x = this.canvasToLocalX(TouchInput.x);
            var y = this.canvasToLocalY(TouchInput.y);

            if (this._sliderActiveIndex == null) {
                for (var i = 0; i < this.maxItems(); i++) {
                    var rect = this.itemRect(i);
                    if (y >= rect.y && y < rect.y + this.itemHeight()) {
                        var symbol = this.commandSymbol(i);
                        var value = this.getConfigValue(symbol);
                        if (typeof value === 'number') {
                            var gaugeX = rect.x + rect.width - this.statusWidth();
                            var width = this.statusWidth() - 48;
                            var margin = 10;

                            if (x >= gaugeX - margin && x <= gaugeX + width + margin) {
                                this._sliderActiveIndex = i;
                                break;
                            }
                        }
                    }
                }
            }

            if (this._sliderActiveIndex != null) {
                var i = this._sliderActiveIndex;
                var rect = this.itemRect(i);
                var symbol = this.commandSymbol(i);
                var gaugeX = rect.x + rect.width - this.statusWidth();
                var width = this.statusWidth() - 48;

                var clampedX = Math.max(gaugeX, Math.min(x, gaugeX + width));
                var ratio = (clampedX - gaugeX) / width;
                var newValue = Math.round(ratio * (SLIDER_MAX - SLIDER_MIN)) + SLIDER_MIN;

                if (x < gaugeX) newValue = SLIDER_MIN;
                if (x > gaugeX + width) newValue = SLIDER_MAX;

                    this.changeValue(symbol, newValue);
            }
        } else {
            this._sliderActiveIndex = null;
        }
    };

    var _Window_Options_getConfigValue = Window_Options.prototype.getConfigValue;
    Window_Options.prototype.getConfigValue = function(symbol) {
        if (numericOptions.indexOf(symbol) >= 0) {
            var value = ConfigManager[symbol];
            return (value !== undefined && value !== null) ? value : 50;
        } else {
            return _Window_Options_getConfigValue.call(this, symbol);
        }
    };

})();