//=============================================================================
// NrSpineTimeScale.js
//=============================================================================

/*:
 * @plugindesc Spineの再生速度をトラック単位で変える。 v1.0.0
 * @author NJ
 *
 * @help
 * 注意:
 * - PictureSpineプラグインが必要です。
 * - プラグイン管理でPictureSpineの「下」に配置してください。
 *
 * スクリプトコマンド：
 *
 * - $gameScreen.spine(pictureId).setTrackTimeScale(trackId, timeScale);
 *
 * 例：
 *   $gameScreen.spine(5).setTrackTimeScale(1, 0.5);
 * - ピクチャ5番のSpineのトラック1の再生速度を0.5倍にします。
 *
 * バージョン：
 * v1.0.0 初回
 *
 * 利用規約：
 * - プラグイン作者に無断で使用、改変、再配布は不可です。
 */

(() => {
    const _Sprite_Spine_update = Sprite_Spine.prototype.update;
    Sprite_Spine.prototype.update = function() {
        _Sprite_Spine_update.call(this);

        const spine = this.spine();
        if (!this._data || !spine || !spine.playData) return;

        this._data.state.tracks.forEach((entry, id) => {
            const playList = spine.playData[id];
            if (entry && playList && playList[0] && typeof playList[0].timeScale === 'number') {
                entry.timeScale = playList[0].timeScale;
            }
        });
    };

    Game_Spine.prototype.setTrackTimeScale = function(trackId, timeScale) {
        this._playData = this._playData || [];
        if (!this._playData[trackId]) return this;

        this._playData[trackId].forEach(data => {
            data.timeScale = Number(timeScale);
        });
        return this;
    };
})();
