/*:
* @plugindesc エンカウント時にフキダシ表示やＳＥ演奏などを行う
* @param waitCount
* @text ウェイトカウント
* @desc エンカウント時に停止させるフレーム数。
* @default 60
* @type number
*
* @param balloonId
* @text フキダシID
* @desc フキダシのIDを指定します。
* @default 1
* @type number
*
* @param seName
* @text サウンドエフェクト
* @desc SEを指定します。
* @default Shot2
* @type file
* @dir audio/se/
*
* @param animeName
* @text アニメーション
* @desc アニメーションを選択します。※アニメを表示しないときは「なし」を選択。
* @type file
* @dir img/animations/
*
* @param pictName
* @text 画像の名前
* @desc 表示する画像の名前を指定します。例えば Ghost など。※画像を表示しない場合は空白にしてください。
* @type file
*
* @param pictX
* @text 画像Ｘ座標
* @desc 画像のＸ座標を指定します。デフォルト値は画面中央となります。数字を小さくするほど左に行きます。
* @default 408
* @type number 
*
* @param pictY
* @text 画像Ｙ座標
* @desc 画像のＹ座標を指定します。デフォルト値は画面中央よりもやや上です。数字を小さくするほど上に行きます。
* @default 212
* @type number 
*
* @param pictAnchorX
* @text 画像内原点Ｘ
* @desc 画像内原点Ｘを指定します。0 なら左。0.5 なら中央。1 なら右。画像を画面中央に表示するなら 0.5 にしてください。
* @type select
* @option 0
* @value 0
* @option 0.5
* @value 0.5
* @option 1
* @value 1
* @default 0.5
*
* @param pictAnchorY
* @text 画像内原点Ｙ
* @desc 画像内原点Ｙを指定します。0 なら上。0.5 なら中央。1 なら下。画像を画面中央に表示するなら 0.5 にしてください。
* @type select
* @option 0
* @value 0
* @option 0.5
* @value 0.5
* @option 1
* @value 1
* @default 0.5
*
* @param pictScaleX
* @text 画像スケールＸ
* @desc 画像のスケールＸを指定します。100 なら 100% スケール。50 なら 50% スケール。200 なら 200% スケール。
* @default 100
* @type number 
* 
* @param pictScaleY
* @text 画像スケールＹ
* @desc 画像のスケールＹを指定します。100 なら 100% スケール。50 なら 50% スケール。200 なら 200% スケール。
* @default 100
* @type number 
*
* @help エンカウント時にフキダシ表示、ＳＥ演奏などを行います。
*
* 使い方：
* 右のパラメータを任意の値に変更します。
* ※デフォルトでも機能します。
*
* ・画像を左に寄せたいときは X 座標を小さい値にします。
* そして画像内原点 X を 1 にします（右に設定） 
* ・画像を上げたいときは、Y 座標を小さい値にして、
* 画像内原点 Y を 1 にします（足元に設定）
*
* ※プラグインコマンドはありません。
*
* 2019/10/24追記:こちらのプラグインはパブリックドメインです。
*
* 2024/01/14 バルーンとアニメーション呼び出しAPIのMZ対応修正 @n2naokun
*
*/

(function () {
	'use strict';
	var pluginName = "BattleEncountWait",
		param = PluginManager.parameters(pluginName),
		waitCount = +param['waitCount'] || 60,
		balloonId = +param['balloonId'] || 1,
		seName = param['seName'],
		animeName = param['animeName'],
		pictName = param['pictName'],
		pictX = +param['pictX'] || 408,
		pictY = +param['pictY'] || 212,
		pictAnchorX = +param['pictAnchorX'] || 0.5,
		pictAnchorY = +param['pictAnchorY'] || 0.5,
		pictScaleX = +param['pictScaleX'] || 100,
		pictScaleY = +param['pictScaleY'] || 100;
	console.log();
	var startBalloonSE = function () {
		// SE 演奏
		if (this._JMseName) { AudioManager.playSe({ "name": this._JMseName, "volume": 90, "pitch": 100, "pan": 0 }); }
		// 2024/01/14 バルーンとアニメーション呼び出しAPIのMZ対応修正 @n2naokun
		// フキダシ表示
		if (this._JMballoonId) {
			if (Utils.RPGMAKER_NAME !== 'MZ') {
				$gamePlayer.requestBalloon(this._JMballoonId);
			} else {
				$gameTemp.requestBalloon($gamePlayer, this._JMballoonId);
			}
		}
		// アニメーション
		if (this._JManimeId) {
			if (Utils.RPGMAKER_NAME !== 'MZ') {
				$gamePlayer.requestAnimation(this._JManimeId);
			} else {
				$gameTemp.requestAnimation([$gamePlayer], this._JManimeId);
			}
		}
		// 2024/01/14 ここまで
		// ピクチャ表示
		if (this._JMpictSprite) { SceneManager._scene.addChild(this._JMpictSprite); }
	};

	var addProps = function () {
		this._JMwaitEncMode = false;
		this._JMexecuteMove = $gamePlayer.executeMove;
		this._JMwaitEncCount = waitCount;
		this._JMballoonId = balloonId;
		this._JMseName = seName;
		var anime = $dataAnimations.find(function (x) {
			if (x !== null && x.animation1Name === animeName) {
				return x;
			}
		});
		this._JManimeId = (anime) ? anime.id : 0;
		this._JMpictName = pictName;
		this._JMpict;
		this._JMpictSprite;
		if (pictName.split("/").length === 3) {
			this._JMpict = ImageManager.loadBitmap("", this._JMpictName);
			this._JMpictSprite = new Sprite(this._JMpict);
			this._JMpictSprite.x = this._JMpictX = pictX;
			this._JMpictSprite.y = this._JMpictY = pictY;
			this._JMpictSprite.anchor.x = this._JMpictAnchorX = pictAnchorX;
			this._JMpictSprite.anchor.y = this._JMpictAnchorY = pictAnchorY;
			this._JMpictSprite.scale.x = this._JMpictScaleX = pictScaleX * 0.01;
			this._JMpictSprite.scale.y = this._JMpictScaleY = pictScaleY * 0.01;
		}
	};

	// ランダムエンカウント用
	var _Scene_Map_initialize = Scene_Map.prototype.initialize;
	Scene_Map.prototype.initialize = function () {
		_Scene_Map_initialize.call(this);
		addProps.call(this);
	};
	// 再定義（上書き不可）
	Object.defineProperty(Scene_Map.prototype, 'updateEncounter', {
		value: function () {
			if (this._JMwaitEncMode) { return; }
			if ($gamePlayer.executeEncounter()) {
				$gamePlayer.executeMove = function () { };
				this._JMwaitEncMode = true;
				startBalloonSE.call(this);
				// 指定の時間停止（update()で止めれば良かったけど）
				var t = requestAnimationFrame(function loop(waitCount) {
					if (waitCount > 0) {
						waitCount--;
						var q = requestAnimationFrame(loop.bind(this, waitCount));
					} else {
						cancelAnimationFrame(t);
						cancelAnimationFrame(q);
						this._JMwaitEncMode = false;
						$gamePlayer.executeMove = this._JMexecuteMove;
						SceneManager.push(Scene_Battle);
					}
				}.bind(this, this._JMwaitEncCount));
			}
		}
	});

	// シンボルエンカウント用
	var _Game_Interpreter_setup = Game_Interpreter.prototype.setup;
	Game_Interpreter.prototype.setup = function (list, eventId) {
		_Game_Interpreter_setup.apply(this, arguments);
		this._JMbattleflg = false;
		addProps.call(this);
	};
	var _Game_Interpreter_update = Game_Interpreter.prototype.update;
	Game_Interpreter.prototype.update = function () {
		if (this.isRunning() && !this._JMbattleflg) {
			if (this.currentCommand().code === 301) {
				this._waitCount = this._JMwaitEncCount;
				this._JMbattleflg = true;
				startBalloonSE.call(this);
			}
		}
		_Game_Interpreter_update.call(this);
	};

})();