//=============================================================================
// メニュー画面変更プラグイン
// EXC_DivideEquipCustom.js
// ----------------------------------------------------------------------------
// Copyright (c) 2024 IdiotException
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2024-12-31
//=============================================================================
/*:
 * @target MZ
 * @plugindesc KRD_MZ_DivideEquipの画面のデザインを変更します
 * @author IdiotException
 * @url 
 * 
 * @help KRD_MZ_DivideEquipの画面のデザインを変更、スキルによる二刀流の可不可変化に対応します
 * 以下、前提プラグイン
 *     KRD_MZ_DivideEquip
 *     EquipScene_Extension
 */

const EXCDivideEquipCustom = document.currentScript.src.match(/^.*\/(.+)\.js$/)[1];

(function() {
	"use strict";
	//--------------------------------------------------
	// 定数設定
	//--------------------------------------------------

	// 画像素材の名前
	const PICT_PATH				= "img/menuC/";		// 画像ファイル格納フォルダ
	const PICT_WEAPON_BACK_NAME	= "equip_bg";		// メニューの文字背景バー等のファイル名
	const PICT_SKILL_BACK_NAME	= "ability_bg";		// メニューの文字背景バー等のファイル名

	// ***** 武器・防具等装備側設定値 ******
	const EQUIP_SLOT_SPACE			= 20			// 装備スロットのアイテム名とアイコン間のスペース幅
	const EQUIO_STATUS_ARROW_WIDTH	= 60			// 装備・スキル画面のステータス表示の矢印部分の幅
	const EQUIO_STATUS_PARAM_WIDTH	= 70			// 装備・スキル画面のステータス表示の数値部分の幅

	// 装備ウィンドウ設定
	const WEAPON_SLOT_WINDOW = {
		x				: 20,
		y				: 120,
		height			: 330,
		width			: 430
	} ;

	// ステータスウィンドウ設定
	const WEAPON_STATUS_WINDOW = {
		x				: 20,
		y				: 480,
		height			: 320,
		width			: 430
	} ;

	// コマンドウィンドウ設定
	const WEAPON_COMMAND_WINDOW = {
		x				: 470,
		y				: 115,
		height			: 70,
		width			: 630
	} ;

	// アイテムウィンドウ設定
	const WEAPON_ITEM_WINDOW = {
		x				: 470,
		y				: 185,
		height			: 615,
		width			: 780
	} ;

	// ヘルプウィンドウ設定
	const WEAPON_HELP_WINDOW = {
		x				: 20,
		y				: 825,
		height			: 100,
		width			: 1230
	} ;

	// ***** スキル側設定値 ******
	// 装備ウィンドウ設定
	const SKILL_SLOT_WINDOW = {
		x				: 20,
		y				: 130,
		height			: 160,
		width			: 430
	} ;

	// ステータスウィンドウ設定
	const SKILL_STATUS_WINDOW = {
		x				: 20,
		y				: 320,
		height			: 480,
		width			: 430
	} ;

	// アイテムウィンドウ設定
	const SKILL_ITEM_WINDOW = {
		x				: 470,
		y				: 130,
		height			: 670,
		width			: 780
	} ;

	// ヘルプウィンドウ設定
	const SKILL_HELP_WINDOW = {
		x				: 20,
		y				: 825,
		height			: 100,
		width			: 1230
	} ;

	//--------------------------------------------------
	// Scene_EquipDivide のオーバーライド
	//--------------------------------------------------
	Scene_EquipDivide.prototype.needsPageButtons = function() {
		return false;
	};

	//--------------------------------------------------
	// Scene_EquipWeapon のオーバーライド
	//--------------------------------------------------
	// 各ウィンドウの背景を削除
	const _EXC_Scene_EquipWeapon_create = Scene_EquipWeapon.prototype.create;
	Scene_EquipWeapon.prototype.create = function() {
		_EXC_Scene_EquipWeapon_create.call(this);
		this._statusWindow.opacity = 0;
		this._commandWindow.opacity = 0;
		this._slotWindow.opacity = 0;
		this._itemWindow.opacity = 0;
	};

	// ウィンドウの背景画像呼び出し
	const _EXC_Scene_EquipWeapon_createBackground = Scene_EquipWeapon.prototype.createBackground;
	Scene_EquipWeapon.prototype.createBackground = function() {
		_EXC_Scene_EquipWeapon_createBackground.call(this);

		// プラグイン用画像フォルダを設定
		let imgFolder;
		imgFolder = PICT_PATH;

		// ウィンドウ背景画像呼び出し
		let tmpBmp = ImageManager.loadBitmap(imgFolder, PICT_WEAPON_BACK_NAME, 0, false);
		let tmpSprite = new Sprite(tmpBmp);
		this.addChild(tmpSprite);
	}

	// アクター切り替え機能削除
	const _EXC_Scene_EquipWeapon_createCommandWindow = Scene_EquipWeapon.prototype.createCommandWindow;
	Scene_EquipWeapon.prototype.createCommandWindow = function() {
		_EXC_Scene_EquipWeapon_createCommandWindow.call(this);
		delete this._commandWindow._handlers["pageup"];
		delete this._commandWindow._handlers["pagedown"];
	};

	// ステータスウィンドウ設定
	Scene_EquipWeapon.prototype.statusWindowRect = function() {
		return new Rectangle(WEAPON_STATUS_WINDOW.x, WEAPON_STATUS_WINDOW.y, WEAPON_STATUS_WINDOW.width, WEAPON_STATUS_WINDOW.height);
	};

	// コマンドウィンドウ設定
	Scene_EquipWeapon.prototype.commandWindowRect = function() {
		return new Rectangle(WEAPON_COMMAND_WINDOW.x, WEAPON_COMMAND_WINDOW.y, WEAPON_COMMAND_WINDOW.width, WEAPON_COMMAND_WINDOW.height);
	};

	// 装備ウィンドウ設定
	Scene_EquipWeapon.prototype.slotWindowRect = function() {
		return new Rectangle(WEAPON_SLOT_WINDOW.x, WEAPON_SLOT_WINDOW.y, WEAPON_SLOT_WINDOW.width, WEAPON_SLOT_WINDOW.height);
	};

	// アイテムウィンドウ設定
	Scene_EquipWeapon.prototype.itemWindowRect = function() {
		return new Rectangle(WEAPON_ITEM_WINDOW.x, WEAPON_ITEM_WINDOW.y, WEAPON_ITEM_WINDOW.width, WEAPON_ITEM_WINDOW.height);
	};
	
	// ヘルプウィンドウ設定
	Scene_EquipWeapon.prototype.helpWindowRect = function() {
		return new Rectangle(WEAPON_HELP_WINDOW.x, WEAPON_HELP_WINDOW.y, WEAPON_HELP_WINDOW.width, WEAPON_HELP_WINDOW.height);
	};

	//--------------------------------------------------
	// Scene_EquipSkill のオーバーライド
	//--------------------------------------------------
	// 各ウィンドウの背景を削除
	const _EXC_Scene_EquipSkill_create = Scene_EquipSkill.prototype.create;
	Scene_EquipSkill.prototype.create = function() {
		_EXC_Scene_EquipSkill_create.call(this);
		this._statusWindow.opacity = 0;
		this._slotWindow.opacity = 0;
		this._itemWindow.opacity = 0;
	};

	// ウィンドウの背景画像呼び出し
	const _EXC_Scene_EquipSkill_createBackground = Scene_EquipSkill.prototype.createBackground;
	Scene_EquipSkill.prototype.createBackground = function() {
		_EXC_Scene_EquipSkill_createBackground.call(this);

		// プラグイン用画像フォルダを設定
		let imgFolder;
		imgFolder = PICT_PATH;

		// ウィンドウ背景画像呼び出し
		let tmpBmp = ImageManager.loadBitmap(imgFolder, PICT_SKILL_BACK_NAME, 0, false);
		let tmpSprite = new Sprite(tmpBmp);
		this.addChild(tmpSprite);
	}

	// ステータスウィンドウ設定
	Scene_EquipSkill.prototype.statusWindowRect = function() {
		return new Rectangle(SKILL_STATUS_WINDOW.x, SKILL_STATUS_WINDOW.y, SKILL_STATUS_WINDOW.width, SKILL_STATUS_WINDOW.height);
	};

	// 装備ウィンドウ設定
	Scene_EquipSkill.prototype.slotWindowRect = function() {
		return new Rectangle(SKILL_SLOT_WINDOW.x, SKILL_SLOT_WINDOW.y, SKILL_SLOT_WINDOW.width, SKILL_SLOT_WINDOW.height);
	};

	// アイテムウィンドウ設定
	Scene_EquipSkill.prototype.itemWindowRect = function() {
		return new Rectangle(SKILL_ITEM_WINDOW.x, SKILL_ITEM_WINDOW.y, SKILL_ITEM_WINDOW.width, SKILL_ITEM_WINDOW.height);
	};
	
	// ヘルプウィンドウ設定
	Scene_EquipSkill.prototype.helpWindowRect = function() {
		return new Rectangle(SKILL_HELP_WINDOW.x, SKILL_HELP_WINDOW.y, SKILL_HELP_WINDOW.width, SKILL_HELP_WINDOW.height);
	};

	// EquipScene_Extensionのコード拝借(コマンドウィンドウ表示を常に非表示に)
	const _EXC_Scene_EquipSkill_createSlotWindow = Scene_EquipSkill.prototype.createSlotWindow;
	Scene_EquipSkill.prototype.createSlotWindow = function() {
		_EXC_Scene_EquipSkill_createSlotWindow.call(this);
		// pageup,pagedownは不要なため削除
		this._slotWindow.setHandler("cancel", this.popScene.bind(this));
	};
	
	// EquipScene_Extensionのコード拝借(layoutModeは!=0として、コマンドウィンドウ表示を常に非表示に)
	const _EXC_Scene_EquipSkill_start = Scene_MenuBase.prototype.start;
	Scene_EquipSkill.prototype.start = function() {
		_EXC_Scene_EquipSkill_start.call(this);
		this._itemWindow.show();
		this._slotWindow.select(0);
		this._slotWindow.activate();
	};
	
	// EquipScene_Extensionのコード拝借(コマンドウィンドウ表示を常に非表示に)
	Scene_EquipSkill.prototype.createCommandWindow = function() {
	};
	
	// EquipScene_Extensionのコード拝借(コマンドウィンドウ表示を常に非表示に)
	const _EXC_Scene_EquipSkill_commandWindowRect = Scene_EquipSkill.prototype.commandWindowRect;
	Scene_EquipSkill.prototype.commandWindowRect = function() {
		const rect = _EXC_Scene_EquipSkill_commandWindowRect.call(this);
		rect.height = 0;
		return rect;
	};

	//--------------------------------------------------
	// Window_EquipSlot のオーバーライド
	//--------------------------------------------------
	// タイトル幅を調整、タイトルとアイコン間にスペース挿入(一か所修正のために全コピー・・・)
	Window_EquipSlot.prototype.drawItem = function(index) {
		if (this._actor) {
			const slotName = this.actorSlotName(this._actor, index);
			const item = this.itemAt(index);
			const slotNameWidth = this.slotNameWidth();
			const rect = this.itemLineRect(index);
			const itemWidth = rect.width - slotNameWidth;
			this.changeTextColor(ColorManager.systemColor());
			this.changePaintOpacity(this.isEnabled(index));
			this.drawText(slotName, rect.x, rect.y, slotNameWidth - EQUIP_SLOT_SPACE, rect.height);
			this.drawItemName(item, rect.x + slotNameWidth, rect.y, itemWidth);
			this.changePaintOpacity(true);
		}
	};

	//--------------------------------------------------
	// Window_EquipSlot のオーバーライド
	//--------------------------------------------------
	// 顔や名前の表示を削除
	Window_EquipStatus.prototype.refresh = function() {
		this.contents.clear();
		if (this._actor) {
			this.drawAllParams();
		}
	};

	// 表示ステータスを追加
	Window_EquipStatus.prototype.drawAllParams = function() {
		for (let i = 0; i < 8; i++) {
			const x = this.itemPadding();
			const y = this.paramY(i);
			this.drawItem(x, y, i);
		}
	};

	// 顔表示を削除するため縦位置を修正
	Window_EquipStatus.prototype.paramY = function(index) {
		return Math.floor(this.lineHeight() * index);
	};

	// 矢印表示部の幅調整
	Window_EquipStatus.prototype.rightArrowWidth = function() {
		return EQUIO_STATUS_ARROW_WIDTH;
	};
	
	// ステータス数値の幅調整
	Window_EquipStatus.prototype.paramWidth = function() {
		return EQUIO_STATUS_PARAM_WIDTH;
	};
	
	//--------------------------------------------------
	// Window_ItemList のオーバーライド
	//--------------------------------------------------
	// スキル装備画面では数量を表示しない
	const _EXC_Window_EquipItem_needsNumber = Window_EquipItem.prototype.needsNumber;
	Window_EquipItem.prototype.needsNumber = function() {
		if(this.parent && this.parent.parent && this.parent.parent.constructor.name === "Scene_EquipSkill"){
			return false;
		}
		return _EXC_Window_EquipItem_needsNumber.call(this);
	};

	// 装備選択ウィンドウでメニューのアイテム画面に倣って":"を削除
	Window_EquipItem.prototype.drawItemNumber = function(item, x, y, width) {
		if (this.needsNumber()) {
			//this.drawText(":", x, y, width - this.textWidth("00"), "right");
			this.drawText($gameParty.numItems(item), x, y, width, "right");
		}
	}

	// 装備可能かどうかのチェックを削除
	Window_EquipItem.prototype.includes = function(item) {
		if (item === null) {
			return true;
		}
		return (
			item.etypeId === this.etypeId()
		);
	};

	// 装備不可も表示するようにしたため不活性チェックをするよう追加
	Window_EquipItem.prototype.isCurrentItemEnabled = function(){
		return this.isEnabled(this._data[this.index()]);
	}

	// 装備不可も表示するようにしたため不活性チェックをするよう追加
	Window_EquipItem.prototype.isEnabled = function(item){
		// null(外す)であるか、アクターが装備可能である場合true
		return item === null || (this._actor && this._actor.canEquip(item));
	}

	// リストの並び替え
	const _EXC_Window_EquipItem_makeItemList = Window_EquipItem.prototype.makeItemList;
	Window_EquipItem.prototype.makeItemList = function() {
		if(this.parent && this.parent.parent && this.parent.parent.constructor.name === "Scene_EquipSkill"){
			// スキル装備画面では並び替え不要
			_EXC_Window_EquipItem_makeItemList.call(this);
		} else {
			this._data = [];
			const tmpItems = $gameParty.allItems().filter(item => this.includes(item));

			// "外す"の挿入
			if (this.includes(null)) {
				this._data.push(null);
			}

			// 装備可能装備をリストに追加
			this._data = this._data.concat(tmpItems.filter(item => this.isEnabled(item)));

			// 装備不可装備をリストに追加
			this._data = this._data.concat(tmpItems.filter(item => !this.isEnabled(item)));

		}
	};

})();

