//=============================================================================
// 戦闘画面エネミー名属性アイコン追加プラグイン
// EXC_EnemyNameAttrIcon.js
// ----------------------------------------------------------------------------
// Copyright (c) 2024 IdiotException
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2024-04-01
//=============================================================================
/*:
 * @target MZ
 * @plugindesc 戦闘画面でエネミーの名前に属性耐性アイコン表示を追加します
 * @author IdiotException
 * @url 
 * 
 * @help 戦闘画面でエネミーの名前に属性耐性アイコン表示を追加します
 */

const EXCEnemyNameAttrIcon = document.currentScript.src.match(/^.*\/(.+)\.js$/)[1];

(function() {
	"use strict";
	//--------------------------------------------------
	// 定数設定
	//--------------------------------------------------
	const PICT_PATH			= "img/battleCust/";	// 画像ファイル格納フォルダ
	const PICT_WEAK_TITLE	= "icon_weak";			// 弱点の見出し画像ファイル名
	const PICT_RESIST_TITLE	= "icon_resist";		// 抵抗の見出し画像ファイル名
	const PICT_DIFF_DIV		= "weak_line";		// 抵抗の見出し画像ファイル名
	const TITLE_ICON_HEIGHT	= 32;					// 弱点・抵抗アイコン高さ
	const TITLE_ICON_WIDTH	= 48;					// 弱点・抵抗アイコン幅
	const RES_ICON_POS_MIN	= 200;					// 耐性アイコン最小位置

	// アイコンIDと属性と倍率の対応表　[属性番号][倍率（昇順）]の２次元
	const IconsId = [[313, 297, 281, 265, 249],
						[315, 299, 283, 267, 251],
						[304, 288, 272, 256, 240],
						[305, 289, 273, 257, 241],
						[308, 292, 276, 260, 244],
						[307, 291, 275, 259, 243],
						[310, 294, 278, 262, 246],
						[],
						[306, 290, 274, 258, 242],
						[309, 293, 277, 261, 245],
						[311, 295, 279, 263, 247],
						[312, 296, 280, 264, 248],
						[],
						[],
						[316, 300, 284, 268, 252],
						[],
						[314, 298, 282, 266, 250]
					];
	// 属性の表示優先順位
	const AttrSort = [3, 4, 9, 5, 6, 7, 10, 11, 12, 17, 1, 15, 2, 8, 13, 14, 16];

	// ウィンドウ設定
	const Attr_Icon = {
		left_margin		: 400,
		same_margin		: 2,
		diff_margin		: 9,
		res_margin		: 12
	} ;


	// 耐性倍率と対応表のインデックス対応
	const Value_Icon_Index = {
		x00	: 0,
		x05	: 1,
		x15	: 2,
		x20	: 3,
		x30	: 4
	}

	// 画像素材保持用
	let _bmpWeakTitle, _bmpResistTitle, _bmpDiffDiv;

	//--------------------------------------------------
	// Window_BattleEnemy のオーバーライド
	//--------------------------------------------------
	// イニシャライズの時に画像読み込み
	const _EXC_Window_BattleEnemy_initialize = Window_BattleEnemy.prototype.initialize;
	Window_BattleEnemy.prototype.initialize = function(rect) {
		_EXC_Window_BattleEnemy_initialize.call(this, ...arguments)

		// プラグイン用画像フォルダを設定
		let imgFolder;
		imgFolder = PICT_PATH;

		// 各見出し画像を読み込み
		_bmpWeakTitle = ImageManager.loadBitmap(imgFolder, PICT_WEAK_TITLE);
		_bmpResistTitle = ImageManager.loadBitmap(imgFolder, PICT_RESIST_TITLE);
		_bmpDiffDiv = ImageManager.loadBitmap(imgFolder, PICT_DIFF_DIV);

	}

	// 名前表示部にアイコン表示を追加
	const _EXC_Window_BattleEnemy_drawItem = Window_BattleEnemy.prototype.drawItem;
	Window_BattleEnemy.prototype.drawItem = function(index) {
		_EXC_Window_BattleEnemy_drawItem.call(this, ...arguments);
		
		const rect = this.itemLineRect(index);
		const defaultX = rect.x + Attr_Icon.left_margin;	// xの初期値を保持
		let iconX = defaultX;								// x位置保持用変数
		const iconY = rect.y + Math.floor((rect.height - ImageManager.iconHeight) / 2);
		// 敵データから耐性に関するもの(Code:11)のみ抽出、倍率の降順と属性の表示優先順位昇順でソート
		const tmpAttr = $dataEnemies[this._enemies[index]._enemyId].traits.filter(el => el.code == 11)
			.sort((first, second) => (first.value != second.value? second.value - first.value : 
					AttrSort.findIndex(el => el == first.dataId) - AttrSort.findIndex(el => el == second.dataId)));
		let befMag = 1.0;
		for(let i = 0; i < tmpAttr.length; i++){
			// 対象の倍率に対応するアイコンの決定
			const tmpValue = tmpAttr[i].value;
			const targetAttr = IconsId[tmpAttr[i].dataId - 1];
			if(tmpValue == 1.0 || !targetAttr || targetAttr.length == 0){
				// 等倍,アイコンなしはスキップ
				continue;
			} else if(befMag == tmpValue){
				iconX += ImageManager.iconWidth + Attr_Icon.same_margin; 	// 同倍率の場合の横位置再計算
			} else {

				iconX += ImageManager.iconWidth;
				if(befMag == 1.0 && tmpValue > 1.0){
					// weak見出し表示
					this.contents.blt(_bmpWeakTitle, 0, 0, TITLE_ICON_WIDTH, TITLE_ICON_HEIGHT, iconX, iconY);
					iconX += TITLE_ICON_WIDTH + Attr_Icon.diff_margin; ;
				} else if(befMag >= 1.0 && tmpValue < 1.0){
					if(befMag != 1.0){
						// resistから始まっている場合を考慮
						iconX += Attr_Icon.res_margin;
						if(iconX < defaultX + RES_ICON_POS_MIN){
							// ある程度位置を調整
							iconX = defaultX + RES_ICON_POS_MIN;
						}
					}
					// resist見出し表示	
					this.contents.blt(_bmpResistTitle, 0, 0, TITLE_ICON_WIDTH, TITLE_ICON_HEIGHT, iconX, iconY);
					iconX += TITLE_ICON_WIDTH + Attr_Icon.diff_margin; ;
				} else {
					const tmpCenter =  Math.floor(Attr_Icon.diff_margin / 2);
					this.contents.blt(_bmpDiffDiv, 0, 0, TITLE_ICON_WIDTH, TITLE_ICON_HEIGHT, iconX + tmpCenter, iconY);
					iconX += Attr_Icon.diff_margin;							// 異倍率の場合の横位置再計算
				}
				befMag = tmpValue;											// 現在値を更新
			}
			let tmpIndex = -1;
			if(tmpValue < 0.5){
				// 0.5未満
				tmpIndex = Value_Icon_Index.x00;
			} else if(tmpValue < 1.0){
				// 0.5以上、1.0未満
				tmpIndex = Value_Icon_Index.x05;
			} else if(tmpValue < 1.5){
				// 1.0以上、1.5未満
				// 対象なしのため表示対象外
			} else if(tmpValue < 2.0){
				// 1.5以上、2.0未満
				tmpIndex = Value_Icon_Index.x15;
			} else if(tmpValue < 3.0){
				// 2.0以上、3.0未満
				tmpIndex = Value_Icon_Index.x20;
			} else {
				// 3以上
				tmpIndex = Value_Icon_Index.x30;
			}
			if(tmpIndex < 0){
				// 対象外の場合は表示スキップ
				continue;
			}
			this.drawIcon(targetAttr[tmpIndex], iconX, iconY);
		}
	};

	// アイコン表示のために表示域を確保
	Window_BattleEnemy.prototype.maxCols = function() {
		return 1;
	};
})();

