//=============================================================================
// メニュー画面変更プラグイン
// EXC_OptionsGameEndCustom.js
// ----------------------------------------------------------------------------
// Copyright (c) 2024 IdiotException
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2024-04-01
//=============================================================================
/*:
 * @target MZ
 * @plugindesc オプション画面とゲーム終了のデザインを変更します
 * @author IdiotException
 * @url 
 * 
 * @help オプション画面とゲーム終了のデザインを変更します
 */

const EXCOptionsGameEndCustom = document.currentScript.src.match(/^.*\/(.+)\.js$/)[1];

(function() {
	"use strict";
	//--------------------------------------------------
	// 定数設定
	//--------------------------------------------------
	const PARTY_INDEX = 0;			// 対象アクターのパーティ上でのインデックス

	// 画像素材の名前
	const PICT_PATH					= "img/menuC/";		// 画像ファイル格納フォルダ
	const PICT_OPTIONS_BACK_NAME	= "option_bg";		// 装備のウィンドウ背景のファイル名
	const PICT_GAMEEND_BACK_NAME	= "gameend_bg";		// スキルのウィンドウ背景のファイル名
	const PICT_CHARACTER_NAME		= "menu_character";	// キャラクーの画像ファイル名（ジョブ番号前まで
	const PICT_CHARACTER_TRAIL		= "a";				// メニュー用キャラクター画像の末尾（ジョブ番号以降

	// ***** オプション画面設定値 ******
	// オプションウィンドウ設定
	const OPTIONS_WINDOW = {
		x				: 20,
		y				: 120,
		height			: 820,
		width			: 525,
		status_width	: 220
	} ;



	//--------------------------------------------------
	// Scene_Options のオーバーライド
	//--------------------------------------------------
	// ウィンドウの背景画像呼び出し
	const _EXC_Scene_Options_createBackground = Scene_Options.prototype.createBackground;
	Scene_Options.prototype.createBackground = function() {
		_EXC_Scene_Options_createBackground.call(this);

		// プラグイン用画像フォルダを設定
		let imgFolder;
		imgFolder = PICT_PATH;

		// キャラクター画像の読み込み
		let tmpImgName, tmpBmp, tmpSprite;
		if($gameParty && $gameParty.members() && $gameParty.members()[PARTY_INDEX]){
			tmpImgName = PICT_CHARACTER_NAME + ('0' + $gameParty.members()[PARTY_INDEX]._classId).slice(-2) + PICT_CHARACTER_TRAIL;
		} else {
			tmpImgName = PICT_CHARACTER_NAME + "01" + PICT_CHARACTER_TRAIL;
		}
		tmpBmp = ImageManager.loadBitmap(imgFolder, tmpImgName, 0, false);
		tmpSprite = new Sprite(tmpBmp);
		this.addChild(tmpSprite);

		// ウィンドウ背景画像呼び出し
		tmpBmp = ImageManager.loadBitmap(imgFolder, PICT_OPTIONS_BACK_NAME, 0, false);
		tmpSprite = new Sprite(tmpBmp);
		this.addChild(tmpSprite);
	}

	// ウィンドウ枠、背景削除
	const _EXC_Scene_Options_createOptionsWindow = Scene_Options.prototype.createOptionsWindow;
	Scene_Options.prototype.createOptionsWindow = function() {
		_EXC_Scene_Options_createOptionsWindow.call(this);
		this._optionsWindow.opacity = 0;
	}

	// ウィンドウのサイズ、表示位置変更
	Scene_Options.prototype.optionsWindowRect = function() {
		return new Rectangle(OPTIONS_WINDOW.x, OPTIONS_WINDOW.y, OPTIONS_WINDOW.width, OPTIONS_WINDOW.height);
	};

	//--------------------------------------------------
	// Window_Options のオーバーライド
	//--------------------------------------------------
	Window_Options.prototype.statusWidth = function() {
		return OPTIONS_WINDOW.status_width;
	};


	//--------------------------------------------------
	// Scene_GameEnd のオーバーライド
	//--------------------------------------------------
	const _EXC_Scene_GameEnd_createBackground = Scene_GameEnd.prototype.createBackground;
	Scene_GameEnd.prototype.createBackground = function() {
		_EXC_Scene_GameEnd_createBackground.call(this);

		// プラグイン用画像フォルダを設定
		let imgFolder;
		imgFolder = PICT_PATH;

		// ウィンドウ背景画像呼び出し
		let tmpBmp = ImageManager.loadBitmap(imgFolder, PICT_GAMEEND_BACK_NAME, 0, false);
		let tmpSprite = new Sprite(tmpBmp);
		this.addChild(tmpSprite);
	}

	// ウィンドウ枠、背景削除
	const _EXC_Scene_GameEnd_createCommandWindow = Scene_GameEnd.prototype.createCommandWindow;
	Scene_GameEnd.prototype.createCommandWindow = function() {
		_EXC_Scene_GameEnd_createCommandWindow.call(this);
		this._commandWindow.opacity = 0;
	}
})();

