//=============================================================================
// 戦闘画面ウィンドウ情報変更プラグイン
// EXC_SceneBattleCustom.js
// ----------------------------------------------------------------------------
// Copyright (c) 2024 IdiotException
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2024-04-24
//=============================================================================
/*:
 * @target MZ
 * @plugindesc 戦闘画面のウィンドウ等の設定を変更します☆
 * @author IdiotException
 * @url 
 * 
 * @help 戦闘画面のウィンドウ等の設定を変更します☆☆☆
 * 
 * @param repeatID
 * @text 繰り返し変数
 * @desc スキルエフェクト繰り返し表示回数を保存している変数
 * @type variable
 * @default 6
 */

const EXCSceneBattleCustom = document.currentScript.src.match(/^.*\/(.+)\.js$/)[1];

(function() {
	"use strict";
	//--------------------------------------------------
	// 定数設定
	//--------------------------------------------------
	const TAG_REPEAT_WAIT = "EXC_RepeatWait";

	const COMMAND_WINDOW_LINES	= 7;	// コマンドウィンドウの表示行数
	const SKILL_WINDOW_LINES	= 12;	// スキル・アイテムウィンドウの表示行数
	const WINDOW_HELP_PAD_LEFT	= 16;

	// ログウィンドウ関連設定
	const Log_Window = {
		x			: 0,
		y			: 386,
		width		: 500,
		maxLines	: 9,
		font_size	: 16,
		padding		: 4
	} ;

	//--------------------------------------------------
	// 変数設定
	//--------------------------------------------------	
	// ログウィンドウを別なところで使用するため
	let _windowLog;

	// アニメーション重ね掛けのための保持用
	let _curSubject, _curActionItem, _curTargets, _animeWait, _animeRepeat;

	//パラメータ受取処理
	let parameters = PluginManager.parameters(ExcSlotMachinePluginName);
	let _repeatId				= Number(parameters['repeatID'] || 6);

	//--------------------------------------------------
	// ツクール側変数取得宣言
	//--------------------------------------------------
	// コイン
	function Exc_getRepeatCount() {
		return $gameVariables.value(_repeatId);
	}

	//--------------------------------------------------
	// Scene_Battle のオーバーライド
	//--------------------------------------------------
	// コマンドウィンドウを左に配置
	Scene_Battle.prototype.isRightInputMode = function() {
		return false;
	};
	
	const _EXC_Scene_Battle_createAllWindows = Scene_Battle.prototype.createAllWindows;
	Scene_Battle.prototype.createAllWindows = function() {
		_EXC_Scene_Battle_createAllWindows.call(this);

		// キャラクターステータスの背景除去
		this._statusWindow.opacity = 0;

		// ログウィンドウの保持
		_windowLog = this._logWindow;

		// ヘルプウィンドウの高さ変更
		this._helpWindow.height = this.helpAreaHeightLow();
	};

	// ログウィンドウの位置、サイズ再設定
	Scene_Battle.prototype.logWindowRect = function() {
		const wx = Log_Window.x;
		const wy = Log_Window.y;
		const ww = Log_Window.width;
		const wh = this.calcWindowHeight(Log_Window.maxLines, false);
		return new Rectangle(wx, wy, ww, wh);
	};

	// ステータスウィンドウのサイズ再設定
	const _EXC_Scene_Battle_statusWindowRect = Scene_Battle.prototype.statusWindowRect;
	Scene_Battle.prototype.statusWindowRect = function() {
		const rect = _EXC_Scene_Battle_statusWindowRect.call(this);

		// ヘルプウィンドウ位置移動のため下にスペース作成
		rect.height -= this.helpAreaHeightLow();

		return rect;
	};


	// ヘルプウィンドウの幅再設定
	const _EXC_Scene_Battle_helpWindowRect = Scene_Battle.prototype.helpWindowRect;
	Scene_Battle.prototype.helpWindowRect = function() {
		const rect = _EXC_Scene_Battle_helpWindowRect.call(this);

		// 幅と横位置を再設定
		rect.width = this._statusWindow.width;
		rect.x = this._statusWindow.x;
		return rect;
	};

	// スキル・アイテムウィンドウのサイズ再設定
	const _EXC_Scene_Battle_skillWindowRect = Scene_Battle.prototype.skillWindowRect;
	Scene_Battle.prototype.skillWindowRect = function() {
		const rect = _EXC_Scene_Battle_skillWindowRect.call(this);
		// 高さと縦位置を再計算
		const tmpH = this.calcWindowHeight(SKILL_WINDOW_LINES, true);
		rect.height = tmpH;
		rect.y = Graphics.boxHeight - tmpH;
		
		// ヘルプウィンドウ位置移動のため少し上に
		rect.y -= this.helpAreaHeight();


		// 幅と横位置を再設定
		rect.width = this._statusWindow.width;
		rect.x = this._statusWindow.x;

		return rect;
	};

	// ヘルプウィンドウ位置修正
	Scene_Battle.prototype.helpAreaTop = function() {
		// ステータスウィンドウの下にくっつける
		return Graphics.boxHeight - this.helpAreaHeightLow();
	};

	// ヘルプウィンドウの低い時の高さ設定（追加関数）
	Scene_Battle.prototype.helpAreaHeightLow = function() {
		return this.calcWindowHeight(1, false);
	};

	// コマンド等ウィンドウの高さ変更
	Scene_Battle.prototype.windowAreaHeight = function() {
		return this.calcWindowHeight(COMMAND_WINDOW_LINES, true);
	};

	// キャンセルボタン位置修正
	Scene_Battle.prototype.buttonAreaTop = function() {
		// ヘルプ位置移動のため、一番上に
		return 0;
	};

	// スキルウィンドウ表示時処理
	const _EXC_Scene_Battle_commandSkill = Scene_Battle.prototype.commandSkill;
	Scene_Battle.prototype.commandSkill = function() {
		_EXC_Scene_Battle_commandSkill.call(this);
		
		// スキルコマンド選択時にコマンドウィンドウ非表示になるので再表示
		this._actorCommandWindow.show();

		// ヘルプウィンドウの高さを２行に
		this._helpWindow.height = this.helpAreaHeight();
		this._helpWindow.y = Graphics.boxHeight - this._helpWindow.height;
	};

	// アイテムウィンドウ表示時処理
	const _EXC_Scene_Battle_commandItem = Scene_Battle.prototype.commandItem;
	Scene_Battle.prototype.commandItem = function() {
		_EXC_Scene_Battle_commandItem.call(this);
		
		// アイテムコマンド選択時にコマンドウィンドウ非表示になるので再表示
		this._actorCommandWindow.show();

		// ヘルプウィンドウの高さを２行に
		this._helpWindow.height = this.helpAreaHeight();
		this._helpWindow.y = Graphics.boxHeight - this._helpWindow.height;
	};

	// スキル決定時処理
	const _EXC_Scene_Battle_onSkillOk = Scene_Battle.prototype.onSkillOk;
	Scene_Battle.prototype.onSkillOk = function() {
		// 1行に戻す
		this._helpWindow.height = this.helpAreaHeightLow();
		this._helpWindow.y = Graphics.boxHeight - this._helpWindow.height;

		_EXC_Scene_Battle_onSkillOk.call(this);
	};
	
	// スキルキャンセル時処理
	const _EXC_Scene_Battle_onSkillCancel = Scene_Battle.prototype.onSkillCancel;
	Scene_Battle.prototype.onSkillCancel = function() {
		// 1行に戻す
		this._helpWindow.height = this.helpAreaHeightLow();
		this._helpWindow.y = Graphics.boxHeight - this._helpWindow.height;

		_EXC_Scene_Battle_onSkillCancel.call(this);
	};
	
	// アイテム決定時処理
	const _EXC_Scene_Battle_onItemOk = Scene_Battle.prototype.onItemOk;
	Scene_Battle.prototype.onItemOk = function() {
		// 1行に戻す
		this._helpWindow.height = this.helpAreaHeightLow();
		this._helpWindow.y = Graphics.boxHeight - this._helpWindow.height;

		_EXC_Scene_Battle_onItemOk.call(this);
	};

	// アイテムキャンセル時処理
	const _EXC_Scene_Battle_onItemCancel = Scene_Battle.prototype.onItemCancel;
	Scene_Battle.prototype.onItemCancel = function() {
		// 1行に戻す
		this._helpWindow.height = this.helpAreaHeightLow();
		this._helpWindow.y = Graphics.boxHeight - this._helpWindow.height;

		_EXC_Scene_Battle_onItemCancel.call(this);
	};
	
	// 味方選択キャンセル時、ヘルプの高さ再調整
	const _EXC_Scene_Battle_onActorCancel = Scene_Battle.prototype.onActorCancel;
	Scene_Battle.prototype.onActorCancel = function() {
		_EXC_Scene_Battle_onActorCancel.call(this);
		switch (this._actorCommandWindow.currentSymbol()) {
			case "skill":
			case "item":
				// ヘルプウィンドウの高さを２行に
				this._helpWindow.height = this.helpAreaHeight();
				this._helpWindow.y = Graphics.boxHeight - this._helpWindow.height;
				break;
		}
	};

	// 敵選択時スキル・アイテムウィンドウ非表示
	const _EXC_Scene_Battle_startEnemySelection = Scene_Battle.prototype.startEnemySelection;
	Scene_Battle.prototype.startEnemySelection = function() {
		_EXC_Scene_Battle_startEnemySelection.call(this);
		// 対象のウィンドウ非表示処理
		switch (this._actorCommandWindow.currentSymbol()) {
			case "attack":
				break;
			case "skill":
				this._skillWindow.hide();
				break;
			case "item":
				this._itemWindow.hide();
				break;
		}
	}

	// 敵選択キャンセル時、ヘルプの高さ再調整
	const _EXC_Scene_Battle_onEnemyCancel = Scene_Battle.prototype.onEnemyCancel;
	Scene_Battle.prototype.onEnemyCancel = function() {
		_EXC_Scene_Battle_onEnemyCancel.call(this);
		switch (this._actorCommandWindow.currentSymbol()) {
			case "attack":
				break;
			case "skill":
			case "item":
				// ヘルプウィンドウの高さを２行に
				this._helpWindow.height = this.helpAreaHeight();
				this._helpWindow.y = Graphics.boxHeight - this._helpWindow.height;
				break;
		}
	};

	// ログを常時表示に切り替え
	Scene_Battle.prototype.updateLogWindowVisibility = function() {
		this._logWindow.visible = true;
	};

	//--------------------------------------------------
	// Window_BattleLog のオーバーライド
	//--------------------------------------------------
	// 最大行数の設定
	Window_BattleLog.prototype.maxLines = function() {
		return Log_Window.maxLines;
	};	

	// 行高さの設定
	Window_BattleLog.prototype.itemHeight = function() {
		return Log_Window.font_size + (this.itemPadding() *2);
	};

	// 行内余白の設定
	Window_BattleLog.prototype.itemPadding = function() {
		return Log_Window.padding;
	};

	// フォントサイズの変更
	const _EXC_Window_BattleLog_resetFontSettings = Window_BattleLog.prototype.resetFontSettings;
	Window_BattleLog.prototype.resetFontSettings = function() {
		_EXC_Window_BattleLog_resetFontSettings.call(this);

		this.contents.fontSize = Log_Window.font_size;
	};

	// ログ背景をグラデーションで透過するよう調整
	Window_BattleLog.prototype.drawBackground = function() {
		const rect = this.backRect();
		const color = this.backColor();
		this.contentsBack.clear();
		this.contentsBack.paintOpacity = this.backPaintOpacity();
		this.contentsBack.gradientFillRect (rect.x, rect.y, rect.width, rect.height, color, "rgba(0, 0, 0, 0)", false);
		this.contentsBack.paintOpacity = 255;
	};

	// すべてのログを積み上げるように修正
	Window_BattleLog.prototype.clear = function() {
		//	this._lines = [];
		this._baseLineStack = [];
		this.refresh();
	};
	
	// 上限行数を超過する場合に古いログを消す
	const _EXC_Window_BattleLog_addText = Window_BattleLog.prototype.addText;
	Window_BattleLog.prototype.addText = function(text) {
		if(this._lines.length >= this.maxLines()){
			this._lines.shift();
		}
		
		_EXC_Window_BattleLog_addText.call(this, ...arguments);
	};

	// ---------------------------------------------
	// エフェクトの重ね掛けのために改修
	// 実行前に各種設定
	const _EXC_Window_BattleLog_startAction = Window_BattleLog.prototype.startAction;
	Window_BattleLog.prototype.startAction = function(subject, action, targets) {

		// 繰り返し表示のために必要なものを保持
		_curSubject = subject;
		_curTargets = targets;
		_curActionItem = action.item();

		// 繰り返し表示のために必要なものを取得
		_animeWait = Number(_curActionItem.meta[TAG_REPEAT_WAIT] || -1);
		if(_animeWait >= 0){
			_animeRepeat = Exc_getRepeatCount();
		} else {
			_animeRepeat = 0;
		}

		// 元の処理呼び出し
		_EXC_Window_BattleLog_startAction.call(this, ...arguments);
	};

	// 繰り返しの処理を追加
	const _EXC_Window_BattleLog_update = Window_BattleLog.prototype.update;
	Window_BattleLog.prototype.update = function() {
		if (_animeRepeat > 0) {
			// アニメーション繰り返し中の場合
			if(_animeWait == 0){
				// 待ち時間が無くなっている場合
				// アニメーションを呼び出し、待ち時間再設定
				this.showAnimation(_curSubject, _curTargets.clone(), _curActionItem.animationId);
				_animeWait = Number(_curActionItem.meta[TAG_REPEAT_WAIT] || -1);
				_animeRepeat --;
			}else {
				// 待ち時間を減らす
				_animeWait--;
			}

		}

		// 元の処理呼び出し
		_EXC_Window_BattleLog_update.call(this);
	};

	//--------------------------------------------------
	// Window_BattleStatus のオーバーライド
	//--------------------------------------------------
	// 各キャラの配置を調整
	const _EXC_Window_BattleStatus_itemRect = Window_BattleStatus.prototype.itemRect;
	Window_BattleStatus.prototype.itemRect = function(index) {
		const rect = _EXC_Window_BattleStatus_itemRect.call(this, ...arguments);

		switch(index){
			case 0:
				rect.x -= 35;
				break;
			case 1:
				rect.x += 5;
				break;
			case 2:
				rect.x -= 10;
				break;
			case 3:
				rect.x -= 30;
				break;
		}

		return rect;
	};

	// 名前の位置調整（名前のアウトライン調整等のため高さが変わるため
	const _EXC_Window_BattleStatus_nameY = Window_BattleStatus.prototype.nameY;
	Window_BattleStatus.prototype.nameY = function(rect) {
		return _EXC_Window_BattleStatus_nameY.call(this, ...arguments) - 8;
	};

	//--------------------------------------------------
	// Sprite_Name のオーバーライド
	//--------------------------------------------------
	// 縁取り太さ調整のために調整
	Sprite_Name.prototype.bitmapHeight = function() {
		return 34;
	};

	Sprite_Name.prototype.outlineWidth = function() {
		return 6;
	};

	Sprite_Name.prototype.redraw = function() {
		const name = this.name();
		const width = this.bitmapWidth();
		const height = this.bitmapHeight();
		this.setupFont();
		this.bitmap.clear();
		this.bitmap.drawText(name, 3, 3, width, height, "left");
	};

	//--------------------------------------------------
	// Window_Help のオーバーライド
	//--------------------------------------------------
	// 戦闘画面でのみ文頭を少しずらす
	const _EXC_Window_Help_baseTextRect = Window_Help.prototype.baseTextRect;
	Window_Help.prototype.baseTextRect = function() {
		const rect = _EXC_Window_Help_baseTextRect.call(this);

		if(this.parent && this.parent.parent && this.parent.parent.constructor.name == "Scene_Battle"){
			rect.x += WINDOW_HELP_PAD_LEFT;
			rect.width -= WINDOW_HELP_PAD_LEFT;
			rect.height += rect.height;
		}

		return rect;
	};

	//--------------------------------------------------
	// Window_BattleItem のオーバーライド
	//--------------------------------------------------
	//--------------------------------------------------
	// DarkPlasma_SkillCostExtension のオーバーライド
	// アイテム選択画面でメニューのアイテム画面に倣って":"を削除
	Window_BattleItem.prototype.drawItemNumber = function(item, x, y, width) {
		if (this.needsNumber()) {
			//this.drawText(":", x, y, width - this.textWidth("00"), "right");
			this.drawText($gameParty.numItemsForDisplay(item), x, y, width, 'right');
		}
	};

	//--------------------------------------------------
	// BattleManager のオーバーライド
	//--------------------------------------------------
	// 戦闘開始メッセージをログに出力
	BattleManager.displayStartMessages = function() {
		for (const name of $gameTroop.enemyNames()) {
			this._logWindow.addText(TextManager.emerge.format(name));
		}
		if (this._preemptive) {
			this._logWindow.addText(TextManager.preemptive.format($gameParty.name()));
		} else if (this._surprise) {
			this._logWindow.addText(TextManager.surprise.format($gameParty.name()));
		}
	};

	// 逃走成功メッセージをログに出力
	BattleManager.displayEscapeSuccessMessage = function() {
		this._logWindow.addText(TextManager.escapeStart.format($gameParty.name()));
	};
	
	// 逃走失敗メッセージをログに出力
	BattleManager.displayEscapeFailureMessage = function() {
		this._logWindow.addText(TextManager.escapeStart.format($gameParty.name()));
		this._logWindow.addText(TextManager.escapeFailure);
	};


	//--------------------------------------------------
	// Window_ActorCommand のオーバーライド
	//--------------------------------------------------
	// コマンド名を取得するための処理を追加
	Window_ActorCommand.prototype.currentName = function() {
		return this.currentData() ? this.currentData().name : null;
	};

	// コマンド名に対応するインデックスを取得する処理を追加
	Window_Command.prototype.findName = function(name) {
		return this._list.findIndex(item => item.name === name);
	};

	// コマンド名をもとにコマンドを選択する処理を追加
	Window_ActorCommand.prototype.selectName = function(name) {
		const index = this.findName(name);
		if (index >= 0) {
			this.forceSelect(index);
		} else {
			this.forceSelect(0);
		}
	};

	// コマンドの記憶をシンボルではなくコマンド名にする
	const _EXC_Window_ActorCommand_processOk = Window_ActorCommand.prototype.processOk;
	Window_ActorCommand.prototype.processOk = function() {

		// コマンド名記憶を追加
		if (this._actor) {
			if (ConfigManager.commandRemember) {
				this._actor.setLastCommandName(this.currentName());
			} else {
				this._actor.setLastCommandName("");
			}
		}

		// 元の処理を呼び出し
		_EXC_Window_ActorCommand_processOk.call(this);
	};
	
	// 記憶しているコマンド名をもとにコマンド初期位置をセット
	const _EXC_Window_ActorCommand_selectLast = Window_ActorCommand.prototype.selectLast;
	Window_ActorCommand.prototype.selectLast = function() {
		_EXC_Window_ActorCommand_selectLast.call(this);

		if (this._actor && ConfigManager.commandRemember) {
			const commandName = this._actor.lastCommandName();
			this.selectName(commandName);
		}
	};

	//--------------------------------------------------
	// Game_Actor のオーバーライド
	//--------------------------------------------------
	// 戦闘コマンド名記憶の処理を追加
	Game_Actor.prototype.lastCommandName = function() {
		return this._lastCommandName;
	};
	
	Game_Actor.prototype.setLastCommandName = function(commandName) {
		this._lastCommandName = commandName;
	};
})();

