//=============================================================================
// ショップ画面ウィンドウ位置とかいろいろ改変プラグイン
// EXC_SceneShopCustom.js
// ----------------------------------------------------------------------------
// Copyright (c) 2024 IdiotException
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2024-04-24
//=============================================================================
/*:
 * @target MZ
 * @plugindesc ショップ画面のウィンドウ等の設定を変更しまうま
 * @author IdiotException
 * @url 
 * 
 * @help ショップ画面のウィンドウ等の設定を変更したりするらしいですよ
 * 
 * @param numberWindowContentYOffset
 * @text 購入テキスト縦位置調整
 * @desc 購入ウィンドウのウィンドウ内テキストの
 * 表示される縦位置を調整します。
 * @type number
 * @default 240
 * @min -99999
 * 
 * @param learnedText
 * @text 習得済み表示テキスト
 * @desc スキル習得効果のあるアイテムで
 * 習得済みの場合に表示するテキストを指定します。
 * @type string
 * @default しってる
 * 
 * @param learnedTextColor
 * @text 習得済み表示色ID
 * @desc スキル習得効果のあるアイテムで
 * 習得済みの場合に表示するテキストの色のIDを指定します。
 * @type number
 * @default 6
 * 
 * @param notLearnedText
 * @text 未習得表示テキスト
 * @desc スキル習得効果のあるアイテムで
 * 未習得の場合に表示するテキストを指定します。
 * @type string
 * @default しらない
 * 
 * @param notLearnedTextColor
 * @text 未習得表示色ID
 * @desc スキル習得効果のあるアイテムで
 * 未習得の場合に表示するテキストの色のIDを指定します。
 * @type number
 * @default 16
 * 
 * @param classDelimiter
 * @text クラス区切り文字
 * @desc 武器・防具で装備可能クラス名の間にはいる文字です
 * @type string
 * @default /
 * 
 * @param noneClassText
 * @text 対象無しテキスト
 * @desc 武器・防具で装備可能クラスが
 * 現状存在しない場合に表示する代替テキストです
 * @type string
 * @default そうびかのうくらすなし
 * 
 * @param notDisplayArmorType
 * @text 防具表示対象外タイプ
 * @desc 防具で装備可能クラス名の一覧を
 * 表示させない防具タイプのリストです
 * @type number[]
 * 
 * @param shopLists
 * @text 店員設定リスト
 * @desc ショップで表示する店員のリストを作成します。
 * @default []
 * @type struct<shopLists>[]
 * @parent shopSettings
 */
/*~struct~shopLists:
 *
 * @param number
 * @text 番号
 * @desc 店員指定変数で呼び出される番号です。
 * 重複しない番号でリストを作成してください。
 * @max 2000
 * @min 1
 * @type number
 *
 * @param shopText
 * @text ショップ説明他
 * @desc コマンドウィンドウ選択時のヘルプウィンドウに表示されるテキストです
 * ※設定なしでも可
 * @type multiline_string
 *
 */
const EXCSceneShopCustom = document.currentScript.src.match(/^.*\/(.+)\.js$/)[1];

(function() {
	"use strict";
	//--------------------------------------------------
	// 定数設定
	//--------------------------------------------------
	const SCENE_PADDING	= 30;				// 画面全体の外周空白幅
	const GOLD_WINDOW_OFFSET = 14;			// 所持金ウィンドウの金額表示縦位置調整
	const STATUS_PARAM_RIGHT_X = 328;		// ステータスの右側表示項目の左側との相対位置
	const STATUS_PARAM_NUM_OFFSET = 140;	// ステータスの数値表示の項目名との相対位置

	const SELL_WINDOW_PARTITION = "/"		// 所持数と売却額を分割するテキスト
	const SELL_CURRENCY_UNIT_SPACE = 8;		// 売却額の末尾の単位の前のスペース
	const SELL_CURRENCY_UNIT_COLOR = "#84AAFF";		// 売却額の末尾の単位の文字色

	const GREED_MATERIAL_NUM_WIDTH = 140;	// 素材表示ウィンドウの所持数・必要数表示の幅

	const SHOP_OPTION_TAG ="EXC_Shop"		// アイテム側に設定するタグ

	// ↓NRP_ClassChangeSceneからコピペ
	/**
	 * ●構造体をJSで扱えるように変換
	 */
	function parseStruct1(arg) {
		const ret = [];
		if (arg) {
			for (const str of JSON.parse(arg)) {
				ret.push(str);
			}
		}
		return ret;
	}
	/**
	 * ●構造体（二重配列）をJSで扱えるように変換
	 */
	function parseStruct2(arg) {
		const ret = [];
		if (arg) {
			for (const str of JSON.parse(arg)) {
				ret.push(JSON.parse(str));
			}
		}
		return ret;
	}
	function toBoolean(str, def) {
		if (str === true || str === "true") {
			return true;
		} else if (str === false || str === "false") {
			return false;
		}
		return def;
	}
	function toNumber(str, def) {
		if (str == undefined || str == "") {
			return def;
		}
		return isNaN(str) ? def : +(str || def);
	}
	// ↑NRP_ClassChangeSceneからコピペ

	// LL_MenuScreenShopから必要なものをもらう
	const parameters = PluginManager.parameters("LL_MenuScreenShop");
	const shopNumberVariable = Number(parameters["shopNumberVariable"] || 0);

	// ShopScene_Extensionから必要なものをもらう
	const params = PluginManager.parameters(ShopScene_ExtensionPluginName);
	const ActorCharacterBeginOfs = parseInt(params["ActorCharacterBeginOfs"]);
	const EnableActorArrow = (params["EnableActorArrow"] === "true" ? true : false);
	const VisibleEquipMode = parseInt(params["VisibleEquipMode"]);

	// ARTM_TMGreedShopMZから必要なものをもらう
    const PLUGIN_NAME = "ARTM_TMGreedShopMZ";
    const parametersGS = PluginManager.parameters(PLUGIN_NAME);
    const materialWindowPosition = +(parametersGS['materialWindowPosition'] || 0);
    const needText = parametersGS['needText'] || '';
	const showMaterialFromNumberWindow = JSON.parse(parametersGS['showMaterialFromNumberWindow'] || 'true');

	// NRP_ClassChangeSceneから必要なものをもらう
	const PLUGIN_NAME_CC = "NRP_ClassChangeScene";
	const parametersCC = PluginManager.parameters(PLUGIN_NAME_CC);
	const pClassList = parseStruct2(parametersCC["ClassList"]);
	const pSortClassId = toBoolean(parametersCC["SortClassId"], false);

	// このプラグインのパラメータ取得
	const paramEXC = PluginManager.parameters(EXCSceneShopCustom);
	const GreedShopNumberWindowContentsYOffset = parseInt(paramEXC["numberWindowContentYOffset"] || 0);
	const learnedText = String(paramEXC["learnedText"] || "しってる");
	const learnedTextColor = Number(paramEXC["learnedTextColor"] || 0);
	const notLearnedText = String(paramEXC["notLearnedText"] || "しらない");
	const notLearnedTextColor = Number(paramEXC["notLearnedTextColor"] || 0);
	const classDelimiter = String(paramEXC["classDelimiter"] || "/");
	const noneClassText = String(paramEXC["noneClassText"] || "/");
	const notDispArmor = JSON.parse(paramEXC["notDisplayArmorType"] || "[]");
	// LL_MenuScreenShopを参考に
	const shopListArrays = JSON.parse(paramEXC["shopLists"] || "[]");
	let shopLists = [];
	shopListArrays.forEach(el => shopLists.push(JSON.parse(el)));

	//--------------------------------------------------
	// 変数設定
	//--------------------------------------------------
	let _isShop = false;	// 内部で使うフラグ
	let _shopText = "";		// コマンドウィンドウ選択中にヘルプに表示するテキスト
	let _currencyUnit = "";	// 通貨単位保持用
	let _classList = null;	// 転職対象となる職業一覧
	
	//--------------------------------------------------
	// Scene_Shop のオーバーライド
	//--------------------------------------------------
	// ボタンを消しているのでトップ位置修正
	Scene_Shop.prototype.mainAreaTop = function() {
		return SCENE_PADDING;
	};

	// アクター切り替え機能を削除
	Scene_Shop.prototype.nextActor = function() {
		this.activateBuyWindow();
	};
	
	// アクター切り替え機能を削除
	Scene_Shop.prototype.previousActor = function() {
		this.activateBuyWindow();
	};

	const _EXC_Scene_Shop_create = Scene_Shop.prototype.create;
	Scene_Shop.prototype.create = function() {
		// ショップ画面であることのフラグ
		_isShop = true;

		// コマンドウィンドウアクティブ時に表示するテキストの取得
		_shopText = "";
		const tmpShopSetting = shopLists.filter(el => Number(el.number|| 0) == $gameVariables.value(shopNumberVariable));
		if (tmpShopSetting && tmpShopSetting.length > 0){
			_shopText = tmpShopSetting[0].shopText;
		}

		// 継承元処理の実行
		_EXC_Scene_Shop_create.call(this);

		// 通貨単位取得
		_currencyUnit = this._goldWindow.currencyUnit();

		// メッセージウィンドウの背景削除
		this._messageWindow.opacity = 0;

		// ヘルプウィンドウの背景復活
		this._helpWindow.opacity = 255;

		// ヘルプウィンドウと所持金ウィンドウの高さを一致させる
		this._goldWindow.y = this._helpWindow.y;

		// 売却ウィンドウの表示範囲バグ修正
		this._sellWindow.createContents();
		this._sellWindow.refresh();


		// 職業一覧の生成
		// ↓ほぼNRP_ClassChangeSceneのコピペ
		_classList = [];
		const mClassList = pClassList;

		// ＩＤ順で並び替え
		if (pSortClassId) {
			mClassList.sort((a, b) => a.Class - b.Class);
		}

		// 職業一覧を編集
		for (const classInfo of mClassList) {
			classInfo.class = classInfo.Class;
			classInfo.actors = parseStruct1(classInfo.Actors);
			classInfo.switch = toNumber(classInfo.Switch);
			classInfo.item = toNumber(classInfo.Item);
			classInfo.classInfo = classInfo.ClassInfo;
			classInfo.script = classInfo.Script;
		}

		// 転職条件を満たすか判定
		for (const classInfo of mClassList) {
			// 対象のアクターでない場合
			/*if (classInfo.actors && classInfo.actors.length && !this.isActorConditionOK(classInfo.actors)) {
				continue;
			// 対象のスイッチがオンでない場合
			} else */
			if (classInfo.switch && !$gameSwitches.value(classInfo.switch)) {
				continue;
			// 対象のアイテムが持っていない場合
			} /*else if (classInfo.item && !$gameParty.hasItem($dataItems[classInfo.item])) {
				continue;
			// 対象の職業情報を満たさない場合
			} else if (classInfo.classInfo && !this.isClassConditionOK(classInfo.classInfo)) {
				continue;
			// 対象のスクリプトがオンでない場合
			} else if (classInfo.script && !eval(classInfo.script)) {
				continue;
			}
			*/

			// 条件を満たすなら追加
			_classList.push($dataClasses[classInfo.class]);
		}
		// ↑ほぼNRP_ClassChangeSceneのコピペ
	};

	const _EXC_Scene_Shop_helpWindowRect = Scene_Shop.prototype.helpWindowRect;
	Scene_Shop.prototype.helpWindowRect = function() {
		const rect = _EXC_Scene_Shop_helpWindowRect.call(this);

		// 幅を調整
		rect.width -= this.mainCommandWidth() + (SCENE_PADDING *2);
		
		// パディング分位置変更
		rect.x = SCENE_PADDING;

		return rect;
	};


	const _EXC_Scene_Shop_goldWindowRect = Scene_Shop.prototype.goldWindowRect;
	Scene_Shop.prototype.goldWindowRect = function() {
		const rect = _EXC_Scene_Shop_goldWindowRect.call(this);

		// 高さをヘルプに合うよう調整
		rect.height = this.calcWindowHeight(2, false);

		// パディング分位置変更
		rect.x -= SCENE_PADDING;

		return rect;
	};

	const _EXC_Scene_Shop_commandWindowRect = Scene_Shop.prototype.commandWindowRect;
	Scene_Shop.prototype.commandWindowRect = function() {
		const rect = _EXC_Scene_Shop_commandWindowRect.call(this);

		// コマンドウィンドウ幅と位置変更
		rect.x = SCENE_PADDING;
		rect.width = Graphics.boxWidth - this.statusWidth();

		return rect;
	};

	const _EXC_Scene_Shop_dummyWindowRect = Scene_Shop.prototype.dummyWindowRect;
	Scene_Shop.prototype.dummyWindowRect = function() {
		const rect = _EXC_Scene_Shop_dummyWindowRect.call(this);

		// パディング分位置変更
		rect.x = SCENE_PADDING;

		return rect;
	};

	const _EXC_Scene_Shop_numberWindowRect = Scene_Shop.prototype.numberWindowRect;
	Scene_Shop.prototype.numberWindowRect = function() {
		const rect = _EXC_Scene_Shop_numberWindowRect.call(this);

		// パディング分位置変更
		rect.x = SCENE_PADDING;

		return rect;
	};

	const _EXC_Scene_Shop_statusWindowRect = Scene_Shop.prototype.statusWindowRect;
	Scene_Shop.prototype.statusWindowRect = function() {
		const rect = _EXC_Scene_Shop_statusWindowRect.call(this);

		// パディング分位置変更
		rect.x = SCENE_PADDING;

		return rect;
	};

	const _EXC_Scene_Shop_buyWindowRect = Scene_Shop.prototype.buyWindowRect;
	Scene_Shop.prototype.buyWindowRect = function() {
		const rect = _EXC_Scene_Shop_buyWindowRect.call(this);

		// パディング分位置変更
		rect.x = SCENE_PADDING;

		return rect;
	};

	const _EXC_Scene_Shop_categoryWindowRect = Scene_Shop.prototype.categoryWindowRect;
	Scene_Shop.prototype.categoryWindowRect = function() {
		const rect = _EXC_Scene_Shop_categoryWindowRect.call(this);

		// パディング分位置変更
		rect.x = SCENE_PADDING;

		return rect;
	};

	const _EXC_Scene_Shop_sellWindowRect = Scene_Shop.prototype.sellWindowRect;
	Scene_Shop.prototype.sellWindowRect = function() {
		const rect = _EXC_Scene_Shop_sellWindowRect.call(this);

		// パディング分位置変更
		rect.x = SCENE_PADDING;

		return rect;
	};

	//////////////////////////////////////////////
	// 以下、LL_MenuScreenShopのオーバーライド
	Scene_Shop.prototype.statusHeight = function() {
		return 210;
	};

	Scene_Shop.prototype.messageWindowRect = function() {
		// メッセージウィンドウ位置を変更
		const ww = Graphics.boxWidth - this._commandWindow.width - SCENE_PADDING *2;
		const wh = this.calcWindowHeight(1, false);
		const wx = this._commandWindow.x + this._commandWindow.width;
		const wy = this._commandWindow.y + (this._commandWindow.height - wh)/2;
		return new Rectangle(wx, wy, ww, wh);
	};

	const _EXC_Scene_Shop_updateMessageWithPicture = Scene_Shop.prototype.updateMessageWithPicture;
	Scene_Shop.prototype.updateMessageWithPicture = function(messageType) {
		_EXC_Scene_Shop_updateMessageWithPicture.call(this, ...arguments);

		// メッセージ位置を固定
		this._messageWindow.width = Graphics.boxWidth - this._commandWindow.width - SCENE_PADDING *2;
		this._messageWindow.height = this.calcWindowHeight(1, false);
		this._messageWindow.x = this._commandWindow.x + this._commandWindow.width;
		this._messageWindow.y = this._commandWindow.y + (this._commandWindow.height - this._messageWindow.height)/2;

		// コマンドウィンドウアクティブ時のヘルプメッセージ設定
		if (!messageType && this._commandWindow && this._commandWindow.active) {
			if(_shopText == ""){
				// 表示テキストがなければヘルプを非表示に
				this._helpWindow.hide();
			} else {
				// テキストをヘルプに表示する
				this._helpWindow.show();
				this._helpWindow.setText(_shopText);
			}
		} else {
			this._helpWindow.show();
		}
	}


	//--------------------------------------------------
	// Window_Base のオーバーライド
	//--------------------------------------------------
	//--------------------------------------------------
	// ARTM_TMGreedShopMZ のオーバーライド
	Window_Base.prototype.drawGreedMaterials = function(x, y, item, amount, rate) {
		const materials = DataManager.getGreedShopMaterials(item);
		this.resetFontSettings();
		this.contents.fontSize = Math.floor(this.contents.fontSize * rate);
		if (needText) {
			// こちらの条件を追加　売却時にはこの部分を処理しないようにしているだけ
			if (!this.parent || !this.parent.parent || !this.parent.parent._commandWindow ||
					(this.parent && this.parent.parent && this.parent.parent._commandWindow 
							&& this.parent.parent._commandWindow.currentSymbol() != "sell")) {
				y = this.drawGreedNeedText(y, rate);
			}
		}
		// こちらの条件を追加　売却時にはこの部分を処理しないようにしているだけ
		if (!this.parent || !this.parent.parent || !this.parent.parent._commandWindow ||
				(this.parent && this.parent.parent && this.parent.parent._commandWindow 
						&& this.parent.parent._commandWindow.currentSymbol() != "sell")) {
			for (let i = 0; i < materials.length; i++) {
				y = this.drawGreedMaterial(x, y, materials[i], amount, rate);
			}
		}
		if (this._price) {
			this.drawGreedPrice(y, amount, rate);
		}
		this.resetFontSettings();
	};

	// アイテム名と所持数/数量が被らないよう調整
	Window_Base.prototype.drawGreedMaterial = function(x, y, material, amount, rate) {
		const x2 = x + Math.floor((ImageManager.iconWidth + 4) * rate);
		const lh = Math.floor(this.lineHeight() * rate);
		const materialItem = DataManager.materialToItem(material);
		const need = material.need * amount;
		const n = $gameParty.numItems(materialItem);
		let text = DataManager.isConsumableMaterial(materialItem) ? '' + n + '/' : '--/';
		text += ('   ' + need).substr(-3);
		this.drawStretchIcon(x, y, materialItem.iconIndex, rate);
		this.changeTextColor(ColorManager.normalColor());
        //this.contents.drawText(materialItem.name, x2, y, 312, lh); 下記にリプレイス 素材名と数量が被らないよう調整
		this.contents.drawText(materialItem.name, x2, y, this.contents.width - GREED_MATERIAL_NUM_WIDTH, lh);
		this.contents.drawText(text, x, y, this.contents.width - this.itemPadding(), lh, 'right');
		return y + lh;
	};

	//--------------------------------------------------
	// Window_Gold のオーバーライド
	//--------------------------------------------------
	const _EXC_Window_Gold_itemLineRect = Window_Gold.prototype.itemLineRect;
	Window_Gold.prototype.itemLineRect = function(index) {
		const rect = _EXC_Window_Gold_itemLineRect.call(this, ...arguments);

		if(_isShop){
			// ２行高さの中央っぽい位置に高さ微調整
			rect.y += GOLD_WINDOW_OFFSET;
			rect.height += GOLD_WINDOW_OFFSET;
		}
		return rect;
	};

	//--------------------------------------------------
	// Window_ShopSell のオーバーライド
	//--------------------------------------------------
	// 売却ウィンドウで売却額も表示するよう改修
	Window_ShopSell.prototype.drawItemNumber = function(item, x, y, width) {
		if (this.needsNumber()) {
			// 売却額の取得
			let price = Math.floor(item.price / 2);
				// 2024/12/24 売却価格をスイッチで標準価格に変更できるように改変
				if (item.meta && item.meta.Price && $gameTemp.isRshop && $gameTemp.isRshop() && !Number.isNaN(price) && !$gameSwitches.value(35)) {
				// 2024/12/24 ここまで
                price = Number(item.meta.Price);
            }
			// 所持数 / 売却額 になるようにテキスト調整
			this.drawText($gameParty.numItems(item), x, y, width - this.textWidth(" " + SELL_WINDOW_PARTITION + " 00000" + _currencyUnit) - SELL_CURRENCY_UNIT_SPACE, "right");
			this.drawText(SELL_WINDOW_PARTITION, x, y, width - this.textWidth("00000" + _currencyUnit) - SELL_CURRENCY_UNIT_SPACE, "right");
			this.drawText(price, x, y, width - this.textWidth(_currencyUnit) - SELL_CURRENCY_UNIT_SPACE, "right");

			// 末尾のお金の単位は特定の色に変更
			this.changeTextColor(SELL_CURRENCY_UNIT_COLOR);
			this.drawText(_currencyUnit, x, y, width, "right");
			this.resetTextColor();
		}
	};

	// 数値の表示域確保
	Window_ShopSell.prototype.numberWidth = function() {
		return this.textWidth(" 000 " + SELL_WINDOW_PARTITION + " 00000" + _currencyUnit) + SELL_CURRENCY_UNIT_SPACE;
	};

	//--------------------------------------------------
	// Window_ShopStatus のオーバーライド
	//--------------------------------------------------
	//--------------------------------------------------
	// 以下、ShopScene_Extension のオーバーライド
	const _EXC_Window_ShopStatus_updateArrowCursor = Window_ShopStatus.prototype.updateArrowCursor;
	Window_ShopStatus.prototype.updateArrowCursor = function() {
		_EXC_Window_ShopStatus_updateArrowCursor.call(this);

		// 左右切り替え表示の矢印を常時非表示
		this._rightArrowSprite.visible = false;
		this._leftArrowSprite.visible = false;

	};

	// アイテム所持数の行に情報追加
	const _EXC_Window_ShopStatus_drawPossession = Window_ShopStatus.prototype.drawPossession;
	Window_ShopStatus.prototype.drawPossession = function(x, y) {
		let text = "";

		// アイテム側の設定がある場合は読み込む
		if(!text && this._item.meta[SHOP_OPTION_TAG]){
			text = this._item.meta[SHOP_OPTION_TAG];
			this.resetTextColor();
			this.drawText(text, x, y, STATUS_PARAM_RIGHT_X - x);
		}

		// スキル習得アイテムの場合、習得済みor未習得を表示
		if(!text && this._item.effects){
			let colorID = 0;
			// 対象のアイテムからスキル習得効果の取得
			const learn = this._item.effects.find(el => el.code == "43");
			if(this._actor && learn){
				// 習得済み、未習得の切り分け
				if(this._actor.hasSkill(learn.dataId)){
					text = learnedText;
					colorID = learnedTextColor;
				}else{
					text = notLearnedText;
					colorID = notLearnedTextColor;
				}

				// テキストをセット
				if(text){
					this.changeTextColor(ColorManager.textColor(colorID));
					this.drawText(text, x, y, STATUS_PARAM_RIGHT_X - x);
					this.resetTextColor();
				}
			}
		}

		if(!text){
			let traitCode = -1;
			let typeId = -1;
			// 武器防具の切り分け
			if(DataManager.isWeapon(this._item)){
				traitCode = 51;
				typeId = this._item.wtypeId;
			}else if(DataManager.isArmor(this._item)){
				// 表示対象外の場合はスキップ
				if(!notDispArmor.find(el => Number(el) == this._item.atypeId)){
					traitCode = 52;
					typeId = this._item.atypeId;
				}
			}
			if(traitCode > 0){
				// 各クラスの装備可能チェック
				for (const classInfo of _classList) {
					if(classInfo.name && classInfo.traits && classInfo.traits.find(el => el.code == traitCode && el.dataId == typeId)){
						if(text){
							text += classDelimiter;
						}
						text += classInfo.name;
					}
				}
				// 現状判明しているクラスで装備できない場合は代替テキストに
				if(!text){
					text = noneClassText;
				}

				// 作成したクラス名一覧を表示
				this.resetTextColor();
				this.drawText(text, x, y, STATUS_PARAM_RIGHT_X - x);
			}
		}
		// アイテム所持数のx位置書き換え
		x += STATUS_PARAM_RIGHT_X;
		_EXC_Window_ShopStatus_drawPossession.call(this, x, y);
	};
	//--------------------------------------------------
	// 以下、ShopScene_Extension のオーバーライド
	// ちょっと書き換えのために全コピー
	Window_ShopStatus.prototype.drawActorEquipInfo = function(x, y, actor) {
		this._currentEquippedItem = this.currentEquippedItem(actor, this._item.etypeId);
		const width = this.innerWidth - x - this.itemPadding();
		const halfWindowWidth = Math.floor(width / 2);
		this.resetTextColor();
	
		// Draw equip item
		if (VisibleEquipMode === 1) {
			// Draw actor name
			this.drawText(actor.name(), x, y, halfWindowWidth);
	
			// Draw item
			this.drawCurrentItem(x + halfWindowWidth, y, halfWindowWidth);
			y += this.lineHeight() * 3 + 8;
	
			// Draw characters
			this.setupActorCharacters(x + ActorCharacterBeginOfs, y - this.lineHeight() * 1.5);
			if (EnableActorArrow) this.setupActorCursors(y - this.lineHeight() * 1.5);
		} else if (VisibleEquipMode === 2) {
			// Draw actor name
			//this.drawText(actor.name(), x, y, width); //ここを消す
	
			// Draw item
			const halfRightArrowWidth = this.rightArrowWidth() / 2;
			const itemNameWidth = halfWindowWidth - halfRightArrowWidth;
			//y += this.lineHeight(); //ここを消す
			this.drawCurrentItem(x, y, itemNameWidth);
			this.drawItemName(this._item, x + halfWindowWidth + this.rightArrowWidth(), y, itemNameWidth - halfRightArrowWidth);
			this.drawRightArrow(x + halfWindowWidth, y);
			//y += this.lineHeight() * 2 + 8;
			y += this.lineHeight(); // ここを書き換え
	
			// Draw characters
			this.setupActorCharacters(x + ActorCharacterBeginOfs, y - this.lineHeight());
			if (EnableActorArrow) this.setupActorCursors(y - this.lineHeight());
		} else {
			// Draw actor
			this.drawText(actor.name(), x, y, width);
	
			// Draw characters
			y += this.lineHeight() * 3 + 8;
			this.setupActorCharacters(x + ActorCharacterBeginOfs, y - this.lineHeight() * 1.5);
			if (EnableActorArrow) this.setupActorCursors(y - this.lineHeight() * 1.5);
		}
		//y += 8; //ここを消す
	
		// Draw params
		this.drawAllParams(x, y);
	};

	// このメソッドは結構大きく書き換えてる
	Window_ShopStatus.prototype.drawAllParams = function(x, y) {
		let tmpX = x;
		for (let i = 0; i < 6; i++) {
			if (i % 2 == 1) {
				tmpX = x + STATUS_PARAM_RIGHT_X; // 奇数の場合右側に表示を
			} else {
				tmpX = x;
			}
			this.drawItem(tmpX, y, 2 + i);
			if (i % 2 == 1) {
				// 奇数の場合次の行
				y += this.lineHeight();
			}

		}
	};

	// 一部だけ書き換え
	Window_ShopStatus.prototype.drawItem = function(x, y, paramId) {
		//const paramX = this.paramX();
		const paramX = x + STATUS_PARAM_NUM_OFFSET;// ここだけ書き換え
		const paramWidth = this.paramWidth();
		const rightArrowWidth = this.rightArrowWidth();
		this.drawParamName(x, y, paramId);
		if (this._actor) this.drawCurrentParam(paramX, y, paramId);
		this.drawRightArrow(paramX + paramWidth, y);
		this.drawNewParam(paramX + paramWidth + rightArrowWidth, y, paramId);
	};

	// アクター切り替えを常時OFF
	Window_ShopStatus.prototype.setEnableChangeActor = function(enableChangeActor) {
		this._enableChangeActor = false;
	};

	//--------------------------------------------------
	// Window_ShopBuy のオーバーライド
	//--------------------------------------------------
	//--------------------------------------------------
	// ARTM_TMGreedShopMZ のオーバーライド
	// 素材ウィンドウの位置補正、ちょっと書き換えのために全コピー
	Window_ShopBuy.prototype.setMaterialWindowPosition = function() {
        const rect = this.itemRectWithPadding(this.index());
        const y = this.calcMaterialWindowPositionY(rect);
        //const h_helpWindowNoinc = Graphics.boxHeight - this._helpWindow.height;
        const h_helpWindowNoinc = this.y + this.height; // ここだけ書き換え ウィンドウ下端上限判定値をウィンドウの要素で完結するように
        let x = 0;
        switch (materialWindowPosition) {
            case 0:  // item bottom
                x = this.x + this.width / 2;
                this._materialWindow.x = x - this._materialWindow.width / 2;
                this._materialWindow.y = y;
                if (this._materialWindow.y + this._materialWindow.height > h_helpWindowNoinc) {
                    this._materialWindow.y -= this._materialWindow.height + rect.height;
                }
                break;
            case 1:  // item right
                x = this.x + this.width - this.padding;
                this._materialWindow.x = x;
                this._materialWindow.y = y;
                if (this._materialWindow.x + this._materialWindow.width > Graphics.boxWidth) {
                    this._materialWindow.x = Graphics.boxWidth - this._materialWindow.width;
                }
                if (this._materialWindow.y + this._materialWindow.height > h_helpWindowNoinc) {
                    this._materialWindow.y -= this._materialWindow.height + rect.height;
                }
                break;
            case 2:  // container bottom
                this._materialWindow.x = this.x;
                this._materialWindow.y = this.y + this.height;
                if (this._materialWindow.y + this._materialWindow.height > h_helpWindowNoinc) {
                    this._materialWindow.y = h_helpWindowNoinc - this._materialWindow.height;
                }
                break;
        }
    };


	//--------------------------------------------------
	// Window_ShopNumber のオーバーライド
	//--------------------------------------------------
	//--------------------------------------------------
	// ARTM_TMGreedShopMZ のオーバーライド
	const _EXC_Window_ShopNumber_drawGreedMaterials = Window_ShopNumber.prototype.drawGreedMaterials;
    Window_ShopNumber.prototype.drawGreedMaterials = function(x, y, item, amount, rate) {

		// 縦位置の補正
		y += GreedShopNumberWindowContentsYOffset;

		_EXC_Window_ShopNumber_drawGreedMaterials.call(this, x, y, item, amount, rate);
	};

	const _EXC_Window_ShopNumber_itemNameY = Window_ShopNumber.prototype.itemNameY;
	Window_ShopNumber.prototype.itemNameY = function() {
		let ret = _EXC_Window_ShopNumber_itemNameY.call(this);
		// 縦位置の補正
		if ($gameTemp.isGreedShop() && showMaterialFromNumberWindow) {
			ret += GreedShopNumberWindowContentsYOffset;
		}
		return ret;
	};

	const _EXC_Window_ShopNumber_priceY = Window_ShopNumber.prototype.priceY;
	Window_ShopNumber.prototype.priceY = function() {
		let ret = _EXC_Window_ShopNumber_priceY.call(this);
		// 縦位置の補正
		if ($gameTemp.isGreedShop() && showMaterialFromNumberWindow) {
			ret += GreedShopNumberWindowContentsYOffset;
		}
		return ret;
	};

	const _EXC_Window_ShopNumber_buttonY = Window_ShopNumber.prototype.buttonY;
	Window_ShopNumber.prototype.buttonY = function() {
		let ret = _EXC_Window_ShopNumber_buttonY.call(this);
		// 縦位置の補正
		if ($gameTemp.isGreedShop() && showMaterialFromNumberWindow) {
			ret += GreedShopNumberWindowContentsYOffset;
		}
		return ret;
	};
})();

