//=============================================================================
// ヘルプウィンドウ文字サイズ縮小プラグイン
// EXC_WindowHelpFontSizeReduction.js
// ----------------------------------------------------------------------------
// Copyright (c) 2025 IdiotException
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2025-12-16
//=============================================================================
/*:
 * @target MZ
 * @plugindesc ヘルプウィンドウの文字サイズを縮小します
 * @author IdiotException
 * @url 
 * 
 * @help ヘルプウィンドウの文字列がウィンドウ描画範囲の幅を超過する場合に
 * フォントサイズを縮小して全文が表示されるよう調整します。
 * 
 * @param minFontSize
 * @text 最小サイズ
 * @desc 最小となるフォントサイズです。
 * これよりは小さくせず、見切れが発生します。
 * @min 1
 * @type number
 * @default 10
 */

const EXCWindowHelpFontSizeReduction = document.currentScript.src.match(/^.*\/(.+)\.js$/)[1];

(function() {
	"use strict";

	// このプラグインのパラメータ取得
	const param = PluginManager.parameters(EXCWindowHelpFontSizeReduction);
	const _minFontSize = parseInt(param["minFontSize"] || 1);

	//--------------------------------------------------
	// window_help のオーバーライド
	//--------------------------------------------------
	// Window_Helpのrefreshメソッドをオーバーライド
    const _Window_Help_refresh = Window_Help.prototype.refresh;
    Window_Help.prototype.refresh = function() {
        _Window_Help_refresh.call(this);  // 元のrefreshを呼び出し

        this.contents.clear();
        if (this._text) {
			// 文字色変更命令が残っていることがあるのでリセットさせてから描画する
			const tmpText = "\\c[0]" + this._text;

		    const rect = this.baseTextRect();
            const maxWidth = rect.width;  // ウィンドウの内幅（padding除く）

			// デフォルトでのテキスト幅の取得（呼び出し先でフォント設定がリセットされる）
			let textWidth = this.textSizeEx(tmpText).width;

			// 元のフォントサイズ取得
            let fontSize = this.contents.fontSize;

            // 幅が超える場合、フォントサイズを減らすループ
            while (textWidth > maxWidth && fontSize > _minFontSize) {
                fontSize--;
                this.contents.fontSize = fontSize;
				textWidth = this.EXC_TextSizeEx(tmpText).width;
            }

            // テキストを描画 drawTextExの中身を引っ張ってきた（同メソッドでは処理前にフォントリセット処理があったため
			const textState = this.createTextState(tmpText, rect.x, rect.y, rect.width);
			this.processAllText(textState);

            // フォント設定を元に戻す
            this.resetFontSettings();
        }
	};

	// window_baseのtextSizeExからフォントリセット機能を取り除いたもの
	Window_Help.prototype.EXC_TextSizeEx = function(text) {
		// 実際には書き込まずに書き込むのと同等の処理を行い、テキストのサイズを取得
		const textState = this.createTextState(text, 0, 0, 0);
		textState.drawing = false;	// 実際には書き込まないようOFFに
		this.processAllText(textState);
		return { width: textState.outputWidth, height: textState.outputHeight };
	};
})();

