//=============================================================================
// FOTA3_AutoSaveTimingFix.js
// ----------------------------------------------------------------------------
// Copyright (c) 2021 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2025/11/07 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc オートセーブのタイミングを修正する
 * @target MZ
 * @author n2naokun(柊菜緒)
 *
 * @help 説明
 * 
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

var Imported = Imported || {};
// 他のプラグインとの連携用シンボル

(function (_global) {
   const PluginName = "FOTA3_AutoSaveTimingFix";
   Imported[PluginName] = true;

   // グローバル変数宣言
   var saveContents = null;
   var autoSaveFlag = false;
   var isNewScene = false;

   const Scene_Map_start = Scene_Map.prototype.start;
   Scene_Map.prototype.start = function () {
      Scene_Map_start.call(this);
      isNewScene = true;
   };

   const Scene_Map_update = Scene_Map.prototype.update;
   Scene_Map.prototype.update = function () {
      Scene_Map_update.call(this);
      // フェードが空けたタイミングでスクリーンショットとセーブ処理を行う
      if (autoSaveFlag && isNewScene && !this.isBusy()) {
         autoSaveFlag = false;
         isNewScene = false;
         DataManager.saveGameWithData(0, saveContents)
            .then(() => this.onAutosaveSuccess())
            .catch(() => this.onAutosaveFailure());
         saveContents = null;
      }
   };

   const Scene_Map_executeAutosave = Scene_Map.prototype.executeAutosave;
   Scene_Map.prototype.executeAutosave = function () {
      $gameSystem.onBeforeSave();
      // 念のために通常のオートセーブも行う
      DataManager.saveGame(0)
         .then(() => this.onAutosaveSuccess())
         .catch(() => this.onAutosaveFailure());
      // 後でスクリーンショットを撮り直してセーブするためにデータを保存
      saveContents = DataManager.makeSaveContents();
      autoSaveFlag = true;
      isNewScene = false;
   };

   DataManager.saveGameWithData = function (savefileId, contents) {
      SceneManager.snapForBackground();
      const saveName = this.makeSavename(savefileId);
      return StorageManager.saveObject(saveName, contents).then(() => {
         this._globalInfo[savefileId] = this.makeSavefileInfo();
         this.saveGlobalInfo();
         return 0;
      });
   };
})(this);
