//=============================================================================
// FOTA3_MenuCommon.js
// ----------------------------------------------------------------------------
// Copyright (c) 2021 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.3.1 2024/12/24 タッチUI無効化でgetterだけ指定していたら
//                  CustomizeConfigDefaultがエラーになったのを修正
// 0.3.0 2024/05/11 タッチUIの無効化機能を追加
// 0.2.0 2024/02/17 Scene_MenuBaseを継承したシーンへの立ち絵表示機能追加
// 0.1.1 2024/02/01 スロットプラグイン対応修正
// 0.1.0 2024/01/31 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc 深淵の森RPG3共通処理ライブラリ
 * @target MZ
 * @url 
 * @author n2naokun(柊菜緒)
 *
 * @help 説明
 * 
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 * 
 * @param backConfigVariable
 * @text 背景指定変数
 * @desc 背景を指定するのに使用する変数番号を指定します。
 * @type number
 * @default 0
 * 
 * @param fontData
 * @text フォントデータ
 * @desc フォント名とファイル名のセット
 * @type struct<fontData>[]
 * @default []
 * 
 * @param hideBackImage
 * @text シーン背景画像非表示
 * @desc シーン個別で背景画像を非表示にするかどうか
 * Scene_MenuBaseを継承したシーン名を指定してください。
 * @type string[]
 * @default ["Scene_SlotMachine"]
 * 
 * @param showStandImage
 * @text シーン立ち絵表示設定
 * @desc シーン個別で立ち絵を表示するかどうか
 * Scene_MenuBaseを継承したシーン名を指定してください。
 * @type string[]
 * @default ["Scene_Status"]
 */
/*~struct~fontData:
 * @param fontName
 * @text フォント名
 * @desc プログラム内で使用されるフォント名
 * 
 * @param fontFileName
 * @text フォントファイル名
 * @desc フォントのファイル名
 */


// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

var Imported = Imported || {};
Imported.FOTA3_MenuCommon = true;
// 他のプラグインとの連携用シンボル

(function (_global) {
   const params = PluginManager.parameters('FOTA3_MenuCommon');
   const fontData = JSON.parse(params['fontData']).map(
      function (data) {
         return JSON.parse(data);
      }
   );
   const backConfigVariable = Number(params['backConfigVariable']) || 0;

   const hideBackImage = JSON.parse(params['hideBackImage']);

   const showStandImage = JSON.parse(params['showStandImage']);


   // フォントローダー
   const _Scene_Boot_loadGameFonts = Scene_Boot.prototype.loadGameFonts;
   Scene_Boot.prototype.loadGameFonts = function () {
      _Scene_Boot_loadGameFonts.call(this);

      fontData.forEach(function (data) {
         FontManager.load(data['fontName'], data['fontFileName']);
      });
   };

   // バックグラウンド表示
   const _Scene_MenuBase_createBackground = Scene_MenuBase.prototype.createBackground;
   Scene_MenuBase.prototype.createBackground = function () {
      _Scene_MenuBase_createBackground.call(this);

      // 2024/02/01 スロットマシンの背景に表示されてしまう不具合の修正
      if (hideBackImage.contains(this.constructor.name)) {
         return;
      }
      // 2024/02/01 ここまで
      var backNum = $gameVariables.value(backConfigVariable) || 0;
      this._customBGSprite = new Sprite();
      if (backNum > 0 && backNum < 100) {
         var fileName = 'menu_bg' + ('00' + backNum).slice(-2);
         if (this.constructor.name === 'Scene_Menu') {
            fileName += 'a';
         } else {
            fileName += 'b';
         }
         this._customBGSprite.bitmap = ImageManager.loadBitmap("img/menuC/", fileName);
      }
      this.addChild(this._customBGSprite);

      // 立ち絵表示
      this._standImageSprite = new Sprite();
      if (showStandImage.contains(this.constructor.name)) {
         const actor = $gameParty.members()[0];
         const classId = actor._classId;
         this._standImageSprite.bitmap =
            ImageManager.loadBitmap("img/menuC/", "menu_character" + ('00' + classId).slice(-2) + "b");
      }
      this.addChild(this._standImageSprite);
   };

   // 2024/05/11 タッチUI無効化
   Object.defineProperty(ConfigManager, 'touchUI', {
      get: function () {
         return false;
      },
      // 2024/12/24 タッチUI無効化でgetterだけ指定していたらCustomizeConfigDefaultがエラーになったのを修正
      set: function (value) {
         // 設定値は無視
      }
      // 2024/12/24 ここまで
   });

   const Window_Options_makeCommandList = Window_Options.prototype.makeCommandList;
   Window_Options.prototype.makeCommandList = function () {
      Window_Options_makeCommandList.call(this);
      let list = this._list;
      this._list = list.filter(command => {
         return command.symbol !== 'touchUI';
      });
   };
   // 2024/05/11 ここまで

})(this);
