//=============================================================================
// FOTA3_SkillTypeWindowCustom.js
// ----------------------------------------------------------------------------
// Copyright (c) 2021 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2025/12/11 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc スキルタイプウィンドウに表示するスキルの制御プラグイン
 * @target MZ
 * @author n2naokun(柊菜緒)
 *
 * @help 説明
 * ジョブや装備(アビリティ)のメモ欄にタグを追加することで表示するスキルタイプをコントロールできます。
 * <jobFlagSwitch:番号>
 * このタグで指定した番号のスイッチがONの時はジョブのスキルタイプを強制的に表示します。
 * <jobForceFlag>
 * このタグが付いたジョブのスキルタイプは強制的に表示されます。
 * 
 * <abilityFlagSwitch:番号>
 * このタグで指定した番号のスイッチがONの時はアビリティのスキルタイプを強制的に表示します。
 * <abilityForceFrag:番号>
 * このタグが付いたアビリティのスキルタイプは強制的に表示されます。
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

var Imported = Imported || {};
Imported.FOTA3_SkillTypeWindowCustom = true;
// 他のプラグインとの連携用シンボル

(function (_global) {

   function enableSkillTypes(traitObjects) {
      const code = Game_BattlerBase.TRAIT_STYPE_ADD;
      const allTraits = traitObjects.reduce((r, obj) => r.concat(obj.traits), []);
      const traits = allTraits.filter(trait => trait.code === code);
      const skillTypes = traits.reduce((r, trait) => r.concat(trait.dataId), []);
      return skillTypes;
   }

   function getEnableClasses() {
      return $dataClasses.filter(classData => {
         return classData && (classData.meta.jobForceFlag || $gameSwitches.value(Number(classData.meta.jobFlagSwitch)));
      });
   }

   function getEnableAbilities() {
      return $gameParty.armors().filter(classData => {
         return classData && (classData.meta.abilityForceFrag || $gameSwitches.value(Number(classData.meta.abilityFlagSwitch)));
      });
   }

   if (KRD_MULTILINGUAL) {
      // 多分不要になるけど念のためにKRD_MZ_Multilingual.jsとの連携
      Window_SkillType.prototype.makeCommandList = function () {
         if (this._actor) {
            const classes = getEnableClasses();
            const abilities = getEnableAbilities();
            const skillTypes = [...new Set(enableSkillTypes(classes).concat(enableSkillTypes(abilities)))];
            for (const stypeId of skillTypes) {
               const name = TextManager.skillType(stypeId);
               this.addCommand(name, "skill", true, stypeId);
            }
         }
      };
   } else {
      Window_SkillType.prototype.makeCommandList = function () {
         if (this._actor) {
            const classes = getEnableClasses();
            const abilities = getEnableAbilities();
            const skillTypes = [...new Set(enableSkillTypes(classes).concat(enableSkillTypes(abilities)))];
            for (const stypeId of skillTypes) {
               const name = $dataSystem.skillTypes[stypeId];
               this.addCommand(name, "skill", true, stypeId);
            }
         }
      };
   }

})(this);
