/*
 * --------------------------------------------------
 * 深淵の森３専用プラグイン
 * --------------------------------------------------
 */
 /*:
 * @target MZ
 * @plugindesc 深淵の森３専用プラグイン
 * @author ALEN（仮）
 *
 * @help
 * 深淵の森３専用プラグイン
 */ 

(() => {

    //--------------------------------------------------
    // 定数設定
    //--------------------------------------------------
    // 画像素材の名前
    const PICT_PATH				= "img/menuC/";		// 画像ファイル格納フォルダ
    const PICT_FRONT_NAME		= "skill_bg";		// 前景の画像ファイル名

    //--------------------------------------------------
    // 変数設定
    //--------------------------------------------------
    // 画像用Bitmapの保持
    let _bmpFront,_sprFront;
//    let _bmpCharactor,_sprCharactor;

    //***************************************************
    //   スキルコマンド
    //***************************************************
    Scene_Skill.prototype.create = function() {
        this.loadImageBitmap();
        Scene_ItemBase.prototype.create.call(this);
        this.createHelpWindow("skill");
        this.createSkillTypeWindow();
//        this.createStatusWindow();
        this.createItemWindow();
        this.createActorWindow();
    };

    Scene_Skill.prototype.createSkillTypeWindow = function() {
        const rect = this.skillTypeWindowRect();
        this._skillTypeWindow = new Window_SkillType(rect);
        this._skillTypeWindow.setHelpWindow(this._helpWindow);
        this._skillTypeWindow.setHandler("skill", this.commandSkill.bind(this));
        this._skillTypeWindow.setHandler("cancel", this.popScene.bind(this));
//        this._skillTypeWindow.setHandler("pagedown", this.nextActor.bind(this));
//        this._skillTypeWindow.setHandler("pageup", this.previousActor.bind(this));
        this._skillTypeWindow.opacity = 0;
        this.addWindow(this._skillTypeWindow);
    };

    Scene_Skill.prototype.createItemWindow = function() {
        const rect = this.itemWindowRect();
        this._itemWindow = new Menu_SkillList(rect);
        this._itemWindow.setHelpWindow(this._helpWindow);
//        this._itemWindow.setHandler("ok", this.onItemOk.bind(this));
        this._itemWindow.setHandler("cancel", this.onItemCancel.bind(this));
        this._skillTypeWindow.setSkillWindow(this._itemWindow);
        this._itemWindow.opacity = 0;
        this.addWindow(this._itemWindow);
    };

    Scene_Skill.prototype.createActorWindow = function() {
        const rect = this.actorWindowRect();
        this._actorWindow = new Window_MenuActor(rect);
        this._actorWindow.setHandler("ok", this.onActorOk.bind(this));
        this._actorWindow.setHandler("cancel", this.onActorCancel.bind(this));
        this._actorWindow.hide();
        this._actorWindow.deactivate();
    };

    Scene_Skill.prototype.skillTypeWindowRect = function() {
        const wx = 22;
        const wy = 120;
        const ww = 233;
        const wh = 620;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Skill.prototype.itemWindowRect = function() {
        const wx = 280;
        const wy = 120;
        const ww = Graphics.boxWidth - wx - 23;
        const wh = 682;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Skill.prototype.needsPageButtons = function() {
        return false;
    };

    Scene_Skill.prototype.refreshActor = function() {
        const actor = this.actor();
        this._skillTypeWindow.setActor(actor);
//        this._statusWindow.setActor(actor);
        this._itemWindow.setActor(actor);
    };

    // 画像準備
    Scene_Skill.prototype.loadImageBitmap = function() {
        let imgFolder;
        imgFolder = PICT_PATH;
        // 背景の読み込み
        _bmpFront = ImageManager.loadBitmap(imgFolder, PICT_FRONT_NAME, 0, false);
        //★★現在のジョブにより画像を変える
        //_bmpCharactor = ImageManager.loadBitmap(imgFolder, "menu_character01b", 0, false);
    }

    // 背景の設定
    Scene_Skill.prototype.createBackground = function() {
        // 元の背景（ぼかしたマップ）はそのまま利用
        Scene_ItemBase.prototype.createBackground.call(this);
        // 画面背景の設定
//        _sprCharactor = new Sprite(_bmpCharactor);
//        this.addChild(_sprCharactor);
        _sprFront = new Sprite(_bmpFront);
        this.addChild(_sprFront);
    };

    function Menu_SkillList() {
        this.initialize(...arguments);
    }

    Menu_SkillList.prototype = Object.create(Window_SkillList.prototype);
    Menu_SkillList.prototype.constructor = Menu_SkillList;

    Menu_SkillList.prototype.initialize = function(rect) {
        Window_SkillList.prototype.initialize.call(this, rect);
    };

    Menu_SkillList.prototype.drawItem = function(index) {
        const skill = this.itemAt(index);
        if (skill) {
            const costWidth = this.costWidth();
            const rect = this.itemLineRect(index);
            this.changePaintOpacity(true);
            this.drawItemName(skill, rect.x, rect.y, rect.width - costWidth);
            this.drawSkillCost(skill, rect.x, rect.y, rect.width);
            this.changePaintOpacity(1);
        }
    };

})();