/*
 * --------------------------------------------------
 * 深淵の森３専用プラグイン
 * --------------------------------------------------
 */
/*:
* @target MZ
* @plugindesc 深淵の森３専用プラグイン
* @author ALEN（仮）
* @url 
*
* @help
* 深淵の森３専用プラグイン
* 
* @param MenuUseItemText
* @text 「使用する」選択肢文言
* @type text
* @default 使う
* @desc アイテム使用時に表示する確認ダイアログの「使用する」側の文言。
* 
* @param MenuCancelItemText
* @text 「やめる」選択肢文言
* @type text
* @default やめる
* @desc アイテム使用時に表示する確認ダイアログの「使用しない」側の文言。
* 
* @param LearnMagicSEName
* @text 「魔法を覚える」サウンドエフェクト
* @type text
* @default Item3
* @desc 魔導書を使用して魔法を覚えるときに流れる音
* 
* @param MergeMagicSEName
* @text 「魔法を合成する」サウンドエフェクト
* @type text
* @default Item3
* @desc 魔導書を使用して上級魔導書を合成するときに流れる音
* 
* @param LearnMagicMessage
* @text 魔法習得メッセージ
* @type text
* @default $MagicName$を覚えた！
* @desc 魔導書を使用して魔法を習得した場合のメッセージ
* 
* @param MergeMagicMessage
* @text 魔導書合成メッセージ
* @type text
* @default $MergeName$を手に入れた！
* @desc 魔導書を合成して上位魔導書を手に入れた場合のメッセージ
* 
* @param IsLearningMagicMessage
* @text 魔法習得済みメッセージ
* @type text
* @default $MagicName$はもう覚えてるんですが
* @desc 魔導書を使用時にすでに対象魔法を習得している場合のメッセージ
* 
* @param FullQuantityItemMessage
* @text 魔導書フル数量時メッセージ
* @type text
* @default $MergeName$はもう持てませんよぉ
* @desc 合成する魔導書を99個持っている場合のメッセージ
*/

const FOTAItemWindowPluginName = document.currentScript.src.match(/^.*\/(.+)\.js$/)[1];

(() => {

    let parameters = PluginManager.parameters(FOTAItemWindowPluginName);
    const MenuUseItemText = String(parameters['MenuUseItemText'] || "使う");
    const MenuCancelItemText = String(parameters['MenuCancelItemText'] || "やめる");
    const LearnMagicSEName = String(parameters['LearnMagicSEName'] || "Item3");
    const MergeMagicSEName = String(parameters['MergeMagicSEName'] || "Item3");
    const LearnMagicMessage = String(parameters['LearnMagicMessage'] || "$MagicName$を覚えた！");
    const MergeMagicMessage = String(parameters['MergeMagicMessage'] || "$MergeName$を手に入れた！");
    const IsLearningMagicMessage = String(parameters['IsLearningMagicMessage'] || "$MagicName$はもう覚えてるんですが");
    const FullQuantityItemMessage = String(parameters['FullQuantityItemMessage'] || "$MergeName$はもう持てませんよぉ");
    let MenuLearnMagicText = "";
    let MenuMergeMagicText = "";
    let commandSelect = 0;

    let chkwin = null;

    //--------------------------------------------------
    // 定数設定
    //--------------------------------------------------
    // 画像素材の名前
    const PICT_PATH				= "img/menuC/";		// 画像ファイル格納フォルダ
//    const PICT_BACK_NAME		= "menu_bg02";		// 背景の画像ファイル名
    const PICT_FRONT_NAME		= "item_bg";		// 前景の画像ファイル名
	const PICT_CHARACTER_NAME	= "menu_character";	// キャラクーの画像ファイル名（ジョブ番号前まで
	const PICT_CHARACTER_TRAIL	= "b";				// アイテム用キャラクター画像の末尾（ジョブ番号以降

    //--------------------------------------------------
    // 変数設定
    //--------------------------------------------------
    // 画像用Bitmapの保持
    //    let _bmpBack,_sprBack;
    let _bmpFront,_sprFront;
    let _bmpCharactor,_sprCharactor;

    //***************************************************
    //   アイテムコマンド
    //***************************************************
    Scene_Item.prototype.create = function() {
        this.loadImageBitmap();
        Scene_ItemBase.prototype.create.call(this);
        this.createHelpWindow("item");
        this.createCategoryWindow();
        this.createItemWindow();
        this.createItemActorWindow();
        this.createStatusParamsWindow();
        //2024/12/07 ADD Start
        //ツクール標準のメッセージが画面下部にも表示されるので消す
        this._messageWindow.hide();
        //2024/12/07 ADD End
    };

    // 画像準備
    Scene_Item.prototype.loadImageBitmap = function() {
        let imgFolder;
        imgFolder = PICT_PATH;
        // 背景の読み込み
        //        _bmpBack = ImageManager.loadBitmap(imgFolder, PICT_BACK_NAME, 0, false);
        _bmpFront = ImageManager.loadBitmap(imgFolder, PICT_FRONT_NAME, 0, false);
        //★★現在のジョブにより画像を変える
        let tmpImgName = PICT_CHARACTER_NAME + ('0' + $gameParty.members()[0]._classId).slice(-2) + PICT_CHARACTER_TRAIL;
        _bmpCharactor = ImageManager.loadBitmap(imgFolder, tmpImgName, 0, false);
    };

    // 2025/09/26 使用するカテゴリーウィンドウをカスタマイズ @柊菜緒
    const Scene_Item_createCategoryWindow = Scene_Item.prototype.createCategoryWindow;
    Scene_Item.prototype.createCategoryWindow = function () {
        if (this.constructor.name === 'Scene_Item') {
            const rect = this.categoryWindowRect();
            this._categoryWindow = new Window_ItemCategory(rect);
            this._categoryWindow.setHelpWindow(this._helpWindow);
            this._categoryWindow.setHandler("ok", this.onCategoryOk.bind(this));
            this._categoryWindow.setHandler("cancel", this.popScene.bind(this));
            // this.addWindow(this._categoryWindow);

            const rect2 = this.itemCategoryWindowRect();
            this._itemCategoryWindow = new Window_MenuItemCategory(rect2);
            this._itemCategoryWindow.setHelpWindow(this._helpWindow);
            this._itemCategoryWindow.setHandler("ok", this.onCategoryOk.bind(this));
            this._itemCategoryWindow.setHandler("cancel", this.popScene.bind(this));
            this._itemCategoryWindow.opacity = 0;
            this.addWindow(this._itemCategoryWindow);
        }else{
            Scene_Item_createCategoryWindow.call(this);
        }
    };

    Scene_Item.prototype.itemCategoryWindowRect = function () {
        const rect = this.categoryWindowRect();
        rect.x = 22;
        rect.y = 120;
        rect.width = 554;
        return rect;
    };

    const Scene_Item_onItemCancel = Scene_Item.prototype.onItemCancel;
    Scene_Item.prototype.onItemCancel = function () {
        if (this.constructor.name === 'Scene_Item') {
            if (this._itemCategoryWindow.needsSelection()) {
                this._itemWindow.deselect();
                this._itemCategoryWindow.activate();
            } else {
                this.popScene();
            }
        }else{
            Scene_Item_onItemCancel.call(this);
        }
    };
    // 2025/09/26 ここまで

    Scene_Item.prototype.createItemWindow = function() {
        const rect = this.itemWindowRect();
        this._itemWindow = new Window_MenuItemList(rect);
        this._itemWindow.setHelpWindow(this._helpWindow);
        this._itemWindow.setHandler("ok", this.onItemOk.bind(this));
        this._itemWindow.setHandler("cancel", this.onItemCancel.bind(this));
        this._itemWindow.opacity = 0;
        this.addWindow(this._itemWindow);
        this._categoryWindow.setItemWindow(this._itemWindow);
        if (this.constructor.name === 'Scene_Item') {
            // 2025/09/26 独自のカテゴリーウィンドウを使用 @柊菜緒
            this._itemCategoryWindow.setItemWindow(this._itemWindow);
            if (!this._itemCategoryWindow.needsSelection()) {
                // カテゴリーウィンドウの高さは68px
                // this._itemWindow.y -= this._categoryWindow.height;
                // this._itemWindow.height += this._categoryWindow.height;
                this._itemWindow.createContents();
                this._itemCategoryWindow.update();
                this._itemCategoryWindow.hide();
                this._itemCategoryWindow.deactivate();
                this.onCategoryOk();
            }
            if (!this._categoryWindow.needsSelection()) {
                // カテゴリーウィンドウの高さは68px
                // this._itemWindow.y -= this._categoryWindow.height;
                // this._itemWindow.height += this._categoryWindow.height;
                // this._itemWindow.createContents();
                this._categoryWindow.update();
                this._categoryWindow.hide();
                this._categoryWindow.deactivate();
                // this.onCategoryOk();
            }
            // 2025/09/26 ここまで
        } else {
            if (!this._categoryWindow.needsSelection()) {
                this._itemWindow.y -= this._categoryWindow.height;
                this._itemWindow.height += this._categoryWindow.height;
                this._itemWindow.createContents();
                this._categoryWindow.update();
                this._categoryWindow.hide();
                this._categoryWindow.deactivate();
                this.onCategoryOk();
            }
        }
    };

    Scene_Item.prototype.itemWindowRect = function() {
        // 2025/09/28 表示位置調整 @柊菜緒
        const wx = 22;
        const wy = 194; // 190から変更
        const ww = 870;
        const wh = 596; // 610から変更
        // 2025/09/28 ここまで
        return new Rectangle(wx, wy, ww, wh);
    };

    // 背景の設定
    Scene_Item.prototype.createBackground = function() {
        // 元の背景（ぼかしたマップ）はそのまま利用
        Scene_ItemBase.prototype.createBackground.call(this);
        // 画面背景の設定
        //        _sprBack = new Sprite(_bmpBack);
        //        this.addChild(_sprBack);
        _sprCharactor = new Sprite(_bmpCharactor);
        this.addChild(_sprCharactor);
        _sprFront = new Sprite(_bmpFront);
        this.addChild(_sprFront);
    };

    Scene_Item.prototype.onItemOk = function() {
        let chkMagic = false;
        let chkMerge = false;
        commandSelect = 0;

        // 2024/07/24 effects[0]が無くてエラーが出ることがある場合の対策
        //        if (this.item().effects[0].code == Game_Action.EFFECT_LEARN_SKILL) {	//アイテムが魔法取得タイプ
        if (this.item().effects[0] && this.item().effects[0].code == Game_Action.EFFECT_LEARN_SKILL) {	//アイテムが魔法取得タイプ
            // 2024/07/24 ここまで
            chkMagic = true;
            if (this.item().meta["merge"]) {						//合成先の設定タグがある場合
                if ($gameParty.numItems(this.item()) >= 5) {		//魔導書の所持数が5以上の場合
                    chkMerge = true;
                }
            }
        }
        const rect = this.ItemConfirmRect(chkMagic, chkMerge);
        MenuLearnMagicText = "";
        MenuMergeMagicText = "";
        if (chkMagic) {
            MenuLearnMagicText = $dataSkills[+this.item().effects[0].dataId].name;
            if (chkMerge) {
                MenuMergeMagicText = $dataItems[+this.item().meta["merge"]].name;
            }
            this._commandWindow = new Window_MergeMagicConfirm(rect);
            this._commandWindow.setHandler("mergemagic", this.commandUseItem.bind(this, 3));
            this._commandWindow.setHandler("useitem", this.commandUseItem.bind(this, 2));
        } else {
            this._commandWindow = new Window_ItemConfirm(rect);
            this._commandWindow.setHandler("useitem", this.commandUseItem.bind(this, 1));
        }
        this._commandWindow.setHandler("cancel", this.commandUseItem.bind(this, 0));
        this.addWindow(this._commandWindow);
        //        $gameParty.setLastItem(this.item());
        //        this.determineItem();
    };

    Scene_Item.prototype.ItemConfirmRect = function(chkMagic, chkMarge) {
        const ww = chkMagic ? this.mainCommandWidth() * 2 :this.mainCommandWidth();
        const wh = this.calcWindowHeight(chkMarge ? 3 : 2, true);
        const wx = (Graphics.boxWidth - ww) / 2;
        const wy = (Graphics.boxHeight - wh) / 2;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Item.prototype.commandUseItem = function(useSelect) {
        this._commandWindow.hide();
        this.removeChild(this._commandWindow);
        if (useSelect) {
            commandSelect = useSelect;
            Scene_Item.prototype.useItem.call(this);
            this._itemWindow.refresh();
        } else {
            this._itemWindow.activate();
        }
        // 2024/10/26 アイテム消費時のヘルプ表示対策 変更者:柊菜緒
        const maxItems = this._itemWindow.maxItems();
        const index = this._itemWindow.index();
        if (index < maxItems) {
            this._itemWindow.select(index);
        } else {
            this._itemWindow.select(maxItems - 1);
        }
        // 2024/10/26 ここまで
    };

    //***************************************************
    //   アクターウインドウ
    //***************************************************
    Scene_Item.prototype.createItemActorWindow = function() {
        const rect = this.itemActorWindowRect();
        this._actorWindow = new Window_ItemActor(rect);
        this._actorWindow.setActor(this.actor());
        this._actorWindow.opacity = 0;
        this.addWindow(this._actorWindow);
    };

    Scene_Item.prototype.itemActorWindowRect = function() {
        const wx = 918;
        const wy = 285;
        const ww = 340;
        const wh = 115;
        return new Rectangle(wx, wy, ww, wh);
    };

    //   表示項目調整
    function Window_ItemActor() {
        this.initialize(...arguments);
    }

    Window_ItemActor.prototype = Object.create(Window_Status.prototype);
    Window_ItemActor.prototype.constructor = Window_ItemActor;

    Window_ItemActor.prototype.initialize = function(rect) {
        Window_StatusBase.prototype.initialize.call(this, rect);
    };

    Window_ItemActor.prototype.refresh = function() {
        Window_StatusBase.prototype.refresh.call(this);
        if (this._actor) {
            this.drawBlock1();
        }
    };

    Window_ItemActor.prototype.drawBlock1 = function() {
        this.drawActorName(this._actor, 6, 6, 168);
        this.drawActorClass(this._actor, 36, 57, 168);
        this.drawActorClassLevel(this._actor, 240, 57);
    };

    Window_StatusBase.prototype.drawActorName = function(actor, x, y, width) {
        width = width || 168;
        this.changeMenuTextColor(ColorManager.hpColor(actor));
        this.drawText(actor.name(), x, y, width);
    };

    Window_ItemActor.prototype.drawActorClass = function(actor, x, y, width) {
        width = width || 168;
        this.resetMenuTextColor();
        this.drawText(actor.currentClass().name, x, y, width);
    };

    Window_ItemActor.prototype.drawActorClassLevel = function(actor, x, y) {
        this.changeMenuTextColor(ColorManager.systemColor());
        this.drawText("Lv", x, y, 36);
        this.resetMenuTextColor();
        this.drawText(actor.level, x + 36, y, 36, "right");
    };

    Window_Base.prototype.changeMenuTextColor = function(color) {
        this.contents.textColor = color;
        this.changeOutlineColor("#006699");
    	this.outlineWidth = 9;
    };

    Window_Base.prototype.resetMenuTextColor = function() {
        this.changeTextColor(ColorManager.normalColor());
        this.changeOutlineColor("#006699");
    	this.outlineWidth = 9;
    };

    //***************************************************
    //   ステータスウインドウ
    //***************************************************
    Scene_Item.prototype.createStatusParamsWindow = function() {
        const rect = this.statusParamsWindowRect();
        this._statusParamsWindow = new Window_ItemStatusParams(rect);
        this._statusParamsWindow.setActor(this.actor());
        this._statusParamsWindow.opacity = 0;
        this.addWindow(this._statusParamsWindow);

        // IdiotException add↓
        // アイテムウィンドウ側から呼び出せるようにセット
        this._itemWindow.setStatusParamsWindow(this._statusParamsWindow);

        // ステータスウィンドウを更新
        this._statusParamsWindow.updateStatusParams(this._itemWindow.item());
        // IdiotException add↑
    };

    Scene_Item.prototype.statusParamsWindowRect = function() {
        const ww = 332;
        const wh = 370;
        const wx = 938;
        const wy = 428;
        return new Rectangle(wx, wy, ww, wh);
    };

    //   表示項目調整
    function Window_ItemStatusParams() {
        this.initialize(...arguments);
    }

    Window_ItemStatusParams.prototype = Object.create(Window_StatusParams.prototype);
    Window_ItemStatusParams.prototype.constructor = Window_StatusParams;

    Window_ItemStatusParams.prototype.initialize = function(rect) {
        Window_StatusParams.prototype.initialize.call(this, rect);
        this._actor = null;
        this._tmpActor = null;      // IdiotException add
    };

    Window_ItemStatusParams.prototype.itemHeight = function() {
        return this.lineHeight() - 3;
    };

    Window_ItemStatusParams.prototype.drawItem = function(index) {
        let rect;
        //先頭のステータスの前にHPとMPを追加
        if (index == 0) {
            for (let i = 0; i <= 1; i++) {
                rect = this.itemLineRect(i);
                this.changeMenuTextColor(ColorManager.systemColor());
                this.drawText(i == 0 ? TextManager.hp : TextManager.mp, rect.x, rect.y, 160);
                this.resetMenuTextColor();
                // this.drawText(i == 0 ? $gameParty.members()[0].mhp : $gameParty.members()[0].mmp, rect.x + 160, rect.y, 60, "right"); // IdiotException del
                // IdiotException add ↓
                if (this._tmpActor && ((i == 0 && $gameParty.members()[0].mhp != this._tmpActor.mhp) 
                                        || (i != 0 && $gameParty.members()[0].mmp != this._tmpActor.mmp))){
                    // パラメータに差がある場合、文字色変更と仮アクターのステータス表示
                    const tmpValue = (i == 0 ? this._tmpActor.mhp : this._tmpActor.mmp);
                    this.changeMenuTextColor("#ffff00");
                    this.drawText(tmpValue, rect.x + 160, rect.y, 60, "right");
                    this.resetMenuTextColor();
                } else {
                    // 元の処理
                    this.drawText(i == 0 ? $gameParty.members()[0].mhp : $gameParty.members()[0].mmp, rect.x + 160, rect.y, 60, "right");
                }
                // IdiotException add ↑
            }
        }
        rect = this.itemLineRect(index + 2);
        const paramId = index + 2;
        const name = TextManager.param(paramId);
        const value = this._actor.param(paramId);
        this.changeMenuTextColor(ColorManager.systemColor());
        this.drawText(name, rect.x, rect.y, 160);
        this.resetMenuTextColor();
        // this.drawText(value, rect.x + 160, rect.y, 60, "right");  // IdiotException del
        // IdiotException add ↓
        if (this._tmpActor && value != this._tmpActor.param(paramId)){
            // パラメータに差がある場合、文字色変更と仮アクターのステータス表示
            const tmpValue = this._tmpActor.param(paramId);
            this.changeMenuTextColor("#ffff00");
            this.drawText(tmpValue, rect.x + 160, rect.y, 60, "right");
            this.resetMenuTextColor();
        } else {
            // 元の処理
            this.drawText(value, rect.x + 160, rect.y, 60, "right");
        }
        // IdiotException add ↑
    };

    // IdiotException add↓
    // ステータスの表示を更新する処理
    Window_ItemStatusParams.prototype.updateStatusParams = function(targetItem) {

        // アクターをコピーしてアイテム適用後のステータス取得用仮アクターを作成
        this._tmpActor = JsonEx.makeDeepCopy(this._actor);

        if (targetItem && targetItem.effects) {        //2024/12/16 ADD アイテムがない場合は処理なし
            // 現在のアイテムが持つ効果一覧より処理を行う
            for (const effect of targetItem.effects) {
                // パラメータアップ効果の場合に仮アクターに適用
                if(effect.code == Game_Action.EFFECT_GROW){
                    this._tmpActor.addParam(effect.dataId, Math.floor(effect.value1));
                }
            }
        }                                              //2024/12/16 ADD

        // 表示を更新
        this.refresh();
    };
    // IdiotException add↑

    //***************************************************
    //   アイテム描画時
    //***************************************************
    function Window_MenuItemList() {
        this.initialize(...arguments);
    }

    Window_MenuItemList.prototype = Object.create(Window_ItemList.prototype);
    Window_MenuItemList.prototype.constructor = Window_MenuItemList;

	Window_MenuItemList.prototype.initialize = function(rect) {
        Window_ItemList.prototype.initialize.call(this, rect);
        // 2025/09/25 アイテムカテゴリーを初期化 @柊菜緒
        this._categoryIndex = -1;
        // 2025/09/25 ここまで
    };

    // 2025/09/25 指定カテゴリーのアイテムを抽出 @柊菜緒
    const Window_MenuItemList_makeItemList = Window_ItemList.prototype.makeItemList;
    Window_MenuItemList.prototype.makeItemList = function () {
        const data = $gameParty.allItems().filter(item => this.includes(item));
        if (this._categoryIndex >= 0) {
            // アイテムのカテゴリでフィルター
            this._data = data.filter(item => item.meta.categoryName === categories[this._categoryIndex]);
        } else {
            this._data = data;
        }
        if (this.includes(null)) {
            this._data.push(null);
        }
    };
    // 2025/09/25 ここまで

    // 2025/09/26 カテゴリーインデックスを指定する関数を追加 @柊菜緒
    Window_MenuItemList.prototype.setCategoryIndex = function (index) {
        if (this._categoryIndex !== index) {
            this._categoryIndex = index;
            this.refresh();
            this.scrollTo(0, 0);
        }
    };
    // 2025/09/26 ここまで

    Window_MenuItemList.prototype.drawItem = function(index) {
        const item = this.itemAt(index);
        if (item) {
            const numberWidth = this.numberWidth();
            const rect = this.itemLineRect(index);
            if (this.isEnabled(item)) {
                this.contents.paintOpacity = 255;			// 使用可アイテムの明るさ
                //                this._contentsBackSprite.alpha = 0;
            } else {
                this.contents.paintOpacity = 255;			// 使用不可アイテムの明るさ
                //                this._contentsBackSprite.alpha = 200;
            }
            this.drawItemName(item, rect.x - 5, rect.y, rect.width - numberWidth);
            this.drawItemNumber(item, rect.x + 5, rect.y, rect.width);
            this.changePaintOpacity(1);
        }
    };

    Window_MenuItemList.prototype.drawItemNumber = function(item, x, y, width) {
        if (this.needsNumber()) {
            this.drawText("", x, y, width - this.textWidth("00"), "right");
            this.drawText($gameParty.numItems(item), x, y, width, "right");
        }
    };

    // IdiotException add↓
    // ステータスウィンドウを更新できるよう保持
    Window_MenuItemList.prototype.setStatusParamsWindow = function(statusParamsWindow) {
        this._statusParamsWindow = statusParamsWindow;
    };

    // ヘルプの更新時にステータスウィンドウも更新
    Window_MenuItemList.prototype.updateHelp = function() {
        this.setHelpWindowItem(this.item());    // こっちはもともとの処理
        // 以下追加の処理
        if(this._statusParamsWindow){
            this._statusParamsWindow.updateStatusParams(this.item());
        }
    };
    // IdiotException add↑

    //***************************************************
    //   カテゴリーウインドウ
    //***************************************************
    // 2025/09/26 カテゴリーウィンドウをカスタマイズ @柊菜緒
    function Window_MenuItemCategory() {
        this.initialize(...arguments);
    }

    Window_MenuItemCategory.prototype = Object.create(Window_ItemCategory.prototype);
    Window_MenuItemCategory.prototype.constructor = Window_MenuItemCategory;

    Window_MenuItemCategory.prototype.initialize = function (rect) {
        Window_ItemCategory.prototype.initialize.call(this, rect);
    };

    const Window_MenuItemCategory_makeCommandList = Window_ItemCategory.prototype.makeCommandList;
    Window_MenuItemCategory.prototype.makeCommandList = function () {
        // 潔く普通のカテゴリーは消す
        // Window_ItemCategory.prototype.makeCommandList.call(this);
        // アイテムデータベースで追加したカテゴリーを追加
        categories.forEach(name => {
            this.addCommand(name, name);
        });
    };

    Window_MenuItemCategory.prototype.update = function () {
        Window_HorzCommand.prototype.update.call(this);
        if (this._itemWindow) {
            this._itemWindow.setCategoryIndex(this.index());
        }
    };

    Window_MenuItemCategory.prototype.maxCols = function () {
        return 3;
    };

    Window_MenuItemCategory.prototype.drawItem = function (index) {
        const rect = this.itemLineRect(index);
        const align = this.itemTextAlign();
        this.resetMenuTextColor();
        this.changePaintOpacity(this.isCommandEnabled(index));
        this.drawText(this.commandName(index), rect.x, rect.y, rect.width, align);
    };
    // 2025/09/26 ここまで

    //***************************************************
    //   使用確認ウインドウ
    //***************************************************
    function Window_ItemConfirm() {
        this.initialize(...arguments);
    }

    Window_ItemConfirm.prototype = Object.create(Window_Command.prototype);
    Window_ItemConfirm.prototype.constructor = Window_ItemConfirm;

	Window_ItemConfirm.prototype.initialize = function(rect) {
        Window_Command.prototype.initialize.call(this, rect);
        this.selectSymbol("cancel");
    };

    Window_ItemConfirm.prototype.makeCommandList = function() {
        this.addCommand(MenuUseItemText, "useitem");
        this.addCommand(MenuCancelItemText, "cancel");
    };

    //***************************************************
    //   魔法合成確認ウインドウ
    //***************************************************
    function Window_MergeMagicConfirm() {
        this.initialize(...arguments);
    }

    Window_MergeMagicConfirm.prototype = Object.create(Window_Command.prototype);
    Window_MergeMagicConfirm.prototype.constructor = Window_MergeMagicConfirm;

	Window_MergeMagicConfirm.prototype.initialize = function(rect) {
	    Window_Command.prototype.initialize.call(this, rect);
        this.selectSymbol("cancel");
	};

    Window_MergeMagicConfirm.prototype.makeCommandList = function() {
        this.addCommand(MenuLearnMagicText + "を習得する", "useitem");
        if (MenuMergeMagicText != "") {
            this.addCommand(MenuMergeMagicText + "を合成する", "mergemagic");
        }
        this.addCommand(MenuCancelItemText, "cancel");
    };

    //***************************************************
    //   アイテム使用時
    //***************************************************
/*    Scene_ItemBase.prototype.determineItem = function() {
        const action = new Game_Action(this.user());
        const item = this.item();
        action.setItemObject(item);
        this.useItem();
        this.activateItemWindow();
        this._statusParamsWindow.refresh();
    };
*/
    Scene_ItemBase.prototype.useItem = function() {
        var dispMessage = "";
        switch(commandSelect) {
            case 1:
                // IdiotException add 2025/12/14↓
                // レベルアップアイテムはレベル上限の場合専用メッセージ＆アイテム不使用
                if (this.item().meta["MaxLvMessage"] && this._actor.isMaxLevel()) {
                    SoundManager.playBuzzer();
                    dispMessage = "\\>" + this.item().meta["MaxLvMessage"];
                    commandSelect = 4;
                    break;
                }
                // IdiotException add 2025/12/14↑

                //通常アイテム使用時
		        this.playSeForItem();
		        this.user().useItem(this.item());
                this.applyItem();

                //2024/12/07 ADD Start
                //commoneventのタグがある場合はコモンイベントを実行する。
                if (this.item().meta["commonevent"]) {
                    if ($gameTemp._menuCommonEvent &&
                        $gameTemp._menuCommonEvent["Scene_Item"] &&
                        $gameTemp._menuCommonEvent["Scene_Item"]._interpreter) {
                        $gameTemp.reserveCommonEvent(+this.item().meta["commonevent"]);
                        $gameTemp._menuCommonEvent["Scene_Item"]._interpreter.setupReservedCommonEvent() ;                   }
                }
                //messageのタグがある場合にメッセージを表示する。
                if (this.item().meta["message"]) {
                    dispMessage = "\\>" + this.item().meta["message"];
                    commandSelect = 4;
                }
                //2024/12/07 ADD End
                break;
            case 2:
                //魔導書使用時
                if(this._actor.isLearnedSkill(+this.item().effects[0].dataId)){
                    dispMessage = "\\>" + IsLearningMagicMessage.replace("$MagicName$", MenuLearnMagicText);
                } else {
		            AudioManager.playSe({"name":LearnMagicSEName,"volume":100,"pitch":100,"pan":0});
		            this.user().useItem(this.item());
                    this.applyItem();
                    dispMessage = "\\>" + LearnMagicMessage.replace("$MagicName$", MenuLearnMagicText);
                }
                break;
            case 3:
                //魔導書合成時
                if ($gameParty.numItems($dataItems[+this.item().meta["merge"]]) >= $gameParty.maxItems(this.item())) {	//魔導書の所持数が最大所持数以上の場合
                    dispMessage = "\\>" + FullQuantityItemMessage.replace("$MergeName$", MenuMergeMagicText);
                } else {
		            AudioManager.playSe({"name":MergeMagicSEName,"volume":100,"pitch":100,"pan":0});
		            $gameParty.gainItem($dataItems[+this.item().meta["merge"]], 1);			//合成先の魔導書を1増やす
		            $gameParty.loseItem(this.item(), 5);									//使用した魔導書を5減らす
                    dispMessage = "\\>" + MergeMagicMessage.replace("$MergeName$", MenuMergeMagicText);
                }
                break;
        }
        this.checkCommonEvent();
        this.checkGameover();
        this._actorWindow.refresh();
        this._statusParamsWindow.refresh();

        if (commandSelect == 1) {
            this._itemWindow.activate();
        } else {
        	chkwin = this._itemWindow;
            $gameMessage.add(dispMessage);
            if(this._useMessageWindow){
                this._useMessageWindow.update();
            } else {
                const rect = this.useMessageWindowRect();
                this._useMessageWindow = new Window_UseMessage(rect);
                this.addWindow(this._useMessageWindow);
            }
        }
    };

    Scene_ItemBase.prototype.itemTargetActors = function() {
        const action = new Game_Action(this.user());
        action.setItemObject(this.item());
        return [$gameParty.members()[0]];
    };

    //ダミーウインドウ枠
    Scene_ItemBase.prototype.useMessageWindowRect = function() {
        const ww = Graphics.boxWidth;
        const wh = 100;
        const wx = 0;
        const wy = 0;
        return new Rectangle(wx, wy, ww, wh);
    };

    //***************************************************
    //   アイテム使用メッセージ
    //***************************************************
    function Window_UseMessage() {
        this.initialize(...arguments);
    }

    Window_UseMessage.prototype = Object.create(Window_Message.prototype);
    Window_UseMessage.prototype.constructor = Window_UseMessage;

    Window_UseMessage.prototype.initialize = function(rect) {
        Window_Message.prototype.initialize.call(this, rect);
    };

    Window_UseMessage.prototype.initMembers = function() {
        this._background = 0;
        this._positionType = 2;
        this._waitCount = 0;
        this._textState = null;
        this.clearFlags();
    };

    Window_UseMessage.prototype.update = function() {
        this.checkToNotClose();
        Window_Base.prototype.update.call(this);
        while (!this.isOpening() && !this.isClosing()) {
            if (this.updateWait()) {
                return;
            } else if (this.updateInput()) {
                return;
            } else if (this.updateMessage()) {
                return;
            } else if (this.canStart()) {
                this.startMessage();
            } else {
                this.startInput();
                return;
            }
        }
    };

    Window_UseMessage.prototype.startMessage = function() {
        const text = $gameMessage.allText();
        const rect = this.useMessageWindowRect(text);
        this.move(rect.x, rect.y, rect.width, rect.height);
        const textState = this.createTextState(text, 0, 0, 0);
        textState.x = this.newLineX(textState) + 35;
        textState.startX = textState.x;
        this._textState = textState;
        this.newPage(this._textState);
        this.open();
    };

    Window_UseMessage.prototype.newLineX = function(textState) {
        const faceExists = $gameMessage.faceName() !== "";
        const faceWidth = 0;
        const spacing = 20;
        const margin = faceExists ? faceWidth + spacing : 4;
        return textState.rtl ? this.innerWidth - margin : margin;
    };

    Window_UseMessage.prototype.useMessageWindowRect = function(text) {
        const wx = (Graphics.boxWidth - this.textSizeEx(text).width - 100) / 2;
        const wy = (Graphics.boxHeight - this.textSizeEx(text).height - 26) / 2;
        const ww = this.textSizeEx(text).width + 100;
        const wh = this.textSizeEx(text).height + 26;
        return new Rectangle(wx, wy, ww, wh);
    };

    Window_UseMessage.prototype.terminateMessage = function() {
        chkwin.activate();
        this.close();
        $gameMessage.clear();
    };

    Window_UseMessage.prototype.updateInput = function() {
        if (this.pause) {
            if (this.isTriggered()) {
                Input.update();
                this.pause = false;
                if (!this._textState) {
                    this.terminateMessage();
                }
            }
            return true;
        }
        return false;
    };

    Window_UseMessage.prototype.isTriggered = function() {
        return (
            // 2024/07/24 アイテム一覧再クリック問題対策
//          Input.isRepeated("ok") ||
//          Input.isRepeated("cancel") ||
//          TouchInput.isRepeated()
            Input.isTriggered("ok") ||
            Input.isTriggered("cancel") ||
            TouchInput.isClicked() ||
            TouchInput.isCancelled()
            // 2024/07/24 ここまで
        );
    };

    Window_UseMessage.prototype.newPage = function(textState) {
        this.contents.clear();
        this.resetFontSettings();
        this.clearFlags();
        textState.x = textState.startX;
        textState.y = 0;
        textState.height = this.calcTextHeight(textState);
    };

    //2024/11/11 Start 競合よけのためrmmz_windowsより移植
    Window_UseMessage.prototype.initialize = function(rect) {
        Window_Base.prototype.initialize.call(this, rect);
        this.openness = 0;
        this.initMembers();
    };

    Window_UseMessage.prototype.onEndOfText = function() {
        if (!this.startInput()) {
            if (!this._pauseSkip) {
                this.startPause();
            } else {
                this.terminateMessage();
            }
        }
        this._textState = null;
    };

    Window_UseMessage.prototype.startInput = function() {
        if ($gameMessage.isChoice()) {
            this._choiceListWindow.start();
            return true;
        } else if ($gameMessage.isNumberInput()) {
            this._numberInputWindow.start();
            return true;
        } else if ($gameMessage.isItemChoice()) {
            this._eventItemWindow.start();
            return true;
        } else {
            return false;
        }
    };
    //2024/11/11 End 競合よけのためrmmz_windowsより移植

    //★★以下共通
    //***************************************************
    //   ヘルプウインドウ
    //***************************************************
    Scene_MenuBase.prototype.createHelpWindow = function(type) {
        const rect = this.helpWindowRect(type);
        this._helpWindow = new Window_Help(rect);
        this._helpWindow.opacity = 0;
        this.addWindow(this._helpWindow);
    };

    Scene_MenuBase.prototype.helpWindowRect = function(type) {
        var wx = 0;
        var wy = this.helpAreaTop();
        var ww = Graphics.boxWidth;
        var wh = this.helpAreaHeight();

        if (type) {
            switch (type) {
                case "item":
                case "skill":
                    wx = 22;
                    wy = this.helpAreaTop() - 34;
                    ww = 1225;
                    wh = this.helpAreaHeight() + 10;
                    break;
                case "mission":
                    wx = 22;
                    wy = this.isBottomButtonMode() + 120;
                    ww = 1225;
                    wh = this.helpAreaHeight() + 75;
                    break;
            }
        }

        return new Rectangle(wx, wy, ww, wh);
    };

    //***************************************************
    //   メインメニュー項目設定
    //***************************************************
    const _Window_MenuCommand_addMainCommands = Window_MenuCommand.prototype.addMainCommands;
    Window_MenuCommand.prototype.addMainCommands = function() {
        // 元処理実行
        _Window_MenuCommand_addMainCommands.call(this);

        // 指定位置に転職コマンドを挿入
        // ※標準では装備の下
        this._list.splice(5, 0,
            { name: "ミッション", symbol: "mission", enabled: true, ext: null});
    };

    const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
    Scene_Menu.prototype.createCommandWindow = function() {
        // 元処理実行
        _Scene_Menu_createCommandWindow.call(this);

        // コマンド追加（アクター選択）
        this._commandWindow.setHandler("mission", this.commandMission.bind(this));
    };

    //***************************************************
    //   Scene_Bootでカテゴリーデータを自動付与する処理
    //***************************************************
    // 2025/09/25 $dataItemからカテゴリーリストを生成 @柊菜緒
    const categories = []; // カテゴリー管理用の配列
    const PatternCatName = /\[(.+)\]\[category\]/; // カテゴリー名抽出用の正規表現
    const Scene_Boot_start = Scene_Boot.prototype.start;
    Scene_Boot.prototype.start = function () {
        this.initCatList();
        Scene_Boot_start.call(this);
    };

    Scene_Boot.prototype.initCatList = function () {
        let categoryName = 'default';

        $dataItems.forEach((item, index, array) => {
            if (index === 0) return;
            if (item.name.endsWith('[category]')) {
                categoryName = item.name.match(PatternCatName)[1];

            }
            let existingCategory = categories.includes(categoryName);
            if (!existingCategory && categoryName !== 'default') {
                categories.push(categoryName);
            }
            // メモ欄で<categoryName:カテゴリ名>で個別にカテゴリ名を指定可能
            if (!item.meta.categoryName) {
                item.meta.categoryName = categoryName;
            }
        });
    };
    // 2025/09/25 ここまで

})();