/*
 * --------------------------------------------------
 * 深淵の森３専用プラグイン
 * --------------------------------------------------
 */
 /*:
 * @target MZ
 * @plugindesc 深淵の森３専用プラグイン
 * @author ALEN（仮）
 *
 * @help
 * 深淵の森３専用プラグイン
 */ 

(() => {

	//--------------------------------------------------
	// 定数設定
	//--------------------------------------------------
	// 画像素材の名前
	const PICT_PATH				= "img/menuC/";		// 画像ファイル格納フォルダ
//	const PICT_BACK_NAME		= "menu_bg02";		// 背景の画像ファイル名
	const PICT_FRONT_NAME		= "mission_bg";		// 前景の画像ファイル名

	//--------------------------------------------------
	// 変数設定
	//--------------------------------------------------
	// 画像用Bitmapの保持
//	let _bmpBack,_sprBack;
	let _bmpFront,_sprFront;

	Scene_Menu.prototype.commandMission = function() {
	    SceneManager.push(Scene_Mission);
	};

	//***************************************************
	//   ミッションコマンド
	//***************************************************
	function Scene_Mission() {
	    this.initialize(...arguments);
	}

	Scene_Mission.prototype = Object.create(Scene_Item.prototype);
	Scene_Mission.prototype.constructor = Scene_Mission;

	Scene_Mission.prototype.initialize = function() {
	    Scene_Item.prototype.initialize.call(this);
	};

	Scene_Mission.prototype.create = function() {
	    this.loadImageBitmap();
	    Scene_ItemBase.prototype.create.call(this);
	    this.createHelpWindow("mission");
	    this.createCategoryWindow();
	    this.createItemWindow();
	};

	// 画像準備
	Scene_Mission.prototype.loadImageBitmap = function() {
	    let imgFolder;
	    imgFolder = PICT_PATH;
	    // 背景の読み込み
//	    _bmpBack = ImageManager.loadBitmap(imgFolder, PICT_BACK_NAME, 0, false);
	    _bmpFront = ImageManager.loadBitmap(imgFolder, PICT_FRONT_NAME, 0, false);
	}

	Scene_Mission.prototype.createItemWindow = function() {
	    const rect = this.itemWindowRect();
	    this._itemWindow = new Window_MissionList(rect);
	    this._itemWindow.setHelpWindow(this._helpWindow);
	    this._itemWindow.setHandler("ok", this.onItemOk.bind(this));
	    this._itemWindow.setHandler("cancel", this.onItemCancel.bind(this));
	    this._itemWindow.opacity = 0;
	    this.addWindow(this._itemWindow);
	    this._categoryWindow.setItemWindow(this._itemWindow);
	    if (!this._categoryWindow.needsSelection()) {
	//        this._itemWindow.y -= this._categoryWindow.height;
	//        this._itemWindow.height += this._categoryWindow.height;
		    this._itemWindow.setCategory("keyItem");
	        this._itemWindow.createContents();
	        this._categoryWindow.update();
	        this._categoryWindow.hide();
	        this._categoryWindow.deactivate();
	        this.onCategoryOk();
	    }
	};

	Scene_Mission.prototype.itemWindowRect = function() {
	    const wx = 22;
	    const wy = 310;
	    const ww = 1225;
	    const wh = 615;
	    return new Rectangle(wx, wy, ww, wh);
	};

	// 背景の設定
	Scene_Mission.prototype.createBackground = function() {
	    // 元の背景（ぼかしたマップ）はそのまま利用
	    Scene_ItemBase.prototype.createBackground.call(this);
	    // 画面背景の設定
//	    _sprBack = new Sprite(_bmpBack);
//	    this.addChild(_sprBack);
	    _sprFront = new Sprite(_bmpFront);
	    this.addChild(_sprFront);
	};

	function Window_MissionList() {
	    this.initialize(...arguments);
	}

	Window_MissionList.prototype = Object.create(Window_ItemList.prototype);
	Window_MissionList.prototype.constructor = Window_MissionList;

	Window_MissionList.prototype.initialize = function(rect) {
	    Window_ItemList.prototype.initialize.call(this, rect);
	};

//	デフォルトの2列表示のためコメント
//	Window_MissionList.prototype.maxCols = function() {
//	    return 3;
//	};

	Window_MissionList.prototype.includes = function(item) {
        return DataManager.isItem(item) && item.itypeId === 3;
	};

	Window_MissionList.prototype.drawItem = function(index) {
	    const item = this.itemAt(index);
	    if (item) {
	        const numberWidth = this.numberWidth();
	        const rect = this.itemLineRect(index);
	        this.changePaintOpacity(true);
	        this.drawItemName(item, rect.x, rect.y, rect.width - numberWidth);
//	        this.drawItemNumber(item, rect.x, rect.y, rect.width);		//数量出さないのでコメント
	        this.changePaintOpacity(1);
	    }
	};

})();