//=============================================================================
// HSMZ_CompatibleLayer.js
// ----------------------------------------------------------------------------
// Copyright (c) 2023 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2023/04/29 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc 一部のMVプラグインを動かすための関数実装
 * @target MZ
 * @author n2naokun(柊菜緒)
 *
 * @help MZには無い一部の関数を追加します。
 * 
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

var Imported = Imported || {};
Imported.HSMZ_CompatibleLayer = true;
// 他のプラグインとの連携用シンボル

(function (_global) {
   Bitmap.prototype._setDirty = function () {
      this._dirty = true;
   };

   Bitmap.prototype.checkDirty = function () {
      if (this._dirty) {
         this._baseTexture.update();
         this._dirty = false;
      }
   };


   Window_Base.prototype.textPadding = function () {
      const rect = this.itemRectWithPadding(0);
      const padding = (rect.height - this.lineHeight()) / 2;
      rect.y += padding;
      rect.height -= padding * 2;
      return rect.x;
   };

   const Window_Base_initialize = Window_Base.prototype.initialize;
   Window_Base.prototype.initialize = function (x, y, width, height) {
      if (arguments.length > 1) {
         Window_Base_initialize.call(this, new Rectangle(x, y, width, height));
      } else {
         Window_Base_initialize.apply(this, arguments);
      }
   };

   Window_Base.prototype.standardFontSize = function () {
      return $gameSystem.mainFontSize();
   };

   Window_Command.prototype.windowWidth = function () {
      return 240;
   };

   const Window_HorzCommand_initialize = Window_HorzCommand.prototype.initialize;
   Window_HorzCommand.prototype.initialize = function (x, y) {
      if (arguments.length > 1) {
         var width = this.windowWidth();
         var height = this.fittingHeight(this.numVisibleRows ? this.numVisibleRows() : 1);
         Window_HorzCommand_initialize.call(
            this, new Rectangle(x, y, width || Graphics.boxWidth, height || Graphics.boxHeight));
      } else {
         Window_HorzCommand_initialize.apply(this, arguments);
      }
   };



})(this);