//=============================================================================
// HSMZ_CustomIroiro.js
// ----------------------------------------------------------------------------
// Copyright (c) 2021 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.1.0 2025/05/28 オプションから言語設定を取得
// 1.0.1 2025/05/15 コモンイベントの実行関連を修正
// 1.0.0 2025/05/15 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc 多雑に痒いところに手を届かせるためのカスタムプラグイン
 * @target MZ
 * @author n2naokun(柊菜緒)
 *
 * @help 動作させるのにMenuCommonEventが必須です。
 * 
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 *
 * @param ToTitleCommonEventId
 * @text ゲームエンドコモンID
 * @desc タイトルに戻るコモンイベントID
 * @type common_event
 * @default 0
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

var Imported = Imported || {};
// 他のプラグインとの連携用シンボル

(function (_global) {
   const PluginName = "HSMZ_CustomIroiro";
   Imported[PluginName] = true;

   const params = PluginManager.parameters(PluginName);
   const ToTitleCommonEventId = Number(params['ToTitleCommonEventId'] || 0);


   Scene_GameEnd.prototype.commandToTitle = function () {
      if ($gameTemp._menuCommonEvent &&
         $gameTemp._menuCommonEvent["Scene_GameEnd"] &&
         $gameTemp._menuCommonEvent["Scene_GameEnd"]._interpreter) {
         $gameTemp.reserveCommonEvent(ToTitleCommonEventId);
         $gameTemp._menuCommonEvent["Scene_GameEnd"]._interpreter.setupReservedCommonEvent();
      }
      // this.fadeOutAll();
      // SceneManager.goto(Scene_Title);
      // Window_TitleCommand.initCommandPosition();
   };

   const Game_Variables_value = Game_Variables.prototype.value;
   Game_Variables.prototype.value = function (variableId) {
      if (variableId === 301) {
         return ConfigManager['multilingual'] || 0;
      } else {
         return Game_Variables_value.call(this, variableId);
      }
   };

})(this);
