//=============================================================================
// HSMZ_EncountBeforeCommon.js
// ----------------------------------------------------------------------------
// Copyright (c) 2021 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.1.0 2025/01/13 エンカウント前コモンイベントで敵グループIDを扱えるように変更
// 1.0.2 2024/12/28 空エンカウントでもコモンイベントが走るバグを修正
// 1.0.1 2024/12/27 エンカウント時に一歩歩ける問題の修正
// 1.0.0 2024/01/15 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc ランダムエンカウント突入前コモンイベント実行プラグイン
 * @target MZ
 * @author n2naokun(柊菜緒)
 *
 * @help プラグイン内のcommonEventIdに設定した番号のコモンイベントを
 * エンカウント前に実行できます。
 * 
 * スクリプトで$gameTemp.encountedTroopIdにアクセスすることでコモンイベント内で
 * どのIDの敵グループにエンカウントしたかを判定できます。
 * また、$gameTemp.encountedTroopIdに敵グループIDを設定することで
 * 戦闘する敵グループを強制的に上書きできます。
 * 
 * また、$gameTemp.encountedTroopIdに0をセットするか
 * $gameTemp.clearEncountedTroopId();
 * を実行することでコモンイベントを実行しつつ、エンカウントをキャンセルします。
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

var Imported = Imported || {};
// 他のプラグインとの連携用シンボル

(function (_global) {
   const PluginName = "HSMZ_EncountBeforeCommon";
   Imported[PluginName] = true;

   const commonEventId = 43;

   var encount = false;
   var encountedTroopId = 0;
   Game_Player.prototype.executeEncounter = function () {
      if (!$gameMap.isEventRunning() && (this._encounterCount <= 0)) {
         if (!encount) {
            encount = true;
            encountedTroopId = this.makeEncounterTroopId();
            Game_Character.prototype.update.call(this);
            if ($dataTroops[encountedTroopId]) {
               $gameTemp.reserveCommonEvent(commonEventId);
            }
            return false;
         }
         this.makeEncounterCount();
         encount = false;
         const troopId = encountedTroopId;
         encountedTroopId = 0;
         if ($dataTroops[troopId]) {
            BattleManager.setup(troopId, true, false);
            BattleManager.onEncounter();
            return true;
         } else {
            return false;
         }
      } else {
         return false;
      }
   };

   const Game_Player_canMove = Game_Player.prototype.canMove;
   Game_Player.prototype.canMove = function () {
      // 2024/12/28 空エンカウント時にマウス移動が停止するバグ修正
      return Game_Player_canMove.call(this) && !$dataTroops[encountedTroopId];
      // 2024/12/28 ここまで
   };

   // 2025/01/13 エンカウント前コモンイベントで敵グループIDを扱えるように変更
   const Game_Temp_initialize = Game_Temp.prototype.initialize;
   Game_Temp.prototype.initialize = function () {
      Game_Temp_initialize.call(this);
      Object.defineProperty(this, 'encountedTroopId', {
         set: function (value) {
            encountedTroopId = value;
         },
         get: function () {
            return typeof encountedTroopId === 'number' ? encountedTroopId : 0;
         }
      });
   };

   Game_Temp.prototype.clearEncountedTroopId = function () {
      encountedTroopId = 0;
   };
   // 2025/01/13 ここまで

})(this);
