//=============================================================================
// HSMZ_F5ButtonFix.js
// ----------------------------------------------------------------------------
// Copyright (c) 2021 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.1.1 2024/10/22 テスト中のみカーソル位置を表示するように変更
// 1.1.0 2024/02/17 マウスカーソル位置表示機能を追加
// 1.0.0 2024/02/01 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc VSCode空のデバッグ時にゲーム上でF5キーを押したときの動作を修正します。
 * @target MZ
 * @url 
 * @author n2naokun(柊菜緒)
 *
 * @help VSCode空のデバッグ時にゲーム上でF5キーを押したときの動作を修正します。
 * MZ標準の動作の場合F5キーを押すとデバッグセッションが途切れてしまうので、
 * 内部動作をMVと同じ動作に修正します。
 * Launch.jsonの"runtimeArgs"で"vscode"を指定する必要があります。
 * "test"を既に指定している場合は"test&vscode"を指定してください。
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

var Imported = Imported || {};
Imported.HSMZ_F5ButtonFix = true;
// 他のプラグインとの連携用シンボル

(function (_global) {
   const _SceneManager_reloadGame = SceneManager.reloadGame;
   SceneManager.reloadGame = function () {
      if (Utils.isOptionValid("test") && Utils.isOptionValid("vscode")) {
         location.reload();
      } else {
         _SceneManager_reloadGame.call(this);
      }
   };

   const _TouchInput_onHover = TouchInput._onHover;
   TouchInput._onHover = function (x, y) {
      _TouchInput_onHover.apply(this, arguments);
      if (Utils.isOptionValid("test") && $dataSystem && $dataSystem.gameTitle) {
         document.title = $dataSystem.gameTitle + '  CursorPOS (x=' + x + ' ,y=' + y + ')';
      }
   };

})(this);
