//=============================================================================
// HSMZ_PurgeEquip.js
// ----------------------------------------------------------------------------
// Copyright (c) 2021 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2024/11/25 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc 指定した装備を外します。
 * @target MZ
 * @author n2naokun(柊菜緒)
 *
 * @help 指定した装備をアクターの装備欄から外します。
 * 
 * プラグインコマンドでアクターIDと装備タイプと装備IDを指定して装備を解除できます。
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 * 
 * 
 * @command purgeEquip
 * @text 装備解除
 * @desc 指定した装備をアクターの装備欄から外します。
 * 
 * @arg actorId
 * @text アクターID
 * @desc 装備を外すアクターのIDを指定します。
 * @type number
 * @default 0
 * 
 * @arg equipType
 * @text 装備タイプ
 * @desc 武器か防具かを選択します
 * @type select
 * @option 防具
 * @value armor
 * @option 武器
 * @value weapon
 * @default armor
 * 
 * @arg itemId
 * @text 装備ID
 * @desc 装備する武器または防具のIDを指定します。
 * @type number
 * @default 0
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

var Imported = Imported || {};
// 他のプラグインとの連携用シンボル

(function (_global) {
   const PluginName = "HSMZ_PurgeEquip";
   Imported[PluginName] = true;
   // ここにプラグイン処理を記載

   PluginManager.registerCommand(PluginName, "purgeEquip", args => {
      let actor = null;
      const actorId = Number(args['actorId']);
      const type = args['equipType'];
      const itemId = Number(args['itemId']);

      if (actorId === 0 || itemId === 0) return;
      const members = $gameParty.members();
      for (let i = 0; i < members.length; i++) {
         if (members[i].actorId() === actorId) {
            actor = members[i];
            break;
         }
      }
      if (actor) {
         const equips = actor.equips();
         for (let i = 0; i < equips.length; i++) {
            if (actor._equips[i]._dataClass === type && equips[i] && equips[i].id === itemId) {
               actor.changeEquip(i, null);
               break;
            }
         }
      }
   });
})(this);
