//=============================================================================
// HSMZ_RegionMaker.js
// ----------------------------------------------------------------------------
// Copyright (c) 2021 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.1.0 2024/12/26 バグ修正と機能強化
// 1.0.0 2024/12/26 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc 指定したリージョンにプレイヤーがいる場合にプレイヤーの上に
 * 変数で指定した番号の吹き出しを表示するプラグイン
 * @target MZ
 * @author n2naokun(柊菜緒)
 *
 * @help 変数で指定したリージョンにプレイヤーがいる場合にプレイヤーの上に
 * 変数で指定した番号の吹き出しを表示します。
 * 
 * 仕様手順
 * プラグインパラメータのリージョン指定変数と吹き出し指定変数と
 * 吹き出しフレーム番号指定変数に変数番号を指定してください。
 * 
 * 上記で指定した変数にリージョン番号と吹き出し番号を指定してください。
 * 変数内の番号を変更することでイベント上でもリージョン番号と吹き出しを変更できます。
 * 吹き出しフレーム番号を0～7に設定する事で任意のフレームの吹き出しを固定で表示できます。
 * また、吹き出しフレーム番号に-1を設定すると吹き出しがアニメーションループします。
 * 
 * 吹き出し番号とフレーム番号について
 * img/systemにあるballoon.pngの内部で下記のように並んでいます。
 *   0,1,2,3,4,5,6,7
 *  1
 *  2
 *  3
 *  4
 *  5
 *  6
 *  7
 *  8
 *  9
 * 10
 * 11
 * 12
 *  .
 *  .
 *  .
 * 
 * 縦が吹き出し番号、横がフレーム番号です。
 * 吹き出し番号は1始まります。
 * フレーム番号は0～7です。
 * 
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 * 
 * @param RegionNumberVariable
 * @text リージョン指定変数
 * @desc 吹き出しを表示するリージョンの番号を格納する変数の番号を指定します。
 * @type number
 * @default 0
 * 
 * @param BalloonIdVariable
 * @text 吹き出し指定変数
 * @desc 表示する吹き出しのID番号を指定する変数番号を指定します。
 * @type number
 * @default 0
 * 
 * @param BalloonFrameVariable
 * @text 吹き出しフレーム番号変数
 * @desc 表示する吹き出しのフレーム番号(0～7)を指定する変数を指定します。
 * @type number
 * @default 0
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

var Imported = Imported || {};
// 他のプラグインとの連携用シンボル

(function (_global) {
   const PluginName = "HSMZ_RegionMaker";
   Imported[PluginName] = true;

   const params = PluginManager.parameters(PluginName);
   const regVar = Number(params["RegionNumberVariable"]) || 0;
   const balloonIdVar = Number(params["BalloonIdVariable"]) || 0;
   const balloonFrameVar = Number(params["BalloonFrameVariable"]) || 0;

   const Spriteset_Map_update = Spriteset_Map.prototype.update;
   Spriteset_Map.prototype.update = function () {
      Spriteset_Map_update.apply(this, arguments);
      const nowRegionId = $gameMap.regionId($gamePlayer.x, $gamePlayer.y);
      const regionId = $gameVariables.value(regVar);
      const balloonId = $gameVariables.value(balloonIdVar);
      // console.log(`x: ${$gamePlayer.x}, y: ${$gamePlayer.y}`);
      if (regionId > 0 && regionId === nowRegionId) {
         // マーカーを表示
         $gameTemp.requestMarker(balloonId);
      } else {
         // マーカーを削除
         $gameTemp.requestMarker(-1);
      }
   };

   Game_Temp.prototype.requestMarker = function (balloonId) {
      this._markerId = balloonId;
   };

   Game_Temp.prototype.requestedMarker = function () {
      return this._markerId || 0;
   };

   const Spriteset_Map_processBalloonRequests = Spriteset_Map.prototype.processBalloonRequests;
   Spriteset_Map.prototype.processBalloonRequests = function () {
      Spriteset_Map_processBalloonRequests.apply(this, arguments);

      const markerId = $gameTemp.requestedMarker();
      if (markerId > 0) {
         this.createMarker({ target: $gamePlayer, balloonId: markerId });
      } else if (markerId < 0 && this._markerSprite) {
         this.removeBalloon(this._markerSprite);
         this._markerSprite = null;
      }
   };

   Spriteset_Map.prototype.createMarker = function (request) {
      const targetSprite = this.findTargetSprite(request.target);
      if (targetSprite && !this._markerSprite) {
         const sprite = new Sprite_Marker();
         this._markerSprite = sprite;
         sprite.targetObject = request.target;
         sprite.setup(targetSprite, request.balloonId);
         this._effectsContainer.addChild(sprite);
         this._balloonSprites.push(sprite);
      }
   };

   function Sprite_Marker() {
      this.initialize(...arguments);
   }

   Sprite_Marker.prototype = Object.create(Sprite_Balloon.prototype);
   Sprite_Marker.prototype.constructor = Sprite_Marker;

   Sprite_Marker.prototype.isPlaying = function () {
      return true;
   };

   Sprite_Marker.prototype.update = function () {
      Sprite.prototype.update.call(this);
      if (this._balloonId !== $gameVariables.value(balloonIdVar)) {
         this._balloonId = $gameVariables.value(balloonIdVar);
      }
      if (!((this._interval || 0) > 0)) {
         if (this._duration > 0) {
            this._duration--;
            if (this._duration > 0) {
            } else {
               this._duration = 8 * this.speed() + this.waitTime();
               this._interval = 8;
            }
            this.updatePosition();
            this.updateFrame();
         }
      } else {
         this._interval--;
      }

   };

   Sprite_Marker.prototype.frameIndex = function () {
      var frameNumber = 7;
      if (balloonFrameVar > 0) {
         frameNumber = Math.min(7, Math.max(-1, $gameVariables.value(balloonFrameVar)));
      }
      return frameNumber >= 0 ? frameNumber : Sprite_Balloon.prototype.frameIndex.call(this);
   };

})(this);
