//=============================================================================
// HS_GoldWindowIcon.js
// ----------------------------------------------------------------------------
// Copyright (c) 2021 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2024/10/18 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc 金額ウィンドウアイコン表示プラグイン
 * @target MV MZ
 * @author n2naokun(柊菜緒)
 *
 * @help アイコン指定変数(IndexVar)に変数番号を指定して、
 * 指定した変数にアイコンの番号を代入することで
 * 金額ウィンドウの左側にアイコンを表示します。
 * 0番を指定すると従来通りの表示になります。
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 * 
 * @param IndexVar
 * @text アイコン指定変数
 * @type number
 * @default 0
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

var Imported = Imported || {};
// 他のプラグインとの連携用シンボル

(function (_global) {
   const PluginName = "HS_GoldWindowIcon";
   Imported[PluginName] = true;

   const params = PluginManager.parameters(PluginName);
   const indexVar = Number(params["IndexVar"]) || 0;

   const Window_Gold_refresh = Window_Gold.prototype.refresh;
   Window_Gold.prototype.refresh = function () {
      const rect = this.itemLineRect(0);
      const x = rect.x;
      const y = rect.y;
      const width = rect.width;
      this.contents.clear();
      let iconWidth = 0;
      const iconIndex = $gameVariables.value(indexVar);
      if (indexVar > 0 && iconIndex > 0 && this.width > 1 && this.height > 1) {
         let text = `\\I[${iconIndex}]`;
         iconWidth += ImageManager.iconWidth + 8;
         this.drawTextEx(text, x, y, iconWidth);
      }
      this.drawCurrencyValue(this.value(), this.currencyUnit(), x + iconWidth, y, width - iconWidth);
   };

})(this);
