//=============================================================================
// HS_RestrictedShop_Extension.js
// ----------------------------------------------------------------------------
// Copyright (c) 2017 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.1 2024/12/23 スイッチで売却価格を標準に戻せるように変更 ※35番固定
// 1.0.0 2018/08/08 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc HS_RestrictedShopを前提として売値をツクールとは別に設定するプラグイン
 * @author n2naokun(柊菜緒)
 *
 * @help 売買可能なアイテムのメモ欄に
 * <Price:価格>
 * と記載すればその価格が設定可能です。
 * 
 * ※買い取り制限ショップの時だけ動作します。
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

var Imported = Imported || {};
Imported.HS_RestrictedShop_Extension = true;
// 他のプラグインとの連携用シンボル

(function (_global) {
   if (Imported.HS_RestrictedShop) {
      var Scene_Shop_sellingPrice = Scene_Shop.prototype.sellingPrice;
      Scene_Shop.prototype.sellingPrice = function () {
         var price = Number(this._item.meta.Price);
         // 2024/12/23 スイッチで売却価格を標準に戻せるように変更
         if ($gameTemp.isRshop() && !Number.isNaN(price) && !$gameSwitches.value(35)) {
            // 2024/12/23 ここまで
            return price;
         } else {
            return Scene_Shop_sellingPrice.call(this);
         }
      };

   }
})(this);