﻿//=============================================================================
// IRPP_MV_PrizeShop.js
//=============================================================================

/*:
 * @plugindesc (※下部)特殊なショップの処理を実装します。
 * @author イロスマRPG制作委員会
 *
 * @param Page1
 * @text 基本設定
 *
 * @param SellShop SID
 * @desc 売却ショップの判定に使うスイッチIDです。
 * @default 12
 * @type switch
 * @parent Page1
 *
 * @param BuyingPrice VID
 * @desc 購入価格の割合を指定する変数のIDです。
 * @default 10
 * @type variable
 * @parent Page1
 *
 * @param SellingPrice VID
 * @desc 売却価格の割合を指定する変数のIDです。
 * @default 11
 * @type variable
 * @parent Page1
 *
 * @param Page2
 * @text 交換ショップ
 *
 * @param ItemShop SID
 * @desc 交換ショップの判定に使うスイッチIDです。
 * @default 13
 * @type switch
 * @parent Page2
 *
 * @param ItemMoney VID
 * @desc 交換対象のアイテムIDの指定に使う変数IDです。
 * @default 12
 * @type variable
 * @parent Page2
 *
 * @param Text Buy ItemShop
 * @desc 交換ショップの「購入する」の名称です。
 * @default 交換する
 * @parent Page2
 *
 * @param Text Sell ItemShop
 * @desc 交換ショップの「購入する」の名称です。
 * @default 引換する
 * @parent Page2
 *
 * @param Text ItemMoney
 * @desc 交換ショップの通貨単位名です。
 * @default 個
 * @parent Page2
 *
 * @param Show Sell Item
 * @desc 交換ショップで「売却する」を表示を表示しますか？
 * @default 0
 * @type select
 * @option false
 * @value 0
 * @option true
 * @value 1
 * @parent Page2
 *
 * @param Page3
 * @text 変数ショップ
 *
 * @param VariableShop SID
 * @desc 変数ショップの判定に使うスイッチIDです。
 * @default 14
 * @type switch
 * @parent Page3
 *
 * @param VariableMoney VID
 * @desc 変数ショップの通貨に使う変数IDです。
 * @default 13
 * @type variable
 * @parent Page3
 *
 * @param Text Buy VariableShop
 * @desc 変数ショップの「購入する」の名称です。
 * @default 交換する
 * @parent Page3
 *
 * @param Text Sell VariableShop
 * @desc 変数ショップの「購入する」の名称です。
 * @default 引換する
 * @parent Page3
 *
 * @param Text VariableMoney
 * @desc 変数ショップの通貨単位名です。
 * @default BP
 * @parent Page3
 *
 * @param Show Sell Variable
 * @desc 変数ショップで「売却する」を表示を表示しますか？
 * @default 0
 * @type select
 * @option false
 * @value 0
 * @option true
 * @value 1
 * @parent Page3
 *
 * @help アイテム、武器、防具のメモ欄に以下を書くと
 * そのアイテム類の値段に関わらず売却できなくなります。
 * <DisableSelling>
 * 
 * 使い方:
 * 「ItemShop SID」で指定したスイッチをONにすると
 * 交換ショップになります。
 * 
 * 「VariableShop SID」で指定したスイッチをONにすると
 * 変数ショップになります。
 * 
 * 「SellShop SID」で指定したスイッチをONにすると
 * 売却ショップになります。
 * また、「購入のみ」の設定が無視されます。
 * 
 * 交換ショップの場合:
 * 「ItemMoney VID」で指定した変数IDが1で、
 * その変数の値が1の時は1番目のアイテムが通貨になります。
 * 
 * 変数ショップの場合:
 * 「VariableMoney VID」で指定した変数IDが2の場合、
 * その変数が通貨になります。
 * 
 * 
 */

var Imported = Imported || {};
Imported.IRPP_MV_PrizeShop = true;
(function() {
var Parameters = PluginManager.parameters('IRPP_MV_PrizeShop');
var sellShop_SID = Number(Parameters['SellShop SID'] || 12);
var buyingPrice_VID = Number(Parameters['BuyingPrice VID'] || 10);
var sellingPrice_VID = Number(Parameters['SellingPrice VID'] || 11);
var itemShop_SID = Number(Parameters['ItemShop SID'] || 13);
var itemMoney_VID = Number(Parameters['ItemMoney VID'] || 12);
var showSell_Item = Number(Parameters['Show Sell Item'] || 0);
var variableShop_SID = Number(Parameters['VariableShop SID'] || 14);
var variableMoney_VID = Number(Parameters['VariableMoney VID'] || 13);
var showSell_Variable = Number(Parameters['Show Sell Variable'] || 0);
var textBuy_ItemShop = String(Parameters['Text Buy ItemShop'] || '交換する');
var textSell_ItemShop = String(Parameters['Text Sell ItemShop'] || '引換する');
var text_ItemMoney = String(Parameters['Text ItemMoney'] || '個');
var textBuy_VidShop = String(Parameters['Text Buy VariableShop'] || '交換する');
var textSell_VidShop = String(Parameters['Text Sell VariableShop'] || '引換する');
var text_VariableMoney = String(Parameters['Text VariableMoney'] || 'BP');
var reDisableSelling = /<DisableSelling>/i;

// 2024/10/22 変数をスクリプトから変更できるように改造
Game_Temp.prototype.setVarMoneyId = function (varId) {
  variableMoney_VID = Number(varId) || Number(Parameters['VariableMoney VID'] || 13);
};
// 2024/10/22 ここまで

var _DataManager_setupNewGame = DataManager.setupNewGame;
DataManager.setupNewGame = function() {
    _DataManager_setupNewGame.call(this);
    $gameVariables.setValue(buyingPrice_VID, 100);
    $gameVariables.setValue(sellingPrice_VID, 100);
};

var _Scene_Shop_terminate = Scene_Shop.prototype.terminate;
Scene_Shop.prototype.terminate = function() {
    _Scene_Shop_terminate.call(this);
    $gameVariables.setValue(buyingPrice_VID, 100);
    $gameVariables.setValue(sellingPrice_VID, 100);
    $gameSwitches.setValue(sellShop_SID, false);
    $gameSwitches.setValue(itemShop_SID, false);
    $gameSwitches.setValue(variableShop_SID, false);
};

var _Scene_Shop_doBuy = Scene_Shop.prototype.doBuy;
Scene_Shop.prototype.doBuy = function(number) {
    if ($gameSwitches.value(itemShop_SID)) {
      $gameParty.loseItem($dataItems[$gameVariables.value(itemMoney_VID)], number * this.buyingPrice());
      $gameParty.gainItem(this._item, number);
    } else if ($gameSwitches.value(variableShop_SID)) {
      var oldCount = $gameVariables.value(variableMoney_VID);
      $gameVariables.setValue(variableMoney_VID, oldCount - (number * this.buyingPrice()));
      $gameParty.gainItem(this._item, number);
    } else {
      _Scene_Shop_doBuy.call(this, number);
    }
};

var _Scene_Shop_doSell = Scene_Shop.prototype.doSell;
Scene_Shop.prototype.doSell = function(number) {
    if ($gameSwitches.value(itemShop_SID)) {
      $gameParty.gainItem($dataItems[$gameVariables.value(itemMoney_VID)], number * this.sellingPrice());
      $gameParty.loseItem(this._item, number);
    } else if ($gameSwitches.value(variableShop_SID)) {
      var oldCount = $gameVariables.value(variableMoney_VID);
      $gameVariables.setValue(variableMoney_VID, oldCount + (number * this.sellingPrice()));
      $gameParty.loseItem(this._item, number);
    } else {
      _Scene_Shop_doSell.call(this, number);
    }
};

var _Scene_Shop_sellingPrice = Scene_Shop.prototype.sellingPrice;
Scene_Shop.prototype.sellingPrice = function() {
    return Math.floor(Math.max(_Scene_Shop_sellingPrice.call(this) * $gameVariables.value(sellingPrice_VID) * 0.01, 0));
};

var _Window_Gold_value = Window_Gold.prototype.value;
Window_Gold.prototype.value = function() {
    if ($gameSwitches.value(itemShop_SID)) {
      return $gameParty.numItems($dataItems[$gameVariables.value(itemMoney_VID)]);
    } else if ($gameSwitches.value(variableShop_SID)) {
      return $gameVariables.value(variableMoney_VID);
    } else {
      return _Window_Gold_value.call(this);
    }
};

var _Window_Gold_currencyUnit = Window_Gold.prototype.currencyUnit;
Window_Gold.prototype.currencyUnit = function() {
    if ($gameSwitches.value(itemShop_SID)) {
      return text_ItemMoney;
    } else if ($gameSwitches.value(variableShop_SID)) {
      return text_VariableMoney;
    } else {
      return _Window_Gold_currencyUnit.call(this);
    }
};

var _Window_ShopCommand_makeCommandList = Window_ShopCommand.prototype.makeCommandList;
Window_ShopCommand.prototype.makeCommandList = function() {
    if ($gameSwitches.value(itemShop_SID)) {
      if ($gameSwitches.value(sellShop_SID)) {
        this.addCommand(textSell_ItemShop,   'sell');
      } else {
        this.addCommand(textBuy_ItemShop,    'buy');
        if (showSell_Item == 1) {
          this.addCommand(textSell_ItemShop,   'sell',   !this._purchaseOnly);
        }
      }
      this.addCommand(TextManager.cancel, 'cancel');
    } else if ($gameSwitches.value(variableShop_SID)) {
      if ($gameSwitches.value(sellShop_SID)) {
        this.addCommand(textSell_VidShop,   'sell');
      } else {
        this.addCommand(textBuy_VidShop,    'buy');
        if (showSell_Variable == 1) {
          this.addCommand(textSell_VidShop,   'sell',   !this._purchaseOnly);
        }
      }
      this.addCommand(TextManager.cancel, 'cancel');
    } else if ($gameSwitches.value(sellShop_SID)) {
      this.addCommand(TextManager.sell,   'sell');
      this.addCommand(TextManager.cancel, 'cancel');
    } else {
      _Window_ShopCommand_makeCommandList.call(this);
    }
};

var _Window_ShopBuy_price = Window_ShopBuy.prototype.price;
Window_ShopBuy.prototype.price = function(item) {
    return Math.floor(Math.max(_Window_ShopBuy_price.call(this, item) * ($gameVariables.value(buyingPrice_VID) * 0.01), 0));
};

var _Window_ShopSell_isEnabled = Window_ShopSell.prototype.isEnabled;
Window_ShopSell.prototype.isEnabled = function(item) {
    return _Window_ShopSell_isEnabled.call(this, item) && !(reDisableSelling.exec(item.note) != null) &&
           (($gameSwitches.value(itemShop_SID)) ? !(item == $dataItems[$gameVariables.value(itemMoney_VID)]):true);
};
})();