/*:-----------------------------------------------------------------------------------
 * NUUN_SaveScreen_3.js
 * 
 * Copyright (C) 2024 NUUN
 * This software is released under the MIT License.
 * http://opensource.org/licenses/mit-license.php
 * -------------------------------------------------------------------------------------
 */
/*:
 * @target MZ
 * @plugindesc Save screen EX
 * @author NUUN
 * @version 3.0.6
 * @base NUUN_Base
 * @orderAfter NUUN_Base
 * 
 * @help
 * You can customize the save screen.
 * 
 * "Save main window settings" is a window that displays a list of save files.
 * "Save status window settings" is a window that displays the currently selected save information. Multiple windows can be created.
 * 
 * Actor display
 * Actor images can display character chips, face graphics, and side view actors. If a specified member is set in "PartyActorMode", only the specified actor will be displayed.
 * 
 * Also, actor name, occupation, nickname, and level can be displayed for each character in the same way as the actor image. If a specified member is set in "PartyActorMode", only the specified actor will be displayed.
 * 
 * If you want to display different content for the same item, enter any string in the method name. (Character chip, face graphic, side view actor, actor name, level)
 * 
 * Original param
 * To set original items, enter any string in the "Method name".
 * actor:$gameActors (Actor specified by "SpecifyActor" (leader if not specified))
 * 
 * Actor original params
 * To set original items, enter any string in the "Method name".
 * It can be displayed for each character in the same way as actor images.
 * 
 * actor:$gameActors
 * 
 * ShowEval
 * actor:$gameActors (Actor specified by "SpecifyActor" (leader if not specified))
 * The only variables that can be referenced in the free text display conditions are info information, file name numbers, and display window objects.
 * 
 * The drawTextEx display does not apply the font size of the plugin parameter.
 * Set the text with \FS[x].
 * 
 * Change background image
 * You can change the background image as the game progresses.
 * By default, the background ID will be changed each time you change it with the plug-in command "Change background image".
 * The background ID of the save data with the highest ID is displayed on the loading screen.
 * 
 * Autosave snapshot
 * When autosaving, snapshots will be taken of the map just before the start of the battle and the map just before moving.
 * 
 * Content background setting (NUUN_Base ver.1.6.2 or later)
 * You can set an image as the content background for each save.
 * Usually, the background of list number 1 is displayed.
 * Use the second and later when you want to change the content background for each map.
 * Specify the file directly to change with the plug-in command.
 * 
 * The origin position of the content background image and the enlargement rate are set by the plug-in parameter "Content background image setting".
 * When an image with the same name as the image set in the content background is displayed, the set origin and magnification are applied.
 * If not set, it will be applied with the origin 0,0 and the magnification rate 100%.
 * 
 * Map Notes
 * <SaveContentsBackImg:[filename]> Specifies the content background image. For maps with this tag set, the image set in the map is applied instead of the image set in the plug-in parameter and plug-in command.
 * [filename]:list number of content background image
 * 
 * Terms of Use
 * This plugin is distributed under the MIT license.
 * 
 * Log
 * 8/17/2024 Ver.3.0.6
 * Fixed an issue that caused the save file cursor to be unnatural when the autosave display on the save screen was disabled.
 * Fixed a spelling mistake.
 * 7/27/2024 Ver.3.0.5
 * Added the ability to set the number of content columns in the save info window.
 * Added the ability to specify decimal points for some items.
 * 6/22/2024 Ver.3.0.4
 * Fixed an issue where item width was not applied wider than the width of a single item.
 * 6/1/2024 Ver.3.0.3
 * Fixed an issue where images were not displayed the first time.
 * 5/5/2024 Ver.3.0.2
 * Fixed an issue where actor original parameters were not displayed.
 * Fixed an issue where plugin commands could not be executed.
 * Added units.
 * 5/4/2024 Ver.3.0.1
 * Fixed an issue where parameters were not retrieved.
 * 5/3/2024 Ver.3.0.0
 * First edition.
 * 
 * @command ChangeBackground
 * @desc Change the background image.
 * @text Change background image
 * 
 * @arg BackGroundImg
 * @desc Specifies the background image file name.
 * @text Background image
 * @type file
 * @dir img/
 * @default 
 * 
 * @arg BackGroundId
 * @desc Sets the background image ID."Background image ID automatic setting" is OFF.
 * @text Background image ID
 * @type number
 * @default 0
 * @min 0
 * 
 * 
 * @command ChangeContentsBackground
 * @desc Change the content background image.
 * @text Content background image change
 * 
 * @arg BackGroundImg
 * @desc Specifies the background image file name.
 * @text Background image
 * @type file
 * @dir img/
 * @default 
 * 
 * 
 * @command UserAutoSave
 * @desc Perform autosave.
 * @text Perform autosave
 * 
 * @arg CompulsionAutoSave
 * @text Execute when save is disabled
 * @desc Auto-save is performed even when saving is prohibited.
 * @type boolean
 * @default false
 * 
 * @arg OnSaveSnap
 * @text snapshot permission
 * @desc Allow snapshots on autosave.
 * @type boolean
 * @default true
 * 
 * @command SnapShot
 * @desc Take a snapshot of the next save.
 * @text taking a snapshot
 * 
 * @command SetAnyName
 * @desc Enter the chapter name.
 * @text Chapter
 * 
 * @arg AnyName
 * @text Chapter text
 * @desc Enter the chapter text. Set when you want to display the current captor.
 * @type string
 * @default 
 * 
 * @command SpecifyActor
 * @desc Set the actor to display only the specified actor on the save screen.
 * @text Change specified actor
 * 
 * @arg ActorId
 * @text Actor
 * @desc Specifies an actor. If 0 is specified, the leader will be displayed.
 * @type actor
 * @default 0
 * 
 * @param SaveLayoutSetting
 * @text Save Layout
 * @default ------------------------------
 * 
 * @param SaveLayoutStyle
 * @desc Specify the save style.
 * @text Save Style
 * @type combo
 * @option 'Default'
 * @option 'Default720P'
 * @option 'Type2'
 * @default 'Default'
 * @parent SaveLayoutSetting
 * 
 * @param SaveWindowSetting
 * @text Save status window
 * @default ------------------------------
 * 
 * @param SaveLayout
 * @desc Specifies the save window to display.
 * @text Save window settings
 * @default ["{\"StyleName\":\"'Default'\",\"PartyActorMode\":\"'BattleMember'\",\"SaveSetting\":\"------------------------------\",\"NumSaveCols\":\"1\",\"NumSaveRows\":\"5\",\"SaveContentsCols\":\"2\",\"MaxSave\":\"20\",\"ContentsSetting\":\"------------------------------\",\"SaveHelpWindowList\":\"{\\\"MethodName\\\":\\\"\\\",\\\"WindowX\\\":\\\"0\\\",\\\"WindowY\\\":\\\"52\\\",\\\"WindowWidth\\\":\\\"0\\\",\\\"WindowHeight\\\":\\\"0\\\",\\\"WindowHeightRows\\\":\\\"1\\\",\\\"WindowVisible\\\":\\\"true\\\"}\",\"SaveMainWindowList\":\"{\\\"MethodName\\\":\\\"\\\",\\\"ContentsList\\\":\\\"[\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"CharacterChip\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"24\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Level\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"60\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"48\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"FileName\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-4\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Title\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"230\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"TextEx\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Lcation\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"230\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"260\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"70\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Location\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Gold\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"3\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"230\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"260\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"70\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Gold\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"SaveTime\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"500\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"260\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"PlayTime\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"3\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"500\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"260\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Play time\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\"]\\\",\\\"NotContentsList\\\":\\\"\\\",\\\"WindowX\\\":\\\"0\\\",\\\"WindowY\\\":\\\"112\\\",\\\"WindowWidth\\\":\\\"0\\\",\\\"WindowHeight\\\":\\\"504\\\",\\\"WindowHeightRows\\\":\\\"0\\\",\\\"WindowVisible\\\":\\\"true\\\",\\\"ActorCols\\\":\\\"4\\\",\\\"ActorAreaWidth\\\":\\\"48\\\",\\\"ActorAreaHeight\\\":\\\"162\\\"}\",\"SaveStatusWindowListSetting\":\"------------------------------\",\"SaveStatusWindowList\":\"\",\"ListData1_10\":\"------------------------------\",\"PageList1\":\"[]\",\"PageList2\":\"[]\",\"PageList3\":\"[]\",\"PageList4\":\"[]\",\"PageList5\":\"[]\",\"PageList6\":\"[]\",\"PageList7\":\"[]\",\"PageList8\":\"[]\",\"PageList9\":\"[]\",\"PageList10\":\"[]\",\"SaveSnapSetting\":\"------------------------------\",\"InfoSaveSnap\":\"false\",\"SaveSnapQuality\":\"0.92\",\"SaveSnapScale\":\"12\",\"Actor\":\"------------------------------\",\"FaceWidth\":\"144\",\"FaceHeight\":\"144\",\"FaceScale\":\"100\",\"BackGround\":\"------------------------------\",\"BackGroundImg\":\"\",\"BackUiWidth\":\"true\",\"BackFitWidth\":\"false\",\"AutomaticSetting\":\"true\",\"ContentsBackVisible\":\"false\",\"ContentsBackGroundImg\":\"[]\",\"ContentsBackSettingsList\":\"\",\"ContentsBackScale\":\"100\"}","{\"StyleName\":\"'Default720P'\",\"PartyActorMode\":\"'BattleMember'\",\"SaveSetting\":\"------------------------------\",\"NumSaveCols\":\"1\",\"NumSaveRows\":\"5\",\"SaveContentsCols\":\"2\",\"MaxSave\":\"20\",\"ContentsSetting\":\"------------------------------\",\"SaveHelpWindowList\":\"{\\\"MethodName\\\":\\\"\\\",\\\"WindowX\\\":\\\"0\\\",\\\"WindowY\\\":\\\"52\\\",\\\"WindowWidth\\\":\\\"0\\\",\\\"WindowHeight\\\":\\\"0\\\",\\\"WindowHeightRows\\\":\\\"1\\\",\\\"WindowVisible\\\":\\\"true\\\"}\",\"SaveMainWindowList\":\"{\\\"MethodName\\\":\\\"\\\",\\\"ContentsList\\\":\\\"[\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"CharacterChip\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"3\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"20\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Level\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"32\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"48\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"FileName\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-4\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Title\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"230\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"TextEx\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Lcation\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"230\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"320\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"70\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Location\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Gold\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"3\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"230\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"320\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Gold\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"SaveTime\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"600\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"360\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"PlayTime\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"3\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"600\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"360\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Play time\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"SnapShot\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1040\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\"]\\\",\\\"NotContentsList\\\":\\\"\\\",\\\"WindowX\\\":\\\"0\\\",\\\"WindowY\\\":\\\"112\\\",\\\"WindowWidth\\\":\\\"0\\\",\\\"WindowHeight\\\":\\\"600\\\",\\\"WindowHeightRows\\\":\\\"0\\\",\\\"WindowVisible\\\":\\\"true\\\",\\\"ActorCols\\\":\\\"4\\\",\\\"ActorAreaWidth\\\":\\\"48\\\",\\\"ActorAreaHeight\\\":\\\"162\\\"}\",\"SaveStatusWindowListSetting\":\"------------------------------\",\"SaveStatusWindowList\":\"\",\"ListData1_10\":\"------------------------------\",\"PageList1\":\"[]\",\"PageList2\":\"[]\",\"PageList3\":\"[]\",\"PageList4\":\"[]\",\"PageList5\":\"[]\",\"PageList6\":\"[]\",\"PageList7\":\"[]\",\"PageList8\":\"[]\",\"PageList9\":\"[]\",\"PageList10\":\"[]\",\"SaveSnapSetting\":\"------------------------------\",\"InfoSaveSnap\":\"true\",\"SaveSnapQuality\":\"0.92\",\"SaveSnapScale\":\"12\",\"Actor\":\"------------------------------\",\"FaceWidth\":\"144\",\"FaceHeight\":\"144\",\"FaceScale\":\"100\",\"BackGround\":\"------------------------------\",\"BackGroundImg\":\"\",\"BackUiWidth\":\"true\",\"BackFitWidth\":\"false\",\"AutomaticSetting\":\"true\",\"ContentsBackVisible\":\"false\",\"ContentsBackGroundImg\":\"[]\",\"ContentsBackSettingsList\":\"\",\"ContentsBackScale\":\"100\"}","{\"StyleName\":\"'Type2'\",\"PartyActorMode\":\"'Actor'\",\"SaveSetting\":\"------------------------------\",\"NumSaveCols\":\"1\",\"NumSaveRows\":\"10\",\"SaveContentsCols\":\"1\",\"MaxSave\":\"20\",\"ContentsSetting\":\"------------------------------\",\"SaveHelpWindowList\":\"{\\\"MethodName\\\":\\\"\\\",\\\"WindowX\\\":\\\"0\\\",\\\"WindowY\\\":\\\"52\\\",\\\"WindowWidth\\\":\\\"0\\\",\\\"WindowHeight\\\":\\\"0\\\",\\\"WindowHeightRows\\\":\\\"1\\\",\\\"WindowVisible\\\":\\\"true\\\"}\",\"SaveMainWindowList\":\"{\\\"MethodName\\\":\\\"\\\",\\\"ContentsList\\\":\\\"[\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"FileName\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"PlayTime\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"280\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\"]\\\",\\\"NotContentsList\\\":\\\"[\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"FileName\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"280\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\FS[20]No Data\\\\\\\\\\\\\\\"}\\\\\\\"]\\\",\\\"WindowX\\\":\\\"0\\\",\\\"WindowY\\\":\\\"112\\\",\\\"WindowWidth\\\":\\\"420\\\",\\\"WindowHeight\\\":\\\"504\\\",\\\"WindowHeightRows\\\":\\\"0\\\",\\\"WindowVisible\\\":\\\"true\\\",\\\"ActorCols\\\":\\\"1\\\",\\\"ActorAreaWidth\\\":\\\"48\\\",\\\"ActorAreaHeight\\\":\\\"162\\\"}\",\"SaveStatusWindowListSetting\":\"------------------------------\",\"SaveStatusWindowList\":\"[\\\"{\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ListDateSetting\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"ListNotDateSetting\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WindowX\\\\\\\":\\\\\\\"420\\\\\\\",\\\\\\\"WindowY\\\\\\\":\\\\\\\"112\\\\\\\",\\\\\\\"WindowWidth\\\\\\\":\\\\\\\"388\\\\\\\",\\\\\\\"WindowHeight\\\\\\\":\\\\\\\"504\\\\\\\",\\\\\\\"WindowHeightRows\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WindowVisible\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"ActorCols\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"ActorAreaWidth\\\\\\\":\\\\\\\"48\\\\\\\",\\\\\\\"ActorAreaHeight\\\\\\\":\\\\\\\"162\\\\\\\"}\\\"]\",\"ListData1_10\":\"------------------------------\",\"PageList1\":\"[\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"FileName\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Face\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"ActorName\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"162\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"ClassName\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"3\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"162\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Nickname\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"162\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Level\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"162\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"HP\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"6\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"-12\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"MP\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"7\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"-12\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Atk\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Def\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"9\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Mat\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Mdf\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"11\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Agi\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Luk\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"13\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\",\"PageList2\":\"[]\",\"PageList3\":\"[]\",\"PageList4\":\"[]\",\"PageList5\":\"[]\",\"PageList6\":\"[]\",\"PageList7\":\"[]\",\"PageList8\":\"[]\",\"PageList9\":\"[]\",\"PageList10\":\"[]\",\"SaveSnapSetting\":\"------------------------------\",\"InfoSaveSnap\":\"false\",\"SaveSnapQuality\":\"0.92\",\"SaveSnapScale\":\"12\",\"Actor\":\"------------------------------\",\"FaceWidth\":\"144\",\"FaceHeight\":\"144\",\"FaceScale\":\"100\",\"BackGround\":\"------------------------------\",\"BackGroundImg\":\"\",\"BackUiWidth\":\"true\",\"BackFitWidth\":\"false\",\"AutomaticSetting\":\"true\",\"ContentsBackVisible\":\"false\",\"ContentsBackGroundImg\":\"[]\",\"ContentsBackSettingsList\":\"\",\"ContentsBackScale\":\"100\"}"]
 * @type struct<SaveLayoutList>[]
 * @parent SaveWindowSetting
 * 
 * @param BasicSetting
 * @text Basic Setting
 * @default ------------------------------
 * 
 * @param DecimalMode
 * @text rounding off
 * @desc Round off the non-display decimal point. (truncated at false)
 * @type boolean
 * @default true
 * @parent BasicSetting
 * 
 * @param DayTime
 * @desc Date and time format to display
 * @text datetime format
 * @type select
 * @option Standard
 * @value 'default'
 * @option US notation
 * @value 'en-US'
 * @option British notation
 * @value 'en-GB'
 * @option Japanese notation
 * @value 'ja-JP'
 * @option Japanese era notation
 * @value 'ja-JP-u-ca-japanese'
 * @default 'default'
 * @parent Contents
 * 
 * @param AutoSaveSetting
 * @text Auto save settings
 * @default ------------------------------
 * 
 * @param SaveFileShowAutoSave
 * @text Save screen auto save display
 * @desc Auto save display on save screen.
 * @type boolean
 * @default true
 * @parent AutoSaveSetting
 * 
 * @param MapTransferAutoSave
 * @text Auto save enabled when moving map
 * @desc Autosave enabled when moving map.
 * @type boolean
 * @default true
 * @parent AutoSaveSetting
 * 
 * @param BattleEndAutoSave
 * @text Autosave enabled after battle
 * @desc Autosave enabled after battle.
 * @type boolean
 * @default true
 * @parent AutoSaveSetting
 * 
 * @param AutoSaveEnabledSwitch
 * @desc Specify a switch to disable auto-save execution when moving after battle. (0 to enable auto save)
 * @text After battle, auto-save execution is prohibited while moving.
 * @type switch
 * @default 0
 * @parent AutoSaveSetting
 * 
 * @param AnyName
 * @text Chapter setting
 * @default ------------------------------
 * 
 * @param AnyNameVariable
 * @desc Chapter text variable number. It is not displayed if it is set by the plugin command "Enter the chapter name".
 * @text Chapter text display variable number
 * @type variable
 * @default 0
 * @parent AnyName
 * 
 * 
 */
/*~struct~SaveLayoutList:
 * 
 * @param StyleName
 * @desc Style name of the save layout.
 * @text Save layout style
 * @type combo
 * @option 'Default'
 * @default 'Default'
 * 
 * @param PartyActorMode
 * @desc Actor to display
 * @text Display actor
 * @type select
 * @option Specified member
 * @value 'Actor'
 * @option BattleMember
 * @value 'BattleMember'
 * @option PartyMember
 * @value 'PartyMember'
 * @default 'BattleMember'
 * 
 * @param SaveSetting
 * @text Save etting
 * @default ------------------------------
 * 
 * @param NumSaveCols
 * @desc The number of save cols to display on the screen.
 * @text Number of display save cols
 * @type number
 * @default 1
 * @min 1
 * @parent SaveSetting
 * 
 * param NumSaveRows
 * @desc Number of save rows displayed on the screen.
 * @text Number of saved display rows
 * @type number
 * @default 5
 * @min 1
 * @parent SaveSetting
 * 
 * @param SaveContentsCols
 * @desc Number of save columns to display on screen.
 * @text Number of display save item columns
 * @type number
 * @default 2
 * @min 1
 * @parent SaveSetting
 * 
 * @param MaxSave
 * @desc Maximum number of saves.
 * @text Max number of saves
 * @type number
 * @default 20
 * @min 1
 * @parent SaveSetting
 * 
 * @param ContentsSetting
 * @text Contents Setting
 * @default ------------------------------
 * 
 * @param SaveHelpWindowList
 * @desc Set up the help window.
 * @text Save help window settings
 * @type struct<SaveHelpWindowListData>
 * @default {"MethodName":"","WindowX":"0","WindowY":"0","WindowWidth":"0","WindowHeight":"0","WindowHeightRows":"1","WindowVisible":"true"}
 * @parent ContentsSetting
 * 
 * @param SaveMainWindowList
 * @desc Window settings to display the save list.
 * @text Save main window settings
 * @type struct<SaveMainWindowListData>
 * @default {"MethodName":"","ContentsList":"[\"{\\\"DateSelect\\\":\\\"None\\\",\\\"X_Position\\\":\\\"1\\\",\\\"Y_Position\\\":\\\"1\\\",\\\"X_Coordinate\\\":\\\"0\\\",\\\"Y_Coordinate\\\":\\\"0\\\",\\\"ItemWidth\\\":\\\"0\\\",\\\"SystemItemWidth\\\":\\\"0\\\",\\\"SystemNameColor\\\":\\\"16\\\",\\\"FontSize\\\":\\\"-6\\\",\\\"ParamName\\\":\\\"\\\",\\\"DetaEval\\\":\\\"\\\",\\\"Align\\\":\\\"\\\\\\\"left\\\\\\\"\\\",\\\"ShowEval\\\":\\\"\\\",\\\"MethodName\\\":\\\"\\\",\\\"FreeText\\\":\\\"\\\"}\"]","NotContentsList":"","WindowX":"0","WindowY":"0","WindowWidth":"0","WindowHeight":"0","WindowHeightRows":"0","WindowVisible":"true","ActorCols":"4","ActorAreaWidth":"48","ActorAreaHeight":"162"}
 * @parent ContentsSetting
 * 
 * @param SaveStatusWindowListSetting
 * @text Save status settings
 * @default ------------------------------
 * @parent ContentsSetting
 * 
 * @param SaveStatusWindowList
 * @desc Window settings to switch the display for each save file.
 * @text Save status window settings
 * @type struct<SaveWindowListData>[]
 * @default 
 * @parent SaveStatusWindowListSetting
 * 
 * @param ListData1_10
 * @text Display item setting 1-10
 * @default ------------------------------
 * @parent SaveStatusWindowListSetting
 * 
 * @param PageList1
 * @desc List to display.
 * @text display list 1
 * @type struct<StatusListData>[]
 * @default ["{\"DateSelect\":\"FileName\",\"X_Position\":\"1\",\"Y_Position\":\"1\",\"X_Coordinate\":\"0\",\"Y_Coordinate\":\"0\",\"ItemWidth\":\"0\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"left\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"Face\",\"X_Position\":\"1\",\"Y_Position\":\"2\",\"X_Coordinate\":\"0\",\"Y_Coordinate\":\"0\",\"ItemWidth\":\"0\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"left\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"ActorName\",\"X_Position\":\"1\",\"Y_Position\":\"2\",\"X_Coordinate\":\"162\",\"Y_Coordinate\":\"0\",\"ItemWidth\":\"0\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"left\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"ClassName\",\"X_Position\":\"1\",\"Y_Position\":\"3\",\"X_Coordinate\":\"162\",\"Y_Coordinate\":\"0\",\"ItemWidth\":\"0\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"left\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"Nickname\",\"X_Position\":\"1\",\"Y_Position\":\"4\",\"X_Coordinate\":\"162\",\"Y_Coordinate\":\"0\",\"ItemWidth\":\"0\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"left\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"Level\",\"X_Position\":\"1\",\"Y_Position\":\"5\",\"X_Coordinate\":\"162\",\"Y_Coordinate\":\"0\",\"ItemWidth\":\"0\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"left\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"HP\",\"X_Position\":\"1\",\"Y_Position\":\"6\",\"X_Coordinate\":\"0\",\"Y_Coordinate\":\"-12\",\"ItemWidth\":\"0\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"left\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"MP\",\"X_Position\":\"1\",\"Y_Position\":\"7\",\"X_Coordinate\":\"0\",\"Y_Coordinate\":\"-12\",\"ItemWidth\":\"0\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"left\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"Atk\",\"X_Position\":\"1\",\"Y_Position\":\"8\",\"X_Coordinate\":\"0\",\"Y_Coordinate\":\"0\",\"ItemWidth\":\"200\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"right\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"Def\",\"X_Position\":\"1\",\"Y_Position\":\"9\",\"X_Coordinate\":\"0\",\"Y_Coordinate\":\"0\",\"ItemWidth\":\"200\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"right\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"Mat\",\"X_Position\":\"1\",\"Y_Position\":\"10\",\"X_Coordinate\":\"0\",\"Y_Coordinate\":\"0\",\"ItemWidth\":\"200\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"right\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"Mdf\",\"X_Position\":\"1\",\"Y_Position\":\"11\",\"X_Coordinate\":\"0\",\"Y_Coordinate\":\"0\",\"ItemWidth\":\"200\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"right\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"Agi\",\"X_Position\":\"1\",\"Y_Position\":\"12\",\"X_Coordinate\":\"0\",\"Y_Coordinate\":\"0\",\"ItemWidth\":\"200\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"right\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}","{\"DateSelect\":\"Luk\",\"X_Position\":\"1\",\"Y_Position\":\"13\",\"X_Coordinate\":\"0\",\"Y_Coordinate\":\"0\",\"ItemWidth\":\"200\",\"SystemItemWidth\":\"0\",\"SystemNameColor\":\"16\",\"FontSize\":\"-6\",\"ParamName\":\"\",\"DetaEval\":\"\",\"Align\":\"\\\"right\\\"\",\"ShowEval\":\"\",\"MethodName\":\"\",\"FreeText\":\"\"}"]
 * @parent ListData1_10
 *  
 * @param PageList2
 * @desc List to display.
 * @text display list 2
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList3
 * @desc List to display.
 * @text display list 3
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList4
 * @desc List to display.
 * @text display list 4
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList5
 * @desc List to display.
 * @text display list 5
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList6
 * @desc List to display.
 * @text display list 6
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList7
 * @desc List to display.
 * @text display list 7
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList8
 * @desc List to display.
 * @text display list 8
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList9
 * @desc List to display.
 * @text display list 9
 * @type struct<StatussListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList10
 * @desc List to display.
 * @text display list 10
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param SaveSnapSetting
 * @text Save snapshot settings
 * @default ------------------------------
 * 
 * @param InfoSaveSnap
 * @text Enable snapshot
 * @desc Enable snapshots.
 * @type boolean
 * @default false
 * @parent SaveSnapSetting
 * 
 * @param SaveSnapQuality
 * @desc Snapshot quality. (default value 0.92)
 * @text Snapshot quality
 * @type string
 * @default 0.92
 * @max 1
 * @parent SaveSnapSetting
 * 
 * @param SaveSnapScale
 * @desc Snapshot enlargement rate. (percentage)
 * @text Snapshot enlargement rate(percentage)
 * @type number
 * @default 12
 * @min 0
 * @parent SaveSnapSetting
 * 
 * @param Actor
 * @text Actor settings
 * @default ------------------------------
 * 
 * @param FaceWidth
 * @desc Face Width.
 * @text Face Width
 * @type number
 * @default 144
 * @min 0
 * @parent Actor
 * 
 * @param FaceHeight
 * @desc Face height
 * @text Face height.
 * @type number
 * @default 144
 * @parent Actor
 * 
 * @param FaceScale
 * @desc Face scale
 * @text Scale
 * @type number
 * @default 100
 * @parent Actor
 * 
 * @param BackGround
 * @text Background setting
 * @default ------------------------------
 * 
 * @param BackGroundImg
 * @desc Specifies the background image file name.
 * @text Background image
 * @type file
 * @dir img/
 * @default 
 * @parent BackGround
 * 
 * @param BackUiWidth
 * @text Background image window UI size
 * @desc Fit the background image to the window UI size.
 * @type boolean
 * @default true
 * @parent BackGround
 * 
 * @param BackFitWidth
 * @text Background image enlargement
 * @desc Scales the background image to fit the window size or screen.
 * @type boolean
 * @default false
 * @parent BackGround
 * 
 * @param AutomaticSetting
 * @text Background image ID automatic setting
 * @desc Automatically sets the background image ID. The background of save data with a high ID is displayed on the loading screen.
 * @type boolean
 * @default true
 * @parent BackGround
 * 
 * @param ContentsBackVisible
 * @text Hide content background image
 * @desc Hide content background image
 * @type boolean
 * @default false
 * @parent BackGround
 * 
 * @param ContentsBackGroundImg
 * @desc Specifies the content background image file name.
 * @text Content background image
 * @type file[]
 * @dir img/
 * @default []
 * @parent BackGround
 * 
 * @param ContentsBackSettingsList
 * @desc Set the content background image.
 * @text Content background image setting
 * @type struct<ContentsBackSettings>[]
 * @default 
 * @parent BackGround
 * 
 * @param ContentsBackScale
 * @desc Default content background image scaling factor (percentage)
 * @text Background image magnification (percentage)
 * @type number
 * @min 0
 * @default 100
 * @parent BackGround
 * 
 */
/*~struct~SaveHelpWindowListData:
 * 
 * @param MethodName
 * @desc Specifies the window's distinguished name.
 * @text Method name
 * @type string
 * @default
 * 
 * @param WindowX
 * @text Window x coordinate
 * @desc Window x coordinate.
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param WindowY
 * @desc Window y coordinate.
 * @text Window y coordinate
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param WindowWidth
 * @text Window width
 * @desc Window width. (Screen UI width at 0)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowHeight
 * @text Window height
 * @desc Window height. (Screen UI height at 0)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowHeightRows
 * @text Window height row
 * @desc Window height (number of lines specified) (WindowHeight specified with 0)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowVisible
 * @text Window skin image display
 * @desc Display window skin image.
 * @type boolean
 * @default true
 * 
 */
/*~struct~SaveMainWindowListData:
 * 
 * @param MethodName
 * @desc Specifies the window's distinguished name.
 * @text Method name
 * @type string
 * @default
 * 
 * @param ContentsList
 * @desc Item to display.
 * @text Display items
 * @type struct<ContentsListData>[]
 * @default 
 * 
 * @param NotContentsList
 * @desc Item that displays a list of missing files.
 * @text No file display item
 * @type struct<NotContentsListData>[]
 * @default 
 * 
 * @param WindowX
 * @text Window x coordinate
 * @desc Window x coordinate.
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param WindowY
 * @desc Window y coordinate.
 * @text Window y coordinate
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param WindowWidth
 * @text Window width
 * @desc Window width. (Screen UI width at 0)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowHeight
 * @text Window height
 * @desc Window height. (Screen UI height at 0)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowHeightRows
 * @text Window height row
 * @desc Window height (number of lines specified) (WindowHeight specified with 0)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowVisible
 * @text Window skin image display
 * @desc Display window skin image.
 * @type boolean
 * @default true
 * 
 * @param ActorCols
 * @text Actor display cols
 * @desc Actor display cols.
 * @type number
 * @default 4
 * @min 1
 * 
 * @param ActorAreaWidth
 * @text Actor horizontal spacing width
 * @desc Actor horizontal spacing width.
 * @type number
 * @default 48
 * @min 0
 * 
 * @param ActorAreaHeight
 * @text Actor vertical spacing width
 * @desc Actor vertical spacing width.
 * @type number
 * @default 162
 * @min 0
 * 
 * 
 */
/*~struct~SaveWindowListData:
 * 
 * @param MethodName
 * @desc Specifies the window's distinguished name.
 * @text Method name
 * @type string
 * @default
 *
 * @param ListDateSetting
 * @desc Specify the list to display.
 * @text Specifying display list
 * @type select
 * @option None
 * @value 0
 * @option display list 1
 * @value 1
 * @option display list 2
 * @value 2
 * @option display list 3
 * @value 3
 * @option display list 4
 * @value 4
 * @option display list 5
 * @value 5
 * @option display list 6
 * @value 6
 * @option display list 7
 * @value 7
 * @option display list 8
 * @value 8
 * @option display list 9
 * @value 9
 * @option display list 10
 * @value 10
 * @default 0
 * 
 * @param ListNotDateSetting
 * @desc Specifies the list in case there are no save files.
 * @text Specify display list without save files
 * @type select
 * @option None
 * @value 0
 * @option display list 1
 * @value 1
 * @option display list 2
 * @value 2
 * @option display list 3
 * @value 3
 * @option display list 4
 * @value 4
 * @option display list 5
 * @value 5
 * @option display list 6
 * @value 6
 * @option display list 7
 * @value 7
 * @option display list 8
 * @value 8
 * @option display list 9
 * @value 9
 * @option display list 10
 * @value 10
 * @default 0
 * 
 * @param SaveStatusContentsCols
 * @desc Number of save columns to display on screen.
 * @text Number of display save item columns
 * @type number
 * @default 2
 * @min 1
 * 
 * @param WindowX
 * @text Window x coordinate
 * @desc Window x coordinate.
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param WindowY
 * @desc Window y coordinate.
 * @text Window y coordinate
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param WindowWidth
 * @text Window width
 * @desc Window width. (Screen UI width at 0)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowHeight
 * @text Window height
 * @desc Window height. (Screen UI height at 0)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowHeightRows
 * @text Window height row
 * @desc Window height (number of lines specified) (WindowHeight specified with 0)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowVisible
 * @text Window skin image display
 * @desc Display window skin image.
 * @type boolean
 * @default true
 * 
 * 
 * @param ActorCols
 * @text Actor display cols
 * @desc Actor display cols.
 * @type number
 * @default 4
 * @min 1
 * 
 * @param ActorAreaWidth
 * @text Actor horizontal spacing width
 * @desc Actor horizontal spacing width.
 * @type number
 * @default 48
 * @min 0
 * 
 * @param ActorAreaHeight
 * @text Actor vertical spacing width
 * @desc Actor vertical spacing width.
 * @type number
 * @default 162
 * @min 0
 * 
 * 
 */
/*~struct~ContentsListData:
 * 
 * @param DateSelect
 * @text status to display
 * @desc Specifies the status to display. (x)will be displayed for each displayed actor.
 * @type select
 * @option None
 * @value None
 * @option Play time(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value PlayTime
 * @option Save time(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value SaveTime
 * @option Location(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value Lcation
 * @option Money(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value Gold
 * @option Original param(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)(11)(13)(15)(16)
 * @value OriginalParam
 * @option Fail name(1)(2)(3)(4)(5)(8)
 * @value FileName
 * @option Title(1)(2)(3)(4)(5)(8)(11)
 * @value Title
 * @option Chapter(1)(2)(3)(4)(5)(8)(11)
 * @value Chapter
 * @option Action goal(1)(2)(3)(4)(5)(8)(11)
 * @value ActionGoal
 * @option Actor name (x)(1)(2)(3)(4)(5)(8)(12)(13)
 * @value ActorName
 * @option Class (x)(1)(2)(3)(4)(5)(8)
 * @value ClassName
 * @option Nickname (x)(1)(2)(3)(4)(5)(8)
 * @value Nickname
 * @option Level (x)(1)(2)(3)(4)(5)(8)(11)(12)(13)
 * @value Level
 * @option Character chip (x)(1)(2)(3)(4)(5)(12)(13)
 * @value CharacterChip
 * @option Face (x)(1)(2)(3)(4)(12)(13)
 * @value Face
 * @option SV actor (x)(1)(2)(3)(4)(5)(12)(13)
 * @value SvActor
 * @option Snap shot(1)(2)(3)(4)
 * @value SnapShot
 * @option Line(1)(2)(3)(4)(5)(7)
 * @value HorzLine
 * @option Free text(1)(2)(3)(4)(12)(14)
 * @value FreeText
 * @default None
 * 
 * @param X_Position
 * @text X display col position(1)
 * @desc X display col position.
 * @type number
 * @default 1
 * @min 1
 * @max 4
 * 
 * @param Y_Position
 * @desc Y display row position.
 * @text Y display row position(2)
 * @type number
 * @default 1
 * @min 1
 * @max 99
 * 
 * @param X_Coordinate
 * @text X coordinate (relative)(3)
 * @desc X coordinate (relative coordinate from X display col position)
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 * 
 * @param Y_Coordinate
 * @text Y coordinate (relative)(4)
 * @desc Y coordinate (relative coordinate from Y display row position)
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 * 
 * @param ItemWidth
 * @desc Item, gauge width(0 for default width)
 * @text Item, gauge width(5)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param SystemItemWidth
 * @desc Width of item name (default width at 0)
 * @text Width of item name(6)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param SystemNameColor
 * @desc System color ID for system items. You can enter the color code in the text tab.
 * @text System Name color(7)
 * @type color
 * @default 16
 * @min 0
 * 
 * @param FontSize
 * @desc Font size (difference from main font)
 * @text Font size(8)
 * @type number
 * @default -6
 * @min -99
 * 
 * @param ParamName
 * @desc Set the item name.
 * @text Name(9)
 * @type string
 * @default
 * 
 * @param DetaEval
 * @desc Enter an evaluation formula.
 * @text Evaluation formula(javaScript)(10)
 * @type combo
 * @option '$gameParty.steps();//Step'
 * @option '$gameSystem.battleCount();//Battle count'
 * @option '$gameSystem.escapeCount();//Escapes count'
 * @option '$gameSystem.saveCount();//Save count'
 * @option '$gameVariables.value(0);//Game variable'
 * @option '$gameSystem.chronus().getDateFormat(1);//”Chronus.js” datetime format 1'
 * @option '$gameSystem.chronus().getDateFormat(2);//”Chronus.js” datetime format 2'
 * @default 
 * 
 * @param Align
 * @desc Align.
 * @text Align(11)
 * @type select
 * @option Text code can be used (left) "Chapter" and "Action goal" only.
 * @value "TextEx"
 * @option Left
 * @value "left"
 * @option Center
 * @value "center"
 * @option Right
 * @value "right"
 * @default "left"
 * 
 * @param ShowEval
 * @desc Enter the display conditions in Javascript.
 * @text Display condition (javaScript)(12)
 * @type combo
 * @option '$gameSwitches.value(Number(actor.actor().meta.SaveActorShowSwitch))'
 * @option '(!info && $gameSystem.getVariableSaveFiles() <= savefileId);//Variable maximum save number final file judgment'
 * @default 
 * 
 * @param MethodName
 * @desc Method name
 * @text Method name(13)
 * @type string
 * @default 
 * 
 * @param FreeText
 * @desc Fill in your text. Text codes can be used.
 * @text Text(14)
 * @type string
 * @default 
 * 
 * @param paramUnit
 * @desc Unit.
 * @text Unit(15)
 * @type string
 * @default
 * 
 * @param Decimal
 * @text Decimal digits(16)
 * @desc The number of decimal places that can be displayed.
 * @type number
 * @default 0
 * @min 0
 * @max 99
 * 
 * 
 */
/*~struct~StatusListData:
 * 
 * @param DateSelect
 * @text status to display
 * @desc Specifies the status to display. * will be displayed for each displayed actor.
 * @type select
 * @option None
 * @value None
 * @option Play time(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value PlayTime
 * @option Save time(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value SaveTime
 * @option Location(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value Lcation
 * @option Money(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value Gold
 * @option Original param(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)(11)(13)(15)(16)
 * @value OriginalParam
 * @option Fail name(1)(2)(3)(4)(5)(8)
 * @value FileName
 * @option Title(1)(2)(3)(4)(5)(8)(11)
 * @value Title
 * @option Chapter(1)(2)(3)(4)(5)(8)(11)
 * @value Chapter
 * @option Action goal(1)(2)(3)(4)(5)(8)(11)
 * @value ActionGoal
 * @option Actor name (x)(1)(2)(3)(4)(5)(8)(12)(13)
 * @value ActorName
 * @option Class(1) (x)(2)(3)(4)(5)(8)
 * @value ClassName
 * @option Nickname (x)(1)(2)(3)(4)(5)(8)
 * @value Nickname
 * @option Level (x)(1)(2)(3)(4)(5)(8)(11)(12)(13)
 * @value Level
 * @option Character chip (x)(1)(2)(3)(4)(5)(12)(13)
 * @value CharacterChip
 * @option Face (x)(1)(2)(3)(4)(12)(13)
 * @value Face
 * @option SV actor (x)(1)(2)(3)(4)(5)(12)(13)
 * @value SvActor
 * @option Snap shot(1)(2)(3)(4)
 * @value SnapShot
 * @option Line(1)(2)(3)(4)(5)(7)
 * @value HorzLine
 * @option Free text(1)(2)(3)(4)(12)(14)
 * @value FreeText
 * @option HP (x)(1)(2)(3)(4)(5)(7)
 * @value HP
 * @option MP (x)(1)(2)(3)(4)(5)(7)
 * @value MP
 * @option ATK (x)(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(15)
 * @value Atk
 * @option DEF (x)(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(15)
 * @value Def
 * @option MAT (x)(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(15)
 * @value Mat
 * @option MDF (x)(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(15)
 * @value Mdf
 * @option AGI (x)(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(15)
 * @value Agi
 * @option LUK (x)(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(15)
 * @value Luk
 * @option Actor original params (x)(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(13)(15)
 * @value ActorOriginalParam
 * @default None
 * 
 * @param X_Position
 * @text X display col position(1)
 * @desc X display col position.
 * @type number
 * @default 1
 * @min 1
 * @max 4
 * 
 * @param Y_Position
 * @desc Y display row position.
 * @text Y display row position(2)
 * @type number
 * @default 1
 * @min 1
 * @max 99
 * 
 * @param X_Coordinate
 * @text X coordinate (relative)(3)
 * @desc X coordinate (relative coordinate from X display col position)
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 * 
 * @param Y_Coordinate
 * @text Y coordinate (relative)(4)
 * @desc Y coordinate (relative coordinate from Y display row position)
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 * 
 * @param ItemWidth
 * @desc Item, gauge width(0 for default width)
 * @text Item, gauge width(5)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param SystemItemWidth
 * @desc Width of item name (default width at 0)
 * @text Width of item name(6)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param SystemNameColor
 * @desc System color ID for system items. You can enter the color code in the text tab.
 * @text System Name color(7)
 * @type color
 * @default 16
 * @min 0
 * 
 * @param FontSize
 * @desc Font size (difference from main font)
 * @text Font size(8)
 * @type number
 * @default -6
 * @min -99
 * 
 * @param ParamName
 * @desc Set the item name.
 * @text Name(9)
 * @type string
 * @default
 * 
 * @param DetaEval
 * @desc Enter an evaluation formula.
 * @text Evaluation formula(javaScript)(10)
 * @type combo
 * @option '$gameParty.steps();//Step'
 * @option '$gameSystem.battleCount();//Battle count'
 * @option '$gameSystem.escapeCount();//Escapes count'
 * @option '$gameSystem.saveCount();//Save count'
 * @option '$gameVariables.value(0);//Game variable'
 * @option '$gameSystem.chronus().getDateFormat(1);//”Chronus.js” datetime format 1'
 * @option '$gameSystem.chronus().getDateFormat(2);//”Chronus.js” datetime format 2'
 * @default 
 * 
 * @param Align
 * @desc Align.
 * @text Align(11)
 * @type select
 * @option Text code can be used (left) "Chapter" and "Action goal" only.
 * @value "TextEx"
 * @option Left
 * @value "left"
 * @option Center
 * @value "center"
 * @option Right
 * @value "right"
 * @default "left"
 * 
 * @param ShowEval
 * @desc Enter the display conditions in Javascript.
 * @text Display condition (javaScript)(12)
 * @type combo
 * @option '$gameSwitches.value(Number(actor.actor().meta.SaveActorShowSwitch))'
 * @option '(!info && $gameSystem.getVariableSaveFiles() <= savefileId);//Variable maximum save number final file judgment'
 * @default 
 * 
 * @param MethodName
 * @desc Method name
 * @text Method name(13)
 * @type string
 * @default 
 * 
 * @param FreeText
 * @desc Fill in your text. Text codes can be used.
 * @text Text(14)
 * @type string
 * @default 
 * 
 * @param paramUnit
 * @desc Unit.
 * @text Unit(15)
 * @type string
 * @default
 * 
 * @param Decimal
 * @text Decimal digits(16)
 * @desc The number of decimal places that can be displayed.
 * @type number
 * @default 0
 * @min 0
 * @max 99
 * 
 * 
 */
/*~struct~NotContentsListData:
 * 
 * @param DateSelect
 * @text status to display
 * @desc Specifies the status to display.
 * @type select
 * @option None
 * @value None
 * @option FileName(1)(2)(3)(4)(5)(8)
 * @value FileName
 * @option Line(1)(2)(3)(4)(5)(7)
 * @value HorzLine
 * @option Fre text(1)(2)(3)(4)(12)(14)
 * @value FreeText
 * @default None
 * 
 * @param X_Position
 * @text X display col position(1)
 * @desc X display col position.
 * @type number
 * @default 1
 * @min 1
 * @max 4
 * 
 * @param Y_Position
 * @desc Y display row position.
 * @text Y display row position(2)
 * @type number
 * @default 1
 * @min 1
 * @max 99
 * 
 * @param X_Coordinate
 * @text X coordinate (relative)(3)
 * @desc X coordinate (relative coordinate from X display col position)
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 * 
 * @param Y_Coordinate
 * @text Y coordinate (relative)(4)
 * @desc Y coordinate (relative coordinate from Y display row position)
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 * 
 * @param ItemWidth
 * @desc Item, gauge width(0 for default width)
 * @text Item, gauge width(5)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param SystemNameColor
 * @desc System color ID for system items. You can enter the color code in the text tab.
 * @text System Name color(7)
 * @type color
 * @default 16
 * @min 0
 * 
 * @param FontSize
 * @desc Font size (difference from main font)
 * @text Font size(8)
 * @type number
 * @default -6
 * @min -99
 * 
 * @param ShowEval
 * @desc Enter the display conditions in Javascript.
 * @text Display condition (javaScript)(12)
 * @type combo
 * @option '(!info && $gameSystem.getVariableSaveFiles() <= savefileId);//Variable maximum save number final file judgment'
 * @default 
 * 
 * @param FreeText
 * @desc Fill in your text. Text codes can be used.
 * @text Text(14)
 * @type string
 * @default 
 * 
 * 
 */
/*~struct~ContentsBackSettings:
 * 
 * @param ContentsBackGroundImg
 * @desc Specifies the content background image file name.
 * @text Content background image
 * @type file
 * @dir img/
 * @default 
 * 
 * @param Img_SX
 * @desc The display start coordinate X of the image.
 * @text Image display start coordinate X
 * @type number
 * @default 0
 * @min -9999
 * @max 9999
 * 
 * @param Img_SY
 * @desc The display start coordinate Y of the image.
 * @text Image display start coordinate Y
 * @type number
 * @default 0
 * @min -9999
 * @max 9999
 * 
 * @param Scale
 * @desc Content background image scaling factor (percentage)
 * @text Background image magnification (percentage)
 * @type number
 * @min 0
 * @default 100
 * 
 * 
 */
/*:ja
 * @target MZ
 * @plugindesc セーブ画面拡張
 * @author NUUN
 * @base NUUN_Base
 * @orderAfter NUUN_Base
 * @version 3.0.6
 * 
 * @help
 * セーブ画面をカスタマイズできます。
 * 
 * セーブメインウィンドウはセーブファイルのリストを表示するウィンドウです。
 * セーブステータスウィンドウは選択中のセーブ情報を表示するウィンドウです。このウィンドウは複数生成できます。
 * 
 * アクターの表示
 * アクター画像はキャラチップ、顔グラフィック、サイドビューアクターを表示できます。PartyActorModeで指定のメンバーを設定している場合は
 * 指定アクターのみ表示されます。
 * 
 * また、アクター名、職業、ニックネーム、レベルはアクター画像と同様にキャラ毎に表示可能です。PartyActorModeで指定のメンバーを設定している場合は
 * 指定アクターのみ表示されます。
 * 
 * 同じ項目で別の内容を表示させる場合はメソッド名に任意の文字列を記入します。(キャラチップ、顔グラフィック、サイドビューアクター、アクター名、レベル)
 * 
 * オリジナル項目
 * オリジナル項目を設定するにはメソッド名に任意の文字列を記入してください。
 * actor:$gameActors (指定のアクター変更で指定したアクター(指定してない場合はリーダー))
 * 
 * アクターオリジナルパラメータ
 * オリジナルパラメータを設定するにはメソッド名に任意の文字列を記入してください。
 * アクター画像と同様にキャラ毎に表示可能です。PartyActorModeで指定のメンバーを設定している場合は
 * 指定アクターのみ表示されます。
 * actor:$gameActors
 * 
 * 表示条件
 * actor:$gameActors (指定のアクター変更で指定したアクター(指定してない場合はリーダー))
 * フリーテキストの表示条件で参照できる変数はインフォ情報とファイル名番号及び表示ウィンドウのオブジェクトのみになります。
 * 
 * drawTextEx表示はプラグインパラメータのフォントサイズが適用されません。
 * テキストに\FS[x]で設定してください。
 * 
 * 背景画像の変更
 * ゲームの進行によって背景画像を変更出来ます。
 * 初期設定ではプラグインコマンド「背景画像変更」で変更したたびに背景IDが変更されます。
 * 背景IDはロード画面でIDの一番高いセーブデータの背景が表示されます。
 * 
 * オートセーブ時のスナップショット
 * オートセーブ時のスナップショットは戦闘開始直前のマップ、移動直前のマップが撮影されます。
 * 
 * スナップショットを表示するとセーブ容量が大きります。
 * 
 * コンテンツ背景の設定
 * 各セーブのコンテンツ背景に画像を設定できます。
 * 通常はリスト番号1番の背景が表示されます。
 * 2番以降はマップ毎でコンテンツ背景を変更したい場合に使用します。
 * プラグインコマンドでの変更は直接ファイルを指定します。
 * 
 * コンテンツ背景の画像の原点位置及び、拡大率はプラグインパラメータのコンテンツ背景画像設定で行います。
 * コンテンツ背景に設定された画像を同じ名前の画像が表示されるとき、設定された原点、拡大率が適用されます。
 * 設定されていない場合は原点0,0、拡大率100%で適用されます。
 * 
 * マップの設定のメモ欄
 * <SaveContentsBackImg:[filename]> コンテンツ背景の画像を指定します。このタグが設定されているマップは、プラグインパラメータ及びプラグインコマンドで
 * 設定された画像は適用されずマップに設定された画像が適用されます。
 * [filename]:コンテンツ背景画像のリスト番号
 * 
 * 利用規約
 * このプラグインはMITライセンスで配布しています。
 * 
 * 更新履歴
 * 2024/8/17 Ver.3.0.6
 * セーブ画面のオートセーブ表示を無効にしたときに、セーブファイルのカーソルが不自然になる問題を修正。
 * スペルミスを修正。
 * 2024/7/27 Ver.3.0.5
 * セーブインフォウィンドウでコンテンツ列数の設定を追加。
 * 一部項目に小数点数を指定できる機能を追加。
 * 2024/6/22 Ver.3.0.4
 * 項目の横幅が1項目の横幅より広く適用されない問題を修正。
 * 2024/6/1 Ver.3.0.3
 * 初回時に画像が表示されない問題を修正。
 * 2024/5/5 Ver.3.0.2
 * アクターオリジナルパラメータが表示されない問題を修正。
 * プラグインコマンドが実行できない問題を修正。
 * 単位を追加。
 * 2024/5/4 Ver.3.0.1
 * パラメータが取得されない問題を修正。
 * 2024/5/3 Ver.3.0.0
 * 初版
 * 
 * @command ChangeBackground
 * @desc 背景画像を変更します。
 * @text 背景画像変更
 * 
 * @arg BackGroundImg
 * @desc 背景画像ファイル名を指定します。
 * @text 背景画像
 * @type file
 * @dir img/
 * @default 
 * 
 * @arg BackGroundId
 * @desc 背景画像IDを設定します。IDの高いセーブデータの背景がロード画面で表示されます。背景画像ID自動設定がOFFの時有効です。
 * @text 背景画像ID
 * @type number
 * @default 0
 * @min 0
 * 
 * 
 * @command ChangeContentsBackground
 * @desc コンテンツ背景画像を変更します。
 * @text コンテンツ背景画像変更
 * 
 * @arg BackGroundImg
 * @desc 背景画像ファイル名を指定します。
 * @text 背景画像
 * @type file
 * @dir img/
 * @default 
 * 
 * 
 * @command UserAutoSave
 * @desc オートセーブ時を行います。
 * @text オートセーブ実行
 * 
 * @arg CompulsionAutoSave
 * @text セーブ禁止時実行
 * @desc セーブ禁止時でもオートセーブを実行します。
 * @type boolean
 * @default false
 * 
 * @arg OnSaveSnap
 * @text スナップショット許可
 * @desc オートセーブ時のスナップショットを許可します。
 * @type boolean
 * @default true
 * 
 * @command SnapShot
 * @desc 次回セーブ時のスナップショットを撮影します。
 * @text スナップショット撮影
 * 
 * @command SetAnyName
 * @desc 章の名称を記入します。
 * @text 章
 * 
 * @arg AnyName
 * @text 章テキスト
 * @desc 章テキストを記入します。現在のキャプターを表示したい時に設定します。
 * @type string
 * @default 
 * 
 * @command SpecifyActor
 * @desc セーブ画面に表示されるアクターを指定のアクターのみ表示させるアクターを設定します。
 * @text 指定のアクター変更
 * 
 * @arg ActorId
 * @text アクター
 * @desc アクターを指定します。0の場合はリーダーが表示されます。
 * @type actor
 * @default 0
 * 
 * 
 * @param SaveLayoutSetting
 * @text セーブレイアウト
 * @default ------------------------------
 * 
 * @param SaveLayoutStyle
 * @desc セーブスタイルを指定します。
 * @text セーブスタイル
 * @type combo
 * @option 'Default'
 * @option 'Default720P'
 * @option 'Type2'
 * @default 'Default'
 * @parent SaveLayoutSetting
 * 
 * @param SaveWindowSetting
 * @text セーブステータスウィンドウ
 * @default ------------------------------
 * 
 * @param SaveLayout
 * @desc 表示するセーブウィンドウを指定します。
 * @text セーブウィンドウ設定
 * @default ["{\"StyleName\":\"'Default'\",\"PartyActorMode\":\"'BattleMember'\",\"SaveSetting\":\"------------------------------\",\"NumSaveCols\":\"1\",\"NumSaveRows\":\"5\",\"SaveContentsCols\":\"2\",\"MaxSave\":\"20\",\"ContentsSetting\":\"------------------------------\",\"SaveHelpWindowList\":\"{\\\"MethodName\\\":\\\"\\\",\\\"WindowX\\\":\\\"0\\\",\\\"WindowY\\\":\\\"52\\\",\\\"WindowWidth\\\":\\\"0\\\",\\\"WindowHeight\\\":\\\"0\\\",\\\"WindowHeightRows\\\":\\\"1\\\",\\\"WindowVisible\\\":\\\"true\\\"}\",\"SaveMainWindowList\":\"{\\\"MethodName\\\":\\\"\\\",\\\"ContentsList\\\":\\\"[\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"CharacterChip\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"24\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Level\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"60\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"48\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"FileName\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-4\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Title\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"230\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"TextEx\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Lcation\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"230\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"260\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"70\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"現在地\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Gold\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"3\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"230\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"260\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"70\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"所持金\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"SaveTime\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"500\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"260\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"PlayTime\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"3\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"500\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"260\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"プレイ時間\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\"]\\\",\\\"NotContentsList\\\":\\\"\\\",\\\"WindowX\\\":\\\"0\\\",\\\"WindowY\\\":\\\"112\\\",\\\"WindowWidth\\\":\\\"0\\\",\\\"WindowHeight\\\":\\\"504\\\",\\\"WindowHeightRows\\\":\\\"0\\\",\\\"WindowVisible\\\":\\\"true\\\",\\\"ActorCols\\\":\\\"4\\\",\\\"ActorAreaWidth\\\":\\\"48\\\",\\\"ActorAreaHeight\\\":\\\"162\\\"}\",\"SaveStatusWindowListSetting\":\"------------------------------\",\"SaveStatusWindowList\":\"\",\"ListData1_10\":\"------------------------------\",\"PageList1\":\"[]\",\"PageList2\":\"[]\",\"PageList3\":\"[]\",\"PageList4\":\"[]\",\"PageList5\":\"[]\",\"PageList6\":\"[]\",\"PageList7\":\"[]\",\"PageList8\":\"[]\",\"PageList9\":\"[]\",\"PageList10\":\"[]\",\"SaveSnapSetting\":\"------------------------------\",\"InfoSaveSnap\":\"false\",\"SaveSnapQuality\":\"0.92\",\"SaveSnapScale\":\"12\",\"Actor\":\"------------------------------\",\"FaceWidth\":\"144\",\"FaceHeight\":\"144\",\"FaceScale\":\"100\",\"BackGround\":\"------------------------------\",\"BackGroundImg\":\"\",\"BackUiWidth\":\"true\",\"BackFitWidth\":\"false\",\"AutomaticSetting\":\"true\",\"ContentsBackVisible\":\"false\",\"ContentsBackGroundImg\":\"[]\",\"ContentsBackSettingsList\":\"\",\"ContentsBackScale\":\"100\"}","{\"StyleName\":\"'Default720P'\",\"PartyActorMode\":\"'BattleMember'\",\"SaveSetting\":\"------------------------------\",\"NumSaveCols\":\"1\",\"NumSaveRows\":\"5\",\"SaveContentsCols\":\"2\",\"MaxSave\":\"20\",\"ContentsSetting\":\"------------------------------\",\"SaveHelpWindowList\":\"{\\\"MethodName\\\":\\\"\\\",\\\"WindowX\\\":\\\"0\\\",\\\"WindowY\\\":\\\"52\\\",\\\"WindowWidth\\\":\\\"0\\\",\\\"WindowHeight\\\":\\\"0\\\",\\\"WindowHeightRows\\\":\\\"1\\\",\\\"WindowVisible\\\":\\\"true\\\"}\",\"SaveMainWindowList\":\"{\\\"MethodName\\\":\\\"\\\",\\\"ContentsList\\\":\\\"[\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"CharacterChip\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"3\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"20\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Level\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"32\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"48\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"FileName\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-4\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Title\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"230\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"TextEx\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Lcation\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"230\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"320\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"70\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"現在地\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"Gold\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"3\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"230\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"320\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"所持金\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"SaveTime\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"600\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"360\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"PlayTime\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"3\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"600\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"360\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"プレイ時間\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"SnapShot\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1040\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\"]\\\",\\\"NotContentsList\\\":\\\"\\\",\\\"WindowX\\\":\\\"0\\\",\\\"WindowY\\\":\\\"112\\\",\\\"WindowWidth\\\":\\\"0\\\",\\\"WindowHeight\\\":\\\"600\\\",\\\"WindowHeightRows\\\":\\\"0\\\",\\\"WindowVisible\\\":\\\"true\\\",\\\"ActorCols\\\":\\\"4\\\",\\\"ActorAreaWidth\\\":\\\"48\\\",\\\"ActorAreaHeight\\\":\\\"162\\\"}\",\"SaveStatusWindowListSetting\":\"------------------------------\",\"SaveStatusWindowList\":\"\",\"ListData1_10\":\"------------------------------\",\"PageList1\":\"[]\",\"PageList2\":\"[]\",\"PageList3\":\"[]\",\"PageList4\":\"[]\",\"PageList5\":\"[]\",\"PageList6\":\"[]\",\"PageList7\":\"[]\",\"PageList8\":\"[]\",\"PageList9\":\"[]\",\"PageList10\":\"[]\",\"SaveSnapSetting\":\"------------------------------\",\"InfoSaveSnap\":\"true\",\"SaveSnapQuality\":\"0.92\",\"SaveSnapScale\":\"12\",\"Actor\":\"------------------------------\",\"FaceWidth\":\"144\",\"FaceHeight\":\"144\",\"FaceScale\":\"100\",\"BackGround\":\"------------------------------\",\"BackGroundImg\":\"\",\"BackUiWidth\":\"true\",\"BackFitWidth\":\"false\",\"AutomaticSetting\":\"true\",\"ContentsBackVisible\":\"false\",\"ContentsBackGroundImg\":\"[]\",\"ContentsBackSettingsList\":\"\",\"ContentsBackScale\":\"100\"}","{\"StyleName\":\"'Type2'\",\"PartyActorMode\":\"'Actor'\",\"SaveSetting\":\"------------------------------\",\"NumSaveCols\":\"1\",\"NumSaveRows\":\"10\",\"SaveContentsCols\":\"1\",\"MaxSave\":\"20\",\"ContentsSetting\":\"------------------------------\",\"SaveHelpWindowList\":\"{\\\"MethodName\\\":\\\"\\\",\\\"WindowX\\\":\\\"0\\\",\\\"WindowY\\\":\\\"52\\\",\\\"WindowWidth\\\":\\\"0\\\",\\\"WindowHeight\\\":\\\"0\\\",\\\"WindowHeightRows\\\":\\\"1\\\",\\\"WindowVisible\\\":\\\"true\\\"}\",\"SaveMainWindowList\":\"{\\\"MethodName\\\":\\\"\\\",\\\"ContentsList\\\":\\\"[\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"FileName\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"PlayTime\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"280\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\"]\\\",\\\"NotContentsList\\\":\\\"[\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"FileName\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ParamName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"DetaEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Align\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ShowEval\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"MethodName\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"{\\\\\\\\\\\\\\\"DateSelect\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Position\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"X_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"280\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"Y_Coordinate\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"12\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ItemWidth\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"SystemNameColor\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"16\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FontSize\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"-6\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"FreeText\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\FS[20]No Data\\\\\\\\\\\\\\\"}\\\\\\\"]\\\",\\\"WindowX\\\":\\\"0\\\",\\\"WindowY\\\":\\\"112\\\",\\\"WindowWidth\\\":\\\"420\\\",\\\"WindowHeight\\\":\\\"504\\\",\\\"WindowHeightRows\\\":\\\"0\\\",\\\"WindowVisible\\\":\\\"true\\\",\\\"ActorCols\\\":\\\"1\\\",\\\"ActorAreaWidth\\\":\\\"48\\\",\\\"ActorAreaHeight\\\":\\\"162\\\"}\",\"SaveStatusWindowListSetting\":\"------------------------------\",\"SaveStatusWindowList\":\"[\\\"{\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ListDateSetting\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"ListNotDateSetting\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WindowX\\\\\\\":\\\\\\\"420\\\\\\\",\\\\\\\"WindowY\\\\\\\":\\\\\\\"112\\\\\\\",\\\\\\\"WindowWidth\\\\\\\":\\\\\\\"388\\\\\\\",\\\\\\\"WindowHeight\\\\\\\":\\\\\\\"504\\\\\\\",\\\\\\\"WindowHeightRows\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WindowVisible\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"ActorCols\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"ActorAreaWidth\\\\\\\":\\\\\\\"48\\\\\\\",\\\\\\\"ActorAreaHeight\\\\\\\":\\\\\\\"162\\\\\\\"}\\\"]\",\"ListData1_10\":\"------------------------------\",\"PageList1\":\"[\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"FileName\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Face\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"ActorName\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"162\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"ClassName\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"3\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"162\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Nickname\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"162\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Level\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"162\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"HP\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"6\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"-12\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"MP\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"7\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"-12\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Atk\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Def\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"9\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Mat\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Mdf\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"11\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Agi\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"DateSelect\\\\\\\":\\\\\\\"Luk\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"13\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemNameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"FontSize\\\\\\\":\\\\\\\"-6\\\\\\\",\\\\\\\"ParamName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Align\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"right\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"MethodName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"FreeText\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\",\"PageList2\":\"[]\",\"PageList3\":\"[]\",\"PageList4\":\"[]\",\"PageList5\":\"[]\",\"PageList6\":\"[]\",\"PageList7\":\"[]\",\"PageList8\":\"[]\",\"PageList9\":\"[]\",\"PageList10\":\"[]\",\"SaveSnapSetting\":\"------------------------------\",\"InfoSaveSnap\":\"false\",\"SaveSnapQuality\":\"0.92\",\"SaveSnapScale\":\"12\",\"Actor\":\"------------------------------\",\"FaceWidth\":\"144\",\"FaceHeight\":\"144\",\"FaceScale\":\"100\",\"BackGround\":\"------------------------------\",\"BackGroundImg\":\"\",\"BackUiWidth\":\"true\",\"BackFitWidth\":\"false\",\"AutomaticSetting\":\"true\",\"ContentsBackVisible\":\"false\",\"ContentsBackGroundImg\":\"[]\",\"ContentsBackSettingsList\":\"\",\"ContentsBackScale\":\"100\"}"]
 * @type struct<SaveLayoutList>[]
 * @parent SaveWindowSetting
 * 
 * @param BasicSetting
 * @text 基本設定
 * @default ------------------------------
 * 
 * @param DecimalMode
 * @text 端数処理四捨五入
 * @desc 表示外小数点を四捨五入で丸める。（falseで切り捨て）
 * @type boolean
 * @default true
 * @parent BasicSetting
 * 
 * @param DayTime
 * @desc 表示する日時フォーマット
 * @text 日時フォーマット
 * @type select
 * @option 標準
 * @value 'default'
 * @option 西暦月日
 * @value 'ja-JP'
 * @option 元号表記
 * @value 'ja-JP-u-ca-japanese'
 * @option 米国表記
 * @value 'en-US'
 * @option 英国表記
 * @value 'en-GB'
 * @default 'default'
 * @parent BasicSetting
 * 
 * @param AutoSaveSetting
 * @text オートセーブ設定
 * @default ------------------------------
 * 
 * @param SaveFileShowAutoSave
 * @text セーブ画面オートセーブ表示
 * @desc セーブ画面でのオートセーブ表示。
 * @type boolean
 * @default true
 * @parent AutoSaveSetting
 * 
 * @param MapTransferAutoSave
 * @text マップ移動時オートセーブ有効
 * @desc マップ移動時のオートセーブ有効。
 * @type boolean
 * @default true
 * @parent AutoSaveSetting
 * 
 * @param BattleEndAutoSave
 * @text 戦闘終了後オートセーブ有効
 * @desc 戦闘終了後のオートセーブ有効。
 * @type boolean
 * @default true
 * @parent AutoSaveSetting
 * 
 * @param AutoSaveEnabledSwitch
 * @desc 戦闘後、移動時のオートセーブ実行を禁止にするスイッチを指定します。(0でオートセーブを有効化ON)
 * @text 戦闘後、移動時オートセーブ実行禁止
 * @type switch
 * @default 0
 * @parent AutoSaveSetting
 * 
 * @param AnyName
 * @text 章設定
 * @default ------------------------------
 * 
 * @param AnyNameVariable
 * @desc 章テキスト変数番号。プラグインコマンド「章テキスト」で設定している場合は表示されません。
 * @text 章テキスト表示変数番号
 * @type variable
 * @default 0
 * @parent AnyName
 * 
 */
/*~struct~SaveLayoutList:ja
 * 
 * @param StyleName
 * @desc セーブレイアウトのスタイル名。
 * @text セーブレイアウトスタイル
 * @type combo
 * @option 'Default'
 * @default 'Default'
 * 
 * @param PartyActorMode
 * @desc 表示するアクター
 * @text 表示アクター
 * @type select
 * @option 指定のメンバー
 * @value 'Actor'
 * @option バトルメンバー
 * @value 'BattleMember'
 * @option パーティメンバー(控え含む)
 * @value 'PartyMember'
 * @default 'BattleMember'
 * 
 * @param SaveSetting
 * @text セーブ設定
 * @default ------------------------------
 * 
 * @param NumSaveCols
 * @desc 画面に表示するセーブ列数
 * @text 表示セーブ列数
 * @type number
 * @default 1
 * @min 1
 * @parent SaveSetting
 * 
 * @param NumSaveRows
 * @desc 画面に表示するセーブ行数
 * @text 表示セーブ行数
 * @type number
 * @default 5
 * @min 1
 * @parent SaveSetting
 * 
 * @param SaveContentsCols
 * @desc 画面に表示するセーブの項目列数
 * @text 表示セーブ項目列数
 * @type number
 * @default 2
 * @min 1
 * @parent SaveSetting
 * 
 * @param MaxSave
 * @desc 最大セーブ数
 * @text 最大セーブ数
 * @type number
 * @default 20
 * @min 1
 * @parent SaveSetting
 * 
 * @param ContentsSetting
 * @text コンテンツ設定
 * @default ------------------------------
 * 
 * @param SaveHelpWindowList
 * @desc ヘルプウィンドウを設定する
 * @text セーブヘルプウィンドウ設定
 * @type struct<SaveHelpWindowListData>
 * @default {"MethodName":"","WindowX":"0","WindowY":"0","WindowWidth":"0","WindowHeight":"0","WindowHeightRows":"1","WindowVisible":"true"}
 * @parent ContentsSetting
 * 
 * @param SaveMainWindowList
 * @desc セーブ一覧を表示するウィンドウ設定
 * @text セーブメインウィンドウ設定
 * @type struct<SaveMainWindowListData>
 * @default {"MethodName":"","ContentsList":"[\"{\\\"DateSelect\\\":\\\"None\\\",\\\"X_Position\\\":\\\"1\\\",\\\"Y_Position\\\":\\\"1\\\",\\\"X_Coordinate\\\":\\\"0\\\",\\\"Y_Coordinate\\\":\\\"0\\\",\\\"ItemWidth\\\":\\\"0\\\",\\\"SystemItemWidth\\\":\\\"0\\\",\\\"SystemNameColor\\\":\\\"16\\\",\\\"FontSize\\\":\\\"-6\\\",\\\"ParamName\\\":\\\"\\\",\\\"DetaEval\\\":\\\"\\\",\\\"Align\\\":\\\"\\\\\\\"left\\\\\\\"\\\",\\\"ShowEval\\\":\\\"\\\",\\\"MethodName\\\":\\\"\\\",\\\"FreeText\\\":\\\"\\\"}\"]","NotContentsList":"","WindowX":"0","WindowY":"0","WindowWidth":"0","WindowHeight":"0","WindowHeightRows":"0","WindowVisible":"true","ActorCols":"4","ActorAreaWidth":"48","ActorAreaHeight":"162"}
 * @parent ContentsSetting
 * 
 * @param SaveStatusWindowListSetting
 * @text セーブステータス設定
 * @default ------------------------------
 * @parent ContentsSetting
 * 
 * @param SaveStatusWindowList
 * @desc セーブファイルごとに表示を切り替えるウィンドウ設定。
 * @text セーブステータスウィンドウ設定
 * @type struct<SaveWindowListData>[]
 * @default 
 * @parent SaveStatusWindowListSetting
 * 
 * @param ListData1_10
 * @text 表示項目設定1-10
 * @default ------------------------------
 * @parent SaveStatusWindowListSetting
 * 
 * @param PageList1
 * @desc 表示するリスト。
 * @text 表示リスト１
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 *  
 * @param PageList2
 * @desc 表示するリスト。
 * @text 表示リスト２
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList3
 * @desc 表示するリスト。
 * @text 表示リスト３
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList4
 * @desc 表示するリスト。
 * @text 表示リスト４
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList5
 * @desc 表示するリスト。
 * @text 表示リスト５
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList6
 * @desc 表示するリスト。
 * @text 表示リスト６
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList7
 * @desc 表示するリスト。
 * @text 表示リスト７
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList8
 * @desc 表示するリスト。
 * @text 表示リスト８
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList9
 * @desc 表示するリスト。
 * @text 表示リスト９
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param PageList10
 * @desc 表示するリスト。
 * @text 表示リスト１０
 * @type struct<StatusListData>[]
 * @default []
 * @parent ListData1_10
 * 
 * @param SaveSnapSetting
 * @text セーブスナップショット設定
 * @default ------------------------------
 * 
 * @param InfoSaveSnap
 * @text スナップショット有効化
 * @desc スナップショットを有効にします。
 * @type boolean
 * @default false
 * @parent SaveSnapSetting
 * 
 * @param SaveSnapQuality
 * @desc スナップショットの画質。(デフォルト値0.92)
 * @text スナップショット画質
 * @type string
 * @default 0.92
 * @max 1
 * @parent SaveSnapSetting
 * 
 * @param SaveSnapScale
 * @desc スナップショットの拡大率（百分率）
 * @text スナップショット拡大率（百分率）
 * @type number
 * @default 12
 * @min 0
 * @parent SaveSnapSetting
 * 
 * @param Actor
 * @text アクター設定
 * @default ------------------------------
 * 
 * @param FaceWidth
 * @desc 顔グラの横幅
 * @text 顔グラの横幅
 * @type number
 * @default 144
 * @min 0
 * @parent Actor
 * 
 * @param FaceHeight
 * @desc 顔グラの縦幅
 * @text 顔グラの縦幅
 * @type number
 * @default 144
 * @parent Actor
 * 
 * @param FaceScale
 * @desc 顔グラの拡大率
 * @text 拡大率
 * @type number
 * @default 100
 * @parent Actor
 * 
 * @param BackGround
 * @text 背景設定
 * @default ------------------------------
 * 
 * @param BackGroundImg
 * @desc 背景画像ファイル名を指定します。
 * @text 背景画像
 * @type file
 * @dir img/
 * @default 
 * @parent BackGround
 * 
 * @param BackUiWidth
 * @text 背景画像ウィンドウUIサイズ
 * @desc 背景画像をウィンドウUIサイズに合わせる。
 * @type boolean
 * @default true
 * @parent BackGround
 * 
 * @param BackFitWidth
 * @text 背景画像拡大
 * @desc 背景画像をウィンドウサイズまたは画面に合わせ拡大します。
 * @type boolean
 * @default false
 * @parent BackGround
 * 
 * @param AutomaticSetting
 * @text 背景画像ID自動設定
 * @desc 背景画像IDを自動で設定します。背景画像を変更した際、IDの高いセーブデータの背景がロード画面で表示されます。
 * @type boolean
 * @default true
 * @parent BackGround
 * 
 * @param ContentsBackVisible
 * @text コンテンツ背景表示なし
 * @desc コンテンツの背景画像を表示しません。
 * @type boolean
 * @default false
 * @parent BackGround
 * 
 * @param ContentsBackGroundImg
 * @desc コンテンツ背景画像ファイル名を指定します。
 * @text コンテンツ背景画像
 * @type file[]
 * @dir img/
 * @default []
 * @parent BackGround
 * 
 * @param ContentsBackSettingsList
 * @desc コンテンツ背景の画像設定を行います。
 * @text コンテンツ背景画像設定
 * @type struct<ContentsBackSettings>[]
 * @default 
 * @parent BackGround
 * 
 * @param ContentsBackScale
 * @desc デフォルトのコンテンツ背景画像の拡大率(百分率)
 * @text コンテンツ背景画像拡大率(百分率)
 * @type number
 * @min 0
 * @default 100
 * @parent BackGround
 * 
 */
/*~struct~SaveHelpWindowListData:ja
 * 
 * @param MethodName
 * @desc ウィンドウの識別名を指定します。
 * @text 識別名
 * @type string
 * @default
 * 
 * @param WindowX
 * @text ウィンドウX座標
 * @desc ウィンドウのX座標
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param WindowY
 * @desc ウィンドウのY座標
 * @text ウィンドウY座標
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param WindowWidth
 * @text ウィンドウ横幅
 * @desc ウィンドウの横幅。0で画面UI幅
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowHeight
 * @text ウィンドウの縦幅
 * @desc ウィンドウ縦幅。0で画面UI高さ
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowHeightRows
 * @text ウィンドウ高さ
 * @desc ウィンドウの高さ(行数指定) 0でWindowHeight指定
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowVisible
 * @text ウィンドウスキン画像表示
 * @desc ウィンドウスキン画像を表示する。
 * @type boolean
 * @default true
 * 
 */
/*~struct~SaveMainWindowListData:ja
 * 
 * @param MethodName
 * @desc ウィンドウの識別名を指定します。
 * @text 識別名
 * @type string
 * @default
 *
 * @param ContentsList
 * @desc 表示する項目。
 * @text 表示項目
 * @type struct<ContentsListData>[]
 * @default 
 * 
 * @param NotContentsList
 * @desc ファイルがないリストを表示する項目。
 * @text ファイル無し表示項目
 * @type struct<NotContentsListData>[]
 * @default 
 * 
 * @param WindowX
 * @text ウィンドウX座標
 * @desc ウィンドウのX座標
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param WindowY
 * @desc ウィンドウのY座標
 * @text ウィンドウY座標
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param WindowWidth
 * @text ウィンドウ横幅
 * @desc ウィンドウの横幅。0で画面UI幅
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowHeight
 * @text ウィンドウの縦幅
 * @desc ウィンドウ縦幅。0で画面UI高さ
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowHeightRows
 * @text ウィンドウ高さ
 * @desc ウィンドウの高さ(行数指定) 0でWindowHeight指定
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowVisible
 * @text ウィンドウスキン画像表示
 * @desc ウィンドウスキン画像を表示する。
 * @type boolean
 * @default true
 * 
 * @param ActorCols
 * @text アクター表示列数
 * @desc アクターの表示列数
 * @type number
 * @default 4
 * @min 1
 * 
 * @param ActorAreaWidth
 * @text アクター横間隔幅
 * @desc アクターの横間隔幅。
 * @type number
 * @default 48
 * @min 0
 * 
 * @param ActorAreaHeight
 * @text アクター縦間隔幅
 * @desc アクターの縦間隔幅。
 * @type number
 * @default 162
 * @min 0
 * 
 * 
 */
/*~struct~SaveWindowListData:ja
 * 
 * @param MethodName
 * @desc ウィンドウの識別名を指定します。
 * @text 識別名
 * @type string
 * @default
 *
 * @param ListDateSetting
 * @desc 表示するリストを指定します。
 * @text 表示リスト指定
 * @type select
 * @option なし
 * @value 0
 * @option 表示リスト１
 * @value 1
 * @option 表示リスト２
 * @value 2
 * @option 表示リスト３
 * @value 3
 * @option 表示リスト４
 * @value 4
 * @option 表示リスト５
 * @value 5
 * @option 表示リスト６
 * @value 6
 * @option 表示リスト７
 * @value 7
 * @option 表示リスト８
 * @value 8
 * @option 表示リスト９
 * @value 9
 * @option 表示リスト１０
 * @value 10
 * @default 0
 * 
 * @param ListNotDateSetting
 * @desc セーブファイルがない場合のリストを指定します。
 * @text セーブファイル無し表示リスト指定
 * @type select
 * @option なし
 * @value 0
 * @option 表示リスト１
 * @value 1
 * @option 表示リスト２
 * @value 2
 * @option 表示リスト３
 * @value 3
 * @option 表示リスト４
 * @value 4
 * @option 表示リスト５
 * @value 5
 * @option 表示リスト６
 * @value 6
 * @option 表示リスト７
 * @value 7
 * @option 表示リスト８
 * @value 8
 * @option 表示リスト９
 * @value 9
 * @option 表示リスト１０
 * @value 10
 * @default 0
 * 
 * @param SaveStatusContentsCols
 * @desc 画面に表示するセーブの項目列数
 * @text 表示セーブ項目列数
 * @type number
 * @default 2
 * @min 1
 * 
 * @param WindowX
 * @text ウィンドウX座標
 * @desc ウィンドウのX座標
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param WindowY
 * @desc ウィンドウのY座標
 * @text ウィンドウY座標
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param WindowWidth
 * @text ウィンドウ横幅
 * @desc ウィンドウの横幅。0で画面UI幅
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowHeight
 * @text ウィンドウの縦幅
 * @desc ウィンドウ縦幅。0で画面UI高さ
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowHeightRows
 * @text ウィンドウ高さ
 * @desc ウィンドウの高さ(行数指定) 0でWindowHeight指定
 * @type number
 * @default 0
 * @min 0
 * 
 * @param WindowVisible
 * @text ウィンドウスキン画像表示
 * @desc ウィンドウスキン画像を表示する。
 * @type boolean
 * @default true
 * 
 * 
 * @param ActorCols
 * @text アクター表示列数
 * @desc アクターの表示列数
 * @type number
 * @default 4
 * @min 1
 * 
 * @param ActorAreaWidth
 * @text アクター横間隔幅
 * @desc アクターの横間隔幅。
 * @type number
 * @default 48
 * @min 0
 * 
 * @param ActorAreaHeight
 * @text アクター縦間隔幅
 * @desc アクターの縦間隔幅。
 * @type number
 * @default 162
 * @min 0
 * 
 * 
 */
/*~struct~ContentsListData:ja
 * 
 * @param DateSelect
 * @text 表示するステータス
 * @desc 表示するステータスを指定します。※は表示アクター毎に表示されます。
 * @type select
 * @option なし
 * @value None
 * @option プレイ時間(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value PlayTime
 * @option セーブ時刻(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value SaveTime
 * @option 現在地(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value Lcation
 * @option 所持金(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value Gold
 * @option オリジナル項目(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)(11)(13)(15)(16)
 * @value OriginalParam
 * @option ファイル名(1)(2)(3)(4)(5)(8)
 * @value FileName
 * @option タイトル(1)(2)(3)(4)(5)(8)(11)
 * @value Title
 * @option 章(1)(2)(3)(4)(5)(8)(11)
 * @value Chapter
 * @option 行動目標(1)(2)(3)(4)(5)(8)(11)
 * @value ActionGoal
 * @option アクター名※(1)(2)(3)(4)(5)(8)(12)(13)
 * @value ActorName
 * @option クラス※(1)(2)(3)(4)(5)(8)
 * @value ClassName
 * @option 二つ名※(Nickname)(1)(2)(3)(4)(5)(8)
 * @value Nickname
 * @option レベル※(1)(2)(3)(4)(5)(8)(11)(12)(13)
 * @value Level
 * @option キャラチップ※(1)(2)(3)(4)(5)(12)(13)
 * @value CharacterChip
 * @option 顔グラ※(1)(2)(3)(4)(12)(13)
 * @value Face
 * @option SVアクター※(1)(2)(3)(4)(5)(12)(13)
 * @value SvActor
 * @option スナップショット(1)(2)(3)(4)
 * @value SnapShot
 * @option ライン(1)(2)(3)(4)(5)(7)
 * @value HorzLine
 * @option フリーテキスト(1)(2)(3)(4)(12)(14)
 * @value FreeText
 * @default None
 * 
 * @param X_Position
 * @text X表示列位置(1)
 * @desc X表示列位置
 * @type number
 * @default 1
 * @min 1
 * @max 4
 * 
 * @param Y_Position
 * @desc Y表示行位置
 * @text Y表示行位置(2)
 * @type number
 * @default 1
 * @min 1
 * @max 99
 * 
 * @param X_Coordinate
 * @text X座標（相対）(3)
 * @desc X座標（X表示列位置からの相対座標）
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 * 
 * @param Y_Coordinate
 * @text Y座標（相対）(4)
 * @desc Y座標（Y表示列位置からの相対座標）
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 * 
 * @param ItemWidth
 * @desc 項目横幅（0でデフォルト幅）
 * @text 項目横幅(5)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param SystemItemWidth
 * @desc システム項目の横幅（0でデフォルト幅）
 * @text システム項目横幅(6)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param SystemNameColor
 * @desc システム項目の文字色。テキストタブでカラーコードを入力できます。
 * @text システム項目文字色(7)
 * @type color
 * @default 16
 * @min 0
 * 
 * @param FontSize
 * @desc フォントサイズ（メインフォントからの差）
 * @text フォントサイズ(8)
 * @type number
 * @default -6
 * @min -99
 * 
 * @param ParamName
 * @desc 項目の名称を設定します。
 * @text 名称(9)
 * @type string
 * @default
 * 
 * @param DetaEval
 * @desc 評価式。
 * @text 評価式(javaScript)(10)
 * @type combo
 * @option '$gameParty.steps();//歩数'
 * @option '$gameSystem.battleCount();//戦闘回数'
 * @option '$gameSystem.escapeCount();//逃走回数'
 * @option '$gameSystem.saveCount();//セーブ回数'
 * @option '$gameVariables.value(0);//ゲーム変数'
 * @option '$gameSystem.chronus().getDateFormat(1);//ゲーム内時間の導入プラグイン日時フォーマット1'
 * @option '$gameSystem.chronus().getDateFormat(2);//ゲーム内時間の導入プラグイン日時フォーマット2'
 * @default 
 * 
 * @param Align
 * @desc 文字揃え。
 * @text 文字揃え(11)
 * @type select
 * @option 制御文字使用可(左揃え)章と行動目標のみ
 * @value "TextEx"
 * @option 左
 * @value "left"
 * @option 中央
 * @value "center"
 * @option 右
 * @value "right"
 * @default "left"
 * 
 * @param ShowEval
 * @desc 表示条件をJavascriptで記入します。
 * @text 表示条件(javaScript)(12)
 * @type combo
 * @option '$gameSwitches.value(Number(actor.actor().meta.SaveActorShowSwitch))'
 * @option '(!info && $gameSystem.getVariableSaveFiles() <= savefileId);//可変最大セーブ数最終ファイル判定'
 * @default 
 * 
 * @param MethodName
 * @desc メソッド名
 * @text メソッド名(13)
 * @type string
 * @default 
 * 
 * @param FreeText
 * @desc テキストを記入します。制御文字が使用できます。
 * @text テキスト(14)
 * @type string
 * @default 
 * 
 * @param paramUnit
 * @desc 単位。
 * @text 単位(15)
 * @type string
 * @default
 * 
 * @param Decimal
 * @text 小数点桁数(16)
 * @desc 表示出来る小数点桁数。
 * @type number
 * @default 0
 * @min 0
 * @max 99
 * 
 * 
 */
/*~struct~StatusListData:ja
 * 
 * @param DateSelect
 * @text 表示するステータス
 * @desc 表示するステータスを指定します。※は表示アクター毎に表示されます。
 * @type select
 * @option なし
 * @value None
 * @option プレイ時間(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value PlayTime
 * @option セーブ時刻(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value SaveTime
 * @option 現在地(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value Lcation
 * @option 所持金(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)
 * @value Gold
 * @option オリジナル項目(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)(11)(13)(15)(16)
 * @value OriginalParam
 * @option ファイル名(1)(2)(3)(4)(5)(8)
 * @value FileName
 * @option タイトル(1)(2)(3)(4)(5)(8)(11)
 * @value Title
 * @option 章(1)(2)(3)(4)(5)(8)(11)
 * @value Chapter
 * @option 行動目標(1)(2)(3)(4)(5)(8)(11)
 * @value ActionGoal
 * @option アクター名※(1)(2)(3)(4)(5)(8)(12)(13)
 * @value ActorName
 * @option クラス※(1)(2)(3)(4)(5)(8)
 * @value ClassName
 * @option 二つ名※(Nickname)(1)(2)(3)(4)(5)(8)
 * @value Nickname
 * @option レベル※(1)(2)(3)(4)(5)(8)(11)(12)(13)
 * @value Level
 * @option キャラチップ※(1)(2)(3)(4)(5)(12)(13)
 * @value CharacterChip
 * @option 顔グラ※(1)(2)(3)(4)(12)(13)
 * @value Face
 * @option SVアクター※(1)(2)(3)(4)(5)(12)(13)
 * @value SvActor
 * @option スナップショット(1)(2)(3)(4)
 * @value SnapShot
 * @option ライン(1)(2)(3)(4)(5)(7)
 * @value HorzLine
 * @option フリーテキスト(1)(2)(3)(4)(12)(14)
 * @value FreeText
 * @option HP※(1)(2)(3)(4)(5)(7)
 * @value HP
 * @option MP※(1)(2)(3)(4)(5)(7)
 * @value MP
 * @option 攻撃力※(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(15)
 * @value Atk
 * @option 防御力※(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(15)
 * @value Def
 * @option 魔法力※(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(15)
 * @value Mat
 * @option 魔法防御※(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(15)
 * @value Mdf
 * @option 敏捷性※(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(15)
 * @value Agi
 * @option 運※(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(15)
 * @value Luk
 * @option アクターオリジナルパラメータ※(1)(2)(3)(4)(5)(6)(7)(8)(9)(11)(13)(15)
 * @value ActorOriginalParam
 * @default None
 * 
 * @param X_Position
 * @text X表示列位置(1)
 * @desc X表示列位置
 * @type number
 * @default 1
 * @min 1
 * @max 4
 * 
 * @param Y_Position
 * @desc Y表示行位置
 * @text Y表示行位置(2)
 * @type number
 * @default 1
 * @min 1
 * @max 99
 * 
 * @param X_Coordinate
 * @text X座標（相対）(3)
 * @desc X座標（X表示列位置からの相対座標）
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 * 
 * @param Y_Coordinate
 * @text Y座標（相対）(4)
 * @desc Y座標（Y表示列位置からの相対座標）
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 * 
 * @param ItemWidth
 * @desc 項目横幅（0でデフォルト幅）
 * @text 項目横幅(5)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param SystemItemWidth
 * @desc システム項目の横幅（0でデフォルト幅）
 * @text システム項目横幅(6)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param SystemNameColor
 * @desc システム項目の文字色。テキストタブでカラーコードを入力できます。
 * @text システム項目文字色(7)
 * @type color
 * @default 16
 * @min 0
 * 
 * @param FontSize
 * @desc フォントサイズ（メインフォントからの差）
 * @text フォントサイズ(8)
 * @type number
 * @default -6
 * @min -99
 * 
 * @param ParamName
 * @desc 項目の名称を設定します。
 * @text 名称(9)
 * @type string
 * @default
 * 
 * @param DetaEval
 * @desc 評価式。
 * @text 評価式(javaScript)(10)
 * @type combo
 * @option '$gameParty.steps();//歩数'
 * @option '$gameSystem.battleCount();//戦闘回数'
 * @option '$gameSystem.escapeCount();//逃走回数'
 * @option '$gameSystem.saveCount();//セーブ回数'
 * @option '$gameVariables.value(0);//ゲーム変数'
 * @option '$gameSystem.chronus().getDateFormat(1);//ゲーム内時間の導入プラグイン日時フォーマット1'
 * @option '$gameSystem.chronus().getDateFormat(2);//ゲーム内時間の導入プラグイン日時フォーマット2'
 * @default 
 * 
 * @param Align
 * @desc 文字揃え。
 * @text 文字揃え(11)
 * @type select
 * @option 制御文字使用可(左揃え)章と行動目標のみ
 * @value "TextEx"
 * @option 左
 * @value "left"
 * @option 中央
 * @value "center"
 * @option 右
 * @value "right"
 * @default "left"
 * 
 * @param ShowEval
 * @desc 表示条件をJavascriptで記入します。
 * @text 表示条件(javaScript)(12)
 * @type combo
 * @option '$gameSwitches.value(Number(actor.actor().meta.SaveActorShowSwitch))'
 * @option '(!info && $gameSystem.getVariableSaveFiles() <= savefileId);//可変最大セーブ数最終ファイル判定'
 * @default 
 * 
 * @param MethodName
 * @desc メソッド名
 * @text メソッド名(13)
 * @type string
 * @default 
 * 
 * @param FreeText
 * @desc テキストを記入します。制御文字が使用できます。
 * @text テキスト(14)
 * @type string
 * @default 
 * 
 * @param paramUnit
 * @desc 単位。
 * @text 単位(15)
 * @type string
 * @default
 * 
 * @param Decimal
 * @text 小数点桁数(16)
 * @desc 表示出来る小数点桁数。
 * @type number
 * @default 0
 * @min 0
 * @max 99
 * 
 * 
 */
/*~struct~NotContentsListData:ja
 * 
 * @param DateSelect
 * @text 表示するステータス
 * @desc 表示するステータスを指定します。
 * @type select
 * @option なし
 * @value None
 * @option ファイル名(1)(2)(3)(4)(5)(8)
 * @value FileName
 * @option ライン(1)(2)(3)(4)(5)(7)
 * @value HorzLine
 * @option フリーテキスト(1)(2)(3)(4)(12)(14)
 * @value FreeText
 * @default None
 * 
 * @param X_Position
 * @text X表示列位置(1)
 * @desc X表示列位置
 * @type number
 * @default 1
 * @min 1
 * @max 4
 * 
 * @param Y_Position
 * @desc Y表示行位置
 * @text Y表示行位置(2)
 * @type number
 * @default 1
 * @min 1
 * @max 99
 * 
 * @param X_Coordinate
 * @text X座標（相対）(3)
 * @desc X座標（X表示列位置からの相対座標）
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 * 
 * @param Y_Coordinate
 * @text Y座標（相対）(4)
 * @desc Y座標（Y表示列位置からの相対座標）
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 * 
 * @param ItemWidth
 * @desc 項目横幅（0でデフォルト幅）
 * @text 項目横幅(5)
 * @type number
 * @default 0
 * @min 0
 * 
 * @param SystemNameColor
 * @desc システム項目の文字色。テキストタブでカラーコードを入力できます。
 * @text システム項目文字色(7)
 * @type color
 * @default 16
 * @min 0
 * 
 * @param FontSize
 * @desc フォントサイズ（メインフォントからの差）
 * @text フォントサイズ(8)
 * @type number
 * @default -6
 * @min -99
 * 
 * @param ShowEval
 * @desc 表示条件をJavascriptで記入します。
 * @text 表示条件(javaScript)(12)
 * @type combo
 * @option '(!info && $gameSystem.getVariableSaveFiles() <= savefileId);//可変最大セーブ数最終ファイル判定'
 * @default 
 * 
 * @param FreeText
 * @desc テキストを記入します。制御文字が使用できます。
 * @text テキスト(14)
 * @type string
 * @default 
 * 
 * 
 */
/*~struct~ContentsBackSettings:ja
 * 
 * @param ContentsBackGroundImg
 * @desc コンテンツ背景画像ファイル名を指定します。
 * @text コンテンツ背景画像
 * @type file
 * @dir img/
 * @default 
 * 
 * @param Img_SX
 * @desc 画像の表示開始座標X。
 * @text 画像表示開始座標X
 * @type number
 * @default 0
 * @min -9999
 * @max 9999
 * 
 * @param Img_SY
 * @desc 画像の表示開始座標Y
 * @text 画像表示開始座標Y
 * @type number
 * @default 0
 * @min -9999
 * @max 9999
 * 
 * @param Scale
 * @desc コンテンツ背景画像の拡大率(百分率)
 * @text コンテンツ背景画像拡大率(百分率)
 * @type number
 * @min 0
 * @default 100
 * 
 * 
 */

var Imported = Imported || {};
Imported.NUUN_SaveScreen_3 = true;

(() => {
    const params = Nuun_PluginParams.getPluginParams(document.currentScript);
    const saveLayout = params.SaveLayout.find(style => style.StyleName === params.SaveLayoutStyle);
    const allSaveContents = allContentsList();

    const parameters = PluginManager.parameters('NUUN_SaveScreen_3');

    function getSaveContentsBackgroundImg() {
        return !!$dataMap && $dataMap.meta && $dataMap.meta.SaveContentsBackImg ?  saveLayout.ContentsBackGroundImg[Number($dataMap.meta.SaveContentsBackImg) - 1] : $gameSystem.saveContentsBackgroundImg;
    };

    function allContentsList() {
        const list = saveLayout.SaveMainWindowList.ContentsList.map(data => data);
        if (saveLayout.SaveStatusWindowList) {
            saveLayout.SaveStatusWindowList.forEach(data => {
                const method = "PageList"+ data.ListDateSetting;
                Array.prototype.push.apply(list, (saveLayout[method] || []));
            })
        }
        return list;
    };

    function isAutosaveEnabledSwitch() {
        return params.AutoSaveEnabledSwitch === 0 || !$gameSwitches.value(params.AutoSaveEnabledSwitch);
    };

    const pluginName = "NUUN_SaveScreen_3";
    PluginManager.registerCommand(pluginName, 'ChangeBackground', args => {
        const data = String(args.BackGroundImg);
        if (data) {
        $gameSystem.setSaveBackGround(data, Number(args.BackGroundId));
        }
    });

    PluginManager.registerCommand(pluginName, 'ChangeContentsBackground', args => {
        const data = String(args.BackGroundImg);
        if (data) {
        $gameSystem.setSaveContentsBackGround(data);
        }
    });

    PluginManager.registerCommand(pluginName, 'UserAutoSave', args => {
        SceneManager.snapSaveBitmap(eval(args.OnSaveSnap));
        SceneManager._scene.userRequestAutosave(eval(args.CompulsionAutoSave));
    });
    
    PluginManager.registerCommand(pluginName, 'SetAnyName', args => {
        $gameSystem.saveAnyName = args.AnyName;
    });

    PluginManager.registerCommand(pluginName, 'SpecifyActor', args => {
        $gameParty.setSaveFileSpecifyActorOnry(Number(args.ActorId));
    });


    const _DataManager_loadSavefileImages = DataManager.loadSavefileImages;
    DataManager.loadSavefileImages = function(info) {
        _DataManager_loadSavefileImages.call(this, info);
        if (info.svActor && Symbol.iterator in info.svActor) {
            for (const character of info.svActor) {
                ImageManager.loadSvActor(character[0]);
            }
        }
        if (info.snap) {
            ImageManager.loadSaveSnapBitmap(info.snap);
        }
    };

    DataManager.loadSnap = function(info) {
        if ($gameSystem.onSnap) {
            DataManager.urlBitmapData();
            info.snap = this.urlBitmap;
        } else {
            saveInfoSnapShot = null;
            info.snap = null;
        }
    };

    const _DataManager_makeSavefileInfo = DataManager.makeSavefileInfo ;
    DataManager.makeSavefileInfo = function() {
        const info = _DataManager_makeSavefileInfo.call(this);
        this.setSaveInfo(info);
        this.loadSnap(info);
        return info;
    };

    DataManager.setSaveInfo = function(info) {
        const mode = saveLayout.PartyActorMode === 'Actor';
        const actorId = $gameParty.getSaveFileSpecifyActorOnry();
        const actor = actorId > 0 ? $gameActors.actor(actorId) : $gameParty.leader();
        if (mode) {
            info.characters = [[actor.characterName(), actor.characterIndex()]];
            info.faces = [[actor.faceName(), actor.faceIndex()]];
        }
        info.background = $gameSystem.saveBackgroundImg;
        info.contentsBack = getSaveContentsBackgroundImg();
        for(const contents of allSaveContents) {
            switch (contents.DateSelect) {
                case 'Gold':
                    info.gold = $gameParty._gold;
                    break;
                case 'Lcation':
                    info.mapname = !!$dataMap ? $gameMap.displayName() : '';
                    break;
                case 'OriginalParam':
                    this.setOrgParams(info, contents, actor);
                    break;
                case 'Chapter':
                    
                    if (Imported.NUUN_Chapter) {
                        info.AnyName = $gameSystem.getChapter();
                    } else {
                        info.AnyName = $gameSystem.saveAnyName ? $gameSystem.saveAnyName : $gameVariables.value(params.AnyNameVariable);
                    }
                    break;
                case 'ActionGoal':
                    if (Imported.NUUN_Destination) {
                        info.destinationName = $gameSystem.getDestinationList();
                    }
                    break;
                case 'ActorName':
                    info.actorName = mode ? [actor.name()] : $gameParty.actorNameForSavefile();
                    if (!!contents.ShowEval) {
                        info["actorName_"+ String(contents.MethodName)] = $gameParty.actorNameFilterForSavefile(contents);
                    }
                    break;
                case 'ClassName':
                    info.actorClass = mode ? [actor.currentClass().name] : $gameParty.actorClassForSavefile();
                    break;
                case 'Nickname':
                    info.actorNickName = mode ? [actor.nickname()] : $gameParty.actorNickNameForSavefile();
                    break;
                case 'Level':
                    info.levelActor = mode ? [actor._level] : $gameParty.actorLevelForSavefile();
                    if (!!contents.ShowEval) {
                        info["levelActor_"+ String(contents.MethodName)] = $gameParty.actorLevelFilterForSavefile(contents);
                    }
                    break;
                case 'CharacterChip':
                    if (!!contents.ShowEval) {
                        info["characters_"+ String(contents.MethodName)] = $gameParty.charactersFilterForSavefile(contents);
                    }
                    break;
                case 'Face':
                    if (!!contents.ShowEval) {
                        info["faces_"+ String(contents.MethodName)] = $gameParty.actorFacesFilterForSavefile(contents);
                    }
                    break;
                case 'SVActor':
                    info.svActor = mode ? [actor.battlerName()] : $gameParty.svActorForSavefile();
                    if (!!contents.ShowEval) {
                        info["svActor_"+ String(contents.MethodName)] = $gameParty.svActorFilterForSavefile(contents);
                    }
                    break;
                case 'HP':
                    info.actorHp = mode ? [[actor.hp, actor.mhp]] : $gameParty.actorHpForSavefile();
                    break;
                case 'MP':
                    info.actorMp = mode ? [[actor.mp, actor.mmp]] : $gameParty.actorMpForSavefile();
                    break;
                case 'Atk':
                    info.actorAtk = mode ? [actor.param(2)] : $gameParty.actorParamForSavefile(2);
                    break;
                case 'Def':
                    info.actorDef = mode ? [actor.param(3)] : $gameParty.actorParamForSavefile(3);
                    break;
                case 'Mat':
                    info.actorMat = mode ? [actor.param(4)] : $gameParty.actorParamForSavefile(4);
                    break;
                case 'Mdf':
                    info.actorMdf = mode ? [actor.param(5)] : $gameParty.actorParamForSavefile(5);
                    break;
                case 'Agi':
                    info.actorAgi = mode ? [actor.param(6)] : $gameParty.actorParamForSavefile(6);
                    break;
                case 'Luk':
                    info.actorLuk = mode ? [actor.param(7)] : $gameParty.actorParamForSavefile(7);
                    break;
                case 'ActorOriginalParam':
                    info["orgParam_"+ String(contents.MethodName)] = this.actorOriginalParamForSavefile();
                    break;
                case 'Imges':
                    
                    break;
            }
        }
    };
    
    DataManager.setOrgParams = function(info, contents, actor) {
        const text = eval(contents.DetaEval);
        if (isNaN(text)) {
            info["orgParam_"+ String(contents.MethodName)] = text;
        } else {
            info["orgParam_"+ String(contents.MethodName)] = NuunManager.numPercentage(text, (contents.Decimal - 2) || 0, true);
        }
    };

    DataManager.actorOriginalParamForSavefile = function(info, contents, actor) {
        if (saveLayout.PartyActorMode === "Actor") {
            return eval(contents.DetaEval);
        } else {
            return this.actorOriginalParamMembars(info, contents);
        }
    };

    DataManager.actorOriginalParamMembars = function(info, contents) {
        if (saveLayout.PartyActorMode === "BattleMember") {
            return $gameParty.battleMembers().map(actor => eval(contents.DetaEval));
        } else if (saveLayout.PartyActorMode === "PartyMember") {
            return $gameParty.members().map(actor => eval(contents.DetaEval));
        }
    };
    
    DataManager.loadBackground = function() {
        const globalInfo = this._globalInfo;
        const validInfo = globalInfo.slice(1).filter(x => x);
        const id = Math.max(...validInfo.map(x => this.backgroundId(x)));
        const index = globalInfo.findIndex(x => x && this.backgroundId(x) === id);
        return globalInfo[index].background ? globalInfo[index].background[0] : null;
    };
    
    DataManager.backgroundId = function(x) {
        return x.background ? x.background[1] : 0;
    };
    
    DataManager.snapBitmap = function() {
        return SceneManager.getSnapBitmap();
    };
    
    DataManager.urlBitmapData = function() {
        this.urlBitmap = this.toDataURL();
    };
    
    DataManager.toDataURL = function() {
        const png = this.svaeSnapBitmap()._canvas.toDataURL('image/png', saveLayout.SaveSnapQuality);
        const jpeg = this.svaeSnapBitmap()._canvas.toDataURL('image/jpeg', saveLayout.SaveSnapQuality);
        return (png.length < jpeg.length) ? png : jpeg;
    };
    
    DataManager.svaeSnapBitmap = function(){
        const bitmap = this.snapBitmap();
        if (bitmap) {
            const width = bitmap.width * saveLayout.SaveSnapScale / 100;
            const height = bitmap.height * saveLayout.SaveSnapScale / 100;
            const snapBitmap = new Bitmap(width, height);
            snapBitmap.blt(bitmap, 0, 0, bitmap.width, bitmap.height, 0, 0, snapBitmap.width, snapBitmap.height);
            return snapBitmap;
        }
        return null;
    };
    
    SceneManager.snapSaveBitmap = function(mode) {
        $gameSystem.onSnap = mode;
        if (mode) {
            if (this._snapBitmap) {
                this._snapBitmap.destroy();
            }
            this._snapBitmap = this.snap();
            SceneManager.snapAutoSave();
        }
    };
    
    SceneManager.snapAutoSave = function() {
        this._snapAutoSave = true;
    };
    
    SceneManager.getSnapBitmap = function() {
        return this._snapBitmap;
    };
    
    SceneManager.snapSaveBackground = function() {
        $gameSystem.onSnap = saveLayout.InfoSaveSnap;
        if (saveLayout.InfoSaveSnap) {
            if (this._snapAutoSave) {
                this._snapAutoSave = false;
                return;
            }
            if (this._snapBitmap) {
                this._snapBitmap.destroy();
            }
            this._snapBitmap = this._backgroundBitmap;
        }
    };
    
    const _SceneManager_push = SceneManager.push;
    SceneManager.push = function(sceneClass) {
        if (sceneClass.name === 'Scene_Battle') {
            if (Scene_Base.prototype.isAutosaveEnabled.call() && params.BattleEndAutoSave && isAutosaveEnabledSwitch()) {
                SceneManager.snapSaveBitmap(true);
            }
        }
        _SceneManager_push.call(this, sceneClass);
    };
    
    const _SceneManager_snapForBackground = SceneManager.snapForBackground;
    SceneManager.snapForBackground = function() {
        _SceneManager_snapForBackground.call(this);
        this.snapSaveBackground();
    };
    
    ImageManager.loadSaveSnapBitmap = function(url) {
        const has = Utils.hasEncryptedImages();
        let bitmap = null;
        if (has) {
            Utils._hasEncryptedImages = false;
            bitmap = ImageManager.loadBitmapFromUrl(url);
            Utils._hasEncryptedImages = true;
        } else {
            bitmap = ImageManager.loadBitmapFromUrl(url);
        }
        return bitmap;
    };
    
    const _DataManager_maxSavefiles = DataManager.maxSavefiles;
    DataManager.maxSavefiles = function() {
        return saveLayout.MaxSave ? saveLayout.MaxSave : _DataManager_maxSavefiles.call(this);
    };
      
    
    const _Scene_Base_requestAutosave = Scene_Base.prototype.requestAutosave;
    Scene_Base.prototype.requestAutosave = function() {
        _Scene_Base_requestAutosave.call(this);
    };
    
    Scene_Base.prototype.userRequestAutosave = function(mode) {
        if (this.isAutosaveMode(mode)) {
            this.executeAutosave();
        }
    };

    Scene_Base.prototype.isAutosaveMode = function(mode) {
        return mode ? this.isUserAutosaveEnabled() : this.isAutosaveEnabled()
    };

    Scene_Base.prototype.isUserAutosaveEnabled = function() {
        return (
            !DataManager.isBattleTest() &&
            !DataManager.isEventTest() &&
            $gameSystem.isAutosaveEnabled()
        );
    };
    
    const _Scene_Map_updateTransferPlayer = Scene_Map.prototype.updateTransferPlayer;
    Scene_Map.prototype.updateTransferPlayer = function() {
        if ($gamePlayer.isTransferring()) {
            if (this.isAutosaveEnabled() && params.MapTransferAutoSave && isAutosaveEnabledSwitch()) {
                SceneManager.snapSaveBitmap(true);
            }
        }
        _Scene_Map_updateTransferPlayer.call(this);
    };

    const _Scene_Map_shouldAutosave = Scene_Map.prototype.shouldAutosave;
    Scene_Map.prototype.shouldAutosave = function() {
        return _Scene_Map_shouldAutosave.apply(this, arguments) && params.MapTransferAutoSave && isAutosaveEnabledSwitch();
    };

    const _Scene_Battle_shouldAutosave = Scene_Battle.prototype.shouldAutosave;
    Scene_Battle.prototype.shouldAutosave = function() {
        return _Scene_Battle_shouldAutosave.apply(this, arguments) && params.BattleEndAutoSave && isAutosaveEnabledSwitch();
    };


    const _Scene_File_create = Scene_File.prototype.create;
    Scene_File.prototype.create = function() {
        this.createBackground();
        _Scene_File_create.call(this);
    };

    const _Scene_File_createListWindow = Scene_File.prototype.createListWindow;
    Scene_File.prototype.createListWindow = function() {
        _Scene_File_createListWindow.call(this);
        if (!saveLayout.SaveMainWindowList) {
            this._listWindow.opacity = 0;
        }
        this.createContentsWindow();
        if ($gameTemp.isPlaytest()) {
            if (!!this._helpWindow) {
                console.log("ヘルプウィンドウ: x"+ this._helpWindow.x +" y"+ this._helpWindow.y +" width"+ this._helpWindow.width +" height"+ this._helpWindow.height)
            }
            console.log("ヘルプウィンドウ: x"+ this._listWindow.x +" y"+ this._listWindow.y +" width"+ this._listWindow.width +" height"+ this._listWindow.height)
        }
    };

    const _Scene_File_createHelpWindow = Scene_File.prototype.createHelpWindow;
    Scene_File.prototype.createHelpWindow = function() {
        if (saveLayout.SaveHelpWindowList) {
            _Scene_File_createHelpWindow.call(this);
            if (!saveLayout.SaveHelpWindowList.WindowVisible) {
                this._helpWindow.opacity = 0;
            }
        }
    };

    Scene_File.prototype.createContentsWindow = function() {
        const list = saveLayout.SaveStatusWindowList;
        const windosList = [];
        if (list && list.length > 0) {
            list.forEach((data, i) => {
                const method = '_saveContentsWindow'+ (!!data.MethodName ? data.MethodName : "_"+ [i]);
                const rect = this.contentsWindowRect(data);
                const _window = new Window_SaveStatusContentsWindow(rect, data);
                this[method] = _window;
                this.addWindow(_window);
                windosList.push(_window);
                if (!data.WindowVisible) {
                    _window.opacity = 0;
                }
            });
        }
        this._listWindow.setSaveStatusWindowList(windosList);
    };

    Scene_File.prototype.helpWindowRect = function() {
        const a = saveLayout.SaveHelpWindowList;
        const wx = a.WindowX || 0;
        const wy = (a.WindowY || 0);// + this.mainAreaTop();
        const ww = a.WindowWidth > 0 ? Math.min(a.WindowWidth, Graphics.boxWidth) : Graphics.boxWidth;
        const wh = a.WindowHeightRows > 0 ? this.calcWindowHeight(a.WindowHeightRows, false) : (a.WindowHeight > 0 ? a.WindowHeight : Graphics.boxHeight);
        return new Rectangle(wx, wy, ww, Math.min(wh, Graphics.boxHeight - wy));
    };

    Scene_File.prototype.listWindowRect = function() {
        const a = saveLayout.SaveMainWindowList;
        const wx = a.WindowX || 0;
        const wy = (a.WindowY || 0);// + this.mainAreaTop();
        const ww = a.WindowWidth > 0 ? Math.min(a.WindowWidth, Graphics.boxWidth) : Graphics.boxWidth;
        const wh = a.WindowHeightRows > 0 ? this.calcWindowHeight(a.WindowHeightRows, false) : (a.WindowHeight > 0 ? a.WindowHeight : Graphics.boxHeight);
        return new Rectangle(wx, wy, ww, Math.min(wh, Graphics.boxHeight - wy));
    };

    Scene_File.prototype.contentsWindowRect = function(data) {
        const wx = data.WindowX || 0;
        const wy = (data.WindowY || 0);// + this.mainAreaTop();
        const ww = data.WindowWidth > 0 ? Math.min(data.WindowWidth, Graphics.boxWidth) : Graphics.boxWidth;
        const wh = data.WindowHeightRows > 0 ? this.calcWindowHeight(data.WindowHeightRows, false) : (data.WindowHeight > 0 ? data.WindowHeight : Graphics.boxHeight);
        return new Rectangle(wx, wy, ww, Math.min(wh, Graphics.boxHeight - wy));
    };

    Scene_File.prototype.createBackground = function() {
        Scene_MenuBase.prototype.createBackground.call(this);
        if (saveLayout.BackGroundImg) {
            let data = null;
            if (this._mode === 'save') {
                data = $gameSystem.getSaveBackGround();
            } else {
                data = DataManager.loadBackground() || BackGroundImg;
            }
            if (data) {
                const sprite = new Sprite();
                sprite.bitmap = ImageManager.nuun_LoadPictures(data);
                if (data) {
                    this.addChild(sprite);
                    if (sprite.bitmap && !sprite.bitmap.isReady()) {
                        sprite.bitmap.addLoadListener(this.setBackGround.bind(this, sprite));
                    } else {
                        this.setBackGround(sprite);
                    }
                }
            }
        }
    };

    Scene_File.prototype.setBackGround = function(sprite) {
        if (saveLayout.BackUiWidth) {
            sprite.x = (Graphics.width - Graphics.boxWidth) / 2 - 4;
            sprite.y = (Graphics.height - Graphics.boxHeight) / 2 - 4;
        } else {
            sprite.x = 0;
            sprite.y = 0;
        }
        if (saveLayout.BackFitWidth) {
            if(saveLayout.BackUiWidth) {
                sprite.scale.x = (Graphics.boxWidth + 8 !== sprite.bitmap.width ? (Graphics.boxWidth + 8) / sprite.bitmap.width : 1);
                sprite.scale.y = (Graphics.boxHeight + 8 !== sprite.bitmap.height ? (Graphics.boxHeight + 8) / sprite.bitmap.height : 1);
            } else {
                sprite.scale.x = (Graphics.width !== sprite.bitmap.width ? Graphics.width / sprite.bitmap.width : 1);
                sprite.scale.y = (Graphics.height !== sprite.bitmap.height ? Graphics.height / sprite.bitmap.height : 1);
            }
        }
    };


    const _Window_SavefileList_initialize = Window_SavefileList.prototype.initialize;
    Window_SavefileList.prototype.initialize = function(rect) {
        _Window_SavefileList_initialize.call(this, rect);
        this._contentsBackVisible = saveLayout.ContentsBackVisible;
        this._windowList = null;
    };

    Window_SavefileList.prototype.maxCols = function() {
        return saveLayout.NumSaveCols;
    };
    
    Window_SavefileList.prototype.maxContentsCols = function() {
        return saveLayout.SaveContentsCols;
    };
    
    Window_SavefileList.prototype.maxItems = function() {
        return DataManager.maxSavefiles() - this.isSaveFileShowAutoSave();
    };

    const _Window_SavefileList_indexToSavefileId = Window_SavefileList.prototype.indexToSavefileId;
    Window_SavefileList.prototype.indexToSavefileId = function(index) {
        return _Window_SavefileList_indexToSavefileId.apply(this, arguments) + this.isSaveFileShowAutoSave();
    };
    
    const _Window_SavefileList_savefileIdToIndex = Window_SavefileList.prototype.savefileIdToIndex;
    Window_SavefileList.prototype.savefileIdToIndex = function(savefileId) {
        return _Window_SavefileList_savefileIdToIndex.apply(this, arguments) - this.isSaveFileShowAutoSave();
    };
    
    Window_SavefileList.prototype.lineHeight = function() {
        return 30;
    };

    Window_SavefileList.prototype.isSaveFileShowAutoSave = function() {
        if (this._autosave) {
            return !params.SaveFileShowAutoSave && this._mode === 'save' ? 1 : 0;
        } else {
            return 0;
        }
    };

    Window_SavefileList.prototype.setSaveStatusWindowList = function(windowList) {
        this._windowList = windowList;
        this.refreshSaveData(this._index);
    };

    Window_SavefileList.prototype.select = function(index) {
        Window_Selectable.prototype.select.call(this, index);
        this.refreshSaveData(index);
    };

    Window_SavefileList.prototype.refreshSaveData = function(index) {
        if (this._windowList) {
            const savefileId = this.indexToSavefileId(index);
            const info = DataManager.savefileInfo(savefileId);
            this.setInfoData(info, savefileId);
        }
    };

    Window_SavefileList.prototype.setInfoData = function(info, savefileId) {
        this._windowList.forEach(_window => {
            _window.setInfoData(info, savefileId);
        });
    };

    Window_SavefileList.prototype.selectSavefile = function(savefileId) {//再定義
        const index = Math.max(0, this.savefileIdToIndex(savefileId));
        this.select(index);
        this.setTopRow(Math.floor(index / this.maxCols()) - 2);
    };
    
    const _Window_SavefileList_numVisibleRows = Window_SavefileList.prototype.numVisibleRows;
    Window_SavefileList.prototype.numVisibleRows = function() {
        return saveLayout.NumSaveRows ? saveLayout.NumSaveRows : _Window_SavefileList_numVisibleRows.call(this);
    };

    Window_SavefileList.prototype.nuun_ColsContentsX = function(x, width, index) {
        return x + Math.floor(index % saveLayout.SaveMainWindowList.ActorCols) * width;
    };

    Window_SavefileList.prototype.nuun_ColsContentsY = function(y, index) {
        return y + Math.floor(index / saveLayout.SaveMainWindowList.ActorCols) * saveLayout.SaveMainWindowList.ActorAreaHeight;
    };

    Window_SavefileList.prototype.getActorAreaWidth = function() {
        return saveLayout.SaveMainWindowList.ActorAreaWidth || 48;
    };

    const _Window_SavefileList_drawItemBackground = Window_SavefileList.prototype.drawItemBackground;
    Window_SavefileList.prototype.drawItemBackground = function(index) {
        const savefileId = this.indexToSavefileId(index);
        const info = DataManager.savefileInfo(savefileId);
        const backgroundImg = info && !!info.contentsBack ? info.contentsBack : null;
        if (backgroundImg) {
            const bitmap = ImageManager.nuun_LoadPictures(backgroundImg);
        if (bitmap && !bitmap.isReady()) {
            bitmap.addLoadListener(this.drawContentsBack.bind(this, bitmap, index, backgroundImg));
        } else {
            this.drawContentsBack(bitmap, index, backgroundImg);
        }
        } else {
        _Window_SavefileList_drawItemBackground.call(this, index);
        }
    };

    Window_SavefileList.prototype.drawContentsBack = function(bitmap, index , backgroundImg) {
        const data = saveLayout.ContentsBackSettingsList.find(imgData => backgroundImg === imgData.ContentsBackGroundImg);
        let sx = 0;
        let sy = 0;
        let scale = saveLayout.ContentsBackScale;
        if (data) {
            sx = data.Img_SX;
            sy = data.Img_SY;
            scale = data.Scale;
        }
        const rect = this.itemRect(index);
        try {
            this.contentsBack.nuun_contentsBackBlt(bitmap, sx, sy, rect.width, rect.height, rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2, scale, true);
        } catch (e) {
            const log = $gameSystem.isJapanese() ? 'NUUN_BaseがVer.1.6.2以降ではありません。' : "'NUUN_Base' is not Ver.1.6.2 or later.";
            throw ["LoadError", log];
        }
    };

    Window_SavefileList.prototype.drawItem = function(index) {
        const savefileId = this.indexToSavefileId(index);
        const info = DataManager.savefileInfo(savefileId);
        const rect = this.itemRectWithPadding(index);
        this.resetTextColor();
        this.changePaintOpacity(this.isEnabled(savefileId));
        this.drawContents(info, rect, savefileId);
    };

    Window_SavefileList.prototype.drawContents = function(info, rect, savefileId) {
        const lineHeight = this.lineHeight();
        const colSpacing = this.colSpacing();
        const itemWidth = this.itemContentsWidth(rect.width);
        const list = this.getListData(info);
        if (list) {
            list.forEach((data, r) => {
                this.resetFontSettings();
                const x_Position = data.X_Position;
                const y_Position = data.Y_Position;
                const position = Math.min(x_Position, this.maxContentsCols());
                const x = (data.X_Coordinate || 0) + (itemWidth + colSpacing) * (position - 1);
                const y = (y_Position - 1) * lineHeight + rect.y + (data.Y_Coordinate || 0);
                const width = Math.min(data.ItemWidth && data.ItemWidth > 0 ? Math.min(data.ItemWidth, rect.width - x) : this.widthMode(data, itemWidth), rect.width - x);
                this.nuun_DrawContents(info, x + rect.x , y, width, data, savefileId);
            });
        }
    };

    Window_SavefileList.prototype.getListData = function(info) {
        if (info) {
            return saveLayout.SaveMainWindowList.ContentsList;
        } else {
            const list = saveLayout.SaveMainWindowList.NotContentsList;
            return !!list ? list : saveLayout.SaveMainWindowList.ContentsList;
        }
    };

    Window_SavefileList.prototype.widthMode = function(mode, width) {
        if (mode) {
            width = width * 2 + this.colSpacing();
        }
        return width;
    };

    Window_SavefileList.prototype.itemContentsWidth = function(width) {
        return Math.floor(width / this.maxContentsCols()) - this.colSpacing();
    };

    Window_SavefileList.prototype.nuun_DrawContents = function(info, x, y, width, data, savefileId) {
        const method = 'nuun_DrawSaveContents' + data.DateSelect;
        try {
            this[method](info, x, y, width, data, savefileId);
        } catch (error) {
            const log = ($gameSystem.isJapanese() ? "無効なIDが設定されています。" : "An invalid ID has been configured.") + data.DateSelect;
            throw ["DataError", log];
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsNone = function(info, x, y, width, data) {
        
    };

    Window_Base.prototype.nuun_DrawSaveContentsHorzLine = function(info, x, y, width, data) {
        const lineY = y + this.lineHeight() / 2 - 1;
        this.contents.paintOpacity = 48;
        this.contents.fillRect(x, lineY, width, 2, NuunManager.getColorCode(data.SystemNameColor));
        this.contents.paintOpacity = 255;
    };

    Window_Base.prototype.nuun_DrawSaveContentsFreeText = function(info, x, y, width, data, savefileId) {
        if (!data.ShowEval || eval(data.ShowEval)) {
            this.drawTextEx(data.FreeText, x, y, width);
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsFileText = function(info, x, y, width, data) {
        if (savefileId <= 0) {
            this.drawTextEx(info.AnyName, x, y, width);
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsPlayTime = function(info, x, y, width, data) {
        if (info) {
            const systemWidth = data.ParamName ? (data.SystemItemWidth || 100) : 0;
            const padding = data.ParamName ? this.itemPadding() : 0;
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            this.drawSystemText(x, y , systemWidth, data);
            if (info.playtime) {
                this.drawText(info.playtime, x + systemWidth + padding, y, width - (systemWidth + padding), data.Align);
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsSaveTime = function(info, x, y, width, data) {
        if (info) {
            const systemWidth = data.ParamName ? (data.SystemItemWidth || 100) : 0;
            const padding = data.ParamName ? this.itemPadding() : 0;
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            this.drawSystemText(x, y , systemWidth, data);
            if (info.timestamp) {
                const _dayTime = new Date(info.timestamp);
                const format = _dayTime.toLocaleString(String(params.DayTime));
                this.drawText(format, x + systemWidth + padding, y, width - (systemWidth + padding), data.Align);
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsLcation = function(info, x, y, width, data) {
        if (info) {
            const systemWidth = data.ParamName ? (data.SystemItemWidth || 100) : 0;
            const padding = data.ParamName ? this.itemPadding() : 0;
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            this.drawSystemText(x, y , systemWidth, data);
            if (info.mapname) {
                this.drawText(info.mapname, x + systemWidth + padding, y, width - (systemWidth + padding), data.Align);
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsGold = function(info, x, y, width, data) {
        if (info) {
            const systemWidth = data.ParamName ? (data.SystemItemWidth || 100) : 0;
            const padding = data.ParamName ? this.itemPadding() : 0;
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            this.drawSystemText(x, y , systemWidth, data);
            if (info.gold !== undefined) {
                const unit = TextManager.currencyUnit;
                this.drawCurrencyValue(info.gold, unit, x, y, width)
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsOriginalParam = function(info, x, y, width, data) {
        if (info) {
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            const systemWidth = data.ParamName ? (data.SystemItemWidth || 100) : 0;
            this.drawSystemText(x, y , systemWidth, data);
            const text = info["orgParam_"+ String(data.MethodName)];
            if (text !== undefined) {
                const padding = data.ParamName ? this.itemPadding(): 0;
                this.nuun_DrawContentsParamUnitText(text, data, x + systemWidth + padding, y, width - (systemWidth + padding));
            }
        }
    };

    Window_SavefileList.prototype.nuun_DrawSaveContentsFileName = function(info, x, y, width, data, savefileId) {
        this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
        this.drawTitle(savefileId, x, y);
    };

    Window_Base.prototype.nuun_DrawSaveContentsTitle = function(info, x, y, width, data) {
        if (info) {
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            this.drawText(info.title, x, y, width);
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsChapter = function(info, x, y, width, data) {
        if (info && info.AnyName) {
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            this.resetTextColor();
            if (data.Align === 'TextEx') {
                this.drawTextEx(info.AnyName, x, y, width);
            } else {
                this.drawText(info.AnyName , x, y, width, data.Align);
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsActionGoal = function(info, x, y, width, data) {
        if (info && info.destinationName) {
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            this.resetTextColor();
            if (data.Align === 'TextEx') {
                this.drawTextEx(info.destinationName, x, y, width);
            } else {
                this.drawText(info.destinationName , x, y, width, data.Align);
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsCharacterChip = function(info, x, y, width, data) {
        if (info) {
            const rect = this.itemRectWithPadding(0);
            const areaWidth = this.getActorAreaWidth()
            const bottom = y + 24;
            if (!!data.ShowEval) {
                this.drawPartyFilterCharacters(info, x + 24, bottom, areaWidth, data.MethodName);
            } else if (saveLayout.PartyActorMode === 'Actor') {
                this.nuun_SpecifyActorOnryCharacter(info, x + 24, bottom);
            } else {
                this.drawPartyCharacters(info, x + 24, bottom, areaWidth);
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsFace = function(info, x, y, width, data) {
        if (info) {
            const rect = this.itemRect(0);
            const colSpacing = this.colSpacing();
            const areaWidth = this.getActorAreaWidth();
            const height = Math.min(saveLayout.FaceHeight, rect.height) - 4;
            const height2 = height * (height / (height * saveLayout.FaceScale / 100));
            if (!!data.ShowEval) {
                const _info = info["faces_"+ String(data.MethodName)] || [];
                _info.forEach((face, i) => {
                    this.nuun_DrawSaveFace(face[0], face[1], this.nuun_ColsContentsX(x, areaWidth, i), this.nuun_ColsContentsY(y + 2, i), saveLayout.FaceWidth, height2);
                });
            } else if (info.faces) {
                if (saveLayout.PartyActorMode === 'Actor') {
                    const data = info.faces[0];
                    this.nuun_DrawSaveFace(data[0], data[1], x, y + 2, saveLayout.FaceWidth, height2);
                } else {
                    info.faces.forEach((face, i) => {
                        this.nuun_DrawSaveFace(face[0], face[1], this.nuun_ColsContentsX(x, areaWidth, i), this.nuun_ColsContentsY(y + 2, i), saveLayout.FaceWidth, height2);
                    });
                }
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsSvActor = function(info, x, y, width, data) {
        if (info) {
            const colSpacing = this.colSpacing();
            const areaWidth = this.getActorAreaWidth();
            if (!!data.ShowEval) {
                const _info = info["svActor_"+ String(data.MethodName)] || [];
                _info.forEach((sv, i) => {
                    this.nuun_DrawSaveSvActor(sv[0], sv[1], this.nuun_ColsContentsX(x, areaWidth, i), this.nuun_ColsContentsY(y + 2, i));
                });
            } else if (info.svActor) {
                if (saveLayout.PartyActorMode === 'Actor') {
                    const data = info.svActor[0];
                    this.nuun_DrawSaveSvActor(data, x, y);
                } else {
                    info.svActor.forEach((sv, i) => {
                        this.nuun_DrawSaveSvActor(sv[0], sv[1], this.nuun_ColsContentsX(x, areaWidth, i), this.nuun_ColsContentsY(y + 2, i));
                    });
                }
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsActorName = function(info, x, y, width, data) {
        if (info) {
            const colSpacing = this.colSpacing();
            const width2 = this.getActorAreaWidth();
            const padding = this.itemPadding();
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            this.resetTextColor();
            if (!!data.ShowEval) {
                const actorName = (info["actorName_"+ String(data.MethodName)] || []);
                actorName.forEach((name, i) => {
                    this.drawText(name , this.nuun_ColsContentsX(x, width2, i), this.nuun_ColsContentsY(y, i), width - padding, data.Align);
                });
            } else if (info.actorName) {
                if (saveLayout.PartyActorMode === 'Actor') {
                    const name = info.actorName[0];
                    this.drawText(name , x, y, width, data.Align);
                } else {
                    info.actorName.forEach((name, i) => {
                        this.drawText(name , this.nuun_ColsContentsX(x, width2, i), this.nuun_ColsContentsY(y, i), width - padding, data.Align);
                    });
                }
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsClassName = function(info, x, y, width, data) {
        if (info && info.actorClass) {
            const colSpacing = this.colSpacing();
            const width2 = this.getActorAreaWidth();
            const padding = this.itemPadding();
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            this.resetTextColor();
            if (saveLayout.PartyActorMode === 'Actor') {
                const name = info.actorClass[0];
                this.drawText(name , x, y, width, data.Align);
            } else {
                info.actorClass.forEach((name, i) => {
                    this.drawText(name , this.nuun_ColsContentsX(x, width2, i), this.nuun_ColsContentsY(y, i), width - padding, data.Align);
                });
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsNickname = function(info, x, y, width, data) {
        if (info && info.actorNickName) {
            const colSpacing = this.colSpacing();
            const width2 = this.getActorAreaWidth();
            const padding = this.itemPadding();
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            this.resetTextColor();
            if (saveLayout.PartyActorMode === 'Actor') {
                const name = info.actorNickName[0];
                this.drawText(name , x, y, width, data.Align);
            } else {
                info.actorNickName.forEach((name, i) => {
                    this.drawText(name , this.nuun_ColsContentsX(x, width2, i), this.nuun_ColsContentsY(y, i), width - padding, data.Align);
                });
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsLevel = function(info, x, y, width, data) {
        if (info) {
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            const textWidth = this.textWidth(TextManager.levelA);
            const padding = this.itemPadding();
            const colSpacing = this.colSpacing();
            const width2 = this.getActorAreaWidth();
            if (!!data.ShowEval) {
                const levelActor = (info["levelActor_"+ String(data.MethodName)] || []);
                levelActor.forEach((level, i) => {
                    this.changeTextColor(NuunManager.getColorCode(data.SystemNameColor));
                    this.drawText(TextManager.levelA, this.nuun_ColsContentsX(x + padding / 4, width2, i), this.nuun_ColsContentsY(y, i), textWidth);
                    this.resetTextColor();
                    this.drawText(level, this.nuun_ColsContentsX(x + textWidth + padding / 2, width2, i), this.nuun_ColsContentsY(y, i), width - (textWidth + padding), data.Align);
                });
            } else if (info.levelActor) {
                if (saveLayout.PartyActorMode === 'Actor') {
                    const level = info.levelActor[0];
                    this.changeTextColor(NuunManager.getColorCode(data.SystemNameColor));
                    this.drawText(TextManager.levelA, x, y, textWidth);
                    this.resetTextColor();
                    this.drawText(level, x + textWidth + padding, y, width - (textWidth + padding), data.Align);
                } else {
                    const width2 = (data.ItemWidth || 48);
                    info.levelActor.forEach((level, i) => {
                        this.changeTextColor(NuunManager.getColorCode(data.SystemNameColor));
                        this.drawText(TextManager.levelA, this.nuun_ColsContentsX(x + padding / 4, width2, i), this.nuun_ColsContentsY(y, i), textWidth);
                        this.resetTextColor();
                        this.drawText(level, this.nuun_ColsContentsX(x + textWidth + padding / 2, width2, i), this.nuun_ColsContentsY(y, i), width - (textWidth + padding), data.Align);
                    });
                }
            }
        }
    };

    Window_Base.prototype.nuun_DrawSaveFace = function(faceName, faceIndex, x, y, width, height) {
        const rect = this.itemRectWithPadding(0);
        const scale = saveLayout.FaceScale / 100;
        const scale2 = 100 / (100 * scale);
        width = width || ImageManager.faceWidth;
        height = Math.min((height || ImageManager.faceHeight), (rect.height - 2) * scale2);
        const bitmap = ImageManager.loadFace(faceName);
        const pw = ImageManager.faceWidth;
        const ph = ImageManager.faceHeight;
        const sw = Math.min(width, pw);
        const sh = Math.min(height, ph);
        const dx = Math.floor(x + Math.max(width - pw, 0) / 2);
        const dy = Math.floor(y + Math.max(height - ph, 0) / 2);
        const sx = Math.floor((faceIndex % 4) * pw + (pw - sw) / 2);
        const sy = Math.floor(Math.floor(faceIndex / 4) * ph + (ph - sh) / 2);
        const dw = Math.floor(sw * scale);
        const dh = Math.floor(sh * scale);
        this.contents.blt(bitmap, sx, sy, sw, sh, dx, dy, dw, dh);
    };

    Window_Base.prototype.nuun_DrawSaveSvActor = function(data, x, y) {
        if (data) {
            const motionIndex = 0;
            const bitmap = ImageManager.loadSvActor(data);
            const pw = Math.floor(bitmap.width / 9);
            const ph = Math.floor(bitmap.height / 6);
            const sx = Math.floor(motionIndex / 6) * 3;
            const sy = motionIndex % 6;
            this.contents.blt(bitmap, sx, sy, pw, ph, x, y);
        }
    };

    Window_SavefileList.prototype.drawPartyCharacters = function(info, x, y, width) {
        if (info.characters) {
            info.characters.forEach((data, i) => {
                this.drawCharacter(data[0], data[1], this.nuun_ColsContentsX(x, width, i), this.nuun_ColsContentsY(y, i));
            });
        }
    };

    Window_SavefileList.prototype.drawPartyFilterCharacters = function(info, x, y, width, method) {
        const characters = info["characters_"+ String(method)];
        if (characters) {
            characters.forEach((data, i) => {
                this.drawCharacter(data[0], data[1], this.nuun_ColsContentsX(x, width, i), this.nuun_ColsContentsY(y, i));
            });
        }
    };

    Window_Base.prototype.nuun_SpecifyActorOnryCharacter = function(info, x, y) {
        if (info.characters) {
            const data = info.characters[0];
            this.drawCharacter(data[0], data[1], x, y);
        }
    };

    Window_Base.prototype.nuun_DrawSaveContentsSnapShot = function(info, x, y, width, data) {
        if (info && info.snap) {
            const bitmap = ImageManager.loadSaveSnapBitmap(info.snap);
            this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, x, y);
        }
    };

    Window_SavefileList.prototype.drawSystemText = function(x, y, width, data) {
        if (data.ParamName) {
            this.changeTextColor(NuunManager.getColorCode(data.SystemNameColor));
            this.drawText(data.ParamName || '', x, y, width);
            this.resetTextColor();
        }
    };
    
    Window_SavefileList.prototype.systemWidth = function(swidth, width) {
        return swidth > 0 ? swidth : Math.floor(width / 2);
    };

    function Window_SaveStatusContentsWindow() {
        this.initialize(...arguments);
    }
    
    Window_SaveStatusContentsWindow.prototype = Object.create(Window_StatusBase.prototype);
    Window_SaveStatusContentsWindow.prototype.constructor = Window_SaveStatusContentsWindow;
    
    Window_SaveStatusContentsWindow.prototype.initialize = function(rect, data) {
        this._contents = data;
        this._data = {Id: data.MethodName};//T氏プラグイン
        this._classNameId = data.MethodName;
        Window_StatusBase.prototype.initialize.call(this, rect);
        this._info = null;
        this._savefileId = 0;
    };

    Window_SaveStatusContentsWindow.prototype.maxContentsCols = function() {
        return this._contents.SaveStatusContentsCols || 1;
    };

    Window_SaveStatusContentsWindow.prototype.itemHeight = function() {
        return this.innerHeight;
    };

    Window_SaveStatusContentsWindow.prototype.setInfoData = function(info, savefileId) {
        this._info = info;
        this._savefileId = savefileId;
        this.refresh();
    };

    Window_SaveStatusContentsWindow.prototype.refresh = function() {
        Window_StatusBase.prototype.refresh.call(this);
        const rect = this.itemRect(0);
        const unLoadBitmap = this.loadCheckBitmap();
        if(unLoadBitmap){
            unLoadBitmap.addLoadListener(this.refresh.bind(this));//再トライ
        } else {
            this.drawContents(rect);
        }
    };

    Window_SaveStatusContentsWindow.prototype.nuun_ColsContentsX = function(x, width, index) {
        return x + Math.floor(index % this._contents.ActorCols) * width;
    };

    Window_SaveStatusContentsWindow.prototype.nuun_ColsContentsY = function(y, index) {
        return y + Math.floor(index / this._contents.ActorCols) * this._contents.ActorAreaHeight;
    };

    Window_SaveStatusContentsWindow.prototype.getActorAreaWidth = function() {
        return this._contents.ActorAreaWidth || 200;
    };

    Window_SaveStatusContentsWindow.prototype.loadCheckBitmap = function() {
        let bitmap = null;
        let loadBitmap = null;
        const info = this._info;
        if (!info) {
            return bitmap;
        }
        if (info.characters && Symbol.iterator in info.characters) {
            for (const character of info.characters) {
                loadBitmap = ImageManager.loadCharacter(character[0]);
                if (loadBitmap && !loadBitmap.isReady()) {
                    bitmap = loadBitmap;
                }
            }
        }
        if (info.faces && Symbol.iterator in info.faces) {
            for (const face of info.faces) {
                loadBitmap = ImageManager.loadFace(face[0]);
                if (loadBitmap && !loadBitmap.isReady()) {
                    bitmap = loadBitmap;
                }
            }
        }
        if (info.svActor && Symbol.iterator in info.svActor) {
            for (const character of info.svActor) {
                loadBitmap = ImageManager.loadSvActor(character[0]);
                if (loadBitmap && !loadBitmap.isReady()) {
                    bitmap = loadBitmap;
                }
            }
        }
        if (info.snap) {
            loadBitmap = ImageManager.loadSaveSnapBitmap(info.snap);
            if (loadBitmap && !loadBitmap.isReady()) {
                bitmap = loadBitmap;
            }
        }
        return bitmap;
    };

    Window_SaveStatusContentsWindow.prototype.drawContents = function(rect) {
        const lineHeight = this.lineHeight();
        const colSpacing = this.colSpacing();
        const itemWidth = this.itemContentsWidth(rect.width);
        const list = this.getListData();
        if (list) {
            list.forEach(data => {
                this.resetFontSettings();
                const x_Position = data.X_Position;
                const y_Position = data.Y_Position;
                const position = Math.min(x_Position, this.maxContentsCols());
                const x = (data.X_Coordinate || 0) + (itemWidth + colSpacing) * (position - 1);
                const y = (y_Position - 1) * lineHeight + rect.y + (data.Y_Coordinate || 0);
                const width = Math.min(data.ItemWidth && data.ItemWidth > 0 ? Math.min(data.ItemWidth, rect.width - x) : this.widthMode(data, itemWidth), rect.width - x);
                this.nuun_DrawContents(this._info, x + rect.x , y, width, data, this._savefileId);
            });
        }
    };

    Window_SaveStatusContentsWindow.prototype.getListData = function() {
        if (this._info) {
            return saveLayout['PageList' + this._contents.ListDateSetting];
        } else {
            const list = saveLayout['PageList' + this._contents.ListNotDateSetting];
            return !!list ? list : saveLayout['PageList' + this._contents.ListDateSetting];
        }
    };

    Window_SaveStatusContentsWindow.prototype.widthMode = function(mode, width) {
        if (mode) {
            width = width * 2 + this.colSpacing();
        }
        return width;
    };

    Window_SaveStatusContentsWindow.prototype.itemContentsWidth = function(width) {
        return Math.floor(width / this.maxContentsCols()) - this.colSpacing();
    };

    Window_SaveStatusContentsWindow.prototype.nuun_DrawContents = function(info, x, y, width, data, savefileId) {
        const method = 'nuun_DrawSaveContents' + data.DateSelect;
        try {
            this[method](info, x, y, width, data, savefileId);
        } catch (error) {
            const log = ($gameSystem.isJapanese() ? "無効なIDが設定されています。" : "An invalid ID has been configured.") + data.DateSelect;
            throw ["DataError", log];
        }
    };

    Window_SaveStatusContentsWindow.prototype.nuun_DrawSaveContentsFileName = function(info, x, y, width, data, savefileId) {
        this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
        Window_SavefileList.prototype.drawTitle.call(this, savefileId, x, y);
    };


    Window_SaveStatusContentsWindow.prototype.drawPartyCharacters = function(info, x, y, width) {
        if (info.characters) {
            info.characters.forEach((data, i) => {
                this.drawCharacter(data[0], data[1], this.nuun_ColsContentsX(x, width, i), this.nuun_ColsContentsY(y, i));
            });
        }
    };

    Window_SaveStatusContentsWindow.prototype.drawPartyFilterCharacters = function(info, x, y, width, method) {
        const characters = info["characters_"+ String(method)];
        if (characters) {
            characters.forEach((data, i) => {
                this.drawCharacter(data[0], data[1], this.nuun_ColsContentsX(x, width, i), this.nuun_ColsContentsY(y, i));
            });
        }
    };

    Window_SaveStatusContentsWindow.prototype.drawSystemText = function(x, y, width, data, text) {
        const name = !!text ? text : data.ParamName;
        if (name) {
            this.changeTextColor(NuunManager.getColorCode(data.SystemNameColor));
            this.drawText(name || '', x, y, width);
            this.resetTextColor();
        }
    };

    Window_SaveStatusContentsWindow.prototype.nuun_DrawSaveContentsHP = function(info, x, y, width, data) {
        if (info && info.actorHp) {
            const width2 = this.getActorAreaWidth();
            const colSpacing = this.colSpacing();
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            if (saveLayout.PartyActorMode === 'Actor') {
                const hp = info.actorHp[0];
                this.nuun_DrawActorGauge(TextManager.hpA, x, y, (data.ItemWidth || 128), hp[0], hp[1], ColorManager.hpGaugeColor1(), ColorManager.hpGaugeColor2(), NuunManager.getColorCode(data.SystemNameColor), 'hp');
            } else {
                info.actorHp.forEach((hp, i) => {
                    x2 = this.nuun_ColsContentsX(x, width2, i);
                    y2 = this.nuun_ColsContentsY(y, i);
                    this.nuun_DrawActorGauge(TextManager.hpA, x2, y2, (data.ItemWidth || 128), hp[0], hp[1], ColorManager.hpGaugeColor1(), ColorManager.hpGaugeColor2(), NuunManager.getColorCode(data.SystemNameColor), 'hp');
                });
            }
        }
    };

    Window_SaveStatusContentsWindow.prototype.nuun_DrawSaveContentsMP = function(info, x, y, width, data) {
        if (info && info.actorMp) {
            const width2 = this.getActorAreaWidth();
            const colSpacing = this.colSpacing();
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            if (saveLayout.PartyActorMode === 'Actor') {
                const mp = info.actorMp[0];
                this.nuun_DrawActorGauge(TextManager.mpA, x, y, (data.ItemWidth || 128), mp[0], mp[1], ColorManager.mpGaugeColor1(), ColorManager.mpGaugeColor2(), NuunManager.getColorCode(data.SystemNameColor), 'mp');
            } else {
                info.actorHp.forEach((mp, i) => {
                    x2 = this.nuun_ColsContentsX(x, width2, i);
                    y2 = this.nuun_ColsContentsY(y, i);
                    this.nuun_DrawActorGauge(TextManager.mpA, x2, y2, (data.ItemWidth || 128), mp[0], mp[1], ColorManager.mpGaugeColor1(), ColorManager.mpGaugeColor2(), NuunManager.getColorCode(data.SystemNameColor), 'mp');
                });
            }
        }
    };

    Window_SaveStatusContentsWindow.prototype.nuun_DrawSaveContentsAtk = function(info, x, y, width, data) {
        if (info && info.actorAtk) {
            this.nuun_DrawSaveContentsParams(info.actorAtk, x, y, width, data, 2);
        }
    };

    Window_SaveStatusContentsWindow.prototype.nuun_DrawSaveContentsDef = function(info, x, y, width, data) {
        if (info && info.actorDef) {
            this.nuun_DrawSaveContentsParams(info.actorDef, x, y, width, data, 3);
        }
    };

    Window_SaveStatusContentsWindow.prototype.nuun_DrawSaveContentsMat = function(info, x, y, width, data) {
        if (info && info.actorMat) {
            this.nuun_DrawSaveContentsParams(info.actorMat, x, y, width, data, 4);
        }
    };

    Window_SaveStatusContentsWindow.prototype.nuun_DrawSaveContentsMdf = function(info, x, y, width, data) {
        if (info && info.actorMdf) {
            this.nuun_DrawSaveContentsParams(info.actorMdf, x, y, width, data, 5);
        }
    };

    Window_SaveStatusContentsWindow.prototype.nuun_DrawSaveContentsAgi = function(info, x, y, width, data) {
        if (info && info.actorAgi) {
            this.nuun_DrawSaveContentsParams(info.actorAgi, x, y, width, data, 6);
        }
    };

    Window_SaveStatusContentsWindow.prototype.nuun_DrawSaveContentsLuk = function(info, x, y, width, data) {
        if (info && info.actorLuk) {
            this.nuun_DrawSaveContentsParams(info.actorLuk, x, y, width, data, 7);
        }
    };
    
    Window_SaveStatusContentsWindow.prototype.nuun_DrawSaveContentsParams = function(actors, x, y, width, data, param) {
        const padding = this.itemPadding();
        this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
        const name = data.ParamName ? data.ParamName : TextManager.param(param);
        const systemWidth = name ? (data.SystemItemWidth || 100) : 0;
        const width2 = this.getActorAreaWidth();
        if (saveLayout.PartyActorMode === 'Actor') {
            const value = actors[0];
            this.drawSystemText(x, y , systemWidth, data, name);
            this.nuun_DrawContentsParamUnitText(value, data, x + systemWidth + padding, y, width - (systemWidth + padding));
        } else {
            actors.forEach((value, i) => {
                this.drawSystemText(this.nuun_ColsContentsX(x, width2, i), this.nuun_ColsContentsY(y, i) , systemWidth, data, name);
                this.nuun_DrawContentsParamUnitText(value, data, this.nuun_ColsContentsX(x + systemWidth + padding / 2, width2, i), this.nuun_ColsContentsY(y, i), width - (systemWidth + padding));
            });
        }
    };

    Window_SaveStatusContentsWindow.prototype.nuun_DrawSaveContentsActorOriginalParam = function(info, x, y, width, data) {
        if (info) {
            const padding = data.ParamName ? this.itemPadding(): 0;
            this.contents.fontSize = $gameSystem.mainFontSize() + data.FontSize;
            const systemWidth = data.ParamName ? (data.SystemItemWidth || 100) : 0;
            const _info = info["orgParam_"+ String(data.MethodName)];
            const width2 = this.getActorAreaWidth();
            if (saveLayout.PartyActorMode === 'Actor') {
                if (_info) {
                    this.drawSystemText(x, y , systemWidth, data);
                    this.nuun_DrawContentsParamUnitText(_info[0], data, x + systemWidth + padding, y, width - (systemWidth + padding));
                }
            } else {
                _info.forEach((value, i) => {
                    this.drawSystemText(this.nuun_ColsContentsX(x, width2, i), this.nuun_ColsContentsY(y, i) , systemWidth, data);
                    this.nuun_DrawContentsParamUnitText(value, data, this.nuun_ColsContentsX(x + systemWidth + padding / 2, width2, i), this.nuun_ColsContentsY(y, i), width - (systemWidth + padding));
                });
            }
        }
    };
    
    Window_SaveStatusContentsWindow.prototype.systemWidth = function(swidth, width) {
        return swidth > 0 ? swidth : Math.floor(width / 2);
    };


    const _Game_System_initialize = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function() {
        _Game_System_initialize.call(this);
        this.saveBackgroundImg = [saveLayout.BackGroundImg, 0];
        this.saveContentsBackgroundImg = saveLayout.ContentsBackGroundImg[0];
        this.onSnap = false;
    };

    Game_System.prototype.setSaveBackGround = function(img, id) {
        const backgroundId = saveLayout.AutomaticSetting ? (this.backgroundId || 0) + 1 : id;
        this.saveBackgroundImg = [img, backgroundId];
    };

    Game_System.prototype.getSaveBackGround = function() {
        this.saveBackgroundImg = this.saveBackgroundImg && !!this.saveBackgroundImg[0] ? this.saveBackgroundImg : [saveLayout.BackGroundImg, 0];
        return this.saveBackgroundImg[0];
    };

    Game_System.prototype.getSaveBackGroundId = function() {
        return this.saveBackgroundImg[1] || 0;
    };

    Game_System.prototype.setSaveContentsBackGround = function(img) {
        this.saveContentsBackgroundImg = img ? img : saveLayout.ContentsBackGroundImg[0];
    };


    const _Game_Party_initialize = Game_Party.prototype.initialize;
    Game_Party.prototype.initialize = function() {
        _Game_Party_initialize.call(this);
        this._saveFileSpecifyActorOnry = 0;
    };

    Game_Party.prototype.setSaveFileSpecifyActorOnry = function(id) {
        this._saveFileSpecifyActorOnry = id;
    };

    Game_Party.prototype.getSaveFileSpecifyActorOnry = function() {
        return this._saveFileSpecifyActorOnry || 0;
    };

    const _Game_Party_charactersForSavefile = Game_Party.prototype.charactersForSavefile;
    Game_Party.prototype.charactersForSavefile = function() {
        if (saveLayout.PartyActorMode === 'BattleMember') {
            return _Game_Party_charactersForSavefile.call(this);
        } else if (saveLayout.PartyActorMode === 'PartyMember') {
            return this.members().map(actor => [
                actor.characterName(),
                actor.characterIndex()
            ]);
        }
    };

    const _Game_Party_facesForSavefile = Game_Party.prototype.facesForSavefile;
    Game_Party.prototype.facesForSavefile = function() {
        if (saveLayout.PartyActorMode === 'BattleMember') {
            return _Game_Party_facesForSavefile.call(this);
        } else if (saveLayout.PartyActorMode === 'PartyMember') {
            return this.members().map(actor => [
                actor.faceName(),
                actor.faceIndex()
            ]);
        }
    };

    Game_Party.prototype.actorLevelForSavefile = function() {
        if (saveLayout.PartyActorMode === 'BattleMember') {
            return this.battleMembers().map(actor => actor._level);
        } else if (saveLayout.PartyActorMode === 'PartyMember') {
            return this.members().map(actor => actor._level);
        }
    };

    Game_Party.prototype.actorNameForSavefile = function() {
        if (saveLayout.PartyActorMode === 'BattleMember') {
            return this.battleMembers().map(actor => actor.name());
        } else if (saveLayout.PartyActorMode === 'PartyMember') {
            return this.members().map(actor => actor.name());
        }
    };

    Game_Party.prototype.svActorForSavefile = function() {
        if (saveLayout.PartyActorMode === 'BattleMember') {
            return this.battleMembers().map(actor => [actor.battlerName()]);
        } else if (saveLayout.PartyActorMode === 'PartyMember') {
            return this.members().map(actor => [actor.battlerName()]);
        }
    };

    Game_Party.prototype.actorClassForSavefile = function() {
        if (saveLayout.PartyActorMode === 'BattleMember') {
            return this.battleMembers().map(actor => actor.currentClass().name);
        } else if (saveLayout.PartyActorMode === 'PartyMember') {
            return this.members().map(actor => actor.currentClass().name);
        }
    };

    Game_Party.prototype.actorNickNameForSavefile = function() {
        if (saveLayout.PartyActorMode === 'BattleMember') {
            return this.battleMembers().map(actor => actor.nickname());
        } else if (saveLayout.PartyActorMode === 'PartyMember') {
            return this.members().map(actor => actor.nickname());
        }
    };

    Game_Party.prototype.charactersFilterForSavefile = function(data) {
        return this.allMembers().filter(actor => eval(data.ShowEval)).map(actor => [
            actor.characterName(),
            actor.characterIndex()
        ]);
    };

    Game_Party.prototype.actorFacesFilterForSavefile = function(data) {
        return this.allMembers().filter(actor => eval(data.ShowEval)).map(actor => [
            actor.faceName(),
            actor.faceIndex()
        ]);
    };
    
    Game_Party.prototype.svActorFilterForSavefile = function(data) {
        return this.allMembers().filter(actor => eval(data.ShowEval)).map(actor => [actor.battlerName()]);
    };

    Game_Party.prototype.actorLevelFilterForSavefile = function(data) {
        return this.allMembers().filter(actor => eval(data.ShowEval)).map(actor => actor._level);
    };
    
    Game_Party.prototype.actorNameFilterForSavefile = function(data) {
        return this.allMembers().filter(actor => eval(data.ShowEval)).map(actor => actor.name());
    };

    Game_Party.prototype.actorHpForSavefile = function() {
        if (saveLayout.PartyActorMode === 'BattleMember') {
            return this.battleMembers().map(actor => [actor.hp, actor.mhp]);
        } else if (saveLayout.PartyActorMode === 'PartyMember') {
            return this.members().map(actor => [actor.hp, actor.mhp]);
        }
    };

    Game_Party.prototype.actorMpForSavefile = function() {
        if (saveLayout.PartyActorMode === 'BattleMember') {
            return this.battleMembers().map(actor => [actor.mp, actor.mmp]);
        } else if (saveLayout.PartyActorMode === 'PartyMember') {
            return this.members().map(actor => [actor.mp, actor.mmp]);
        }
    };

    Game_Party.prototype.actorParamForSavefile = function(paramId) {
        if (saveLayout.PartyActorMode === 'BattleMember') {
            return this.battleMembers().map(actor => actor.param(paramId));
        } else if (saveLayout.PartyActorMode === 'PartyMember') {
            return this.members().map(actor => actor.param(paramId));
        }
    };



})();