//=============================================================================
// RandomBranch.js
// ----------------------------------------------------------------------------
// Copyright (c) 2017 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2017/12/08 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc 指定した確率で条件分岐を分岐させるプラグイン
 * @author n2naokun(柊菜緒)
 *
 * @help 指定した確率で分岐を実行できます
 * 使い方
 * 条件分岐でスクリプトを使用してProb(確率)と指定したら一定確率でその条件分岐を実行します。
 * Prob(1/3)この場合1/3の確率で実行されます。
 * 確率は1以下の数字になるように指定してください。
 * 1より大きい数字になる場合は分岐は実行されません。
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

(function (_global) {
   window.Prob = function (prob) {
      if (prob <= 1) {
         if (Math.random() <= prob) return true;
      }
      return false;
   };
})(this);