//=============================================================================
// Ten_MenuController.js
// ----------------------------------------------------------------------------
// Copyright (c) 2021 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.8.7  2025/12/21 切り替える画像データのレイヤーを変更
// 0.8.6  2025/12/20 8番スイッチがONの時は読み込む背景を変更
// 0.8.5  2025/12/20 バッドエンド回想の時だけ全てをスイッチで無効にできるように変更
//                   スイッチは8番固定
// 0.8.4  2025/09/17 リストウィンドウのスクロール位置をリセットする方法を変更
// 0.8.3  2025/09/16 カテゴリー名を意図的に重複させた時の動作を変更
// 0.8.2  2025/09/09 場所移動でカテゴリー分けが上手く動作しなかったのを修正
// 0.8.1  2025/09/09 カーソル移動関係の軽微なバグを修正
// 0.8.0  2025/09/09 カテゴリー分け機能を追加
// 0.7.7  2025/05/24 文字溢れ対策のバグを修正
// 0.7.6  2025/05/23 文字溢れ対策を強化
// 0.7.5  2025/05/21 タイトルとサブタイトルの文字溢れ対策
// 0.7.4  2025/05/20 鑑賞モードでオートセーブが働くのを無効化
// 0.7.3  2025/03/25 タイトルからアイコンを削除する処理を追加
// 0.7.2  2024/12/26 ボタン押しっぱなし系のバグを修正
// 0.7.1  2024/12/26 キャンセルボタンを長押しした時のバグ修正
// 0.7.0  2024/12/23 場所移動でフラグが立っていない時に選択肢を非表示するように変更
//                   鑑賞モード時でフラグが立っていない時にb付き画像を読むように変更
//                   鑑賞モード時にボタン長押しで複数回コモンが実行されるのを修正
// 0.6.11 2024/12/21 テキストの処理をdrawTextExに変更
// 0.6.10 2024/12/03 プラグインコマンドウィンドウの表示にフェードインアウトを追加
// 0.6.9  2024/12/02 実行時にフェードアウトを入れるように変更
// 0.6.8  2024/11/30 メッセージウィンドウのキャラ名が表示されない問題の修正
//                   鑑賞モードに入る時にフラグをリセットするように変更
// 0.6.7  2024/11/27 プラグインコマンドを追加したり色々修正しました……
// 0.6.6  2024/11/22 場所移動を実行後にマップが一時的に表示されるのを抑制
// 0.6.5  2024/11/19 サムネイルの位置調整機能追加とアウトラインの表示バグとエラー修正
// 0.6.4  2024/11/17 アウトラインの太さがLL_OutlineColorAutoに従うように変更
// 0.6.3  2024/11/17 アウトラインカラー系プラグインとの競合修正
// 0.6.2  2024/11/17 キャラ位置に固定値が代入されているのを修正
// 0.6.1  2024/11/16 アウトラインカラー変更と表示位置調整機能を追加
// 0.6.0  2024/11/11 ウィンドウを非表示、位置調整
// 0.5.0  2024/11/04 フラグ管理をスイッチでするように変更
// 0.4.4  2024/10/30 アイテムリストのテキストの制御文字を非表示に変更
// 0.4.3  2024/10/29 MZ対応作業見落とし
// 0.4.2  2024/08/27 一部のBGM停止を無効化
// 0.4.1  2024/05/20 Keke_TimingCommonとの競合対策
// 0.4.0  2024/05/10 MZ対応作業
// 0.3.2  2021/08/07 Scene_StoryMenuから戻ってゲーム終了を押すと
//                   背景がScene_StoryMenuの画像になっていたのを修正。
// 0.3.1  2021/08/05 セーブ・ロード時にエラーが出る問題を修正
// 0.3.0  2021/07/30 自動フラグ管理機能を追加
// 0.2.0  2021/07/27 フリーモード・観賞モード内で直接コモンイベントを
//                   実行可能に機能変更
// 0.1.1  2021/07/08 画像の指定フォルダを変更・メニューコマンドの追加
//                   各種フェードの追加
// 0.1.0  2021/07/03 プレビュー版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @target MZ
 * @plugindesc てんたくるぱにっくの回想・ミニゲーム選択などを制御する専用プラグイン
 * 
 * @author n2naokun(柊菜緒)
 *
 * @help 回想やミニゲーム選択画面などを定義・制御します。
 * 
 * ※このプラグインは未完成のプレビュー版です。
 *   大体の機能は追加されていると思いますが抜けが有るかも知れません。
 * 
 * 自動フラグ管理機能の仕組み
 * コモンイベントを実行することでコモンイベントの番号ごとに1度以上
 * 実行したというフラグを立てる仕組みになっています。
 * なのでストーリー上で一度でも該当コモンイベントを実行すると
 * 深く考えて管理しなくてもプラグイン側で勝手に処理してくれます。
 * セーブ自体はsaveフォルダにtenGlobalSave.rpgsaveとして保存されます。
 * 
 * 使い方
 * プラグインパラメータを開いて基本的な設定をしてください。
 * マップIDの項目には何も無い空マップを指定してください。
 * 各メニューの一覧項目にコモンイベントなどを登録してください。
 * 場所移動メニューに関しましてはすぐ実行の項目は存在しますが
 * 動作はしません(仕様です)
 * 基本的にはセーブIDを指定しなくても(0でも)コモンイベントIDから
 * セーブIDを取得します、場所移動などで実行したいコモンイベントのIDと
 * フラグとして管理したいコモンイベントのIDが異なる場合のみセーブIDを
 * 指定して使ってください。
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 * 
 * @param ==基本設定==
 * @param MapId
 * @text マップID
 * @desc コモンイベントを実行する前に一時的に読み込むマップのIDを指定します。
 * @type number
 * @default 1
 * 
 * @param =1
 *
 * @param ==ミニゲームへの移動画面設定==
 * 
 * @param Enable_Story
 * @text メニューコマンド有効化
 * @desc メニューコマンド上に項目を表示します。
 * @type boolean
 * @on 有効化
 * @off 無効化
 * @default true
 * 
 * @param FlagSwitch_Story
 * @text フラグスイッチ
 * @desc このシーンに入っているか確認するためのスイッチ
 * @type number
 * @default 0
 * 
 * @param OutlineColor_Story
 * @text 文字縁取り色
 * @desc 文字の縁取りに使う色を指定します
 * @type string
 * @default #000000
 * 
 * @param TitlePos_Story
 * @text タイトル位置
 * @desc タイトルの表示位置を指定
 * @type struct<Pos>
 * @default {"x":"35","y":"130"}
 * 
 * @param SubTitlePos_Story
 * @text サブタイトル位置
 * @desc サブタイトルの表示位置を指定
 * @type struct<Pos>
 * @default {"x":"100","y":"210"}
 * 
 * @param TextPos_Story
 * @text テキスト位置
 * @desc テキストの表示位置を指定
 * @type struct<Pos>
 * @default {"x":"27","y":"365"}
 * 
 * @param ListPos_Story
 * @text リスト位置
 * @desc リストの表示位置を指定
 * @type struct<Pos>
 * @default {"x":"733","y":"62"}
 * 
 * @param Command_Story
 * @text コマンド名
 * @desc メニュー画面上のコマンド名を設定します。
 * @type string
 * @default 場所移動
 * 
 * @param Command_StoryIndex
 * @text コマンドの挿入位置
 * @desc メニュー画面でコマンドが挿入される位置。
 * @type number
 * @default 0
 *
 * @param CharImage_Story
 * @text 立ち絵画像
 * @desc 立ち絵画像を指定します。
 * @type file
 * @dir img/pictures
 *
 * @param CharPos_Story
 * @text 立ち絵の位置
 * @type struct<Pos>
 * @desc ミニゲーム移動シーンでの立ち絵の位置を指定します。
 * @default {"x":"80","y":"280"}
 * 
 * @param ThumbnailPos_Story
 * @text マッププレビューの位置
 * @type struct<Pos>
 * @desc マッププレビューの位置を指定します。
 * @default {"x":"648","y":"468"}
 *
 * @param BGImage_Story
 * @text 背景画像
 * @desc 背景画像を指定します。
 * @type file
 * @dir img/pictures
 *
 * @param StoryList
 * @text ミニゲーム移動先一覧
 * @type struct<Stage>[]
 * @desc ミニゲーム移動先の情報を登録します。
 * @default []
 * 
 * @param =2
 *
 * @param ==ミニゲーム選択画面設定==
 *
 * @param Enable_Game
 * @text ミニゲームコマンド有効化
 * @desc タイトルコマンド上に項目を表示します。
 * @type boolean
 * @on 有効化
 * @off 無効化
 * @default true
 * 
 * @param FlagSwitch_Game
 * @text フラグスイッチ
 * @desc このシーンに入っているか確認するためのスイッチ
 * @type number
 * @default 0
 * 
 * @param OutlineColor_Game
 * @text 文字縁取り色
 * @desc 文字の縁取りに使う色を指定します
 * @type string
 * @default #000000
 * 
 * @param TitlePos_Game
 * @text タイトル位置
 * @desc タイトルの表示位置を指定
 * @type struct<Pos>
 * @default {"x":"35","y":"130"}
 * 
 * @param SubTitlePos_Game
 * @text サブタイトル位置
 * @desc サブタイトルの表示位置を指定
 * @type struct<Pos>
 * @default {"x":"100","y":"210"}
 * 
 * @param TextPos_Game
 * @text テキスト位置
 * @desc テキストの表示位置を指定
 * @type struct<Pos>
 * @default {"x":"27","y":"365"}
 * 
 * @param ListPos_Game
 * @text リスト位置
 * @desc リストの表示位置を指定
 * @type struct<Pos>
 * @default {"x":"733","y":"62"}
 * 
 * @param Command_Game
 * @text コマンド名
 * @desc タイトル画面上のコマンド名を設定します。
 * @type string
 * @default フリーモード
 *
 * @param Command_GameIndex
 * @text コマンドの位置
 * @desc タイトル画面でコマンドが挿入される位置。
 * (下部の項目が優先されます)
 * @type number
 * @default 2
 *
 * @param CharImage_Game
 * @text 立ち絵画像
 * @desc 立ち絵画像を指定します。
 * @type file
 * @dir img/pictures
 *
 * @param CharPos_Game
 * @text 立ち絵の位置
 * @type struct<Pos>
 * @desc ミニゲーム選択シーンでの立ち絵の位置を指定します。
 * @default {"x":"80","y":"280"}
 *
 * @param ThumbnailPos_Game
 * @text マッププレビューの位置
 * @type struct<Pos>
 * @desc マッププレビューの位置を指定します。
 * @default {"x":"648","y":"468"}
 *
 * @param BGImage_Game
 * @text 背景画像
 * @desc 背景画像を指定します。
 * @type file
 * @dir img/pictures
 *
 * @param GameList
 * @text ミニゲーム一覧
 * @type struct<Stage>[]
 * @desc バッドエンド回想の情報を登録します。
 * @default []
 * 
 * @param =3
 *
 * @param ==回想シーン画面設定==
 *
 * @param Enable_Bad
 * @text バッドエンド回想コマンド有効化
 * @desc タイトルコマンド上に項目を表示します。
 * @type boolean
 * @on 有効化
 * @off 無効化
 * @default true
 * 
 * @param FlagSwitch_Bad
 * @text フラグスイッチ
 * @desc このシーンに入っているか確認するためのスイッチ
 * @type number
 * @default 0
 * 
 * @param OutlineColor_Bad
 * @text 文字縁取り色
 * @desc 文字の縁取りに使う色を指定します
 * @type string
 * @default #000000
 * 
 * @param TitlePos_Bad
 * @text タイトル位置
 * @desc タイトルの表示位置を指定
 * @type struct<Pos>
 * @default {"x":"35","y":"130"}
 * 
 * @param SubTitlePos_Bad
 * @text サブタイトル位置
 * @desc サブタイトルの表示位置を指定
 * @type struct<Pos>
 * @default {"x":"100","y":"210"}
 * 
 * @param TextPos_Bad
 * @text テキスト位置
 * @desc テキストの表示位置を指定
 * @type struct<Pos>
 * @default {"x":"27","y":"365"}
 * 
 * @param ListPos_Bad
 * @text リスト位置
 * @desc リストの表示位置を指定
 * @type struct<Pos>
 * @default {"x":"733","y":"62"}
 *
 * @param Command_Bad
 * @text コマンド名
 * @desc タイトル画面でのバッドエンド回想用コマンド名。
 * @type string
 * @default 鑑賞モード
 * 
 * @param Command_BadIndex
 * @text コマンドの位置
 * @desc タイトル画面でコマンドが挿入される位置。
 * (下部の項目が優先されます)
 * @type number
 * @default 3
 *
 * @param CharImage_Bad
 * @text 立ち絵画像
 * @desc 立ち絵画像を指定します。
 * @type file
 * @dir img/pictures
 *
 * @param CharPos_Bad
 * @text 立ち絵の位置
 * @type struct<Pos>
 * @desc 回想シーンでの立ち絵の位置を指定します。
 * @default {"x":"80","y":"280"}
 *
 * @param ThumbnailPos_Bad
 * @text マッププレビューの位置
 * @type struct<Pos>
 * @desc マッププレビューの位置を指定します。
 * @default {"x":"648","y":"468"}
 *
 * @param BGImage_Bad
 * @text 背景画像
 * @desc 背景画像を指定します。
 * @type file
 * @dir img/pictures
 *
 * @param BadEndList
 * @text 回想シーン一覧
 * @type struct<Stage>[]
 * @desc バッドエンド回想の情報を登録します。
 * @default []
 * 
 * 
 * 
 * 
 * @command showWindows
 * @text 画面を表示
 * @desc 画面を再び表示します。
 * 
 * @command hideWindows
 * @text 画面を非表示
 * @desc 画面を消します。
 */
/*~struct~Stage:
 * @param Name
 * @text タイトル
 * @type string
 * @desc タイトルを設定します。
 * 
 * @param SubTitle
 * @text サブタイトル
 * @type string
 * @desc サブタイトルを設定します。
 * 
 * @param Message
 * @text メッセージテキスト
 * @type note
 * @desc メッセージウィンドウに表示されるテキストを設定します。
 * 
 * @param Thumbnail
 * @text サムネイル画像
 * @type file
 * @dir img/pictures
 * @desc マップなどのサムネイル画像を設定します。
 * 
 * @param CommonEvent
 * @text コモンイベント
 * @type number
 * @desc 実行するコモンイベントを登録します。
 * @default 1
 * 
 * @param SaveId
 * @text フラグスイッチ番号
 * @type number
 * @desc 選択肢有効化フラグスイッチ番号
 * @default 0
 * 
 * @param nowExecute
 * @text すぐ実行
 * @type boolean
 * @desc この画面でコモンイベントを実行するか。
 * 空マップに移動してから実行するか。
 * @on 移動せず実行
 * @off 移動して実行
 * @default false
 */
/*~struct~Pos:
 * @param x
 * @text X座標
 * @desc X座標を指定します。
 * @min -9999999
 * @type number
 * @default 80
 * 
 * @param y
 * @text Y座標
 * @desc Y座標を指定します。
 * @min -9999999
 * @type number
 * @default 280
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

var Imported = Imported || {};
Imported.Ten_MenuController = true;
// 他のプラグインとの連携用シンボル

(function (_global) {
   /**
    * プラグインパラメータをパース
    */
   var params = PluginManager.parameters('Ten_MenuController');
   params.MapId = Number(params.MapId);

   const params2 = PluginManager.parameters('FOTA3_MenuCommon');
   var backConfigVariable = 0;
   if (params2) {
      backConfigVariable = Number(params2['backConfigVariable']) || 0;
   }

   parseEnable("Enable_Story");
   parseNumber("FlagSwitch_Story");
   parseColor("OutlineColor_Story");
   parsePos("TitlePos_Story");
   parsePos("SubTitlePos_Story");
   parsePos("TextPos_Story");
   parsePos("ListPos_Story");
   parsePos("CharPos_Story");
   parsePos('ThumbnailPos_Story');
   parseNumber("Command_StoryIndex");
   parseList("StoryList");

   parseEnable("Enable_Game");
   parseNumber("FlagSwitch_Game");
   parseColor("OutlineColor_Game");
   parsePos("TitlePos_Game");
   parsePos("SubTitlePos_Game");
   parsePos("TextPos_Game");
   parsePos("ListPos_Game");
   parsePos("CharPos_Game");
   parsePos('ThumbnailPos_Game');
   parseNumber("Command_GameIndex");
   parseList("GameList");

   parseEnable("Enable_Bad");
   parseNumber("FlagSwitch_Bad");
   parseColor("OutlineColor_Bad");
   parsePos("TitlePos_Bad");
   parsePos("SubTitlePos_Bad");
   parsePos("TextPos_Bad");
   parsePos("ListPos_Bad");
   parsePos("CharPos_Bad");
   parsePos('ThumbnailPos_Bad');
   parseNumber("Command_BadIndex");
   parseList("BadEndList");

   function parseEnable(pname) {
      try {
         params[pname] = eval(params[pname]);
      } catch (error) {
         console.error(error);
         params[pname] = true;
      }
   }

   function parseNumber(pname) {
      try {
         params[pname] = Number(params[pname]);
      } catch (error) {
         console.error(error);
         params[pname] = 0;
      }
   }

   function parsePos(pname) {
      try {
         params[pname] = JSON.parse(params[pname]);
         params[pname].x = Number(params[pname].x);
         params[pname].y = Number(params[pname].y);
      } catch (error) {
         console.error(error);
         params[pname] = { x: 0, y: 0 };
      }
   }

   function parseColor(pname) {
      const ColorCodePattern = /#([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})/;
      params[pname] =
         params[pname][0] === '#' ?
            params[pname] :
            '#' + params[pname];
      if (!ColorCodePattern.test(params[pname])) {
         params[pname] = '#000000';
      }
   }

   function parseList(pname) {
      try {
         params[pname] = JSON.parse(params[pname]);
         if (params[pname].forEach) params[pname].forEach((item, index, items) => {
            items[index] = JSON.parse(item);
            if (items[index].CommonEvent) items[index].CommonEvent = Number(items[index].CommonEvent);
            if (items[index].Message) items[index].Message = JSON.parse(items[index].Message);
            if (items[index].SaveId) {
               items[index].SaveId = Number(items[index].SaveId);
            } else {
               items[index].SaveId = 0;
            }
            if (items[index].nowExecute) {
               items[index].nowExecute = eval(items[index].nowExecute);
            } else {
               items[index].nowExecute = false;
            }
         });
      } catch (error) {
         params[pname] = [];
      }
   }


   // 2024/05/10 MVか確認する関数
   function isMV() {
      return Utils.RPGMAKER_NAME !== 'MZ';
   }
   // 2024/05/10 ここまで




   PluginManager.registerCommand('Ten_MenuController', "showWindows", args => {
      if (SceneManager._scene.showWindows) {
         const scene = SceneManager._scene;
         scene.startFadeOut(scene.fadeSpeed(), false);
         scene.queueingExec(scene.showWindows.bind(scene));
         scene.queueingExec(scene.startFadeIn.bind(scene, scene.fadeSpeed(), false));
      }
   });

   PluginManager.registerCommand('Ten_MenuController', "hideWindows", args => {
      if (SceneManager._scene.showWindows) {
         const scene = SceneManager._scene;
         scene.hideWindows();
      }
   });




   /**
    * Window_Commandを拡張
    */
   Window_Command.prototype.insertCommand = function (index, name, symbol, enabled, ext) {
      if (enabled === undefined) {
         enabled = true;
      }
      if (ext === undefined) {
         ext = null;
      }
      this._list.splice(index, 0, { name: name, symbol: symbol, enabled: enabled, ext: ext });
   };




   /**
    * Scene_Title拡張
    */
   // 2025/05/20 オートセーブ対策
   var autoSaveEnable = true;
   var Scene_Title_initialize = Scene_Title.prototype.initialize;
   Scene_Title.prototype.initialize = function () {
      Scene_Title_initialize.call(this);
      autoSaveEnable = true;
   };
   // 2025/05/20 ここまで

   var Scene_Title_createCommandWindow = Scene_Title.prototype.createCommandWindow;
   Scene_Title.prototype.createCommandWindow = function () {
      Scene_Title_createCommandWindow.call(this);
      this._commandWindow.setHandler('openMiniGame', this.commandOpenMiniGame.bind(this));
      this._commandWindow.setHandler('openBadEnd', this.commandOpenBadEnd.bind(this));
   };

   Scene_Title.prototype.commandOpenMiniGame = function () {
      // 2025/05/20 オートセーブ対策
      autoSaveEnable = false;
      // 2025/05/20 ここまで
      AudioManager.stopAll();
      DataManager.setupNewGame();
      var mapId = params.MapId;
      $gamePlayer.reserveTransfer(mapId, 0, 0, 2, 0);
      $gamePlayer.setTransparent(true);
      this._commandWindow.close();
      this.fadeOutAll();
      SceneManager.push(Scene_MiniGame);
   };

   Scene_Title.prototype.commandOpenBadEnd = function () {
      // 2025/05/20 オートセーブ対策
      autoSaveEnable = false;
      // 2025/05/20 ここまで
      AudioManager.stopAll();
      DataManager.setupNewGame();
      var mapId = params.MapId;
      $gamePlayer.reserveTransfer(mapId, 0, 0, 2, 0);
      $gamePlayer.setTransparent(true);
      this._commandWindow.close();
      this.fadeOutAll();
      SceneManager.push(Scene_BadEnd);
   };




   /**
    * Window_TitleCommandを拡張
    */
   // テスト用フラグ
   var Window_TitleCommand_makeCommandList = Window_TitleCommand.prototype.makeCommandList;
   Window_TitleCommand.prototype.makeCommandList = function () {
      Window_TitleCommand_makeCommandList.call(this);
      if (params.Enable_Game)
         this.insertCommand(params.Command_GameIndex, params.Command_Game, 'openMiniGame');
      if (params.Enable_Bad)
         this.insertCommand(params.Command_BadIndex, params.Command_Bad, 'openBadEnd');
   };




   /**
    * Scene_Mapを拡張
    */
   var commonEventId = 0;
   var blackOut = false;
   var Scene_Map_start = Scene_Map.prototype.start;
   var notClearStack = false;
   Scene_Map.prototype.start = function () {
      if (0 < commonEventId) {
         $gameTemp.reserveCommonEvent(commonEventId);
         commonEventId = 0;
      }
      notClearStack = true;
      Scene_Map_start.call(this);
      // 2024/11/21 とりあえずエラーが出ないようにだけコメントアウト
      // if (blackOut) {
      //    this.createFadeSprite();
      //    this._blackSprite = this._fadeSprite;
      //    this._fadeSprite = null;
      //    this._blackSprite.opacity = 255;
      //    blackOut = false;
      // } else if (this._blackSprite) {
      //    this._blackSprite.opacity = 0;
      //    this._blackSprite = null;
      // }
      // 2024/11/21 ここまで
   };

   // 2024/11/22 マップに戻ってマップ移動を行うまで場所移動画面のスクリーンショットを強制表示
   const Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;
   Scene_Map.prototype.createDisplayObjects = function () {
      Scene_Map_createDisplayObjects.call(this);
      if (screenBitmap) {
         this._screenOverride = new Sprite(screenBitmap);
         screenBitmap = null;
         this.addChild(this._screenOverride);
      }
   };
   // 2024/11/22 ここまで

   // 2025/05/20 オートセーブ対策
   const Scene_Map_shouldAutosave = Scene_Map.prototype.shouldAutosave;
   Scene_Map.prototype.shouldAutosave = function () {
      return Scene_Map_shouldAutosave.call(this) && autoSaveEnable;
   };
   // 2025/05/20 ここまで

   const SceneManager_clearStack = SceneManager.clearStack;
   SceneManager.clearStack = function () {
      if (notClearStack) {
         notClearStack = false;
         return;
      }
      SceneManager_clearStack.call(this);
   };




   /**
    * Scene_Menuを変更
    */
   var Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
   Scene_Menu.prototype.createCommandWindow = function () {
      Scene_Menu_createCommandWindow.call(this);
      this._commandWindow.setHandler('move', this.commandMove.bind(this));
   };

   Scene_Menu.prototype.commandMove = function () {
      SceneManager.push(Scene_StoryMenu);
   };




   /**
    * Window_MenuCommandを変更
    */
   var Window_MenuCommand_makeCommandList = Window_MenuCommand.prototype.makeCommandList;
   Window_MenuCommand.prototype.makeCommandList = function () {
      Window_MenuCommand_makeCommandList.call(this);
      if (params.Enable_Story)
         this.insertCommand(params.Command_StoryIndex, params.Command_Story, 'move');
   };




   /**
    * DataManagerを拡張
    */
   DataManager.setupEventApply = function () {
      this.createGameObjects();
      this.selectSavefileForNewGame();
      $gameParty.setupStartingMembers();
      Graphics.frameCount = 0;
   };




   /**
    * StorageManagerを拡張
    */
   var StorageManager_localFilePath = StorageManager.localFilePath;
   StorageManager.localFilePath = function (savefileId) {
      if (typeof savefileId === 'string') {
         var name = savefileId + '.rpgsave';
         return this.localFileDirectoryPath() + name;
      } else {
         return StorageManager_localFilePath.call(this, savefileId);
      }
   };




   /**
    * Game_Playerを拡張
    */
   var Game_Player_canMove = Game_Player.prototype.canMove;
   Game_Player.prototype.canMove = function () {
      var activeScene = SceneManager._scene;
      if (activeScene.constructor !== Scene_Map && activeScene.canMove) {
         return activeScene.canMove();
      }
      return Game_Player_canMove.call(this);
   };




   /**
    * Game_Mapを拡張
    */
   Game_Map.prototype.updateEvents = function () {
      var activeScene = SceneManager._scene;
      if (!(activeScene.constructor === Scene_StoryMenu)) {
         this.events().forEach(function (event) {
            event.update();
         });
      }
      this._commonEvents.forEach(function (event) {
         event.update();
      });
   };





   /**
    * Spriteset_Mapを拡張
    */
   var Spriteset_Map_initialize = Spriteset_Map.prototype.initialize;
   Spriteset_Map.prototype.initialize = function () {
      var scene = SceneManager._scene;
      if (scene._requireBackImage) {
         this._createBackground = scene.createBackground.bind(scene);
      }
      if (scene._requireStaticImage) {
         this._createStaticImage = scene.createStaticImage.bind(scene);
      }
      Spriteset_Map_initialize.call(this);
   };

   var Spriteset_Map_createUpperLayer = Spriteset_Map.prototype.createUpperLayer;
   Spriteset_Map.prototype.createUpperLayer = function () {
      if (this._createBackground) {
         var sprite = this._createBackground();
         this.addChild(sprite);
      }
      if (this._createStaticImage) {
         var sprites = this._createStaticImage();
         this.addChild(sprites.backSprite);
         this.addChild(sprites.charSprite);
         this.addChild(sprites.thumbnail);
      }
      Spriteset_Map_createUpperLayer.call(this);
   };




   /**
    * Scene_GameMenuBaseを定義
    */
   function Scene_GameMenuBase() {
      this.initialize.apply(this, arguments);
   }

   Scene_GameMenuBase.prototype = Object.create(Scene_Map.prototype);
   Scene_GameMenuBase.prototype.constructor = Scene_GameMenuBase;

   Scene_GameMenuBase.prototype.initialize = function () {
      Scene_Map.prototype.initialize.call(this);
      this._backImage = null;
      this._charImage = null;
      this._charPos = null;
      this._menuList = null;
      this._blackSprite = null;
      this._windowHidden = false;
      this._requireStaticImage = true;
      this._requireBackImage = true;
      this._execQueue = [];

      // this._titlePos = params.TitlePos_Bad;
      // this._subTitlePos = params.SubTitlePos_Bad;
      // this._textPos = params.TextPos_Bad;
      // this._listPos = params.ListPos_Bad;
      // this._outlineColor = params.OutlineColor_Bad;
      // this._thumbnailPos = params.ThumbnailPos_Bad;
   };

   Scene_GameMenuBase.prototype.createBackground = function () {
      var backNum = $gameVariables.value(backConfigVariable) || 0;
      this._customBGSprite;
      if (backNum > 0 && backNum < 100) {
         var fileName = 'menu_bg' + ('00' + backNum).slice(-2);
         if (this.constructor.name === 'Scene_Menu') {
            fileName += 'a';
         } else {
            fileName += 'b';
         }
         this._customBGSprite = new Sprite(ImageManager.loadBitmap("img/menuC/", fileName));
      }
      // this.addChild(this._customBGSprite);
      return this._customBGSprite || new Sprite();
   };

   Scene_GameMenuBase.prototype.createStaticImage = function () {
      // 2025/12/20 8番スイッチがONの時は読み込む背景を変更
      let suffix = '';
      if (this.constructor.name === 'Scene_BadEnd' && $gameSwitches.value(8)) {
         suffix = '_free';
      }
      this._backSprite = new Sprite(ImageManager.loadPicture(this._backImage + suffix));
      this._charSprite = new Sprite(ImageManager.loadPicture(this._charImage));
      // 2025/12/20 ここまで
      this._thumbnail = new Sprite();
      var charPos = this._charPos || { x: 80, y: 280 };
      this._charSprite.move(charPos.x, charPos.y);
      var unit = Window_Base.prototype.lineHeight();
      var thumbnailPos = this._thumbnailPos || { x: 648, y: 468 };
      this._thumbnail.move(thumbnailPos.x, thumbnailPos.y);
      return { backSprite: this._backSprite, charSprite: this._charSprite, thumbnail: this._thumbnail };
   };

   Scene_GameMenuBase.prototype.createWindows = function () {
      this._titleWindow = new Window_MenuTitle(this._titlePos, this._outlineColor);
      this._subTitleWindow = new Window_MenuSubTitle(this._subTitlePos, this._outlineColor);
      this._textWindow = new Window_MenuText(this._textPos, this._outlineColor);
      this.createListWindow();
      this.addWindow(this._titleWindow);
      this.addWindow(this._subTitleWindow);
      this.addWindow(this._textWindow);
      if (this._listWindow) this.addWindow(this._listWindow);
   };

   Scene_GameMenuBase.prototype.createListWindow = function () {
      this._listWindow = new Window_MenuList(null, this._listPos, this._outlineColor);
      this._listWindow.setHandler('ok', this.menuOk.bind(this));
      this._listWindow.setHandler('cancel', this.menuCancel.bind(this));
      this._listWindow.setList(this._menuList);
      this._listWindow.setTitleWindow(this._titleWindow);
      this._listWindow.setSubTitleWindow(this._subTitleWindow);
      this._listWindow.setTextWindow(this._textWindow);
      this._listWindow.setThumbnale(this._thumbnail);
      this._listWindow.refresh();
      this._listWindow.select(0);
   };

   Scene_GameMenuBase.prototype.createAllWindows = function () {
      this.createWindows();
      Scene_Map.prototype.createAllWindows.call(this);
   };

   Scene_GameMenuBase.prototype.start = function () {
      Scene_Map.prototype.start.call(this);
      // 2024/08/27 音楽再生停止を無効化
      // AudioManager.stopAll();
      // $gameMap._interpreter.pluginCommand('StopAllSound');
      // 2024/08/27 ここまで
      $gameScreen.clear();
      this._windowLayer.children.forEach(window => {
         if (!(
            window === this._titleWindow ||
            window === this._subTitleWindow ||
            window === this._textWindow ||
            window === this._listWindow
         )) {
            if (window.hide) {
               if (!(window === this._messageWindow ||
                  window === this._nameBoxWindow ||
                  window === this._choiceListWindow
               )) {
                  window.hide();
               }
            }
         } else {
            // フレーム・背景非表示処理
            window.backOpacity = 0;
            window.frameVisible = false;
         }
      });
      this.children.forEach(sprite => {
         if (!(
            sprite === this._spriteset ||
            sprite === this._mapNameWindow ||
            sprite === this._fadeSprite ||
            sprite === this._nameBoxWindow
         )) {
            if (sprite.hide) {
               sprite.hide();
            } else if (sprite.opacity) {
               sprite.opacity = 0;
            }
         }
      });
      this._spriteset.children.forEach(sprite => {
         if (!(
            sprite === this._customBGSprite ||
            sprite === this._backSprite ||
            sprite === this._charSprite ||
            sprite === this._thumbnail ||
            sprite === this._spriteset._baseSprite ||
            sprite === this._spriteset._toneSprite ||
            sprite === this._spriteset._pictureContainer ||
            sprite === this._spriteset._timerSprite ||
            sprite === this._spriteset._flashSprite ||
            sprite === this._spriteset._fadeSprite ||
            sprite === this._spriteset._weather
         )) {
            if (sprite.hide) {
               sprite.hide();
            } else if (sprite.opacity) {
               sprite.opacity = 0;
            }
         }
      });
   };

   Scene_GameMenuBase.prototype.terminate = function () {
      // 2024/11/18 MZ対応
      if (isMV()) {
         Scene_Base.prototype.terminate.call(this);
         if (!SceneManager.isNextScene(Scene_Battle)) {
            this._spriteset.update();
            this._mapNameWindow.hide();
         } else {
            ImageManager.clearRequest();
         }

         if (SceneManager.isNextScene(Scene_Map)) {
            ImageManager.clearRequest();
         }

         $gameScreen.clearZoom();
      } else {
         Scene_Message.prototype.terminate.call(this);
         if (!SceneManager.isNextScene(Scene_Battle)) {
            this._spriteset.update();
            this._mapNameWindow.hide();
            this.hideMenuButton();
            // 2024/11/21 背景が変わらないように変更
            // SceneManager.snapForBackground();
            // 2024/11/21 ここまで
         }
         $gameScreen.clearZoom();
      }
      // 2024/11/18 ここまで

      // this.removeChild(this._fadeSprite);
      this.removeChild(this._mapNameWindow);
      this.removeChild(this._windowLayer);
      this.removeChild(this._spriteset);
      this.removeChild(this._blackSprite);
   };

   Scene_GameMenuBase.prototype.canMove = function () {
      return false;
   };

   Scene_GameMenuBase.prototype.updateCallMenu = function () { };

   Scene_GameMenuBase.prototype.processMapTouch = function () { };

   Scene_GameMenuBase.prototype.updateTransferPlayer = function () {
      if ($gamePlayer.isTransferring()) {
         SceneManager.push(Scene_Map);
      }
   };

   Scene_GameMenuBase.prototype.hideWindows = function () {
      this._windowHidden = true;
      this._charSprite.opacity = 0;
      this._backSprite.opacity = 0;
      this._thumbnail.opacity = 0;
      if (this._customBGSprite) this._customBGSprite.opacity = 0;
      this._titleWindow.hide();
      this._subTitleWindow.hide();
      this._textWindow.hide();
      this._listWindow.hide();
      this._listWindow.deactivate();
   };

   Scene_GameMenuBase.prototype.showWindows = function () {
      wait = 60;
      this._windowHidden = false;
      this._charSprite.opacity = 255;
      this._backSprite.opacity = 255;
      this._thumbnail.opacity = 255;
      if (this._customBGSprite) this._customBGSprite.opacity = 255;
      this._titleWindow.show();
      this._subTitleWindow.show();
      this._textWindow.show();
      this._listWindow.show();
      this._listWindow.activate();
      $gameScreen.clear();
   };

   // 継承した各シーン毎に定義
   Scene_GameMenuBase.prototype.menuOk = function () { };

   Scene_GameMenuBase.prototype.menuCancel = function () {
      if (!this._windowHidden) {
         SceneManager.pop();
      } else {
         // 2024/08/27 音楽再生停止を無効化
         // AudioManager.stopAll();
         // $gameMap._interpreter.pluginCommand('StopAllSound');
         // 2024/08/27 ここまで
         $gameScreen.clear();
         this.showWindows();
      }
   };

   const Scene_GameMenuBase_update = Scene_GameMenuBase.prototype.update;
   Scene_GameMenuBase.prototype.update = function () {
      Scene_GameMenuBase_update.call(this);
      if (!this.fadeBusy()) {
         while (this.isQueued()) {
            this.executeQueue();
         }
      }
      if (wait > 0) {
         wait--;
      }
   };

   Scene_GameMenuBase.prototype.fadeBusy = function () {
      return this.isFading() ||
         $gameScreen._fadeOutDuration > 0 ||
         $gameScreen._fadeInDuration > 0;
   };

   Scene_GameMenuBase.prototype.isQueued = function () {
      return this._execQueue.length > 0;
   };

   Scene_GameMenuBase.prototype.executeQueue = function () {
      this._execQueue.shift()();
   };

   Scene_GameMenuBase.prototype.queueingExec = function (func) {
      this._execQueue.push(func);
   };

   var wait = 0;
   const Scene_GameMenuBase_isBusy = Scene_GameMenuBase.prototype.isBusy;
   Scene_GameMenuBase.prototype.isBusy = function () {
      return Scene_GameMenuBase_isBusy.call(this) || wait > 0;
   };




   /**
    * Scene_StoryMenu
    */
   function Scene_StoryMenu() {
      this.initialize.apply(this, arguments);
   }

   Scene_StoryMenu.prototype = Object.create(Scene_GameMenuBase.prototype);
   Scene_StoryMenu.prototype.constructor = Scene_StoryMenu;

   Scene_StoryMenu.prototype.initialize = function () {
      Scene_GameMenuBase.prototype.initialize.call(this);
      this._backImage = params.BGImage_Story;
      this._charImage = params.CharImage_Story;
      this._charPos = params.CharPos_Story;
      this._menuList = params.StoryList;

      this._titlePos = params.TitlePos_Story;
      this._subTitlePos = params.SubTitlePos_Story;
      this._textPos = params.TextPos_Story;
      this._listPos = params.ListPos_Story;
      this._outlineColor = params.OutlineColor_Story;
      this._thumbnailPos = params.ThumbnailPos_Story;

      const flagSW = params.FlagSwitch_Story;
      if (flagSW) {
         $gameSwitches.setValue(flagSW, true);
      }
   };

   var screenBitmap = null;
   Scene_StoryMenu.prototype.menuOk = function () {
      var menu = this._listWindow;
      var item = menu.item(menu.index());
      commonEventId = item.CommonEvent;
      var commonEvent = $dataCommonEvents[commonEventId];
      if (commonEvent) {
         commonEvent.list.forEach(item => {
            if (item.code === 201) {
               blackOut = true;
            }
         });
      }
      // 2024/11/22 場所移動画面をスクリーンショット
      screenBitmap = Bitmap.snap(SceneManager._scene);
      // 2024/11/22 ここまで
      SceneManager.pop();
      SceneManager.pop();
   };

   Scene_StoryMenu.prototype.createListWindow = function () {
      this._listWindow = new Window_MenuList('?', this._listPos, this._outlineColor);
      this._listWindow.setHandler('ok', this.menuOk.bind(this));
      this._listWindow.setHandler('cancel', this.menuCancel.bind(this));
      this._listWindow.setList(this._menuList);
      this._listWindow.setTitleWindow(this._titleWindow);
      this._listWindow.setSubTitleWindow(this._subTitleWindow);
      this._listWindow.setTextWindow(this._textWindow);
      this._listWindow.setThumbnale(this._thumbnail);
      this._listWindow.refresh();
      this._listWindow.select(0);
   };

   Scene_StoryMenu.prototype.fadeOutForTransfer = function () { };





   /**
    * Scene_MiniGame
    */
   function Scene_MiniGame() {
      this.initialize.apply(this, arguments);
   }

   Scene_MiniGame.prototype = Object.create(Scene_GameMenuBase.prototype);
   Scene_MiniGame.prototype.constructor = Scene_MiniGame;

   Scene_MiniGame.prototype.initialize = function () {
      Scene_GameMenuBase.prototype.initialize.call(this);
      this._backImage = params.BGImage_Game;
      this._charImage = params.CharImage_Game;
      this._charPos = params.CharPos_Game;
      this._menuList = params.GameList;

      this._titlePos = params.TitlePos_Game;
      this._subTitlePos = params.SubTitlePos_Game;
      this._textPos = params.TextPos_Game;
      this._listPos = params.ListPos_Game;
      this._outlineColor = params.OutlineColor_Game;
      this._thumbnailPos = params.ThumbnailPos_Game;

      const flagSW = params.FlagSwitch_Game;
      if (flagSW) {
         $gameSwitches.setValue(flagSW, true);
      }
   };

   Scene_MiniGame.prototype.menuOk = function () {
      var menu = this._listWindow;
      var item = menu.item(menu.index());
      var commonEvent = item.CommonEvent;
      var mapId = params.MapId;
      // 2024/08/27 音楽再生停止を無効化
      // AudioManager.stopAll();
      // $gameMap._interpreter.pluginCommand('StopAllSound');
      // 2024/08/27 ここまで
      $gameScreen.clear();
      if (!item.nowExecute) {
         DataManager.setupEventApply();
         $gamePlayer.reserveTransfer(mapId, 0, 0, 2, 0);
         $gamePlayer.setTransparent(true);
         commonEventId = commonEvent;
         $gameSystem.disableMenu();
      } else {
         this.startFadeOut(this.fadeSpeed(), false);
         this.queueingExec(this.hideWindows.bind(this));
         this.queueingExec(function () { $gameScreen._brightness = 0; }.bind(this));
         this.queueingExec(function () { this._fadeOpacity = 0; }.bind(this));
         this.queueingExec($gameTemp.reserveCommonEvent.bind($gameTemp, commonEvent));
         // this.queueingExec($gameScreen.startFadeIn.bind($gameScreen, this.slowFadeSpeed()));
      }
   };

   Scene_MiniGame.prototype.createListWindow = function () {
      this._listWindow = new Window_MenuList('?', this._listPos, this._outlineColor);
      this._listWindow.setHandler('ok', this.menuOk.bind(this));
      this._listWindow.setHandler('cancel', this.menuCancel.bind(this));
      this._listWindow.setList(this._menuList);
      this._listWindow.setTitleWindow(this._titleWindow);
      this._listWindow.setSubTitleWindow(this._subTitleWindow);
      this._listWindow.setTextWindow(this._textWindow);
      this._listWindow.setThumbnale(this._thumbnail);
      this._listWindow.refresh();
      this._listWindow.select(0);
   };

   const Scene_MiniGame_terminate = Scene_MiniGame.prototype.terminate;
   Scene_MiniGame.prototype.terminate = function () {
      Scene_MiniGame_terminate.call(this);
      const flagSW = params.FlagSwitch_Game;
      if (flagSW) {
         $gameSwitches.setValue(flagSW, false);
      }
   };




   /**
    * Scene_BadEnd
    */
   function Scene_BadEnd() {
      this.initialize.apply(this, arguments);
   }

   Scene_BadEnd.prototype = Object.create(Scene_GameMenuBase.prototype);
   Scene_BadEnd.prototype.constructor = Scene_BadEnd;

   Scene_BadEnd.prototype.initialize = function () {
      Scene_GameMenuBase.prototype.initialize.call(this);
      this._backImage = params.BGImage_Bad;
      this._charImage = params.CharImage_Bad;
      this._charPos = params.CharPos_Bad;
      this._menuList = params.BadEndList;

      this._titlePos = params.TitlePos_Bad;
      this._subTitlePos = params.SubTitlePos_Bad;
      this._textPos = params.TextPos_Bad;
      this._listPos = params.ListPos_Bad;
      this._outlineColor = params.OutlineColor_Bad;
      this._thumbnailPos = params.ThumbnailPos_Bad;

      const flagSW = params.FlagSwitch_Bad;
      if (flagSW) {
         $gameSwitches.setValue(flagSW, true);
      }
   };

   Scene_BadEnd.prototype.menuOk = function () {
      var menu = this._listWindow;
      var item = menu.item(menu.index());
      var commonEvent = item.CommonEvent;
      var mapId = params.MapId;
      $gameScreen.clear();
      if (!item.nowExecute) {
         DataManager.setupEventApply();
         $gamePlayer.reserveTransfer(mapId, 0, 0, 2, 0);
         $gamePlayer.setTransparent(true);
         commonEventId = commonEvent;
         $gameSystem.disableMenu();
      } else {
         this.startFadeOut(this.fadeSpeed(), false);
         this.queueingExec(this.hideWindows.bind(this));
         this.queueingExec(function () { $gameScreen._brightness = 0; }.bind(this));
         this.queueingExec(function () { this._fadeOpacity = 0; }.bind(this));
         this.queueingExec($gameTemp.reserveCommonEvent.bind($gameTemp, commonEvent));
         // this.queueingExec($gameScreen.startFadeIn.bind($gameScreen, this.slowFadeSpeed()));
      }
   };

   const Scene_BadEnd_terminate = Scene_BadEnd.prototype.terminate;
   Scene_BadEnd.prototype.terminate = function () {
      Scene_BadEnd_terminate.call(this);
      const flagSW = params.FlagSwitch_Bad;
      if (flagSW) {
         $gameSwitches.setValue(flagSW, false);
      }
   };




   // 2025/05/23 文字溢れ対策
   Window_Base.prototype.calculateTextAndIconWidth = function (text) {
      const convertedText = this.convertEscapeCharacters(text);

      const iconRegex = /\x1bI\[\d+\]/gi;
      let iconCount = 0;
      let match;
      while ((match = iconRegex.exec(convertedText)) !== null) {
         iconCount++;
      }

      const totalIconWidth = iconCount * (ImageManager.iconWidth + 4);

      const escapeRegex = /\x1b(?:[$.|^!><{}\\]|[^A-Z]*[A-Z]+(?:\[\d+\])?)/gi;
      const pureText = convertedText.replace(escapeRegex, "");

      const totalTextWidth = this.textWidth(pureText);

      return { iconWidth: totalIconWidth, textWidth: totalTextWidth };
   };

   function getLineFromCharIndex(text, charIndex) {
      if (charIndex < 0 || charIndex >= text.length) {
         // インデックスが文字列の範囲外の場合
         return null;
      }

      const lines = text.split('\n');
      let currentIndex = 0;

      for (let i = 0; i < lines.length; i++) {
         const line = lines[i];
         // 行の長さ + 改行文字の長さ (LFのみなので1)
         // 最後の行には改行文字がない場合があるため、text.lengthと比較して調整
         const lineLengthWithNewline = line.length + (i < lines.length - 1 ? 1 : 0);

         if (charIndex >= currentIndex && charIndex < currentIndex + lineLengthWithNewline) {
            return line;
         }
         currentIndex += lineLengthWithNewline;
      }

      return null; // 見つからない場合（通常は到達しないはず）
   }

   function flushTextState(textState) {
      let index = textState.index - 1;
      let line = getLineFromCharIndex(textState.text, index);
      let scale = 1;
      if (textState.text[index] === '\n' || textState.text.length <= index) {
         line = getLineFromCharIndex(textState.text, index - 1);
      }
      const widths = this.calculateTextAndIconWidth(line);
      const textSize = widths.iconWidth + widths.textWidth;
      const iconWidth = widths.iconWidth;
      const widthDiff = textState.width - iconWidth;
      scale = widthDiff / widths.textWidth;

      const text = textState.buffer;
      const rtl = textState.rtl;
      const width = this.textWidth(text) * (scale > 1 ? 1 : scale);
      const height = textState.height;
      const x = rtl ? textState.x - width : textState.x;
      const y = textState.y;
      if (textState.drawing) {
         this.contents.drawText(text, x, y, width, height);
      }
      textState.x += rtl ? -width : width;
      textState.buffer = this.createTextBuffer(rtl);
      const outputWidth = Math.abs(textState.x - textState.startX);
      if (textState.outputWidth < outputWidth) {
         textState.outputWidth = outputWidth;
      }
      textState.outputHeight = y - textState.startY + height;
   }
   // 2025/05/23 ここまで

   /**
    * Window_MenuListを定義
    */
   function Window_MenuList() {
      this.initialize.apply(this, arguments);
   }

   Window_MenuList.prototype = Object.create(Window_Selectable.prototype);
   Window_MenuList.prototype.constructor = Window_MenuList;

   Window_MenuList.prototype.initialize = function (mode, pos, outlineColor) {
      this._mode = mode ? mode : 'normal';
      var width = this.windowWidth() + this.lrButtonWidth() * 2;
      var height = this.windowHeight();
      // リストウィンドウの表示位置
      var x = pos.x || 733;
      var y = pos.y || 62;
      this._outlineColor = outlineColor;
      this._categories = [];
      this._categoryIndex = 0;
      this._titleWindow = null;
      this._subTitleWindow = null;
      this._textWindow = null;
      this._thumbnail = null;
      Window_Selectable.prototype.initialize.call(this, new Rectangle(x - this.lrButtonWidth(), y, width, height));
      this.changeOutlineColor(outlineColor);

      this.refresh();
      this.select(0);
      this.activate();
   };

   Window_MenuList.prototype.changeOutlineColorAuto = function () {
      this.changeOutlineColor(this._outlineColor);
   };

   Window_MenuList.prototype.windowWidth = function () {
      return this.fittingHeight(11);
   };

   Window_MenuList.prototype.windowHeight = function () {
      return this.fittingHeight(9);
   };

   // カテゴリー切り替えボタンの幅を定義
   Window_MenuList.prototype.lrButtonWidth = function () {
      return this.lineHeight() * 2;
   };

   // Window_MenuList.prototype.standardPadding = function () {
   //    return 0;
   // };

   // // ウィンドウの枠を非表示
   // Window_MenuList.prototype._refreshFrame = function () { };

   Window_MenuList.prototype.maxItems = function () {
      if (this._categories.length === 0) {
         return 0;
      }
      return this._categories[this._categoryIndex].items.length;
   };

   Window_MenuList.prototype.itemTextAlign = function () {
      return 'left';
   };

   Window_MenuList.prototype.setList = function (list) {
      this._categories = [];
      let currentCategory = null;
      const sceneName = SceneManager._scene.constructor.name;
      const filteredList = (sceneName === 'Scene_StoryMenu') ? list.filter(item => {
         return this.isItemEnable(item) || item.Name.startsWith('[category]');
      }) : list;

      filteredList.forEach(item => {
         if (item.Name.startsWith('[category]')) {
            const categoryName = item.Name.substring('[category]'.length);
            let existingCategory = this._categories.find(c => c.name === categoryName);
            if (existingCategory) {
               currentCategory = existingCategory;
            } else {
               currentCategory = {
                  name: categoryName,
                  items: []
               };
               this._categories.push(currentCategory);
            }
         } else {
            if (!currentCategory) {
               currentCategory = {
                  name: 'default',
                  items: []
               };
               this._categories.push(currentCategory);
            }
            currentCategory.items.push(item);
         }
      });
      if (this._categories.length > 0 && this._categories[0].name === 'default' && this._categories[0].items.length === 0) {
         this._categories.shift();
      }
   };

   Window_MenuList.prototype.item = function (index) {
      if (this._categories.length === 0) {
         return null;
      }
      return this._categories[this._categoryIndex].items[index];
   };

   Window_MenuList.prototype.drawItem = function (index) {
      var item = this.item(index);
      var rect = null;
      // 2024/10/29 MZ対応
      if (isMV()) {
         rect = this.itemRectForText(index);
      } else {
         rect = this.itemLineRect(index);
      }
      // 2024/10/29 ここまで
      // 2025/11/01 描画範囲を狭める
      rect = this.fixRect(rect);
      // 2025/11/01 ここまで
      var align = this.itemTextAlign();
      this.resetTextColor();
      var name = item.Name;
      var mode = this._mode;
      this.changePaintOpacity(this.isEnable(index));
      if (mode === '?' && !this.isEnable(index)) {
         name = name.replace(/./g, '？');
      }
      // 2024/12/21 テキストの処理をdrawTextExに変更
      // var textState = this.createTextState(name, 0, 0, 0);
      // while (textState.index < textState.text.length) {
      //    this.processCharacter(textState);
      // }
      // this.drawText(textState.buffer, rect.x, rect.y, rect.width, align);
      this.drawTextEx(name, rect.x, rect.y, rect.width);
      // 2024/12/21 ここまで
   };

   // 2025/11/01 カーソルのサイズを変更
   Window_MenuList.prototype.refreshCursor = function () {
      if (this._cursorAll) {
         this.refreshCursorForAll();
      } else if (this.index() >= 0) {
         // カーソルサイズを小さくする
         const rect = this.fixRect(this.itemRect(this.index()));
         this.setCursorRect(rect.x, rect.y, rect.width, rect.height);
      } else if (this.index() < -1) {
         // 2025/11/04 左右カーソルボタン非表示のためにコメントアウト
         // const rect = this.itemRect(this.index());
         // this.setCursorRect(rect.x, rect.y, rect.width, rect.height);
      } else {
         this.setCursorRect(0, 0, 0, 0);
      }
   };
   // 2025/11/01 ここまで

   // 2025/11/01 マウスポインター/タッチの当たり判定修正
   Window_MenuList.prototype.hitTest = function (x, y) {
      if (this.innerRect.contains(x, y)) {
         const cx = this.origin.x + x - this.padding;
         const cy = this.origin.y + y - this.padding;
         const topIndex = this.topIndex();
         for (let i = 0; i < this.maxVisibleItems(); i++) {
            const index = topIndex + i;
            if (index < this.maxItems()) {
               const rect = this.fixRect(this.itemRect(index));
               if (rect.contains(cx, cy)) {
                  return index;
               }
            }
         }
         const leftRect = this.itemRect(-2);
         const rightRect = this.itemRect(-3);
         if (leftRect.contains(cx, cy)) {
            return -2;
         } else if (rightRect.contains(cx, cy)) {
            return -3;
         }
      }
      return -1;
   };
   // 2025/11/01 ここまで

   Window_MenuList.prototype.onTouchSelect = function (trigger) {
      this._doubleTouch = false;
      if (this.isCursorMovable()) {
         const lastIndex = this.index();
         const hitIndex = this.hitIndex();
         const lastCategoryIndex = this._categoryIndex;

         if (hitIndex >= 0) {
            if (hitIndex === this.index()) {
               this._doubleTouch = true;
            }
            this.select(hitIndex);
         } else if (hitIndex < -1) {
            this._doubleTouch = true;
            // this.select(hitIndex);
         }
         // if (trigger && this.index() !== lastIndex || this._categoryIndex !== lastCategoryIndex) {
         //    this.playCursorSound();
         // }
      }
   };

   const Window_MenuList_onTouchOk = Window_MenuList.prototype.onTouchOk;
   Window_MenuList.prototype.onTouchOk = function () {
      Window_MenuList_onTouchOk.apply(this, arguments);
      if (this.isTouchOkEnabled()) {
         const lastIndex = this.index();
         const hitIndex = this.hitIndex();
         const lastCategoryIndex = this._categoryIndex;
         if (hitIndex < -1) {
            if (hitIndex === -2) {
               this.cursorLeft();
            } else if (hitIndex === -3) {
               this.cursorRight();
            }
            if (this.index() !== lastIndex || this._categoryIndex !== lastCategoryIndex) {
               this.playCursorSound();
            }
         }
      }
   };

   const Window_MenuList_itemRect = Window_MenuList.prototype.itemRect;
   Window_MenuList.prototype.itemRect = function (index) {
      if (index >= -1) {
         return Window_MenuList_itemRect.apply(this, arguments);
      } else {
         const offsetX = this.lrButtonWidth();
         const innerWidth = this.innerWidth;
         const innerHeight = this.innerHeight;
         if (index === -2) {
            // 左
            return new Rectangle(0, 0, offsetX, innerHeight);
         } else if (index === -3) {
            // 右
            return new Rectangle(innerWidth - offsetX, 0, offsetX, innerHeight);
         }
      }
   };

   // 2025/11/01 rectを修正する関数
   Window_MenuList.prototype.fixRect = function (rect) {
      let offsetX = this.lrButtonWidth();
      rect.x += offsetX;
      rect.width -= offsetX * 2;
      return rect;
   };
   // 2025/11/01 ここまで

   Window_MenuList.prototype.processCursorMove = function () {
      if (this.isCursorMovable()) {
         const lastIndex = this.index();
         const lastCategoryIndex = this._categoryIndex;
         if (Input.isRepeated("down")) {
            this.cursorDown(Input.isTriggered("down"));
         }
         if (Input.isRepeated("up")) {
            this.cursorUp(Input.isTriggered("up"));
         }
         if (Input.isRepeated("right")) {
            this.cursorRight(Input.isTriggered("right"));
         }
         if (Input.isRepeated("left")) {
            this.cursorLeft(Input.isTriggered("left"));
         }
         if (!this.isHandled("pagedown") && Input.isTriggered("pagedown")) {
            this.cursorPagedown();
         }
         if (!this.isHandled("pageup") && Input.isTriggered("pageup")) {
            this.cursorPageup();
         }
         if (this.index() !== lastIndex || this._categoryIndex !== lastCategoryIndex) {
            this.playCursorSound();
         }
      }
   };

   Window_MenuList.prototype.cursorRight = function (wrap) {
      if (this._categories.length > 1) {
         this._categoryIndex = (this._categoryIndex + 1) % this._categories.length;
         this.refresh();
         this.select(0);
         this.scrollTo(0, 0);
      }
   };

   Window_MenuList.prototype.cursorLeft = function (wrap) {
      if (this._categories.length > 1) {
         this._categoryIndex = (this._categoryIndex - 1 + this._categories.length) % this._categories.length;
         this.refresh();
         this.select(0);
         this.scrollTo(0, 0);
      }
   };

   // 2024/12/26 ボタン押しっぱなし対策
   const Window_MenuList_processOk = Window_MenuList.prototype.processOk;
   Window_MenuList.prototype.processOk = function () {
      if (SceneManager._scene.isQueued() || SceneManager._scene.isBusy() || this._onTrigger) {
         return;
      } else {
         this._onTrigger = true;
         Window_MenuList_processOk.apply(this, arguments);
      }
   };

   const Window_MenuList_update = Window_MenuList.prototype.update;
   Window_MenuList.prototype.update = function () {
      Window_MenuList_update.apply(this, arguments);
      if (this._onTrigger && this.active && !Input.isPressed('ok')) {
         this._onTrigger = false;
      }
      this.updateArrowAnimation();
   };
   // 2024/12/26 ここまで

   Window_MenuList.prototype.updateArrowAnimation = function () {
      const p = 24;
      const q = p / 4;
      if (typeof this._arrowAnimCount !== 'number') {
         this._arrowAnimCount = 0;
         this._arrowAnimCycle = 60; //framecount
      }
      if (this._arrowAnimCount < this._arrowAnimCycle / 2) {
         this._leftArrowSprite.x -= q / (this._arrowAnimCycle / 2);
         this._rightArrowSprite.x += q / (this._arrowAnimCycle / 2);
      } else {
         this._leftArrowSprite.x += q / (this._arrowAnimCycle / 2);
         this._rightArrowSprite.x -= q / (this._arrowAnimCycle / 2);
      }

      this._arrowAnimCount++;
      if (this._arrowAnimCount >= this._arrowAnimCycle) {
         this._arrowAnimCount = 0;
         // this._leftArrowSprite.x += q;
         // this._rightArrowSprite.x -= q;
      }
   };

   Window_MenuList.prototype._createArrowSprites = function () {
      Window.prototype._createArrowSprites.call(this);
      this._leftArrowSprite = new Sprite();
      this._rightArrowSprite = new Sprite();
      this.addChild(this._leftArrowSprite);
      this.addChild(this._rightArrowSprite);
   };

   Window_MenuList.prototype._refreshArrows = function () {
      Window.prototype._refreshArrows.call(this);
      const w = this._width;
      const h = this._height;
      const p = 24;
      const q = p / 2;
      const sx = 96 + p;
      const sy = 0 + p;

      const offsetX = this.lrButtonWidth();

      this._leftArrowSprite.bitmap = this.windowskin;
      this._leftArrowSprite.anchor.x = 0.5;
      this._leftArrowSprite.anchor.y = 0.5;
      this._leftArrowSprite.setFrame(sx, sy + q, q, p);
      // アニメーションのために初期位置を内側に設定
      // ウィンドウの実態を横に伸ばしているためその補正
      this._leftArrowSprite.move(0 + q / 2 + offsetX, h / 2);
      // this._leftArrowSprite.move(0 + q / 2 + offsetX * (2 / 3), h / 2);
      this._rightArrowSprite.bitmap = this.windowskin;
      this._rightArrowSprite.anchor.x = 0.5;
      this._rightArrowSprite.anchor.y = 0.5;
      this._rightArrowSprite.setFrame(sx + p + q, sy + q, q, p);
      // アニメーションのために初期位置を内側に設定
      // ウィンドウの実態を横に伸ばしているためその補正
      this._rightArrowSprite.move(w - q / 2 - offsetX, h / 2);
      // this._rightArrowSprite.move(w - q / 2 - offsetX * (2 / 3), h / 2);

      this._downArrowSprite.y = h;
      this._upArrowSprite.y = 0;
   };

   const Window_MenuList_updateArrows = Window_MenuList.prototype.updateArrows;
   Window_MenuList.prototype.updateArrows = function () {
      Window_MenuList_updateArrows.call(this);
      if (this._categories.length > 1) {
         this._leftArrowSprite.visible = true;
         this._rightArrowSprite.visible = true;
      } else {
         this._leftArrowSprite.visible = false;
         this._rightArrowSprite.visible = false;
      }
   };

   Window_MenuList.prototype.isEnable = function (index) {
      var item = this.item(index);
      if (!item) return false;
      // var id = 0;
      // if (item.SaveId > 0) {
      //    id = item.SaveId;
      // } else {
      //    id = item.CommonEvent;
      // }
      // return GlobalSaveManager.readValue(id);
      return this.isItemEnable(item);
   };

   Window_MenuList.prototype.isItemEnable = function (item) {
      if (!item) return false;
      let result = $gameSwitches.value(item.SaveId);
      // 2025/12/20 バッドエンド回想の時だけ全てをスイッチで無効にできるように変更
      // スイッチは8番固定
      if (SceneManager._scene.constructor.name === 'Scene_BadEnd' && $gameSwitches.value(8)) {
         result = false;
      }
      return result;
      // 2025/12/20 ここまで
   };

   Window_MenuList.prototype.select = function (index) {
      Window_Selectable.prototype.select.apply(this, arguments);
      this.updateContents();
   };

   Window_MenuList.prototype.updateContents = function () {
      var contents = this.item(this.index());
      if (!contents) return;
      if (this._titleWindow && (typeof contents.Name !== 'undefined')) {
         // 2025/03/25 タイトルからアイコンを削除
         this._titleWindow.setText(contents.Name.replace(/\\[iI]\[[0-9]+\]\s*/, ''));
         // 2025/03/25 ここまで
      }
      if (this._subTitleWindow && (typeof contents.SubTitle !== 'undefined')) this._subTitleWindow.setText(contents.SubTitle);
      if (this._textWindow && (typeof contents.Message !== 'undefined')) this._textWindow.setText(contents.Message);
      const sceneName = SceneManager._scene.constructor.name;
      const flag = (sceneName === 'Scene_BadEnd' && !this.isItemEnable(contents));
      if (this._thumbnail && (typeof contents.Thumbnail !== 'undefined')) this._thumbnail.bitmap = ImageManager.loadPicture(contents.Thumbnail + (flag ? 'b' : ''));
   };

   Window_MenuList.prototype.setTitleWindow = function (titleWindow) {
      this._titleWindow = titleWindow;
   };

   Window_MenuList.prototype.setSubTitleWindow = function (subTitleWindow) {
      this._subTitleWindow = subTitleWindow;
   };

   Window_MenuList.prototype.setTextWindow = function (textWindow) {
      this._textWindow = textWindow;
   };

   Window_MenuList.prototype.setThumbnale = function (sprite) {
      this._thumbnail = sprite;
   };

   // 2024/12/26 キャンセルが連続でできるバグの修正
   // Window_MenuList.prototype.deactivate = function () {

   //    this.reselect();
   // };
   // 2024/12/26 ここまで

   Window_MenuList.prototype.isCurrentItemEnabled = function () {
      return this.isEnable(this.index());
   };

   Window_MenuList.prototype.isCursorMovable = function () {
      if (this._categories.length > 1 && (Input.isRepeated("right") || Input.isRepeated("left"))) {
         return true;
      }
      return Window_Selectable.prototype.isCursorMovable.call(this);
   };

   // 2025/05/23 文字溢れ対策
   Window_MenuList.prototype.flushTextState = flushTextState;
   // 2025/05/23 ここまで




   /**
    * Window_MenuTitle
    */
   function Window_MenuTitle() {
      this.initialize.apply(this, arguments);
   }

   Window_MenuTitle.prototype = Object.create(Window_Help.prototype);
   Window_MenuTitle.prototype.constructor = Window_MenuTitle;

   const menuTitleFontRate = 1.5;
   Window_MenuTitle.prototype.initialize = function (pos, outlineColor) {
      // 2025/05/21 文字溢れ対策
      var width = this.fittingHeight(11);
      // 2025/05/21 ここまで
      var height = this.fittingHeight(1);
      var x = pos.x || 35; //this.lineHeight();
      var y = pos.y || 130; //this.lineHeight();
      this._outlineColor = outlineColor;
      // タイトルウィンドウの表示位置
      if (isMV()) {
         Window_Help.prototype.initialize.call(this, x, y, width, height);
      } else {
         Window_Help.prototype.initialize.call(this, new Rectangle(x, y, width, height));
      }
      this._text = '';
   };

   const Window_MenuTitle_resetFontSettings = Window_Help.prototype.resetFontSettings;
   Window_MenuTitle.prototype.resetFontSettings = function () {
      if (isMV()) {
         Window_MenuTitle_resetFontSettings.call(this);
      } else {
         this.contents.fontFace = $gameSystem.mainFontFace();
         this.contents.fontSize = $gameSystem.mainFontSize() * menuTitleFontRate;
         this.resetTextColor();
      }
   };

   Window_MenuTitle.prototype.standardFontSize = function () {
      return Window_Help.prototype.standardFontSize.call(this) * menuTitleFontRate;
   };

   Window_MenuTitle.prototype.lineHeight = function () {
      return $gameSystem.mainFontSize() * menuTitleFontRate + this.itemPadding() * 2;
   };

   Window_MenuTitle.prototype.calcTextHeight = function (textState) {
      const lineSpacing = this.lineHeight() - $gameSystem.mainFontSize() * menuTitleFontRate;
      const lastFontSize = this.contents.fontSize;
      const lines = textState.text.slice(textState.index).split("\n");
      const textHeight = this.maxFontSizeInLine(lines[0]) + lineSpacing;
      this.contents.fontSize = lastFontSize;
      return textHeight;
   };

   Window_MenuTitle.prototype.changeOutlineColorAuto = function () {
      this.changeOutlineColor(this._outlineColor);
   };

   // 2025/05/23 文字溢れ対策
   Window_MenuTitle.prototype.flushTextState = flushTextState;
   // 2025/05/23 ここまで

   // Window_MenuTitle.prototype.standardPadding = function () {
   //    return 0;
   // };

   // // ウィンドウの枠を非表示
   // Window_MenuTitle.prototype._refreshFrame = function () { };




   /**
    * Window_MenuSubTitle
    */
   function Window_MenuSubTitle() {
      this.initialize.apply(this, arguments);
   }

   Window_MenuSubTitle.prototype = Object.create(Window_Help.prototype);
   Window_MenuSubTitle.prototype.constructor = Window_MenuSubTitle;

   Window_MenuSubTitle.prototype.initialize = function (pos, outlineColor) {
      // 2025/05/21 文字溢れ対策
      var width = this.fittingHeight(15);
      // 2025/05/21 ここまで
      var height = this.fittingHeight(1);
      var x = pos.x || 100;
      var y = pos.y || 210;
      this._outlineColor = outlineColor;
      // サブタイトルウィンドウの表示位置
      if (isMV()) {
         Window_Help.prototype.initialize.call(this, x, y, width, height);
      } else {
         Window_Help.prototype.initialize.call(this, new Rectangle(x, y, width, height));
      }
      this._text = '';
   };

   Window_MenuSubTitle.prototype.changeOutlineColorAuto = function () {
      this.changeOutlineColor(this._outlineColor);
   };

   // 2025/05/23 文字溢れ対策
   Window_MenuSubTitle.prototype.flushTextState = flushTextState;
   // 2025/05/23 ここまで

   // const Window_MenuSubTitle_resetFontSettings = Window_Base.prototype.resetFontSettings;
   // Window_MenuTitle.prototype.resetFontSettings = function () {
   //    if (isMV()) {
   //       Window_MenuSubTitle_resetFontSettings.call(this);
   //    } else {
   //       this.contents.fontFace = $gameSystem.mainFontFace();
   //       this.contents.fontSize = $gameSystem.mainFontSize() * 1.5;
   //       this.resetTextColor();
   //    }
   // };

   // Window_MenuSubTitle.prototype.standardFontSize = function () {
   //    return Window_Base.prototype.standardFontSize.call(this) * 1.5;
   // };

   // Window_MenuSubTitle.prototype.standardPadding = function () {
   //    return 0;
   // };

   // // ウィンドウの枠を非表示
   // Window_MenuSubTitle.prototype._refreshFrame = function () { };




   /**
    * Window_MenuText
    */

   function Window_MenuText() {
      this.initialize.apply(this, arguments);
   }

   Window_MenuText.prototype = Object.create(Window_Help.prototype);
   Window_MenuText.prototype.constructor = Window_MenuText;

   Window_MenuText.prototype.initialize = function (pos, outlineColor) {
      var width = this.fittingHeight(17);
      var height = this.fittingHeight(15);
      // テキストウィンドウの表示位置
      var x = pos.x || 27;
      var y = pos.y || 365;
      this._outlineColor = outlineColor;
      if (isMV()) {
         Window_Help.prototype.initialize.call(this, x, y, width, height);
      } else {
         Window_Help.prototype.initialize.call(this, new Rectangle(x, y, width, height));
      }
      this._text = '';
      this.changeOutlineColor(outlineColor);
   };

   Window_MenuText.prototype.changeOutlineColorAuto = function () {
      this.changeOutlineColor(this._outlineColor);
   };


   // 2025/05/23 文字溢れ対策
   Window_MenuText.prototype.flushTextState = flushTextState;
   // 2025/05/23 ここまで

})(this);
