/*:
 * @target MZ
 * @plugindesc Fix choice window position to left side
 * @author YourName
 *
 * @param positionType
 * @text Position Type
 * @type select
 * @option Top Left
 * @value top
 * @option Middle Left
 * @value middle
 * @option Bottom Left
 * @value bottom
 * @default bottom
 * @desc Select the position of the choice window.
 *
 * @param offsetX
 * @text X Offset
 * @type number
 * @min 0
 * @max 500
 * @default 0
 * @desc Adjust X position of choice window. (from left)
 *
 * @param offsetY
 * @text Y Offset
 * @type number
 * @min -500
 * @max 500
 * @default 0
 * @desc Adjust Y position of choice window. (positive: down, negative: up)
 *
 * @help
 * ============================================================================
 * Features
 * - Fixes all choice windows to the left side.
 * - Ignores event command window position settings.
 * - Fine-tune position with parameters.
 * ============================================================================
 */

(function() {
    'use strict';
    
    const pluginName = "ChoicePositionFix";
    const params = PluginManager.parameters(pluginName);
    const positionType = String(params['positionType'] || 'bottom');
    const offsetX = Number(params['offsetX'] || 0);
    const offsetY = Number(params['offsetY'] || 0);
    
    const _Window_ChoiceList_updatePlacement = Window_ChoiceList.prototype.updatePlacement;
    Window_ChoiceList.prototype.updatePlacement = function() {
        _Window_ChoiceList_updatePlacement.call(this);
        
        this.x = offsetX;
        
        switch(positionType) {
            case 'top':
                this.y = 0 + offsetY;
                break;
            case 'middle':
                this.y = (Graphics.boxHeight - this.height) / 2 + offsetY;
                break;
            case 'bottom':
            default:
                this.y = Graphics.boxHeight - this.height + offsetY;
                break;
        }
    };
})();