//=============================================================================
// ItemNameEscapeCharacters.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc アイテム名に制御文字(\I[]など)を使用可能にします
 * @author Claude
 *
 * @help ItemNameEscapeCharacters.js
 *
 * このプラグインを使用すると、データベースのアイテム、武器、防具の名前に
 * 制御文字を使用できるようになります。
 *
 * 使用例:
 * \I[68]回復ポーション
 * \I[1]鋼の剣
 * \C[2]レアアイテム\C[0]
 *
 * プラグインコマンドはありません。
 */

(() => {
    'use strict';

    // Window_BaseのdrawItemNameをオーバーライド
    const _Window_Base_drawItemName = Window_Base.prototype.drawItemName;
    Window_Base.prototype.drawItemName = function(item, x, y, width) {
        if (item) {
            const iconY = y + (this.lineHeight() - ImageManager.iconHeight) / 2;
            const textMargin = ImageManager.iconWidth + 4;
            const itemWidth = width - textMargin;
            
            this.resetTextColor();
            
            // データベースのアイコンを描画
            this.drawIcon(item.iconIndex, x, iconY);
            
            // アイテム名（制御文字含む）を描画
            this.drawTextEx(item.name, x + textMargin, y, itemWidth);
        }
    };

    // Window_ItemListのdrawItemも修正
    const _Window_ItemList_drawItem = Window_ItemList.prototype.drawItem;
    Window_ItemList.prototype.drawItem = function(index) {
        const item = this.itemAt(index);
        if (item) {
            const rect = this.itemLineRect(index);
            this.changePaintOpacity(this.isEnabled(item));
            this.drawItemName(item, rect.x, rect.y, rect.width);
            this.drawItemNumber(item, rect.x, rect.y, rect.width);
            this.changePaintOpacity(1);
        }
    };

})();