//=============================================================================
// OnevASSISTANT.js
// RPGツクールMZ用ゲーム作成支援プラグイン
//=============================================================================

/*:
 * @target MZ
 * @plugindesc ゲーム作成支援プラグイン 
 * @author Onmoremind
 *
 * @param TitleSettings
 * @text タイトル設定
 * @type struct<TitleSettings>
 * @desc タイトル画面に関する設定
 *
 * @param UIConfigs
 * @text UI設定リスト
 * @type struct<UIConfig>[]
 * @desc 呼び出し可能な独自UIの設定一覧
 *
 * @param ADMINSettings
 * @text 呼出しコモンイベント管理
 * @type struct<ADMINSettings>
 * @desc イベントの呼出し管理設定
 *
 * @param CgGroupConfig
 * @text CG設定
 * @type struct<CgGroup>
 * @desc CG変遷設定
 *
 * @param BackgroundSettings
 * @text 背景設定
 * @type struct<BackgroundSettings>
 * @desc 背景の切り替えや表示に関する設定
 * 
 * @param FadeTimeVariableId
 * @text フェード時間変数ID
 * @type variable
 * @desc ここで指定した変数の値をフェード系のフレーム数として共有使用
 * @default 0
 * 
 * @param RecollectionSettings
 * @text 回想シーン設定
 * @type struct<RecollectionSettings>
 * @desc 回想シーンに関する設定
 *
 * @param ChatLogSettings
 * @text チャットログ設定
 * @type struct<ChatLogSettings>
 * @desc チャットログ表示に関する各種設定
 *
 * @param OptionCommands
 * @text オプション項目設定
 * @type struct<OptionCommandSet>
 * @desc 各オプション項目の初期値と表示可否のセット
 *
 * @param EnabledSizes
 * @text 有効サイズリスト
 * @type number[]
 * @default ["0", "1", "2", "3", "4"]
 * @desc オプション画面で選択可能な画面サイズの番号リスト
 *
 * @param disablePointer
 * @text ポインタを無効化
 * @type boolean
 * @default true
 * @desc true の場合、タップによる移動先の点滅のONOFF
 * 
 * @param MoveSwitch
 * @text 移動禁止スイッチ
 * @desc 移動を制御するためのスイッチ
 * @type switch
 * @default 10
 * 
 * @param Presets
 * @text フキダシプリセット一覧
 * @type struct<Preset>[]
 * @default []
 * @desc 設定を保存して名前で呼出可
 * 
 * @help
 * スクリプトコマンド:
 *   OnevASSISTANT.saveCurrentBgm();         回想シーンに入る前のBGMを保存
 *   OnevASSISTANT.resetLastClickedChoice(); 最後にクリックした選択肢をリセット
 *   changeWindowSize(n)                 サイズを対応した番号に変更
 *   toggleFullScreen()                  フルスクリーン状態をトグルで切り替える
 *
 * サイズ番号一覧:
 *   0 : 816  * 624
 *   1 : 1024 * 576
 *   2 : 1280 * 720
 *   3 : 1600 * 900
 *   4 : 1920 * 1080
 * 
 * イージングパターンは以下のサイトを参照してください。
 * http://easings.net/ja
 * 
 * 
 *
 * 利用規約：
 *  プラグイン作者に無断で使用、改変、再配布は不可。
 *
 * @command UI操作
 * @text UI操作
 * @desc UIを表示または消去
 *
 * @arg action
 * @text 操作
 * @type select
 * @option 表示
 * @option 消去
 * @option 全消去
 * @option 全非表示
 * @option 再表示
 * @default 表示
 *
 * @arg name
 * @text UI名
 * @desc 表示するUIの名前
 * @type string
 *
 * @command CustomCommonEvent
 * @text カスタムコモンイベント
 * @desc 指定したコモンイベントを呼出
 *
 * @arg name
 * @text カスタム名
 * @type string
 * @desc イベントトリガーのカスタム名
 *
 * @command CharacterAppearance
 * @text キャラクター出現
 * @desc キャラを出現
 *
 * @arg mode
 * @text 出現方法
 * @type select
 * @option 通常出現
 * @option 右から登場
 * @option 左から登場
 * @option 下から登場
 * @option 上から登場
 * @desc キャラをどう出現させるかを選択
 *
 * @arg name
 * @text キャラ識別名
 * @type string
 *
 * @arg layers
 * @text レイヤー構成
 * @type struct<LayerItem>[]
 * @desc レイヤー名・画像・優先度のリスト 
 *
 * @arg pictureId
 * @text ピクチャID
 * @type number
 * @default 20
 *
 * @arg scale
 * @text 拡大率(%)
 * @type number
 * @min 1
 * @max 400
 * @default 100
 *
 * @arg useVariable
 * @text 座標を変数IDで指定
 * @type boolean
 * @default false
 *
 * @arg x
 * @text X座標
 * @type number
 * @default 0
 * @desc 座標を変数IDで指定した場合は変数IDを指定
 *
 * @arg y
 * @text Y座標
 * @type number
 * @default 0
 * @desc 座標を変数IDで指定した場合は変数IDを指定
 *
 * @arg fade
 * @text フェード時間(frame)
 * @type number
 * @default 
 * 
 * @arg flip
 * @text 左右反転
 * @type boolean
 * @default false
 * @desc キャラクター画像を左右反転させるかどうか
 *
 * @arg easing
 * @text イージング種別
 * @type select
 * @option Linear（一定速度） @value linear
 * @option QuadIn（加速・緩やかな始まり） @value easeInQuad
 * @option QuadOut（減速・穏やかな終わり） @value easeOutQuad
 * @option QuadInOut（加速と減速） @value easeInOutQuad
 * @option CubicIn（強めの加速） @value easeInCubic
 * @option CubicOut（強めの減速） @value easeOutCubic
 * @option CubicInOut（滑らかな加減速） @value easeInOutCubic
 * @option QuartIn（急激な加速） @value easeInQuart
 * @option QuartOut（急激な減速） @value easeOutQuart
 * @option QuartInOut（急加減速） @value easeInOutQuart
 * @option QuintIn（非常に急な加速） @value easeInQuint
 * @option QuintOut（非常に急な減速） @value easeOutQuint
 * @option QuintInOut（激しい加減速） @value easeInOutQuint
 * @option SineIn（なめらかな始まり） @value easeInSine
 * @option SineOut（なめらかな終わり） @value easeOutSine
 * @option SineInOut（なめらかな加減速） @value easeInOutSine
 * @option ExpoIn（急激に速くなる） @value easeInExpo
 * @option ExpoOut（急激に遅くなる） @value easeOutExpo
 * @option ExpoInOut（極端な加減速） @value easeInOutExpo
 * @option CircIn（円弧のような加速） @value easeInCirc
 * @option CircOut（円弧のような減速） @value easeOutCirc
 * @option CircInOut（円弧的な加減速） @value easeInOutCirc
 * @option BackIn（少し戻ってから加速） @value easeInBack
 * @option BackOut（終わりに少し戻る） @value easeOutBack
 * @option BackInOut（前後に跳ねるような動き） @value easeInOutBack
 * @option ElasticIn（バネのように跳ねて加速） @value easeInElastic
 * @option ElasticOut（バネのように跳ねて減速） @value easeOutElastic
 * @option ElasticInOut（バネのように前後に跳ねる） @value easeInOutElastic
 * @option BounceIn（バウンドしながら加速） @value easeInBounce
 * @option BounceOut（バウンドしながら減速） @value easeOutBounce
 * @option BounceInOut（前後にバウンドする動き） @value easeInOutBounce
 * @default linear
 *
 * @command ChangeLayers
 * @text パーツ差し替え
 * @desc 指定したキャラのパーツ差替
 *
 * @arg name
 * @text キャラ識別名
 * @type string
 *
 * @arg layers
 * @text 差し替えレイヤー
 * @type struct<LayerPartItem>[]
 * @desc 置き換えたいレイヤーの配列
 *
 * @arg fade
 * @text フェード時間(frame)
 * @type number
 *
 * @command MoveCharacter
 * @text キャラ移動
 * @desc キャラクターを指定座標に移動させる
 *
 * @arg name
 * @text キャラ識別名
 * @desc 移動させるキャラクターの識別名
 * @type string
 *
 * @arg x
 * @text X座標
 * @desc 目標のX座標
 * @type number
 *
 * @arg y
 * @text Y座標
 * @desc 目標のY座標
 * @type number
 *
 * @arg scale
 * @text 拡大率(%)
 * @type number
 * @min 1
 * @max 400
 * @default 100
 *
 * @arg duration
 * @text 移動時間
 * @desc 移動にかけるフレーム数
 * @type number
 * @default 30
 *
 * @arg easing
 * @type select
 * @text イージング種別
 * @option Linear（一定速度） @value linear
 * @option QuadIn（加速・緩やかな始まり） @value easeInQuad
 * @option QuadOut（減速・穏やかな終わり） @value easeOutQuad
 * @option QuadInOut（加速と減速） @value easeInOutQuad
 * @option CubicIn（強めの加速） @value easeInCubic
 * @option CubicOut（強めの減速） @value easeOutCubic
 * @option CubicInOut（滑らかな加減速） @value easeInOutCubic
 * @option QuartIn（急激な加速） @value easeInQuart
 * @option QuartOut（急激な減速） @value easeOutQuart
 * @option QuartInOut（急加減速） @value easeInOutQuart
 * @option QuintIn（非常に急な加速） @value easeInQuint
 * @option QuintOut（非常に急な減速） @value easeOutQuint
 * @option QuintInOut（激しい加減速） @value easeInOutQuint
 * @option SineIn（なめらかな始まり） @value easeInSine
 * @option SineOut（なめらかな終わり） @value easeOutSine
 * @option SineInOut（なめらかな加減速） @value easeInOutSine
 * @option ExpoIn（急激に速くなる） @value easeInExpo
 * @option ExpoOut（急激に遅くなる） @value easeOutExpo
 * @option ExpoInOut（極端な加減速） @value easeInOutExpo
 * @option CircIn（円弧のような加速） @value easeInCirc
 * @option CircOut（円弧のような減速） @value easeOutCirc
 * @option CircInOut（円弧的な加減速） @value easeInOutCirc
 * @option BackIn（少し戻ってから加速） @value easeInBack
 * @option BackOut（終わりに少し戻る） @value easeOutBack
 * @option BackInOut（前後に跳ねるような動き） @value easeInOutBack
 * @option ElasticIn（バネのように跳ねて加速） @value easeInElastic
 * @option ElasticOut（バネのように跳ねて減速） @value easeOutElastic
 * @option ElasticInOut（バネのように前後に跳ねる） @value easeInOutElastic
 * @option BounceIn（バウンドしながら加速） @value easeInBounce
 * @option BounceOut（バウンドしながら減速） @value easeOutBounce
 * @option BounceInOut（前後にバウンドする動き） @value easeInOutBounce
 * @default linear
 *
 * @command モーション
 * @text キャラモーション実行
 * @desc モーションを適用
 *
 * @arg name
 * @type string
 * @text キャラ識別名
 *
 * @arg motion
 * @type select
 * @text モーション名
 * @option うなずく
 * @option 二回うなずく
 * @option 否定
 * @option ジャンプ
 * @option 笑う
 * @option 怒る
 * @desc 実行するモーションの種類
 *
 * @arg duration
 * @type number
 * @default 24
 * @text モーション時間
 *
 * @arg amplitude
 * @type number
 * @default 0
 * @text 動作の大きさ（振れ幅）
 * @desc モーションの強さ
 *
 * @arg easing
 * @type select
 * @text イージング種別
 * @option Linear（一定速度） @value linear
 * @option QuadIn（加速・緩やかな始まり） @value easeInQuad
 * @option QuadOut（減速・穏やかな終わり） @value easeOutQuad
 * @option QuadInOut（加速と減速） @value easeInOutQuad
 * @option CubicIn（強めの加速） @value easeInCubic
 * @option CubicOut（強めの減速） @value easeOutCubic
 * @option CubicInOut（滑らかな加減速） @value easeInOutCubic
 * @option QuartIn（急激な加速） @value easeInQuart
 * @option QuartOut（急激な減速） @value easeOutQuart
 * @option QuartInOut（急加減速） @value easeInOutQuart
 * @option QuintIn（非常に急な加速） @value easeInQuint
 * @option QuintOut（非常に急な減速） @value easeOutQuint
 * @option QuintInOut（激しい加減速） @value easeInOutQuint
 * @option SineIn（なめらかな始まり） @value easeInSine
 * @option SineOut（なめらかな終わり） @value easeOutSine
 * @option SineInOut（なめらかな加減速） @value easeInOutSine
 * @option ExpoIn（急激に速くなる） @value easeInExpo
 * @option ExpoOut（急激に遅くなる） @value easeOutExpo
 * @option ExpoInOut（極端な加減速） @value easeInOutExpo
 * @option CircIn（円弧のような加速） @value easeInCirc
 * @option CircOut（円弧のような減速） @value easeOutCirc
 * @option CircInOut（円弧的な加減速） @value easeInOutCirc
 * @option BackIn（少し戻ってから加速） @value easeInBack
 * @option BackOut（終わりに少し戻る） @value easeOutBack
 * @option BackInOut（前後に跳ねるような動き） @value easeInOutBack
 * @option ElasticIn（バネのように跳ねて加速） @value easeInElastic
 * @option ElasticOut（バネのように跳ねて減速） @value easeOutElastic
 * @option ElasticInOut（バネのように前後に跳ねる） @value easeInOutElastic
 * @option BounceIn（バウンドしながら加速） @value easeInBounce
 * @option BounceOut（バウンドしながら減速） @value easeOutBounce
 * @option BounceInOut（前後にバウンドする動き） @value easeInOutBounce
 * @default linear
 * @desc モーションの速度変化の種類を選択してください。
 *
 * @command CharacterExit
 * @text キャラクター退場
 * @desc キャラクターを退場させる
 *
 * @arg mode
 * @text 退場方法
 * @type select
 * @option 通常退場
 * @option 右に消える
 * @option 左に消える
 * @option 上に消える
 * @option 下に消える
 *
 * @arg name
 * @text キャラ識別名
 * @type string
 *
 * @arg duration
 * @text 退場時間
 * @type number
 * @default 30
 *
 * @arg easing
 * @text イージング種別
 * @type select
 * @option Linear（一定速度） @value linear
 * @option QuadIn（加速・緩やかな始まり） @value easeInQuad
 * @option QuadOut（減速・穏やかな終わり） @value easeOutQuad
 * @option QuadInOut（加速と減速） @value easeInOutQuad
 * @option CubicIn（強めの加速） @value easeInCubic
 * @option CubicOut（強めの減速） @value easeOutCubic
 * @option CubicInOut（滑らかな加減速） @value easeInOutCubic
 * @option QuartIn（急激な加速） @value easeInQuart
 * @option QuartOut（急激な減速） @value easeOutQuart
 * @option QuartInOut（急加減速） @value easeInOutQuart
 * @option QuintIn（非常に急な加速） @value easeInQuint
 * @option QuintOut（非常に急な減速） @value easeOutQuint
 * @option QuintInOut（激しい加減速） @value easeInOutQuint
 * @option SineIn（なめらかな始まり） @value easeInSine
 * @option SineOut（なめらかな終わり） @value easeOutSine
 * @option SineInOut（なめらかな加減速） @value easeInOutSine
 * @option ExpoIn（急激に速くなる） @value easeInExpo
 * @option ExpoOut（急激に遅くなる） @value easeOutExpo
 * @option ExpoInOut（極端な加減速） @value easeInOutExpo
 * @option CircIn（円弧のような加速） @value easeInCirc
 * @option CircOut（円弧のような減速） @value easeOutCirc
 * @option CircInOut（円弧的な加減速） @value easeInOutCirc
 * @option BackIn（少し戻ってから加速） @value easeInBack
 * @option BackOut（終わりに少し戻る） @value easeOutBack
 * @option BackInOut（前後に跳ねるような動き） @value easeInOutBack
 * @option ElasticIn（バネのように跳ねて加速） @value easeInElastic
 * @option ElasticOut（バネのように跳ねて減速） @value easeOutElastic
 * @option ElasticInOut（バネのように前後に跳ねる） @value easeInOutElastic
 * @option BounceIn（バウンドしながら加速） @value easeInBounce
 * @option BounceOut（バウンドしながら減速） @value easeOutBounce
 * @option BounceInOut（前後にバウンドする動き） @value easeInOutBounce
 * @default linear
 *
 * @command CG処理
 * @text CG処理
 * @desc 呼出、進行、消去を選択
 *
 * @arg mode
 * @text モード
 * @type select
 * @option 呼出
 * @option 進行
 * @option 消去
 * @desc 実行したい操作を選択
 * @default 呼出
 *
 * @arg label
 * @text シーン名
 * @type string
 * @desc パラメーターで指定したシーン名
 * @default
 *
 * @arg index
 * @text 進行番号
 * @type number
 * @min 0
 * @desc 省略で順送り
 * @default
 *
 * @arg ruleImage
 * @text ルール画像
 * @type file
 * @dir img/system
 * @desc クランジション用ルール画像指定（省略可）
 * @default
 *
 * @command ピクチャにマスク適用
 * @text ピクチャにマスク適用
 * @desc 指定したピクチャIDにマスク画像を適用
 *
 * @arg pictureId
 * @text ピクチャID
 * @type number
 * @min 1
 * @desc マスクを適用したいピクチャID
 *
 * @arg maskPictureId
 * @text マスクピクチャID
 * @type number
 * @min 1
 * @desc マスク画像を表示するピクチャID
 *
 * @arg maskImage
 * @text マスク画像
 * @type file
 * @dir img/pictures/
 *
 * @command setImageChoices
 * @text 画像選択肢設定
 * @desc struct<Choicecommand>[] を使って選択肢を登録します
 *
 * @arg choices
 * @type struct<Choicecommand>[]
 * @text 選択肢リスト
 * @desc 画像と選択肢名のセットを配列で入力
 *
 * @command リング選択肢
 * @text リング選択肢
 * @desc 土台画像と選択肢画像を円配置で表示
 *
 * @arg 仮想選択肢数
 * @text 仮想選択肢数
 * @type number
 * @min 0
 * @max 999
 * @default 0
 * @desc 円運動の分割数
 *
 * @arg 一周回転
 * @text 一周回転
 * @type boolean
 * @default true
 * @desc 選択肢を一周回転させるかどうか
 *
 * @arg 変数で指定
 * @text 変数で指定
 * @type boolean
 * @default false
 * @desc 座標を変数から取得するかどうか
 *
 * @arg X軸
 * @text X軸
 * @type number
 * @default 0
 * @desc 中心のX座標
 *
 * @arg Y軸
 * @text Y軸
 * @type number
 * @default 0
 * @desc 中心のY座標
 *
 * @arg 土台画像
 * @text 土台画像
 * @type file
 * @dir img/choice/
 * @desc 背景に表示する土台画像
 *
 * @arg 選択肢リスト
 * @text 選択肢リスト
 * @type struct<RingChoice>[]
 * @desc 画像とコモンイベントをセットで登録
 *
 * @arg リング選択肢オフセットX
 * @text リング選択肢オフセットX
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc 土台画像の中心からのXオフセット
 *
 * @arg リング選択肢オフセットY
 * @text リング選択肢オフセットY
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc 土台画像の中心からのYオフセット
 * 
 * @arg 選択音
 * @text 選択音
 * @type struct<CursorSelectSe>
 * @desc カーソル移動時に再生する効果音
 *
 * @arg 決定音
 * @text 決定音
 * @type struct<CursorOkSe>
 * @desc 決定時に再生する効果音
 *
 * @arg 初期選択インデックス変数
 * @text 初期選択インデックス変数
 * @type variable
 * @desc 最初に選択状態にする画像のインデックスを格納した変数番号
 * @default 0
 *
 * @arg 初期角度
 * @text 初期角度
 * @type number
 * @default 0
 * @desc 円配置の開始角度（度数、0=右、90=下、180=左、270=上）
 *
 * @arg 円の大きさ
 * @text 円の大きさ
 * @type number
 * @default 100
 * @desc 選択肢を配置する円の半径
 *
 * @arg イージングタイプ
 * @text イージングタイプ
 * @type select
 * @option Linear（一定速度） @value linear
 * @option QuadIn（加速・緩やかな始まり） @value easeInQuad
 * @option QuadOut（減速・穏やかな終わり） @value easeOutQuad
 * @option QuadInOut（加速と減速） @value easeInOutQuad
 * @option CubicIn（強めの加速） @value easeInCubic
 * @option CubicOut（強めの減速） @value easeOutCubic
 * @option CubicInOut（滑らかな加減速） @value easeInOutCubic
 * @option QuartIn（急激な加速） @value easeInQuart
 * @option QuartOut（急激な減速） @value easeOutQuart
 * @option QuartInOut（急加減速） @value easeInOutQuart
 * @option QuintIn（非常に急な加速） @value easeInQuint
 * @option QuintOut（非常に急な減速） @value easeOutQuint
 * @option QuintInOut（激しい加減速） @value easeInOutQuint
 * @option SineIn（なめらかな始まり） @value easeInSine
 * @option SineOut（なめらかな終わり） @value easeOutSine
 * @option SineInOut（なめらかな加減速） @value easeInOutSine
 * @option ExpoIn（急激に速くなる） @value easeInExpo
 * @option ExpoOut（急激に遅くなる） @value easeOutExpo
 * @option ExpoInOut（極端な加減速） @value easeInOutExpo
 * @option CircIn（円弧のような加速） @value easeInCirc
 * @option CircOut（円弧のような減速） @value easeOutCirc
 * @option CircInOut（円弧的な加減速） @value easeInOutCirc
 * @option BackIn（少し戻ってから加速） @value easeInBack
 * @option BackOut（終わりに少し戻る） @value easeOutBack
 * @option BackInOut（前後に跳ねるような動き） @value easeInOutBack
 * @option ElasticIn（バネのように跳ねて加速） @value easeInElastic
 * @option ElasticOut（バネのように跳ねて減速） @value easeOutElastic
 * @option ElasticInOut（バネのように前後に跳ねる） @value easeInOutElastic
 * @option BounceIn（バウンドしながら加速） @value easeInBounce
 * @option BounceOut（バウンドしながら減速） @value easeOutBounce
 * @option BounceInOut（前後にバウンドする動き） @value easeInOutBounce
 * @default easeOutQuad
 * @desc 移動アニメーションの速度変化の種類
 *
 * @arg 移動時間
 * @text 移動時間
 * @type number
 * @default 24
 * @desc 移動アニメーションにかけるフレーム数
 *
 * @arg 拡大表示
 * @text 拡大表示
 * @type boolean
 * @default true
 * @desc 選択中の画像を拡大表示するかどうか
 *
 * @arg キャンセル動作
 * @text キャンセル動作
 * @type select
 * @option 終了
 * @option index0に戻る
 * @default 終了
 * @desc キャンセルキーを押した時の動作
 *
 * @arg マスク画像
 * @text マスク画像
 * @type file
 * @dir img/choice/
 * @desc 表示範囲を制限するマスク画像
 *
 * @command CallRecollection
 * @text 回想呼出し
 * @desc 回想シーン呼出し
 *
 * @command 背景処理
 * @text 背景処理
 * @desc 背景の変遷を管理
 *
 * @arg mode
 * @text モード
 * @type select
 * @option 背景呼出
 * @option 背景変更
 * @option 時間経過
 * @option 背景消去
 * @desc 背景処理選択
 *
 * @arg place
 * @text 場所名
 * @type string
 * @desc 呼出しに使用する名前
 * @default
 *
 * @arg time
 * @text 時間帯
 * @type select
 * @option 朝
 * @option 夕方
 * @option 夜
 * @option なし
 * @desc 時間帯を選択。
 * @default なし
 *
 * @arg ruleImage
 * @text ルール画像（任意）
 * @type file
 * @dir img/system
 * @desc 背景トランジションに使用するルール画像
 * @default
 *
 * @arg duration
 * @text 変遷フレーム数
 * @type number
 * @min 1
 * @max 999
 * @desc 完了するまでのフレーム数
 * @default 60
 * 
 * @command 背景フィルター制御
 * @text 背景フィルター制御
 * @desc フィルターをかけるか解除するかを選択
 *
 * @arg action
 * @text 操作
 * @type select
 * @option 適用
 * @option 解除
 * @default 適用
 * @desc フィルターを適用するか解除するかを選択
 *
 * @arg color
 * @text フィルター色
 * @type string
 * @default #000000
 * @desc カラーコードで指定
 *       フィルターの色を消す場合はresetかリセットを指定
 *
 * @arg opacity
 * @text 透明度
 * @type number
 * @min 0
 * @max 255
 * @default 128
 *
 * @command RuleFade
 * @text フェード機能
 *
 * @arg type
 * @text 処理タイプ
 * @type select
 * @option フェードアウト
 * @value out
 * @option フェードイン
 * @value in
 * @default out
 *
 * @arg ruleImage
 * @text ルール画像
 * @type file
 * @dir img/system
 * @default mask_Dissolve
 *
 * @arg duration
 * @text フェード時間
 * @type number
 * @min 1
 * @default 
 * @desc 空欄の場合、フェード時間変数IDで指定した変数の値を使用
 * 　　　　指定した場合はその値をフレーム数として使用
 *
 * @arg reverseDirection
 * @text 方向反転
 * @type boolean
 * @default false
 * @desc true でマスクの進行を左右反転

 *
 * @command SET_FADE_COLOR
 * @text フェードカラー設定
 * @desc フェードで使うカラーを設定
 *
 * @arg color
 * @text フェードカラー
 * @type string
 * @default #
 * @desc #000000,
 *
 * @command CLEAR_FADE_COLOR
 * @text フェードカラー解除
 * @desc カラー指定を黒に戻す
 * 
 * @command crossFadeBgm
 * @text クロスフェードBGM 
 * @desc 指定したBGMと現在のBGMをクロスフェードで切り替え
 *
 * @arg name
 * @text BGM名
 * @desc 再生するBGMのファイル名
 * @type file
 * @dir audio/bgm
 *
 * @arg volume
 * @text 音量
 * @desc 再生するBGMの音量
 * @type number
 * @min 0
 * @max 100
 * @default 90
 *
 * @arg pitch
 * @text ピッチ
 * @desc 再生するBGMのピッチ
 * @type number
 * @min 50
 * @max 150
 * @default 100
 *
 * @arg pan
 * @text 位相
 * @desc 再生するBGMの左右バランス
 * @type number
 * @min -100
 * @max 100
 * @default 0
 *
 * @arg fadeTime
 * @text フェード時間
 * @type number
 * @default 2000
 * 
 * @command ChatLog
 * @text ログ
 * @desc チャットログ操作
 *
 * @arg action
 * @text 処理内容
 * @type select
 * @option 左にログを追加
 * @option 右にログを追加
 * @option ログをクリア
 * @default 左にログを追加
 *
 * @arg message
 * @text 表示メッセージ
 * @desc 表示するテキスト（ログ追加時のみ有効）
 * @type string
 * @default
 *
 * @command ChatStamp
 * @text スタンプ
 * @desc チャットログにスタンプを追加
 *
 * @arg side
 * @text 表示位置
 * @desc スタンプを表示する位置
 * @type select
 * @option 左
 * @option 右
 * @default 左
 *
 * @arg stampName
 * @text スタンプ画像名
 * @desc 使用するピクチャ
 * @type file
 * @dir img/pictures
 *
 * @arg width
 * @text 幅
 * @desc スタンプの表示幅
 * @type number
 * @default 0
 * @min 0
 *
 * @arg height
 * @text 高さ
 * @desc スタンプの表示高さ
 * @type number
 * @default 0
 * @min 0
 * 
 * @arg commonEventId
 * @text コモンイベントID
 * @desc クリックで呼び出すコモンイベント
 * @type common_event
 * @default 0
 *
 * @command ChatWindow
 * @text チャットウィンドウ設定
 * @desc チャットログウィンドウの位置やサイズ、不透明度を変更
 *
 * @arg x
 * @text X座標
 * @type number
 * @default 0
 *
 * @arg y
 * @text Y座標
 * @type number
 * @default 0
 *
 * @arg width
 * @text 幅
 * @type number
 * @default 480
 *
 * @arg height
 * @text 高さ
 * @type number
 * @default 216
 *
 * @arg opacity
 * @text 不透明度
 * @desc 0で完全透明、255で不透明
 * @type number
 * @default 255
 * @max 255
 * @min 0
 * 
 * @command show
 * @text フキダシ表示
 * @desc 独自ウィンドウを生成、文章の表示と同じ使い方が可能
 * @arg id
 * @type number 
 * @min 1 
 * @default 1
 * 
 * @arg text
 * @text 文章
 * @type note 
 * @default
 * 
 * @arg x
 * @type number 
 * @default 0
 * 
 * @arg y
 * @type number 
 * @default 0
 * 
 * @arg anchorX
 * @text 基点
 * @type select
 * @option 左 
 * @value left
 * @option 中央 
 * @value center
 * @option 右 
 * @value right
 * @default left
 * 
 * @arg background
 * @text 背景
 * @type select
 * @option 通常 
 * @value window
 * @option 透明 
 * @value transparent
 * @default window
 * 
 * @arg opacity
 * @text ウィンドウ不透明度
 * @type number 
 * @min 0 
 * @max 255 
 * @default 255
 * 
 * @arg backOpacity
 * @text 背景不透明度
 * @type number 
 * @min 0 
 * @max 255 
 * @default 192
 * 
 * @arg padding
 * @text 余白
 * @desc -1でデフォルト設定
 * @type number 
 * @min -1 
 * @default -1
 * 
 * @arg fontSize
 * @text フォントサイズ
 * @desc 0の場合systemの値を使用
 * @type number 
 * @min 0 
 * @default 0
 * 
 * @arg fontColor
 * @text 文字色
 * @type string 
 * @default
 * @desc window.pngの番号色や#00000で指定
 * 
 * @arg outlineColor
 * @text アウトライン色
 * @type string 
 * @default
 * @desc 空白ならアウトライン無し
 * アウトライン使用の場合はwindow.pngの番号色や#00000で指定
 * 
 * @arg outlineWidth
 * @text アウトライン太さ
 * @type number
 * @min 0
 * @default 4
 * @desc 文章表示中のアウトライン太さ。\ow[値] で文中変更可
 * 
 * @arg windowskin
 * @text ウィンドウスキン
 * @type file 
 * @dir img/system/ 
 * @default
 * 
 * @arg waitInput
 * @text 入力待ちをする
 * @type boolean 
 * @on 待つ 
 * @off 待たない 
 * @default false
 * 
 * @arg closeOnConfirm
 * @text 入力後に閉じる
 * @type boolean 
 * @on 閉じる 
 * @off 閉じない 
 * @default false
 *
 * @arg tailImage
 * @text テール画像
 * @type file 
 * @dir img/system/ 
 * @default
 * 
 * @arg tailPosition
 * @text テール配置
 * @type select
 * @option なし 
 * @value none
 * @option 左上 
 * @value lt
 * @option 中央上 
 * @value ct
 * @option 右上 
 * @value rt
 * @option 左下 
 * @value lb
 * @option 中央下 
 * @value cb
 * @option 右下 
 * @value rb
 * @default none
 * 
 * @arg tailOffsetX
 * @text テールX補正
 * @type number 
 * @min -9999 
 * @max 9999 
 * @default 0
 * 
 * @arg tailOffsetY
 * @text テールY補正
 * @type number 
 * @min -9999 
 * @max 9999 
 * @default 0
 *
 * @command showPreset
 * @text フキダシプリセット
 * @desc プリセットの設定を使用
 * 
 * @arg id
 * @type number 
 * @min 1 
 * @default 1
 * 
 * @arg presetName
 * @text 使用設定名
 * @type string @default
 * 
 * @arg text
 * @text 文章
 * @type note 
 * @default
 * 
 * @arg waitInput
 * @text 入力待ちをする
 * @type boolean 
 * @on 待つ 
 * @off 待たない 
 * @default false
 * 
 * @arg closeOnConfirm
 * @text 入力後に閉じる
 * @type boolean 
 * @on 閉じる 
 * @off 閉じない 
 * @default false
 *
 * @command setText
 * @text 文章差し替え
 * @desc 指定したIDの文章差替
 * @arg id
 * @type number 
 * @min 1 
 * @default 1
 * @arg text
 * @type note 
 * @default
 * @arg waitInput
 * @text 入力待ち（イベントを止める）
 * @type boolean 
 * @on 待つ 
 * @off 待たない 
 * @default false
 * @arg closeOnConfirm
 * @text 入力後に閉じる
 * @type boolean 
 * @on 閉じる 
 * @off 閉じない 
 * @default false
 * 
 * @command close
 * @text 全フキダシ終了
 * @arg id
 * @type number 
 * @min -1 
 * @default -1
 * 
 * @command オノマトペ表示
 * @text オノマトペ表示
 * @desc カスタムオノマトペを表示
 *
 * @arg id
 * @text オノマトペID
 * @type string
 * @desc オノマトペの識別ID（空白の場合は自動生成）
 *
 * @arg image
 * @text 画像ファイル名
 * @type file
 * @dir img/pictures/
 * @desc オノマトペ画像
 *
 * @arg positionSettings
 * @text 座標設定
 * @type struct<PositionSettings>
 * @desc 開始・終了座標とランダム幅の設定
 * 開始座標から終了座標に向かって移動する
 *
 * @arg scaleSettings
 * @text 拡大率設定
 * @type struct<ScaleSettings>
 * @desc 拡大率に関する詳細設定
 *
 * @arg opacitySettings
 * @text 透明度設定
 * @type struct<OpacitySettings>
 * @desc 透明度に関する設定
 *
 * @arg animationSettings
 * @text アニメーション設定
 * @type struct<AnimationSettings>
 * @desc 時間・ループ・イージングに関する設定
 * 

 * @command オノマトペ表示(スプライトシート)
 * @text オノマトペ表示(スプライトシート)
 * @desc スプライトシート画像をコマ送り再生しながら移動/拡大/透明度アニメーションするオノマトペを表示
 *
 * @arg id
 * @text オノマトペID
 * @type string
 * @desc オノマトペの識別ID（空白の場合は自動生成）
 *
 * @arg image
 * @text 画像ファイル名（スプライトシート）
 * @type file
 * @dir img/pictures/
 * @desc フレームが格子状に並んだスプライトシート画像
 *
 * @arg sheetSettings
 * @text シート設定
 * @type struct<OnomatopoeiaSpriteSheetSettings>
 * @desc フレーム切替に関する設定（列/行/開始終了フレーム/間隔等）
 *
 * @arg positionSettings
 * @text 座標設定
 * @type struct<PositionSettings>
 * @desc 開始・終了座標とランダム幅の設定
 * 開始座標から終了座標に向かって移動する
 *
 * @arg scaleSettings
 * @text 拡大率設定
 * @type struct<ScaleSettings>
 * @desc 拡大率に関する詳細設定
 *
 * @arg opacitySettings
 * @text 透明度設定
 * @type struct<OpacitySettings>
 * @desc 透明度に関する設定
 *
 * @arg animationSettings
 * @text アニメーション設定
 * @type struct<AnimationSettings>
 * @desc 時間・ループ・イージングに関する設定
 *
 * @command オノマトペ削除
 * @text オノマトペ削除
 * @desc 表示中のオノマトペを削除
 *
 * @arg id
 * @text オノマトペID
 * @type string
 * @desc 削除するオノマトペのID（空白の場合は全削除）
 *
 */

/*~struct~PositionSettings:
 * @param startX
 * @text 開始座標X
 * @type number
 * @default 0
 * @desc イージング開始時のX座標
 *
 * @param startY
 * @text 開始座標Y
 * @type number
 * @default 0
 * @desc イージング開始時のY座標
 *
 * @param targetX
 * @text 終了座標X
 * @type number
 * @default 0
 * @desc イージング終了時のX座標
 *
 * @param targetY
 * @text 終了座標Y
 * @type number
 * @default 0
 * @desc イージング終了時のY座標
 *
 * @param rndX
 * @text 開始X座標ランダム加算幅
 * @type number
 * @default 0
 * @desc 開始時のX座標にランダムで加算する値の最大値
 * 例：100なら0～100内でランダム値を加算
 *
 * @param rndY
 * @text 開始Y座標ランダム加算幅
 * @type number
 * @default 0
 * @desc 開始時のY座標にランダムで加算する値の最大値
 * 例：100なら0～100内でランダム値を加算
 *
 * @param targetRndX
 * @text 終了X座標ランダム加算幅
 * @type number
 * @default 0
 * @desc 終了時のX座標にランダムで加算する値の最大値
 * 例：100なら0～100内でランダム値を加算
 *
 * @param targetRndY
 * @text 終了Y座標ランダム加算幅
 * @type number
 * @default 0
 * @desc 終了時のY座標にランダムで加算する値の最大値
 * 例：100なら0～100内でランダム値を加算
 *
 * @param rndOnLoop
 * @text ループ時のランダム値の再計算
 * @type boolean
 * @default true
 * @desc ループ時にランダム値を再計算するかどうか
 *
 * @param easingType
 * @text 座標イージングの種類
 * @type select
 * @default linear
 * @option linear
 * @option easeInQuad
 * @option easeOutQuad
 * @option easeInOutQuad
 * @option easeInCubic
 * @option easeOutCubic
 * @option easeInOutCubic
 * @option easeInQuart
 * @option easeOutQuart
 * @option easeInOutQuart
 * @option easeInQuint
 * @option easeOutQuint
 * @option easeInOutQuint
 * @option easeInSine
 * @option easeOutSine
 * @option easeInOutSine
 * @option easeInExpo
 * @option easeOutExpo
 * @option easeInOutExpo
 * @option easeInCirc
 * @option easeOutCirc
 * @option easeInOutCirc
 * @option easeInElastic
 * @option easeOutElastic
 * @option easeInOutElastic
 * @option easeInBack
 * @option easeOutBack
 * @option easeInOutBack
 * @option easeInBounce
 * @option easeOutBounce
 * @option easeInOutBounce
 * @desc 座標移動用のイージングの種類
 */

/*~struct~ScaleSettings:
 * @param startScale
 * @text 開始拡大率
 * @type number
 * @default 100
 * @desc イージング開始時の拡大率（%）
 ※がついたイージングの際、基準拡大率と同じ値にする
 *
 * @param targetScale
 * @text 終了拡大率
 * @type number
 * @default 100
 * @desc イージング終了時の拡大率（%）
 ※がついたイージングの際、基準拡大率と同じ値にする
 *
 * @param easingType
 * @text 拡大率イージングの種類
 * @type select
 * @default linear
 * @option linear
 * @option easeInQuad
 * @option easeOutQuad
 * @option easeInOutQuad
 * @option easeInCubic
 * @option easeOutCubic
 * @option easeInOutCubic
 * @option easeInQuart
 * @option easeOutQuart
 * @option easeInOutQuart
 * @option easeInQuint
 * @option easeOutQuint
 * @option easeInOutQuint
 * @option easeInSine
 * @option easeOutSine
 * @option easeInOutSine
 * @option easeInExpo
 * @option easeOutExpo
 * @option easeInOutExpo
 * @option easeInCirc
 * @option easeOutCirc
 * @option easeInOutCirc
 * @option easeInElastic※
 * @option easeOutElastic※
 * @option easeInOutElastic※
 * @option easeInBack※
 * @option easeOutBack※
 * @option easeInOutBack※
 * @option easeInBounce※
 * @option easeOutBounce※
 * @option easeInOutBounce※
 * @desc 拡大率専用のイージングの種類
 *
 * @param baseScale
 * @text 基準拡大率
 * @type number
 * @default 100
 * @desc イージングの基準となる拡大率（%）
 *
 * @param maxScale
 * @text 最大拡大率
 * @type number
 * @default 100
 * @desc ＊がついたイージングの最大（最小）拡大率（％）
 *
 * @param minScale
 * @text 最小拡大率
 * @type number
 * @default 100
 * @desc ＊がついたイージングの最大（最小）拡大率（％）
 */

/*~struct~OpacitySettings:
 * @param startOpacity
 * @text 開始透明度
 * @type number
 * @default 255
 * @min 0
 * @max 255
 * @desc イージング開始時の透明度（0~255）
 *
 * @param targetOpacity
 * @text 終了透明度
 * @type number
 * @default 0
 * @min 0
 * @max 255
 * @desc イージング終了時の透明度（0~255）
 *
 * @param easingType
 * @text 透明度イージングの種類
 * @type select
 * @default linear
 * @option linear
 * @option easeInQuad
 * @option easeOutQuad
 * @option easeInOutQuad
 * @option easeInCubic
 * @option easeOutCubic
 * @option easeInOutCubic
 * @option easeInQuart
 * @option easeOutQuart
 * @option easeInOutQuart
 * @option easeInQuint
 * @option easeOutQuint
 * @option easeInOutQuint
 * @option easeInSine
 * @option easeOutSine
 * @option easeInOutSine
 * @option easeInExpo
 * @option easeOutExpo
 * @option easeInOutExpo
 * @option easeInCirc
 * @option easeOutCirc
 * @option easeInOutCirc
 * @option easeInElastic
 * @option easeOutElastic
 * @option easeInOutElastic
 * @option easeInBack
 * @option easeOutBack
 * @option easeInOutBack
 * @option easeInBounce
 * @option easeOutBounce
 * @option easeInOutBounce
 * @desc 透明度イージングの種類
 */

/*~struct~AnimationSettings:
 * @param duration
 * @text イージング時間
 * @type number
 * @default 60
 * @min 1
 * @desc イージングが完了するまでの時間（フレーム数）
 *
 * @param loops
 * @text ループ回数
 * @type number
 * @default 0
 * @min 0
 * @desc イージングのループ回数（0で無限ループ）
 *
 * @param loopWait
 * @text ループ間ウェイト
 * @type number
 * @default 0
 * @min 0
 * @desc ループとループの間の待機時間（フレーム数）
 */

/*~struct~OnomatopoeiaSpriteSheetSettings:
 * @param frameCols
 * @text 列数
 * @type number
 * @default 3
 * @desc スプライトシートの列数
 *
 * @param frameRows
 * @text 行数
 * @type number
 * @default 1
 * @desc スプライトシートの行数
 *
 * @param startIndex
 * @text 再生開始フレーム
 * @type number
 * @default 0
 * @desc 再生する最初のフレーム番号（0起算）
 *
 * @param endIndex
 * @text 再生終了フレーム
 * @type number
 * @default 2
 * @desc 再生する最後のフレーム番号（0起算）
 *
 * @param interval
 * @text 切替間隔(フレーム)
 * @type number
 * @default 6
 * @desc 何フレームごとに次フレームへ進めるか
 *
 * @param loopSheet
 * @text シートをループ再生
 * @type boolean
 * @default true
 * @desc true の場合、終了フレームまで到達すると開始フレームに戻り続ける
 *
 * @param pingPong
 * @text 往復再生（ピンポン）
 * @type boolean
 * @default false
 * @desc true の場合、端で反転して往復再生
 */

/*~struct~TitleSettings:
 * @param UseCustomTitle
 * @text 独自タイトルを使用する
 * @type boolean
 * @default false
 * @desc trueの場合は独自のタイトルを使用
 *
 * @param ShowGameTitle
 * @text ゲームタイトル表示
 * @type boolean
 * @default true
 * @desc 画面中央上部にゲームタイトルを表示するか
 *
 * @param BackgroundImage
 * @text 背景画像
 * @type file
 * @dir img/titles1/
 * @desc タイトル背景画像
 *
 * @param Choices
 * @text タイトル選択肢リスト
 * @type struct<VisualtitleChoiceItem>[]
 * @desc 表示されるタイトル選択肢の一覧
 *
 * @param ChoiceXBase
 * @text 選択肢X基準
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 *
 * @param ChoiceYBase
 * @text 選択肢Y基準
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 *
 * @param CursorConfig
 * @text カーソル設定
 * @type struct<titlecursorConfig>
 *
 * @param CursorSelectSE
 * @text カーソル移動SE
 * @type struct<CursorSelectSe>
 *
 * @param CursorOkSE
 * @text 決定SE
 * @type struct<CursorOkSe>
 *
 * @param TitleBGM
 * @text タイトルBGM
 * @type struct<BGM>
 *
 * @param DummyMapId
 * @text ダミーマップID
 * @type number
 * @min 1
 * @desc commonEvent 実行時に遷移するマップID
 * @default 1
 */

/*~struct~UIConfig:
 * @param Name
 * @text UI名
 * @type string
 *
 * @param UIbaseSettings
 * @text UIbase設定
 * @type struct<UIbaseSettings>
 * @desc UIのドラッグbaseになる画像の設定
 *
 * @param ActiveSwitchIds
 * @text 有効化スイッチ
 * @type switch[]
 * @desc このUIが表示されている間ONになるスイッチID
 *
 * @param X
 * @text 全体X座標
 * @type number
 * @default 0
 *
 * @param Y
 * @text 全体Y座標
 * @type number
 * @default 0
 *
 * @param PictureId
 * @text 使用ピクチャID
 * @type number
 * @default 50
 *
 * @param ImageSprites
 * @text 画像スプライト一覧
 * @type struct<UIImageSprite>[]
 * @desc 静的または単一画像として表示するUIスプライト
 *
 * @param ChoiceSprites
 * @text 選択肢スプライト一覧
 * @type struct<UIChoiceSprite>[]
 * @desc コモンイベントなどを呼び出す画像選択ボタン一覧
 *
 * @param GaugeSprites
 * @text ゲージスプライト一覧
 * @type struct<UIGaugeSprite>[]
 * @desc ゲージに使用する画像
 *
 * @param NumberSprites
 * @text 数値スプライト一覧
 * @type struct<UINumberSprite>[]
 * @desc 変数に応じて数字をスプライトで表示する項目
 */

/*~struct~UIImageSprite:
 * @param Image
 * @text 表示画像
 * @type file
 * @dir img/UI
 *
 * @param OffsetX
 * @text Xオフセット
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 *
 * @param OffsetY
 * @text Yオフセット
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 *
 * @param ShowSwitch
 * @text 表示スイッチ
 * @type switch
 * @default 0
 * @desc 0の場合は常に表示
 *
 * @param ShowVariable
 * @text 表示変数ID
 * @type variable
 * @default 0
 * @desc 0の場合条件を無視
 *
 * @param ShowOperator
 * @text 比較方法
 * @type select
 * @option 等しい（==）
 * @option 以上（>=）
 * @option 以下（<=）
 * @option より大きい（>）
 * @option より小さい（<）
 * @default 等しい（==）
 *
 * @param ShowValue
 * @text 比較値
 * @type number
 * @default 0
 * @desc 変数と比較する値
 *
 * @param FadeFrames
 * @text フェード時間
 * @type number
 * @min 0
 * @default 0
 * @desc 0: フェード機能、0ならフェードなし
 *
 * @param Priority
 * @text 表示優先度
 * @type number
 * @min 0
 * @default 0
 * @desc 数値が大きいほど手前に描画
 */

/*~struct~UIChoiceSprite:
 * @param Image
 * @text 表示画像
 * @type file
 * @dir img/UI
 * @desc ボタンとして表示される画像
 *
 * @param CommonEventId
 * @type common_event
 * @desc クリックしたときに呼び出されるコモンイベント
 *
 * @param X
 * @type number
 * @default 0
 *
 * @param Y
 * @type number
 * @default 0
 *
 * @param HoverEffect
 * @text ホバー効果
 * @type struct<UIHoverEffectConfig>
 * @desc ホバー効果
 *
 * @param ShowCondition
 * @text 表示条件
 * @type struct<ConditionConfig>
 * @default {"SwitchId":"0","VariableId":"0","Operator":"等しい（==）","Value":"0"}
 *
 * @param EnableCondition
 * @text 有効条件
 * @type struct<ConditionConfig>
 * @default {"SwitchId":"0","VariableId":"0","Operator":"等しい（==）","Value":"0"}
 *
 * @param DisabledImage
 * @text 無効時の画像
 * @type file
 * @dir img/UI
 *
 * @param FadeEffect
 * @text フェード効果
 * @type struct<UIFadeEffect>
 * @desc ボタンの表示・非表示時にフェード効果を使用する
 */

/*~struct~UIFadeEffect:
 *
 * @param UseFade
 * @text フェードを使う
 * @type boolean
 * @default false
 *
 * @param FadeFrames
 * @text フレーム数
 * @type number
 * @default 5
 * @min 1
 */

/*~struct~UIHoverEffectConfig:
 *
 * @param UseScale
 * @text 拡大を有効化
 * @type boolean
 * @default false
 *
 * @param Scale
 * @text 拡大率（%）
 * @type number
 * @default 120
 *
 * @param UseOffset
 * @text 位置補正を有効化
 * @type boolean
 * @default false
 *
 * @param OffsetX
 * @text X補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 *
 * @param OffsetY
 * @text Y補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 *
 * @param UseFrame
 * @text フレームを表示
 * @type boolean
 * @default false
 *
 * @param FrameImage
 * @text フレーム画像
 * @type file
 * @dir img/UI/
 * @desc UI選択肢用のフレーム画像
 *
 * @param SpriteSheet
 * @text スプライトシート設定
 * @type struct<UISpriteSheetConfig>
 * @default
 *
 * @param ExtraImageSetting
 * @text ホバー中表示画像
 * @type struct<UIHoverExtraImageConfig>
 * @default
 *
 * @param HoverSE
 * @text ホバー時SE
 * @type file
 * @dir audio/se/
 * @desc ホバー時に再生するSEファイル
 * @default
 *
 * @param HoverScript
 * @text ホバー時実行スクリプト
 * @type multiline_string
 * @desc ホバー時に実行するJavaScriptコード
 * @default
 */

/*~struct~UIbaseSettings:
 *
 * @param EnableSwitchId
 * @text 有効化スイッチID
 * @type switch
 * @desc このスイッチがONのときUI全体をドラッグで移動可能にする
 *
 * @param Baseimage
 * @text base画像
 * @type file
 * @dir img/UI/
 * @desc UIのbaseになるファイル名
 */

/*~struct~UIHoverExtraImageConfig:
 *
 * @param Image
 * @text 表示画像ファイル
 * @type file
 * @dir img/UI/
 * @desc ホバー中に表示する追加画像
 *
 * @param X
 * @text オフセットX
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 *
 * @param Y
 * @text オフセットY
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 *
 * @param SwitchId
 * @text 表示条件スイッチID
 * @type switch
 * @default 0
 *
 * @param VariableId
 * @text 表示条件変数ID
 * @type variable
 * @default 0
 *
 * @param CompareValue
 * @text 変数の比較値
 * @type number
 * @default 0
 *
 * @param Operator
 * @text 比較演算子
 * @type select
 * @option ==
 * @option >=
 * @option <=
 * @option >
 * @option <
 * @default ==
 */

/*~struct~ConditionConfig:
*
* @param SwitchId
* @text スイッチID
* @type switch
* @default 0

* @param VariableId
* @text 変数ID
* @type variable
* @default 0

* @param Operator
* @text 比較方法
* @type select
* @option 等しい（==）
* @option 以上（>=）
* @option 以下（<=）
* @option より大きい（>）
* @option より小さい（<）
* @default 等しい（==）

* @param Value
* @text 比較値
* @type number
* @default 0
* @desc 変数と比較する対象値
*/

/*~struct~UIGaugeSprite:
 * @param Type
 * @text ゲージタイプ
 * @type select
 * @option 伸縮         @value elasticity
 * @option 移動         @value slide
 * @default elasticity
 * @desc ゲージの動作方式（伸縮 or 移動）
 *
 * @param Align
 * @text ゲージの進行方向
 * @type select
 * @option left
 * @option right
 * @option up
 * @option down
 * @default right
 * @desc ゲージ方向
 *
 * @param CurrentVarId
 * @text 現在値の変数ID
 * @type variable
 * @desc ゲージの現在値変数ID
 *
 * @param MaxVarId
 * @text 最大値の変数ID
 * @type variable
 * @desc ゲージの最大値変数ID
 *
 * @param BarImage
 * @text ゲージ画像
 * @type file
 * @dir img/UI
 * @desc ゲージとして使う画像
 *
 * @param MaskImage
 * @text マスク画像
 * @type file
 * @dir img/UI
 * @desc マスクに使用する画像
 *
 * @param X
 * @text 表示X座標
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 *
 * @param Y
 * @text 表示Y座標
 * @type number
 * @default 0
 *
 * @param Decoration
 * @text 装飾設定
 * @type struct<UIGaugeDecoration>
 * @desc ゲージに重ねる装飾画像
 *
 * @param SlideDistance
 * @text ゲージの移動距離
 * @type number
 * @min 0
 * @desc ゲージが移動する距離(移動タイプのみ使用)
 *
 * @param SwitchId
 * @text 表示切替スイッチ
 * @type switch
 * @default 0
 * @desc 0なら常に表示。
 *
 * @param UseEasing
 * @text イージングを使用する
 * @type boolean
 * @default false
 * @desc 値が変化したときの移動表現を使用するかどうか
 *
 * @param EasingType
 * @text イージングの種類
 * @type select
 * @option linear
 * @option easeIn
 * @option easeOut
 * @option easeInOut
 * @default easeInOut
 * @desc イーシング種類を指定
 *
 * @param EasingSpeed
 * @text イージング速度
 * @type number
 * @decimals 2
 * @min 0.01
 * @max 1.0
 * @default 0.15
 * @desc 値に近づく速さ
 */

/*~struct~UIGaugeDecoration:
 *
 * @param BackgroundImage
 * @text 背景画像
 * @type file
 * @dir img/UI
 * @desc ゲージの後ろに表示される背景画像
 *
 * @param BackgroundOffsetX
 * @text 背景画像X補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc 背景画像のX座標補正
 *
 * @param BackgroundOffsetY
 * @text 背景画像Y補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc 背景画像のY座標補正
 *
 * @param FrameImage
 * @text フレーム画像
 * @type file
 * @dir img/UI
 * @desc ゲージの上に重ねる装飾枠画像
 *
 * @param FrameOffsetX
 * @text フレーム画像X補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc フレーム画像のX座標補正
 *
 * @param FrameOffsetY
 * @text フレーム画像Y補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc フレーム画像のY座標補正
 */

/*~struct~UINumberSprite:
 * @param VariableId
 * @text 表示変数ID
 * @type variable
 * @desc この変数の値をスプライトで表示
 *
 * @param X
 * @text 表示X座標
 * @type number
 * @default 0
 * @desc 数字の表示位置X
 *
 * @param Y
 * @text 表示Y座標
 * @type number
 * @default 0
 * @desc 数字の表示位置Y
 *
 * @param Bitmap
 * @text 数字画像
 * @type file
 * @dir img/system
 * @default Damage
 * @desc 数字表示に使用する画像
 *
 * @param Digit
 * @text 桁数
 * @type number
 * @default 4
 * @desc 表示する最大桁数
 *
 * @param Padding
 * @text 桁間スペース
 * @type number
 * @min -99
 * @max 99
 * @default 0
 * @desc 各桁の間隔
 *
 * @param Align
 * @text 整列方向
 * @type select
 * @option 左揃え @value left
 * @option 中央揃え @value center
 * @option 右揃え @value right
 * @default right
 * @desc 数字の表示位置を設定（左・中央・右）
 *
 * @param PadZero
 * @text ゼロ埋め
 * @type boolean
 * @default false
 * @desc 桁が足りないときに0で埋めるか
 *
 * @param SwitchId
 * @text 表示スイッチ
 * @type switch
 * @default 0
 * @desc 0で常に表示
 *
 */

/*~struct~UITextSprite:
 * @param VariableId
 * @text 表示する変数ID
 * @type variable
 * @desc 表示したい値が格納されている変数番号
 *
 * @param OffsetX
 * @text Xオフセット
 * @type number
 * @default 0
 * @desc UIConfig.X に対する相対位置
 *
 * @param OffsetY
 * @text Yオフセット
 * @type number
 * @default 0
 * @desc UIConfig.Y に対する相対位置
 *
 * @param FontSize
 * @text フォントサイズ
 * @type number
 * @default 28
 *
 * @param Align
 * @text 揃え
 * @type select
 * @option 左揃え
 * @value left
 * @option 中央揃え
 * @value center
 * @option 右揃え
 * @value right
 * @default left
 * @desc テキストの表示位置
 *
 * @param FontFace
 * @text フォント名
 * @type string
 * @desc 表示に使うフォント名（空白ならデフォルト）
 */

/*~struct~UISpriteSheetConfig:

 * @param UseSpriteSheet
 * @text スプライトシートを使用
 * @type boolean
 * @default true
 *
 * @param FrameIndex
 * @text 初期フレーム番号
 * @type number
 * @default 0
 *
 * @param FrameCols
 * @text 列数
 * @type number
 * @default 3 
 *
 * @param FrameRows
 * @text 行数
 * @type number
 * @default 1
 * 
 * @param UseAnimation
 * @type boolean
 * @default true
 *
 * @param Loop
 * @text ループ再生
 * @type boolean
 * @default true 
 *
 * @param StartIndex
 * @text 再生開始フレーム
 * @type number
 * @default 0
 *
 * @param EndIndex
 * @text 再生終了フレーム
 * @type number
 * @default 2
 *
 * @param Interval
 * @text 切替間隔(フレーム)
 * @type number
 * @default 6 
 * 
 * @param OffsetX
 * @text X オフセット
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 *
 * @param OffsetY
 * @text Y オフセット
 * @type number
 * @min -9999
 * @max 9999
 * @default 0 
 */

/*~struct~RecollectionSettings:
 * @param Background
 * @text 回想背景画像
 * @type file
 * @dir img/Recollection/
 * @desc 回想シーンの背景に表示される画像
 * @default ""
 *
 * @param TabBackgrounds
 * @text タブ別背景画像設定
 * @type struct<TabBackground>[]
 * @desc 各タブに表示される画像と座標設定
 * @default []
 *
 * @param Choices
 * @text 回想選択肢リスト
 * @type struct<RecChoiceItem>[]
 * @desc 回想画面に表示される選択肢一覧
 * @default []
 *
 * @param CursorConfig
 * @text カーソル設定
 * @type struct<RecCursorConfig>
 * @default {}
 *
 * @param BGM
 * @text 回想BGM
 * @type struct<BGM>
 * @default {}
 *
 * @param SelectSE
 * @text 選択SE
 * @type struct<CursorSelectSe>
 * @default {}
 *
 * @param OkSE
 * @text 決定SE
 * @type struct<CursorOkSe>
 * @default {}
 *
 * @param Tabs
 * @text タブボタン一覧
 * @type struct<TabButton>[]
 * @default []
 *
 * @param TabCursor
 * @text タブ用カーソル設定
 * @type struct<TabCursorConfig>
 * @default {}
 *
 * @param RecollectionCancelsetting
 * @text 終了確認設定
 * @type struct<RecollectionCancelConfig>
 * @desc 回想シーン中にキャンセルキーで表示される確認画像選択肢
 * @default {}
 *
 * @param RecollectionActiveSwitches
 * @text 回想中スイッチ
 * @type switch[]
 * @desc 回想モード中にONにし、終了時にOFFにするスイッチ
 * @default []
 */

/*~struct~RecChoiceItem:
 * @param Name
 * @text メモ
 * @type string
 * @desc sceneメモ用
 *
 * @param Page
 * @text 表示ページ
 * @type number
 * @desc タブに設定したページで表示
 * @default 1
 *
 * @param ShowSwitch
 * @text 表示スイッチ
 * @type switch
 * @desc 回想開放を判定するスイッチ
 * @default 0
 *
 * @param EnabledImage
 * @text 開放時画像
 * @type file
 * @dir img/Recollection/
 * @desc 表示スイッチがONのときに表示される画像ファイル
 *
 * @param DisabledImage
 * @text 未開放画像
 * @type file
 * @dir img/Recollection/
 * @desc 表示スイッチがOFFのときに表示される画像ファイル
 *
 * @param X
 * @text 表示X座標
 * @type number
 * @min -9999
 * @max 9999
 * @desc ピクチャを表示するX位置
 *
 * @param Y
 * @text 表示Y座標
 * @type number
 * @min -9999
 * @max 9999
 * @desc ピクチャを表示するY位置
 *
 * @param HoverEffect
 * @text ホバー効果
 * @type struct<HoverRecollectionEffectConfig>
 * @desc ホバー効果を設定
 *
 * @param CommonEventId
 * @parent Action
 * @text コモンイベントID
 * @type common_event
 * @desc 回想として呼び出すコモンイベント
 *
 */

/*~struct~ADMINSettings:
 * @param NewGameCommonEvent
 * @text ニューゲームコモン
 * @type common_event
 * @default 0
 * @desc ニューゲーム開始時に自動で実行されるコモンイベントID
 *
 * @param LoadGameCommonEvent
 * @text ロードコモン
 * @type common_event
 * @default 0
 * @desc ロード完了時に自動で実行されるコモンイベントID
 *
 * @param MenuCloseCommonEvent
 * @text メニューコモン
 * @type common_event
 * @default 0
 * @desc メニュー画面を閉じたときに実行されるコモンイベントID
 *
 * @param EventTriggers
 * @text イベントトリガー
 * @type struct<EventTrigger>[]
 * @default []
 * @desc 条件に応じて発動するコモンイベント設定
 *
 * @param TriggerRecordVariable
 * @text トリガー実行記録変数ID
 * @type variable
 * @desc 一度きりイベントの実行状態を記録する変数ID
 * @default 0
 */

/*~struct~EventTrigger:
 * @param CommonEventId
 * @text コモンイベントID
 * @type common_event
 * @desc 実行されるコモンイベントのID。
 *
 * @param ConditionSwitches
 * @text 実行条件スイッチ
 * @type switch[]
 * @desc すべてのスイッチがONのときに実行。
 * @default []
 *
 * @param ConditionVariables
 * @text 実行条件変数
 * @type struct<ConditionVariable>[]
 * @desc すべての変数条件が満たされているときに実行。
 * @default []
 *
 * @param ProhibitSwitches
 * @text 禁止条件スイッチ
 * @type switch[]
 * @desc いずれかのスイッチがONのとき実行しない。
 * @default []
 *
 * @param ProhibitVariables
 * @text 禁止条件変数
 * @type struct<ConditionVariable>[]
 * @desc いずれかの変数条件が満たされていると実行しない。
 * @default []
 *
 * @param Once
 * @text 一度きり実行
 * @type boolean
 * @desc 条件を満たしたら一度だけ実行し、それ以降は無視。
 * @default false
 *
 * @param CustomName
 * @text カスタム名
 * @type string
 * @desc 使用するカスタム名の指定
 * @default
 *
 * @param BlockIfTriggered
 * @text 連続発火を禁止
 * @type boolean
 * @desc 連続のイベント実行を抑制
 * @default false
 */

/*~struct~BackgroundSettings:
 * @param Backgrounds
 * @text 背景管理リスト
 * @type struct<Background>[]
 * @default []
 * @desc 時間帯別の背景画像設定
 *
 * @param PictureId1
 * @text 背景用ピクチャID1
 * @type number
 * @default 1
 * @desc 旧背景に使用するピクチャID
 *
 * @param PictureId2
 * @text 背景用ピクチャID2
 * @type number
 * @default 2
 * @desc 新背景に使用するピクチャID
 */

/*~struct~ConditionVariable:
 * @param Id
 * @text 変数ID
 * @type variable
 * @desc 判定対象の変数ID。
 *
 * @param Operator
 * @text 比較方法
 * @type select
 * @option 等しい（==）
 * @value 等しい
 * @option 等しくない（!=）
 * @value 等しくない
 * @option より大きい（>）
 * @value より大きい
 * @option より小さい（<）
 * @value より小さい
 * @option 以上（>=）
 * @value 以上
 * @option 以下（<=）
 * @value 以下
 * @desc 変数と比較する方法を選択。
 *
 * @param Value
 * @text 比較値
 * @type number
 * @desc 変数と比較する対象の値。
 */

/*~struct~ChatLogSettings:
 *
 * @param SwitchID
 * @text 表示スイッチID
 * @type switch
 * @desc チャットログの表示・非表示を切り替えるスイッチ
 * @default 1
 *
 * @param DisableChatSwitchID
 * @text チャット無効スイッチID
 * @type switch
 * @desc ONのときチャットログ追加を無効化
 * @default 2
 *
 * @param ForceHideSwitchIds
 * @text 強制非表示スイッチID一覧
 * @type switch[]
 * @desc ONのときチャットログウィンドウを強制的に非表示にするスイッチ
 * @default []
 *
 * @param MaxLogEntries
 * @text 最大ログ件数
 * @type number
 * @desc 保存する最大件数（古い順に削除）
 * @default 100
 *
 * @param WindowX
 * @text ウィンドウX座標
 * @type number
 * @default 0
 *
 * @param WindowY
 * @text ウィンドウY座標
 * @type number
 * @default 0
 *
 * @param WindowWidth
 * @text ウィンドウ幅
 * @type number
 * @default 480
 *
 * @param WindowHeight
 * @text ウィンドウ高さ
 * @type number
 * @default 216
 *
 * @param WindowOpacity
 * @text ウィンドウ透明度
 * @type number
 * @min 0
 * @max 255
 * @default 255
 *
 * @param PaddingTop
 * @text 上余白
 * @type number
 * @default 8
 *
 * @param PaddingBottom
 * @text 下余白
 * @type number
 * @default 8
 *
 * @param PaddingLeft
 * @text 左余白
 * @type number
 * @default 12
 *
 * @param PaddingRight
 * @text 右余白
 * @type number
 * @default 12
 *
 * @param LineSpacing
 * @text 行間
 * @type number
 * @default 4
 *
 * @param FontSize
 * @text フォントサイズ
 * @type number
 * @default 28
 *
 * @param IconSize
 * @text アイコンサイズ
 * @type number
 * @default 32
 *
 * @param ScrollAmount
 * @text スクロール量
 * @type number
 * @default 40
 *
 * @param DefaultStampWidth
 * @text デフォルトスタンプ幅
 * @type number
 * @default 100
 *
 * @param DefaultStampHeight
 * @text デフォルトスタンプ高さ
 * @type number
 * @default 100
 *
 * @param CustomBackgroundImage
 * @text カスタム背景画像
 * @type file
 * @dir img/pictures
 * @desc 背景画像を指定。空欄なら無し
 *
 * @param FontName
 * @text 使用フォント名
 * @type string
 * @default GameFont
 */

/*~struct~LayerItem:
 * @param layer
 * @text レイヤー名
 * @type string
 *
 * @param file
 * @text ファイル名（img/characterset 内）
 * @type file
 * @dir img/characterset
 *
 * @param priority
 * @text 優先度
 * @type number
 * @default 50
 * @desc 値が大きいほど上に表示
 */

/*~struct~LayerPartItem:
 * @param layer
 * @text レイヤー名
 * @type string
 *
 * @param file
 * @text 画像ファイル
 * @type file
 * @dir img/characterset
 */

/*~struct~CgGroup:
 *
 * @param FadeVariableId
 * @text フェード時間変数ID
 * @type variable
 * @default 0
 *
 * @param PictureId1
 * @text ベースPictureID
 * @type number
 * @min 1 @max 100
 * @default 21
 *
 * @param PictureId2
 * @text フェードPictureID
 * @type number
 * @min 1 @max 100
 * @default 22
 *
 * @param Scenes
 * @text CGシーン一覧
 * @type struct<CgScene>[]
 * @desc このグループに属する CG シーンを列挙
 */

/*~struct~CgScene:
 *
 * @param Label
 * @text シーン名（ラベル）
 * @type string
 *
 * @param Images
 * @text 画像リスト
 * @type struct<CgImage>[]
 * @desc
 */

/*~struct~CgImage:
 *
 * @param FileName
 * @text CG画像ファイル
 * @type file
 * @dir img/pictures/
 */

/*~struct~VisualtitleChoiceItem:
 * @param Name
 * @text 選択肢名
 * @type string
 * @desc タイトルで表示する選択肢の名前（メモ用）
 *
 * @param ShowSwitch
 * @text 表示スイッチ
 * @type switch
 * @desc ONのときのみこの選択肢を表示（0で常に表示）
 * @default 0
 *
 * @param Image
 * @text 表示画像
 * @type file
 * @dir img/choice/
 * @desc 表示する画像ファイル（img/choice/ フォルダ内）
 *
 * @param X
 * @text 表示X座標
 * @type number
 * @desc ピクチャを表示するX位置
 *
 * @param Y
 * @text 表示Y座標
 * @type number
 * @desc ピクチャを表示するY位置
 *
 * @param HoverEffect
 * @text ホバー効果
 * @type struct<VisualtitleHoverEffectConfig>
 * @desc ホバー効果を設定
 *
 * @param Action
 * @text 実行アクション
 * @type select
 * @option はじめから
 * @value newGame
 * @option つづきから
 * @value continue
 * @option オプション
 * @value options
 * @option ゲーム終了
 * @value gameend
 * @option コモンイベント呼び出し
 * @value commonEvent
 * @desc クリックされたときに実行する動作
 *
 * @param CommonEventId
 * @parent Action
 * @text コモンイベントID
 * @type common_event
 * @desc アクションがコモンイベントのときに呼ばれるコモンイベントID
 */

/*~struct~VisualtitleHoverEffectConfig:
 *
 * @param UseScale
 * @text 拡大を有効化
 * @type boolean
 * @default false
 *
 * @param Scale
 * @text 拡大率（%）
 * @type number
 * @default 120
 *
 * @param UseOffset
 * @text 位置補正を有効化
 * @type boolean
 * @default false
 *
 * @param OffsetX
 * @text X補正
 * @type number
 * @default 0
 *
 * @param OffsetY
 * @text Y補正
 * @type number
 * @default 0
 *
 * @param UseFrame
 * @text フレームを表示
 * @type boolean
 * @default false
 *
 * @param FrameImage
 * @text フレーム画像
 * @type file
 * @dir img/choice/
 *
 * @param ExtraImageSetting
 * @text ホバー中追加画像
 * @type struct<titleVisualHoverExtraImageConfig>
 * @default
 */

/*~struct~HoverEffectConfig:
 * @param UseScale
 * @text 拡大を有効化
 * @type boolean
 * @default false
 * @desc trueにすると選択時に拡大
 *
 * @param Scale
 * @text 拡大率（%）
 * @type number
 * @default 100
 * @desc 選択中倍率
 *
 * @param UseOffset
 * @text 位置補正を有効化
 * @type boolean
 * @default false
 * @desc 選択中画像座標移動
 *
 * @param OffsetX
 * @text X補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc 選択中に画像のX座標をずらす量
 *
 * @param OffsetY
 * @text Y補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc 選択中に画像のY座標をずらす量
 *
 * @param UseFrame
 * @text フレームを表示
 * @type boolean
 * @default false
 * @desc trueにすると選択中にフレーム画像が表示
 *
 * @param FrameImage
 * @text フレーム画像
 * @type file
 * @dir img/choice/
 * @desc フレームに使用する画像
 *
 * @param ExtraImageSetting
 * @text ホバー中表示画像
 * @type struct<VisualHoverExtraImageConfig>
 * @default
 */

/*~struct~titleVisualHoverExtraImageConfig:
 *
 * @param Image
 * @text ホバー画像ファイル名
 * @type file
 * @dir img/choice/
 *
 * @param X
 * @text X座標
 * @type number
 * @default 0
 *
 * @param Y
 * @text Y座標
 * @type number
 * @default 0
 *
 * @param SwitchId
 * @text 表示条件スイッチID
 * @type switch
 * @default 0
 *
 * @param VariableId
 * @text 表示条件変数ID
 * @type variable
 * @default 0
 *
 * @param CompareValue
 * @text 比較値
 * @type number
 * @default 0
 *
 * @param Operator
 * @text 比較演算子
 * @type select
 * @option ==
 * @option >=
 * @option <=
 * @option >
 * @option <
 * @default ==
 */

/*~struct~DummyMapSettings:
 * @param MapId
 * @text マップID
 * @type number
 * @min 1
 * @desc 遷移先のマップID
 *
 * @param X
 * @text X座標
 * @type number
 * @default 1
 *
 * @param Y
 * @text Y座標
 * @type number
 * @default 1
 */

/*~struct~titlecursorConfig:
 *
 * @param Image
 * @text カーソル画像
 * @type file
 * @dir img/choice/
 *
 * @param Position
 * @text 表示位置
 * @type select
 * @option 左
 * @value left
 * @option 中央
 * @value center
 * @option 右
 * @value right
 * @default left
 * @desc カーソルの相対表示位置
 *
 * @param OffsetX
 * @text X座標補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 *
 * @param OffsetY
 * @text Y座標補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc タイトル画面で表示されるカーソルの画像と座標補正値
 */

/*~struct~RecCursorConfig:
 * @param Image
 * @text カーソル画像
 * @type file
 * @dir img/Recollection/
 * @desc 回想シーンで使うカーソル画像
 * @default
 *
 * @param OffsetX
 * @text Xオフセット
 * @type number
 * @min -9999
 * @max 9999
 * @decimals 2
 * @default 0
 * @desc カーソルのX座標補正値
 *
 * @param OffsetY
 * @text Yオフセット
 * @type number
 * @min -9999
 * @max 9999
 * @decimals 2
 * @default 0
 * @desc カーソルのY座標補正値
 */

/*~struct~RecollectionChoiceItem:
 * @param Name
 * @text 選択肢名
 * @type string
 * @desc 開発者用メモとしての選択肢名
 *
 * @param Page
 * @text 表示ページ
 * @type number
 * @desc この選択肢を表示するページ番号（1ページ目なら1）
 * @default 1
 *
 * @param ShowSwitch
 * @text 表示スイッチ
 * @type switch
 * @desc このスイッチのONOFFで回想可能、表示画像の判定を行う
 * @default 0
 *
 * @param EnabledImage
 * @text 表示画像（ON時）
 * @type file
 * @dir img/Recollection/
 * @desc 表示スイッチがONのときに表示される画像ファイル
 *
 * @param DisabledImage
 * @text 表示画像（OFF時）
 * @type file
 * @dir img/Recollection/
 * @desc 表示スイッチがOFFのときに表示される画像ファイル
 *
 * @param X
 * @text 表示X座標
 * @type number
 * @min -9999
 * @max 9999
 * @desc ピクチャを表示するX位置
 *
 * @param Y
 * @text 表示Y座標
 * @type number
 * @min -9999
 * @max 9999
 * @desc ピクチャを表示するY位置
 *
 * @param HoverEffect
 * @text ホバー効果
 * @type struct<HoverRecollectionEffectConfig>
 * @desc 選択中に拡大・移動・フレーム表示などの演出を設定
 *
 * @param CommonEventId
 * @parent Action
 * @text コモンイベントID
 * @type common_event
 * @desc 回想として呼び出すコモンイベント
 *
 */

/*~struct~TabBackground:
 * @param Page
 * @text 対応ページ番号
 * @type number
 *
 * @param Image
 * @text 背景画像
 * @type file
 * @dir img/Recollection/
 *
 * @param X
 * @type number
 * @default 0
 *
 * @param Y
 * @type number
 * @default 0
 *
 * @param ShowSwitch
 * @text 表示スイッチ
 * @type switch
 * @default 0
 * @desc 0なら常に表示、1以上でそのスイッチON時のみ表示
 *
 * @param ShowVariable
 * @text 表示変数ID
 * @type variable
 * @default 0
 *
 * @param ShowOperator
 * @text 変数の比較方法
 * @type select
 * @option 等しい（==）
 * @option 以上（>=）
 * @option 以下（<=）
 * @option より大きい（>）
 * @option より小さい（<）
 * @default 等しい（==）
 *
 * @param ShowValue
 * @text 比較値
 * @type number
 * @default 0
 */

/*~param~TabBackgrounds:
 * @text タブ別背景画像設定
 * @type struct<TabBackground>[]
 * @desc 各ページに対応する画像設定
 */

/*~struct~HoverRecollectionEffectConfig:
 * @param UseScale
 * @text 拡大を有効化
 * @type boolean
 * @default false
 * @desc trueにすると選択時に拡大
 *
 * @param Scale
 * @text 拡大率（%）
 * @type number
 * @default 100
 * @desc 選択中に画像がこの倍率で拡大
 *
 * @param UseOffset
 * @text 位置補正を有効化
 * @type boolean
 * @default false
 * @desc trueにすると選択時に画像の座標が値分変動
 *
 * @param OffsetX
 * @text X補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc 選択中に画像のX座標をずらす量
 *
 * @param OffsetY
 * @text Y補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc 選択中に画像のY座標をずらす量
 *
 * @param UseFrame
 * @text フレームを表示
 * @type boolean
 * @default false
 * @desc trueにすると選択中にフレーム画像が表示
 *
 * @param FrameImage
 * @text フレーム画像
 * @type file
 * @dir img/Recollection/
 * @desc フレームに使用する画像
 */

/*~struct~RecollectionCancelConfig:
 * @param BaseImage
 * @text 土台画像
 * @type file
 * @dir img/Recollection/
 * @desc 確認ウィンドウの背景画像
 *
 * @param Choices
 * @text 選択肢画像リスト
 * @type struct<RecCancelChoiceItem>[]
 * @desc 終了確認の選択肢
 */

/*~struct~RecCancelChoiceItem:
 * @param Image
 * @text 選択肢画像
 * @type file
 * @dir img/Recollection/
 *
 * @param X
 * @text X座標
 * @type number
 * @default 0
 *
 * @param Y
 * @text Y座標
 * @type number
 * @default 0
 *
 * @param HoverEffect
 * @text ホバー効果
 * @type struct<HoverRecollectionEffectConfig>
 * @desc ホバー時の拡大・移動・フレーム表示を設定
 *
 * @param Action
 * @text アクション
 * @type select
 * @option endRecollection
 * @option cancel
 * @desc 選択されたときの動作
 */

/*~struct~PageButton:
 * @param Image
 * @text ボタン画像
 * @type file
 * @dir img/Recollection/
 * @desc 表示するボタン画像
 *
 * @param X
 * @text 表示X座標
 * @type number
 * @min -9999
 * @max 9999
 * @desc ボタンの表示位置X
 * @default 0
 *
 * @param Y
 * @text 表示Y座標
 * @type number
 * @min -9999
 * @max 9999
 * @desc ボタンの表示位置Y
 * @default 0
 */

/*~struct~CursorConfig_Recollection:
 * @param Image
 * @text カーソル画像
 * @type file
 * @dir img/Recollection/
 * @desc 回想シーン専用カーソル画像ファイル
 *
 * @param OffsetX
 * @text オフセットX
 * @type number
 * @min -9999
 * @max 9999
 * @desc カーソルのX座標に加算する数値
 * @default 0
 *
 * @param OffsetY
 * @text オフセットY
 * @type number
 * @min -9999
 * @max 9999
 * @desc カーソルのY座標に加算する数値
 * @default 0
 */

/*~struct~TabButton:
 * @param Image
 * @text タブ画像
 * @type file
 * @dir img/Recollection/
 * @desc 表示するタブの画像
 *
 * @param X
 * @text 表示X座標
 * @type number
 * @min -9999
 * @max 9999
 * @desc タブ画像を表示するX位置
 *
 * @param Y
 * @text 表示Y座標
 * @type number
 * @min -9999
 * @max 9999
 * @desc タブ画像を表示するY位置
 *
 * @param Page
 * @text 対応ページ番号
 * @type number
 * @min -9999
 * @max 9999
 * @desc このタブを押すと切り替わるページ番号
 *
 * @param FrameImage
 * @text フレーム画像
 * @type file
 * @dir img/Recollection/
 * @desc 選択中に表示される装飾フレーム画像
 */

/*~struct~TabCursorConfig:
 * @param Image
 * @text カーソル画像
 * @type file
 * @dir img/Recollection/
 * @desc タブカーソル画像ファイル
 *
 * @param OffsetX
 * @text オフセットX
 * @type number
 * @min -9999
 * @max 9999
 * @desc カーソルのX座標に加算される数値
 * @default 0
 *
 * @param OffsetY
 * @text オフセットY
 * @type number
 * @min -9999
 * @max 9999
 * @desc カーソルのY座標に加算される数値
 * @default 0
 */

/*~struct~BGM:
 * @param name
 * @text ファイル名
 * @type file
 * @dir audio/bgm/
 * @desc 再生するBGMファイル名
 *
 * @param volume
 * @text 音量
 * @type number
 * @min 0
 * @max 100
 * @default 90
 *
 * @param pitch
 * @text ピッチ
 * @type number
 * @min 50
 * @max 150
 * @default 100
 *
 * @param pan
 * @text 位相
 * @type number
 * @min -100
 * @max 100
 * @default 0
 */

/*~struct~CursorConfig:
 * @param VariableId
 * @text 切り替え変数ID
 * @type variable
 * @default 0
 *
 * @param CursorList
 * @text カーソル画像リスト
 * @type struct<CursorImageEntry>[]
 * @desc 値ごとに画像と補正を切り替える
 */

/*~struct~CursorImageEntry:
 * @param Value
 * @text 変数の値
 * @type number
 *
 * @param Image
 * @text カーソル画像
 * @type file
 * @dir img/choice/
 *
 * @param Position
 * @text 表示位置
 * @type select
 * @option 左
 * @value left
 * @option 中央
 * @value center
 * @option 右
 * @value right
 * @default left
 * @desc カーソルの相対表示位置
 *
 * @param OffsetX
 * @text オフセットX
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 *
 * @param OffsetY
 * @text オフセットY
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 */

/*~struct~CursorSelectSe:
 * @param name
 * @text ファイル名
 * @type file
 * @dir audio/se/
 *
 * @param volume
 * @type number
 * @default 90
 *
 * @param pitch
 * @type number
 * @default 100
 *
 * @param pan
 * @type number
 * @default 0
 */

/*~struct~CursorOkSe:
 * @param name
 * @text ファイル名
 * @type file
 * @dir audio/se/
 *
 * @param volume
 * @type number
 * @default 90
 *
 * @param pitch
 * @type number
 * @default 100
 *
 * @param pan
 * @type number
 * @default 0
 */

/*~struct~Background:
 * @param Place
 * @text 場所名
 * @type string
 * @desc 例：村、城、森 など
 *
 * @param MorningImage
 * @text 朝の画像
 * @type file
 * @dir img/pictures/backgrounds/
 * @desc img/pictures/backgrounds/ 以下を指定
 *
 * @param EveningImage
 * @text 夕方の画像
 * @type file
 * @dir img/pictures/backgrounds/
 * @desc img/pictures/backgrounds/ 以下を指定
 *
 * @param NightImage
 * @text 夜の画像
 * @type file
 * @dir img/pictures/backgrounds/
 * @desc img/pictures/bac
 */

/*~struct~Choicecommand:
 * @param 画像
 * @text 画像ファイル
 * @type file
 * @dir img/choice/
 * @desc img/choice
 *
 * @param 選択肢名
 * @text 選択肢の名前
 * @type string
 * @desc Show Choices で入力するテキスト
 *
 * @param X座標
 * @text X座標
 * @type number
 * @min 0
 * @default 0
 * @desc ウィンドウ左上を基準とした表示X位置（px）
 *
 * @param Y座標
 * @text Y座標
 * @type number
 * @min 0
 * @default 0
 * @desc ウィンドウ左上を基準とした表示Y位置（px）
 *
 * @param UseScale
 * @text 拡大を有効化
 * @type boolean
 * @default false
 * @desc trueにすると選択時に拡大
 *
 * @param Scale
 * @text 拡大率（%）
 * @type number
 * @default 100
 * @desc 選択中倍率
 *
 * @param UseOffset
 * @text 位置補正を有効化
 * @type boolean
 * @default false
 * @desc 選択中画像座標移動
 *
 * @param OffsetX
 * @text X補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc 選択中に画像のX座標をずらす量
 *
 * @param OffsetY
 * @text Y補正
 * @type number
 * @min -9999
 * @max 9999
 * @default 0
 * @desc 選択中に画像のY座標をずらす量
 *
 * @param UseFrame
 * @text フレームを表示
 * @type boolean
 * @default false
 * @desc trueにすると選択中にフレーム画像が表示
 *
 * @param FrameImage
 * @text フレーム画像
 * @type file
 * @dir img/choice/
 * @desc フレームに使用する画像
 *
 * @param ExtraImageSetting
 * @text ホバー中表示画像
 * @type struct<choiceHoverExtraImageConfig>
 * @default
 */

/*~struct~choiceHoverExtraImageConfig:
 *
 * @param Image
 * @text ホバー画像ファイル名
 * @type file
 * @dir img/choice/
 *
 * @param X
 * @text X座標
 * @type number
 * @default 0
 *
 * @param Y
 * @text Y座標
 * @type number
 * @default 0
 *
 * @param SwitchId
 * @text 表示条件スイッチID
 * @type switch
 * @default 0
 *
 * @param VariableId
 * @text 表示条件変数ID
 * @type variable
 * @default 0
 *
 * @param CompareValue
 * @text 比較値
 * @type number
 * @default 0
 *
 * @param Operator
 * @text 比較演算子
 * @type select
 * @option ==
 * @option >=
 * @option <=
 * @option >
 * @option <
 * @default ==
 */

/*~struct~RingChoice:
 * @param 画像
 * @text 画像
 * @type file
 * @dir img/choice/
 * @desc 選択肢画像
 *
 * @param コモンイベント
 * @text コモンイベント
 * @type common_event
 * @desc 選択時に呼び出すコモンイベント
 *
 */

/*~struct~OptionCommandSet:
 *
 * @param alwaysDash
 * @text 常時ダッシュの初期値
 * @type boolean
 * @default true
 *
 * @param showAlwaysDash
 * @text 常時ダッシュを表示
 * @type boolean
 * @default true
 *
 * @param commandRemember
 * @text コマンド記憶の初期値
 * @type boolean
 * @default true
 *
 * @param showCommandRemember
 * @text コマンド記憶を表示
 * @type boolean
 * @default true
 *
 * @param touchUI
 * @text タッチUIの初期値
 * @type boolean
 * @default true
 *
 * @param showTouchUI
 * @text タッチUIを表示
 * @type boolean
 * @default true
 *
 * @param showScreenSize
 * @text 画面サイズを表示
 * @type boolean
 * @default true
 *
 * @param showFullScreen
 * @text フルスクリーンを表示
 * @type boolean
 * @default true
 *
 * @param returnToTitle
 * @text タイトルに戻るの初期値
 * @type boolean
 * @default true
 *
 * @param showReturnToTitle
 * @text タイトルに戻るを表示
 * @type boolean
 * @default true
 */

/*~struct~Preset:
 * @param name
 * @text プリセット名
 * @type string
 *
 * @param x
 * @text X
 * @type number
 * @min 0
 *
 * @param y
 * @text Y
 * @type number
 * @min 0
 *
 * @param anchorX
 * @text アンカーX
 * @type select
 * @option left
 * @option center
 * @option right
 * @default left
 *
 * @param background
 * @text 背景
 * @type select
 * @option window
 * @option transparent
 * @option image
 * @default window
 *
 * @param backgroundImage
 * @text 背景画像（img/pictures）
 * @type file
 * @dir img/pictures
 *
 * @param opacity
 * @text 不透明度
 * @type number
 * @max 255
 * @default 255
 *
 * @param backOpacity
 * @text 背景不透明度
 * @type number
 * @max 255
 * @default 192
 *
 * @param padding
 * @text パディング
 * @type number
 * @min -1
 * @default -1
 *
 * @param fontSize
 * @text フォントサイズ
 * @type number
 * @min 0
 * @default 0
 *
 * @param fontColor
 * @text 文字色（数値 or CSS色）
 * @type string
 * @default
 *
 * @param outlineColor
 * @text 縁色（none/transparentで無効）
 * @type string
 * @default
 *
 * @param outlineWidth
 * @text 縁の太さ
 * @type number
 * @min 0
 * @default 4
 *
 * @param windowskin
 * @text ウィンドウスキン（img/system）
 * @type file
 * @dir img/system
 *
 * @param tailImage
 * @text 吹き出し画像（img/system）
 * @type file
 * @dir img/system
 *
 * @param tailPosition
 * @text 吹き出し位置
 * @type select
 * @option none
 * @option lt
 * @option ct
 * @option rt
 * @option lb
 * @option cb
 * @option rb
 * @default none
 *
 * @param tailOffsetX
 * @text 吹き出しオフセットX
 * @type number
 * @default 0
 *
 * @param tailOffsetY
 * @text 吹き出しオフセットY
 * @type number
 * @default 0
 */

/*~struct~OnomatopoeiaSettings:
 * @param presets
 * @text プリセット一覧
 * @type struct<OnomatopoeiaPreset>[]
 * @desc 登録済みオノマトペプリセットの一覧
 */

/*~struct~OnomatopoeiaPreset:
 * @param name
 * @text プリセット名
 * @type string
 * @desc プリセットの識別名
 *
 * @param image
 * @text 画像ファイル名
 * @type file
 * @dir img/pictures/
 * @desc オノマトペ画像
 *
 * @param x
 * @text X座標
 * @type number
 * @default 400
 *
 * @param y
 * @text Y座標
 * @type number
 * @default 300
 *
 * @param duration
 * @text 表示時間
 * @type number
 * @default 60
 * @desc フレーム数
 *
 * @param fadeIn
 * @text フェードイン時間
 * @type number
 * @default 10
 * @desc フレーム数
 *
 * @param fadeOut
 * @text フェードアウト時間
 * @type number
 * @default 10
 * @desc フレーム数
 *
 * @param scaleStart
 * @text 開始スケール
 * @type number
 * @decimals 2
 * @default 0.50
 *
 * @param scaleEnd
 * @text 終了スケール
 * @type number
 * @decimals 2
 * @default 1.20
 *
 * @param rotationStart
 * @text 開始回転角度
 * @type number
 * @default 0
 * @desc 度数法（360度）
 *
 * @param rotationEnd
 * @text 終了回転角度
 * @type number
 * @default 0
 * @desc 度数法（360度）
 *
 * @param easing
 * @text イージングタイプ
 * @type select
 * @option Linear（一定速度） @value linear
 * @option QuadIn（加速・緩やかな始まり） @value easeInQuad
 * @option QuadOut（減速・穏やかな終わり） @value easeOutQuad
 * @option QuadInOut（加速と減速） @value easeInOutQuad
 * @option CubicIn（強めの加速） @value easeInCubic
 * @option CubicOut（強めの減速） @value easeOutCubic
 * @option CubicInOut（滑らかな加減速） @value easeInOutCubic
 * @option QuartIn（急激な加速） @value easeInQuart
 * @option QuartOut（急激な減速） @value easeOutQuart
 * @option QuartInOut（急加減速） @value easeInOutQuart
 * @option QuintIn（非常に急な加速） @value easeInQuint
 * @option QuintOut（非常に急な減速） @value easeOutQuint
 * @option QuintInOut（激しい加減速） @value easeInOutQuint
 * @option SineIn（なめらかな始まり） @value easeInSine
 * @option SineOut（なめらかな終わり） @value easeOutSine
 * @option SineInOut（なめらかな加減速） @value easeInOutSine
 * @option ExpoIn（急激に速くなる） @value easeInExpo
 * @option ExpoOut（急激に遅くなる） @value easeOutExpo
 * @option ExpoInOut（極端な加減速） @value easeInOutExpo
 * @option CircIn（円弧のような加速） @value easeInCirc
 * @option CircOut（円弧のような減速） @value easeOutCirc
 * @option CircInOut（円弧的な加減速） @value easeInOutCirc
 * @option BackIn（少し戻ってから加速） @value easeInBack
 * @option BackOut（終わりに少し戻る） @value easeOutBack
 * @option BackInOut（前後に跳ねるような動き） @value easeInOutBack
 * @option ElasticIn（バネのように跳ねて加速） @value easeInElastic
 * @option ElasticOut（バネのように跳ねて減速） @value easeOutElastic
 * @option ElasticInOut（バネのように前後に跳ねる） @value easeInOutElastic
 * @option BounceIn（バウンドしながら加速） @value easeInBounce
 * @option BounceOut（バウンドしながら減速） @value easeOutBounce
 * @option BounceInOut（前後にバウンドする動き） @value easeInOutBounce
 * @default easeOutQuad
 */

(() => {
  //=============================================================================
  // 共通関数
  //=============================================================================

  "use strict";
  const parameters = PluginManager.parameters("OnevASSISTANT");
  const _origIsFastForward = Scene_Map.prototype.isFastForward;
  function safeJsonParse(jsonString, defaultValue = null) {
    if (!jsonString || jsonString.trim() === "") {
      return defaultValue;
    }
    try {
      return JSON.parse(jsonString);
    } catch (error) {
      console.error("JSON解析エラー:", error);
      console.error("解析対象:", jsonString);
      return defaultValue;
    }
  }

  function getPluginParameter(pluginName, key, defaultValue = undefined) {
    const param = PluginManager.parameters(pluginName)[key];
    return param !== undefined ? param : defaultValue;
  }

  function parseDeep(input) {
    function deepParse(val) {
      if (typeof val !== "string") return val;
      try {
        const parsed = JSON.parse(val);
        return deepParse(parsed);
      } catch {
        return val;
      }
    }

    if (!input) return [];
    try {
      const top = typeof input === "string" ? JSON.parse(input) : input;
      return Array.isArray(top)
        ? top.map((entry) => deepParse(entry))
        : deepParse(top);
    } catch (e) {
      console.warn("parseDeep エラー:", e, input);
      return [];
    }
  }

  function loadDataFile(filename) {
    return new Promise((resolve) => {
      resolve([]);
    });
  }

  async function loadMultipleDataFiles(filenames) {
    const promises = filenames.map((filename) =>
      loadDataFile(filename).catch((error) => {
        console.warn(`ファイル ${filename}.json の読み込みに失敗:`, error);
        return null;
      })
    );

    const results = await Promise.all(promises);
    const data = {};
    filenames.forEach((filename, index) => {
      if (results[index] !== null) {
        data[filename] = results[index];
      }
    });
    return data;
  }

  const dataCache = new Map();
  async function loadDataFileWithCache(filename) {
    if (dataCache.has(filename)) {
      return dataCache.get(filename);
    }

    const data = await loadDataFile(filename);
    dataCache.set(filename, data);
    return data;
  }

  function checkSwitches(switchArray, requiredState) {
    if (!Array.isArray(switchArray)) return true;
    return switchArray.every((id) => $gameSwitches.value(id) === requiredState);
  }

  function normalizeOperator(op) {
    switch (op) {
      case "==":
      case "等しい（==）":
        return "==";
      case "!=":
      case "等しくない（!=）":
        return "!=";
      case ">=":
      case "以上（>=）":
        return ">=";
      case "<=":
      case "以下（<=）":
        return "<=";
      case ">":
      case "より大きい（>）":
        return ">";
      case "<":
      case "より小さい（<）":
        return "<";
      default:
        return "==";
    }
  }

  function checkVariables(variableArray) {
    if (!Array.isArray(variableArray)) return true;

    return variableArray.every((cond) => {
      const id = Number(cond.id ?? cond.Id ?? 0);
      const rawOp = cond.op ?? cond.Operator ?? "==";
      const cmp = Number(cond.value ?? cond.Value ?? 0);

      const op = normalizeOperator(rawOp);
      const v = $gameVariables.value(id);

      switch (op) {
        case "==":
          return v == cmp;
        case "!=":
          return v != cmp;
        case ">=":
          return v >= cmp;
        case "<=":
          return v <= cmp;
        case ">":
          return v > cmp;
        case "<":
          return v < cmp;
        default:
          return true;
      }
    });
  }

  function norm(s) {
    return (s || "").toLowerCase().replace(/\s+/g, "");
  }

  function getNonTransparentBounds(bitmap) {
    const w = bitmap.width;
    const h = bitmap.height;
    const ctx = bitmap._context;
    if (!ctx) return null;

    const imageData = ctx.getImageData(0, 0, w, h).data;

    let minX = w,
      minY = h,
      maxX = 0,
      maxY = 0;
    let hasVisible = false;

    for (let y = 0; y < h; y++) {
      for (let x = 0; x < w; x++) {
        const i = (y * w + x) * 4;
        const alpha = imageData[i + 3];
        if (alpha > 10) {
          hasVisible = true;
          if (x < minX) minX = x;
          if (y < minY) minY = y;
          if (x > maxX) maxX = x;
          if (y > maxY) maxY = y;
        }
      }
    }

    if (!hasVisible) return null;

    return {
      x: minX,
      y: minY,
      width: maxX - minX + 1,
      height: maxY - minY + 1,
    };
  }

  function isUserTryingFastForward(sceneInstance) {
    return _origIsFastForward.call(sceneInstance);
  }

  //=============================================================================
  // 共通イージング
  //=============================================================================

  const Easing = {
    linear: (t) => t,
    easeInQuad: (t) => t * t,
    easeOutQuad: (t) => t * (2 - t),
    easeInOutQuad: (t) => (t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t),
    easeInCubic: (t) => t * t * t,
    easeOutCubic: (t) => --t * t * t + 1,
    easeInOutCubic: (t) =>
      t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1,
    easeInQuart: (t) => t * t * t * t,
    easeOutQuart: (t) => 1 - --t * t * t * t,
    easeInOutQuart: (t) =>
      t < 0.5 ? 8 * t * t * t * t : 1 - 8 * --t * t * t * t,
    easeInQuint: (t) => t * t * t * t * t,
    easeOutQuint: (t) => 1 + --t * t * t * t * t,
    easeInOutQuint: (t) =>
      t < 0.5 ? 16 * t * t * t * t * t : 1 + 16 * --t * t * t * t * t,
    easeInSine: (t) => 1 - Math.cos((t * Math.PI) / 2),
    easeOutSine: (t) => Math.sin((t * Math.PI) / 2),
    easeInOutSine: (t) => -(Math.cos(Math.PI * t) - 1) / 2,
    easeInExpo: (t) => (t === 0 ? 0 : Math.pow(2, 10 * (t - 1))),
    easeOutExpo: (t) => (t === 1 ? 1 : 1 - Math.pow(2, -10 * t)),
    easeInOutExpo: (t) =>
      t === 0
        ? 0
        : t === 1
        ? 1
        : t < 0.5
        ? Math.pow(2, 20 * t - 10) / 2
        : (2 - Math.pow(2, -20 * t + 10)) / 2,
    easeInCirc: (t) => 1 - Math.sqrt(1 - t * t),
    easeOutCirc: (t) => Math.sqrt(1 - --t * t),
    easeInOutCirc: (t) =>
      t < 0.5
        ? (1 - Math.sqrt(1 - 4 * t * t)) / 2
        : (Math.sqrt(1 - 4 * --t * t) + 1) / 2,
    easeInBack: (t) => {
      const c1 = 1.70158;
      const c3 = c1 + 1;
      return c3 * t * t * t - c1 * t * t;
    },
    easeOutBack: (t) => {
      const c1 = 1.70158;
      const c3 = c1 + 1;
      return 1 + c3 * --t * t * t + c1 * t * t;
    },
    easeInOutBack: (t) => {
      const c1 = 1.70158;
      const c2 = c1 * 1.525;
      return t < 0.5
        ? (Math.pow(2 * t, 2) * ((c2 + 1) * 2 * t - c2)) / 2
        : (Math.pow(2 * t - 2, 2) * ((c2 + 1) * (t * 2 - 2) + c2) + 2) / 2;
    },
    easeInElastic: (t) => {
      if (t === 0) return 0;
      if (t === 1) return 1;
      return (
        -Math.pow(2, 10 * t - 10) *
        Math.sin((t * 10 - 10.75) * ((2 * Math.PI) / 3))
      );
    },
    easeOutElastic: (t) => {
      if (t === 0) return 0;
      if (t === 1) return 1;
      return (
        Math.pow(2, -10 * t) * Math.sin((t * 10 - 0.75) * ((2 * Math.PI) / 3)) +
        1
      );
    },
    easeInOutElastic: (t) => {
      if (t === 0) return 0;
      if (t === 1) return 1;
      const c = (2 * Math.PI) / 4.5;
      return t < 0.5
        ? -(Math.pow(2, 20 * t - 10) * Math.sin((20 * t - 11.125) * c)) / 2
        : (Math.pow(2, -20 * t + 10) * Math.sin((20 * t - 11.125) * c)) / 2 + 1;
    },
    easeInBounce: (t) => 1 - Easing.easeOutBounce(1 - t),
    easeOutBounce: (t) => {
      const n1 = 7.5625,
        d1 = 2.75;
      if (t < 1 / d1) {
        return n1 * t * t;
      } else if (t < 2 / d1) {
        return n1 * (t -= 1.5 / d1) * t + 0.75;
      } else if (t < 2.5 / d1) {
        return n1 * (t -= 2.25 / d1) * t + 0.9375;
      } else {
        return n1 * (t -= 2.625 / d1) * t + 0.984375;
      }
    },
    easeInOutBounce: (t) =>
      t < 0.5
        ? (1 - Easing.easeOutBounce(1 - 2 * t)) / 2
        : (1 + Easing.easeOutBounce(2 * t - 1)) / 2,
  };

  function applyHoverEffect(sprite, config, onHoverImageChange) {
    if (!sprite || !config) return;
    if (config.UseScale && config.Scale) {
      sprite.scale.x = sprite.scale.y = config.Scale / 100;
    }

    if (config.UseOffset) {
      sprite.x += config.OffsetX || 0;
      sprite.y += config.OffsetY || 0;
    }
    if (config.UseFrame && config.FrameImage) {
      if (typeof config.onFrameImage === "function") {
        config.onFrameImage(sprite, config.FrameImage);
      }
    }

    if (config.ExtraImageSetting && onHoverImageChange) {
      onHoverImageChange(config.ExtraImageSetting);
    }
  }

  function findNearestChoiceIndex(choices, currentIndex, direction) {
    if (!choices || choices.length === 0) return currentIndex;
    const cx = choices[currentIndex].x;
    const cy = choices[currentIndex].y;
    const dirs = {
      up: { x: 0, y: -1 },
      down: { x: 0, y: 1 },
      left: { x: -1, y: 0 },
      right: { x: 1, y: 0 },
    };
    const dirVec = dirs[direction];
    if (!dirVec) return currentIndex;
    let bestIndex = -1;
    let bestScore = Infinity;
    for (let i = 0; i < choices.length; i++) {
      if (i === currentIndex) continue;
      const tx = choices[i].x;
      const ty = choices[i].y;
      const dx = tx - cx;
      const dy = ty - cy;
      const dot = dx * dirVec.x + dy * dirVec.y;
      if (dot <= 0) continue;
      const absDx = Math.abs(dx);
      const absDy = Math.abs(dy);
      if ((direction === "up" || direction === "down") && absDy < absDx * 0.6)
        continue;
      if (
        (direction === "left" || direction === "right") &&
        absDx < absDy * 0.6
      )
        continue;
      const distSq = dx * dx + dy * dy;
      if (distSq < bestScore) {
        bestScore = distSq;
        bestIndex = i;
      }
    }
    return bestIndex >= 0 ? bestIndex : currentIndex;
  }

  function getMousePosition() {
    return { x: TouchInput.x, y: TouchInput.y };
  }

  function isMouseOverChoice(choice, mousePos) {
    if (!choice || !mousePos) return false;
    const rect = OnevASSISTANT.getHoverHitRect
      ? OnevASSISTANT.getHoverHitRect(choice)
      : null;
    if (!rect) return false;
    return (
      mousePos.x >= rect.left &&
      mousePos.x <= rect.right &&
      mousePos.y >= rect.top &&
      mousePos.y <= rect.bottom
    );
  }

  function getWheelInput(direction, continuous = false) {
    if (!TouchInput.wheelY) return false;

    const wheelY = TouchInput.wheelY;

    if (direction === "up" && wheelY < 0) {
      return true;
    } else if (direction === "down" && wheelY > 0) {
      return true;
    }

    return false;
  }

  function getWheelInputContinuous(direction) {
    return getWheelInput(direction, true);
  }

  function getWheelInputTrigger(direction) {
    return getWheelInput(direction, false);
  }

  window.OnevASSISTANT = window.OnevASSISTANT || {};
  Object.assign(window.OnevASSISTANT, {
    safeJsonParse,
    parseDeep,
    loadDataFile,
    checkSwitches,
    checkVariables,
    applyHoverEffect,
    findNearestChoiceIndex,
    getMousePosition,
    isMouseOverChoice,
    getWheelInput,
    getWheelInputContinuous,
    getWheelInputTrigger,
    getPluginParameter,
    norm,
    Easing,
    isUserTryingFastForward,
  });

  (() => {
    //======================================================================
    // タイトル画面
    //======================================================================

    "use strict";
    const TitleSettings = window.OnevASSISTANT.safeJsonParse(
      window.OnevASSISTANT.getPluginParameter("OnevASSISTANT", "TitleSettings"),
      {}
    );
    const useCustomTitle =
      TitleSettings.UseCustomTitle === "true" ||
      TitleSettings.UseCustomTitle === true;

    if (!useCustomTitle) return;

    const ShowTitleText = TitleSettings["ShowGameTitle"] !== "false";
    const TitleBg = TitleSettings["BackgroundImage"] || "";
    const TitleChoiceBaseX = Number(TitleSettings["ChoiceXBase"] || 0);
    const TitleChoiceBaseY = Number(TitleSettings["ChoiceYBase"] || 0);
    const TitleChoices = window.OnevASSISTANT.parseDeep(
      TitleSettings["Choices"] || "[]"
    ).map((obj) => {
      const hover = window.OnevASSISTANT.safeJsonParse(obj.HoverEffect, {});

      const extraStr = hover.ExtraImageSetting;
      const extraObj = extraStr
        ? window.OnevASSISTANT.safeJsonParse(extraStr, {})
        : hover.ExtraImageSetting || null;

      obj.HoverEffect = {
        UseScale: hover.UseScale === true || hover.UseScale === "true",
        UseOffset: hover.UseOffset === true || hover.UseOffset === "true",
        UseFrame: hover.UseFrame === true || hover.UseFrame === "true",
        FrameImage: hover.FrameImage,
        OffsetX: Number(hover.OffsetX || 0),
        OffsetY: Number(hover.OffsetY || 0),
        Scale: Number(hover.Scale || 100),
        ExtraImageSetting: extraObj,
      };
      return obj;
    });

    const TitleCursorCfg = window.OnevASSISTANT.safeJsonParse(
      TitleSettings["CursorConfig"],
      {}
    );
    const TitleCurImg = TitleCursorCfg.Image || "";
    const TitleCurOffX = Number(TitleCursorCfg.OffsetX || 0);
    const TitleCurOffY = Number(TitleCursorCfg.OffsetY || 0);

    const TitleCursorSe = window.OnevASSISTANT.safeJsonParse(
      TitleSettings["CursorSelectSE"],
      null
    );
    const TitleOkSe = window.OnevASSISTANT.safeJsonParse(
      TitleSettings["CursorOkSE"],
      null
    );
    const TitleBgm = window.OnevASSISTANT.safeJsonParse(
      TitleSettings["TitleBGM"],
      null
    );
    const DummyMapId = Number(
      window.OnevASSISTANT.getPluginParameter("OnevASSISTANT", "DummyMapId") ||
        2
    );
    const DummyMapX = 1;
    const DummyMapY = 1;

    const _Scene_Title_createBackground =
      Scene_Title.prototype.createBackground;
    Scene_Title.prototype.createBackground = function () {
      _Scene_Title_createBackground.call(this);
      if (TitleBg) {
        this._backSprite1.bitmap = ImageManager.loadBitmap(
          "img/titles1/",
          TitleBg
        );
      }
    };

    Scene_Title.prototype.drawGameTitle = function () {
      if (!ShowTitleText) return;
      const x = 20;
      const y = Graphics.height / 4;
      const maxWidth = Graphics.width - x * 2;
      const text = $dataSystem.gameTitle;
      const sprite = new Sprite(new Bitmap(Graphics.width, Graphics.height));
      sprite.bitmap.outlineColor = "black";
      sprite.bitmap.outlineWidth = 8;
      sprite.bitmap.fontSize = 48;
      sprite.bitmap.drawText(text, x, y, maxWidth, 48, "center");
      this.addChild(sprite);
    };

    Scene_Title.prototype.createCommandWindow = function () {
      this._slIcons = [];
      this._slFrames = [];
      this._slExtras = [];
      this._slDisabled = [];
      this._slIndex = 0;
      this._inputMode = "keyboard";
      const initPos = window.OnevASSISTANT.getMousePosition();
      this._lastMouseX = initPos.x;
      this._lastMouseY = initPos.y;

      const hasSaveFile = DataManager.isAnySavefileExists();

      for (var i = 0; i < TitleChoices.length; i++) {
        var c = TitleChoices[i];
        var switchId = Number(c.ShowSwitch || 0);
        if (
          switchId > 0 &&
          !window.OnevASSISTANT.checkSwitches([switchId], true)
        ) {
          this._slIcons[i] = null;
          this._slFrames[i] = null;
          this._slDisabled[i] = false;
          continue;
        }
        var sp = new Sprite(ImageManager.loadBitmap("img/choice/", c.Image));
        sp.anchor.set(0.5, 0.5);
        sp.x = TitleChoiceBaseX + Number(c.X || 0);
        sp.y = TitleChoiceBaseY + Number(c.Y || 0);
        sp.scale.x = sp.scale.y = Number(c.Scale || 100) / 100;

        var isDisabled = c.Action === "continue" && !hasSaveFile;
        this._slDisabled[i] = isDisabled;

        sp._baseX = sp.x;
        sp._baseY = sp.y;
        sp._baseScale = sp.scale.x;
        (function initStaticHitRect(sprite) {
          const ax = sprite.anchor.x || 0;
          const ay = sprite.anchor.y || 0;
          const w = sprite.width || (sprite.bitmap && sprite.bitmap.width) || 0;
          const h =
            sprite.height || (sprite.bitmap && sprite.bitmap.height) || 0;
          const left = sprite._baseX - w * ax;
          const top = sprite._baseY - h * ay;
          sprite._hitLeft = left;
          sprite._hitTop = top;
          sprite._hitRight = left + w;
          sprite._hitBottom = top + h;
        })(sp);

        sp.targetX = sp.x;
        sp.y = sp.y;
        sp.targetScale = sp.scale.x;

        this.addChild(sp);
        this._slIcons[i] = sp;

        const hover = c.HoverEffect || {};
        if (hover.UseFrame && hover.FrameImage) {
          const fr = new Sprite(
            ImageManager.loadBitmap("img/choice/", hover.FrameImage)
          );
          fr.anchor.set(0.5, 0.5);
          fr.x = sp.x;
          fr.y = sp.y;
          fr.visible = false;
          this.addChild(fr);
          this._slFrames[i] = fr;
        } else {
          this._slFrames[i] = null;
        }

        const extra = hover.ExtraImageSetting;
        if (extra && extra.Image) {
          const ex = new Sprite(
            ImageManager.loadBitmap("img/choice/", extra.Image)
          );
          ex.anchor.set(0.5, 0.5);
          ex.x = sp.x + Number(extra.X || 0);
          ex.y = sp.y + Number(extra.Y || 0);
          ex.scale.x = ex.scale.y = sp.scale.x;
          ex.visible = false;
          this.addChild(ex);
          this._slExtras[i] = ex;
        } else {
          this._slExtras[i] = null;
        }
      }

      const extra = c.HoverEffect.ExtraImageSetting;
      if (extra && extra.Image) {
        const exSp = new Sprite(
          ImageManager.loadBitmap("img/choice/", extra.Image)
        );
        exSp.anchor.set(0.5, 0.5);
        exSp.x = sp.x + extra.X;
        exSp.y = sp.y + extra.Y;
        exSp.scale.set(sp.scale.x, sp.scale.y);
        exSp.visible = false;
        this.addChild(exSp);
        this._slExtras[i] = exSp;
      } else {
        this._slExtras[i] = null;
      }

      if (TitleCurImg) {
        this._slCursor = new Sprite(
          ImageManager.loadBitmap("img/choice/", TitleCurImg)
        );
        this._slCursor.anchor.set(0.5, 0.5);
        this.addChild(this._slCursor);
      }

      this._slIndex = this._findFirstEnabledIndex();

      this._updateSlChoice();
      this.children = this.children.filter((sp) => !sp._onevHoverExtra);
    };

    Scene_Title.prototype._findFirstEnabledIndex = function () {
      for (let i = 0; i < this._slIcons.length; i++) {
        if (this._slIcons[i] && !this._slDisabled[i]) {
          return i;
        }
      }
      return 0;
    };

    Scene_Title.prototype._findNextEnabledIndex = function (currentIndex, direction) {
      const step = direction === "down" ? 1 : -1;
      const len = this._slIcons.length;
      let index = currentIndex;
      for (let i = 0; i < len; i++) {
        index = (index + step + len) % len;
        if (this._slIcons[index] && !this._slDisabled[index]) {
          return index;
        }
      }
      return currentIndex; 
    };

    Scene_Title.prototype.update = function () {
      Scene_Base.prototype.update.call(this);
      if (!this._slIcons) return;

      const mousePos = window.OnevASSISTANT.getMousePosition();
      if (this._lastMouseX !== mousePos.x || this._lastMouseY !== mousePos.y) {
        this._inputMode = "mouse";
        this._lastMouseX = mousePos.x;
        this._lastMouseY = mousePos.y;
      }

      const t = 0.2;

      for (let i = 0; i < this._slIcons.length; i++) {
        const sp = this._slIcons[i];
        if (!sp) continue;

        const item = TitleChoices[i];
        const hover = Object.assign({}, item.HoverEffect || {});
        hover.UseFrame = false;
        delete hover.ExtraImageSetting;
        hover.UseScale = hover.UseScale === true || hover.UseScale === "true";
        hover.UseOffset =
          hover.UseOffset === true || hover.UseOffset === "true";
        hover.UseFrame = hover.UseFrame === true || hover.UseFrame === "true";

        const isSelected = i === this._slIndex;
        const isDisabled = this._slDisabled && this._slDisabled[i];

        if (!isDisabled) {
          window.OnevASSISTANT.applyHoverEffect(sp, hover);
        }

        sp.targetX =
          sp._baseX + (isSelected && hover.UseOffset && !isDisabled ? hover.OffsetX || 0 : 0);
        sp.y =
          sp._baseY + (isSelected && hover.UseOffset && !isDisabled ? hover.OffsetY || 0 : 0);
        sp.targetScale =
          isSelected && hover.UseScale && !isDisabled
            ? (hover.Scale || 100) / 100
            : sp._baseScale;

        sp.x += (sp.targetX - sp.x) * t;
        sp.scale.x += (sp.targetScale - sp.scale.x) * t;
        sp.scale.y += (sp.targetScale - sp.scale.y) * t;

        const fr = this._slFrames[i];
        if (fr) {
          fr.visible = isSelected && hover.UseFrame && !isDisabled;
          fr.x = sp.x;
          fr.y = sp.y;
          fr.scale.x = sp.scale.x;
          fr.scale.y = sp.scale.y;
        }

        const ex = this._slExtras[i];
        if (ex) {
          ex.visible = isSelected && !isDisabled;
          ex.x = Number(item.HoverEffect.ExtraImageSetting.X || 0);
          ex.y = Number(item.HoverEffect.ExtraImageSetting.Y || 0);
          ex.scale.x = sp.scale.x;
          ex.scale.y = sp.scale.y;
        }
      }

      if (!this._slChoiceLocked && (Input.isRepeated("down") || Input.isRepeated("up"))) {
        const dir = Input.isRepeated("down") ? "down" : "up";
        let newIndex = window.OnevASSISTANT.findNearestChoiceIndex(
          this._slIcons
            .map((sp, i) => (sp ? { x: sp.x, y: sp.y, _idx: i } : null))
            .filter(Boolean),
          this._slIndex,
          dir
        );
        if (this._slDisabled && this._slDisabled[newIndex]) {
          newIndex = this._findNextEnabledIndex(newIndex, dir);
        }
        this._slIndex = newIndex;
        this._inputMode = "keyboard";
        if (TitleCursorSe && TitleCursorSe.name)
          AudioManager.playSe(TitleCursorSe);
      }

      if (Input.isTriggered("ok")) {
        this._onSlChoiceClick(this._slIndex);
      }

      if (!this._slChoiceLocked && this._inputMode === "mouse") {
        for (let i = 0; i < this._slIcons.length; i++) {
          const sp = this._slIcons[i];
          if (!sp || !sp.bitmap || !sp.bitmap.isReady()) continue;
          if (this._slDisabled && this._slDisabled[i]) continue;
          const w = sp.bitmap.width * sp.scale.x;
          const h = sp.bitmap.height * sp.scale.y;
          const left = sp.x - w * 0.5;
          const top = sp.y - h * 0.5;
          if (
            mousePos.x >= left &&
            mousePos.x <= left + w &&
            mousePos.y >= top &&
            mousePos.y <= top + h
          ) {
            if (this._slIndex !== i) {
              this._slIndex = i;
              if (TitleCursorSe && TitleCursorSe.name)
                AudioManager.playSe(TitleCursorSe);
            }
            break;
          }
        }
      }
      if (!this._slChoiceLocked && TouchInput.isTriggered()) {
        const mouse = window.OnevASSISTANT.getMousePosition();
        for (let i = 0; i < this._slIcons.length; i++) {
          const sp = this._slIcons[i];
          if (!sp || !sp.bitmap || !sp.bitmap.isReady()) continue;
          const w = sp.bitmap.width * sp.scale.x;
          const h = sp.bitmap.height * sp.scale.y;
          const left = sp.x - w * 0.5;
          const top = sp.y - h * 0.5;
          if (
            mouse.x >= left &&
            mouse.x <= left + w &&
            mouse.y >= top &&
            mouse.y <= top + h
          ) {
            this._onSlChoiceClick(i);
            break;
          }
        }
      }

      this._updateSlChoice();

      if (this._pendingCommonEventId && DataManager.isMapLoaded()) {
        $gameSystem = new Game_System();
        $gameScreen = new Game_Screen();
        $gameTimer = new Game_Timer();
        $gameMessage = new Game_Message();
        $gameSwitches = new Game_Switches();
        $gameVariables = new Game_Variables();
        $gameSelfSwitches = new Game_SelfSwitches();
        $gameActors = new Game_Actors();
        $gameParty = new Game_Party();
        $gameTroop = new Game_Troop();
        $gameMap = new Game_Map();
        $gamePlayer = new Game_Player();

        $gameParty.setupStartingMembers();
        $gameMap.setup(this._pendingMapId);
        $gamePlayer.reserveTransfer(
          this._pendingMapId,
          this._pendingMapX,
          this._pendingMapY,
          2,
          0
        );
        $gamePlayer.refresh();
        $gamePlayer.setTransparent(true);
        $gameScreen.startFadeOut(0);
        $gameTemp.reserveCommonEvent(this._pendingCommonEventId);
        this._pendingCommonEventId = null;
        SceneManager.goto(Scene_Map);
      }
    };

    const TitleCurPos = TitleCursorCfg.Position || "left";

    Scene_Title.prototype._updateSlChoice = function () {
      var idx = this._slIndex;
      this._slFrames.forEach(function (fr, i) {
        if (fr) fr.visible = i === idx;
      });

      if (this._slCursor && this._slIcons[idx]) {
        var sp = this._slIcons[idx];
        var cursorX = sp.x;
        var bw = sp.bitmap ? sp.bitmap.width * sp.scale.x : 0;

        switch (TitleCurPos) {
          case "left":
            cursorX = sp.x - bw / 2;
            break;
          case "right":
            cursorX = sp.x + bw / 2;
            break;
          case "center":
          default:
            cursorX = sp.x;
            break;
        }

        this._slCursor.x = cursorX + TitleCurOffX;
        this._slCursor.y = sp.y + TitleCurOffY;
        this._slCursor.visible = true;
      }
    };

    Scene_Title.prototype._onSlChoiceClick = function (index) {
      if (this._slChoiceLocked) return;
      if (this._slDisabled && this._slDisabled[index]) {
        SoundManager.playBuzzer();
        return;
      }
      this._slChoiceLocked = true;
      var item = TitleChoices[index];
      if (!item || !item.Action) return;

      if (TitleOkSe && TitleOkSe.name) AudioManager.playSe(TitleOkSe);

      switch (item.Action) {
        case "newGame":
          DataManager.setupNewGame();
          this.fadeOutAll();
          SceneManager.goto(Scene_Map);
          break;
        case "continue":
          TouchInput.clear();
          SceneManager.push(Scene_Load);
          break;
        case "options":
          TouchInput.clear();
          SceneManager.push(Scene_Options);
          break;
        case "gameend":
          SceneManager.exit();
          break;
        case "commonEvent": {
          //console.log('予約するマップID:', DummyMapId);
          //console.log('予約するイベントID:', item.CommonEventId);
          console.trace();
          const id = Number(item.CommonEventId || 0);
          if (id > 0) {
            this.fadeOutAll();
            $gameScreen._brightness = 0;
            $gameTemp._adminInterceptorType = null;
            this._pendingCommonEventId = Number(item.CommonEventId || 0);
            this._pendingCommonEventId = id;
            this._pendingMapId = DummyMapId;
            this._pendingMapX = DummyMapX;
            this._pendingMapY = DummyMapY;

            DataManager.loadMapData(DummyMapId);
          }
          break;
        }

        default:
          console.warn("未定義の Action:", item.Action);
      }
    };

    Scene_Title.prototype.playTitleMusic = function () {
      if (TitleBgm && TitleBgm.name) {
        AudioManager.playBgm({
          name: TitleBgm.name,
          volume: Number(TitleBgm.volume || 90),
          pitch: Number(TitleBgm.pitch || 100),
          pan: Number(TitleBgm.pan || 0),
        });
      } else {
        AudioManager.playBgm($dataSystem.titleBgm);
      }
    };

    const _Scene_Title_start = Scene_Title.prototype.start;
    Scene_Title.prototype.start = function () {
      this._slChoiceLocked = false;
      if (
        typeof utakata !== "undefined" &&
        utakata.CommonSaveManager &&
        utakata.CommonSaveManager.load
      ) {
        utakata.CommonSaveManager.load();
      }
      _Scene_Title_start.call(this);
    };

    Scene_Title.prototype.isBusy = function () {
      return Scene_Base.prototype.isBusy.call(this);
    };

    if (useCustomTitle) {
      Window_TitleCommand.prototype.makeCommandList = function () {};
    }

    (function () {
      const _Game_Interpreter_setupReservedCommonEvent =
        Game_Interpreter.prototype.setupReservedCommonEvent;
      Game_Interpreter.prototype.setupReservedCommonEvent = function () {
        const result = _Game_Interpreter_setupReservedCommonEvent.call(this);
        if (result) {
          if ($gameMap.mapId && $gameMap.mapId() === DummyMapId) {
            $gameScreen._brightness = 0;
          }
        }
        return result;
      };
    })();
  })();

  (() => {
    //======================================================================
    // UI表示関連
    //======================================================================

    "use strict";
    const _SM_start = Scene_Map.prototype.start;
    Scene_Map.prototype.start = function () {
      _SM_start.call(this);
      $gameSystem.getCustomUIs().forEach((uiName) => {
        OnevASSISTANT.createUI(uiName);
      });
    };
    const _SMn_terminate = Scene_Menu.prototype.terminate;
    Scene_Menu.prototype.terminate = function () {  
      _SMn_terminate.call(this);
      OnevASSISTANT.redrawAllUI();
    };

    const SPRITE_PRIORITIES = {
      IMAGE: 0,
      GAUGE: 100,
      TEXT: 200,
      NUMBER: 300,
    };

    OnevASSISTANT.clickCooldown = 100;//コモンイベント実行時のクールタイム
    OnevASSISTANT.lastClickTime = 0;
    OnevASSISTANT._forceHideAll = false;
    OnevASSISTANT._lastCommonEventId = null;

    window.OnevASSISTANT = window.OnevASSISTANT || {};
    OnevASSISTANT._dragInfo = OnevASSISTANT._dragInfo || {};
    OnevASSISTANT._activeSprites = OnevASSISTANT._activeSprites || {};
    OnevASSISTANT._activeUINames = OnevASSISTANT._activeUINames || new Set();
    const uiConfigs = OnevASSISTANT.parseDeep(parameters["UIConfigs"]);
    const testConfig = uiConfigs[0];
    window.OnevASSISTANT._activeUINames = new Set();
    OnevASSISTANT._activeSprites = OnevASSISTANT._activeSprites || {};

    const _GS_initialize = Game_System.prototype.initialize;

    Game_System.prototype._uiPositions = {};

    Game_System.prototype.setUIPosition = function (name, x, y) {
      this._uiPositions = this._uiPositions || {};
      this._uiPositions[name] = { x, y };
    };

    Game_System.prototype.getUIPosition = function (name) {
      this._uiPositions = this._uiPositions || {};
      return this._uiPositions[name] || null;
    };

    Game_System.prototype.initialize = function () {
      _GS_initialize.call(this);
      this._activeUIs = [];
    };

    Game_System.prototype.removeCustomUI = function (name) {
      this._activeUIs = this._activeUIs || [];
      const idx = this._activeUIs.indexOf(name);
      if (idx >= 0) {
        this._activeUIs.splice(idx, 1);
      }
    };

    Game_System.prototype.clearCustomUIs = function () {
      this._activeUIs = [];
    };

    Game_System.prototype.removeCustomUI = function (name) {
      this._activeUIs = this._activeUIs || [];
      const idx = this._activeUIs.indexOf(name);
      if (idx >= 0) {
        this._activeUIs.splice(idx, 1);
      }
    };

    Game_System.prototype.clearCustomUIs = function () {
      this._activeUIs = [];
    };

    Game_System.prototype.showCustomUI = function (name) {
      this._activeUIs = this._activeUIs || [];
      if (!this._activeUIs.includes(name)) {
        this._activeUIs.push(name);
      }
    };

    Game_System.prototype.getCustomUIs = function () {
      return this._activeUIs || [];
    };

    window.testConfig = testConfig;
    console.log("UIConfig[0] を window.testConfig に出力：", testConfig);

    OnevASSISTANT.createUI = function (name) {
      if (OnevASSISTANT._activeUINames.has(name)) {
        const pc = SceneManager._scene?._spriteset?._pictureContainer;
        const old = OnevASSISTANT._activeSprites[name];

        if (!old || old.parent !== pc) {
          if (old && old.parent) old.parent.removeChild(old);
          delete OnevASSISTANT._activeSprites[name];
          OnevASSISTANT._activeUINames.delete(name);
        } else {
          console.log(`[SKIP] UI「${name}」は既に存在します`);
          return;
        }
      }
      const configs = OnevASSISTANT.parseDeep(parameters["UIConfigs"]);
      const target = configs.find((c) => c.Name === name);
      if (!target) {
        console.warn(`UI名「${name}」が見つかりません`);
        return;
      }

      OnevASSISTANT._activeUINames.add(name);
      $gameSystem.showCustomUI(name);

      const base = OnevASSISTANT.safeJsonParse(target.UIbaseSettings);
      if (!base || !base.Baseimage) {
        console.warn(`UI「${name}」の base画像設定が無効`);
        return;
      }

      const sprite = new Sprite(
        ImageManager.loadBitmap("img/UI/", base.Baseimage)
      );
      const pos = $gameSystem.getUIPosition(name);
      sprite.x = Number(pos?.x || target.X || 0);
      sprite.y = Number(pos?.y || target.Y || 0);
      sprite.z = Number(target.PictureId || 50);
      sprite._onevUIName = name;

      const imageSprites = OnevASSISTANT.createAndAttachImageSprites(
        sprite,
        target.ImageSprites,
        []
      );
      sprite._onevImageChildren = imageSprites;

      const switchId = Number(base.EnableSwitchId || 0);
      if (switchId > 0) {
        OnevASSISTANT._dragInfo[name] = {
          sprite: sprite,
          switchId: switchId,
          dragging: false,
          offsetX: 0,
          offsetY: 0,
        };
      }

      const pc = SceneManager._scene._spriteset._pictureContainer;
      const idx = Math.max(0, Number(target.PictureId || 50) - 1);
      const safeIdx = Math.min(idx, pc.children.length);
      pc.addChildAt(sprite, safeIdx);

      OnevASSISTANT._activeSprites[name] = sprite;
      const choiceSpriteData = OnevASSISTANT.parseDeep(
        target.ChoiceSprites || "[]"
      );
      OnevASSISTANT.createChoiceSprites(sprite, choiceSpriteData);

      const gaugeDefs = OnevASSISTANT.parseDeep(target.GaugeSprites || "[]");
      const gaugeSprites = OnevASSISTANT.createGaugeSprites(sprite, gaugeDefs);
      sprite._onevGaugeChildren = gaugeSprites;
      console.log(`[${name}] ゲージスプライト作成: ${gaugeSprites.length} 件`);

      const numberDefs = OnevASSISTANT.parseDeep(target.NumberSprites || "[]");
      const numberSprites = OnevASSISTANT.createNumberSprites(
        sprite,
        numberDefs
      );
      sprite._onevNumberChildren = numberSprites;
      console.log(`[${name}] 数字スプライト作成: ${numberSprites.length} 件`);

      const textDefs = OnevASSISTANT.parseDeep(target.TextSprites || "[]");
      const textSprites = OnevASSISTANT.createTextSprites(sprite, textDefs);
      sprite._onevTextChildren = textSprites;
      console.log(`[${name}] テキストスプライト作成: ${textSprites.length} 件`);

      const activeIds = OnevASSISTANT.parseDeep(target.ActiveSwitchIds || []);
      activeIds.forEach((id) => {
        if (+id > 0) $gameSwitches.setValue(+id, true);
      });
    };

    OnevASSISTANT.updateNumberSprites = function () {
      for (const name of OnevASSISTANT._activeUINames) {
        const root = OnevASSISTANT._activeSprites[name];
        (root._onevNumberChildren || []).forEach((sp) => sp.update());
      }
    };

    OnevASSISTANT.updateTextSprites = function () {
      for (const name of OnevASSISTANT._activeUINames) {
        const root = OnevASSISTANT._activeSprites[name];
        (root._onevTextChildren || []).forEach((sp) => sp.update());
      }
    };

    OnevASSISTANT.createNumberSprites = function (parentSprite, defs) {
      const list = [];
      defs.forEach((cfg) => {
        const sp = new Sprite_NumberVariable(
          cfg,
          parentSprite.x,
          parentSprite.y
        );
        parentSprite.addChild(sp);
        list.push(sp);
      });
      return list;
    };

    OnevASSISTANT.createTextSprites = function (parentSprite, defs) {
      const list = [];
      defs.forEach((cfg) => {
        const sp = new Sprite_TextVariable(cfg, parentSprite.x, parentSprite.y);
        parentSprite.addChild(sp);
        list.push(sp);
      });
      return list;
    };

    window.OnevASSISTANT.resetLastClickedChoice = function () {
      OnevASSISTANT._lastCommonEventId = null;
    };

    OnevASSISTANT.createAndAttachImageSprites = function (
      parentSprite,
      imageSpriteData,
      storeArray = null
    ) {
      parentSprite.sortableChildren = true;
      const imageConfigs = [];

      try {
        const rawArray = JSON.parse(imageSpriteData || "[]");
        for (const entry of rawArray) {
          try {
            const cfg = JSON.parse(entry);
            imageConfigs.push(cfg);
          } catch (e) {
            console.warn("ImageSprites JSON破損:", entry, e);
          }
        }
      } catch (e) {
        console.error("ImageSprites 全体のパース失敗:", imageSpriteData, e);
      }

      const children = [];

      imageConfigs.forEach((cfg) => {
        const priority = Number(cfg.Priority || 0);
        const imgSp = new Sprite(ImageManager.loadBitmap("img/UI/", cfg.Image));
        imgSp.x = Number(cfg.OffsetX || 0);
        imgSp.y = Number(cfg.OffsetY || 0);
        imgSp.zIndex = priority;
        imgSp._fadeFrames = Number(cfg.FadeFrames || 0);
        imgSp._nextVisible = imgSp.visible;
        imgSp._targetVisible = imgSp.visible;
        imgSp._fadeTween = null;
        const showSwitch = Number(cfg.ShowSwitch || 0);
        const showVariable = Number(cfg.ShowVariable || 0);
        const op = normalizeOperator(cfg.ShowOperator || "==");
        const cmp = Number(cfg.ShowValue || 0);

        const okSwitch = showSwitch === 0 || $gameSwitches.value(showSwitch);
        const okVar =
          showVariable === 0 ||
          (() => {
            const v = $gameVariables.value(showVariable);
            switch (op) {
              case "==":
                return v == cmp;
              case "!=":
                return v != cmp;
              case ">=":
                return v >= cmp;
              case "<=":
                return v <= cmp;
              case ">":
                return v > cmp;
              case "<":
                return v < cmp;
              default:
                return true;
            }
          })();

        imgSp.visible = okSwitch && okVar;
        parentSprite.addChild(imgSp);
        children.push(imgSp);
      });

      if (storeArray) {
        storeArray.length = 0;
        storeArray.push(...children);
      }

      return children;
    };

    OnevASSISTANT.createChoiceSprites = function (parentSprite, choices) {
      console.log(
        `[${parentSprite._onevUIName}] 生の ChoiceSprites データ:`,
        choices
      );
      let list = [];
      try {
        const arr = typeof choices === "string" ? JSON.parse(choices) : choices;
        list = arr
          .map((entry) => {
            if (typeof entry === "string") {
              try {
                return JSON.parse(entry);
              } catch (e) {
                console.warn("ChoiceSprites のエントリパース失敗:", entry, e);
                return null;
              }
            }
            return entry;
          })
          .filter(Boolean);
      } catch (e) {
        console.error("ChoiceSprites 全体のパース失敗:", choices, e);
      }

      console.log(
        `[${parentSprite._onevUIName}] パース後の選択肢データ (${list.length}件):`,
        list
      );
      if (!list.length) return;

      const choiceSprites = [];
      list.forEach((choice, i) => {
        const width = Number(choice.Width || 200);
        const height = Number(choice.Height || 48);
        const text = choice.Text || `選択肢${i + 1}`;
        let content;
        if (choice.Image) {
          content = new Sprite(
            ImageManager.loadBitmap("img/UI/", choice.Image)
          );
        } else {
          const bmp = new Bitmap(width, height);
          bmp.fontSize = 22;
          bmp.drawText(text, 0, 0, width, height, "center");
          content = new Sprite(bmp);
        }
        content.anchor.set(0.5);
        const wrapper = new PIXI.Container();
        wrapper.addChild(content);
        content._originalX = 0;
        content._originalY = 0;
        Object.defineProperty(wrapper, "anchor", {
          get() {
            return content.anchor;
          },
        });

        wrapper.x = Number(choice.X || 0);
        wrapper.y = Number(choice.Y || 0);
        wrapper._originalX = wrapper.x;
        wrapper._originalY = wrapper.y;
        wrapper._choiceMeta = choice;
        wrapper._content = content;
        wrapper._fadeConfig = OnevASSISTANT.safeJsonParse(
          choice.FadeEffect || "{}"
        );
        wrapper._targetVisible = wrapper.visible;
        wrapper._nextVisible = wrapper.visible;
        wrapper._fadeTween = null;
        wrapper.alpha = wrapper.visible ? 1 : 0;
        wrapper._isHovered = false;
        wrapper._hoverState = "normal";
        wrapper.interactive = true;
        wrapper.buttonMode = true;
        wrapper.interactiveChildren = true;
        content.interactive = true;
        content.buttonMode = true;
        content.containsPoint = function (point) {
          const bmp = this.bitmap;
          if (!bmp || !bmp.isReady()) {
            return PIXI.Sprite.prototype.containsPoint.call(this, point);
          }
          const local = this.worldTransform.applyInverse(
            point,
            new PIXI.Point()
          );
          const w = this.width;
          const h = this.height;
          const left = -this.anchor.x * w;
          const top = -this.anchor.y * h;
          if (
            local.x < left ||
            local.x >= left + w ||
            local.y < top ||
            local.y >= top + h
          ) {
            return false;
          }
          const px = Math.floor(local.x + this.anchor.x * w);
          const py = Math.floor(local.y + this.anchor.y * h);
          const alpha = bmp.getAlphaPixel(px, py);
          return alpha > 0;
        };
        const onClick = () => {
          if (+choice.SwitchId) $gameSwitches.setValue(+choice.SwitchId, true);
          if (+choice.CommonEventId)
            $gameTemp.reserveCommonEvent(+choice.CommonEventId);
        };
        content
          .on("pointerdown", onClick)
          .on("pointerup", onClick)
          .on("tap", onClick)
          .on("click", onClick);
        if (String(wrapper._fadeConfig.UseFade) === "true") {
          wrapper.visible = false;
          wrapper.alpha = 0;
          wrapper._targetVisible = false;
          wrapper._nextVisible = false;
          wrapper._fadeTween = null;
        }
        Object.defineProperty(wrapper, "width", {
          get() {
            return content.width;
          },
        });
        Object.defineProperty(wrapper, "height", {
          get() {
            return content.height;
          },
        });
        parentSprite.addChild(wrapper);

        const showCond = OnevASSISTANT.safeJsonParse(
          wrapper._choiceMeta.ShowCondition || "{}"
        );
        let shouldShow = true;

        if (
          +showCond.SwitchId > 0 &&
          !$gameSwitches.value(+showCond.SwitchId)
        ) {
          shouldShow = false;
        }
        if (+showCond.VariableId > 0) {
          const v = $gameVariables.value(+showCond.VariableId);
          const op = normalizeOperator(showCond.Operator || "==");
          const cmp = +showCond.Value || 0;
          switch (op) {
            case "==":
              shouldShow = shouldShow && v == cmp;
              break;
            case "!=":
              shouldShow = shouldShow && v != cmp;
              break;
            case ">=":
              shouldShow = shouldShow && v >= cmp;
              break;
            case "<=":
              shouldShow = shouldShow && v <= cmp;
              break;
            case ">":
              shouldShow = shouldShow && v > cmp;
              break;
            case "<":
              shouldShow = shouldShow && v < cmp;
              break;
          }
        }

        const useFade = String(wrapper._fadeConfig?.UseFade) === "true";
        if (useFade) {
          if (shouldShow) {
            wrapper.visible = true;
            wrapper.alpha = 1;
            wrapper._targetVisible = true;
            wrapper._nextVisible = true;
          } else {
            wrapper.visible = false;
            wrapper.alpha = 0;
            wrapper._targetVisible = false;
            wrapper._nextVisible = false;
          }
        } else {
          wrapper.visible = shouldShow;
          wrapper.alpha = shouldShow ? 1 : 0;
          wrapper._targetVisible = shouldShow;
          wrapper._nextVisible = shouldShow;
        }

        choiceSprites.push(wrapper);

        choiceSprites.push(wrapper);
      });
      parentSprite._onevChoiceChildren = choiceSprites;
    };

    OnevASSISTANT.applyHoverEffect = function (
      sprite,
      config,
      isChoiceMode = false
    ) {
      if (!sprite || !config) return;

      const target = sprite._content || sprite;

      if (target._originalX != null && target._originalY != null) {
        target.x = target._originalX;
        target.y = target._originalY;
      }

      const useScale = String(config.UseScale) === "true";
      const useOffset = String(config.UseOffset) === "true";
      const targetScale = useScale ? (+config.Scale || 100) / 100 : 1;
      const offsetX = useOffset ? +config.OffsetX || 0 : 0;
      const offsetY = useOffset ? +config.OffsetY || 0 : 0;

      target._hoverState = "hovered";
      target._hoverTween = {
        startTime: performance.now(),
        duration: +config.EntryDuration || 200,
        fromScale: target.scale.x,
        toScale: targetScale,
        fromX: target._originalX ?? target.x,
        fromY: target._originalY ?? target.y,
        offsetX,
        offsetY,
        easing: OnevASSISTANT.Easing.easeOutBack,
      };

      if (config.HoverSE) {
        const seName = String(config.HoverSE).replace(/\.\w+$/, "");
        AudioManager.playSe({ name: seName, volume: 90, pitch: 100, pan: 0 });
      }

      if (config.HoverScript && String(config.HoverScript).trim()) {
        try {
          const scriptCode = String(config.HoverScript);
          const executeScript = new Function(
            "$gameVariables",
            "$gameSwitches",
            "$gameActors",
            "$gameParty",
            "$gamePlayer",
            "$gameMap",
            "$gameScreen",
            "$gameTemp",
            scriptCode
          );
          executeScript(
            $gameVariables,
            $gameSwitches,
            $gameActors,
            $gameParty,
            $gamePlayer,
            $gameMap,
            $gameScreen,
            $gameTemp
          );
        } catch (error) {
          console.warn("[OnevASSISTANT] ホバースクリプト実行エラー:", error);
          console.warn("スクリプト内容:", config.HoverScript);
        }
      }

      const extraCfg = config.ExtraImageSetting
        ? OnevASSISTANT.safeJsonParse(config.ExtraImageSetting)
        : null;

      if (extraCfg && extraCfg.Image) {
        const swId = +extraCfg.SwitchId || 0;
        const vrId = +extraCfg.VariableId || 0;
        const okSw = swId === 0 || $gameSwitches.value(swId);

        let okVr = true;
        if (vrId > 0) {
          const v = $gameVariables.value(vrId);
          const op = normalizeOperator(extraCfg.Operator || "==");
          const c = +extraCfg.CompareValue || 0;
          switch (op) {
            case "==":
              okVr = v == c;
              break;
            case "!=":
              okVr = v != c;
              break;
            case ">=":
              okVr = v >= c;
              break;
            case "<=":
              okVr = v <= c;
              break;
            case ">":
              okVr = v > c;
              break;
            case "<":
              okVr = v < c;
              break;
            default:
              okVr = false;
              break;
          }
        }

        if (okSw && okVr) {
          const imagePath = isChoiceMode ? "img/choice/" : "img/UI/";
          const bmp = ImageManager.loadBitmap(imagePath, extraCfg.Image);
          const sp = new Sprite(bmp);
          sp.anchor.set(0.5);
          sp.x += +extraCfg.X || 0;
          sp.y += +extraCfg.Y || 0;
          target.addChild(sp);
          target._hoverExtraImage = sp;
        }
      }

      if (String(config.UseFrame) !== "true" || !config.FrameImage) return;

      target._hoverReqId = (target._hoverReqId || 0) + 1;
      const myReqId = target._hoverReqId;

      const bmp = ImageManager.loadBitmap("img/UI/", config.FrameImage);
      if (bmp.isReady()) {
        drawFrameIfAlive();
      } else {
        bmp.addLoadListener(drawFrameIfAlive);
      }

      function drawFrameIfAlive() {
        if (target._hoverState !== "hovered") return;
        if (target._hoverReqId !== myReqId) return;

        const sheetCfg =
          OnevASSISTANT.safeJsonParse(config.SpriteSheet || "{}") || {};
        const offX = +(sheetCfg.OffsetX || 0);
        const offY = +(sheetCfg.OffsetY || 0);
        const useSheet = String(sheetCfg.UseSpriteSheet) === "true";
        const loopFlag = String(sheetCfg.Loop) !== "false";
        let frameSp;

        if (useSheet) {
          const cols = +(sheetCfg.FrameCols || 1);
          const rows = +(sheetCfg.FrameRows || 1);
          const fw = bmp.width / cols;
          const fh = bmp.height / rows;

          const makeTex = (idx) =>
            new PIXI.Texture(
              bmp.baseTexture,
              new PIXI.Rectangle(
                (idx % cols) * fw,
                Math.floor(idx / cols) * fh,
                fw,
                fh
              )
            );

          if (String(sheetCfg.UseAnimation) === "true") {
            const s = +(sheetCfg.StartIndex || 0);
            const e = +(sheetCfg.EndIndex || cols * rows - 1);
            const tex = [];
            for (let i = s; i <= e; i++) tex.push(makeTex(i));

            frameSp = new PIXI.AnimatedSprite(tex);
            const interval = Math.max(+sheetCfg.Interval || 6, 1);
            frameSp.animationSpeed = 1 / interval;
            frameSp.loop = loopFlag;
            frameSp.play();

            if (!loopFlag) {
              frameSp.onComplete = () => frameSp.gotoAndStop(tex.length - 1);
            }
          } else {
            frameSp = new Sprite(bmp);
            const idx = +(sheetCfg.FrameIndex || 0);
            frameSp.setFrame(
              (idx % cols) * fw,
              Math.floor(idx / cols) * fh,
              fw,
              fh
            );
          }
        } else {
          frameSp = new Sprite(bmp);
        }

        frameSp.anchor.set(0.5);
        frameSp.x += offX;
        frameSp.y += offY;
        target.addChild(frameSp);
        target._hoverFrame = frameSp;
      }
    };

    OnevASSISTANT.clearHoverEffect = function (sprite) {
      const target = sprite._content || sprite;

      target._hoverState = "normal";
      target.scale.set(1, 1);
      if (target._originalX != null && target._originalY != null) {
        target.x = target._originalX;
        target.y = target._originalY;
      }

      if (target._hoverFrame) {
        target.removeChild(target._hoverFrame);
        target._hoverFrame.destroy({ children: true, texture: false });
        target._hoverFrame = null;
      }

      if (target._hoverExtraImage) {
        target.removeChild(target._hoverExtraImage);
        target._hoverExtraImage.destroy({ children: true, texture: false });
        target._hoverExtraImage = null;
      }

      delete target._hoverTween;
    };

    OnevASSISTANT.resetHoverEffect = function (sprite, cfg) {
      const target = sprite._content || sprite;

      if (cfg.UseScale === "true") {
        target.scale.set(1, 1);
      }
      if (cfg.UseOffset === "true") {
        target.x -= Number(cfg.OffsetX || 0);
        target.y -= Number(cfg.OffsetY || 0);
      }
      if (cfg.UseFrame === "true" && target._hoverFrame) {
        target.removeChild(target._hoverFrame);
        target._hoverFrame = null;
      }
    };

    OnevASSISTANT.isPixelTransparent = function (sprite, localX, localY) {
      if (!sprite || !sprite.bitmap || !sprite.bitmap.isReady()) return true;

      const bitmap = sprite.bitmap;
      const canvas = bitmap.canvas || bitmap._canvas;
      if (!canvas) return true;

      const ctx = canvas.getContext("2d");
      if (!ctx) return true;
      const bitmapX = Math.floor(localX);
      const bitmapY = Math.floor(localY);

      if (
        bitmapX < 0 ||
        bitmapX >= bitmap.width ||
        bitmapY < 0 ||
        bitmapY >= bitmap.height
      ) {
        return true;
      }

      try {
        const imageData = ctx.getImageData(bitmapX, bitmapY, 1, 1);
        const alpha = imageData.data[3];

        return alpha === 0;
      } catch (e) {
        return false;
      }
    };

    OnevASSISTANT.updateHoverStates = function () {
      if ($gameMap.isEventRunning && $gameMap.isEventRunning()) {
        return;
      }
      
      if (!OnevASSISTANT.getHoverHitRect) {
        OnevASSISTANT.getHoverHitRect = function (sp) {
          if (!sp) return null;
          const baseX = sp._baseX != null ? sp._baseX : sp.x;
          const baseY = sp._baseY != null ? sp._baseY : sp.y;
          let gx = baseX;
          let gy = baseY;
          if (sp.parent && sp.parent.toGlobal) {
            const pt = new PIXI.Point(baseX, baseY);
            const gpt = sp.parent.toGlobal(pt);
            gx = gpt.x;
            gy = gpt.y;
          }
          const w =
            sp._baseWidth != null
              ? sp._baseWidth
              : sp.width || (sp.bitmap && sp.bitmap.width) || 0;
          const h =
            sp._baseHeight != null
              ? sp._baseHeight
              : sp.height || (sp.bitmap && sp.bitmap.height) || 0;
          const ax = sp.anchor?.x ?? 0.5;
          const ay = sp.anchor?.y ?? 0.5;
          const left = gx - w * ax;
          const top = gy - h * ay;
          return { left, top, right: left + w, bottom: top + h };
        };
      }
      for (const name of OnevASSISTANT._activeUINames) {
        const root = OnevASSISTANT._activeSprites[name];
        if (!root || !root._onevChoiceChildren) continue;

        for (const sp of root._onevChoiceChildren) {
          const cfg = sp._choiceMeta;
          if (!cfg || !cfg.HoverEffect) continue;

          if (sp._hoverBaseReady !== true && sp.bitmap && sp.bitmap.isReady()) {
            const sprite = sp._content || sp;
            const ax = sprite.anchor?.x ?? 0.5;
            const ay = sprite.anchor?.y ?? 0.5;
            const w = sprite.width || sprite.bitmap.width;
            const h = sprite.height || sprite.bitmap.height;
            const baseX = sp._baseX != null ? sp._baseX : sp.x;
            const baseY = sp._baseY != null ? sp._baseY : sp.y;
            sp._hitLeft = baseX - w * ax;
            sp._hitTop = baseY - h * ay;
            sp._hitRight = sp._hitLeft + w;
            sp._hitBottom = sp._hitTop + h;
            sp._hoverBaseReady = true;
          }

          let hit = false;
          const rect = OnevASSISTANT.getHoverHitRect(sp);
          if (rect) {
            const mx = TouchInput.x;
            const my = TouchInput.y;
            hit =
              mx >= rect.left &&
              mx <= rect.right &&
              my >= rect.top &&
              my <= rect.bottom;

            if (hit) {
              const sprite = sp._content || sp;
              if (sprite && sprite.bitmap && sprite.bitmap.isReady()) {
                const ax = sprite.anchor?.x ?? 0.5;
                const ay = sprite.anchor?.y ?? 0.5;
                const w = sprite.width || sprite.bitmap.width;
                const h = sprite.height || sprite.bitmap.height;
                const localX = mx - rect.left;
                const localY = my - rect.top;
                const bitmapX = localX;
                const bitmapY = localY;

                if (
                  OnevASSISTANT.isPixelTransparent(sprite, bitmapX, bitmapY)
                ) {
                  hit = false;
                }
              }
            }
          }

          const wasHovered = sp._isHovered;
          sp._isHovered = hit;

          if (wasHovered !== sp._isHovered) {
            const hoverConfig = OnevASSISTANT.safeJsonParse(
              sp._choiceMeta.HoverEffect
            );
            if (sp._isHovered) {
              if (sp.visible && sp._isEnabled !== false) {
                OnevASSISTANT.applyHoverEffect(sp, hoverConfig);
              }
            } else {
              OnevASSISTANT.clearHoverEffect(sp);
              const target = sp._content || sp;
              target._hoverState = "normal";
            }
          }
        }
      }
    };

    OnevASSISTANT.updateHoverEffects = function () {
      const now = performance.now();
      for (const name of OnevASSISTANT._activeUINames) {
        const root = OnevASSISTANT._activeSprites[name];
        if (!root || !root._onevChoiceChildren) continue;

        root._onevChoiceChildren.forEach((sp) => {
          if (!sp.visible || sp._isEnabled === false) return;

          const tgt = sp._content || sp;
          if (!sp._isHovered && tgt._hoverFrame) {
            tgt.removeChild(tgt._hoverFrame);
            tgt._hoverFrame.destroy({ children: true, texture: false });
            tgt._hoverFrame = null;
          }

          const effect = OnevASSISTANT.safeJsonParse(
            sp._choiceMeta.HoverEffect
          );
          if (!effect) return;

          const target = sp._content || sp;

          const useScale = String(effect.UseScale) === "true";
          const useOffset = String(effect.UseOffset) === "true";
          const useFrame = String(effect.UseFrame) === "true";
          if (!useScale && !useOffset && !useFrame) return;

          const targetScale = useScale
            ? (Number(effect.Scale) || 100) / 100
            : 1.0;
          const moveX = useOffset ? Number(effect.OffsetX || 0) : 0;
          const moveY = useOffset ? Number(effect.OffsetY || 0) : 0;

          if (
            sp._isHovered &&
            target._hoverState !== "hovered" &&
            !target._hoverTween
          ) {
            target._hoverState = "hovered";
            target._hoverTween = {
              startTime: now,
              duration: Number(effect.EntryDuration) || 250,
              fromScale: target.scale.x,
              toScale: targetScale,
              fromX: target.x,
              fromY: target.y,
              offsetX: moveX,
              offsetY: moveY,
              easing: OnevASSISTANT.Easing.easeOutBack,
            };

            if (useFrame && effect.FrameImage && !target._hoverFrame) {
              const frame = new Sprite(
                ImageManager.loadBitmap("img/UI/", effect.FrameImage)
              );
              frame.anchor.set(0.5);
              target.addChild(frame);
              target._hoverFrame = frame;
            }
          } else if (
            !sp._isHovered &&
            target._hoverState === "hovered" &&
            !target._hoverTween
          ) {
            if (target._hoverFrame) {
              target.removeChild(target._hoverFrame);
              target._hoverFrame.destroy();
              target._hoverFrame = null;
            }
            const destX = target._originalX ?? 0;
            const destY = target._originalY ?? 0;
            target._hoverState = "normal";
            target._hoverTween = {
              startTime: now,
              duration: Number(effect.ExitDuration) || 250,
              fromScale: target.scale.x,
              toScale: 1.0,
              fromX: target.x,
              fromY: target.y,
              offsetX: destX - target.x,
              offsetY: destY - target.y,
              easing: OnevASSISTANT.Easing.easeOutExpo,
            };
          }

          if (target._hoverTween) {
            const tween = target._hoverTween;
            const t = Math.min(1, (now - tween.startTime) / tween.duration);
            const eased = tween.easing ? tween.easing(t) : t;

            const scaleVal =
              tween.fromScale + (tween.toScale - tween.fromScale) * eased;
            target.scale.set(scaleVal, scaleVal);

            target.x = tween.fromX + tween.offsetX * eased;
            target.y = tween.fromY + tween.offsetY * eased;

            if (t >= 1) {
              delete target._hoverTween;
            }
          }
        });
      }
    };

    OnevASSISTANT.getSpriteBounds = function (sp) {
      if (!sp || !sp.getGlobalPosition)
        return { left: 0, top: 0, right: 0, bottom: 0 };

      if (sp._baseGlobalX == null || sp._baseGlobalY == null) {
        const g = sp.getGlobalPosition();
        sp._baseGlobalX = g.x;
        sp._baseGlobalY = g.y;
        if (sp._baseScale == null) sp._baseScale = sp.scale?.x ?? 1;
      }

      const baseX = sp._baseGlobalX;
      const baseY = sp._baseGlobalY;
      const baseScale = sp._baseScale != null ? sp._baseScale : 1;
      const width = (sp.width || sp.bitmap?.width || 0) * baseScale;
      const height = (sp.height || sp.bitmap?.height || 0) * baseScale;
      const anchorX = sp.anchor?.x ?? 0;
      const anchorY = sp.anchor?.y ?? 0;
      const left = baseX - anchorX * width;
      const top = baseY - anchorY * height;

      return {
        left,
        top,
        right: left + width,
        bottom: top + height,
      };
    };

    function Sprite_GaugeVariable(setting, baseX = 0, baseY = 0) {
      this.initialize(setting, baseX, baseY);
    }
    Sprite_GaugeVariable.prototype = Object.create(Sprite.prototype);
    Sprite_GaugeVariable.prototype.constructor = Sprite_GaugeVariable;
    Sprite_GaugeVariable.prototype.initialize = function (
      s,
      baseX = 0,
      baseY = 0
    ) {
      Sprite.prototype.initialize.call(this);

      this._container = new Sprite();
      this.addChild(this._container);
      this._curVar = +s.CurrentVarId || 0;
      this._maxVar = +s.MaxVarId || 0;
      this._type = s.Type || "horizontal";
      this._align = s.Align || "right";
      this._maskImage = s.MaskImage || "";
      this._switchId = +s.SwitchId || 0;
      this._useEasing = !!s.UseEasing;
      this._easeSpeed = +s.EasingSpeed || 0.15;
      this._easeType = s.EasingType || "easeInOut";
      this._slideDistance = +s.SlideDistance || 0;
      this._animationStartTime = null;
      this._animationDuration = 0;
      this._targetRate = 0;
      const offsetX = +s.X || 0;
      const offsetY = +s.Y || 0;
      this.x = baseX + offsetX;
      this.y = baseY + offsetY;
      this._baseX = this.x;
      this._baseY = this.y;
      this.anchor.set(0.5, 0.5);
      this._width = 0;
      this._height = 0;
      this._bitmap = ImageManager.loadBitmap("img/UI/", s.BarImage || "");
      this._curRate = typeof s.InitialRate === "number" ? s.InitialRate : 0;
      this._targetRate = this._curRate;
      this._initialized = false;
      this._sprite = new Sprite();
      this._sprite.bitmap = this._bitmap;
      this._container.addChild(this._sprite);

      if (this._maskImage) {
        const maskBmp = ImageManager.loadBitmap("img/UI/", this._maskImage);
        maskBmp.addLoadListener(() => {
          const maskSprite = new Sprite(maskBmp);
          this._sprite.mask = maskSprite;
          this._container.addChildAt(maskSprite, 0);
        });
      }

      this._bitmap.addLoadListener(() => {
        if (this._type === "elasticity") {
          this._width = this._bitmap.width;
          this._height = this._bitmap.height;
        } else if (this._type === "slide") {
          switch (this._align) {
            case "left":
            case "right":
              this._width = this._slideDistance || this._bitmap.width;
              this._height = this._bitmap.height;
              break;
            case "up":
            case "down":
              this._width = this._bitmap.width;
              this._height = this._slideDistance || this._bitmap.height;
              break;
          }
        }
        this.updateVisual();
      });

      let deco = s.Decoration;
      try {
        if (typeof deco === "string") deco = JSON.parse(deco);
      } catch (e) {
        deco = null;
      }

      if (deco) {
        if (deco.BackgroundImage) {
          const bgBmp = ImageManager.loadBitmap(
            "img/UI/",
            deco.BackgroundImage
          );
          this._bgSprite = new Sprite(bgBmp);
          this._bgSprite.x = +deco.BackgroundOffsetX || 0;
          this._bgSprite.y = +deco.BackgroundOffsetY || 0;
          this._container.addChildAt(this._bgSprite, 0);
        }
        if (deco.FrameImage) {
          const frameBmp = ImageManager.loadBitmap("img/UI/", deco.FrameImage);
          this._frameSprite = new Sprite(frameBmp);
          this._frameSprite.x = +deco.FrameOffsetX || 0;
          this._frameSprite.y = +deco.FrameOffsetY || 0;
          this._container.addChild(this._frameSprite);
        }
      }

      if (this._type === "slide") {
        switch (this._align) {
          case "up":
            this._sprite.y = this._slideDistance;
            break;
          case "down":
            this._sprite.y = -this._slideDistance;
            break;
          case "left":
            this._sprite.x = this._slideDistance;
            break;
          case "right":
            this._sprite.x = -this._slideDistance;
            break;
        }
      }
    };

    Sprite_GaugeVariable.prototype.update = function () {
      Sprite.prototype.update.call(this);

      const show = this._switchId <= 0 || $gameSwitches.value(this._switchId);
      this.visible = show;
      if (!show) {
        const val = $gameVariables.value(this._curVar);
        const max = this._maxVar > 0 ? $gameVariables.value(this._maxVar) : 100;
        this._curRate = max > 0 ? Math.min(1, val / max) : 0;
        return;
      }

      const val = $gameVariables.value(this._curVar);
      const max = this._maxVar > 0 ? $gameVariables.value(this._maxVar) : 100;
      const newTarget = max > 0 ? Math.min(1, val / max) : 0;

      if (!this._initialized) {
        this._curRate = newTarget;
        this._targetRate = newTarget;
        this._initialized = true;
      } else if (Math.abs(this._targetRate - newTarget) > 0.001) {
        this._targetRate = newTarget;
        this._animationStartTime = Date.now();
        this._animationDuration = 1000 / this._easeSpeed;
      }

      if (this._useEasing && this._animationStartTime) {
        const elapsed = Date.now() - this._animationStartTime;
        const progress = Math.min(1, elapsed / this._animationDuration);
        const easingFunction = Easing[this._easeType] || Easing.linear;
        const easedProgress = easingFunction(progress);
        const startRate = this._curRate;

        this._curRate =
          startRate + (this._targetRate - startRate) * easedProgress;

        if (progress >= 1) {
          this._curRate = this._targetRate;
          this._animationStartTime = null;
        }
      } else {
        this._curRate = newTarget;
      }

      this.updateVisual();
    };
    Sprite_GaugeVariable.prototype.applyEasing = function (c, t) {
      const d = t - c,
        s = this._easeSpeed;
      const easingFunc = Easing[this._easeType] || Easing.linear;
      const eased = easingFunc(s);
      return c + d * eased;
    };
    Sprite_GaugeVariable.prototype.updateVisual = function () {
      if (
        !this._sprite ||
        !this._bitmap ||
        !this._bitmap.isReady() ||
        !this._sprite.bitmap ||
        !this._sprite.texture ||
        !this._sprite.texture.baseTexture ||
        !this._sprite.texture.baseTexture.valid
      ) {
        return;
      }

      const rate = this._curRate;
      const fixedRate =
        Math.abs(rate - 1) < 0.001 ? 1 : Math.abs(rate - 0) < 0.001 ? 0 : rate;

      if (this._type === "elasticity") {
        if (this._align === "left" || this._align === "right") {
          const sw = Math.floor(this._width * rate);
          this._sprite.setFrame(0, 0, sw, this._bitmap.height);
          this._sprite.x = this._align === "left" ? this._width - sw : 0;
        } else if (this._align === "up") {
          const sh = Math.round(this._height * fixedRate);
          const sy = this._bitmap.height - sh;
          this._sprite.setFrame(0, sy, this._bitmap.width, sh);
          this._sprite.y = this._height - sh;
        } else if (this._align === "down") {
          const sh = Math.floor(this._height * rate);
          this._sprite.setFrame(0, 0, this._bitmap.width, sh);
          this._sprite.y = 0;
        }
      } else if (this._type === "slide") {
        this._sprite.setFrame(0, 0, this._bitmap.width, this._bitmap.height);
        const dist = this._slideDistance;

        switch (this._align) {
          case "left":
            this._sprite.x = -dist * rate;
            break;
          case "right":
            this._sprite.x = dist * rate;
            break;
          case "up":
            this._sprite.y = -dist * rate;
            break;
          case "down":
            this._sprite.y = dist * rate;
            break;
        }
      }
    };

    OnevASSISTANT.createGaugeSprites = function (parentSprite, gaugeDefs) {
      const list = [];
      gaugeDefs.forEach((cfg) => {
        const sp = new Sprite_GaugeVariable(
          cfg,
          parentSprite.x,
          parentSprite.y
        );
        parentSprite.addChild(sp);
        list.push(sp);
      });
      return list;
    };

    OnevASSISTANT.updateGaugeSprites = function () {
      for (const name of OnevASSISTANT._activeUINames) {
        const root = OnevASSISTANT._activeSprites[name];
        (root._onevGaugeChildren || []).forEach((sp) => sp.update());
      }
    };

    function Sprite_NumberVariable(setting, baseX, baseY) {
      this.initialize(setting, baseX, baseY);
    }
    Sprite_NumberVariable.prototype = Object.create(Sprite.prototype);
    Sprite_NumberVariable.prototype.constructor = Sprite_NumberVariable;
    Sprite_NumberVariable.prototype.initialize = function (
      s,
      baseX = 0,
      baseY = 0
    ) {
      Sprite.prototype.initialize.call(this);

      this._setting = s;
      this._varId = +s.VariableId || 0;
      this._digits = +s.Digit || 4;
      this._padding = +s.Padding || 0;
      this._align = s.Align || "right";
      this._boxWidth = +s.BoxWidth || 0;
      this._padZero = String(s.PadZero).toLowerCase() === "true";
      this._switchId = +s.SwitchId || 0;
      const offsetX = +s.X || 0;
      const offsetY = +s.Y || 0;
      this.x = baseX + offsetX;
      this.y = baseY + offsetY;
      this._baseX = this.x;
      this._baseY = this.y;
      const anchorX = this._align === 'right' ? 1.0 : this._align === 'center' ? 0.5 : 0.0;
      this.anchor.set(anchorX, 0.5);
      this._value = null;
      this._digitSprites = [];
      const bmpName = s.Bitmap || "Damage";
      this._bitmap = ImageManager.loadSystem(bmpName);
      this._bitmap.addLoadListener(() => {
        this._digitW = this._bitmap.width / 10;
        this._digitH = this._bitmap.height;
        for (let i = 0; i < this._digits; i++) {
          const sp = new Sprite(this._bitmap);
          sp.setFrame(0, 0, this._digitW, this._digitH);
          this.addChild(sp);
          this._digitSprites.push(sp);
        }
        this._bitmapReady = true;
        this._refresh();
      });
    };

    Sprite_NumberVariable.prototype.update = function () {
      Sprite.prototype.update.call(this);
      if (this._bitmapReady) this._refresh();
    };

    Sprite_NumberVariable.prototype._refresh = function () {
      if (this._switchId > 0 && !$gameSwitches.value(this._switchId)) {
        this.visible = false;
        return;
      } else {
        this.visible = true;
      }

      const v = $gameVariables.value(this._varId);
      if (v === this._value) return;
      this._value = v;

      let displayVal;
      if (v <= 0) {
        displayVal = this._padZero ? "0".padStart(this._digits, "0") : "0";
      } else if (v >= Math.pow(10, this._digits)) {
        displayVal = "9".repeat(this._digits);
      } else {
        const raw = String(v);
        displayVal = this._padZero
          ? raw.padStart(this._digits, "0")
          : raw.substring(raw.length - this._digits);
      }

      const digits = displayVal.split("");
      const totalWidth =
        digits.length * (this._digitW + this._padding) - this._padding;

      digits.forEach((d, i) => {
        const sp = this._digitSprites[i];
        if (sp) {
          sp.setFrame(+d * this._digitW, 0, this._digitW, this._digitH);
          if (this._align === 'right') {
            sp.x = -(totalWidth - i * (this._digitW + this._padding));
          } else if (this._align === 'center') {
            sp.x = i * (this._digitW + this._padding) - totalWidth / 2;
          } else {
            sp.x = i * (this._digitW + this._padding);
          }
          sp.visible = true;
        }
      });

      for (let i = digits.length; i < this._digitSprites.length; i++) {
        this._digitSprites[i].visible = false;
      }
    };

    function Sprite_TextVariable(setting, baseX, baseY) {
      this.initialize(setting, baseX, baseY);
    }
    Sprite_TextVariable.prototype = Object.create(Sprite.prototype);
    Sprite_TextVariable.prototype.constructor = Sprite_TextVariable;
    Sprite_TextVariable.prototype.initialize = function (
      s,
      baseX = 0,
      baseY = 0
    ) {
      Sprite.prototype.initialize.call(this);

      this._varId = +s.VariableId || 0;
      this._fontSize = +s.FontSize || 28;
      this._fontFace = s.FontFace || "";
      this._align = s.Align || "left";
      const offsetX = +s.OffsetX || 0;
      const offsetY = +s.OffsetY || 0;
      this.x = baseX + offsetX;
      this.y = baseY + offsetY;
      this.anchor.set(0.5, 0.5);
      this._baseX = this.x;
      this._baseY = this.y;
      this._value = null;
      this.bitmap = new Bitmap(1, 1);
      this._fontReady = false;

      if (this._fontFace && document.fonts) {
        const fontSpec = `16px "${this._fontFace}"`;
        document.fonts.load(fontSpec).then(() => {
          document.fonts.ready.then(() => {
            this._fontReady = true;
            this._value = null;
            this.forceRedraw();
            console.log(
              "Graphics width×height:",
              Graphics.width,
              "x",
              Graphics.height
            );
            console.log(
              "Graphics real-scale:",
              Graphics._realScale,
              Graphics._width,
              "→",
              Graphics._height
            );
            console.log(
              `[Font Ready] Redrawing TextSprite with font: ${this._fontFace}`
            );
            console.log("window.devicePixelRatio =", window.devicePixelRatio);
            console.log("Canvas size =", Graphics.width, "x", Graphics.height);
            setTimeout(() => {
              this._value = null;
              this.forceRedraw();
            }, 100);
          });
        });
      } else {
        this._fontReady = true;
      }
    };

    Sprite_TextVariable.prototype.forceRedraw = function () {
      const v = String($gameVariables.value(this._varId));
      this._value = v;
      const fontSize = this._fontSize;
      const fontFace = this._fontFace || "GameFont";
      const temp = new Bitmap(1, 1);
      temp.fontSize = fontSize;
      temp.fontFace = fontFace;
      const measuredWidth = Math.ceil(temp.measureTextWidth(v));
      const padding = 16;
      const boxWidth = measuredWidth + padding * 2;
      const boxHeight = fontSize + padding;
      const bmp = new Bitmap(boxWidth, boxHeight);
      bmp.fontSize = fontSize;
      bmp.fontFace = fontFace;
      bmp.drawText(v, 0, 0, boxWidth, boxHeight, this._align);
      this.bitmap = bmp;
      this.x = this._baseX;
      this.y = this._baseY;
      console.log(
        `[TextSprite] pos=(${this.x}, ${this.y}), fontSize=${fontSize}, fontFace=${fontFace}, box=(${boxWidth}x${boxHeight}), text="${v}"`
      );
    };

    Sprite_TextVariable.prototype.update = function () {
      Sprite.prototype.update.call(this);
      if (!this._fontReady) return;

      const v = String($gameVariables.value(this._varId));
      if (v !== this._value || this._value === null) {
        this.forceRedraw();
      }
    };

    Sprite_TextVariable.prototype.updateText = function (force = false) {
      const v = String($gameVariables.value(this._varId));
      if (!force && v === this._value) return;
      this.forceRedraw();
    };

    OnevASSISTANT.updateChoiceClicks = function () {
      const now = performance.now();
      if (now - OnevASSISTANT.lastClickTime < OnevASSISTANT.clickCooldown)
        return;
      const point = new PIXI.Point(TouchInput.x, TouchInput.y);

      for (const name of OnevASSISTANT._activeUINames) {
        const root = OnevASSISTANT._activeSprites[name];
        if (!root || !root._onevChoiceChildren) continue;

        for (const sp of root._onevChoiceChildren) {
          if (!sp.visible || sp._isEnabled === false) continue;
          let hit = false;
          if (OnevASSISTANT.getHoverHitRect) {
            const rect = OnevASSISTANT.getHoverHitRect(sp);
            if (rect) {
              hit =
                point.x >= rect.left &&
                point.x <= rect.right &&
                point.y >= rect.top &&
                point.y <= rect.bottom;

              if (hit) {
                const sprite = sp._content || sp;
                if (sprite && sprite.bitmap && sprite.bitmap.isReady()) {
                  const ax = sprite.anchor?.x ?? 0.5;
                  const ay = sprite.anchor?.y ?? 0.5;
                  const w = sprite.width || sprite.bitmap.width;
                  const h = sprite.height || sprite.bitmap.height;
                  const localX = point.x - rect.left;
                  const localY = point.y - rect.top;
                  const bitmapX = localX;
                  const bitmapY = localY;

                  if (
                    OnevASSISTANT.isPixelTransparent(sprite, bitmapX, bitmapY)
                  ) {
                    hit = false;
                  }
                }
              }
            }
          } else if (sp._content) {
            hit = sp._content.containsPoint(point);
          }

          if (TouchInput.isTriggered() && hit) {
            const c = sp._choiceMeta;
            const ceId = +c.CommonEventId;
            if (
              ceId > 0 &&
              OnevASSISTANT._lastCommonEventId &&
              OnevASSISTANT._lastCommonEventId === ceId
            ) {
              return;
            }

            OnevASSISTANT.lastClickTime = now;

            sp._hoverLocked = true;

            if (+c.SwitchId) {
              $gameSwitches.setValue(+c.SwitchId, true);
            }

            if (ceId > 0) {
              OnevASSISTANT._lastCommonEventId = ceId;
              $gameScreen.startFadeIn(1);
              $gameTemp.reserveCommonEvent(ceId);
            }

            return;
          }
        }
      }
    };

    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
      _Scene_Map_update.call(this);
      this._updateUIDrag();
      OnevASSISTANT.updateUIVisibility();
      OnevASSISTANT.updateImageFades();
      OnevASSISTANT.updateHoverStates();
      OnevASSISTANT.updateHoverEffects();
      OnevASSISTANT.updateChoiceFades();
      OnevASSISTANT.updateChoiceClicks();
      OnevASSISTANT.updateGaugeSprites();
      OnevASSISTANT.updateNumberSprites();
      OnevASSISTANT.updateTextSprites();
    };

    OnevASSISTANT.updateUIVisibility = function () {
      if (
        OnevASSISTANT._forceHideAll &&
        SceneManager._scene instanceof Scene_Map
      )
        return;

      const pluginParams = PluginManager.parameters("OnevASSISTANT") || {};
      const configs = OnevASSISTANT.parseDeep(
        pluginParams["UIConfigs"] || "[]"
      );

      for (const cfg of configs) {
        const name = cfg.Name;
        const sprite = OnevASSISTANT._activeSprites[name];
        if (!sprite) continue;

        const rawImgs = JSON.parse(cfg.ImageSprites || "[]");
        const imgConfs = rawImgs
          .map((s) => {
            try {
              return JSON.parse(s);
            } catch {
              return null;
            }
          })
          .filter(Boolean);
        const imageSprites = sprite._onevImageChildren || [];
        imgConfs.forEach((imgCfg, idx) => {
          const child = imageSprites[idx];
          if (!child) return;
          const okSwitch =
            Number(imgCfg.ShowSwitch) === 0 ||
            $gameSwitches.value(Number(imgCfg.ShowSwitch));
          const okVar =
            Number(imgCfg.ShowVariable) === 0 ||
            (() => {
              const v = $gameVariables.value(Number(imgCfg.ShowVariable));
              const op = normalizeOperator(imgCfg.ShowOperator);
              const cmp = Number(imgCfg.ShowValue);
              switch (op) {
                case "==":
                  return v == cmp;
                case "!=":
                  return v != cmp;
                case ">=":
                  return v >= cmp;
                case "<=":
                  return v <= cmp;
                case ">":
                  return v > cmp;
                case "<":
                  return v < cmp;
                default:
                  return true;
              }
            })();
          const ok = okSwitch && okVar;
          if (child._fadeFrames > 0) {
            child._nextVisible = ok;
          } else {
            child.visible = ok;
            child.alpha = ok ? 1 : 0;
          }
        });

        const choiceSprites = sprite._onevChoiceChildren || [];
        choiceSprites.forEach((sp) => {
          const showCond = OnevASSISTANT.safeJsonParse(
            sp._choiceMeta.ShowCondition || "{}"
          );
          const okShowSw =
            Number(showCond.SwitchId) === 0 ||
            $gameSwitches.value(Number(showCond.SwitchId));
          let okShowVar = true;
          if (Number(showCond.VariableId) > 0) {
            const v = $gameVariables.value(Number(showCond.VariableId));
            const op = normalizeOperator(showCond.Operator);
            const cmp = Number(showCond.Value);
            switch (op) {
              case "==":
                okShowVar = v == cmp;
                break;
              case "!=":
                okShowVar = v != cmp;
                break;
              case ">=":
                okShowVar = v >= cmp;
                break;
              case "<=":
                okShowVar = v <= cmp;
                break;
              case ">":
                okShowVar = v > cmp;
                break;
              case "<":
                okShowVar = v < cmp;
                break;
            }
          }
          const shouldShow = okShowSw && okShowVar;
          const fadeCfg = sp._fadeConfig;
          if (fadeCfg && String(fadeCfg.UseFade) === "true") {
            sp._nextVisible = shouldShow;
          } else {
            sp.visible = shouldShow;
            sp.alpha = shouldShow ? 1 : 0;
          }

          const enCond = OnevASSISTANT.safeJsonParse(
            sp._choiceMeta.EnableCondition || "{}"
          );
          const sid = Number(enCond.SwitchId) || 0;
          const vid = Number(enCond.VariableId) || 0;
          const okEnSw = sid === 0 || $gameSwitches.value(sid);
          let okEnVar = true;
          if (vid > 0) {
            const v = $gameVariables.value(vid);
            const op = normalizeOperator(enCond.Operator);
            const cmp = Number(enCond.Value);
            switch (op) {
              case "==":
                okEnVar = v == cmp;
                break;
              case "!=":
                okEnVar = v != cmp;
                break;
              case ">=":
                okEnVar = v >= cmp;
                break;
              case "<=":
                okEnVar = v <= cmp;
                break;
              case ">":
                okEnVar = v > cmp;
                break;
              case "<":
                okEnVar = v < cmp;
                break;
            }
          }
          const isEnabled = okEnSw && okEnVar;
          sp._isEnabled = isEnabled;

          sp.interactive = isEnabled;
          sp.buttonMode = isEnabled;
          if (!isEnabled) {
            const img = sp._choiceMeta.DisabledImage;
            if (img) {
              sp.bitmap = ImageManager.loadBitmap("img/UI/", img);
            } else {
              //sp.alpha = 0.5; //半透明にしたいならここのコメントアウトを削除
            }
          } else {
            const orig = sp._choiceMeta.Image;
            if (orig) {
              sp.bitmap = ImageManager.loadBitmap("img/UI/", orig);
            }
            sp.alpha = 1;
          }
        });
      }
    };

    Scene_Map.prototype._updateUIDrag = function () {
      const infoMap = OnevASSISTANT._dragInfo;
      for (const name in infoMap) {
        const info = infoMap[name];
        const sp = info.sprite;
        if (TouchInput.isTriggered()) {
          const mx = TouchInput.x;
          const my = TouchInput.y;
          const left = sp.x - sp.anchor.x * sp.width;
          const top = sp.y - sp.anchor.y * sp.height;
          if (
            $gameSwitches.value(info.switchId) &&
            mx >= left &&
            mx <= left + sp.width &&
            my >= top &&
            my <= top + sp.height
          ) {
            info.dragging = true;
            info.offsetX = mx - sp.x;
            info.offsetY = my - sp.y;
          }
        } else if (TouchInput.isPressed() && info.dragging) {
          sp.x = TouchInput.x - info.offsetX;
          sp.y = TouchInput.y - info.offsetY;
        } else if (info.dragging && TouchInput.isReleased()) {
          info.dragging = false;
          $gameSystem.setUIPosition(name, sp.x, sp.y);
        }
      }
    };

    Scene_Map.prototype._updateOnevUIVisibility = function () {
      const configs = OnevASSISTANT.parseDeep(
        PluginManager.parameters("OnevASSISTANT")["UIConfigs"] || []
      );
      for (const cfg of configs) {
        const name = cfg.Name;
        const sprite = OnevASSISTANT._activeSprites[name];
        if (!sprite) continue;

        const activeSwitchIds = OnevASSISTANT.parseDeep(cfg.ActiveSwitchIds);
        sprite.visible = checkSwitches(activeSwitchIds, true);

        const rawArray = JSON.parse(cfg.ImageSprites || "[]");
        const imageConfigs = rawArray
          .map((s) => {
            try {
              return JSON.parse(s);
            } catch {
              return null;
            }
          })
          .filter((e) => e);

        const imageSprites = sprite._onevImageChildren || [];

        imageConfigs.forEach((imgCfg, idx) => {
          const child = imageSprites[idx];
          if (!child) return;

          const showSwitch = Number(imgCfg.ShowSwitch || 0);
          const showVariable = Number(imgCfg.ShowVariable || 0);
          const op = normalizeOperator(imgCfg.ShowOperator || "==");
          const cmp = Number(imgCfg.ShowValue || 0);

          const okSwitch = showSwitch === 0 || $gameSwitches.value(showSwitch);
          const okVar =
            showVariable === 0 ||
            (() => {
              const v = $gameVariables.value(showVariable);
              switch (op) {
                case "==":
                  return v == cmp;
                case "!=":
                  return v != cmp;
                case ">=":
                  return v >= cmp;
                case "<=":
                  return v <= cmp;
                case ">":
                  return v > cmp;
                case "<":
                  return v < cmp;
                default:
                  return true;
              }
            })();

          child.visible = okSwitch && okVar;
        });
      }
    };
    OnevASSISTANT.redrawAllUI = function () {
      const scene = SceneManager._scene;
      const pc = scene._spriteset && scene._spriteset._pictureContainer;
      if (!pc) return;
      for (const name of OnevASSISTANT._activeUINames) {
        if (OnevASSISTANT._activeSprites[name]?.parent === pc) continue;

        OnevASSISTANT.createUI(name);
      }
    };

    const _SM_createPictures = Spriteset_Map.prototype.createPictures;
    Spriteset_Map.prototype.createPictures = function () {
      _SM_createPictures.call(this);
      this._pictureContainer.interactive = true;
      this._pictureContainer.interactiveChildren = true;
      OnevASSISTANT.redrawAllUI();
    };

    const _SB_createPictures = Spriteset_Battle.prototype.createPictures;
    Spriteset_Battle.prototype.createPictures = function () {
      _SB_createPictures.call(this);
      this._pictureContainer.interactive = true;
      this._pictureContainer.interactiveChildren = true;
      OnevASSISTANT.redrawAllUI();
    };

    OnevASSISTANT.updateImageFades = function () {
      const now = performance.now();
      const msPerFrame = 1000 / 60;
      for (const name of OnevASSISTANT._activeUINames) {
        const root = OnevASSISTANT._activeSprites[name];
        if (!root || !root._onevImageChildren) continue;
        root._onevImageChildren.forEach((sp) => {
          const frames = sp._fadeFrames;
          if (!frames) return;
          if (sp._nextVisible !== sp._targetVisible) {
            const willShow = sp._nextVisible;
            sp._targetVisible = willShow;
            if (willShow) sp.visible = true;
            const from = sp.alpha;
            const to = willShow ? 1 : 0;
            sp._fadeTween = {
              startTime: now,
              duration: frames * msPerFrame,
              from,
              to,
            };
          }
          if (sp._fadeTween) {
            const tRaw =
              (now - sp._fadeTween.startTime) / sp._fadeTween.duration;
            const t = tRaw < 1 ? tRaw : 1;
            sp.alpha =
              sp._fadeTween.from + (sp._fadeTween.to - sp._fadeTween.from) * t;
            if (t >= 1) {
              sp._fadeTween = null;
              if (!sp._targetVisible) sp.visible = false;
              sp.alpha = sp._targetVisible ? 1 : 0;
            }
          }
        });
      }
    };

    OnevASSISTANT.updateChoiceFades = function () {
      const now = performance.now();
      const msPerFrame = 1000 / 60;

      for (const name of OnevASSISTANT._activeUINames) {
        const root = OnevASSISTANT._activeSprites[name];
        if (!root || !root._onevChoiceChildren) continue;

        root._onevChoiceChildren.forEach((sp) => {
          const cfg = sp._fadeConfig;
          if (!cfg || String(cfg.UseFade) !== "true") return;

          if (sp._nextVisible !== sp._targetVisible) {
            const willShow = sp._nextVisible;
            sp._targetVisible = willShow;

            if (willShow) {
              sp.alpha = 0;
              sp.visible = true;
            }

            const from = sp.alpha;
            const to = sp._targetVisible ? 1 : 0;
            const frames = Number(cfg.FadeFrames) || 5;
            const duration = frames * msPerFrame;

            sp._fadeTween = { startTime: now, duration, from, to };
          }

          if (sp._fadeTween) {
            const tRaw =
              (now - sp._fadeTween.startTime) / sp._fadeTween.duration;
            const t = tRaw < 1 ? tRaw : 1;
            sp.alpha =
              sp._fadeTween.from + (sp._fadeTween.to - sp._fadeTween.from) * t;

            if (t >= 1) {
              sp._fadeTween = null;
              if (!sp._targetVisible) sp.visible = false;
              sp.alpha = sp._targetVisible ? 1 : 0;
            }
          }
        });
      }
    };

    OnevASSISTANT.removeUI = function (name) {
      const scene = SceneManager._scene;
      const pc =
        scene && scene._spriteset && scene._spriteset._pictureContainer;
      if (!pc) return;

      if ($gameSystem && $gameSystem.removeCustomUI) {
        $gameSystem.removeCustomUI(name);
      }

      OnevASSISTANT._activeUINames.delete(name);
      delete OnevASSISTANT._activeSprites[name];

      const configs = OnevASSISTANT.parseDeep(parameters["UIConfigs"] || []);
      const cfg = configs.find((c) => c.Name === name);
      if (cfg) {
        const activeIds = OnevASSISTANT.parseDeep(cfg.ActiveSwitchIds || []);
        activeIds.forEach((id) => {
          if (+id > 0) $gameSwitches.setValue(+id, false);
        });
      }

      for (let i = pc.children.length - 1; i >= 0; i--) {
        const child = pc.children[i];
        if (child._onevUIName === name) {
          pc.removeChildAt(i);
        }
      }
    };

    OnevASSISTANT.removeAllUI = function () {
      const scene = SceneManager._scene;
      const pc =
        scene && scene._spriteset && scene._spriteset._pictureContainer;
      if (!pc) return;

      for (const name of OnevASSISTANT._activeUINames) {
        for (let i = pc.children.length - 1; i >= 0; i--) {
          const child = pc.children[i];
          if (child._onevUIName === name) {
            pc.removeChildAt(i);
          }
        }
      }
      OnevASSISTANT._activeUINames.clear();
      OnevASSISTANT._activeSprites = {};

      if ($gameSystem && $gameSystem.clearCustomUIs) {
        $gameSystem.clearCustomUIs();
      }

      if ($gameSystem && $gameSystem.clearCustomUIs) {
        $gameSystem.clearCustomUIs();
      }
    };

    OnevASSISTANT.hideAllUI = function () {
      OnevASSISTANT._forceHideAll = true;
      for (const name of OnevASSISTANT._activeUINames) {
        const sp = OnevASSISTANT._activeSprites[name];
        if (sp) sp.visible = false;
      }
    };

    OnevASSISTANT.showAllUI = function () {
      OnevASSISTANT._forceHideAll = false;
      for (const name of OnevASSISTANT._activeUINames) {
        const sp = OnevASSISTANT._activeSprites[name];
        if (sp) sp.visible = true;
      }
    };

    PluginManager.registerCommand("OnevASSISTANT", "UI操作", function (args) {
      const action = args.action;
      const name = args.name;

      if (action === "表示") {
        OnevASSISTANT.createUI(name);
      }

      if (action === "消去" && name) {
        OnevASSISTANT.removeUI(name);
      }

      if (action === "全消去") {
        OnevASSISTANT.removeAllUI();
      }

      if (action === "全非表示") {
        OnevASSISTANT.hideAllUI();
      }

      if (action === "再表示") {
        OnevASSISTANT.showAllUI();
      }
    });
  })();

  (() => {
    //=========================================================================
    // カスタムコモンイベント呼出管理
    //=========================================================================

    "use strict";
    const parameters = PluginManager.parameters("OnevASSISTANT");
    const ADMIN = JSON.parse(parameters["ADMINSettings"] || "{}");
    const checkVariables = OnevASSISTANT.checkVariables;
    const checkSwitches = OnevASSISTANT.checkSwitches;
    const normalizeOperator = OnevASSISTANT.normalizeOperator;
    window.OnevASSISTANT = window.OnevASSISTANT || {};
    OnevASSISTANT._triggerLockSet = new Set();
    OnevASSISTANT._triggerLockFrame = 0;
    OnevASSISTANT.unlockTriggers = function () {
      this._triggerLockSet.clear();
    };
    const eventTriggers = JSON.parse(ADMIN.EventTriggers || "[]").map((e) => {
      const t = JSON.parse(e);

      const parseArr = (s) => JSON.parse(s || "[]");
      const jsonOrSelf = (x) => (typeof x === "string" ? JSON.parse(x) : x);
      t.ConditionSwitches = parseArr(t.ConditionSwitches).map(Number);
      t.ProhibitSwitches = parseArr(t.ProhibitSwitches).map(Number);
      t.ConditionVariables = parseArr(t.ConditionVariables).map(jsonOrSelf);
      t.ProhibitVariables = parseArr(t.ProhibitVariables).map(jsonOrSelf);

      const normVar = (cv) => ({
        id: Number(cv.Id ?? cv.id ?? 0),
        op: cv.Operator ?? cv.op ?? "==",
        value: Number(cv.Value ?? cv.value ?? 0),
      });
      t.ConditionVariables = t.ConditionVariables.map(normVar);
      t.ProhibitVariables = t.ProhibitVariables.map(normVar);
      t.BlockIfTriggered = String(t.BlockIfTriggered) === "true";
      t.Once = String(t.Once) === "true";
      return t;
    });
    function executeEventTriggers(customName = "") {
      console.log(`executeEventTriggers: ${customName}`);

      if (OnevASSISTANT._triggerLockSet.has(customName)) {
        console.log("  └─ロック中");
        return;
      }

      const recordVarId = Number(ADMIN.TriggerRecordVariable || 0);
      let executedList = [];
      if (recordVarId > 0) {
        try {
          executedList = JSON.parse($gameVariables.value(recordVarId) || "[]");
        } catch {
          executedList = [];
        }
      }

      eventTriggers.forEach((t) => {
        if (t.CustomName !== customName) return;

        const ceId = Number(t.CommonEventId);
        const executed = executedList.includes(ceId);

        if (t.Once && executed) {
          console.log(` 一度きり: CE${ceId} 既に実行`);
          return;
        }

        const okCond =
          checkSwitches(t.ConditionSwitches, true) &&
          checkVariables(t.ConditionVariables);
        const ngCond =
          (t.ProhibitSwitches.length &&
            !checkSwitches(t.ProhibitSwitches, false)) ||
          (t.ProhibitVariables.length && !checkVariables(t.ProhibitVariables));

        if (okCond && !ngCond) {
          console.log(` イベント実行: CE${ceId}`);
          $gameTemp.reserveCommonEvent(ceId);
          if (t.BlockIfTriggered) {
            OnevASSISTANT._triggerLockSet.add(customName);
            OnevASSISTANT._triggerLockFrame = Graphics.frameCount;
          }

          if (t.Once && recordVarId > 0 && !executed) {
            executedList.push(ceId);
            $gameVariables.setValue(recordVarId, JSON.stringify(executedList));
          }
        }
      });
    }
    window.executeEventTriggers = executeEventTriggers;

    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
      _Scene_Map_update.call(this);
      if (
        OnevASSISTANT._triggerLockSet.size > 0 &&
        OnevASSISTANT._triggerLockFrame !== Graphics.frameCount &&
        !$gameMap.isEventRunning()
      ) {
        OnevASSISTANT._triggerLockSet.clear();
      }
    };

    const _DM_setupNew = DataManager.setupNewGame;
    DataManager.setupNewGame = function () {
      _DM_setupNew.call(this);
      $gameTemp._adminInterceptorType = "newGame";
    };

    const _DM_loadGame = DataManager.loadGameWithoutRescue;
    DataManager.loadGameWithoutRescue = function (id) {
      const r = _DM_loadGame.call(this, id);
      if (r) $gameTemp._adminInterceptorType = "loadGame";
      return r;
    };

    const _SM_terminate = Scene_Menu.prototype.terminate;
    Scene_Menu.prototype.terminate = function () {
      _SM_terminate.call(this);
      $gameTemp._adminInterceptorType = "menuClose";
    };

    const _GM_setupStart = Game_Map.prototype.setupStartingEvent;
    Game_Map.prototype.setupStartingEvent = function () {
      const r = _GM_setupStart.call(this);
      return r || this._setupAdminCommonInterceptor();
    };

    Game_Map.prototype._setupAdminCommonInterceptor = function () {
      const typ = $gameTemp._adminInterceptorType;

      const idMap = {
        newGame: Number(ADMIN.NewGameCommonEvent || 0),
        loadGame: Number(ADMIN.LoadGameCommonEvent || 0),
        menuClose: Number(ADMIN.MenuCloseCommonEvent || 0),
      };
      const ceId = idMap[typ];

      const dummyMapId = Number(
        PluginManager.parameters("OnevASSISTANT")["DummyMapId"] || 0
      );

      if ($gameMap.mapId() === dummyMapId && typ === "newGame") {
        $gameTemp._adminInterceptorType = null;
        return false;
      }

      if (ceId > 0 && $dataCommonEvents[ceId] && !this.isEventRunning()) {
        this._interpreter.setup($dataCommonEvents[ceId].list);
        $gameTemp._adminInterceptorType = null;
        return true;
      }

      return false;
    };

    if (PluginManager.registerCommand) {
      PluginManager.registerCommand(
        "OnevASSISTANT",
        "CustomCommonEvent",
        (args) => {
          const name = args.name || "";
          if (name) executeEventTriggers(name);
        }
      );
    }
  })();

  (() => {
    //=========================================================================
    // キャラクター表示・モーション関係
    //=========================================================================

    "use strict";

    const PLUGIN_NAME = "OnevASSISTANT";
    const Easing = window.OnevASSISTANT?.Easing || { linear: (t) => t };
    const PARAMS = PluginManager.parameters(PLUGIN_NAME);
    const FADE_VAR_ID = Number(PARAMS.FadeTimeVariableId || 0);
    function resolveFade(args, en = "fade", jp = "フェード時間(frame)") {
      if (args[en] !== "") return Number(args[en]) || 0;
      const vid = Number(args[jp] || 0) || FADE_VAR_ID;
      return Number($gameVariables.value(vid)) || 0;
    }

    class CharComposeManager {
      constructor() {
        this._list = [];
      }
      register(e) {
        const i = this._list.findIndex((a) => a.pid === e.pid);
        if (i >= 0) this._list[i] = e;
        else this._list.push(e);
      }
      erase(pid) {
        this._list = this._list.filter((a) => a.pid !== pid);
      }
      list() {
        return this._list;
      }
    }
    window.$charCompose = window.$charCompose || new CharComposeManager();
    window._compositeCache = window._compositeCache || {};

    function handleCharacterAppearance(args) {
      const g = (en, jp, def = "") => args[en] ?? args[jp] ?? def;

      const name = g("name", "キャラ識別名");
      const pid = Number(g("pictureId", "ピクチャID", 20));
      const scale = Number(g("scale", "拡大率(%)", 100));
      const mode = g("mode", "出現方法", "通常出現");
      const flip = g("flip", "左右反転", "false") === "true";
      const easing = g("easing", "イージング種別", "linear");
      const useVar = g("useVariable", "座標を変数IDで指定", "false") === "true";
      const fade = resolveFade(args);
      const origin = Number(g("origin", "基点", "1"));

      let tx = Number(g("x", "X座標", 0));
      let ty = Number(g("y", "Y座標", 0));
      if (useVar) {
        tx = $gameVariables.value(tx);
        ty = $gameVariables.value(ty);
      }

      const layerList = JSON.parse(g("layers", "レイヤー構成", "[]")).map(
        (str) => {
          const o = JSON.parse(str);
          return {
            layer: o.layer,
            file: o.file,
            priority: Number(o.priority) || 50,
          };
        }
      );

      const M = 100;
      let sx = tx,
        sy = ty;
      switch (mode) {
        case "左から登場":
          sx = -M;
          break;
        case "右から登場":
          sx = Graphics.width + M;
          break;
        case "上から登場":
          sy = -M;
          break;
        case "下から登場":
          sy = Graphics.height + M;
          break;
      }
      const initA = mode === "通常出現" && fade > 0 ? 0 : 255;

      composeAndShow(
        name,
        pid,
        sx,
        sy,
        scale,
        flip,
        layerList,
        mode,
        initA,
        fade,
        tx,
        ty,
        easing,
        origin
      );
    }

    PluginManager.registerCommand(PLUGIN_NAME, "CharacterAppearance", (args) =>
      handleCharacterAppearance(args)
    );
    PluginManager.registerCommand(PLUGIN_NAME, "キャラクター出現", (args) =>
      handleCharacterAppearance(args)
    );

    function applyScaleToSprite(sprite, scaleValue) {
      const signX = scaleValue < 0 ? -1 : 1;
      const abs = Math.abs(scaleValue);
      const s = abs / 100;
      sprite.scale.x = s * signX;
      sprite.scale.y = s;
      const pic = $gameScreen.picture(sprite._pictureId);
      if (pic) {
        pic._scaleX = abs * signX;
        pic._scaleY = abs;
      }
    }

    function composeAndShow(
      name,
      pid,
      sx,
      sy,
      scale,
      flip,
      layerList,
      mode,
      initA = 255,
      fade = 0,
      tx,
      ty,
      easing = "linear",
      origin = 1
    ) {
      if (tx === undefined) tx = sx;
      if (ty === undefined) ty = sy;

      const sorted = []
        .concat(layerList)
        .sort((a, b) => a.priority - b.priority);
      const bitmaps = new Array(sorted.length);
      let loaded = 0;
      sorted.forEach((L, i) => {
        const bmp = ImageManager.loadBitmap("img/characterset/", L.file);
        bmp.addLoadListener(() => {
          bitmaps[i] = bmp;
          if (++loaded >= sorted.length) doCompose();
        });
      });

      function doCompose() {
        const w = Math.max(...bitmaps.map((b) => b.width));
        const h = Math.max(...bitmaps.map((b) => b.height));
        const composite = new Bitmap(w, h);
        bitmaps.forEach((b) => composite.blt(b, 0, 0, b.width, b.height, 0, 0));

        window._compositeCache[pid] = composite;

        $gameScreen.showPicture(
          pid,
          "",
          origin,
          sx,
          sy,
          scale,
          scale,
          initA,
          0
        );
        const pic = $gameScreen.picture(pid);
        if (pic) {
          pic._x = sx;
          pic._y = sy;
          pic._opacity = initA;
          pic._scaleX = scale * (flip ? -1 : 1);
          pic._scaleY = scale;
        }

        const sp =
          SceneManager._scene._spriteset._pictureContainer.children.find(
            (s) => s._pictureId === pid
          );
        if (!sp) return;
        sp.bitmap = composite;
        applyScaleToSprite(sp, flip ? -scale : scale);
        sp.x = sx;
        sp.y = sy;

        $charCompose.register({
          pid,
          name,
          x: tx,
          y: ty,
          scale,
          flip,
          layers: layerList,
          origin,
        });

        const duration = fade > 0 ? fade : 24;
        if (mode === "通常出現") {
          if (fade > 0) {
            const destScaleX = flip ? -scale : scale;
            $gameScreen.movePicture(
              pid,
              origin,
              tx,
              ty,
              destScaleX,
              scale,
              255,
              0,
              fade
            );
          }
        } else {
          executeCharacterMotion(name, "move", duration, {
            targetX: tx,
            targetY: ty,
            easing,
          });
        }
      }
    }

    function queueForBatch(entry, fade) {
      const pid = entry.pid;
      _pendingBatch[pid] ??= { entry, fade, scheduled: false };
      _pendingBatch[pid].entry = entry;
      _pendingBatch[pid].fade = fade;
      if (!_pendingBatch[pid].scheduled) {
        _pendingBatch[pid].scheduled = true;
        setTimeout(() => {
          const { entry: e, fade: f } = _pendingBatch[pid];
          replaceAndFade(e, f);
          delete _pendingBatch[pid];
        }, 0);
      }
    }

    PluginManager.registerCommand(PLUGIN_NAME, "ChangeLayers", (args) => {
      const g = (en, jp, def = "") => args[en] ?? args[jp] ?? def;
      const name = g("name", "キャラ識別名");
      const fade = resolveFade(args);
      const changes = JSON.parse(g("layers", "レイヤー構成", "[]")).map(
        (str) => {
          const o = JSON.parse(str);
          return { layer: o.layer, file: o.file, priority: null };
        }
      );
      const entry = $charCompose.list().find((e) => e.name === name);
      if (!entry) {
        console.warn(`ChangeLayers: ${name} 未表示`);
        return;
      }
      changes.forEach((ch) => {
        const idx = entry.layers.findIndex((l) => l.layer === ch.layer);
        if (idx >= 0) entry.layers[idx].file = ch.file;
        else
          entry.layers.push({ layer: ch.layer, file: ch.file, priority: 50 });
      });
      queueForBatch(entry, fade);
    });

    function replaceAndFade(entry, fade = 0) {
      const { pid, scale, flip, layers } = entry;
      const sorted = [].concat(layers).sort((a, b) => a.priority - b.priority);
      const bitmaps = new Array(sorted.length);
      let loaded = 0;
      sorted.forEach((L, i) => {
        const bmp = ImageManager.loadBitmap("img/characterset/", L.file);
        bmp.addLoadListener(() => {
          bitmaps[i] = bmp;
          if (++loaded >= sorted.length) doReplace();
        });
      });
      function doReplace() {
        const w = Math.max(...bitmaps.map((b) => b.width));
        const h = Math.max(...bitmaps.map((b) => b.height));
        const cmp = new Bitmap(w, h);
        bitmaps.forEach((b) => cmp.blt(b, 0, 0, b.width, b.height, 0, 0));
        window._compositeCache[pid] = cmp;

        const cont = SceneManager._scene._spriteset._pictureContainer;
        const sp = cont.children.find((s) => s._pictureId === pid);
        if (!sp) return;
        const ov = new Sprite(sp.bitmap);
        ov.x = sp.x;
        ov.y = sp.y;
        ov.anchor = sp.anchor.clone();
        ov.scale = sp.scale.clone();
        cont.addChild(ov);

        sp.bitmap = cmp;
        if (flip) sp.scale.x = -Math.abs(sp.scale.x);

        if (fade > 0) {
          const step = 255 / fade;
          (function tick() {
            ov.opacity -= step;
            if (ov.opacity <= 0) cont.removeChild(ov);
            else requestAnimationFrame(tick);
          })();
        } else cont.removeChild(ov);
      }
    }

    const _pendingBatch = {};

    function eraseComposite(pid) {
      $gameScreen.erasePicture(pid);
      delete window._compositeCache[pid];
      $charCompose.erase(pid);
    }
    window.eraseComposite = eraseComposite;

    const _make = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
      const c = _make.call(this);
      c.charCompose = $charCompose.list();
      return c;
    };
    const _ext = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (c) {
      _ext.call(this, c);
      window.$charCompose = new CharComposeManager();
      if (c.charCompose) c.charCompose.forEach((e) => $charCompose.register(e));
    };

    const _sceneStart = Scene_Map.prototype.start;
    Scene_Map.prototype.start = function () {
      _sceneStart.call(this);
      $charCompose.list().forEach((e) => {
        composeAndShow(
          e.name,
          e.pid,
          e.x,
          e.y,
          e.scale,
          e.flip,
          e.layers,
          "通常出現",
          255,
          0,
          e.x,
          e.y,
          "linear",
          e.origin
        );
      });
    };

    const _motionMap = {};

    function registerBase(pid, type, duration, params) {
      _motionMap[pid] = {
        base: { type, frame: 0, duration, ...params },
        overlay: _motionMap[pid]?.overlay ?? null,
      };
    }

    function registerOverlay(pid, type, duration, params) {
      const rec = _motionMap[pid] ?? { base: null, overlay: null };
      rec.overlay = { type, frame: 0, duration, ...params };
      _motionMap[pid] = rec;
    }

    function executeCharacterMotion(name, type, duration = 24, params = {}) {
      const entry = $charCompose.list().find((e) => e.name === name);
      if (!entry) return;
      const pid = entry.pid;

      const sp = SceneManager._scene._spriteset._pictureContainer.children.find(
        (s) => s._pictureId === pid
      );
      if (!sp) return;

      const moveLike = ["move", "runleft", "runright", "runup", "rundown"];
      const reg = moveLike.includes(type) ? registerBase : registerOverlay;

      reg(pid, type, duration, {
        ...params,
        startX: sp.x,
        startY: sp.y,
        targetX: params.targetX ?? sp.x,
        targetY: params.targetY ?? sp.y,
        startScale: Math.abs(sp.scale.x) * 100,
        targetScale: params.targetScale ?? Math.abs(sp.scale.x) * 100,
        startOpacity: sp.opacity ?? 255,
        targetOpacity: params.targetOpacity ?? 255,
        easing: params.easing || "linear",
      });
    }

    const MotionTypeMap = {
      うなずく: "yes",
      二回うなずく: "yesyes",
      否定: "no",
      ジャンプ: "jump",
      揺れる: "shake",
      笑う: "laugh",
      怒る: "stomp",
      右に消える: "runright",
      左に消える: "runleft",
      上に消える: "runup",
      下に消える: "rundown",
    };

    PluginManager.registerCommand(PLUGIN_NAME, "モーション", (args) => {
      const name = args.name;
      const raw = args.motion || args["モーション"];
      const type = MotionTypeMap[raw] || raw;
      const duration =
        Number(args.duration || args["duration"]) || resolveFade(args) || 24;
      const amplitude = Number(args.amplitude || args["amplitude"]) || 0;
      const easing = args.easing || args["easing"] || "linear";
      executeCharacterMotion(name, type, duration, { amplitude, easing });
    });

    PluginManager.registerCommand(PLUGIN_NAME, "MoveCharacter", (args) => {
      const name = args.name;
      const x = Number(args.x || args["X座標"]) || 0;
      const y = Number(args.y || args["Y座標"]) || 0;
      const duration =
        Number(args.duration || args["duration"]) || resolveFade(args) || 24;
      const scale = Number(args.scale || args["scale"]) || 100;
      const easing = args.easing || args["easing"] || "linear";
      executeCharacterMotion(name, "move", duration, {
        targetX: x,
        targetY: y,
        targetScale: scale,
        easing,
      });
    });

    PluginManager.registerCommand(PLUGIN_NAME, "CharacterExit", (args) => {
      const name = args.name;
      const mode = args.mode || args["mode"] || "通常退場";
      const duration =
        Number(args.duration || args["duration"]) || resolveFade(args) || 24;
      const easing = args.easing || args["easing"] || "linear";

      if (MotionTypeMap[mode]) {
        executeCharacterMotion(name, MotionTypeMap[mode], duration, { easing });
        return;
      }

      const entry = $charCompose.list().find((e) => e.name === name);
      if (!entry) return;
      const pid = entry.pid;
      const cont = SceneManager._scene._spriteset._pictureContainer;
      const sp = cont.children.find((s) => s._pictureId === pid);
      if (!sp) return;

      const ov = new Sprite(sp.bitmap);
      ov.x = sp.x;
      ov.y = sp.y;
      ov.anchor = sp.anchor.clone();
      ov.scale = sp.scale.clone();
      ov.opacity = 255;
      cont.addChild(ov);

      eraseComposite(pid);

      const step = 255 / duration;
      (function tick() {
        ov.opacity -= step;
        if (ov.opacity <= 0) cont.removeChild(ov);
        else requestAnimationFrame(tick);
      })();
    });

    const _SprPicUpd2 = Sprite_Picture.prototype.update;
    Sprite_Picture.prototype.update = function () {
      _SprPicUpd2.call(this);

      const cache = window._compositeCache[this._pictureId];
      if (cache && this.bitmap !== cache) this.bitmap = cache;

      const rec = _motionMap[this._pictureId];
      if (!rec) return;
      if (rec.base) applyMotion(this, rec, rec.base, true);
      if (rec.overlay) applyMotion(this, rec, rec.overlay, false);
    };

    function applyMotion(sp, parent, st, overrideXY) {
      st.frame++;
      const t = Math.min(st.frame / st.duration, 1);
      const e = (Easing[st.easing] || Easing.linear)(t);

      switch (st.type) {
        case "move":
          if (overrideXY) {
            sp.x = st.startX + (st.targetX - st.startX) * e;
            sp.y = st.startY + (st.targetY - st.startY) * e;
          }
          break;
        case "runleft":
          if (overrideXY) sp.x = st.startX - e * (Graphics.width + 300);
          break;
        case "runright":
          if (overrideXY) sp.x = st.startX + e * (Graphics.width + 300);
          break;
        case "runup":
          if (overrideXY)
            sp.y = st.startY - e * (Graphics.height + sp.bitmap.height + 300);
          break;
        case "rundown":
          if (overrideXY)
            sp.y = st.startY + e * (Graphics.height + sp.bitmap.height + 300);
          break;

        case "jump":
          sp.y += -Math.sin(e * Math.PI) * (st.amplitude || 12);
          break;
        case "yes":
          sp.y += Math.sin(e * Math.PI) * (st.amplitude || 6);
          break;
        case "yesyes":
          sp.y += Math.sin(e * Math.PI * 4) * (st.amplitude || 6);
          break;
        case "no":
          sp.x += Math.sin(e * Math.PI * 2) * (st.amplitude || 4);
          break;
        case "shake":
          sp.x += Math.sin(st.frame * 0.5) * (st.amplitude || 2);
          break;
        case "laugh":
          sp.y += Math.sin(e * Math.PI * 3) * (st.amplitudeY || 4);
          sp.x += Math.sin(e * Math.PI * 6) * (st.amplitudeX || 1.5);
          break;
        case "stomp":
          sp.y += Math.abs(Math.sin(e * Math.PI)) * (st.amplitude || 10);
          break;
      }

      if (overrideXY && st.targetScale != null) {
        const s0 = st.startScale / 100,
          s1 = st.targetScale / 100;
        const sign = sp.scale.x < 0 ? -1 : 1;
        const s = s0 + (s1 - s0) * e;
        sp.scale.x = s * sign;
        sp.scale.y = s;
      }
      if (overrideXY && st.targetOpacity != null) {
        sp.opacity = st.startOpacity + (st.targetOpacity - st.startOpacity) * e;
      }

      if (st.frame >= st.duration) {
        if (overrideXY) {
          const pic = $gameScreen.picture(sp._pictureId);
          if (pic) {
            pic._x = sp.x;
            pic._y = sp.y;
          }
          if (overrideXY) parent.base = null;
          else parent.overlay = null;

          const done = !parent.base && !parent.overlay;
          if (done) delete _motionMap[sp._pictureId];

          if (
            done &&
            ["runleft", "runright", "runup", "rundown"].includes(st.type)
          ) {
            eraseComposite(sp._pictureId);
          }
          return;
        }
        if (overrideXY) parent.base = null;
        else parent.overlay = null;
        if (!parent.base && !parent.overlay) delete _motionMap[sp._pictureId];
      }
    }
  })();

  (() => {
    //=========================================================================
    // 画像選択肢
    //=========================================================================

    "use strict";
    const PLUGIN_NAME = "OnevASSISTANT";
    const { getMousePosition, isMouseOverChoice } = OnevASSISTANT;

    function applyImageChoiceHoverEffect(sprite, config) {
      if (!sprite || !config) return;
    }

    ImageManager.loadChoiceImage = function (name) {
      return this.loadBitmap("img/choice/", name, 0, true);
    };

    const _GS_init = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function () {
      _GS_init.call(this);
      this._imageChoices = null;
    };
    Game_System.prototype.setImageChoices = function (list) {
      this._imageChoices = list;
    };
    Game_System.prototype.imageChoices = function () {
      return this._imageChoices;
    };
    Game_System.prototype.clearImageChoices = function () {
      this._imageChoices = null;
    };
    Game_System.prototype.imageChoiceModeValid = function (arr) {
      if (!this._imageChoices || !this._imageChoices.length) return false;
      const names = this._imageChoices.map((c) => c["選択肢名"]);
      return arr.every((t) => names.includes(t));
    };

    PluginManager.registerCommand(PLUGIN_NAME, "setImageChoices", (args) => {
      const raw = JSON.parse(args.choices || "[]");
      const list = raw.map((s) => JSON.parse(s));
      $gameSystem.setImageChoices(list);
    });

    const WCL = Window_ChoiceList.prototype;
    const _wWidth = WCL.windowWidth,
      _wHeight = WCL.windowHeight,
      _init = WCL.initialize,
      _start = WCL.start,
      _update = WCL.update,
      _select = WCL.select,
      _ok = WCL.processOk,
      _cancel = WCL.processCancel;

    WCL.isImageMode = function () {
      return $gameSystem.imageChoiceModeValid($gameMessage.choices());
    };

    WCL.windowWidth = function () {
      return this.isImageMode() ? 0 : _wWidth.call(this);
    };
    WCL.windowHeight = function () {
      return this.isImageMode() ? 0 : _wHeight.call(this);
    };

    WCL.initialize = function (msg) {
      _init.call(this, msg);
      this._choiceSprite = [];
    };

    WCL.start = function () {
      if (this.isImageMode()) this._createImageChoices();
      _start.call(this);
      if (this.isImageMode()) {
        this.x = this.y = 0;
        if (this.index() < 0) this.select(0);
        if (this._downArrowSprite) this._downArrowSprite.visible = false;
        if (this._upArrowSprite) this._upArrowSprite.visible = false;
      }
    };

    WCL.select = function (index) {
      _select.call(this, index);
    };

    WCL._disposeChoiceSprites = function () {
      this._choiceSprite.forEach((sp) => {
        if (sp?.parent) sp.parent.removeChild(sp);
        if (sp?._frame?.parent) sp._frame.parent.removeChild(sp._frame);
        if (sp?._hover?.parent) sp._hover.parent.removeChild(sp._hover);
      });
      this._choiceSprite = [];
    };

    WCL.processOk = function () {
      _ok.call(this);
      this._disposeChoiceSprites();
      $gameSystem.clearImageChoices();
    };
    WCL.processCancel = function () {
      _cancel.call(this);
      this._disposeChoiceSprites();
      $gameSystem.clearImageChoices();
    };

    WCL._createImageChoices = function () {
      const list = $gameSystem.imageChoices();
      const texts = $gameMessage.choices();
      this._choiceSprite = [];

      for (let i = 0; i < texts.length; i++) {
        const info = list.find((c) => c["選択肢名"] === texts[i]);
        if (!info) continue;

        const sp = new Sprite(ImageManager.loadChoiceImage(info.画像));
        sp.x = Number(info.X座標) || 0;
        sp.y = Number(info.Y座標) || 0;
        sp.anchor.set(0.5, 0.5);
        sp._baseX = sp.x;
        sp._baseY = sp.y;
        sp.z = 9999;
        (function initStaticHitRect(sprite) {
          const ax = sprite.anchor.x || 0.5;
          const ay = sprite.anchor.y || 0.5;
          const w = sprite.width || (sprite.bitmap && sprite.bitmap.width) || 0;
          const h =
            sprite.height || (sprite.bitmap && sprite.bitmap.height) || 0;
          const left = sprite._baseX - w * ax;
          const top = sprite._baseY - h * ay;
          sprite._hitLeft = left;
          sprite._hitTop = top;
          sprite._hitRight = left + w;
          sprite._hitBottom = top + h;
        })(sp);

        if (info.UseFrame === "true") {
          console.log(
            `[画像選択肢設定] FrameImage読み込み: img/choice/${info.FrameImage}`
          );
          const f = new Sprite(ImageManager.loadChoiceImage(info.FrameImage));
          f.anchor.set(0.5, 0.5);
          f.visible = false;

          f.x = 0;
          f.y = 0;
          sp.addChild(f);
          sp._frame = f;
        }

        if (info.ExtraImageSetting) {
          const cfg = JSON.parse(info.ExtraImageSetting);
          const imgName = cfg.画像 ?? cfg.Image;
          if (imgName) {
            console.log(
              `[画像選択肢設定] ExtraImageSetting画像読み込み: img/choice/${imgName}`
            );
            const h = new Sprite(ImageManager.loadChoiceImage(imgName));
            h.anchor.set(0.5, 0.5);
            h.x = Number(cfg.OffsetX ?? cfg.X ?? 0);
            h.y = Number(cfg.OffsetY ?? cfg.Y ?? 0);
            h.visible = false;
            SceneManager._scene._windowLayer.addChild(h);
            sp._hover = h;
          }
        }
        SceneManager._scene.addChild(sp);
        this._choiceSprite[i] = sp;
      }
    };

    Window_ChoiceList.prototype._mouseHitIndex = function () {
      const mx = TouchInput.x;
      const my = TouchInput.y;

      for (let i = 0; i < this._choiceSprite.length; i++) {
        const sp = this._choiceSprite[i];
        if (!sp || !sp.bitmap || !sp.bitmap.isReady()) continue;

        const w = sp.bitmap.width * Math.abs(sp.scale.x);
        const h = sp.bitmap.height * Math.abs(sp.scale.y);
        const left = sp.x - w * sp.anchor.x;
        const top = sp.y - h * sp.anchor.y;
        
        const margin = 2;
        if (
          mx >= left - margin &&
          mx <= left + w + margin &&
          my >= top - margin &&
          my <= top + h + margin
        )
          return i;
      }
      return -1;
    };

    WCL.update = function () {
      _update.call(this);
      if (!this.isImageMode()) return;
      if (Input.isTriggered("up")) this._moveImageChoice("up");
      if (Input.isTriggered("down")) this._moveImageChoice("down");
      if (Input.isTriggered("left")) this._moveImageChoice("left");
      if (Input.isTriggered("right")) this._moveImageChoice("right");
      if (Input.dir4 !== 0) this._lastInputType = "keyboard";

      this._lastMouseX = this._lastMouseX ?? TouchInput.x;
      this._lastMouseY = this._lastMouseY ?? TouchInput.y;
      if (
        TouchInput.x !== this._lastMouseX ||
        TouchInput.y !== this._lastMouseY
      ) {
        this._lastInputType = "mouse";
      }
      this._lastMouseX = TouchInput.x;
      this._lastMouseY = TouchInput.y;

      const keyTrig =
        Input.isTriggered("down") ||
        Input.isTriggered("up") ||
        Input.isTriggered("left") ||
        Input.isTriggered("right");

      if (keyTrig) {
        this._lastInputType = "keyboard";
      } else if (TouchInput.isMoved()) {
        this._lastInputType = "mouse";
      }

      const cfgs = $gameSystem.imageChoices();
      const cur = this.index();
      const LERP = 0.2;

      for (let i = 0; i < this._choiceSprite.length; i++) {
        const sp = this._choiceSprite[i];
        const info = cfgs[i];
        if (!sp || !info) continue;

        const bx = sp._baseX;
        const by = sp._baseY;

        if (i === cur) {
          const scaleT = info.UseScale ? (Number(info.Scale) || 100) / 100 : 1;
          const tx = bx + (info.UseOffset ? Number(info.OffsetX || 0) : 0);
          const ty = by + (info.UseOffset ? Number(info.OffsetY || 0) : 0);

          sp.scale.x += (scaleT - sp.scale.x) * LERP;
          sp.scale.y = sp.scale.x;
          sp.x += (tx - sp.x) * LERP;
          sp.y += (ty - sp.y) * LERP;

          if (sp._frame && info.UseFrame === "true") sp._frame.visible = true;
          if (sp._hover) sp._hover.visible = true;
        } else {
          sp.scale.x += (1 - sp.scale.x) * LERP;
          sp.scale.y = sp.scale.x;
          sp.x += (bx - sp.x) * LERP;
          sp.y += (by - sp.y) * LERP;

          if (Math.abs(sp.x - bx) < 0.01) sp.x = bx;
          if (Math.abs(sp.y - by) < 0.01) sp.y = by;

          if (sp._frame && info.UseFrame === "true") sp._frame.visible = false;
          if (sp._hover) sp._hover.visible = false;
        }
      }

      if (this._lastInputType === "mouse") {
        const hit = this._mouseHitIndex();
        if (hit >= 0 && hit !== this.index()) {
          this.select(hit);
          SoundManager.playCursor();
        }
      }

      if (TouchInput.isReleased()) {
        const hit = this._mouseHitIndex();
        if (hit >= 0 && hit === this.index()) this.processOk();
      }

      {
        const _origPCM = Window_ChoiceList.prototype.processCursorMove;
        Window_ChoiceList.prototype.processCursorMove = function () {
          if (this.isImageMode()) return;
          _origPCM.call(this);
        };
      }

      Window_ChoiceList.prototype._moveImageChoice = function (dir) {
        const list = this._choiceSprite;
        if (!list || !list.length) return;

        const cur = this.index();
        const cx = list[cur]._baseX;
        const cy = list[cur]._baseY;

        let best = -1,
          bestPrimary = Infinity,
          bestDist2 = Infinity;

        for (let i = 0; i < list.length; i++) {
          if (i === cur) continue;
          const dx = list[i]._baseX - cx;
          const dy = list[i]._baseY - cy;

          if (dir === "up" && dy >= 0) continue;
          if (dir === "down" && dy <= 0) continue;
          if (dir === "left" && dx >= 0) continue;
          if (dir === "right" && dx <= 0) continue;

          const primary =
            dir === "up" || dir === "down" ? Math.abs(dy) : Math.abs(dx);
          const dist2 = dx * dx + dy * dy;

          if (
            primary < bestPrimary ||
            (primary === bestPrimary && dist2 < bestDist2)
          ) {
            best = i;
            bestPrimary = primary;
            bestDist2 = dist2;
          }
        }

        if (best < 0) {
          if (dir === "up") {
            const maxY = Math.max(...list.map((s) => s._baseY));
            best = list.findIndex((s) => s._baseY === maxY);
          } else if (dir === "down") {
            const minY = Math.min(...list.map((s) => s._baseY));
            best = list.findIndex((s) => s._baseY === minY);
          } else if (dir === "left") {
            const maxX = Math.max(...list.map((s) => s._baseX));
            best = list.findIndex((s) => s._baseX === maxX);
          } else if (dir === "right") {
            const minX = Math.min(...list.map((s) => s._baseX));
            best = list.findIndex((s) => s._baseX === minX);
          }
        }

        if (best >= 0 && best !== cur) {
          this.select(best);
          SoundManager.playCursor();
          this._lastInputType = "keyboard";
        }
      };
    };
    (() => {
      const _updateArrows = Window_ChoiceList.prototype.updateArrows;
      Window_ChoiceList.prototype.updateArrows = function () {
        if ($gameSystem.imageChoiceModeValid($gameMessage.choices())) {
          this.downArrowVisible = false;
          this.upArrowVisible = false;
          return;
        }
        _updateArrows.call(this);
      };
    })();
  })();

  (() => {
    //======================================================================
    // リング選択肢
    //======================================================================

    "use strict";
    let _ringChoiceEnabled = false;
    let _ringChoiceConfig = null;
    let _ringChoiceSprites = [];
    let _ringChoiceBaseSprite = null;
    let _currentRingIndex = 0;
    let _currentVirtualIndex = 0;
    let _menuEnabledBeforeRingChoice = true;
    let _ringChoiceClickGuard = false;

    function setMenuEnabled(enabled) {
      if (
        SceneManager._scene &&
        SceneManager._scene._menuEnabled !== undefined
      ) {
        SceneManager._scene._menuEnabled = enabled;
      }
    }

    function getMenuEnabled() {
      if (
        SceneManager._scene &&
        SceneManager._scene._menuEnabled !== undefined
      ) {
        return SceneManager._scene._menuEnabled;
      }
      return true;
    }

    function parseChoiceList(raw) {
      if (!raw) return [];
      let arr = raw;
      if (typeof arr === "string") arr = JSON.parse(raw);
      return arr.map((item) =>
        typeof item === "string" ? JSON.parse(item) : item
      );
    }

    PluginManager.registerCommand("OnevASSISTANT", "リング選択肢", (args) => {
      _ringChoiceEnabled = true;
      let choiceList = parseChoiceList(args["選択肢リスト"]);
      const realImages = choiceList.map((c) => c["画像"]);
      const commonEvents = choiceList.map((c) => Number(c["コモンイベント"]));
      const realCount = realImages.length;
      let virtualCount = Number(args["仮想選択肢数"]);
      if (!virtualCount || virtualCount < 1) virtualCount = realCount;
      const initialIndexVarId = Number(args["初期選択インデックス変数"] || 0);
      let initialIndex = 0;
      if (initialIndexVarId > 0) {
        initialIndex = $gameVariables.value(initialIndexVarId) || 0;
      } else if (args["初期選択インデックス"]) {
        initialIndex = Number(args["初期選択インデックス"]) || 0;
      }
      const initialAngleDeg = Number(args["初期角度"] || 0);
      const initialAngleRad = (initialAngleDeg * Math.PI) / 180;

      let baseX = 0;
      let baseY = 0;
      const useVariablePosition = args["変数で指定"] === "true";

      if (useVariablePosition) {
        const xAxisVarId = Number(args["X軸"] || 0);
        const yAxisVarId = Number(args["Y軸"] || 0);
        baseX = xAxisVarId > 0 ? $gameVariables.value(xAxisVarId) || 0 : 0;
        baseY = yAxisVarId > 0 ? $gameVariables.value(yAxisVarId) || 0 : 0;
      } else {
        baseX = Number(args["X軸"] || 0);
        baseY = Number(args["Y軸"] || 0);
      }

      const offsetX = Number(args["リング選択肢オフセットX"] || 0);
      const offsetY = Number(args["リング選択肢オフセットY"] || 0);

      let selectSe = null,
        okSe = null;
      if (args["選択音"]) {
        try {
          selectSe =
            typeof args["選択音"] === "string"
              ? JSON.parse(args["選択音"])
              : args["選択音"];
        } catch (e) {}
      }
      if (args["決定音"]) {
        try {
          okSe =
            typeof args["決定音"] === "string"
              ? JSON.parse(args["決定音"])
              : args["決定音"];
        } catch (e) {}
      }

      _ringChoiceConfig = {
        baseX: baseX,
        baseY: baseY,
        baseOffsetX: offsetX,
        baseOffsetY: offsetY,
        baseImage: args["土台画像"] || "",
        maskImage: args["マスク画像"] || "",
        choiceImages: realImages,
        commonEvents: commonEvents,
        circleRadius: Number(args["円の大きさ"] || 100),
        easingType: args["イージングタイプ"] || "easeOutQuad",
        duration: Number(args["移動時間"] || 24),
        virtualCount: virtualCount,
        initialIndex: initialIndex,
        initialAngleRad: initialAngleRad,
        enlargeSelected: args["拡大表示"] === "true",
        rotateContinuously: args["一周回転"] === "true",
        cancelAction: args["キャンセル動作"] || "終了",
        selectSe: selectSe,
        okSe: okSe,
      };
      showRingChoice();
    });

    function calculateRingPositions(
      count,
      radius,
      centerX,
      centerY,
      offsetRad = 0
    ) {
      const positions = [];
      const angleStep = (2 * Math.PI) / count;
      for (let i = 0; i < count; i++) {
        const angle = angleStep * i + offsetRad;
        const x = centerX + Math.cos(angle) * radius;
        const y = centerY + Math.sin(angle) * radius;
        positions.push({ x, y, angle });
      }
      return positions;
    }

    function showRingChoice() {
      if (!_ringChoiceEnabled || !_ringChoiceConfig) return;
      _ringChoiceClickGuard = true;
      const config = _ringChoiceConfig;
      const realImages = config.choiceImages;
      const realCount = realImages.length;
      const virtualCount = config.virtualCount;
      const initialIndex = Math.max(
        0,
        Math.min(config.initialIndex, realCount - 1)
      );
      const initialAngleRad = config.initialAngleRad || 0;

      _currentVirtualIndex = initialIndex;
      _currentRingIndex = initialIndex % realCount;

      const centerX = config.baseX + (config.baseOffsetX || 0);
      const centerY = config.baseY + (config.baseOffsetY || 0);

      config.centerX = centerX;
      config.centerY = centerY;

      const angleStep = (2 * Math.PI) / virtualCount;
      const adjustedInitialAngle = initialAngleRad - initialIndex * angleStep;

      const ringPositions = calculateRingPositions(
        virtualCount,
        config.circleRadius,
        centerX,
        centerY,
        adjustedInitialAngle
      );

      if (config.baseImage) {
        _ringChoiceBaseSprite = new Sprite(
          ImageManager.loadBitmap("img/choice/", config.baseImage)
        );
        _ringChoiceBaseSprite.anchor.set(0.5);
        _ringChoiceBaseSprite.x = config.baseX;
        _ringChoiceBaseSprite.y = config.baseY;
        SceneManager._scene.addChild(_ringChoiceBaseSprite);
      }

      let ringChoiceContainer = null;
      if (config.maskImage) {
        ringChoiceContainer = new PIXI.Container();
        ringChoiceContainer.x = centerX;
        ringChoiceContainer.y = centerY;
        SceneManager._scene.addChild(ringChoiceContainer);

        const maskSprite = new Sprite(
          ImageManager.loadBitmap("img/choice/", config.maskImage)
        );
        maskSprite.anchor.set(0.5);
        maskSprite.x = 0;
        maskSprite.y = 0;
        ringChoiceContainer.mask = maskSprite;
        ringChoiceContainer.addChild(maskSprite);

        config.ringChoiceContainer = ringChoiceContainer;
      }

      _ringChoiceSprites = [];
      let loadedCount = 0;
      for (let i = 0; i < realCount; i++) {
        if (i >= virtualCount) break;

        const bitmap = ImageManager.loadBitmap("img/choice/", realImages[i]);
        bitmap.addLoadListener(() => {
          if (bitmap.isError()) return;

          const sprite = new Sprite(bitmap);
          sprite.anchor.set(0.5);
          sprite.x = ringPositions[i].x;
          sprite.y = ringPositions[i].y;
          sprite._startX = ringPositions[i].x;
          sprite._startY = ringPositions[i].y;
          sprite._targetX = ringPositions[i].x;
          sprite._targetY = ringPositions[i].y;
          sprite._frame = 0;
          sprite._duration = config.duration;
          sprite._easingType = config.easingType;
          sprite._isAnimating = false;
          sprite._index = i;
          sprite.scale.set(1.0, 1.0);
          sprite._isSelected = false;

          _ringChoiceSprites[i] = sprite;

          if (config.ringChoiceContainer) {
            sprite.x = ringPositions[i].x - centerX;
            sprite.y = ringPositions[i].y - centerY;
            sprite._startX = ringPositions[i].x - centerX;
            sprite._startY = ringPositions[i].y - centerY;
            sprite._targetX = ringPositions[i].x - centerX;
            sprite._targetY = ringPositions[i].y - centerY;
            config.ringChoiceContainer.addChild(sprite);
          } else {
            SceneManager._scene.addChild(sprite);
          }

          loadedCount++;
          if (loadedCount === Math.min(realCount, virtualCount)) {
            _ringChoiceSprites.forEach((sprite, j) => {
              if (!sprite) return;
              if (j === _currentRingIndex) {
                const shouldEnlarge = config.enlargeSelected !== false;
                const scale = shouldEnlarge ? 1.2 : 1.0;
                sprite.scale.set(scale, scale);
                sprite._isSelected = true;
              } else {
                sprite.scale.set(1.0, 1.0);
                sprite._isSelected = false;
              }
            });
          }
        });
      }

      setTimeout(() => {
        _ringChoiceSprites.forEach((sprite, i) => {
          if (!sprite) return;
          if (i === _currentRingIndex) {
            const shouldEnlarge = config.enlargeSelected !== false;
            const scale = shouldEnlarge ? 1.2 : 1.0;
            sprite.scale.set(scale, scale);
            sprite._isSelected = true;
          } else {
            sprite.scale.set(1.0, 1.0);
            sprite._isSelected = false;
          }
        });
      }, 0);
    }

    function updateRingChoiceAnimation() {
      if (!_ringChoiceEnabled || !_ringChoiceSprites) return;
      _ringChoiceSprites.forEach((sprite, index) => {
        if (sprite && sprite._isAnimating) {
          sprite._frame++;
          const progress = sprite._frame / sprite._duration;
          if (progress >= 1) {
            sprite.x = sprite._targetX;
            sprite.y = sprite._targetY;
            sprite._isAnimating = false;
          } else {
            const eased = (Easing[sprite._easingType] || Easing.linear)(
              progress
            );
            sprite.x =
              sprite._startX + (sprite._targetX - sprite._startX) * eased;
            sprite.y =
              sprite._startY + (sprite._targetY - sprite._startY) * eased;
          }
        }
      });
    }

    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
      _Scene_Map_update.call(this);
      updateRingChoiceAnimation();
      if (!_ringChoiceEnabled) return;
      if (_ringChoiceClickGuard) {
        if (!TouchInput.isPressed() && !Input.isPressed("ok")) {
          _ringChoiceClickGuard = false;
        } else {
          return;
        }
      }

      if (
        Input.isTriggered("up") ||
        Input.isTriggered("down") ||
        OnevASSISTANT.getWheelInput("up") ||
        OnevASSISTANT.getWheelInput("down")
      ) {
        const dir =
          Input.isTriggered("up") || OnevASSISTANT.getWheelInput("up") ? -1 : 1;
        moveRingSelection(dir);
      }

      if (Input.isTriggered("ok") || TouchInput.isTriggered()) {
        selectRingChoice();
      }

      if (Input.isTriggered("cancel")) {
        handleRingChoiceCancel();
      }
    };

    function moveRingSelection(direction) {
      if (_ringChoiceSprites.length === 0) return;

      const config = _ringChoiceConfig;
      const realCount = _ringChoiceSprites.length;
      const virtualCount = config.virtualCount;
      const initialAngle = config.initialAngleRad || 0;
      const centerX = config.centerX;
      const centerY = config.centerY;
      const hasMask = !!config.ringChoiceContainer;
      const toLocalX = (x) => (hasMask ? x - centerX : x);
      const toLocalY = (y) => (hasMask ? y - centerY : y);
      const easeSelected = config.enlargeSelected !== false;
      const selScale = easeSelected ? 1.2 : 1.0;
      const loop = config.rotateContinuously !== false;
      const setAnim = (oldPos, newPos) => {
        for (let i = 0; i < realCount; i++) {
          const spr = _ringChoiceSprites[i];
          if (!spr) continue;
          spr._startX = toLocalX(oldPos[i].x);
          spr._startY = toLocalY(oldPos[i].y);
          spr._targetX = toLocalX(newPos[i].x);
          spr._targetY = toLocalY(newPos[i].y);
          spr._frame = 0;
          spr._isAnimating = true;
        }
      };

      let moved = false;

      if (direction === 0) {
        const prevIndex = _currentRingIndex;
        const newRing = 0;
        const newVirt = 0;
        const oldOffset =
          initialAngle - (_currentVirtualIndex * 2 * Math.PI) / virtualCount;
        const newOffset = initialAngle - (newVirt * 2 * Math.PI) / virtualCount;
        setAnim(
          calculateRingPositions(
            virtualCount,
            config.circleRadius,
            centerX,
            centerY,
            oldOffset
          ),
          calculateRingPositions(
            virtualCount,
            config.circleRadius,
            centerX,
            centerY,
            newOffset
          )
        );

        if (_ringChoiceSprites[prevIndex]) {
          _ringChoiceSprites[prevIndex].scale.set(1.0, 1.0);
          _ringChoiceSprites[prevIndex]._isSelected = false;
        }
        _ringChoiceSprites[newRing].scale.set(selScale, selScale);
        _ringChoiceSprites[newRing]._isSelected = true;

        _currentRingIndex = newRing;
        _currentVirtualIndex = newVirt;
        moved = prevIndex !== newRing;
      } else {
        const prevIndex = _currentRingIndex;
        let newRing = direction > 0 ? prevIndex + 1 : prevIndex - 1;

        if (!loop && (newRing < 0 || newRing >= realCount)) return;
        newRing = (newRing + realCount) % realCount;

        let newVirt = newRing;
        if (virtualCount > realCount) {
          if (loop) {
            newVirt =
              (_currentVirtualIndex + (direction > 0 ? 1 : -1) + virtualCount) %
              virtualCount;
            while (newVirt >= realCount) {
              newVirt =
                (newVirt + (direction > 0 ? 1 : -1) + virtualCount) %
                virtualCount;
            }
          } else {
            newVirt = newRing;
          }
        }

        _currentRingIndex = newRing;
        _currentVirtualIndex = newVirt;

        const oldVirt = (newVirt - direction + virtualCount) % virtualCount;
        const oldOff = initialAngle - (oldVirt * 2 * Math.PI) / virtualCount;
        const newOff = initialAngle - (newVirt * 2 * Math.PI) / virtualCount;
        setAnim(
          calculateRingPositions(
            virtualCount,
            config.circleRadius,
            centerX,
            centerY,
            oldOff
          ),
          calculateRingPositions(
            virtualCount,
            config.circleRadius,
            centerX,
            centerY,
            newOff
          )
        );

        if (_ringChoiceSprites[prevIndex]) {
          _ringChoiceSprites[prevIndex].scale.set(1.0, 1.0);
          _ringChoiceSprites[prevIndex]._isSelected = false;
        }
        _ringChoiceSprites[newRing].scale.set(selScale, selScale);
        _ringChoiceSprites[newRing]._isSelected = true;
        moved = prevIndex !== newRing;
      }

      if (moved && config.selectSe && config.selectSe.name) {
        AudioManager.playSe(config.selectSe);
      }
    }

    function selectRingChoice() {
      if (!_ringChoiceSprites[_currentRingIndex]) return;
      const config = _ringChoiceConfig;
      const realCount = _ringChoiceSprites.length;

      if (_currentVirtualIndex >= realCount) {
        return;
      }

      if (config.okSe && config.okSe.name) {
        AudioManager.playSe(config.okSe);
      }

      const ceId = Number(config.commonEvents[_currentVirtualIndex]);
      if (ceId > 0) {
        $gameTemp.reserveCommonEvent(ceId);
      }
      cleanupRingChoice();
    }

    function handleRingChoiceCancel() {
      const config = _ringChoiceConfig;
      if (config.cancelAction === "index0に戻る") {
        moveRingSelection(0);
      } else {
        cleanupRingChoice();
      }
    }

    function cleanupRingChoice() {
      _ringChoiceEnabled = false;
      _ringChoiceConfig = null;
      if (_ringChoiceBaseSprite && _ringChoiceBaseSprite.parent) {
        _ringChoiceBaseSprite.parent.removeChild(_ringChoiceBaseSprite);
      }
      _ringChoiceBaseSprite = null;
      if (_ringChoiceSprites) {
        _ringChoiceSprites.forEach((sprite) => {
          if (sprite && sprite.parent) sprite.parent.removeChild(sprite);
        });
      }
      _ringChoiceSprites = [];
      _currentRingIndex = 0;
      _currentVirtualIndex = 0;

      if (_ringChoiceConfig && _ringChoiceConfig.ringChoiceContainer) {
        if (_ringChoiceConfig.ringChoiceContainer.parent) {
          _ringChoiceConfig.ringChoiceContainer.parent.removeChild(
            _ringChoiceConfig.ringChoiceContainer
          );
        }
        _ringChoiceConfig.ringChoiceContainer = null;
      }

      setMenuEnabled(_menuEnabledBeforeRingChoice);
      _ringChoiceClickGuard = false;
    }

    const _Game_Interpreter_pluginCommand =
      Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args) {
      _Game_Interpreter_pluginCommand.call(this, command, args);
      if (command === "リング選択肢") {
        if (this.setWaitMode) {
          this.setWaitMode("ringChoice");
        }
        _menuEnabledBeforeRingChoice = getMenuEnabled();
        setMenuEnabled(false);
      }
    };

    const _Scene_Map_isMenuEnabled = Scene_Map.prototype.isMenuEnabled;
    Scene_Map.prototype.isMenuEnabled = function () {
      if (_ringChoiceEnabled) {
        return false;
      }
      return _Scene_Map_isMenuEnabled.call(this);
    };
  })();

  (() => {
    //=========================================================================
    // クロスフェードBGM
    //=========================================================================

    const pluginName = "OnevASSISTANT";
    OnevASSISTANT.crossFadeBgm = function (params) {
      const name = params.name;
      const tgtVol = params.volume / 100;
      const pitch = params.pitch / 100;
      const pan = params.pan / 100;
      const fadeTime = params.fadeTime;

      const oldBuffer = AudioManager._bgmBuffer;
      if (!oldBuffer) {
        AudioManager.playBgm({
          name,
          volume: params.volume,
          pitch: params.pitch,
          pan: params.pan,
        });
        return;
      }

      const newBuffer = new WebAudio(`audio/bgm/${name}.ogg`);
      newBuffer.pitch = pitch;
      newBuffer.pan = pan;
      newBuffer.volume = 0;
      newBuffer.play(true);

      const startCrossFade = () => {
        const step = 30;
        const steps = Math.ceil(fadeTime / step);
        let count = 0;
        const oldStartVol = oldBuffer._volume;

        const id = setInterval(() => {
          count++;
          const t = count / steps;
          oldBuffer.volume = oldStartVol * (1 - t);
          newBuffer.volume = tgtVol * t;
          if (count >= steps) {
            clearInterval(id);
            oldBuffer.stop();
            AudioManager._bgmBuffer = newBuffer;
            AudioManager._currentBgm = {
              name,
              volume: params.volume,
              pitch: params.pitch,
              pan: params.pan,
              pos: 0,
            };
          }
        }, step);
      };

      if (newBuffer.isReady()) {
        startCrossFade();
      } else {
        newBuffer.addLoadListener(startCrossFade);
      }
    };

    PluginManager.registerCommand(pluginName, "crossFadeBgm", (args) => {
      OnevASSISTANT.crossFadeBgm({
        name: args.name,
        volume: Number(args.volume || 90),
        pitch: Number(args.pitch || 100),
        pan: Number(args.pan || 0),
        fadeTime: Number(args.fadeTime || 2000),
      });
    });
  })();

  var RecollectionCursorState = null;
  (() => {
    //======================================================================
    // 回想シーン設定
    //======================================================================

    "use strict";
    SceneManager._forceFadeInDuration = 0;

    function Scene_Recollection() {
      this.initialize(...arguments);
    }
    window.Scene_Recollection = Scene_Recollection;

    Scene_Recollection.prototype = Object.create(Scene_Base.prototype);
    Scene_Recollection.prototype.constructor = Scene_Recollection;

    Scene_Recollection.prototype.initialize = function () {
      Scene_Base.prototype.initialize.call(this);

      const param = OnevASSISTANT.safeJsonParse(
        OnevASSISTANT.getPluginParameter(
          "OnevASSISTANT",
          "RecollectionSettings"
        ),
        {}
      );
      this._activeSwitches = JSON.parse(
        param.RecollectionActiveSwitches || "[]"
      ).map(Number);
      this._activeSwitches.forEach(
        (id) => id && $gameSwitches.setValue(id, true)
      );

      this._page = 1;
      this._cursorIndex = -1;
      this._sprites = [];
      this._frames = [];
      this._choiceSprites = [];
      this._tabCursorIndex = 0;
      this._focusTarget = "tab";
      this._inputMode = "keyboard";
      this._lastMouseX = 0;
      this._lastMouseY = 0;
      this._selected = false;
      this._cancelBaseSprite = null;
      this._cancelConfirmActive = false;
      this._cancelConfirmIndex = 0;
      this._cancelConfirmSprites = [];
      this._cancelConfirmFrames = [];
      this._pendingExit = false;
      this._exitFadeInAfter = 30;

      if (window.RecollectionCursorState) {
        this._page = window.RecollectionCursorState.page;
        this._tabCursorIndex = window.RecollectionCursorState.tabIndex;
        this._cursorIndex = window.RecollectionCursorState.choiceIndex;
        this._focusTarget = "choice";
        window.RecollectionCursorState = null;
      }
    };

    Scene_Recollection.prototype.create = function () {
      Scene_Base.prototype.create.call(this);
      this._loadParams();
      this._setupBackground();
      this._setupBgm();
      this._createCursor();
      this._createTabs();

      if (this._tabCursorCfg.Image) {
        this._tabCursorSprite = new Sprite(
          ImageManager.loadBitmap("img/Recollection/", this._tabCursorCfg.Image)
        );
        this._tabCursorSprite.anchor.set(0.5);
        this._tabCursorSprite.visible = true;
        this.addChild(this._tabCursorSprite);
      }

      this._changePage(this._page);
      this._updateTabCursor();
      if (this._cursorSprite) {
        this.removeChild(this._cursorSprite);
        this.addChild(this._cursorSprite);
        this._cursorSprite.visible = this._focusTarget === "choice";
      }

      if (
        this._focusTarget === "choice" &&
        this._cursorIndex >= 0 &&
        this._cursorIndex < this._choiceSprites.length
      ) {
        this.setChildIndex(this._cursorSprite, this.children.length - 1);
        this._updateCursor(true);
      }
    };

    Scene_Recollection.prototype._loadParams = function () {
      const s = JSON.parse(
        PluginManager.parameters("OnevASSISTANT")["RecollectionSettings"] ||
          "{}"
      );

      this._tabButtons = OnevASSISTANT.parseDeep(s.Tabs || "[]");
      this._cursorCfg = JSON.parse(s.CursorConfig || "{}");
      this._selSe = JSON.parse(s.SelectSE || "{}");
      this._okSe = JSON.parse(s.OkSE || "{}");

      const rawCancel =
        typeof s.RecollectionCancelsetting === "string"
          ? JSON.parse(s.RecollectionCancelsetting)
          : s.RecollectionCancelsetting || {};
      this._cancelCfg = {
        BaseImage: rawCancel.BaseImage || "",
        Choices: JSON.parse(rawCancel.Choices || "[]").map((v) => {
          const o = typeof v === "string" ? JSON.parse(v) : v;
          if (o.HoverEffect) o.HoverEffect = JSON.parse(o.HoverEffect);
          return o;
        }),
      };

      this._choices = JSON.parse(s.Choices || "[]").map((v) => {
        const o = JSON.parse(v);
        if (o.HoverEffect) o.HoverEffect = JSON.parse(o.HoverEffect);
        return o;
      });

      this._tabBackgrounds = JSON.parse(s.TabBackgrounds || "[]").map((v) => {
        const o = JSON.parse(v);
        o.Page = Number(o.Page || 1);
        o.X = Number(o.X || 0);
        o.Y = Number(o.Y || 0);
        return o;
      });

      this._tabCursorCfg = JSON.parse(s.TabCursor || "{}");
      this._maxPage = this._choices.reduce(
        (mx, c) => Math.max(mx, Number(c.Page || 1)),
        1
      );
    };

    Scene_Recollection.prototype._setupBackground = function () {
      const bg = JSON.parse(
        PluginManager.parameters("OnevASSISTANT")["RecollectionSettings"] ||
          "{}"
      ).Background;
      if (bg) {
        this._baseBackgroundSprite = new Sprite(
          ImageManager.loadBitmap("img/Recollection/", bg)
        );
        this.addChild(this._baseBackgroundSprite);
      }
    };

    Scene_Recollection.prototype._setupBgm = function () {
      const bgm = JSON.parse(
        JSON.parse(
          PluginManager.parameters("OnevASSISTANT")["RecollectionSettings"] ||
            "{}"
        ).BGM || "{}"
      );
      if (bgm.name)
        OnevASSISTANT.crossFadeBgm({
          name: String(bgm.name),
          volume: +bgm.volume || 90,
          pitch: +bgm.pitch || 100,
          pan: +bgm.pan || 0,
          fadeTime: 1000,
        });
    };

    Scene_Recollection.prototype._clearSprites = function () {
      this._sprites.forEach((sp) => this.removeChild(sp));
      this._frames.forEach((fr) => fr && this.removeChild(fr));
      this._sprites = [];
      this._frames = [];
      this._choiceSprites = [];
    };

    Scene_Recollection.prototype._clearTabSprites = function () {
      if (this._tabSprites)
        this._tabSprites.forEach((sp) => this.removeChild(sp));
      if (this._tabFrames)
        this._tabFrames.forEach((fr) => fr && this.removeChild(fr));
      this._tabSprites = [];
      this._tabFrames = [];
    };

    Scene_Recollection.prototype._createTabs = function () {
      this._clearTabSprites();

      this._tabSprites = [];
      this._tabFrames = [];

      this._tabButtons.forEach((tab, idx) => {
        if (!tab.Image) return;

        const sp = new Sprite(
          ImageManager.loadBitmap("img/Recollection/", tab.Image)
        );
        sp.anchor.set(0.5);
        sp.x = +tab.X || 0;
        sp.y = +tab.Y || 0;
        sp._tabPage = +tab.Page || 1;
        this.addChild(sp);
        this._tabSprites.push(sp);

        if (tab.FrameImage) {
          const fr = new Sprite(
            ImageManager.loadBitmap("img/Recollection/", tab.FrameImage)
          );
          fr.anchor.set(0.5);
          fr.x = sp.x;
          fr.y = sp.y;
          fr.visible = idx === this._tabCursorIndex;
          this.addChild(fr);
          this._tabFrames[idx] = fr;
        } else {
          this._tabFrames[idx] = null;
        }
      });
    };

    Scene_Recollection.prototype._createChoices = function () {
      const oldSprites = this._choiceSprites || [];
      const oldFrames = this._frames || [];

      const newSprites = [];
      const newFrames = [];

      let imagesToLoad = 0;
      let imagesLoaded = 0;

      this._choices.forEach((it) => {
        if (+it.Page !== this._page) return;

        const enabled =
          +it.ShowSwitch === 0 ||
          OnevASSISTANT.checkSwitches([+it.ShowSwitch], true);
        const imgName = enabled ? it.EnabledImage : it.DisabledImage;
        if (!imgName) return;

        const bmp = ImageManager.loadBitmap("img/Recollection/", imgName);
        const sp = new Sprite(bmp);
        sp.anchor.set(0.5);
        sp.x = +it.X || 0;
        sp.y = +it.Y || 0;
        sp.scale.set((+it.Scale || 100) / 100);
        sp.visible = false;

        const eff = it.HoverEffect || {};
        sp._baseX = sp.x;
        sp._baseY = sp.y;
        sp._baseScale = sp.scale.x;
        sp._hoverScale =
          eff.UseScale === "true" ? (+eff.Scale || 100) / 100 : sp._baseScale;
        sp._hoverOffsetX = eff.UseOffset === "true" ? +eff.OffsetX : 0;
        sp._hoverOffsetY = eff.UseOffset === "true" ? +eff.OffsetY : 0;

        sp._recCfg = it;
        sp._recEnabled = enabled;

        imagesToLoad++;
        bmp.addLoadListener(() => {
          sp.visible = true;
          imagesLoaded++;
          if (imagesLoaded >= imagesToLoad) {
            oldSprites.forEach((s) => this.removeChild(s));
            oldFrames.forEach((f) => f && this.removeChild(f));

            if (this._cursorIndex < 0) this._cursorIndex = 0;
            this._updateCursor(true);
          }
        });

        this.addChild(sp);
        newSprites.push(sp);

        let frameSprite = null;
        if (enabled && (eff.UseFrame === true || eff.UseFrame === "true")) {
          const fbmp = ImageManager.loadBitmap(
            "img/Recollection/",
            eff.FrameImage
          );
          const fr = new Sprite(fbmp);
          fr.anchor.set(0.5);

          fr.x = fr._baseX = sp._baseX;
          fr.y = fr._baseY = sp._baseY;
          fr._baseScale = 1.0;
          fr._enabled = enabled;
          fr._targetX = fr._baseX;
          fr._targetY = fr._baseY;
          fr._targetScale = fr._baseScale;

          fr.visible = false;
          this.addChild(fr);
          frameSprite = fr;
        }

        newFrames.push(frameSprite);
      });

      this._choiceSprites = newSprites;
      this._sprites = newSprites;
      this._frames = newFrames;

      if (newSprites.length) {
        if (this._focusTarget !== "choice" || this._cursorIndex < 0) {
          this._cursorIndex = 0;
        }
        this._updateCursor(true);

        if (
          this._focusTarget === "choice" &&
          this._cursorIndex >= 0 &&
          this._cursorIndex < newSprites.length
        ) {
          this._updateCursor(true);
          const tgt = this._choiceSprites[this._cursorIndex];
          if (this._cursorSprite && tgt) {
            const targetX = tgt._baseX + (+this._cursorCfg.OffsetX || 0);
            const targetY = tgt._baseY + (+this._cursorCfg.OffsetY || 0);
            this._cursorSprite.x = targetX;
            this._cursorSprite.y = targetY;
            this._cursorSprite._targetX = targetX;
            this._cursorSprite._targetY = targetY;
          }
        }

        if (
          this._focusTarget === "choice" &&
          this._cursorIndex >= 0 &&
          this._cursorIndex < newSprites.length
        ) {
          this._choiceSprites.forEach((sp, i) => {
            const hov = i === this._cursorIndex;
            sp._targetX = sp._baseX + (hov ? sp._hoverOffsetX : 0);
            sp._targetY = sp._baseY + (hov ? sp._hoverOffsetY : 0);
            sp._targetScale = hov ? sp._hoverScale : sp._baseScale;

            if (hov) {
              sp.x = sp._targetX;
              sp.y = sp._targetY;
              sp.scale.set(sp._targetScale, sp._targetScale);
            }

            const fr = this._frames[i];
            if (fr) {
              fr.visible = hov;
              fr._targetX = sp._targetX;
              fr._targetY = sp._targetY;
              fr._targetScale = sp._targetScale;

              if (hov) {
                fr.x = fr._targetX;
                fr.y = fr._targetY;
                if (fr._targetScale != null) {
                  fr.scale.set(fr._targetScale, fr._targetScale);
                }
              }
            }
          });
        }
      }
    };

    Scene_Recollection.prototype._createCursor = function () {
      const cfg = this._cursorCfg;
      if (!cfg.Image) return;
      this._cursorSprite = new Sprite(
        ImageManager.loadBitmap("img/Recollection/", cfg.Image)
      );
      this._cursorSprite.anchor.set(0.5);
      this._cursorSprite.visible = false;
      this._cursorCfg.OffsetX = Number(cfg.OffsetX) || 0;
      this._cursorCfg.OffsetY = Number(cfg.OffsetY) || 0;
      this.addChild(this._cursorSprite);
    };

    Scene_Recollection.prototype._updateTabCursor = function () {
      this._tabFrames.forEach(
        (fr, i) => fr && (fr.visible = i === this._tabCursorIndex)
      );

      if (this._tabCursorSprite) {
        const sp = this._tabSprites[this._tabCursorIndex];
        if (sp && sp.bitmap && sp.bitmap.isReady()) {
          this._tabCursorSprite.visible = true;
          this._tabCursorSprite.x = sp.x + (+this._tabCursorCfg.OffsetX || 0);
          this._tabCursorSprite.y = sp.y + (+this._tabCursorCfg.OffsetY || 0);
        } else {
          this._tabCursorSprite.visible = false;
        }
      }
    };

    Scene_Recollection.prototype._updateCursor = function (skipSe = false) {
      if (this._cancelConfirmActive) return;
      if (this._selected) return;
      if (
        this._cursorIndex < 0 ||
        this._cursorIndex >= this._choiceSprites.length
      ) {
        if (this._cursorSprite) this._cursorSprite.visible = false;
        return;
      }

      this._choiceSprites.forEach((sp, i) => {
        const hov = i === this._cursorIndex;
        sp._targetX = sp._baseX + (hov ? sp._hoverOffsetX : 0);
        sp._targetY = sp._baseY + (hov ? sp._hoverOffsetY : 0);
        sp._targetScale = hov ? sp._hoverScale : sp._baseScale;
        const fr = this._frames[i];
        if (fr) {
          fr.visible = hov && sp._recEnabled;
          fr._targetX = sp._targetX;
          fr._targetY = sp._targetY;
          fr._targetScale = sp._targetScale;

          if (hov) {
            fr.x = fr._targetX;
            fr.y = fr._targetY;
            if (fr._targetScale != null) {
              fr.scale.set(fr._targetScale, fr._targetScale);
            }
          } else {
            fr.x = sp._baseX;
            fr.y = sp._baseY;
            fr.scale.set(1.0, 1.0);
          }
        }
      });

      const tgt = this._choiceSprites[this._cursorIndex];
      if (this._cursorSprite) {
        this._cursorSprite.visible = true;
        this._cursorSprite._targetX =
          tgt._targetX + (+this._cursorCfg.OffsetX || 0);
        this._cursorSprite._targetY =
          tgt._targetY + (+this._cursorCfg.OffsetY || 0);

        this.setChildIndex(this._cursorSprite, this.children.length - 1);
      }

      if (!skipSe && this._selSe.name)
        AudioManager.playSe({
          name: this._selSe.name,
          volume: +this._selSe.volume || 90,
          pitch: +this._selSe.pitch || 100,
          pan: +this._selSe.pan || 0,
        });
    };

    Scene_Recollection.prototype._moveCursor = function (dir) {
      if (this._selected) return;
      const curIdx = this._cursorIndex;
      const curSp = this._choiceSprites[curIdx];
      if (!curSp) return;
      const cx = curSp._baseX,
        cy = curSp._baseY;

      const cands = [];
      this._choiceSprites.forEach((sp, i) => {
        if (i === curIdx) return;
        const dx = sp._baseX - cx;
        const dy = sp._baseY - cy;
        if (
          (dir === "up" && dy >= 0) ||
          (dir === "down" && dy <= 0) ||
          (dir === "left" && dx >= 0) ||
          (dir === "right" && dx <= 0)
        )
          return;
        cands.push({ i, dx, dy });
      });

      const score = (c) =>
        dir === "left" || dir === "right"
          ? 2 * c.dx * c.dx + c.dy * c.dy
          : 2 * c.dy * c.dy + c.dx * c.dx;

      cands.sort((a, b) => score(a) - score(b));

      if (cands.length > 0) {
        this._cursorIndex = cands[0].i;
        this._updateCursor();
        return;
      }

      const wrapCands = [];
      this._choiceSprites.forEach((sp, i) => {
        if (i === curIdx) return;
        const dx = sp._baseX - cx;
        const dy = sp._baseY - cy;

        if ((dir === "left" || dir === "right") && Math.abs(dy) < 16) {
          wrapCands.push({ i, x: sp._baseX });
        } else if ((dir === "up" || dir === "down") && Math.abs(dx) < 16) {
          wrapCands.push({ i, y: sp._baseY });
        }
      });

      if (wrapCands.length > 0) {
        if (dir === "left") {
          wrapCands.sort((a, b) => b.x - a.x);
        } else if (dir === "right") {
          wrapCands.sort((a, b) => a.x - b.x);
        } else if (dir === "up") {
          wrapCands.sort((a, b) => b.y - a.y);
        } else if (dir === "down") {
          wrapCands.sort((a, b) => a.y - b.y);
        }

        this._cursorIndex = wrapCands[0].i;
        this._updateCursor();
      }
    };

    Scene_Recollection.prototype._changePage = function (page) {
      this._page = page;
      this._createChoices();
      this._updateTabCursor();

      if (this._focusTarget === "choice") {
        if (this._selected) return;
        this._cursorIndex = 0;
        if (this._cursorSprite) this._cursorSprite.visible = true;
        this._updateCursor(true);
      } else {
        if (this._cursorSprite) this._cursorSprite.visible = false;
      }

      if (this._cursorSprite) {
        this.removeChild(this._cursorSprite);
        this.addChild(this._cursorSprite);
        this.setChildIndex(this._cursorSprite, this.children.length - 1);
      }

      this._frames.forEach((fr, i) => {
        if (fr) {
          const sp = this._choiceSprites[i];
          if (sp) {
            fr.x = sp._baseX;
            fr.y = sp._baseY;
            fr._baseX = sp._baseX;
            fr._baseY = sp._baseY;
            fr._targetX = sp._baseX;
            fr._targetY = sp._baseY;
            fr.visible = false;
          }
        }
      });

      if (this._tabBackgroundSprites) {
        this._tabBackgroundSprites.forEach((sp) => this.removeChild(sp));
      }
      this._tabBackgroundSprites = [];

      const shouldShow = (cfg) => {
        const sw = Number(cfg.ShowSwitch);
        if (sw > 0 && !$gameSwitches.value(sw)) return false;

        const vid = Number(cfg.ShowVariable);
        if (vid > 0) {
          const val = $gameVariables.value(vid);
          const target = Number(cfg.ShowValue);
          const op = cfg.ShowOperator || "等しい（==）";

          switch (op) {
            case "等しい（==）":
              if (val !== target) return false;
              break;
            case "以上（>=）":
              if (val < target) return false;
              break;
            case "以下（<=）":
              if (val > target) return false;
              break;
            case "より大きい（>）":
              if (val <= target) return false;
              break;
            case "より小さい（<）":
              if (val >= target) return false;
              break;
          }
        }
        return true;
      };

      const bgList = this._tabBackgrounds
        .filter((cfg) => Number(cfg.Page) === page)
        .filter((cfg) => shouldShow(cfg));

      const baseIndex = this.children.indexOf(
        this._baseBackgroundSprite ?? null
      );
      let insertAt = baseIndex >= 0 ? baseIndex + 1 : this.children.length;

      bgList.forEach((cfg) => {
        const sp = new Sprite(
          ImageManager.loadBitmap("img/Recollection/", cfg.Image)
        );
        sp.anchor.set(0.5);
        sp.x = +cfg.X || Graphics.width / 2;
        sp.y = +cfg.Y || Graphics.height / 2;
        this.addChildAt(sp, insertAt++);
        this._tabBackgroundSprites.push(sp);
      });
    };

    Scene_Recollection.prototype._hideCancelConfirm = function () {
      this._cancelConfirmActive = false;
      if (
        this._cursorSprite &&
        this._focusTarget === "choice" &&
        this._cursorIndex >= 0 &&
        this._cursorIndex < this._choiceSprites.length
      ) {
        this._cursorSprite.visible = true;
        this._updateCursor(true);
      }
      this._frames.forEach((fr, i) => {
        if (fr) fr.visible = i === this._cursorIndex;
      });
      this._cancelConfirmSprites.forEach((s) => this.removeChild(s));
      this._cancelConfirmFrames.forEach((f) => f && this.removeChild(f));
      if (this._cancelBaseSprite) this.removeChild(this._cancelBaseSprite);

      this._cancelConfirmSprites = [];
      this._cancelConfirmFrames = [];
      this._cancelConfirmIndex = 0;
      this._cancelBaseSprite = null;
    };

    Scene_Recollection.prototype._showCancelConfirmImage = function () {
      if (Array.isArray(this._tabFrames)) {
        this._tabFrames.forEach((fr) => fr && (fr.visible = false));
      }
      if (this._tabCursorSprite) {
        this._tabCursorSprite.visible = false;
      }

      if (this._cancelBaseSprite) return;
      const name = this._cancelCfg.BaseImage;
      if (!name) return;

      this._cancelBaseSprite = new Sprite(
        ImageManager.loadBitmap("img/Recollection/", name)
      );
      this._cancelBaseSprite.anchor.set(0.5);
      this._cancelBaseSprite.x = Graphics.width / 2;
      this._cancelBaseSprite.y = Graphics.height / 2;
      this.addChild(this._cancelBaseSprite);
      this.setChildIndex(this._cancelBaseSprite, this.children.length - 1);
      this._cancelConfirmSprites = [];
      this._cancelConfirmFrames = [];
      this._cancelConfirmIndex = 0;

      this._cancelCfg.Choices.forEach((cfg, i) => {
        const sp = new Sprite(
          ImageManager.loadBitmap("img/Recollection/", cfg.Image)
        );
        sp.anchor.set(0.5);
        sp.x = +cfg.X || 0;
        sp.y = +cfg.Y || 0;

        const eff = cfg.HoverEffect || {};
        sp._baseX = sp.x;
        sp._baseY = sp.y;
        sp._baseScale = 1.0;
        sp._hoverScale =
          eff.UseScale === "true" ? (+eff.Scale || 100) / 100 : 1;
        sp._hoverOffsetX = eff.UseOffset === "true" ? +eff.OffsetX : 0;
        sp._hoverOffsetY = eff.UseOffset === "true" ? +eff.OffsetY : 0;
        sp._action = cfg.Action || "cancel";

        this.addChild(sp);
        this.setChildIndex(sp, this.children.length - 1);
        this._cancelConfirmSprites.push(sp);

        if (eff.FrameImage) {
          const fr = new Sprite(
            ImageManager.loadBitmap("img/Recollection/", eff.FrameImage)
          );
          fr.anchor.set(0.5);
          fr.x = sp.x;
          fr.y = sp.y;
          fr.visible = false;
          this.addChild(fr);
          this.setChildIndex(fr, this.children.length - 1);
          this._cancelConfirmFrames[i] = fr;
        } else {
          this._cancelConfirmFrames[i] = null;
        }
      });

      this._updateCancelConfirmCursor(true);

      if (this._cursorSprite) this._cursorSprite.visible = false;
      this._frames.forEach((fr) => {
        if (fr) fr.visible = false;
      });

      this._cancelConfirmActive = true;
    };

    Scene_Recollection.prototype._updateCancelConfirmCursor = function (
      skipSe = false
    ) {
      if (this._selected) return;
      this._cancelConfirmSprites.forEach((sp, i) => {
        const hov = i === this._cancelConfirmIndex;
        sp._targetX = sp._baseX + (hov ? sp._hoverOffsetX : 0);
        sp._targetY = sp._baseY + (hov ? sp._hoverOffsetY : 0);
        sp._targetScale = hov ? sp._hoverScale : sp._baseScale;
        const fr = this._cancelConfirmFrames[i];
        if (fr) {
          fr.visible = hov;
          fr._targetX = sp._targetX;
          fr._targetY = sp._targetY;
        }
      });

      if (!skipSe && this._selSe.name)
        AudioManager.playSe({
          name: this._selSe.name,
          volume: +this._selSe.volume || 90,
          pitch: +this._selSe.pitch || 100,
          pan: +this._selSe.pan || 0,
        });
    };

    Scene_Recollection.prototype._onSelect = function (cfg) {
      if (this._selected) return;
      this._selected = true;

      window.RecollectionCursorState = {
        tabIndex: this._tabCursorIndex,
        choiceIndex: this._cursorIndex,
        page: this._page,
      };

      if (this._okSe.name)
        AudioManager.playSe({
          name: this._okSe.name,
          volume: +this._okSe.volume || 90,
          pitch: +this._okSe.pitch || 100,
          pan: +this._okSe.pan || 0,
        });

      if (cfg.CommonEventId) {
        $gameScreen._brightness = 0;
        $gameTemp.reserveCommonEvent(+cfg.CommonEventId);
      }

      this.startFadeOut(this.fadeSpeed(), false);
      this.fadeOutAll(this.fadeSpeed());
      AudioManager.fadeOutBgm(60);
      SceneManager.pop();
    };

    Scene_Recollection.prototype.update = function () {
      Scene_Base.prototype.update.call(this);

      if (this._pendingExit) {
        if (this._fadeDuration > 0) return;
        if (!this._didCleanup) {
          this._didCleanup = true;
          if (typeof window.ADMIN_forceClearAllCGPictures === "function") {
            window.ADMIN_forceClearAllCGPictures();
          }
          if (this._clearSprites) this._clearSprites();
          if (this._clearTabSprites) this._clearTabSprites();
          if (this._baseBackgroundSprite)
            this.removeChild(this._baseBackgroundSprite);
          if (this._tabBackgroundSprites)
            this._tabBackgroundSprites.forEach((sp) => this.removeChild(sp));
          if (this._cursorSprite) this.removeChild(this._cursorSprite);
          if (this._tabCursorSprite) this.removeChild(this._tabCursorSprite);
          if (this._cancelBaseSprite) this.removeChild(this._cancelBaseSprite);
          if (this._cancelConfirmSprites)
            this._cancelConfirmSprites.forEach((sp) => this.removeChild(sp));
          if (this._cancelConfirmFrames)
            this._cancelConfirmFrames.forEach(
              (fr) => fr && this.removeChild(fr)
            );
        }

        const dur = this._exitFadeInAfter || 30;
        SceneManager._forceFadeInDuration = dur;
        $gameScreen.startFadeIn(dur);
        $gameSystem.replayBgm();
        SceneManager.pop();
        this._pendingExit = false;
        return;
      }

      if (this._pendingExit && this._fadeDuration <= 0) {
        this._pendingExit = false;
        SceneManager.pop();

        const next = SceneManager._scene;
        if (next && next.startFadeIn) {
          next.startFadeIn(this._exitFadeInAfter, false);
        }
        $gameScreen.startFadeIn(this._exitFadeInAfter);
        $gameSystem.replayBgm();
        return;
      }
      if (!this._sprites.length) return;
      if (this.isBusy()) return;
      if (this._selected) return;

      const mx = TouchInput.x,
        my = TouchInput.y;

      if (this._cancelConfirmActive) {
        const over = this._cancelConfirmSprites.findIndex((sp) => {
          if (!sp.bitmap || !sp.bitmap.isReady()) return false;
          const w = sp.bitmap.width * sp.scale.x;
          const h = sp.bitmap.height * sp.scale.y;
          return (
            mx >= sp.x - w / 2 &&
            mx <= sp.x + w / 2 &&
            my >= sp.y - h / 2 &&
            my <= sp.y + h / 2
          );
        });
        if (over >= 0 && over !== this._cancelConfirmIndex) {
          this._cancelConfirmIndex = over;
          this._updateCancelConfirmCursor();
        }

        for (let i = 0; i < this._cancelConfirmSprites.length; i++) {
          const sp = this._cancelConfirmSprites[i];
          if (TouchInput.isTriggered() && this._isMouseOverSprite(sp)) {
            const act = sp._action;
            if (act === "endRecollection") {
              this.exitRecollection();
            } else {
              this._hideCancelConfirm();
            }
            break;
          }
        }

        if (Input.isTriggered("left") || Input.isTriggered("right")) {
          const len = this._cancelConfirmSprites.length;
          this._cancelConfirmIndex = Input.isTriggered("left")
            ? (len + this._cancelConfirmIndex - 1) % len
            : (this._cancelConfirmIndex + 1) % len;
          this._updateCancelConfirmCursor();
        }
        if (Input.isTriggered("ok")) {
          const act =
            this._cancelConfirmSprites[this._cancelConfirmIndex]._action;
          act === "endRecollection"
            ? this.exitRecollection()
            : this._hideCancelConfirm();
        }

        _smoothSprites(this._choiceSprites.concat(this._frames));

        if (this._cursorSprite && this._cursorSprite.visible) {
          this._cursorSprite.x = this._cursorSprite._targetX;
          this._cursorSprite.y = this._cursorSprite._targetY;
          if (this._cursorSprite._targetScale != null) {
            const s = this._cursorSprite._targetScale;
            this._cursorSprite.scale.set(s, s);
          }
        }

        return;
      }

      if (
        Input.isPressed("up") ||
        Input.isPressed("down") ||
        Input.isPressed("left") ||
        Input.isPressed("right") ||
        Input.isTriggered("ok") ||
        Input.isTriggered("cancel")
      ) {
        this._inputMode = "keyboard";
      } else if (mx !== this._lastMouseX || my !== this._lastMouseY) {
        this._inputMode = "mouse";
      }
      this._lastMouseX = mx;
      this._lastMouseY = my;

      if (this._inputMode === "keyboard") {
        if (this._focusTarget === "choice") {
          if (Input.isTriggered("cancel")) {
            this._focusTarget = "tab";
            this._cursorIndex = -1;

            if (this._cursorSprite) this._cursorSprite.visible = false;

            this._choiceSprites.forEach((sp) => {
              sp.x = sp._baseX;
              sp.y = sp._baseY;
              sp.scale.set(sp._baseScale);
              sp._targetX = null;
              sp._targetY = null;
              sp._targetScale = null;
            });

            this._frames.forEach((fr) => {
              if (fr) {
                fr.visible = false;
                fr.x = null;
                fr.y = null;
                fr._targetX = null;
                fr._targetY = null;
              }
            });

            this._updateTabCursor();
          }
          if (Input.isTriggered("ok")) {
            const sp = this._choiceSprites[this._cursorIndex];
            if (sp && sp._recEnabled) this._onSelect(sp._recCfg);
          }
          if (
            Input.isRepeated("up") ||
            Input.isRepeated("down") ||
            Input.isRepeated("left") ||
            Input.isRepeated("right")
          ) {
            if (Input.isRepeated("up")) this._moveCursor("up");
            if (Input.isRepeated("down")) this._moveCursor("down");
            if (Input.isRepeated("left")) this._moveCursor("left");
            if (Input.isRepeated("right")) this._moveCursor("right");
          }
        } else {
          if (Input.isTriggered("cancel")) this._showCancelConfirmImage();

          if (Input.isTriggered("ok")) {
            this._focusTarget = "choice";

            if (this._choiceSprites.length) {
              this._cursorIndex = 0;
              if (this._cursorSprite) this._cursorSprite.visible = true;
              this._updateCursor();
            } else {
              this._cursorIndex = -1;
              if (this._cursorSprite) this._cursorSprite.visible = false;
            }
          }

          if (
            Input.isRepeated("left") ||
            Input.isRepeated("right") ||
            Input.isRepeated("up") ||
            Input.isRepeated("down")
          ) {
            const len = this._tabSprites.length;
            if (Input.isRepeated("left") || Input.isRepeated("up"))
              this._tabCursorIndex = (len + this._tabCursorIndex - 1) % len;
            else this._tabCursorIndex = (this._tabCursorIndex + 1) % len;

            this._updateTabCursor();
            this._changePage(this._tabSprites[this._tabCursorIndex]._tabPage);
          }
        }
      }

      if (this._inputMode === "mouse") {
        if (this._focusTarget === "choice") {
          const over = this._choiceSprites.findIndex((sp) => {
            if (!sp.bitmap || !sp.bitmap.isReady()) return false;
            const w = sp.bitmap.width * sp.scale.x;
            const h = sp.bitmap.height * sp.scale.y;
            return (
              mx >= sp.x - w / 2 &&
              mx <= sp.x + w / 2 &&
              my >= sp.y - h / 2 &&
              my <= sp.y + h / 2
            );
          });
          if (over >= 0 && over !== this._cursorIndex) {
            this._cursorIndex = over;
            this._updateCursor();
          }
          if (TouchInput.isTriggered() && over >= 0) {
            const sp = this._choiceSprites[over];
            if (sp._recEnabled) this._onSelect(sp._recCfg);
          }
        }

        this._tabSprites.forEach((sp, i) => {
          if (!sp.bitmap || !sp.bitmap.isReady()) return;
          const w = sp.bitmap.width,
            h = sp.bitmap.height;
          if (
            mx >= sp.x - w / 2 &&
            mx <= sp.x + w / 2 &&
            my >= sp.y - h / 2 &&
            my <= sp.y + h / 2 &&
            TouchInput.isTriggered()
          ) {
            this._tabCursorIndex = i;
            this._focusTarget = "choice";
            this._changePage(sp._tabPage);
            if (this._cursorSprite) this._cursorSprite.visible = true;
            this._updateCursor();
            this._updateTabCursor();
          }
        });

        if (
          ["tab", "choice"].includes(this._focusTarget) &&
          TouchInput.isCancelled()
        ) {
          this._showCancelConfirmImage();
        }

        this._choiceSprites.forEach((sp, i) => {
          const hov = i === this._cursorIndex;

          sp._targetX = sp._baseX + (hov ? sp._hoverOffsetX : 0);
          sp._targetY = sp._baseY + (hov ? sp._hoverOffsetY : 0);
          sp._targetScale = hov ? sp._hoverScale : sp._baseScale;

          const fr = this._frames[i];
          if (fr) {
            fr.visible = hov && sp._recEnabled;
            fr._targetX = sp._targetX;
            fr._targetY = sp._targetY;
            fr._targetScale = sp._targetScale;

            if (hov) {
              if (!this._cancelConfirmActive) {
                this.setChildIndex(fr, this.children.length - 1);
              }
              fr.x = fr._targetX;
              fr.y = fr._targetY;
              if (fr._targetScale != null) {
                fr.scale.set(fr._targetScale, fr._targetScale);
              }
            } else {
              fr.x = sp._baseX;
              fr.y = sp._baseY;
              fr.scale.set(1.0, 1.0);
            }
          }
        });

        if (this._cursorSprite && this._cursorSprite.visible) {
          if (!this._cancelConfirmActive) {
            this.setChildIndex(this._cursorSprite, this.children.length - 1);
          }
        }

        if (this._focusTarget === "tab") {
          const overChoice = this._choiceSprites.findIndex((sp) => {
            if (!sp.bitmap || !sp.bitmap.isReady()) return false;
            const w = sp.bitmap.width * sp.scale.x;
            const h = sp.bitmap.height * sp.scale.y;
            return (
              mx >= sp.x - w / 2 &&
              mx <= sp.x + w / 2 &&
              my >= sp.y - h / 2 &&
              my <= sp.y + h / 2
            );
          });

          if (overChoice >= 0) {
            this._focusTarget = "choice";
            this._cursorIndex = overChoice;
            if (this._cursorSprite) this._cursorSprite.visible = true;
            this._updateCursor();
          }
        }
      }

      _smoothSprites(this._choiceSprites.concat(this._frames));

      if (this._cursorSprite && this._cursorSprite.visible) {
        this._cursorSprite.x = this._cursorSprite._targetX;
        this._cursorSprite.y = this._cursorSprite._targetY;
        if (this._cursorSprite._targetScale != null) {
          const s = this._cursorSprite._targetScale;
          this._cursorSprite.scale.set(s, s);
        }
        this.setChildIndex(this._cursorSprite, this.children.length - 1);
      }
    };

    Scene_Recollection.prototype._checkRightClickTrigger = function () {
      if (TouchInput._rightButtonPressed && !this._wasRightClick) {
        this._wasRightClick = true;
        return true;
      }
      if (!TouchInput._rightButtonPressed) {
        this._wasRightClick = false;
      }
      return false;
    };

    Scene_Recollection.prototype.exitRecollection = function () {
      this._activeSwitches.forEach((id) => {
        if (id) $gameSwitches.setValue(id, false);
      });
      const spd = this.fadeSpeed();
      this.startFadeOut(spd, false);
      this.fadeOutAll(spd);
      AudioManager.fadeOutBgm(60);
      this._pendingExit = true;
    };

    function _smoothSprites(list) {
      const t = 0.2;
      list.forEach((sp) => {
        if (!sp || sp._targetX == null) return;

        sp.x += (sp._targetX - sp.x) * t;
        sp.y += (sp._targetY - sp.y) * t;
        if (sp._targetScale != null) {
          const s = sp.scale.x + (sp._targetScale - sp.scale.x) * t;
          sp.scale.set(s, s);
        }
      });
    }

    function Scene_RecollectionEntry() {
      this.initialize(...arguments);
    }
    Scene_RecollectionEntry.prototype = Object.create(Scene_Base.prototype);
    Scene_RecollectionEntry.prototype.constructor = Scene_RecollectionEntry;
    Scene_RecollectionEntry.prototype.initialize = function () {
      Scene_Base.prototype.initialize.call(this);
      this._phase = 0;
      this._fadeOpacity = 0;
    };

    Scene_RecollectionEntry.prototype.create = function () {
      Scene_Base.prototype.create.call(this);
      $gameSystem.saveBgm();
      this._fadeSprite = new ScreenSprite();
      this.addChild(this._fadeSprite);
    };

    Scene_RecollectionEntry.prototype.update = function () {
      Scene_Base.prototype.update.call(this);

      if (this._phase === 0) {
      } else if (this._phase === 1) {
      } else if (this._phase === 2) {
        if (this._syncFadeSprite && this._fadeInDuration > 0) {
          this._fadeSprite.opacity = this._fadeOpacity;
        }
        if (this._fadeInDuration <= 0) {
          if (this._fadeSprite && this._fadeSprite.parent) {
            this.removeChild(this._fadeSprite);
          }
          SceneManager.pop();
        }
      }
    };

    Scene_RecollectionEntry.prototype.startFadeIn = function (duration, white) {
      Scene_Base.prototype.startFadeIn.call(this, duration, white);
      if (this._fadeSprite) {
        this._fadeSprite.opacity = 255;
        this._syncFadeSprite = true;
      }
    };

    PluginManager.registerCommand("OnevASSISTANT", "CallRecollection", () => {
      const scene = SceneManager._scene;
      if (!scene) return;

      scene.startFadeOut(60, false);
      const _update = scene.update;
      scene.update = function () {
        _update.call(this);
        if (this._fadeDuration <= 0) SceneManager.push(Scene_Recollection);
      };
    });

    Scene_Recollection.prototype._isMouseOverSprite = function (sp) {
      if (!sp || !sp.bitmap || !sp.bitmap.isReady()) return false;
      const mx = TouchInput.x,
        my = TouchInput.y;
      const baseX = sp._baseX != null ? sp._baseX : sp.x;
      const baseY = sp._baseY != null ? sp._baseY : sp.y;
      const w = sp.bitmap.width * sp.scale.x;
      const h = sp.bitmap.height * sp.scale.y;
      return (
        mx >= baseX - w / 2 &&
        mx <= baseX + w / 2 &&
        my >= baseY - h / 2 &&
        my <= baseY + h / 2
      );
    };

    OnevASSISTANT.saveCurrentBgm = function () {
      const bgm = AudioManager._currentBgm;
      if (bgm && bgm.name) {
        OnevASSISTANT._savedBgm = {
          name: bgm.name,
          volume: bgm.volume,
          pitch: bgm.pitch,
          pan: bgm.pan,
        };
      } else {
        OnevASSISTANT._savedBgm = null;
      }
    };

    window.OnevASSISTANT.saveCurrentBgm = OnevASSISTANT.saveCurrentBgm;

    Scene_Recollection.prototype.start = function () {
      if (typeof window.ADMIN_clearCG === "function") {
        window.ADMIN_clearCG();
      }
      Scene_Base.prototype.start.call(this);
      this.startFadeIn(30, false);

      if (this._focusTarget !== "choice") {
        this._focusTarget = "tab";
        const tabSprite = this._tabSprites[this._tabCursorIndex];
        const tabPage = tabSprite ? tabSprite._tabPage : 1;
        this._changePage(tabPage);

        if (this._choiceSprites.length > 0) {
          this._cursorIndex = 0;
          this._updateCursor(true);
          if (this._cursorSprite) this._cursorSprite.visible = false;
        } else {
          this._cursorIndex = -1;
          if (this._cursorSprite) this._cursorSprite.visible = false;
        }
      } else {
        if (
          this._choiceSprites.length > 0 &&
          this._cursorIndex >= 0 &&
          this._cursorIndex < this._choiceSprites.length
        ) {
          if (this._cursorSprite) {
            this._cursorSprite.visible = true;
            this.setChildIndex(this._cursorSprite, this.children.length - 1);
          }
          this._updateCursor(true);
        }
      }

      this._updateTabCursor();
    };

    const _Scene_Map_start = Scene_Map.prototype.start;
    Scene_Map.prototype.start = function () {
      _Scene_Map_start.call(this);

      if (SceneManager._forceFadeInDuration > 0) {
        this.startFadeIn(SceneManager._forceFadeInDuration, false);
        SceneManager._forceFadeInDuration = 0;
      }

      if (SceneManager._nextSceneFadeIn) {
        this.startFadeIn(30, false);
        SceneManager._nextSceneFadeIn = false;
      }
    };

    Scene_Recollection.prototype._hideCancelConfirm = function () {
      this._cancelConfirmActive = false;

      if (this._focusTarget === "tab") {
        if (this._tabCursorSprite) this._tabCursorSprite.visible = true;
        if (Array.isArray(this._tabFrames)) {
          this._tabFrames.forEach((fr, i) => {
            if (fr) fr.visible = i === this._tabCursorIndex;
          });
        }
      } else {
        if (this._tabCursorSprite) this._tabCursorSprite.visible = false;
        if (Array.isArray(this._tabFrames)) {
          this._tabFrames.forEach((fr) => fr && (fr.visible = false));
        }
      }

      if (
        this._cursorSprite &&
        this._focusTarget === "choice" &&
        this._cursorIndex >= 0 &&
        this._cursorIndex < this._choiceSprites.length
      ) {
        this._cursorSprite.visible = true;
        this._updateCursor(true);
      }
      this._frames.forEach((fr, i) => {
        if (fr)
          fr.visible =
            this._focusTarget === "choice" && i === this._cursorIndex;
      });

      this._cancelConfirmSprites.forEach((s) => this.removeChild(s));
      this._cancelConfirmFrames.forEach((f) => f && this.removeChild(f));
      if (this._cancelBaseSprite) this.removeChild(this._cancelBaseSprite);

      this._cancelConfirmSprites = [];
      this._cancelConfirmFrames = [];
      this._cancelConfirmIndex = 0;
      this._cancelBaseSprite = null;
    };

    (function () {
      const _exitRec = Scene_Recollection.prototype.exitRecollection;
      Scene_Recollection.prototype.exitRecollection = function () {
        _exitRec.call(this);
        const fadeOutMs = 1000;
        setTimeout(() => {
          const prev = OnevASSISTANT._savedBgm;
          if (prev && prev.name) {
            OnevASSISTANT.crossFadeBgm({
              name: prev.name,
              volume: prev.volume,
              pitch: prev.pitch,
              pan: prev.pan,
              fadeTime: 1000,
            });
          }
        }, fadeOutMs);
      };
    })();
  })();

  (() => {
    //======================================================================
    // 背景の管理
    //======================================================================

    "use strict";
    const raw = OnevASSISTANT.getPluginParameter(
      "OnevASSISTANT",
      "BackgroundSettings",
      "{}"
    );

    let backgroundSettings = [];
    let backgroundPictureId = 10;
    let fadingPictureId = 11;
    let queuedBackgroundChange = null;

    try {
      const parsed = OnevASSISTANT.safeJsonParse(raw, {});

      if (parsed.PictureId1 != null)
        backgroundPictureId = Number(parsed.PictureId1);
      if (parsed.PictureId2 != null)
        fadingPictureId = Number(parsed.PictureId2);

      const list = OnevASSISTANT.parseDeep(parsed.Backgrounds || []);
      backgroundSettings = list.map((bg) => {
        const timePics = [];
        if (bg.MorningImage) {
          timePics.push({
            Time: "morning",
            FileName: bg.MorningImage.replace(/^.*[\\\/]/, ""),
          });
        }
        if (bg.EveningImage) {
          timePics.push({
            Time: "evening",
            FileName: bg.EveningImage.replace(/^.*[\\\/]/, ""),
          });
        }
        if (bg.NightImage) {
          timePics.push({
            Time: "night",
            FileName: bg.NightImage.replace(/^.*[\\\/]/, ""),
          });
        }
        return {
          Place: bg.Place,
          TimePictures: timePics,
        };
      });
    } catch (e) {
      console.error("背景設定の初期化中に予期せぬエラー:", e);
    }

    const timeOrder = ["morning", "evening", "night"];
    let currentPlace = null;
    let currentTime = "morning";
    let isPictureTransitioning = false;
    let nextTimeToSet = null;

    window.ADMIN_changeBackground = function (
      place,
      time,
      ruleImage = null,
      duration = 60
    ) {
      time = time || currentTime;

      const isFast =
        Graphics && Graphics._fpsMeter && Graphics._fpsMeter._isRunning;
      const instant =
        isFast ||
        (SceneManager &&
          SceneManager.isFastForward &&
          SceneManager.isFastForward());

      if (isPictureTransitioning) {
        queuedBackgroundChange = { place, time, ruleImage, duration };
        return;
      }
      const bg = backgroundSettings.find((bg) => bg.Place === place);
      if (!bg) {
        console.warn("場所が見つかりません:", place);
        return;
      }
      const timePic = bg.TimePictures.find((tp) => tp.Time === time);
      if (!timePic || !timePic.FileName) {
        console.warn("時間帯データが見つかりません:", time);
        return;
      }

      if (isPictureTransitioning) {
        queuedBackgroundChange = { place, time, ruleImage, duration };
        console.log("背景変更予約:", queuedBackgroundChange);
        return;
      }

      const fileName = "backgrounds/" + timePic.FileName;

      currentPlace = place;
      currentTime = time;

      if (instant) {
        $gameScreen.showPicture(
          backgroundPictureId,
          fileName,
          0,
          0,
          0,
          100,
          100,
          255,
          0
        );
        $gameScreen.showPicture(
          fadingPictureId,
          fileName,
          0,
          0,
          0,
          100,
          100,
          255,
          0
        );
        $gameScreen.erasePicture(backgroundPictureId);
        try {
          const scene = SceneManager._scene;
          if (scene && scene._onevFadeLayer) {
            scene._onevFadeLayer.visible = true;
          }
        } catch (e) {}
        isPictureTransitioning = false;
        nextTimeToSet = null;
        return;
      }

      if (ruleImage) {
        nextTimeToSet = time;
        isPictureTransitioning = true;
        ADMIN_performRuleTransition(fileName, ruleImage, duration, true, "out");
      } else {
        $gameScreen.showPicture(
          backgroundPictureId,
          fileName,
          0,
          0,
          0,
          100,
          100,
          255,
          0
        );
        $gameScreen.movePicture(
          fadingPictureId,
          0,
          0,
          0,
          100,
          100,
          0,
          0,
          duration
        );
        isPictureTransitioning = true;
        nextTimeToSet = time;
      }
    };

    window.ADMIN_advanceTime = function (ruleImage = null, duration = 60) {
      if (isPictureTransitioning) {
        const bg = backgroundSettings.find((bg) => bg.Place === currentPlace);
        const nextTime = bg ? getNextValidTime(bg, currentTime) : null;
        if (!nextTime) return;
        queuedBackgroundChange = {
          place: currentPlace,
          time: nextTime,
          ruleImage,
          duration,
        };
        return;
      }

      const bg = backgroundSettings.find((bg) => bg.Place === currentPlace);
      if (!bg) return;
      const nextTime = getNextValidTime(bg, currentTime);
      if (!nextTime) return;
      const timePic = bg.TimePictures.find((tp) => tp.Time === nextTime);
      if (!timePic || !timePic.FileName) return;
      const fileName = "backgrounds/" + timePic.FileName;
      const isFast =
        Graphics && Graphics._fpsMeter && Graphics._fpsMeter._isRunning;
      const instant =
        isFast ||
        (SceneManager &&
          SceneManager.isFastForward &&
          SceneManager.isFastForward());

      if (instant) {
        $gameScreen.showPicture(
          backgroundPictureId,
          fileName,
          0,
          0,
          0,
          100,
          100,
          255,
          0
        );
        $gameScreen.showPicture(
          fadingPictureId,
          fileName,
          0,
          0,
          0,
          100,
          100,
          255,
          0
        );
        $gameScreen.erasePicture(backgroundPictureId);
        isPictureTransitioning = false;
        nextTimeToSet = null;
        return;
      }

      if (ruleImage) {
        nextTimeToSet = nextTime;
        isPictureTransitioning = true;
        ADMIN_performRuleTransition(fileName, ruleImage, duration, true, "out");
      } else {
        $gameScreen.showPicture(
          backgroundPictureId,
          fileName,
          0,
          0,
          0,
          100,
          100,
          255,
          0
        );
        $gameScreen.movePicture(
          fadingPictureId,
          0,
          0,
          0,
          100,
          100,
          0,
          0,
          duration
        );
        isPictureTransitioning = true;
        nextTimeToSet = nextTime;
      }
    };

    function getNextValidTime(bgData, current) {
      let index = timeOrder.indexOf(current);
      if (index === -1) return null;
      const total = timeOrder.length;
      for (let i = 1; i <= total; i++) {
        const nextTime = timeOrder[(index + i) % total];
        if (bgData.TimePictures.find((tp) => tp.Time === nextTime)) {
          return nextTime;
        }
      }
      return null;
    }

    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
      _Scene_Map_update.call(this);

      if (isPictureTransitioning) {
        const pic = $gameScreen.picture(fadingPictureId);
        const bgPic = $gameScreen.picture(backgroundPictureId);

        if (!pic || pic.opacity() <= 0) {
          if (bgPic) {
            const fileName = bgPic._name;
            $gameScreen.showPicture(
              fadingPictureId,
              fileName,
              0,
              0,
              0,
              100,
              100,
              255,
              0
            );
          }
          $gameScreen.erasePicture(backgroundPictureId);
          isPictureTransitioning = false;
          currentTime = nextTimeToSet;
          nextTimeToSet = null;

          if (queuedBackgroundChange) {
            console.log("背景変更予約を実行:", queuedBackgroundChange);
            const q = queuedBackgroundChange;
            queuedBackgroundChange = null;

            const time = q.time || currentTime;
            window.ADMIN_changeBackground(
              q.place,
              time,
              q.ruleImage,
              q.duration
            );
          }
        } else {
        }
      }
    };

    window.ADMIN_currentTime = () => currentTime;
    window.ADMIN_performRuleTransition = function (
      nextImagePath,
      ruleImageName,
      duration = 60,
      applyTimeChange = false,
      type = "out"
    ) {
      const isFast =
        Graphics && Graphics._fpsMeter && Graphics._fpsMeter._isRunning;
      const instant =
        isFast ||
        (SceneManager &&
          SceneManager.isFastForward &&
          SceneManager.isFastForward());

      if (instant) {
        $gameScreen.showPicture(
          fadingPictureId,
          nextImagePath,
          0,
          0,
          0,
          100,
          100,
          255,
          0
        );
        $gameScreen.erasePicture(backgroundPictureId);
        isPictureTransitioning = false;
        if (applyTimeChange) {
          currentTime = nextTimeToSet;
        }
        nextTimeToSet = null;
        if (queuedBackgroundChange) {
          const q = queuedBackgroundChange;
          queuedBackgroundChange = null;
          const time = q.time || currentTime;
          window.ADMIN_changeBackground(q.place, time, q.ruleImage, q.duration);
        }
        return;
      }

      const newBitmap = ImageManager.loadPicture(nextImagePath);
      const ruleBitmap = ImageManager.loadBitmap("img/system/", ruleImageName);
      const oldPic = $gameScreen.picture(fadingPictureId);
      const oldBitmap =
        oldPic && oldPic.name()
          ? ImageManager.loadPicture(oldPic.name())
          : new Bitmap(Graphics.width, Graphics.height);

      function waitUntilReady(callback) {
        if (
          newBitmap.isReady() &&
          ruleBitmap.isReady() &&
          oldBitmap.isReady()
        ) {
          callback();
        } else {
          setTimeout(() => waitUntilReady(callback), 10);
        }
      }

      waitUntilReady(() => {
        const stage = SceneManager._scene._spriteset;
        if (!stage) return;

        const container = new Sprite();
        const newSprite = new Sprite(newBitmap);
        const oldSprite = new Sprite(oldBitmap);
        const maskSprite = new Sprite(ruleBitmap);
        maskSprite.width = Graphics.width;
        maskSprite.height = Graphics.height;
        const isFadeOut = type === "out";
        const fragmentShader = `
        precision mediump float;
        varying vec2 vTextureCoord;
        uniform sampler2D uSampler;
        uniform sampler2D back;
        uniform sampler2D mask;
        uniform float  progress;
        uniform int    isFadeOut;
        uniform int    invertMask;
        void main(void){
            float m = texture2D(mask, vTextureCoord).r;
            if (invertMask == 1) m = 1.0 - m;
            float f = step(m, progress);
            float alpha = isFadeOut == 1 ? f : (1.0 - f);
            vec4 oldColor = texture2D(back,      vTextureCoord);
            vec4 newColor = texture2D(uSampler,  vTextureCoord);
        
            gl_FragColor = mix(oldColor, newColor, alpha);
        }
        `;

        const filter = new PIXI.Filter(undefined, fragmentShader, {
          back: oldSprite.texture,
          mask: maskSprite.texture,
          progress: 0,
          isFadeOut: type === "out" ? 1 : 0,
          invertMask: 0,
        });

        newSprite.filters = [filter];
        container.addChild(oldSprite);
        container.addChild(newSprite);
        const transitionLayer = new Sprite();
        transitionLayer.z = 0;
        const pictureContainer =
          SceneManager._scene._spriteset._pictureContainer;

        let insertIndex = pictureContainer.children.length;
        for (let i = 0; i < pictureContainer.children.length; i++) {
          const sprite = pictureContainer.children[i];
          if (sprite._pictureId === fadingPictureId) {
            insertIndex = i + 1;
            break;
          }
        }

        pictureContainer.addChild(transitionLayer);
        transitionLayer.addChild(container);

        isPictureTransitioning = true;
        let frame = 0;
        function updateTransition() {
          filter.uniforms.progress = ++frame / duration;
          if (frame >= duration) {
            if (transitionLayer.parent) {
              transitionLayer.parent.removeChild(transitionLayer);
            }

            $gameScreen.showPicture(
              fadingPictureId,
              nextImagePath,
              0,
              0,
              0,
              100,
              100,
              255,
              0
            );
            $gameScreen.erasePicture(backgroundPictureId);
            isPictureTransitioning = false;

            if (applyTimeChange) {
              currentTime = nextTimeToSet;
            }
            nextTimeToSet = null;

            if (queuedBackgroundChange) {
              const q = queuedBackgroundChange;
              queuedBackgroundChange = null;
              const time = q.time || currentTime;
              window.ADMIN_changeBackground(
                q.place,
                time,
                q.ruleImage,
                q.duration
              );
            }
          } else {
            requestAnimationFrame(updateTransition);
          }
        }
        requestAnimationFrame(updateTransition);
      });
    };

    PluginManager.registerCommand("OnevASSISTANT", "背景処理", (args) => {
      console.log("📥 プラグインコマンド呼び出し:", args);

      const mode = args.mode;
      const place = args.place;
      const jpTime = args.time;
      const ruleImage = args.ruleImage;
      const duration = Number(args.duration || 60);
      const wait = Number(args.duration || 60);

      const m = { 朝: "morning", 夕方: "evening", 夜: "night" };
      const time =
        jpTime === "なし" || !jpTime
          ? window.ADMIN_currentTime
            ? window.ADMIN_currentTime()
            : "morning"
          : m[jpTime] || jpTime;

      if (mode === "背景呼出" && place && time) {
        window.ADMIN_changeBackground(place, time, ruleImage, duration);
      } else if (mode === "背景変更" && place) {
        const nowTime = window.ADMIN_currentTime
          ? window.ADMIN_currentTime()
          : "morning";
        const safeTime =
          jpTime === "なし" || !jpTime ? nowTime : m[jpTime] || jpTime;
        window.ADMIN_changeBackground(place, safeTime, ruleImage, duration);
      } else if (mode === "時間経過") {
        window.ADMIN_advanceTime &&
          window.ADMIN_advanceTime(ruleImage, duration);
      } else if (mode === "背景消去") {
        $gameScreen.erasePicture(backgroundPictureId);
        $gameScreen.erasePicture(fadingPictureId);
        isPictureTransitioning = false;
        queuedBackgroundChange = null;
        window.ADMIN_clearBackgroundFilter();
      }
    });

    const _Sprite_Picture_update = Sprite_Picture.prototype.update;
    Sprite_Picture.prototype.update = function () {
      _Sprite_Picture_update.call(this);
      const bgIds = [backgroundPictureId, fadingPictureId];
      if (bgIds.includes(this._pictureId)) {
        this.z = 0;
      } else {
        this.z = 10;
      }
    };

    function getBackgroundFilterSprite() {
      const scene = SceneManager._scene;
      if (!scene || !scene._spriteset) return null;
      if (!scene._onevFilterSprite) {
        const g = new PIXI.Graphics();
        scene._spriteset._pictureContainer.addChild(g);
        scene._onevFilterSprite = g;
      }
      return scene._onevFilterSprite;
    }

    window.ADMIN_setBackgroundFilter = function (hexColor, opacity) {
      const sprite = getBackgroundFilterSprite();
      if (!sprite) return;

      const color = parseInt(hexColor.replace(/^#/, ""), 16);
      const alpha = Math.max(0, Math.min(opacity, 255)) / 255;

      sprite.clear();
      sprite.beginFill(color, alpha);
      sprite.drawRect(0, 0, Graphics.width, Graphics.height);
      sprite.endFill();
    };

    window.ADMIN_clearBackgroundFilter = function () {
      const scene = SceneManager._scene;
      if (scene && scene._onevFilterSprite) {
        scene._onevFilterSprite.clear();
      }
    };

    PluginManager.registerCommand(
      "OnevASSISTANT",
      "背景フィルター制御",
      (args) => {
        const action = args.action;

        if (action === "適用") {
          const rawColor = (args.color || "").trim();
          if (/^(reset|リセット)$/i.test(rawColor)) {
            window.ADMIN_clearBackgroundFilter();
            return;
          }
          const color = rawColor || "#000000";
          const opacity = Number(args.opacity || 0);
          window.ADMIN_setBackgroundFilter(color, opacity);
        } else if (action === "解除") {
          window.ADMIN_clearBackgroundFilter();
        }
      }
    );
  })();

  (() => {
    //======================================================================
    // CG変遷管理
    //======================================================================

    "use strict";
    const cgorigin = 0;
    const cgposX = 0;
    const cgposY = 0;
    let currentCgLabel = null;
    let currentCgIndex = 0;
    let nextCgIndex = null;
    let isCgTransitioning = false;
    let queuedCgChange = null;
    const raw = getPluginParameter("OnevASSISTANT", "CgGroupConfig", "{}");
    const pluginParams = PluginManager.parameters("OnevASSISTANT");
    const GLOBAL_FADE_VAR_ID = Number(pluginParams["FadeTimeVariableId"] || 0);
    let cgSettings = [];

    try {
      const g = parseDeep(safeJsonParse(raw, {}));
      const fadeVar = Number(g.FadeVariableId || 0);
      const picId1 = Number(g.PictureId1 || 21);
      const picId2 = Number(g.PictureId2 || 22);
      let scenes = Array.isArray(g.Scenes)
        ? g.Scenes
        : parseDeep(safeJsonParse(g.Scenes || "[]"));

      scenes.forEach((scene) => {
        let imgs = Array.isArray(scene.Images)
          ? scene.Images
          : parseDeep(safeJsonParse(scene.Images || "[]"));

        if (imgs.length === 0) return;

        const mainImage = imgs[0].FileName || "";
        const variations = imgs.length > 1 ? imgs.filter((_, i) => i > 0) : [];

        cgSettings.push({
          Label: scene.Label,
          PictureId1: picId1,
          PictureId2: picId2,
          FadeVariableId: fadeVar,
          MainImage: mainImage,
          Variations: variations,
        });
      });
    } catch (e) {
      console.error("CG設定の初期化エラー:", e);
    }

    function getCgVariations(cg) {
      const list = [];
      if (cg.MainImage) list.push(cg.MainImage);

      (cg.Variations || []).forEach((v) => {
        if (typeof v === "string") {
          list.push(v);
        } else if (v && v.FileName) {
          list.push(v.FileName);
        }
      });
      return list;
    }

    function getFadeDuration(cg, fallbackDuration) {
      const id =
        cg?.FadeVariableId > 0
          ? cg.FadeVariableId
          : GLOBAL_FADE_VAR_ID > 0
          ? GLOBAL_FADE_VAR_ID
          : 0;
      if (id > 0) {
        const v = Number($gameVariables.value(id));
        return Math.max(1, v || fallbackDuration);
      }
      return Math.max(1, fallbackDuration);
    }

    window.ADMIN_performCGTransition = function (
      nextImagePath,
      ruleImageName,
      duration = 60,
      type = "out",
      cgConfig
    ) {
      const idOld = cgConfig.PictureId1;
      const idNew = cgConfig.PictureId2;
      const newBitmap = ImageManager.loadPicture(nextImagePath);
      const ruleBitmap = ImageManager.loadBitmap("img/system/", ruleImageName);
      const oldPic = $gameScreen.picture(idNew);
      const oldBitmap =
        oldPic && oldPic.name()
          ? ImageManager.loadPicture(oldPic.name())
          : new Bitmap(Graphics.width, Graphics.height);

      const waitUntilReady = (cb) =>
        newBitmap.isReady() && ruleBitmap.isReady() && oldBitmap.isReady()
          ? cb()
          : setTimeout(() => waitUntilReady(cb), 10);

      waitUntilReady(() => {
        const picCont = SceneManager._scene?._spriteset?._pictureContainer;
        if (!picCont) return;

        const container = new Sprite();
        const newSprite = new Sprite(newBitmap);
        const oldSprite = new Sprite(oldBitmap);
        const maskSprite = new Sprite(ruleBitmap);
        maskSprite.width = Graphics.width;
        maskSprite.height = Graphics.height;

        const shader = `
        precision mediump float;
        varying vec2 vTextureCoord;
        uniform sampler2D uSampler;
        uniform sampler2D back;
        uniform sampler2D mask;
        uniform float progress;
        void main(void){
          float m = texture2D(mask, vTextureCoord).r;
          float f = smoothstep(progress-0.05, progress+0.05, m);
          float t = ${type === "out" ? "f" : "1.0 - f"};
          vec4 fromCol = texture2D(back, vTextureCoord);
          vec4 toCol   = texture2D(uSampler, vTextureCoord);
          vec4 outCol  = mix(fromCol, toCol, t);
          gl_FragColor = outCol;
        }`;

        const filter = new PIXI.Filter(undefined, shader, {
          back: oldSprite.texture,
          mask: maskSprite.texture,
          progress: 0,
        });

        newSprite.filters = [filter];
        container.addChild(oldSprite);
        container.addChild(newSprite);

        const transitionLayer = new Sprite();
        picCont.addChild(transitionLayer);
        transitionLayer.addChild(container);

        isCgTransitioning = true;
        let frame = 0;
        const step = () => {
          filter.uniforms.progress = ++frame / duration;
          if (frame >= duration) {
            transitionLayer.parent.removeChild(transitionLayer);
            $gameScreen.showPicture(
              idNew,
              nextImagePath,
              cgorigin,
              cgposX,
              cgposY,
              100,
              100,
              255,
              0
            );
            $gameScreen.erasePicture(idOld);
            isCgTransitioning = false;
          } else {
            requestAnimationFrame(step);
          }
        };
        requestAnimationFrame(step);
      });
    };

    window.ADMIN_displayCgFade = function (label, idx, fallbackDu) {
      const cg = cgSettings.find((c) => c.Label === label);
      if (!cg) {
        console.warn("CGラベルが見つかりません:", label);
        return;
      }

      const du = Math.max(1, getFadeDuration(cg, fallbackDu));
      const list = getCgVariations(cg);
      const target =
        idx !== null ? Math.min(Math.max(idx, 0), list.length - 1) : 0;
      const fileName = list[target];
      currentCgLabel = label;
      currentCgIndex = target;
      nextCgIndex = target;
      const idB = cg.PictureId1;
      const idF = cg.PictureId2;
      const prevPic = $gameScreen.picture(idB);
      const hasPrev = prevPic && prevPic.name();

      if (!hasPrev) {
        $gameScreen.showPicture(
          idB,
          fileName,
          cgorigin,
          cgposX,
          cgposY,
          100,
          100,
          0,
          0
        );
        isCgTransitioning = true;
        $gameScreen.movePicture(
          idB,
          cgorigin,
          cgposX,
          cgposY,
          100,
          100,
          255,
          0,
          du
        );

        waitPictures([idB], () => {
          isCgTransitioning = false;
          flushCgQueue();
        });
        return;
      }

      const prevName = prevPic.name();
      $gameScreen.showPicture(
        idF,
        prevName,
        cgorigin,
        cgposX,
        cgposY,
        100,
        100,
        255,
        0
      );

      $gameScreen.showPicture(
        idB,
        fileName,
        cgorigin,
        cgposX,
        cgposY,
        100,
        100,
        255,
        0
      );

      isCgTransitioning = true;
      $gameScreen.movePicture(
        idF,
        cgorigin,
        cgposX,
        cgposY,
        100,
        100,
        0,
        0,
        du
      );

      waitPictures([idF], () => {
        $gameScreen.erasePicture(idF);
        isCgTransitioning = false;
        flushCgQueue();
      });
    };

    window.ADMIN_changeCG = function (
      label,
      index = null,
      ruleImage = null,
      fallbackDu = 60
    ) {
      const cg = cgSettings.find((c) => c.Label === label);
      if (!cg) {
        console.warn("CGラベルが見つかりません:", label);
        return;
      }

      const duration = getFadeDuration(cg, fallbackDu);

      if (isCgTransitioning) {
        queuedCgChanges.push({
          mode: "進行",
          label,
          index,
          ruleImage,
          duration,
        });
        return;
      }

      const list = getCgVariations(cg);
      let target = 0;
      if (index === null) {
        if (currentCgLabel === label) {
          target = Math.min(currentCgIndex + 1, list.length - 1);
        }
      } else {
        target = Math.max(0, Math.min(Number(index), list.length - 1));
      }

      currentCgLabel = label;
      currentCgIndex = target;
      nextCgIndex = target;

      const fileName = list[target];
      const idB = cg.PictureId1;
      const idF = cg.PictureId2;

      if (ruleImage) {
        isCgTransitioning = true;
        ADMIN_performCGTransition(fileName, ruleImage, duration, "in", cg);
        waitPictures([idB], () => {
          isCgTransitioning = false;
          flushCgQueue();
        });
        return;
      }

      const prevPic = $gameScreen.picture(idB);
      const prevName = prevPic && prevPic.name() ? prevPic.name() : fileName;

      $gameScreen.showPicture(
        idF,
        prevName,
        cgorigin,
        cgposX,
        cgposY,
        100,
        100,
        255,
        0
      );

      $gameScreen.showPicture(
        idB,
        fileName,
        cgorigin,
        cgposX,
        cgposY,
        100,
        100,
        255,
        0
      );

      isCgTransitioning = true;
      $gameScreen.movePicture(
        idF,
        cgorigin,
        cgposX,
        cgposY,
        100,
        100,
        0,
        0,
        duration
      );

      waitPictures([idF], () => {
        $gameScreen.erasePicture(idF);
        isCgTransitioning = false;
        flushCgQueue();
      });
    };

    window.ADMIN_advanceCG = function (ruleImage = null, fallbackDu = 60) {
      const cg = cgSettings.find((c) => c.Label === currentCgLabel);
      if (!cg) return;

      const duration = getFadeDuration(cg, fallbackDu);

      if (isCgTransitioning) {
        queuedCgChanges.push({
          mode: "進行",
          label: currentCgLabel,
          index: null,
          ruleImage,
          duration,
        });
        return;
      }

      const variations = getCgVariations(cg);
      let next = currentCgIndex + 1;
      if (next >= variations.length) {
        next = variations.length - 1;
      }

      window.ADMIN_changeCG(currentCgLabel, next, ruleImage, duration);
    };

    window.ADMIN_clearCG = function (label, ruleImage = null) {
      const cg = cgSettings.find((c) => c.Label === (label || currentCgLabel));
      if (!cg) return;

      const duration = getFadeDuration(cg, 0);
      const idB = cg.PictureId1;
      const idF = cg.PictureId2;

      const pic = $gameScreen.picture(idB);
      if (!pic || !pic.name()) {
        $gameScreen.erasePicture(idB);
        $gameScreen.erasePicture(idF);
        isCgTransitioning = false;
        queuedCgChanges = [];
        return;
      }

      if (ruleImage) {
        isCgTransitioning = true;
        const fileName = pic.name();
        ADMIN_performCGTransition(fileName, ruleImage, duration, "out", cg);
        waitPictures([idB], () => {
          isCgTransitioning = false;
          flushCgQueue();
        });
        return;
      }

      isCgTransitioning = true;
      $gameScreen.movePicture(
        idB,
        cgorigin,
        cgposX,
        cgposY,
        100,
        100,
        0,
        0,
        duration
      );

      waitPictures([idB], () => {
        $gameScreen.erasePicture(idB);
        $gameScreen.erasePicture(idF);
        isCgTransitioning = false;
        flushCgQueue();
      });
    };

    PluginManager.registerCommand("OnevASSISTANT", "CG処理", (args) => {
      const mode = args.mode;
      const idx = args.index === "" ? null : Number(args.index);
      const rule = args.ruleImage || null;
      const label =
        args.label && args.label !== "" ? args.label : currentCgLabel;

      const cg = cgSettings.find((c) => c.Label === label);
      if (!cg) {
        console.warn("CGラベルが見つかりません:", label);
        return;
      }

      const du = getFadeDuration(cg, 0);

      const cmd = {
        mode,
        label,
        index: idx,
        ruleImage: rule,
        duration: du,
      };

      if (isCgTransitioning) {
        queuedCgChanges.push(cmd);
      } else {
        invokeCGCommand(cmd);
      }
    });

    function invokeCGCommand(cmd) {
      switch (cmd.mode) {
        case "呼出":
          window.ADMIN_displayCgFade(cmd.label, cmd.index, cmd.duration);
          break;
        case "進行":
        case "進行(Variation)":
          if (cmd.index !== null) {
            window.ADMIN_changeCG(
              cmd.label,
              cmd.index,
              cmd.ruleImage,
              cmd.duration
            );
          } else {
            window.ADMIN_advanceCG(cmd.ruleImage, cmd.duration);
          }
          break;
        case "消去":
          window.ADMIN_clearCG(cmd.label);
          break;
      }
    }
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
      _Scene_Map_update.call(this);

      if (!isCgTransitioning && queuedCgChange) {
        const cmd = queuedCgChange;
        queuedCgChange = null;
        invokeCGCommand(cmd);
      }
    };

    const _Sprite_Picture_update = Sprite_Picture.prototype.update;
    Sprite_Picture.prototype.update = function () {
      _Sprite_Picture_update.call(this);
      const ids = cgSettings.flatMap((c) => [c.PictureId1, c.PictureId2]);
      this.z = ids.includes(this._pictureId) ? 0 : 5;
    };

    function waitPictures(ids, onFinish) {
      const allDone = () =>
        ids.every((id) => {
          const pic = $gameScreen.picture(id);
          return !pic || pic._duration <= 0;
        });
      const loop = () =>
        allDone() ? onFinish?.() : requestAnimationFrame(loop);
      loop();
    }

    let queuedCgChanges = [];

    function flushCgQueue() {
      if (isCgTransitioning || !queuedCgChanges.length) return;
      const cmd = queuedCgChanges.shift();
      invokeCGCommand(cmd);
    }

    window.ADMIN_forceClearAllCGPictures = function () {
      cgSettings.forEach((cg) => {
        $gameScreen.erasePicture(cg.PictureId1);
        $gameScreen.erasePicture(cg.PictureId2);
      });
      currentCgLabel = null;
      currentCgIndex = 0;
      nextCgIndex = null;
      isCgTransitioning = false;
      queuedCgChanges = [];
    };
  })();

  (() => {
    //========================================================================================================
    //マスク処理
    //========================================================================================================

    const pluginName = getPluginParameter(
      "OnevASSISTANT",
      "PluginName",
      "OnevASSISTANT"
    );
    window.Onev_MaskSettings = window.Onev_MaskSettings || [];
    PluginManager.registerCommand(
      pluginName,
      "ピクチャにマスク適用",
      (args) => {
        const targetId = Number(args.pictureId);
        const maskId = Number(args.maskPictureId);
        const maskImage = args.maskImage;

        const exists = Onev_MaskSettings.some(
          (m) => m.targetId === targetId && m.maskId === maskId
        );
        if (!exists) Onev_MaskSettings.push({ targetId, maskId, maskImage });

        applyPictureMask(targetId, maskId, maskImage);
      }
    );

    function applyPictureMask(targetId, maskId, maskImage) {
      const scene = SceneManager._scene;
      const container =
        scene && scene._spriteset && scene._spriteset._pictureContainer;
      if (!container) return;

      const targetSprite = container.children.find(
        (sp) => sp._pictureId === targetId
      );
      if (!targetSprite) {
        return;
      }

      if (!$gameScreen.picture(maskId)) {
        const targetPic = $gameScreen.picture(targetId);
        if (!targetPic) return;

        $gameScreen.showPicture(
          maskId,
          maskImage,
          targetPic.origin(),
          targetPic.x(),
          targetPic.y(),
          targetPic.scaleX(),
          targetPic.scaleY(),
          targetPic.opacity(),
          targetPic.blendMode()
        );
      }

      let tries = 0;
      const maxTries = 20;

      function tryApplyMask() {
        const maskSprite = container.children.find(
          (sp) => sp._pictureId === maskId
        );
        const targetSprite = container.children.find(
          (sp) => sp._pictureId === targetId
        );

        if (maskSprite && targetSprite) {
          maskSprite.anchor.set(targetSprite.anchor.x, targetSprite.anchor.y);
          maskSprite.x = targetSprite.x;
          maskSprite.y = targetSprite.y;
          maskSprite.scale.set(targetSprite.scale.x, targetSprite.scale.y);
          targetSprite.mask = maskSprite;
        } else if (tries < maxTries) {
          tries++;
          requestAnimationFrame(tryApplyMask);
        }
      }

      requestAnimationFrame(tryApplyMask);
    }

    const _Scene_Map_start = Scene_Map.prototype.start;
    Scene_Map.prototype.start = function () {
      _Scene_Map_start.apply(this, arguments);
      const container = this._spriteset && this._spriteset._pictureContainer;
      if (!container) return;

      for (const { targetId, maskId } of window.Onev_MaskSettings) {
        const targetSprite = container.children.find(
          (sp) => sp._pictureId === targetId
        );
        const maskSprite = container.children.find(
          (sp) => sp._pictureId === maskId
        );
        if (targetSprite && maskSprite) {
          maskSprite.anchor.set(targetSprite.anchor.x, targetSprite.anchor.y);
          maskSprite.x = targetSprite.x;
          maskSprite.y = targetSprite.y;
          maskSprite.scale.set(targetSprite.scale.x, targetSprite.scale.y);
          targetSprite.mask = maskSprite;
        }
      }
    };
  })();

  (() => {
    //======================================================================
    // フェード制御
    //======================================================================

    "use strict";

    const pluginParams = PluginManager.parameters("OnevASSISTANT");
    const GLOBAL_FADE_VAR_ID = Number(pluginParams["FadeTimeVariableId"] || 0);
    function getGlobalFadeDuration(fallback) {
      if (GLOBAL_FADE_VAR_ID > 0) {
        const v = Number($gameVariables.value(GLOBAL_FADE_VAR_ID));
        return v > 0 ? v : fallback;
      }
      return fallback;
    }

    let _prevRuleFadeLayer = null;
    let isScreenFading = false;
    let queuedScreenFade = null;
    let _originalIsFastForward = null;

    Game_Screen.prototype._hexToRGB = function (hex) {
      hex = (hex || "").replace(/^#/, "");
      if (hex.length === 3)
        hex = hex
          .split("")
          .map((c) => c + c)
          .join("");
      const num = parseInt(hex, 16) || 0;
      return [(num >> 16) & 0xff, (num >> 8) & 0xff, num & 0xff];
    };

    Game_Screen.prototype.setRuleFadeColor = function (hex) {
      this._ruleFadeColor = this._hexToRGB(hex);
    };

    Game_Screen.prototype.clearRuleFadeColor = function () {
      this._ruleFadeColor = null;
    };

    Game_Screen.prototype.getRuleFadeColorHex = function () {
      if (!this._ruleFadeColor) return "#000000";
      return (
        "#" +
        this._ruleFadeColor
          .map((c) => ("0" + c.toString(16)).substr(-2))
          .join("")
      );
    };

    const _Scene_MenuBase_isBusy = Scene_MenuBase.prototype.isBusy;
    Scene_MenuBase.prototype.isBusy = function () {
      if (isScreenFading) return true;
      return _Scene_MenuBase_isBusy.apply(this, arguments);
    };

    PluginManager.registerCommand("OnevASSISTANT", "SET_FADE_COLOR", (args) => {
      const hex = args.color || "#000000";
      $gameScreen.setRuleFadeColor(hex);
    });

    PluginManager.registerCommand("OnevASSISTANT", "CLEAR_FADE_COLOR", () => {
      $gameScreen.clearRuleFadeColor();
    });

    PluginManager.registerCommand("OnevASSISTANT", "RuleFade", function (args) {
      const type = args.type;
      const imgName = args.ruleImage || "mask_Dissolve";
      let durationArg = Number(args.duration || 0);
      const duration =
        durationArg > 0 ? durationArg : getGlobalFadeDuration(60);
      const reverse = args.reverseDirection === "true";
      const colorCode = args.fadeColor || $gameScreen.getRuleFadeColorHex();
      performRuleScreenFade(type, imgName, duration, reverse, colorCode);
      if (this.wait) this.wait(duration);
    });

    function hexToRGBVec3(hex) {
      hex = (hex || "").replace(/^#/, "");
      if (hex.length === 3)
        hex = hex
          .split("")
          .map((c) => c + c)
          .join("");
      const num = parseInt(hex, 16) || 0;
      return [
        ((num >> 16) & 0xff) / 255,
        ((num >> 8) & 0xff) / 255,
        (num & 0xff) / 255,
      ];
    }

    function performRuleScreenFade(
      type,
      ruleImageName,
      duration = 0,
      reverseDirection = false,
      fadeColor
    ) {
      const scene = SceneManager._scene;
      if (!scene) return;
      if (isScreenFading) {
        queuedScreenFade = {
          type,
          ruleImageName,
          duration,
          reverseDirection,
          fadeColor,
        };
        return;
      }
      isScreenFading = true;
      if (SceneManager && SceneManager.isFastForward) {
        if (!_originalIsFastForward)
          _originalIsFastForward = SceneManager.isFastForward;
        SceneManager.isFastForward = () => false;
      }
      const ruleBitmap = ImageManager.loadBitmap("img/system/", ruleImageName);
      const fc = fadeColor || $gameScreen.getRuleFadeColorHex();
      const du = duration > 0 ? duration : getGlobalFadeDuration(60);
      const callStart = (bmp) =>
        startFade(
          scene,
          bmp,
          type,
          du,
          reverseDirection,
          fc,
          _prevRuleFadeLayer
        );
      if (!ruleBitmap.isReady()) ruleBitmap.addLoadListener(callStart);
      else callStart(ruleBitmap);
    }

    function startFade(
      scene,
      ruleBitmap,
      type,
      duration,
      reverseDirection,
      fadeColor,
      oldLayer = null
    ) {
      const layer = new PIXI.Container();
      scene.addChildAt(layer, scene.children.indexOf(scene._windowLayer));
      const blackSprite = new PIXI.Sprite(PIXI.Texture.WHITE);
      blackSprite.tint = 0xffffff;
      blackSprite.width = Graphics.width;
      blackSprite.height = Graphics.height;
      layer.addChild(blackSprite);

      const maskSprite = new Sprite(ruleBitmap);
      maskSprite.width = Graphics.width;
      maskSprite.height = Graphics.height;

      const shader = `
      precision mediump float;
      varying vec2 vTextureCoord;
      uniform sampler2D mask;
      uniform float progress;
      uniform int isFadeOut;
      uniform int invertMask;
      uniform vec3 fadeColor;
      void main(void){
        float m = texture2D(mask, vTextureCoord).r;
        if (invertMask == 1) m = 1.0 - m;
        float f = step(m, progress);
        float a = isFadeOut == 1 ? f : (1.0 - f);
        gl_FragColor = vec4(fadeColor * a, a);
      }
    `;
      const filter = new PIXI.Filter(undefined, shader, {
        mask: maskSprite.texture,
        progress: -0.001,
        isFadeOut: type === "out" ? 1 : 0,
        invertMask: reverseDirection ? 1 : 0,
        fadeColor: hexToRGBVec3(fadeColor),
      });
      blackSprite.filters = [filter];
      if (oldLayer && oldLayer.parent) oldLayer.parent.removeChild(oldLayer);
      _prevRuleFadeLayer = type === "out" ? layer : null;

      let frame = 0;
      function update() {
        filter.uniforms.progress = Math.min(frame / duration, 1.0);
        frame++;
        if (frame <= duration) {
          requestAnimationFrame(update);
        } else {
          if (type === "out") {
            blackSprite.filters = null;
            blackSprite.tint = PIXI.utils.string2hex(fadeColor);
            blackSprite.alpha = 1.0;
            _prevRuleFadeLayer = layer;
          }
          if (type === "in") scene.removeChild(layer);
          isScreenFading = false;
          if (_originalIsFastForward) {
            SceneManager.isFastForward = _originalIsFastForward;
            _originalIsFastForward = null;
            _prevRuleFadeLayer = null;
          }
          if (queuedScreenFade) {
            const q = queuedScreenFade;
            queuedScreenFade = null;
            performRuleScreenFade(
              q.type,
              q.ruleImageName,
              q.duration,
              q.reverseDirection,
              q.fadeColor
            );
          }
        }
      }
      requestAnimationFrame(update);
    }
  })();

  (() => {
    //======================================================================
    // チャットログ機能
    //======================================================================

    "use strict";
    const raw = getPluginParameter("OnevASSISTANT", "ChatLogSettings", "{}");
    const chatParams = safeJsonParse(raw, {});
    const parameters = {
      ...chatParams,
      ...PluginManager.parameters("OnevASSISTANT"),
    };

    let fontName = parameters["FontName"] || "GameFont";
    let fontLoaded = false;

    if (fontName !== "GameFont") {
      const fontFileName = fontName.endsWith(".woff")
        ? fontName
        : `${fontName}.woff`;
      const baseFontName = fontName.replace(/\.woff$/i, "");

      const font = new FontFace(baseFontName, `url("fonts/${fontFileName}")`);
      font
        .load()
        .then((loadedFont) => {
          document.fonts.add(loadedFont);
          fontLoaded = true;
        })
        .catch((err) => {
          console.warn(
            `フォント "${baseFontName}" の読み込みに失敗しました:`,
            err
          );
          fontLoaded = true;
        });

      fontName = baseFontName;
    } else {
      fontLoaded = true;
    }

    const _Scene_Boot_isReady = Scene_Boot.prototype.isReady;
    Scene_Boot.prototype.isReady = function () {
      return _Scene_Boot_isReady.call(this) && fontLoaded;
    };

    const settings = {
      disableSwitchId: Number(parameters["DisableChatSwitchID"] || 2),
      visibleSwitchId: Number(parameters["SwitchID"] || 1),
      forceHideSwitchIds: JSON.parse(
        parameters["ForceHideSwitchIds"] || "[]"
      ).map(Number),
      maxEntries: Number(parameters["MaxLogEntries"] || 100),
      padding: {
        top: Number(parameters["PaddingTop"] || 8),
        bottom: Number(parameters["PaddingBottom"] || 8),
        left: Number(parameters["PaddingLeft"] || 12),
        right: Number(parameters["PaddingRight"] || 12),
      },
      fontSize: Number(parameters["FontSize"] || 28),
      iconSize: Number(parameters["IconSize"] || 32),
      scrollAmount: Number(parameters["ScrollAmount"] || 40),
      defaultStampWidth: Number(parameters["DefaultStampWidth"] || 100),
      defaultStampHeight: Number(parameters["DefaultStampHeight"] || 100),
      backgroundImage: parameters["CustomBackgroundImage"] || "",
      voiceCompleteId: Number(parameters["VoiceCompleteSwitchID"] || 0),
      fontName: fontName,
      window: {
        x: Number(parameters["WindowX"] || 0),
        y: Number(parameters["WindowY"] || 0),
        width: Number(parameters["WindowWidth"] || 480),
        height: Number(parameters["WindowHeight"] || 216),
        opacity: Number(parameters["WindowOpacity"] || 255),
      },
      lineSpacing: Number(parameters["LineSpacing"] || 4),
    };

    let {
      x: currentWindowX,
      y: currentWindowY,
      width: currentWindowWidth,
      height: currentWindowHeight,
      opacity: currentWindowOpacity,
    } = settings.window;

    let {
      top: paddingTop,
      bottom: paddingBottom,
      left: paddingLeft,
      right: paddingRight,
    } = settings.padding;

    let scrollAmount = settings.scrollAmount;
    let maxLogEntries = settings.maxEntries;
    let disableChatSwitchId = settings.disableSwitchId;
    const DEBUG = true;
    let switchId = settings.visibleSwitchId;
    let fontSize = settings.fontSize;
    let iconSize = settings.iconSize;
    let lineSpacing = settings.lineSpacing;
    let fontNameFinal = settings.fontName;
    let customBackgroundImage = settings.backgroundImage;
    let voiceCompleteSwitchId = settings.voiceCompleteId;
    let chatEntries = [];
    let scrollY = 0;
    let totalLogHeight = 0;
    let maxScrollY = 0;
    let $chatLogData = {
      entries: [],
      scrollY: 0,
      wasVisible: false,
      windowX: currentWindowX,
      windowY: currentWindowY,
      windowWidth: currentWindowWidth,
      windowHeight: currentWindowHeight,
      windowOpacity: currentWindowOpacity,
    };

    function Window_ChatLog() {
      this.initialize(...arguments);
    }

    Window_ChatLog.prototype = Object.create(Window_Base.prototype);
    Window_ChatLog.prototype.constructor = Window_ChatLog;

    Window_ChatLog.prototype.initialize = function () {
      const rect = new Rectangle(
        currentWindowX,
        currentWindowY,
        currentWindowWidth,
        currentWindowHeight
      );
      Window_Base.prototype.initialize.call(this, rect);

      this.contents.fontSize = fontSize;

      if (customBackgroundImage) {
        this.windowskin = new Bitmap();
        this.opacity = 0;
        this.backOpacity = 0;
        this.contentsOpacity = 255;
        this._backgroundSprite = new Sprite();
        const bgBitmap = ImageManager.loadPicture(customBackgroundImage);
        this._backgroundSprite.bitmap = bgBitmap;
        this.addChildToBack(this._backgroundSprite);

        bgBitmap.addLoadListener(() => {
          const w = bgBitmap.width;
          const h = bgBitmap.height;

          this._backgroundSprite.x = 0;
          this._backgroundSprite.y = 0;
          this.setWindowSize(
            w,
            h,
            currentWindowX,
            currentWindowY,
            currentWindowOpacity
          );
        });
      } else {
        this.opacity = currentWindowOpacity;
        this.backOpacity = 192;
        this.contentsOpacity = 255;
      }
      this.hide();
      this.updateVisibility();
      this.initializeMouseScroll();
      this.redrawLog();
      this._draggingScrollbar = false;
      this._dragOffsetY = 0;
    };

    Window_ChatLog.prototype._refreshFrame = function () {
      if (customBackgroundImage) return;
      Window_Base.prototype._refreshFrame.call(this);
    };

    Window_ChatLog.prototype.updateVisibility = function () {
      const forceHidden = settings.forceHideSwitchIds.some((id) =>
        $gameSwitches.value(id)
      );
      if (forceHidden || !$gameSwitches.value(switchId)) {
        this.hideWindow();
      } else {
        this.showWindow();
      }
    };

    Window_ChatLog.prototype.textPadding = function () {
      return 0;
    };

    Window_ChatLog.prototype.lineHeight = function () {
      return this.contents.fontSize + 6;
    };

    Window_ChatLog.prototype.convertEscapeCharacters = function (text) {
      text = text.replace(/\\+n(?![\[\d])/g, "\n");
      text = text.replace(/\\/g, "¤");
      text = text.replace(/¤V\[(\d+)\]/gi, (_, n) => {
        return $gameVariables.value(Number(n));
      });

      text = text.replace(/\\SV\[([^\]]+)\]/gi, (_, arg) => {
        const expanded = this.convertEscapeCharacters(arg);
        this._lastVoiceName = expanded;
        return "";
      });

      text = text.replace(/¤SC\[(\d+)\]/gi, (_, n) => {
        const varValue = $gameVariables.value(Number(n));
        this._lastVoiceName = varValue;
        return "";
      });

      text = text.replace(/¤N\[(\d+)\]/gi, (_, n) => {
        const actor = $gameActors.actor(Number(n));
        return actor ? actor.name() : "";
      });

      text = text.replace(/¤ITEM\[(\d+)\]/gi, (_, id) => {
        const item = $dataItems[parseInt(id, 10)];
        return item ? item.name : "";
      });

      text = text.replace(/¤WEAPON\[(\d+)\]/gi, (_, id) => {
        const wep = $dataWeapons[parseInt(id, 10)];
        return wep ? wep.name : "";
      });

      text = text.replace(/¤ARMOR\[(\d+)\]/gi, (_, id) => {
        const arm = $dataArmors[parseInt(id, 10)];
        return arm ? arm.name : "";
      });

      text = text.replace(/¤G/gi, TextManager.currencyUnit);

      return text;
    };

    Window_ChatLog.prototype.initializeMouseScroll = function () {};

    const _Window_ChatLog_update = Window_ChatLog.prototype.update;
    Window_ChatLog.prototype.update = function () {
      _Window_ChatLog_update.call(this);
      if (this.visible) {
        const wheelY = TouchInput.wheelY;
        if (wheelY > 0) {
          this.scrollYMinus();
        } else if (wheelY < 0) {
          this.scrollYPlus();
        }
      }
    };

    Window_ChatLog.prototype.scrollYPlus = function () {
      scrollY = Math.min(scrollY + scrollAmount, maxScrollY);
      this.redrawLog();
    };

    Window_ChatLog.prototype.scrollYMinus = function () {
      scrollY = Math.max(scrollY - scrollAmount, 0);
      this.redrawLog();
    };

    Window_ChatLog.prototype.redrawLog = function () {
      this.contents.clear();
      this._playedVoices = [];
      this._stampHitAreas = [];
      this.updateTotalHeight();
      let currentY = this.contents.height - paddingBottom + scrollY;
      for (let i = chatEntries.length - 1; i >= 0; i--) {
        const entry = chatEntries[i];
        let entryHeight;
        if (entry.height) {
          entryHeight = entry.height;
        } else if (entry.text && entry.text.includes("\n")) {
          const lineCnt = entry.text.split("\n").length;
          entryHeight = (fontSize + lineSpacing) * lineCnt;
        } else {
          entryHeight = fontSize + lineSpacing;
        }
        currentY -= entryHeight;
        if (currentY < -entryHeight) break;
        if (currentY > this.contents.height) continue;
        if (entry.type === "text") {
          this.contents.fontSize = fontSize;

          const txt = this.convertEscapeCharacters(entry.text);
          let x;
          if (entry.align === "right") {
            const w = this.textWidth(txt);
            x = this.contents.width - paddingRight - w;
          } else {
            x = paddingLeft;
          }
          this.drawChatText(entry.text, x, currentY, entry.align);
        } else if (entry.type === "stamp") {
          const bitmap = ImageManager.loadPicture(entry.stampName);
          if (bitmap && bitmap.isReady()) {
            const w = entry.width;
            const h = entry.height;
            const x =
              entry.align === "right"
                ? this.contents.width - w - paddingRight
                : paddingLeft;

            this.contents.blt(
              bitmap,
              0,
              0,
              bitmap.width,
              bitmap.height,
              x,
              currentY,
              w,
              h
            );
            this._stampHitAreas.push({
              x,
              y: currentY,
              width: w,
              height: h,
              commonEventId: entry.commonEventId || 0,
            });
          } else {
            bitmap.addLoadListener(() => this.redrawLog());
          }
        }
      }

      this.drawScrollBar();
      this.contents.fontSize = fontSize;
    };

    Window_ChatLog.prototype.drawScrollBar = function () {
      const barWidth = 8;
      const marginRight = 4;
      const visibleHeight = this.contents.height - paddingTop - paddingBottom;

      if (totalLogHeight <= visibleHeight) return;

      const trackX = this.contents.width - barWidth - marginRight;
      const trackY = paddingTop;
      const trackH = visibleHeight;
      this.contents.paintOpacity = 48;
      this.contents.fillRect(trackX, trackY, barWidth, trackH, "#000000");
      const barRatio = visibleHeight / totalLogHeight;
      const barHeight = Math.floor(visibleHeight * barRatio);
      const maxScroll = totalLogHeight - visibleHeight;
      const barY =
        paddingTop +
        Math.floor(
          ((maxScroll - scrollY) / maxScroll) * (visibleHeight - barHeight)
        );

      this.contents.paintOpacity = 128;
      this.contents.fillRect(trackX, barY, barWidth, barHeight, "#FFFFFF");
      this.contents.paintOpacity = 255;
    };

    Window_ChatLog.prototype.updateTotalHeight = function () {
      let total = 0;
      for (let i = chatEntries.length - 1; i >= 0; i--) {
        const entry = chatEntries[i];
        let entryHeight;
        if (entry.height) {
          entryHeight = entry.height;
        } else if (entry.text && entry.text.includes("\n")) {
          entryHeight = (fontSize + lineSpacing) * 2;
        } else {
          entryHeight = fontSize + lineSpacing;
        }
        if (entry.text && entry.text.includes("\n")) {
          const normalizedText = this.convertEscapeCharacters(entry.text);
          const lineCount = normalizedText.split("\n").length;
          entryHeight = (fontSize + lineSpacing) * lineCount;
        }
        total += entryHeight;
      }
      totalLogHeight = total;

      const visibleHeight = this.contents.height - paddingTop - paddingBottom;
      maxScrollY = Math.max(totalLogHeight - visibleHeight, 0);

      scrollY = Math.min(scrollY, maxScrollY);
    };

    Window_ChatLog.prototype.updateDragScroll = function () {
      const visibleHeight = this.contents.height - paddingTop - paddingBottom;
      if (totalLogHeight <= visibleHeight) return;

      const barWidth = 8;
      const marginRight = 4;
      const pad = this._padding !== undefined ? this._padding : 12;
      const mx = TouchInput.x - (this.x + pad);
      const my = TouchInput.y - (this.y + pad);
      const trackX = this.contents.width - barWidth - marginRight;
      const trackY = paddingTop;
      const trackH = visibleHeight;
      const barH = Math.floor((visibleHeight * visibleHeight) / totalLogHeight);
      const maxScroll = totalLogHeight - visibleHeight;
      const barY =
        trackY + Math.floor((trackH - barH) * (1 - scrollY / maxScroll));

      if (!this._draggingScrollbar && TouchInput.isTriggered()) {
        if (
          mx >= trackX &&
          mx <= trackX + barWidth &&
          my >= barY &&
          my <= barY + barH
        ) {
          this._draggingScrollbar = true;
          this._dragOffsetY = my - barY;
          return;
        }
      }

      if (this._draggingScrollbar) {
        if (TouchInput.isPressed()) {
          let relY = my - this._dragOffsetY;
          relY = Math.max(0, Math.min(trackH - barH, relY));
          scrollY = Math.round(maxScroll * (1 - relY / (trackH - barH)));
          this.redrawLog();
          return;
        }
        if (TouchInput.isReleased()) {
          this._draggingScrollbar = false;
        }
      }
    };

    Window_ChatLog.prototype.scrollToBottom = function () {
      this.updateTotalHeight();
      scrollY = 0;
      this.redrawLog();
    };

    Window_ChatLog.prototype.clearLog = function () {
      chatEntries = [];
      scrollY = 0;
      totalLogHeight = 0;
      maxScrollY = 0;
      this.contents.clear();
    };

    Window_ChatLog.prototype.hideWindow = function () {
      this.visible = false;
      this.hide();
    };

    Window_ChatLog.prototype.showWindow = function () {
      this.visible = true;
      this.show();
      this.redrawLog();
    };

    Window_ChatLog.prototype.setWindowSize = function (
      width,
      height,
      x,
      y,
      opacity
    ) {
      if (width !== undefined) currentWindowWidth = width;
      if (height !== undefined) currentWindowHeight = height;
      if (x !== undefined) currentWindowX = x;
      if (y !== undefined) currentWindowY = y;
      if (opacity !== undefined) currentWindowOpacity = opacity;

      this.move(
        currentWindowX,
        currentWindowY,
        currentWindowWidth,
        currentWindowHeight
      );
      this.opacity = currentWindowOpacity;
      this.createContents();
      this.redrawLog();
    };

    Window_ChatLog.prototype.drawChatText = function (text, x, y, align) {
      const normalizedText = text.replace(/\\+n(?![\[\d])/g, "\n");
      const textState = {
        index: 0,
        x: x,
        y: y,
        left: x,
        text: this.convertEscapeCharacters(normalizedText),
        drawing: true,
      };

      this.contents.fontFace = fontName;
      this.contents.fontSize = fontSize;
      this.resetTextColor();
      this.contents.fontBold = false;
      this.contents.fontItalic = false;
      this.contents.outlineWidth = 4;

      const controlCodeMarker = "¤";
      while (textState.index < textState.text.length) {
        const c = textState.text.charAt(textState.index);
        if (c === controlCodeMarker) {
          textState.index++;
          const code = this.obtainEscapeCode(textState);
          this.processChatEscapeCharacter(code, textState);
        } else if (c === "\n") {
          textState.x = textState.left;
          textState.y += this.lineHeight();
          textState.index++;
        } else {
          const w = this.textWidth(c);
          this.contents.drawText(
            c,
            textState.x,
            textState.y,
            w,
            this.lineHeight(),
            "left"
          );
          textState.x += w;
          textState.index++;
        }
      }
    };

    Window_ChatLog.prototype.resetFontSettings = function () {
      this.contents.fontFace = fontName;
      this.contents.fontSize = fontSize;
      this.resetTextColor();
      this.contents.fontBold = false;
      this.contents.fontItalic = false;
    };

    Window_ChatLog.prototype.processChatEscapeCharacter = function (
      code,
      textState
    ) {
      switch (code) {
        case "C": {
          const colorIndex = this.obtainEscapeParam(textState);
          this.changeTextColor(this.textColor(colorIndex));
          break;
        }
        case "I": {
          const iconIndex = this.obtainEscapeParam(textState);
          this.drawIcon(iconIndex, textState.x, textState.y + 2);
          textState.x += this.iconWidth;
          break;
        }
        case "FS": {
          const size = this.obtainEscapeParam(textState);
          this.contents.fontSize = size;
          break;
        }
        case "V": {
          const variableId = this.obtainEscapeParam(textState);
          const value = $gameVariables.value(variableId).toString();
          for (let i = 0; i < value.length; i++) {
            const char = value.charAt(i);
            const w = this.textWidth(char);
            this.contents.drawText(
              char,
              textState.x,
              textState.y,
              w,
              this.lineHeight(),
              "left"
            );
            textState.x += w;
          }
          break;
        }
        case "FB": {
          this.contents.fontBold = !this.contents.fontBold;
          break;
        }
        case "FI": {
          this.contents.fontItalic = !this.contents.fontItalic;
          break;
        }
        case "OW": {
          const width = this.obtainEscapeParam(textState);
          this.contents.outlineWidth = width;
          break;
        }
        case "SV": {
          const match = textState.text
            .substring(textState.index)
            .match(/^\[([^\]]+)\]/);
          if (match) {
            let fileName = match[1];
            textState.index += match[0].length;

            fileName = this.convertEscapeCharacters(fileName);

            if (this._playedVoices && this._playedVoices.includes(fileName)) {
            } else {
              this._lastVoiceName = fileName;
            }
          }
          break;
        }
      }
    };

    Window_ChatLog.prototype.obtainEscapeCode = function (textState) {
      const regExp = /^([A-Z]{1,3})/i;
      const match = textState.text.substring(textState.index).match(regExp);
      if (match) {
        textState.index += match[1].length;
        return match[1].toUpperCase();
      }
      return "";
    };

    Window_ChatLog.prototype.obtainEscapeParam = function (textState) {
      const regExp = /^\[(\d+)\]/;
      const match = textState.text.substring(textState.index).match(regExp);
      if (match) {
        textState.index += match[0].length;
        return Number(match[1]);
      } else {
        return 0;
      }
    };

    Window_ChatLog.prototype._localX = function () {
      return TouchInput.x - this.x - this.padding;
    };
    Window_ChatLog.prototype._localY = function () {
      return TouchInput.y - this.y - this.padding;
    };

    Window_ChatLog.prototype.update = function () {
      Window_Base.prototype.update.call(this);
      this.updateDragScroll();

      if (this.visible && TouchInput.isTriggered()) {
        const lx = this._localX();
        const ly = this._localY();
        for (const area of this._stampHitAreas) {
          if (
            lx >= area.x &&
            lx <= area.x + area.width &&
            ly >= area.y &&
            ly <= area.y + area.height
          ) {
            if (area.commonEventId > 0) {
              $gameTemp.reserveCommonEvent(area.commonEventId);
            }
            break;
          }
        }
      }
    };

    Window_ChatLog.prototype.addChatText = function (text, align) {
      if ($gameSwitches.value(disableChatSwitchId)) return;

      const rawText = text;
      const displayText = this.convertEscapeCharacters(text);

      if (
        displayText &&
        window.SimpleVoiceControlParams &&
        window.SimpleVoiceControlParams.enableVoicePlayback
      ) {
        if (this._lastVoiceName == undefined) {
          const svMatch = /\\SV\[(.+?)\]/i.exec(rawText);
          this._lastVoiceName = svMatch[1];
        }

        const sound = {
          name: this._lastVoiceName,
          volume: ConfigManager.voiceVolume || 100,
          pitch: 100,
          pan: 0,
        };

        if (this._currentVoiceBuffer && this._currentVoiceBuffer.isPlaying()) {
          this._currentVoiceBuffer.stop();
        }

        const buffer = AudioManager.createBuffer("voice", sound.name);
        this._currentVoiceBuffer = buffer;
        buffer.addLoadListener(() => {
          buffer.play(false, 0);
          buffer.addStopListener(() => {
            if (voiceCompleteSwitchId > 0) {
              $gameSwitches.setValue(voiceCompleteSwitchId, true);
            }
          });
        });
        this._lastVoiceName = null;
      }

      const entryHeight = fontSize + lineSpacing;
      const entry = {
        type: "text",
        text: displayText,
        align: align,
        fontSize: fontSize,
        height: entryHeight,
      };

      chatEntries.push(entry);
      if (chatEntries.length > maxLogEntries) {
        chatEntries.shift();
      }

      this.scrollToBottom();
      this.showWindow();
    };

    Window_ChatLog.prototype.addStamp = function (
      stampName,
      align,
      width,
      height,
      commonEventId = 0
    ) {
      if ($gameSwitches.value(disableChatSwitchId)) return;

      const defaultWidth = Number(parameters["DefaultStampWidth"]) || 100;
      const defaultHeight = Number(parameters["DefaultStampHeight"]) || 100;
      const bitmap = ImageManager.loadPicture(stampName);

      bitmap.addLoadListener(() => {
        let finalWidth = bitmap.width;
        let finalHeight = bitmap.height;

        if (finalWidth > defaultWidth || finalHeight > defaultHeight) {
          const scale = Math.min(
            defaultWidth / finalWidth,
            defaultHeight / finalHeight
          );
          finalWidth = Math.floor(finalWidth * scale);
          finalHeight = Math.floor(finalHeight * scale);
        }

        const entry = {
          type: "stamp",
          stampName,
          align,
          width: finalWidth,
          height: finalHeight,
          commonEventId,
        };

        chatEntries.push(entry);
        if (chatEntries.length > maxLogEntries) chatEntries.shift();

        this.scrollToBottom();
        this.redrawLog();
        this.showWindow();
      });
    };

    const _Game_Interpreter_pluginCommand =
      Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args) {
      if (_Game_Interpreter_pluginCommand) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
      }

      if (!SceneManager._scene || !SceneManager._scene._chatLogWindow) {
        return;
      }

      const chatWindow = SceneManager._scene._chatLogWindow;
      if (!args) args = [];

      switch (command) {
        case "chatleft":
        case "chatright": {
          const text = args.join(" ").replace(/_/g, " ");
          const align = command === "chatleft" ? "left" : "right";
          chatWindow.addChatText(text, align);
          break;
        }
        case "chatsize": {
          const w = Number(args[0] || currentWindowWidth);
          const h = Number(args[1] || currentWindowHeight);
          const x = Number(args[2] || currentWindowX);
          const y = Number(args[3] || currentWindowY);
          const op =
            args[4] !== undefined ? Number(args[4]) : currentWindowOpacity;
          chatWindow.setWindowSize(w, h, x, y, op);
          break;
        }
        case "chatscroll": {
          const val = Number(args[0] || defaultScrollAmount);
          scrollAmount = val;
          break;
        }
        case "chatclear": {
          chatWindow.clearLog();
          break;
        }
      }
    };

    function onchat(align, content) {
      if (!SceneManager._scene || !SceneManager._scene._chatLogWindow) {
        console.warn("ChatLog Window is not initialized");
        return;
      }
      const chatWindow = SceneManager._scene._chatLogWindow;

      if (align !== "left" && align !== "right") {
        console.warn("Invalid align: use 'left' or 'right'");
        return;
      }

      if (typeof content === "string") {
        const normalizedContent = content.replace(/\\+n(?![\[\d])/g, "\n");
        chatWindow.addChatText(normalizedContent, align);
      } else if (typeof content === "object" && content.stamp) {
        chatWindow.addStamp(
          content.stamp,
          align,
          content.width,
          content.height
        );
      } else {
        console.warn("Invalid content. Must be a string or {stamp:'img', ...}");
      }
    }
    window.onchat = onchat;

    const _Scene_Map_createAllWindows = Scene_Map.prototype.createAllWindows;
    Scene_Map.prototype.createAllWindows = function () {
      _Scene_Map_createAllWindows.call(this);
      this._chatLogWindow = new Window_ChatLog();
      const picContainer = this._spriteset._pictureContainer;
      picContainer.addChild(this._chatLogWindow);
      picContainer.setChildIndex(
        this._chatLogWindow,
        picContainer.children.length - 1
      );
      this._chatLogWindow.restoreFromSaveData();
    };

    const _Scene_Map_updateMain = Scene_Map.prototype.updateMain;
    Scene_Map.prototype.updateMain = function () {
      _Scene_Map_updateMain.call(this);
      if (this._chatLogWindow) {
        this._chatLogWindow.updateVisibility();
        this._chatLogWindow.updateDragScroll();
      }
    };

    Window_ChatLog.prototype.restoreFromSaveData = function () {
      if ($chatLogData.entries) {
        chatEntries = JSON.parse(JSON.stringify($chatLogData.entries));
      }
      scrollY = $chatLogData.scrollY || 0;
      totalLogHeight = 0;
      currentWindowX = $chatLogData.windowX || currentWindowX;
      currentWindowY = $chatLogData.windowY || currentWindowY;
      currentWindowWidth = $chatLogData.windowWidth || currentWindowWidth;
      currentWindowHeight = $chatLogData.windowHeight || currentWindowHeight;
      currentWindowOpacity = $chatLogData.windowOpacity || currentWindowOpacity;

      this.move(
        currentWindowX,
        currentWindowY,
        currentWindowWidth,
        currentWindowHeight
      );
      this.opacity = currentWindowOpacity;
      this.createContents();

      if ($chatLogData.wasVisible) {
        this.showWindow();
      } else {
        this.hideWindow();
      }
      this.redrawLog();
    };

    const _Scene_Map_start = Scene_Map.prototype.start;
    Scene_Map.prototype.start = function () {
      _Scene_Map_start.call(this);

      if ($chatLogData.wasVisible && this._chatLogWindow) {
        this._chatLogWindow.showWindow();
      }
    };

    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function () {
      if (this._chatLogWindow) {
        this._chatLogWindow.saveChatLogData();
      }
      _Scene_Map_terminate.call(this);
    };

    Window_ChatLog.prototype.saveChatLogData = function () {
      $chatLogData.entries = JSON.parse(JSON.stringify(chatEntries));
      $chatLogData.scrollY = scrollY;
      $chatLogData.wasVisible = this.visible;
      $chatLogData.windowX = currentWindowX;
      $chatLogData.windowY = currentWindowY;
      $chatLogData.windowWidth = currentWindowWidth;
      $chatLogData.windowHeight = currentWindowHeight;
      $chatLogData.windowOpacity = currentWindowOpacity;
    };

    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
      const contents = _DataManager_makeSaveContents.call(this);
      contents.chatLogData = JSON.parse(JSON.stringify($chatLogData));
      return contents;
    };

    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
      _DataManager_extractSaveContents.call(this, contents);
      if (contents.chatLogData) {
        $chatLogData = JSON.parse(JSON.stringify(contents.chatLogData));
      }
    };

    Window_ChatLog.prototype.standardFontFace = function () {
      return fontName;
    };

    PluginManager.registerCommand("OnevASSISTANT", "ChatLog", (args) => {
      const action = args.action;
      const message = args.message || "";

      if (!SceneManager._scene || !SceneManager._scene._chatLogWindow) {
        console.warn("ChatLog Window not found.");
        return;
      }

      const chatWindow = SceneManager._scene._chatLogWindow;

      switch (action) {
        case "左にログを追加":
          chatWindow.addChatText(message, "left");
          break;

        case "右にログを追加":
          chatWindow.addChatText(message, "right");
          break;

        case "ログをクリア":
          chatWindow.clearLog();
          break;
      }
    });

    PluginManager.registerCommand("OnevASSISTANT", "ChatStamp", (args) => {
      const side = args.side === "右" ? "right" : "left";
      const stamp = args.stampName || "";
      const w = Number(args.width || 0);
      const h = Number(args.height || 0);
      const ceId = Number(args.commonEventId || 0);

      const chatWindow =
        SceneManager._scene && SceneManager._scene._chatLogWindow;
      chatWindow.addStamp(stamp, side, w, h, ceId);
    });

    PluginManager.registerCommand("OnevASSISTANT", "ChatWindow", (args) => {
      const x = Number(args.x || 0);
      const y = Number(args.y || 0);
      const width = Number(args.width || 480);
      const height = Number(args.height || 216);
      const opacity = Number(args.opacity || 255);
      const chatWindow =
        SceneManager._scene && SceneManager._scene._chatLogWindow;
      if (chatWindow) {
        chatWindow.setWindowSize(width, height, x, y, opacity);
      } else {
        console.warn("⚠️ チャットウィンドウがまだ初期化されていません");
      }
    });
  })();

  (() => {
    //=============================================================================
    // ウィンドウサイズ変更+オプション項目
    //=============================================================================

    "use strict";

    const parameters = PluginManager.parameters("OnevASSISTANT");
    const OptionCommands = OnevASSISTANT.safeJsonParse(
      parameters["OptionCommands"],
      {}
    );
    const EnabledSizes = JSON.parse(parameters["EnabledSizes"] || "[]").map(
      Number
    );

    ConfigManager.alwaysDash = OptionCommands.alwaysDash === "true";
    ConfigManager.commandRemember = OptionCommands.commandRemember === "true";
    ConfigManager.touchUI = OptionCommands.touchUI === "true";
    ConfigManager.screenSize = 2;
    ConfigManager.fullScreen = false;
    ConfigManager.returnToTitle = OptionCommands.returnToTitle === "true";
    const showAlwaysDash = OptionCommands.showAlwaysDash === "true";
    const showCommandRemember = OptionCommands.showCommandRemember === "true";
    const showTouchUI = OptionCommands.showTouchUI === "true";
    const showReturnToTitle = OptionCommands.showReturnToTitle === "true";
    const showScreenSize = OptionCommands.showScreenSize === "true";
    const showFullScreen = OptionCommands.showFullScreen === "true";

    const SizeManager = {
      SIZES: {
        0: { width: 816, height: 624 },
        1: { width: 1024, height: 576 },
        2: { width: 1280, height: 720 },
        3: { width: 1600, height: 900 },
        4: { width: 1920, height: 1080 },
      },
      FILE_NAME: "windowsize",
      _savedApplied: false,
      resizeWindow(w, h) {
        const fw = window.outerWidth - window.innerWidth;
        const fh = window.outerHeight - window.innerHeight;
        window.resizeTo(w + fw, h + fh);
      },
      applySize(label) {
        ConfigManager.screenSize = label;
        this.save(label);
        if (!Graphics._isFullScreen()) {
          this.applyRecordedSize();
        }
      },
      applyRecordedSize() {
        const size = this.SIZES[ConfigManager.screenSize];
        if (size) this.resizeWindow(size.width, size.height);
      },
      save(label) {
        const data = {
          sizeLabel: label ?? ConfigManager.screenSize,
          isFullScreen: Graphics._isFullScreen(),
        };
        StorageManager.saveToLocalFile(
          this.FILE_NAME,
          JSON.stringify(data)
        ).catch(() => {});
      },
      async load() {
        try {
          const json = await StorageManager.loadFromLocalFile(this.FILE_NAME);
          return JSON.parse(json);
        } catch {
          return null;
        }
      },
      async applySaved() {
        if (this._savedApplied) return;
        this._savedApplied = true;

        const data = await this.load();
        if (!data) return;

        if (data.sizeLabel !== undefined && this.SIZES[data.sizeLabel]) {
          ConfigManager.screenSize = data.sizeLabel;
          this.applyRecordedSize();
        }
        if (data.isFullScreen && !Graphics._isFullScreen()) {
          Graphics._requestFullScreen();
        }
      },
      getClosestLabel() {
        const w = window.innerWidth,
          h = window.innerHeight;
        let closest = 0,
          minDiff = Infinity;
        for (const [label, size] of Object.entries(this.SIZES)) {
          const diff = Math.abs(size.width - w) + Math.abs(size.height - h);
          if (diff < minDiff) {
            closest = Number(label);
            minDiff = diff;
          }
        }
        return closest;
      },
      getLabels() {
        return EnabledSizes.filter((id) => this.SIZES.hasOwnProperty(id));
      },
      getSizeOptions() {
        return this.getLabels().map((id) => {
          const s = this.SIZES[id];
          return `${s.width}×${s.height}`;
        });
      },
    };

    const _ConfigManager_makeData = ConfigManager.makeData;
    ConfigManager.makeData = function () {
      const config = _ConfigManager_makeData.call(this);
      config.screenSize = this.screenSize;
      config.fullScreen = this.fullScreen;
      return config;
    };

    const _ConfigManager_applyData = ConfigManager.applyData;
    ConfigManager.applyData = function (config) {
      _ConfigManager_applyData.call(this, config);
      this.screenSize = Number.isInteger(config.screenSize)
        ? config.screenSize
        : 0;
      this.fullScreen =
        typeof config.fullScreen === "boolean" ? config.fullScreen : false;
    };

    const _Scene_Boot_start = Scene_Boot.prototype.start;
    Scene_Boot.prototype.start = function () {
      _Scene_Boot_start.call(this);
      SizeManager.applySaved();
    };

    let _prevFullScreen = Graphics._isFullScreen();
    const _SceneManager_updateMain = SceneManager.updateMain;
    SceneManager.updateMain = function () {
      _SceneManager_updateMain.call(this);
      const now = Graphics._isFullScreen();
      if (_prevFullScreen && !now) SizeManager.applyRecordedSize();
      _prevFullScreen = now;
    };

    const _SceneManager_terminate = SceneManager.terminate;
    SceneManager.terminate = function () {
      SizeManager.save();
      _SceneManager_terminate.call(this);
    };
    window.changeWindowSize = (label) => SizeManager.applySize(label);
    window.toggleFullScreen = () => Graphics._switchFullScreen();
    const _Window_Options_addGeneralOptions =
      Window_Options.prototype.addGeneralOptions;
    Window_Options.prototype.addGeneralOptions = function () {
      _Window_Options_addGeneralOptions.call(this);
      if (showScreenSize) this.addCommand("画面サイズ", "screenSize");
      if (showFullScreen) this.addCommand("フルスクリーン", "fullScreen");
    };

    const _Window_Options_statusText = Window_Options.prototype.statusText;
    Window_Options.prototype.statusText = function (index) {
      const symbol = this.commandSymbol(index);
      const value = this.getConfigValue(symbol);
      if (symbol === "screenSize") {
        const labels = SizeManager.getLabels();
        const options = SizeManager.getSizeOptions();
        const idx = labels.indexOf(value);
        return options[idx] || "";
      } else if (symbol === "fullScreen") {
        return value ? "ON" : "OFF";
      } else if (symbol === "returnToTitle") {
        return "";
      }
      return _Window_Options_statusText.call(this, index);
    };

    const _Window_Options_processOk = Window_Options.prototype.processOk;
    Window_Options.prototype.processOk = function () {
      const index = this.index();
      const symbol = this.commandSymbol(index);
      const value = this.getConfigValue(symbol);
      if (symbol === "screenSize") {
        const labels = SizeManager.getLabels();
        const i = labels.indexOf(value);
        const next = (i + 1) % labels.length;
        const val = labels[next];
        this.changeValue(symbol, val);
        SizeManager.applySize(val);
      } else if (symbol === "fullScreen") {
        this.changeValue(symbol, !value);
        if (this.getConfigValue(symbol) !== Graphics._isFullScreen()) {
          Graphics._switchFullScreen();
        }
      } else if (symbol === "returnToTitle") {
        SoundManager.playOk();
        SceneManager.goto(Scene_Title);
      } else {
        _Window_Options_processOk.call(this);
      }
    };

    const _Window_Options_makeCommandList =
      Window_Options.prototype.makeCommandList;
    Window_Options.prototype.makeCommandList = function () {
      _Window_Options_makeCommandList.call(this);
      this._list = this._list.filter((cmd) => {
        if (cmd.symbol === "alwaysDash" && !showAlwaysDash) return false;
        if (cmd.symbol === "commandRemember" && !showCommandRemember)
          return false;
        if (cmd.symbol === "touchUI" && !showTouchUI) return false;
        return true;
      });
      if (showReturnToTitle) this.addCommand("タイトルに戻る", "returnToTitle");
      this.addCommand("閉じる", "close", false);
    };

    const _Window_Options_drawItem = Window_Options.prototype.drawItem;
    Window_Options.prototype.drawItem = function (index) {
      if (this.commandSymbol(index) === "close") {
        const rect = this.itemRect(index);
        this.resetTextColor();
        this.changePaintOpacity(true);
        this.drawText(
          this.commandName(index),
          rect.x,
          rect.y,
          rect.width,
          "center"
        );
      } else {
        _Window_Options_drawItem.call(this, index);
      }
    };

    const _Window_Options_processOkClose = Window_Options.prototype.processOk;
    Window_Options.prototype.processOk = function () {
      const symbol = this.commandSymbol(this.index());
      if (symbol === "close") SceneManager.pop();
      else _Window_Options_processOkClose.call(this);
    };

    function overrideTouchUIButton(sceneClass) {
      const _createButtons = sceneClass.prototype.createButtons;
      sceneClass.prototype.createButtons = function () {
        _createButtons.call(this);
        if (!showTouchUI && this._buttonTouchUI) {
          this._buttonTouchUI.visible = false;
          this.removeChild(this._buttonTouchUI);
          this._buttonTouchUI = null;
        }
      };
    }

    overrideTouchUIButton(Scene_Title);
    overrideTouchUIButton(Scene_MenuBase);
    overrideTouchUIButton(Scene_Options);

    const _Scene_Map_createMenuButton = Scene_Map.prototype.createMenuButton;
    Scene_Map.prototype.createMenuButton = function () {
      _Scene_Map_createMenuButton.call(this);
      if (!showTouchUI && this._menuButton) {
        this._menuButton.visible = false;
        this.removeChild(this._menuButton);
        this._menuButton = null;
      }
    };

    const _Scene_Map_createButtons = Scene_Map.prototype.createButtons;
    Scene_Map.prototype.createButtons = function () {
      _Scene_Map_createButtons.call(this);
      if (!showTouchUI && this._buttonTouchUI) {
        this._buttonTouchUI.visible = false;
        this.removeChild(this._buttonTouchUI);
        this._buttonTouchUI = null;
      }
    };
  })();

  (() => {
    //=============================================================================
    // 点滅+移動制御
    //=============================================================================

    "use strict";
    const pluginName = "OnevASSISTANT";
    const parameters = PluginManager.parameters(pluginName);
    const disablePointer = parameters["disablePointer"] === "true";
    const moveSwitchId = Number(parameters["MoveSwitch"] || 10);
    const _Sprite_Destination_update = Sprite_Destination.prototype.update;
    Sprite_Destination.prototype.update = function () {
      if (disablePointer) {
        Sprite.prototype.update.call(this);
        this.visible = false;
      } else {
        _Sprite_Destination_update.call(this);
      }
    };
    const _Game_Player_executeMove = Game_Player.prototype.executeMove;
    Game_Player.prototype.executeMove = function (direction) {
      if (!$gameSwitches.value(moveSwitchId)) {
        _Game_Player_executeMove.call(this, direction);
      }
    };
  })();

  (() => {
    //=============================================================================
    // 複数会話ウィンドウ
    //=============================================================================
    "use strict";
    const pluginName = "OnevASSISTANT";
    const CHARS_PER_FRAME = 1; // 1フレームに出す文字数
    const CHAR_INTERVAL_FRAMES = 2; // 文字間隔フレーム
    const WAIT_DOT_FRAMES = 15; // \. の待機
    const WAIT_BAR_FRAMES = 60; // \| の待機
    const FAST_WHILE_PRESSED = true;

    const DEBUG = false;
    const dbg = (...a) => {
      if (DEBUG) console.log("[FreeMsg]", ...a);
    };

    const num = (s) => Number(s || 0);
    const str = (s) => (s != null ? String(s) : "");
    const bool = (s) => String(s) === "true";

    const stripQuotes = (s) => {
      const t = str(s).trim();
      if (
        (t.startsWith('"') && t.endsWith('"')) ||
        (t.startsWith("'") && t.endsWith("'"))
      ) {
        return t.substring(1, t.length - 1);
      }
      return t;
    };

    const preprocessText = (s) => {
      let r = String(s ?? "");
      const PH = "\uE000__KEEP_N__";
      r = r.replace(/\\\\n/g, PH);
      r = r.replace(/\\\\/g, "\\");
      r = r.replace(/\\n/g, "\n");
      while (r.indexOf(PH) >= 0) r = r.replace(PH, "\\n");
      return r;
    };

    const getPadding = (win) =>
      typeof win.padding === "function"
        ? win.padding()
        : Number(win.padding || 0);

    const setPadding = (win, value) => {
      if (value < 0) return;
      if (typeof win.padding === "function") {
        win._paddingCustom = value;
        win.padding = function () {
          return this._paddingCustom;
        };
      } else {
        win.padding = value;
      }
      if (typeof win.updatePadding === "function") win.updatePadding();
    };

    const parseArgs = (args) => ({
      id: num(args.id) || 1,
      text: stripQuotes(args.text),
      x: num(args.x),
      y: num(args.y),
      anchorX: args.anchorX || "left",
      background: args.background || "window",
      backgroundImage: str(args.backgroundImage),
      opacity: Math.min(255, Math.max(0, num(args.opacity) || 255)),
      backOpacity: Math.min(255, Math.max(0, num(args.backOpacity) || 192)),
      padding: num(args.padding),
      fontSize: num(args.fontSize),
      fontColor: str(args.fontColor),
      outlineColor: str(args.outlineColor),
      outlineWidth: num(args.outlineWidth),
      windowskin: str(args.windowskin),
      waitInput: bool(args.waitInput),
      closeOnConfirm: bool(args.closeOnConfirm),
      tailImage: str(args.tailImage),
      tailPosition: args.tailPosition || "none",
      tailOffsetX: num(args.tailOffsetX),
      tailOffsetY: num(args.tailOffsetY),
    });

    const param = PluginManager.parameters(pluginName);
    function parseStructArray(json) {
      try {
        return JSON.parse(json || "[]").map((e) => JSON.parse(e));
      } catch (_) {
        return [];
      }
    }
    const _rawPresets = parseStructArray(param.Presets);
    const PresetMap = new Map();
    for (const p of _rawPresets) {
      if (!p || !p.name) continue;
      const opt = {
        x: num(p.x),
        y: num(p.y),
        anchorX: p.anchorX || "left",
        background: p.background || "window",
        backgroundImage: str(p.backgroundImage),
        opacity: Math.min(255, Math.max(0, num(p.opacity) || 255)),
        backOpacity: Math.min(255, Math.max(0, num(p.backOpacity) || 192)),
        padding: num(p.padding),
        fontSize: num(p.fontSize),
        fontColor: str(p.fontColor),
        outlineColor: str(p.outlineColor),
        outlineWidth: num(p.outlineWidth),
        windowskin: str(p.windowskin),
        tailImage: str(p.tailImage),
        tailPosition: p.tailPosition || "none",
        tailOffsetX: num(p.tailOffsetX),
        tailOffsetY: num(p.tailOffsetY),
      };
      PresetMap.set(String(p.name), opt);
    }

    const FreeMsg = {
      _windows: new Map(),
      _waiters: new Map(),

      show(opt, interpreter) {
        const id = opt.id || 1;
        let win = this._windows.get(id);
        const rect = new Rectangle(opt.x, opt.y, 24, 24);

        if (!win) {
          win = new Window_FreeMessage(rect, opt);
          win._freeMsgId = id;
          this._windows.set(id, win);
          this.addToScene(win);
        } else {
          win.applyOptions(opt);
          win.setText(opt.text);
          win.visible = true;
          win.open();
        }

        win._waitForInput = !!opt.waitInput;
        win._closeOnConfirm = !!opt.closeOnConfirm;

        if (opt.waitInput && interpreter) {
          this._waiters.set(interpreter, {
            id,
            resolved: false,
            closeOnConfirm: !!opt.closeOnConfirm,
          });
          interpreter.setWaitMode("freeMessage");
        }

        win.setupTail?.();
      },

      addToScene(win) {
        const scene = SceneManager._scene;
        if (scene && typeof scene.addWindow === "function")
          scene.addWindow(win);
      },

      resolveByWindow(id) {
        for (const [interp, w] of this._waiters) {
          if (w.id === id) {
            w.resolved = true;
            if (w.closeOnConfirm) this.close(id);
          }
        }
      },

      setText(id, text, waitInput, closeOnConfirm, interpreter) {
        const win = this._windows.get(id);
        if (!win) return;
        win.setText(text);
        if (typeof waitInput === "boolean") win._waitForInput = waitInput;
        if (typeof closeOnConfirm === "boolean")
          win._closeOnConfirm = closeOnConfirm;
        if (waitInput && interpreter) {
          this._waiters.set(interpreter, {
            id,
            resolved: false,
            closeOnConfirm: !!closeOnConfirm,
          });
          interpreter.setWaitMode("freeMessage");
        }
      },

      close(id) {
        if (id === -1) {
          for (const [i, w] of this._windows) {
            w._autoDestroy = true;
            w.close();
          }
          return;
        }
        const win = this._windows.get(id);
        if (win) {
          win._autoDestroy = true;
          win.close();
        }
      },

      erase(id) {
        this.close(id);
      },

      _destroyWindow(id) {
        const win = this._windows.get(id);
        if (!win) return;
        win._destroyTail?.();
        win.parent?.removeChild(win);
        try {
          win.destroy?.({ children: true });
        } catch (_e) {
          try {
            win.contents?.destroy?.();
          } catch (__) {}
        }
        this._windows.delete(id);
        dbg("destroy", { id });
      },
    };

    class Window_FreeMessage extends Window_Base {
      _isOutlineOff(v) {
        const t = (v ?? "").toString().trim();
        return !t || /^(transparent|none|off|0)$/i.test(t);
      }
      _resolveColor(v) {
        const t = (v ?? "").toString().trim();
        if (!t) return null;
        if (/^\d+$/.test(t)) return ColorManager.textColor(Number(t));
        return t;
      }

      resetFontSettings() {
        Window_Base.prototype.resetFontSettings.call(this);
        const size = Number(this._options?.fontSize || 0);
        if (size > 0) this.contents.fontSize = size;

        const baseColor = this._resolveColor(this._options?.fontColor);
        if (baseColor) this.changeTextColor(baseColor);

        const olRaw = this._options?.outlineColor;
        if (this._isOutlineOff(olRaw)) {
          this.contents.outlineWidth = 0;
          this.contents.outlineColor = "rgba(0,0,0,0)";
        } else {
          const ol = this._resolveColor(olRaw);
          if (ol) this.contents.outlineColor = ol;
        }
        const ow = Number(this._options?.outlineWidth);
        if (!isNaN(ow) && ow >= 0) this.contents.outlineWidth = ow;
      }
      resetTextColor() {
        Window_Base.prototype.resetTextColor.call(this);
        const baseColor = this._resolveColor(this._options?.fontColor);
        if (baseColor) this.changeTextColor(baseColor);
      }

      initialize(rect, options) {
        super.initialize(rect);
        this._options = options;
        this._baseX = options.x;
        this._baseY = options.y;
        this.openness = 255;
        this._backgroundSprite = null;
        this.applyOptions(options);
        this.setText(options.text);
        this._waitForInput = !!options.waitInput;
        this._closeOnConfirm = !!options.closeOnConfirm;
        this._autoDestroy = false;
        this._tailSprite = null;
      }

      applyOptions(opt) {
        this._options = Object.assign(this._options || {}, opt);
        this._baseX = opt.x;
        this._baseY = opt.y;
        if (opt.background === "image" && opt.backgroundImage) {
          this._setupBackgroundImage(opt.backgroundImage);
          this.opacity = 0;
          this.backOpacity = 0;
        } else {
          this._destroyBackgroundImage();
          this.opacity = opt.background === "transparent" ? 0 : opt.opacity;
          this.backOpacity =
            opt.background === "transparent" ? 0 : opt.backOpacity;
        }

        if (opt.padding >= 0) setPadding(this, opt.padding);
        this.resetFontSettings();
        if (opt.windowskin)
          this.windowskin = ImageManager.loadSystem(opt.windowskin);
      }

      setText(text) {
        this._textRaw = stripQuotes(text || "");
        this._textConverted = this.convertEscapeCharacters(
          preprocessText(this._textRaw)
        );

        this.resizeForText();
        this.resetFontSettings();
        this.contents.clear();
        this._waitCount = 0;
        this._pauseInput = false;
        this._finished = false;
        this._charsPerFrame = CHARS_PER_FRAME;
        this._instantMode = false;
        this._confirmReady = false;
        this._charWait = 0;
        this._fastGuard = 10;

        this._textState = this.createTextState(
          this._textConverted,
          0,
          0,
          this.innerWidth
        );
        this._textState.drawing = true;
      }

      appendText(text) {
        this._textRaw = (this._textRaw || "") + stripQuotes(text || "");
        this._textConverted = this.convertEscapeCharacters(
          preprocessText(this._textRaw)
        );
        this.setText(this._textRaw);
      }

      _tailBitmap() {
        const name = (this._options?.tailImage || "").trim();
        if (!name) return null;
        return ImageManager.loadSystem(name);
      }
      _tailAnchor(pos) {
        switch (pos || "none") {
          case "lt":
            return [0, 0];
          case "ct":
            return [0.5, 0];
          case "rt":
            return [1, 0];
          case "lb":
            return [0, 1];
          case "cb":
            return [0.5, 1];
          case "rb":
            return [1, 1];
          default:
            return [0.5, 1];
        }
      }
      _tailAnchorPoint(pos) {
        const x = this.x,
          y = this.y,
          w = this.width,
          h = this.height;
        switch (pos || "none") {
          case "lt":
            return [x, y];
          case "ct":
            return [x + w / 2, y];
          case "rt":
            return [x + w, y];
          case "lb":
            return [x, y + h];
          case "cb":
            return [x + w / 2, y + h];
          case "rb":
            return [x + w, y + h];
          default:
            return [x + w / 2, y + h];
        }
      }
      setupTail() {
        this._destroyTail();
        const pos = this._options?.tailPosition || "none";
        const name = (this._options?.tailImage || "").trim();
        if (pos === "none" || !name) return;
        const bmp = this._tailBitmap();
        if (!bmp) return;

        const sp = new Sprite(bmp);
        const [ax, ay] = this._tailAnchor(pos);
        sp.anchor.set(ax, ay);
        sp.alpha = this.openness === 255 ? 1 : 0;
        sp.visible = this.visible;
        this._tailSprite = sp;

        const p = this.parent ?? SceneManager._scene;
        p?.addChild(sp);
        this._updateTailPosition(true);
      }
      _destroyTail() {
        if (this._tailSprite) {
          this._tailSprite.parent?.removeChild(this._tailSprite);
          try {
            this._tailSprite.destroy();
          } catch (_) {}
          this._tailSprite = null;
        }
      }

      _setupBackgroundImage(imageName) {
        this._destroyBackgroundImage();
        if (!imageName) return;

        const bitmap = ImageManager.loadPicture(imageName);
        this._backgroundSprite = new Sprite(bitmap);
        this._backgroundSprite.anchor.set(0, 0);
        this.addChildAt(this._backgroundSprite, 0);

        bitmap.addLoadListener(() => {
          this._updateBackgroundImage();
        });
      }
      _destroyBackgroundImage() {
        if (this._backgroundSprite) {
          this.removeChild(this._backgroundSprite);
          try {
            this._backgroundSprite.destroy();
          } catch (_) {}
          this._backgroundSprite = null;
        }
      }
      _updateBackgroundImage() {
        if (!this._backgroundSprite || !this._backgroundSprite.bitmap) return;
        const bgBitmap = this._backgroundSprite.bitmap;
        if (bgBitmap.isReady()) {
          this._backgroundSprite.scale.x = this.width / bgBitmap.width;
          this._backgroundSprite.scale.y = this.height / bgBitmap.height;
          this._backgroundSprite.x = 0;
          this._backgroundSprite.y = 0;
        }
      }

      _updateTailPosition(force = false) {
        const sp = this._tailSprite;
        if (!sp) return;
        const pos = this._options?.tailPosition || "none";
        const [bx, by] = this._tailAnchorPoint(pos);
        const ox = Number(this._options?.tailOffsetX || 0);
        const oy = Number(this._options?.tailOffsetY || 0);
        const nx = Math.round(bx + ox);
        const ny = Math.round(by + oy);
        if (force || sp.x !== nx || sp.y !== ny) {
          sp.x = nx;
          sp.y = ny;
        }
        sp.alpha = this.openness === 255 ? 1 : 0;
        sp.visible = this.visible;
      }

      _processOnePrintable(textState) {
        if (!textState || !textState.text) return 0;
        if (textState.index >= textState.text.length) return 0;
        for (;;) {
          if (textState.index >= textState.text.length) return 0;

          const prevX = textState.x;
          const prevY = textState.y;
          const prevIndex = textState.index;
          const prevWait = this._waitCount;
          const prevPause = this._pauseInput;
          this.processCharacter(textState);
          if (this._waitCount > prevWait || (!prevPause && this._pauseInput)) {
            return 0;
          }

          const movedX = textState.x !== prevX;
          const movedY = textState.y !== prevY;
          const advanced = textState.index > prevIndex;

          if (advanced && movedX) {
            return 1;
          }
        }
      }

      update() {
        super.update();
        this._updateTailPosition();
        if (this._fastGuard > 0) this._fastGuard--;
        if (!this.isOpen()) {
          if (this._autoDestroy && this.openness === 0) {
            FreeMsg._destroyWindow(this._freeMsgId);
          }
          return;
        }

        if (this._finished && this._waitForInput) {
          if (!this._confirmReady) {
            this._confirmReady = true;
            return;
          }
          const triggered =
            Input.isTriggered("ok") ||
            Input.isTriggered("cancel") ||
            TouchInput.isTriggered();
          if (triggered) {
            FreeMsg.resolveByWindow(this._freeMsgId);
            if (this._closeOnConfirm) FreeMsg.close(this._freeMsgId);
          }
          return;
        }

        const fastPressed =
          FAST_WHILE_PRESSED &&
          this._fastGuard <= 0 &&
          (Input.isPressed("ok") ||
            Input.isPressed("shift") ||
            TouchInput.isPressed());
        const skipTriggered =
          Input.isTriggered("ok") ||
          TouchInput.isTriggered() ||
          Input.isTriggered("cancel");

        if (skipTriggered) {
          this._waitCount = 0;
          this._pauseInput = false;
          this._charWait = 0;
        }
        if (this._pauseInput) {
          if (!skipTriggered) return;
          this._pauseInput = false;
        }
        if (this._waitCount > 0) {
          this._waitCount--;
          return;
        }

        const slowMode = !fastPressed && !this._instantMode;
        if (slowMode && this._charWait > 0) {
          this._charWait--;
          return;
        }

        const target =
          fastPressed || this._instantMode ? 9999 : this._charsPerFrame;
        let printed = 0;

        while (this._textState && printed < target) {
          if (
            !this._textState.text ||
            this._textState.index >= this._textState.text.length
          )
            break;
          const gained = this._processOnePrintable(this._textState);
          printed += gained;
          if (!this._textState || this._pauseInput || this._waitCount > 0)
            break;
          if (slowMode && gained > 0) break;
        }

        if (slowMode && printed > 0)
          this._charWait = Math.max(0, CHAR_INTERVAL_FRAMES);

        if (
          this._textState &&
          this._textState.text &&
          this._textState.index >= this._textState.text.length
        ) {
          this._textState = null;
          this._finished = true;
          this.finalRedraw();
        }
      }

      finalRedraw() {
        const fullText =
          this._textConverted ??
          this.convertEscapeCharacters(preprocessText(this._textRaw || ""));
        this.contents.clear();
        this.resetFontSettings();
        this.drawTextEx(fullText, 0, 0, this.innerWidth);
      }

      processEscapeCharacter(code, textState) {
        switch (code) {
          case ".":
            if (textState.drawing) this._waitCount = WAIT_DOT_FRAMES;
            return;
          case "|":
            if (textState.drawing) this._waitCount = WAIT_BAR_FRAMES;
            return;
          case "!":
            if (textState.drawing) this._pauseInput = true;
            return;
          case ">":
            if (textState.drawing) this._instantMode = true;
            return;
          case "<":
            if (textState.drawing) this._instantMode = false;
            return;
          case "n":
            this.processNewLine(textState);
            return;
          case "OW": {
            const p = this.obtainEscapeParam(textState);
            if (textState.drawing && p != null)
              this.contents.outlineWidth = Number(p) || 0;
            return;
          }
          default:
            Window_Base.prototype.processEscapeCharacter.call(
              this,
              code,
              textState
            );
        }
      }

      resizeForText() {
        const pad = getPadding(this);
        const raw = this._textRaw || "";
        const text =
          this._textConverted ??
          this.convertEscapeCharacters(preprocessText(raw));
        const anchor = this._options?.anchorX || "left";

        this.resetFontSettings();

        const ts = this.createTextState(text, 0, 0, 0x7fffffff);
        ts.drawing = false;
        this.processAllText(ts);
        const measuredH = Math.ceil(ts.outputHeight || 0);

        const lines = text.split("\n");
        let maxW = 0;
        for (const line of lines) {
          const s = this.textSizeEx(line);
          const w = s && typeof s.width === "number" ? s.width : 0;
          if (w > maxW) maxW = w;
        }

        const width = Math.max(48, Math.ceil(maxW + pad * 2 + 4));
        const height = Math.max(24, Math.ceil(measuredH + pad * 2 + 4));

        const bx = Number(this._baseX ?? this.x);
        const by = Number(this._baseY ?? this.y);
        let nx;
        if (anchor === "center") nx = Math.round(bx - width / 2);
        else if (anchor === "right") nx = Math.round(bx - width);
        else nx = bx;
        let ny = by;

        const gw = Graphics.width,
          gh = Graphics.height;
        if (nx + width > gw) nx = Math.max(0, gw - width);
        if (ny + height > gh) ny = Math.max(0, gh - height);

        this.move(nx, ny, width, height);
        this.createContents();
        this._updateBackgroundImage();
        this._updateTailPosition(true);
      }
    }

    const _updateWaitMode = Game_Interpreter.prototype.updateWaitMode;
    Game_Interpreter.prototype.updateWaitMode = function () {
      if (this._waitMode === "freeMessage") {
        const w = FreeMsg._waiters.get(this);
        if (!w) {
          this._waitMode = "";
          return false;
        }
        if (w.resolved) {
          FreeMsg._waiters.delete(this);
          this._waitMode = "";
          return false;
        }
        return true;
      }
      return _updateWaitMode.apply(this, arguments);
    };

    PluginManager.registerCommand(pluginName, "show", function (args) {
      const opt = parseArgs(args);
      FreeMsg.show(opt, this);
    });

    PluginManager.registerCommand(pluginName, "showPreset", function (args) {
      const id = num(args.id) || 1;
      const name = stripQuotes(args.presetName || "");
      const base = PresetMap.get(name);
      const preset = base || {
        x: 0,
        y: 0,
        anchorX: "left",
        background: "window",
        backgroundImage: "",
        opacity: 255,
        backOpacity: 192,
        padding: -1,
        fontSize: 0,
        fontColor: "",
        outlineColor: "",
        outlineWidth: 4,
        windowskin: "",
        tailImage: "",
        tailPosition: "none",
        tailOffsetX: 0,
        tailOffsetY: 0,
      };
      const opt = Object.assign({}, preset, {
        id,
        text: stripQuotes(args.text || ""),
        waitInput: bool(args.waitInput),
        closeOnConfirm: bool(args.closeOnConfirm),
      });
      FreeMsg.show(opt, this);
    });

    PluginManager.registerCommand(pluginName, "setText", function (args) {
      const id = num(args.id) || 1;
      const text = str(args.text);
      const wait = bool(args.waitInput);
      const close = bool(args.closeOnConfirm);
      FreeMsg.setText(id, text, wait, close, this);
    });

    PluginManager.registerCommand(pluginName, "close", (args) => {
      const id = num(args.id) || 1;
      FreeMsg.close(id);
    });
  })();

  (() => {
    //=============================================================================
    // オノマトペ機能
    //=============================================================================
    "use strict";

    const pluginName = "OnevASSISTANT";
    const PARAMS = PluginManager.parameters(pluginName);
    const PRESETS = JSON.parse(PARAMS["Presets"] || "[]");

    if (typeof window.OnevASSISTANT === 'undefined' || typeof window.OnevASSISTANT.Easing === 'undefined') {
      console.warn('OnevASSISTANT.Easingが見つかりません。基本的なイージング関数を定義します。');
      
      window.jQueryEasing = {
        linear: function(t, b, c, d) {
          return c * t / d + b;
        },
        easeInQuad: function(t, b, c, d) {
          return c * (t /= d) * t + b;
        },
        easeOutQuad: function(t, b, c, d) {
          return -c * (t /= d) * (t - 2) + b;
        },
        easeInOutQuad: function(t, b, c, d) {
          if ((t /= d / 2) < 1) return c / 2 * t * t + b;
          return -c / 2 * ((--t) * (t - 2) - 1) + b;
        }
      };
    } else {
      window.jQueryEasing = {
        linear: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.linear(t / d);
        },
        easeInQuad: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInQuad(t / d);
        },
        easeOutQuad: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeOutQuad(t / d);
        },
        easeInOutQuad: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInOutQuad(t / d);
        },
        easeInCubic: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInCubic(t / d);
        },
        easeOutCubic: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeOutCubic(t / d);
        },
        easeInOutCubic: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInOutCubic(t / d);
        },
        easeInQuart: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInQuart(t / d);
        },
        easeOutQuart: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeOutQuart(t / d);
        },
        easeInOutQuart: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInOutQuart(t / d);
        },
        easeInQuint: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInQuint(t / d);
        },
        easeOutQuint: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeOutQuint(t / d);
        },
        easeInOutQuint: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInOutQuint(t / d);
        },
        easeInSine: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInSine(t / d);
        },
        easeOutSine: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeOutSine(t / d);
        },
        easeInOutSine: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInOutSine(t / d);
        },
        easeInExpo: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInExpo(t / d);
        },
        easeOutExpo: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeOutExpo(t / d);
        },
        easeInOutExpo: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInOutExpo(t / d);
        },
        easeInCirc: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInCirc(t / d);
        },
        easeOutCirc: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeOutCirc(t / d);
        },
        easeInOutCirc: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInOutCirc(t / d);
        },
        easeInBack: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInBack(t / d);
        },
        easeOutBack: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeOutBack(t / d);
        },
        easeInOutBack: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInOutBack(t / d);
        },
        easeInElastic: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInElastic(t / d);
        },
        easeOutElastic: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeOutElastic(t / d);
        },
        easeInOutElastic: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInOutElastic(t / d);
        },
        easeInBounce: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInBounce(t / d);
        },
        easeOutBounce: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeOutBounce(t / d);
        },
        easeInOutBounce: function(t, b, c, d) {
          return b + c * window.OnevASSISTANT.Easing.easeInOutBounce(t / d);
        }
      };
    }

    PluginManager.registerCommand(pluginName, "オノマトペ表示", (args) => {
      if ($gameTemp._onmtpManager === null) {
        $gameTemp._onmtpManager = new OnomatopoeiaManager();
      }
      
      console.log("オノマトペ表示 受信args:", args); // デバッグ用
      
      const imageName = args.image || args["画像ファイル名"] || "s_sandoll";
      const x = Number(args.x || args["X座標"] || 400);
      const y = Number(args.y || args["Y座標"] || 300);
      const duration = Number(args.duration || args["表示時間"] || 60);
      const fadeIn = Number(args.fadeIn || args["フェードイン時間"] || 10);
      const fadeOut = Number(args.fadeOut || args["フェードアウト時間"] || 10);
      const scaleStart = Number(args.scaleStart || args["開始スケール"] || 0.5);
      const scaleEnd = Number(args.scaleEnd || args["終了スケール"] || 1.2);
      const rotationStart = Number(args.rotationStart || args["開始回転角度"] || 0);
      const rotationEnd = Number(args.rotationEnd || args["終了回転角度"] || 0);
      const easing = args.easing || args["イージングタイプ"] || "easeOutQuad";
      
      const param = {
        name: imageName,
        startX: x,
        startY: y,
        targetX: x,
        targetY: y - 100,
        startScale: Math.round(scaleStart * 100),
        targetScale: Math.round(scaleEnd * 100),
        startOpacity: 0,
        targetOpacity: 255,
        duration: duration,
        loops: 1,
        easingType: easing,
        easingOpacityType: "linear",
        rndX: 0,
        rndY: 0,
        rndOnLoop: "false",
        fadeIn: fadeIn,
        fadeOut: fadeOut,
        rotationStart: rotationStart,
        rotationEnd: rotationEnd
      };
      
      
      const onomatopoeia = new Sprite_Onomatopoeia(param);
      onomatopoeia.startEase();
      SceneManager._scene.addChild(onomatopoeia);
      
      if ($gameTemp._onmtpManager._storeData["custom"] === undefined) {
        $gameTemp._onmtpManager._storeData["custom"] = [];
      }
      $gameTemp._onmtpManager._storeData["custom"].push(onomatopoeia);
    });

    PluginManager.registerCommand(pluginName, "プリセット呼出", (args) => {
      const presetNum = parseInt(args.presetNumber || "1") - 1;
      if (PRESETS.length > presetNum) {
        if ($gameTemp._onmtpManager === null) {
          $gameTemp._onmtpManager = new OnomatopoeiaManager();
        }
        $gameTemp._onmtpManager.add(presetNum);
      }
    });

    PluginManager.registerCommand(pluginName, "オノマトペ削除", (args) => {
      if ($gameTemp._onmtpManager === null) {
        $gameTemp._onmtpManager = new OnomatopoeiaManager();
      }
      
      const target = args.target || "all";
      if (target === "all") {
        var currentScene = SceneManager._scene;
        Object.keys($gameTemp._onmtpManager._storeData).forEach((key) => {
          $gameTemp._onmtpManager._storeData[key].forEach((data) => {
            currentScene.removeChild(data);
          });
        });
        $gameTemp._onmtpManager._storeData = {};
      } else if (target === "preset") {
        const presetNum = parseInt(args.presetNumber || "1") - 1;
        if (PRESETS.length > presetNum) {
          $gameTemp._onmtpManager.removePreset(presetNum);
        }
      } else if (target === "custom") {
        if ($gameTemp._onmtpManager._storeData["custom"]) {
          var currentScene = SceneManager._scene;
          $gameTemp._onmtpManager._storeData["custom"].forEach((data) => {
            currentScene.removeChild(data);
          });
          delete $gameTemp._onmtpManager._storeData["custom"];
        }
      }
    });

    PluginManager.registerCommand(pluginName, "オノマトペ表示", (args) => {
      if ($gameTemp._onmtpManager === null) {
        $gameTemp._onmtpManager = new OnomatopoeiaManager();
      }
      
      
      const param = {
        name: args.image || "s_sandoll",
        startX: Number(args.startX || 400),
        startY: Number(args.startY || 300),
        targetX: Number(args.targetX || 400),
        targetY: Number(args.targetY || 200),
        startScale: Number(args.startScale || 100),
        targetScale: Number(args.targetScale || 150),
        startOpacity: Number(args.startOpacity || 255),
        targetOpacity: Number(args.targetOpacity || 0),
        duration: Number(args.duration || 60),
        loops: Number(args.loops || 0),
        rndX: Number(args.rndX || 0),
        rndY: Number(args.rndY || 0),
        rndOnLoop: String(args.rndOnLoop || "false"),
        easingType: args.easingType || "linear",
        easingOpacityType: args.easingOpacityType || "linear"
      };
        
      const onomatopoeia = new Sprite_Onomatopoeia(param);
      onomatopoeia.startEase();
      SceneManager._scene.addChild(onomatopoeia);
      
      if ($gameTemp._onmtpManager._storeData["custom"] === undefined) {
        $gameTemp._onmtpManager._storeData["custom"] = [];
      }
      $gameTemp._onmtpManager._storeData["custom"].push(onomatopoeia);
    });

    PluginManager.registerCommand(pluginName, "プリセット呼出", (args) => {
      const presetNum = parseInt(args.presetNumber || "1") - 1;
      if (PRESETS.length > presetNum) {
        if ($gameTemp._onmtpManager === null) {
          $gameTemp._onmtpManager = new OnomatopoeiaManager();
        }
        $gameTemp._onmtpManager.add(presetNum);
      }
    });

    PluginManager.registerCommand(pluginName, "オノマトペ削除", (args) => {
      if ($gameTemp._onmtpManager === null) {
        $gameTemp._onmtpManager = new OnomatopoeiaManager();
      }
      
      const all = args.all !== "false";
      if (all) {
        var currentScene = SceneManager._scene;
        Object.keys($gameTemp._onmtpManager._storeData).forEach((key) => {
          $gameTemp._onmtpManager._storeData[key].forEach((data) => {
            currentScene.removeChild(data);
          });
        });
        $gameTemp._onmtpManager._storeData = {};
      } else {
        if ($gameTemp._onmtpManager._storeData["custom"] && $gameTemp._onmtpManager._storeData["custom"].length > 0) {
          var currentScene = SceneManager._scene;
          var lastItem = $gameTemp._onmtpManager._storeData["custom"].pop();
          currentScene.removeChild(lastItem);
        }
      }
    });

    const _Game_Interpreter_pluginCommand =
      Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args) {
      _Game_Interpreter_pluginCommand.apply(this, arguments);

      if (args.length < 1) {
        return;
      }

      var option = "start";
      if (args.length >= 2) {
        option = args[1].toLowerCase();
      }

      var cmd = command.toLowerCase();
      if (cmd === "omtp") {
        if ($gameTemp._onmtpManager === null) {
          $gameTemp._onmtpManager = new OnomatopoeiaManager();
        }
        switch (option) {
          case "start":
            var presetNum = parseInt(args[0]) - 1;
            if (PRESETS.length > presetNum) {
              $gameTemp._onmtpManager.add(presetNum);
            }
            break;
          case "delete":
            var presetNum = parseInt(args[0]) - 1;
            if (PRESETS.length > presetNum) {
              $gameTemp._onmtpManager.removePreset(presetNum);
            }
            break;
        }
      }
    };

    const _Game_Map_setup = Game_Map.prototype.setup;
    Game_Map.prototype.setup = function (mapId) {
      _Game_Map_setup.call(this, mapId);
      if ($gameTemp._onmtpManager === null) {
        $gameTemp._onmtpManager = new OnomatopoeiaManager();
      }
      $gameTemp._onmtpManager._mapId = -1;
    };

    const _Game_Temp_initialize = Game_Temp.prototype.initialize;
    Game_Temp.prototype.initialize = function () {
      _Game_Temp_initialize.call(this);
      this._onmtpManager = null;
    };

    const _Scene_Base_isReady = Scene_Base.prototype.isReady;
    Scene_Base.prototype.isReady = function () {
      if ($gameTemp !== null) {
        if ($gameTemp._onmtpManager !== null) {
          $gameTemp._onmtpManager.restore();
        }
      }
      return _Scene_Base_isReady.call(this);
    };

    class Sprite_Onomatopoeia extends Sprite {
      constructor(param, time = 0, loopTime = 0, rndPosition = { x: 0, y: 0 }) {
        super();

        this.visible = false;
        this.z = 10;
        this.anchor.set(0.5, 0.5);
        this._param = param;
        this._startPosition = {
          x: Number(param.startX),
          y: Number(param.startY),
        };
        this._targetPosition = {
          x: Number(param.targetX),
          y: Number(param.targetY),
        };
        this._startScale = {
          x: Number(param.startScale) / 100.0,
          y: Number(param.startScale) / 100.0,
        };
        this._targetScale = {
          x: Number(param.targetScale) / 100,
          y: Number(param.targetScale) / 100,
        };
        this._baseScale = Number(param.baseScale || param.startScale || 100) / 100.0;
        this._maxScale = Number(param.maxScale || 200) / 100.0;
        this._minScale = Number(param.minScale || 50) / 100.0;
        this._rndPosition = {
          x: (Math.random() * 100 * Number(param.rndX || 0)) / 100,
          y: (Math.random() * 100 * Number(param.rndY || 0)) / 100,
        };
        
        this._targetRndPosition = {
          x: (Math.random() * 100 * Number(param.targetRndX || 0)) / 100,
          y: (Math.random() * 100 * Number(param.targetRndY || 0)) / 100,
        };
        
        this._startOpacity = Number(param.startOpacity);
        this._targetOpacity = Number(param.targetOpacity);
        this.bitmap = ImageManager.loadPicture(param.name || "s_sandoll");
        this._duration = 0;
        this._time = time;
        this._loopTime = loopTime;
        this._waitTime = 0; 
        this._isWaiting = false; 
      }

      update() {

        if (this._isWaiting) {
          this._waitTime++;
          const loopWait = Number(this._param.loopWait || 0);
          if (this._waitTime >= loopWait) {
            this._isWaiting = false;
            this._waitTime = 0;
            this.startEase(false);
          }
          return; 
        }
        
        if (this._time < this._duration) {
          this._time++;
          this.x = this.updateEasing(this._easingX);
          this.y = this.updateEasing(this._easingY);
          var scaleTemp = this.updateScaleEasing(this._easingScale);
          this.scale.set(scaleTemp, scaleTemp);
          this.opacity = this.updateEasing(this._easingOpacity);
          if (this._time >= this._duration) {
            this._loopTime++;
            this._duration = 0;
            this._time = 0;
            this.endEase();
          }
        }
      }

      updateEasing(easing) {
        if (jQueryEasing[easing.f]) {
          return jQueryEasing[easing.f](
            this._time,
            easing.b,
            easing.c,
            this._duration
          );
        } else {
          return jQueryEasing.linear(
            this._time,
            easing.b,
            easing.c,
            this._duration
          );
        }
      }

      updateScaleEasing(easing) {
        const easingType = easing.f;
        let result;
        
        if ((easingType.includes('Back') || easingType.includes('Elastic') || easingType.includes('Bounce')) 
            && easing.c === 0) {
          const progress = this._time / this._duration;
          const tempB = easing.base;
          const tempC = easing.max - easing.base;
          
          if (jQueryEasing[easingType]) {
            result = jQueryEasing[easingType](this._time, tempB, tempC, this._duration);
          } else {
            result = jQueryEasing.linear(this._time, tempB, tempC, this._duration);
          }
          
          if (progress > 0.5) {
            const returnProgress = (progress - 0.5) * 2;
            const targetValue = easing.b + easing.c; 
            result = result + (targetValue - result) * returnProgress;
          }
        } else {
          if (jQueryEasing[easing.f]) {
            result = jQueryEasing[easing.f](
              this._time,
              easing.b,
              easing.c,
              this._duration
            );
          } else {
            result = jQueryEasing.linear(
              this._time,
              easing.b,
              easing.c,
              this._duration
            );
          }
        }

        if (easingType.includes('Back') || easingType.includes('Elastic') || easingType.includes('Bounce')) {
          result = Math.max(easing.min, Math.min(easing.max, result));
        } else {
          const minBound = Math.min(easing.b, easing.b + easing.c);
          const maxBound = Math.max(easing.b, easing.b + easing.c);
          result = Math.max(minBound, Math.min(maxBound, result));
        }
        return result;
      }

      startEase(resetFlg = true) {
        if (resetFlg) {
          this._loopTime = 0;
        }
        if (this._param.rndOnLoop === "true") {
          this._rndPosition = {
            x: (Math.random() * 100 * Number(this._param.rndX)) / 100,
            y: (Math.random() * 100 * Number(this._param.rndY)) / 100,
          };
          this._targetRndPosition = {
            x: (Math.random() * 100 * Number(this._param.targetRndX || 0)) / 100,
            y: (Math.random() * 100 * Number(this._param.targetRndY || 0)) / 100,
          };
        }
        this.visible = true;
        this._duration = this._param.duration;
        this.x = this._startPosition.x + this._rndPosition.x;
        this.y = this._startPosition.y + this._rndPosition.y;
        this.scale.set(this._startScale.x, this._startScale.y);
        this.opacity = this._startOpacity;
        
        const finalTargetX = this._targetPosition.x + this._targetRndPosition.x;
        const finalTargetY = this._targetPosition.y + this._targetRndPosition.y;
        
        this._easingX = {
          f: this._param.easingType,
          b: this.x,
          c: finalTargetX - this.x,
        };
        this._easingY = {
          f: this._param.easingType,
          b: this.y,
          c: finalTargetY - this.y,
        };
        this._easingScale = {
          f: this._param.easingScaleType || this._param.easingType,
          b: this.scale.x,
          c: this._targetScale.x - this.scale.x,
          base: this._baseScale,
          max: this._maxScale,
          min: this._minScale
        };

        this._easingOpacity = {
          f: this._param.easingOpacityType,
          b: this.opacity,
          c: this._targetOpacity - this.opacity,
        };
      }

      endEase() {
        if (this._loopTime < this._param.loops || this._param.loops == 0) {
          this._loopTime++;
          const loopWait = Number(this._param.loopWait || 0);
          if (loopWait > 0) {
            this._isWaiting = true;
            this._waitTime = 0;
          } else {
            this.startEase(false);
          }
        } else {
          this.visible = false;

          if (this._customId && $gameTemp._onmtpManager) {
            $gameTemp._onmtpManager.removeById(this._customId);
          } else {
            $gameTemp._onmtpManager.remove(this);
          }
        }
      }
    }

    class Sprite_OnomatopoeiaSheet extends Sprite_Onomatopoeia {
      constructor(param) {
        super(param);
        const sheet = param.sheetSettings || {};
        this._sheet = {
          cols: Number(sheet.frameCols || 3),
          rows: Number(sheet.frameRows || 1),
          start: Number(sheet.startIndex || 0),
          end: Number(sheet.endIndex || 0),
          interval: Number(sheet.interval || 6),
          loop: sheet.loopSheet !== undefined ? sheet.loopSheet === true || sheet.loopSheet === "true" : true,
          pingPong: sheet.pingPong === true || sheet.pingPong === "true",
        };
        this._frameIndex = this._sheet.start;
        this._frameTicker = 0;

        this.bitmap = ImageManager.loadPicture(param.name || "s_sandoll");
        this.bitmap.addLoadListener(() => {
          this._frameWidth = Math.floor(this.bitmap.width / this._sheet.cols);
          this._frameHeight = Math.floor(this.bitmap.height / this._sheet.rows);
          this._updateFrameRect();
        });
      }

      _updateFrameRect() {
        const cols = this._sheet.cols;
        const w = this._frameWidth || 0;
        const h = this._frameHeight || 0;
        const idx = Math.max(0, this._frameIndex);
        const xIndex = idx % cols;
        const yIndex = Math.floor(idx / cols);
        this.setFrame(xIndex * w, yIndex * h, w, h);
      }

      update() {
        super.update();
        if (!this.visible || this._isWaiting) return;
        if (!this.bitmap || !this.bitmap.isReady()) return;

        this._frameTicker++;
        if (this._frameTicker >= this._sheet.interval) {
          this._frameTicker = 0;
          this._advanceFrame();
          this._updateFrameRect();
        }
      }

      _advanceFrame() {
        const s = this._sheet;
        const dirKey = "_sheetDir";
        if (s.pingPong) {
          if (this[dirKey] === undefined) this[dirKey] = 1;
          this._frameIndex += this[dirKey];
          if (this._frameIndex >= s.end) {
            this._frameIndex = s.end;
            this[dirKey] = -1;
          } else if (this._frameIndex <= s.start) {
            this._frameIndex = s.start;
            this[dirKey] = 1;
          }
        } else {
          this._frameIndex++;
          const last = s.end;
          if (this._frameIndex > last) {
            if (s.loop) {
              this._frameIndex = s.start;
            } else {
              this._frameIndex = last; 
            }
          }
        }
      }
    }

    class OnomatopoeiaManager {
      constructor() {
        this._mapId = -1;
        this._storeData = {};
        this._idCounter = 0; 
        this._sprites = new Map(); 
      }

      addWithId(param, id = null) {
        const scene = SceneManager._scene;
        
        if (!id || id.trim() === "") {
          id = `auto_${Date.now()}_${this._idCounter++}`;
        }

        if (this._sprites.has(id)) {
          this.removeById(id);
        }
        
        const randomSeed = Math.random() * 1000;
        const onomatopoeia = new Sprite_Onomatopoeia(param);
        onomatopoeia._customId = id; 
        onomatopoeia.startEase();
        scene.addChild(onomatopoeia);
        this._sprites.set(id, onomatopoeia);
        
        if (this._storeData["custom"] === undefined) {
          this._storeData["custom"] = [];
        }
        this._storeData["custom"].push(onomatopoeia);
        
        return id;
      }

      removeById(id) {
        if (!this._sprites.has(id)) {
          console.log(`オノマトペ ID ${id} が見つかりません`);
          return false;
        }
        
        const sprite = this._sprites.get(id);
        const scene = SceneManager._scene;
        scene.removeChild(sprite);
        this._sprites.delete(id);
        if (this._storeData["custom"]) {
          const index = this._storeData["custom"].indexOf(sprite);
          if (index >= 0) {
            this._storeData["custom"].splice(index, 1);
          }
        }
        return true;
      }

      removeAll() {
        const scene = SceneManager._scene;
        this._sprites.forEach((sprite, id) => {
          scene.removeChild(sprite);
        });
        this._sprites.clear();
        Object.keys(this._storeData).forEach((key) => {
          if (this._storeData[key]) {
            this._storeData[key].forEach((sprite) => {
              scene.removeChild(sprite);
            });
          }
        });
        this._storeData = {};
      }

      addSheetWithId(param, id = null) {
        const scene = SceneManager._scene;
        if (!id || id.trim() === "") {
          id = `auto_${Date.now()}_${this._idCounter++}`;
        }
        if (this._sprites.has(id)) {
          this.removeById(id);
        }
        const spr = new Sprite_OnomatopoeiaSheet(param);
        spr._customId = id;
        spr.startEase();
        scene.addChild(spr);
        this._sprites.set(id, spr);
        if (this._storeData["custom"] === undefined) this._storeData["custom"] = [];
        this._storeData["custom"].push(spr);
        return id;
      }

      add(number) {
        var scene = SceneManager._scene;
        var param = JSON.parse(PRESETS[number]);
        var onomatopoeia = new Sprite_Onomatopoeia(param);
        onomatopoeia.startEase();
        scene.addChild(onomatopoeia);

        if (this._storeData[number] === undefined) {
          this._storeData[number] = [];
        }
        this._storeData[number].push(onomatopoeia);
      }

      remove(onomatopoeia) {
        var scene = SceneManager._scene;
        scene.removeChild(onomatopoeia);
      }

      removePreset(number) {
        var currentScene = SceneManager._scene;
        Object.keys(this._storeData).forEach((key) => {
          this._storeData[key].forEach((data) => {
            currentScene.removeChild(data);
          });
        });
        delete this._storeData[number];
      }

      restore() {
        var currentScene = SceneManager._scene;
        var previousScene = SceneManager._previousClass;
        const allowedScenes = PARAMS["Scenes"] ? JSON.parse(PARAMS["Scenes"]) : ["Scene_Map"];
        if (allowedScenes.includes(previousScene.name)) {
          Object.keys(this._storeData).forEach((key) => {
            this._storeData[key].forEach((data) => {
              currentScene.addChild(data);
            });
          });
        }
      }
    }

    PluginManager.registerCommand(pluginName, "オノマトペ表示", (args) => {
      if ($gameTemp._onmtpManager === null) {
        $gameTemp._onmtpManager = new OnomatopoeiaManager();
      }
      
      const positionSettings = args.positionSettings ? JSON.parse(args.positionSettings) : {};
      const scaleSettings = args.scaleSettings ? JSON.parse(args.scaleSettings) : {};
      const opacitySettings = args.opacitySettings ? JSON.parse(args.opacitySettings) : {};
      const animationSettings = args.animationSettings ? JSON.parse(args.animationSettings) : {};
      
      const param = {
        name: args.image || "s_sandoll",
        startX: Number(positionSettings.startX || 400),
        startY: Number(positionSettings.startY || 300),
        targetX: Number(positionSettings.targetX || 400),
        targetY: Number(positionSettings.targetY || 200),
        rndX: Number(positionSettings.rndX || 0),
        rndY: Number(positionSettings.rndY || 0),
        targetRndX: Number(positionSettings.targetRndX || 0),
        targetRndY: Number(positionSettings.targetRndY || 0),
        startScale: Number(scaleSettings.startScale || 100),
        targetScale: Number(scaleSettings.targetScale || 150),
        baseScale: Number(scaleSettings.baseScale || 100),
        maxScale: Number(scaleSettings.maxScale || 200),
        minScale: Number(scaleSettings.minScale || 50),
        startOpacity: Number(opacitySettings.startOpacity || 255),
        targetOpacity: Number(opacitySettings.targetOpacity || 0),
        duration: Number(animationSettings.duration || 60),
        loops: Number(animationSettings.loops || 0),
        loopWait: Number(animationSettings.loopWait || 0),
        rndOnLoop: String(positionSettings.rndOnLoop || "false"),
        easingType: positionSettings.easingType || "linear",
        easingScaleType: scaleSettings.easingType || "linear",
        easingOpacityType: opacitySettings.easingType || "linear"
      };
      
      const assignedId = $gameTemp._onmtpManager.addWithId(param, args.id);
    });

    PluginManager.registerCommand(pluginName, "オノマトペ表示(スプライトシート)", (args) => {
      if ($gameTemp._onmtpManager === null) {
        $gameTemp._onmtpManager = new OnomatopoeiaManager();
      }
      const positionSettings = args.positionSettings ? JSON.parse(args.positionSettings) : {};
      const scaleSettings = args.scaleSettings ? JSON.parse(args.scaleSettings) : {};
      const opacitySettings = args.opacitySettings ? JSON.parse(args.opacitySettings) : {};
      const animationSettings = args.animationSettings ? JSON.parse(args.animationSettings) : {};
      const sheetSettings = args.sheetSettings ? JSON.parse(args.sheetSettings) : {};

      const param = {
        name: args.image || "s_sandoll",
        startX: Number(positionSettings.startX || 400),
        startY: Number(positionSettings.startY || 300),
        targetX: Number(positionSettings.targetX || 400),
        targetY: Number(positionSettings.targetY || 200),
        rndX: Number(positionSettings.rndX || 0),
        rndY: Number(positionSettings.rndY || 0),
        targetRndX: Number(positionSettings.targetRndX || 0),
        targetRndY: Number(positionSettings.targetRndY || 0),
        startScale: Number(scaleSettings.startScale || 100),
        targetScale: Number(scaleSettings.targetScale || 150),
        baseScale: Number(scaleSettings.baseScale || 100),
        maxScale: Number(scaleSettings.maxScale || 200),
        minScale: Number(scaleSettings.minScale || 50),
        startOpacity: Number(opacitySettings.startOpacity || 255),
        targetOpacity: Number(opacitySettings.targetOpacity || 0),
        duration: Number(animationSettings.duration || 60),
        loops: Number(animationSettings.loops || 0),
        loopWait: Number(animationSettings.loopWait || 0),
        rndOnLoop: String(positionSettings.rndOnLoop || "false"),
        easingType: positionSettings.easingType || "linear",
        easingScaleType: scaleSettings.easingType || "linear",
        easingOpacityType: opacitySettings.easingType || "linear",
        sheetSettings: {
          frameCols: Number(sheetSettings.frameCols || sheetSettings.FrameCols || 3),
          frameRows: Number(sheetSettings.frameRows || sheetSettings.FrameRows || 1),
          startIndex: Number(sheetSettings.startIndex || sheetSettings.StartIndex || 0),
          endIndex: Number(sheetSettings.endIndex || sheetSettings.EndIndex || 0),
          interval: Number(sheetSettings.interval || sheetSettings.Interval || 6),
          loopSheet: sheetSettings.loopSheet === undefined ? true : (sheetSettings.loopSheet === true || sheetSettings.loopSheet === "true"),
          pingPong: sheetSettings.pingPong === true || sheetSettings.pingPong === "true",
        },
      };

      $gameTemp._onmtpManager.addSheetWithId(param, args.id);
    });

    PluginManager.registerCommand(pluginName, "オノマトペ削除", (args) => {
      if ($gameTemp._onmtpManager === null) {
        console.log("オノマトペマネージャーが初期化されていません");
        return;
      }
      
      const id = args.id;
      
      if (!id || id.trim() === "") {
        $gameTemp._onmtpManager.removeAll();
      } else {
        $gameTemp._onmtpManager.removeById(id.trim());
      }
    });
  })();
})();
