//=============================================================================
// SetActorHome.js
// ----------------------------------------------------------------------------
// <利用規約>
//  利用はRPGツクールMV/RPGMakerMVの正規ユーザーに限られます。
//  商用、非商用、ゲームの内容を問わず利用可能です。
//  ゲームへの利用の際、報告や出典元の記載等は必須ではありません。
//  二次配布や転載は禁止します。
//  ソースコードURL、ダウンロードURLへの直接リンクも禁止します。
//  不具合対応以外のサポートやリクエストは受け付けておりません。
//  スクリプト利用により生じたいかなる問題においても、一切責任を負いかねます。
// ----------------------------------------------------------------------------
//  Ver1.00  2016/01/31  初版
//=============================================================================

/*:
 * @plugindesc サイドビューバトルでアクターを表示する位置を設定します。
 * @author こま
 *
 * @param Home X
 * @desc アクターを表示するX座標の計算式を指定してください。
 * @default 600 + index * 32
 *
 * @param Home Y
 * @desc アクターを表示するY座標の計算式を指定してください。
 * @default 280 + index * 48
 *
 * @help
 * プラグインパラメータの「Home X」と「Home Y」に、アクターを表示する座標の計算式を
 * 指定してください。式中の「index」は、何番目のアクターかによって値が決まります。
 * 先頭のアクターは0、2番目が1、という風になります。
 *
 * *このプラグインには、プラグインコマンドはありません。
 */

(function(){
    var parameters = PluginManager.parameters('SetActorHome');
    var homeX = parameters['Home X'];
    var homeY = parameters['Home Y'];

    Sprite_Actor.prototype.setActorHome = function(index) {
        this.setHome(eval(homeX), eval(homeY));
    };
}());
