---
name: SFX座標管理システム実装プラン
overview: ""
todos:
  - id: b806bc42-f658-4f34-b023-0aa8df5c8a82
    content: dataEx/bubbleAnchors.json を作成（初期構造）
    status: completed
  - id: 8ba289bd-ecde-4a36-89a3-31d91410a1e0
    content: docs/SFX_COORDINATE_MEASUREMENT_GUIDE.md を作成
    status: completed
  - id: 92b7a225-8d9e-404a-87d8-90904d1dc6fc
    content: js/plugins/BubbleCoordinateResolver.js を作成
    status: pending
---

# SFX座標管理システム実装プラン

## 設計概要

擬音ジャンル中心の座標管理システムを構築します。

### データ構造

```javascript
{
  "insert_entry": {  // 擬音ジャンル（ズプッ）
    "slime_restrained_insert": {  // 敵Type + 状態
      "pussy": {  // 部位
        "left": { "x": 200, "y": 150 },
        "right": { "x": 250, "y": 150 }
      }
    },
    "goblin_restrained_insert": { ... },
    "tentacle_restrained_insert": { ... }
  },
  "insert_piston": { ... },  // ぬちょっ
  "rub_breast": { ... },     // 胸揉み音
  "orgasm": { ... }          // 絶頂音
}
```

## Phase 1: データファイル作成

### 1.1 座標データJSON作成

- ファイル: `dataEx/bubbleAnchors.json`
- 初期構造を作成（全座標を仮値で設定）
- 擬音ジャンル一覧:
  - `insert_entry` (ズプッ)
  - `insert_piston` (ぬちょっ)
  - `insert_deep` (ズポ)
  - `rub_pussy` (膣愛撫)
  - `rub_breast` (胸揉み)
  - `orgasm` (ぐちゃ)
  - `liquid` (液体音)

### 1.2 測定ガイド作成

- ファイル: `docs/SFX_COORDINATE_MEASUREMENT_GUIDE.md`
- 画像測定手順
- 記録シート
- 座標変換方法

## Phase 2: システム実装

### 2.1 座標解決プラグイン作成

- ファイル: `js/plugins/BubbleCoordinateResolver.js`
- 機能:
  - `bubbleAnchors.json` を読み込み
  - 擬音ジャンル × 敵Type × 部位 × 左右 で座標を解決
  - フォールバック処理（データがない場合は部位デフォルト）
```javascript
window.BubbleCoordinateResolver = {
  loadAnchors: function() {
    // dataEx/bubbleAnchors.json を読み込み
  },
  
  resolve: function(sfxType, profileName, targetPart, side) {
    // 1. 擬音ジャンル → 敵Type → 部位 → 左右
    // 2. フォールバック: 部位デフォルト
    // 3. 最終フォールバック: グローバルデフォルト
  },
  
  parseSfxKey: function(key) {
    // "default_pose_overlay_ズプッ1-6_left" から
    // sfxType="insert_entry", side="left" を抽出
  }
};
```


### 2.2 VisualAutoFill.js 修正

- 場所: `js/plugins/VisualAutoFill.js` 540-588行目
- 修正内容:
  - `getBubbleOverlaysFromContext()` の戻り値を拡張
  - 文字列配列ではなく、座標情報付きオブジェクト配列を返す
```javascript
// 修正前
return [`${key}_left`, `${key}_right`];

// 修正後
return [
  { 
    key: `${key}_left`, 
    sfxType: determinedSfxType,  // "insert_entry" など
    side: "left" 
  },
  { 
    key: `${key}_right`, 
    sfxType: determinedSfxType, 
    side: "right" 
  }
];
```


### 2.3 BattleBustManager.js 修正

- 場所: `js/plugins/BattleBustManager.js` 393-424行目
- 修正内容:
  - バブル配置ロジックを拡張
  - オブジェクト形式のエントリに対応
  - `BubbleCoordinateResolver` を使用して座標を解決
```javascript
for (const entry of bubbleOverlays) {
  if (!entry) continue;

  if (typeof entry === "string") {
    // 既存の文字列形式（後方互換）
    const picName = resolveBubblePictureName(profileName, pose, entry);
    // ... 既存ロジック
  } else if (typeof entry === "object" && entry.sfxType) {
    // ★ 新形式: 座標情報付き
    const picName = resolveBubblePictureName(profileName, pose, entry.key);
    if (!picName) continue;
    
    // BubbleCoordinateResolver で座標を取得
    const coord = window.BubbleCoordinateResolver?.resolve(
      entry.sfxType,
      profileName,
      targetPart,
      entry.side
    );
    
    const finalX = coord ? coord.x : (408 + bubbleOffset.x);
    const finalY = coord ? coord.y : (32 + bubbleOffset.y);
    
    const sprite = createLayerSprite(picName, animationType, { 
      x: finalX, 
      y: finalY, 
      z: 9999,
      anchorX: 0.5,
      anchorY: 0.5 
    });
    group._bubble.addChild(sprite);
  } else if (typeof entry === "object") {
    // 既存のオブジェクト形式（後方互換）
    // ... 既存ロジック
  }
}
```


### 2.4 VisualOverlayData.js 修正

- 場所: `js/plugins/VisualOverlayData.js` 80-88行目
- 修正内容: `sfx` マッピングにコメント追加（座標は `bubbleAnchors.json` で管理）

## Phase 3: プラグイン登録

### 3.1 plugins.js 更新

- `BubbleCoordinateResolver.js` を追加
- 読み込み順序:

  1. VisualOverlayData.js
  2. BubbleCoordinateResolver.js ← 新規
  3. VisualAutoFill.js
  4. BattleBustManager.js

## Phase 4: 座標測定作業

### 4.1 測定対象

- Slime: 6パターン (restrained × pussy/breast, restrained_insert × pussy/breast, 各2種類)
- Goblin: 6パターン
- Tentacle: 6パターン
- 合計: 18パターン × 7擬音ジャンル × 2方向 = 約252座標

### 4.2 測定手順

1. `docs/SFX_COORDINATE_MEASUREMENT_GUIDE.md` に従って画像を開く
2. 擬音の中心座標を測定
3. `dataEx/bubbleAnchors.json` に記録
4. ゲームで動作確認
5. 微調整

## Phase 5: テスト・調整

### 5.1 動作確認

- 各敵タイプで戦闘開始
- 擬音が正しい位置に表示されるか確認
- Console で座標解決ログを確認

### 5.2 微調整

- `bubbleAnchors.json` の座標を調整
- ゲームをリロード（F5）して再確認

## 重要ファイル

- `dataEx/bubbleAnchors.json` - 座標データ（新規作成）
- `js/plugins/BubbleCoordinateResolver.js` - 座標解決ロジック（新規作成）
- `js/plugins/VisualAutoFill.js` - SFX選択ロジック（修正）
- `js/plugins/BattleBustManager.js` - 描画ロジック（修正）
- `docs/SFX_COORDINATE_MEASUREMENT_GUIDE.md` - 測定ガイド（新規作成）

## 拡張性

- 新しい敵を追加: `bubbleAnchors.json` に敵Typeのエントリを追加
- 新しい擬音ジャンル追加: `VisualOverlayData.js` の `sfx` に追加 + `bubbleAnchors.json` に座標追加
- 特殊な座標調整: JSON内の該当エントリを編集するだけ