# ProjectEst

RPG Maker MZ で開発中のアダルトRPGプロジェクト

## 📖 概要

拘束・快楽・堕落システムを実装した戦闘システム

## ✨ 主要機能

### 実装済み
- **拘束・エロ攻撃システム**: 敵による拘束攻撃とエロ攻撃の実装
- **挿入システム**: 抵抗判定を含む挿入イベント
- **絶頂システム**: resist/fall分岐のある絶頂イベント
- **堕落度システム**: 堕落度に応じた反応変化（low/high）
- **カスタムUI**: エロステータス画面、戦闘立ち絵表示
- **エロメモリー**: 自動解放機能付き記録システム
- **敵AIシステム**: 状況に応じたインテリジェントな行動選択
- **ピンク背景演出**: 絶頂・挿入時の雰囲気演出

### 実装済みモンスター
- ゴブリン（堕落度low/high対応）
- スライム（堕落度low/high対応）
- 触手（堕落度low/high対応）

## 🔧 技術スタック

- **エンジン**: RPG Maker MZ
- **カスタムプラグイン**: 50+個
- **JSON設定ファイル**: 100+個
- **画像アセット**: 1900+ファイル

## 📁 プロジェクト構造

```
ProjectEst/
├── js/plugins/          # カスタムプラグイン（50+個）
├── dataEx/              # JSON設定ファイル（100+個）
│   ├── poseProfiles/    # 立ち絵・表情設定
│   ├── restraintProfiles/ # 拘束時の設定
│   ├── introProfiles/   # イベント導入設定
│   ├── orgasmDetailProfiles/ # 絶頂イベント設定
│   └── flavor/          # フレーバーテキスト設定
├── img/pictures/busts/  # キャラクター立ち絵（1900+ファイル）
├── tools/               # デバッグ用スクリプト
├── data/                # ゲームデータ
└── www/                 # ビルド出力（実行ファイル）
```

## 🎮 開発環境のセットアップ

### 必要なもの
- RPG Maker MZ
- Python 3.x（デバッグツール使用時）

### セットアップ手順
1. このリポジトリをクローン
   ```bash
   git clone https://github.com/YOUR_USERNAME/ProjectEst.git
   ```

2. RPG Maker MZでプロジェクトを開く
   - `Game.rpgproject`を開く

3. デバッグツールの実行（オプション）
   ```bash
   python tools/comprehensive_debug.py
   python tools/check_all_overlays.py
   ```

## 📝 開発状況

### Phase 1: コアシステム ✅
- [x] 拘束・エロ攻撃システム
- [x] 挿入・絶頂システム
- [x] 堕落度システム
- [x] カスタムUI
- [x] 敵AIシステム
- [x] エロメモリー機能

### Phase 2: コンテンツ拡張（進行中）
- [x] 基本モンスター3種（ゴブリン、スライム、触手）
- [x] 堕落度low/high対応
- [x] 擬音オーバーレイシステム
- [ ] 追加モンスター（電撃スライム、狂人、毒スライム等）
- [ ] ストーリーイベント
- [ ] マップ実装

### Phase 3: バランス調整
- [x] 戦闘バランス（エロ攻撃優先度）
- [x] 拘束解除時の動作
- [ ] 快楽・堕落度の調整
- [ ] UI/UXの改善

## ⚠️ 注意事項

### 画像ファイルについて
- `img/pictures/busts/`以下に大量の画像ファイルがあります
- 総サイズが大きい場合はGit LFSの使用を推奨

### プライバシー/著作権
- このプロジェクトはアダルトコンテンツを含みます
- 商用利用時はRPG Maker MZのライセンスを確認してください
- 使用素材のライセンスを確認してください

## 🔨 主要プラグイン

### 戦闘システム
- `EnemyActionManager.js` - 敵AI制御（拘束/エロ/挿入攻撃の優先度管理）
- `PleasureAttackManager.js` - 快楽攻撃管理
- `RestraintEventHandler.js` - 拘束イベント処理
- `InsertEventHandler.js` - 挿入イベント処理
- `OrgasmEventHandler.js` - 絶頂イベント処理

### UI/表示
- `BattleBustManager.js` - 戦闘立ち絵管理
- `PleasureDisplayManager.js` - 演出・エフェクト（ピンク背景、擬音表示）
- `EroStatusUI.js` - エロステータス画面
- `EroMemory.js` - エロメモリー機能
- `ClothingDurabilityWindow.js` - 服装耐久度表示

### データ管理
- `PleasureActorStatus.js` - キャラクターステータス（開発度、被虐度、矜持）
- `PleasurePoseController.js` - 立ち絵・表情制御
- `PleasureDataManager.js` - データユーティリティ
- `PleasureStateManager.js` - ステート管理

## 📊 統計

- カスタムプラグイン数: **50+**
- JSON設定ファイル: **100+**
- 実装済みイベント: **300+**
- 画像ファイル: **1900+**
- コード行数: **15,000+**
- 開発期間: **2024年〜**

## 🐛 デバッグツール

プロジェクトには包括的なデバッグツールが含まれています：

```bash
# 全体的なデバッグチェック
python tools/comprehensive_debug.py

# 擬音オーバーレイの確認
python tools/check_all_overlays.py

# profileNameの確認
python tools/find_profilename_mismatches.py
```

## 🎯 技術的特徴

### カスタムイベントシステム
- JSON駆動の柔軟なイベント定義
- 堕落度・stage・部位ごとの詳細な分岐
- resist/fallの二択による物語性

### スマートな敵AI
- プレイヤーの状態に応じた行動選択
- 拘束 → エロ攻撃 → 挿入攻撃の自然な流れ
- 拘束解除時の適切な対応

### データ整合性
- 100+のJSONファイルの整合性確認システム
- 画像ファイルの存在確認
- プラグイン間の依存関係管理

## 🤝 コントリビューション

現在このプロジェクトは個人開発中です。

## 📜 ライセンス

Private - 非商用のみ

---

**Last Updated**: 2024-11-17

