# セリフシステム仕様書（AI生成用）

## 📌 このドキュメントの目的

セリフ生成AIに対して、以下を正確に伝えるための技術仕様書です：

1. 各イベントが発生する**文脈・タイミング**
2. Stage / イベントタイプ / 分岐の**構造的な関係性**
3. 出力すべき**JSON構造とキー名**
4. 各場面で期待される**感情の方向性**

**具体的なセリフ例は含みません。** 創作指示は別途提供されます。

---

## 🔢 システム変数の定義

### Stage（興奮段階）

プレイヤーキャラクターの**絶頂回数**によって決定される段階。

| Stage | 絶頂回数 | 意味 |
|-------|---------|------|
| `stage1` | 0〜1回 | 初期段階。まだ余裕がある状態 |
| `stage2` | 2〜4回 | 中期段階。追い込まれ始めている |
| `stage3` | 5回以上 | 終期段階。限界を超えている |

**重要**: Stage2以降では `resist` / `fall` の分岐が発生します。

---

### corruptionStage（堕落度）

キャラクターの**精神的な堕落の進行度**。開発度によって決定。

| corruptionStage | 意味 |
|-----------------|------|
| `low` | 純潔期。恥じらいと拒絶が中心 |
| `mid` | 動揺期。葛藤と身体反応への戸惑い |
| `high` | 屈服期。快楽への抵抗が弱まっている |

---

### eventType（イベント種別）

**現在のMP（快感ゲージ）残量**によって自動決定されるイベントの種類。

| MP残量 | eventType | 発生タイミング |
|--------|-----------|---------------|
| 100〜61% | `react` | エロ攻撃を受けた直後の反応 |
| 60〜31% | `danger` | 絶頂が近づいている危機的状態 |
| 30〜1% | `climax` | 絶頂寸前の極限状態 |
| 0% | `orgasm` | 絶頂に達した瞬間（別処理） |
| 絶頂直後 | `down_attack` | 回復中に追撃を受けた状態 |
| 攻撃なし | `standby` | 待機状態（セリフ抑制） |

---

### targetPart（攻撃部位）

エロ攻撃の対象となる身体部位。

| targetPart | 意味 |
|------------|------|
| `pussy` | 秘所（最も一般的） |
| `breast` | 胸部 |
| `anal` | 後孔 |
| `mouth` | 口 |
| `body` | 全身 |

---

### resolve（プレイヤー選択）

Stage2以降で発生する**プレイヤーの意思決定結果**。

| resolve | 意味 | 感情の方向性 |
|---------|------|-------------|
| `resist` | 抵抗を選択した | 強がり、意地、我慢 |
| `fall` | 身を委ねた | 諦め、快感への屈服、流される |

---

## ⏱️ 戦闘フロー概要

### 通常エロ攻撃の時系列

```
[ターン開始]
    │
    ▼
敵がエロスキルを使用
    │
    ▼
MP減少 → eventType が決定される
    │
    ├── MP > 60% → react（通常反応）
    ├── MP 31〜60% → danger（危機反応）
    ├── MP 1〜30% → climax（絶頂寸前）
    └── MP = 0% → orgasm → 絶頂処理へ
    │
    ▼
poseProfiles からセリフを取得・表示
    │
    ▼
[ターン終了]
```

### 絶頂イベントの時系列

```
MP が 0% に到達
    │
    ▼
プレイヤー選択画面
    │
    ├── 「耐える」→ resolve = "resist"
    └── 「身を委ねる」→ resolve = "fall"
    │
    ▼
orgasmDetailProfiles の sequence を再生
（複数行が順番に表示される）
    │
    ▼
絶頂回数 +1 → Stage が進行する可能性
    │
    ▼
aftermath（絶頂後）のセリフを表示
    │
    ▼
[次ターンでエロ攻撃を受けた場合]
    │
    ▼
eventType = "down_attack" として処理
```

### 挿入イベントの時系列

```
敵が挿入スキルを使用
    │
    ▼
挿入回数を判定
    │
    ├── 初回 → pre_first イベント
    └── 2回目以降 → pre_repeat イベント
    │
    ▼
プレイヤー選択画面
    │
    ├── 「抵抗する」を選択
    │       │
    │       ▼
    │   成功率判定
    │       │
    │       ├── 成功 → sequence_resist_success
    │       └── 失敗 → sequence_resist_fail
    │
    └── 「受け入れる」を選択
            │
            ▼
        sequence_accept
    │
    ▼
挿入状態フラグが ON になる
以降のエロ攻撃は挿入版プロファイルを参照
```

### 拘束イベントの時系列

```
敵が拘束スキルを使用
    │
    ▼
拘束回数を判定
    │
    ├── 初回 → first イベント
    └── 2回目以降 → repeat イベント
    │
    ▼
restraintProfiles からセリフを取得・表示
    │
    ▼
拘束状態フラグが ON になる
以降のエロ攻撃は拘束版プロファイルを参照
```

---

## 📊 Stage × イベントタイプ 対応表

### 必要なセリフの有無

|  | react | danger | climax | down_attack |
|--|-------|--------|--------|-------------|
| **stage1** | ✅ | ✅ | ✅ | △ |
| **stage2** | △ | ✅分岐 | ✅分岐 | ✅ |
| **stage3** | × | × | ✅分岐 | ✅分岐 |

**凡例**:
- ✅ = 必須
- ✅分岐 = resist/fall の2パターン必須
- △ = オプション（あれば使用）
- × = 不要（stage2にフォールバック）

---

## 📁 ファイル別の構造仕様

### 1. poseProfiles（通常エロ攻撃時）

#### 使用されるタイミング
- 通常のエロ攻撃を受けた時
- イベントタイプ: react / danger / climax / down_attack / standby

#### JSON構造

**Stage1（分岐なし）**:
```
lines.{eventType}.{targetPart}.{stage}.{corruptionStage}
→ 配列 [ { dialogueSequence: [...], log?: string } ]
```

**Stage2/3（分岐あり）**:
```
lines.{eventType}.{targetPart}.{stage}.{corruptionStage}.{resolve}
→ 配列 [ { dialogueSequence: [...], log?: string } ]
```

#### 各イベントの文脈

| eventType | 文脈 | 感情の方向性 |
|-----------|------|-------------|
| `react` | エロ攻撃を受けた直後 | 驚き、拒絶、不快感 |
| `danger` | 絶頂が近づいている | 焦燥、危機感、必死の抵抗または諦め |
| `climax` | 絶頂の瞬間 | 絶頂の波、理性と快感のせめぎ合い |
| `down_attack` | 絶頂直後に追撃を受けた | 余韻の中での無力感、抗議 |
| `standby` | 攻撃を受けていない | 余韻、警戒、疲労（セリフ抑制傾向） |

---

### 2. orgasmDetailProfiles（絶頂イベント時）

#### 使用されるタイミング
- MP が 0% になり、絶頂が発生した時
- プレイヤーが「耐える」「身を委ねる」を選択した後

#### JSON構造

```
sequence.{stage}.{corruptionStage}
→ 配列 [ { dialogue: string, expression?: string } ]

after_resist.{stage}.{corruptionStage}
→ 配列 [ { dialogue: string, expression?: string } ]

after_fall.{stage}.{corruptionStage}
→ 配列 [ { dialogue: string, expression?: string } ]
```

#### 各セクションの文脈

| セクション | 文脈 | 感情の方向性 |
|-----------|------|-------------|
| `sequence` | 絶頂に至るまでの過程 | 高まり、限界、爆発。段階的なエスカレート |
| `after_resist` | 絶頂後（抵抗を選んだ場合） | 荒い呼吸、まだ意地を保つ、または崩れかける |
| `after_fall` | 絶頂後（身を委ねた場合） | 虚脱、快感の余韻、理性の弛緩 |

---

### 3. introProfiles（挿入イベント時）

#### 使用されるタイミング
- 敵が挿入スキルを使用した時
- 拘束状態でのみ発生

#### JSON構造

```
insert.{stage}.{corruptionStage}.{eventType}
→ 配列 [ { dialogueSequence: [...] } ]
```

#### 各イベントの文脈

| eventType | 文脈 | 感情の方向性 |
|-----------|------|-------------|
| `pre_first` | 初めて挿入が試みられる直前 | 恐怖、パニック、必死の拒絶 |
| `pre_repeat` | 2回目以降の挿入直前 | 既視感、トラウマ反応、諦めの兆し |
| `sequence_resist_success` | 抵抗に成功し、挿入を防いだ | 安堵、一時的な勝利感 |
| `sequence_resist_fail` | 抵抗に失敗し、挿入された | 衝撃、痛み、屈辱、敗北感 |
| `sequence_accept` | 抵抗せず受け入れた | 諦め、無意識の身体反応、葛藤 |

---

### 4. restraintProfiles（拘束イベント時）

#### 使用されるタイミング
- 敵が拘束スキルを使用した時
- 自由状態から拘束状態への遷移時

#### JSON構造

```
lines.default.{stage}.{corruptionStage}.{countType}
→ 配列 [ string, string, ... ]
```

#### 各イベントの文脈

| countType | 文脈 | 感情の方向性 |
|-----------|------|-------------|
| `first` | 初めて拘束された | 驚き、パニック、怒り |
| `repeat` | 2回目以降の拘束 | 疲労感、諦め、または怒りの再燃 |

---

## 🔀 resist / fall 分岐の意味

### 発生条件
- Stage2 以降の danger / climax / down_attack イベント
- 絶頂イベントの aftermath

### resolve の決定方法
1. 絶頂時にプレイヤーが選択肢を選ぶ
2. その選択結果が `_resolveHistory` に保存される
3. 以降のセリフ取得時に参照される

### 分岐の感情的な意味

| resolve | 心理状態 | 表現の特徴 |
|---------|---------|-----------|
| `resist` | 快感に抗おうとしている | 強がり、歯を食いしばる、自分を律しようとする |
| `fall` | 快感に流されている | 抗えない、身体が勝手に、諦めの混じった反応 |

**重要**: resist でも身体は反応してしまう。あくまで「精神的にどう向き合っているか」の違い。

---

## 📐 行数・構造の仕様

### dialogueSequence の構造

```json
{
  "dialogueSequence": [
    { "text": "1行目のセリフ", "expression": "endure" },
    { "text": "2行目のセリフ", "expression": "confused" },
    { "text": "3行目のセリフ", "expression": "ahe" }
  ],
  "log": "状況説明テキスト（オプション）"
}
```

### 推奨行数

| イベント種別 | 推奨行数 | 備考 |
|-------------|---------|------|
| react | 2〜4行 | 通常の反応 |
| danger | 2〜4行 | 危機感を段階的に |
| climax | 3〜5行 | 絶頂への高まりを表現 |
| down_attack | 2〜3行 | 余韻の中の反応 |
| sequence（絶頂） | 3〜5行 | 段階的なエスカレート |
| after（絶頂後） | 1〜3行 | 短い余韻 |
| pre_first | 2〜3行 | 恐怖と拒絶 |
| pre_repeat | 1〜2行 | 短い反応 |
| resist_success | 1〜2行 | 安堵 |
| resist_fail | 2〜3行 | 衝撃 |
| accept | 1〜2行 | 身体反応 |
| 拘束 first/repeat | 1〜2行 | 短い反応 |

---

## 📊 必要パターン数サマリー

### 1モンスター分（Low堕落度のみ）

| ファイル | 内訳 | パターン数 |
|---------|------|-----------|
| poseProfiles | stage1(3) + stage2分岐(4) + stage3分岐(4) + down_attack(3) | 約14 |
| restraintProfiles | stage1-3 × first/repeat | 約6 |
| orgasmDetailProfiles | stage1-3 × sequence + after | 約6 |
| introProfiles | stage2-3 × 5イベント | 約10 |
| **合計** | | **約36パターン** |

**Low + High 両方で約 72パターン** が必要。

---

## 🏷️ expression（表情）の種類

| expression | 意味 | 使用場面 |
|------------|------|---------|
| `normal` | 通常 | 待機、初期状態 |
| `surprised` | 驚愕 | 拘束時、挿入時 |
| `endure` | 耐える | 抵抗中、我慢 |
| `confused` | 困惑 | 葛藤、戸惑い |
| `ahe` | 恍惚 | 絶頂、理性崩壊 |

---

## 🔗 プロファイル名の命名規則

システムは以下の形式でプロファイル名を自動生成します：

```
{enemyKey}[_restrained][_insert]_{corruptionStage}
```

| 状態 | プロファイル名 |
|------|---------------|
| 非拘束・低堕落 | `slime_low` |
| 拘束・低堕落 | `slime_restrained_low` |
| 拘束+挿入・低堕落 | `slime_restrained_insert_low` |
| 拘束+挿入・高堕落 | `slime_restrained_insert_high` |

---

## ⚡ クイックリファレンス

### イベント→ファイル対応

| 状況 | 使用ファイル | JSONパス |
|------|-------------|---------|
| 通常エロ攻撃 | poseProfiles | lines.{eventType}.{part}.{stage}.{corruption}[.{resolve}] |
| 絶頂 | orgasmDetailProfiles | sequence.{stage}.{corruption} |
| 絶頂後 | orgasmDetailProfiles | after_resist / after_fall |
| 挿入前 | introProfiles | insert.{stage}.{corruption}.pre_first/pre_repeat |
| 挿入成功/失敗 | introProfiles | insert.{stage}.{corruption}.sequence_* |
| 拘束 | restraintProfiles | lines.default.{stage}.{corruption}.first/repeat |

### 分岐の有無

| Stage | 分岐 |
|-------|------|
| stage1 | なし |
| stage2 | resist / fall |
| stage3 | resist / fall |

### フォールバック

| 取得失敗時 | フォールバック先 |
|-----------|-----------------|
| stage3 の react/danger | stage2 の同イベント |
| 指定 targetPart がない | pussy |
| 指定パターンがない | 配列の最初の要素 |

---

## 📝 出力時の注意点

### JSON構造の厳守
- キー名は完全一致が必要
- `dialogueSequence` と `dialogue` の使い分けに注意
  - poseProfiles / introProfiles → `dialogueSequence`
  - orgasmDetailProfiles → `dialogue`

### 配列形式
- 各パターンは配列の要素として格納
- システムはランダムに1つを選択

### log フィールド
- オプションだが、状況説明として有用
- プレイヤーへの文脈提示に使用される

---

この仕様書に基づいて、適切なJSON構造でセリフを生成してください。
具体的なセリフの内容・文体・表現については、別途提供される創作ガイドラインに従ってください。

