# セリフ整備ガイド（セリフライター向け）

## 📌 このドキュメントについて

セリフ整備班向けに、以下の点を重点的に解説します：

1. **Stage と イベントタイプの関係性**
2. **戦闘中のイベント時系列フロー**
3. **各イベントのセリフ行数・分岐の違い**

---

## 🎯 Stage（興奮段階）とは

**Stage** はプレイヤーの絶頂回数によって決まる段階です。

| Stage | 絶頂回数 | 状態 | セリフの特徴 |
|-------|---------|------|-------------|
| **stage1** | 0〜1回 | 初期状態 | 余裕あり、素直な拒絶 |
| **stage2** | 2〜4回 | 追い込まれ中 | 葛藤、resist/fall分岐あり |
| **stage3** | 5回以上 | 限界突破 | 理性崩壊、♡多用 |

### Stage の進行イメージ

```
戦闘開始
    │
    ▼
┌─────────────────────────────────────────────────┐
│ 【Stage1】 絶頂0〜1回                            │
│  ・まだ余裕がある                                │
│  ・「やめて！」「いや！」など素直な反応          │
│  ・resist/fall 分岐なし                         │
└─────────────────────────────────────────────────┘
    │ 絶頂2回目で移行
    ▼
┌─────────────────────────────────────────────────┐
│ 【Stage2】 絶頂2〜4回                            │
│  ・追い込まれ始める                              │
│  ・葛藤が生まれる                                │
│  ★ resist/fall 分岐が発生！                     │
└─────────────────────────────────────────────────┘
    │ 絶頂5回目で移行
    ▼
┌─────────────────────────────────────────────────┐
│ 【Stage3】 絶頂5回以上                           │
│  ・理性の崩壊                                    │
│  ・♡マーク多用、濁音使用                        │
│  ★ resist/fall 分岐あり                        │
│  ※ react/danger は省略可（stage2にフォールバック）│
└─────────────────────────────────────────────────┘
```

---

## 🔄 イベントタイプ（eventType）とは

**イベントタイプ** は「今なにが起きているか」を表します。  
MP（快感ゲージ）の残量によって自動決定されます。

| MP残量 | イベント | 状態 |
|--------|---------|------|
| 100〜61% | **react** | 通常反応 |
| 60〜31% | **danger** | 絶頂危機 |
| 30〜1% | **climax** | 絶頂寸前 |
| 0% | **orgasm** | 絶頂 → 回復後 **down_attack** |

### イベントタイプの進行イメージ

```
【1ターン目】エロ攻撃
     │
     ▼
  MP 100% → 70%
  イベント: react（通常反応）
  「きゃっ…触らないで…！」
     │
     ▼
【2ターン目】エロ攻撃
     │
     ▼
  MP 70% → 45%
  イベント: danger（絶頂危機）
  「やだ…っ♡ このままじゃ…！」
     │
     ▼
【3ターン目】エロ攻撃
     │
     ▼
  MP 45% → 15%
  イベント: climax（絶頂寸前）
  「だめっ…イっちゃう…っ！」
     │
     ▼
【4ターン目】エロ攻撃
     │
     ▼
  MP 15% → 0%
  イベント: orgasm（絶頂）
  「あぁぁっ♡ イクぅっ♡」
  ★ 絶頂回数 +1 → Stage判定に影響
     │
     ▼
【5ターン目】（回復中にエロ攻撃）
     │
     ▼
  イベント: down_attack（ダウン攻撃）
  「はぁ…っ♡ イったばかりなのに…！」
```

---

## 📊 Stage × イベントタイプ 対応表

### 必要なセリフの有無

|  | react | danger | climax | down_attack | standby |
|--|-------|--------|--------|-------------|---------|
| **stage1** | ✅必須 | ✅必須 | ✅必須 | △オプション | △オプション |
| **stage2** | △オプション | ✅必須(分岐) | ✅必須(分岐) | ✅必須 | △オプション |
| **stage3** | ×不要 | ×不要 | ✅必須(分岐) | ✅必須(分岐) | ×不要 |

**凡例**:
- ✅必須 = 必ず用意する
- ✅必須(分岐) = resist/fall の2パターン必要
- △オプション = あれば良い
- ×不要 = システムが stage2 にフォールバックするため省略可

---

## ⏱️ 戦闘フロー全体図

### 通常エロ攻撃の流れ

```
敵がエロスキル使用
        │
        ▼
┌───────────────────────────────────────┐
│ ① MP減少 → イベントタイプ決定         │
│    (react / danger / climax / orgasm) │
└───────────────────────────────────────┘
        │
        ▼
┌───────────────────────────────────────┐
│ ② poseProfiles のセリフを表示         │
│    lines.{eventType}.{part}.{stage}   │
└───────────────────────────────────────┘
        │
        │ MP が 0% になった場合
        ▼
┌───────────────────────────────────────┐
│ ③ 絶頂イベント発動                    │
│    → orgasmDetailProfiles を使用      │
│    → 絶頂回数 +1                      │
│    → Stage 判定が更新される           │
└───────────────────────────────────────┘
        │
        │ 次ターンでエロ攻撃を受けた場合
        ▼
┌───────────────────────────────────────┐
│ ④ ダウン攻撃イベント                  │
│    lines.down_attack.{part}.{stage}   │
└───────────────────────────────────────┘
```

### 挿入イベントの流れ

```
敵が挿入スキル使用
        │
        ▼
┌───────────────────────────────────────┐
│ ① 挿入の試み                          │
│    ・初回か2回目以降かを判定           │
└───────────────────────────────────────┘
        │
        ├── 初回の場合 ────────────────┐
        │                               ▼
        │                    ┌──────────────────┐
        │                    │ pre_first        │
        │                    │ 「入ってくる…！」│
        │                    └──────────────────┘
        │
        ├── 2回目以降 ────────────────┐
        │                               ▼
        │                    ┌──────────────────┐
        │                    │ pre_repeat       │
        │                    │ 「また…っ」     │
        │                    └──────────────────┘
        │
        ▼
┌───────────────────────────────────────┐
│ ② プレイヤー選択                      │
│    「抵抗する」or「受け入れる」        │
└───────────────────────────────────────┘
        │
        ├── 抵抗を選択 ─────────────────┐
        │                                │
        │    ┌─ 成功判定 ─┐              │
        │    │            │              │
        │    ▼            ▼              │
        │ 成功           失敗            │
        │    │            │              │
        │    ▼            ▼              │
        │ ┌────────┐  ┌────────────┐     │
        │ │resist  │  │resist_fail │     │
        │ │_success│  │「あっ…入っ │     │
        │ │「防げた│  │ ちゃった…」│     │
        │ └────────┘  └────────────┘     │
        │                                │
        ├── 受け入れを選択 ─────────────┐
        │                                ▼
        │                    ┌──────────────────┐
        │                    │ sequence_accept  │
        │                    │ 「んっ…あぁ…♡」│
        │                    └──────────────────┘
        │
        ▼
┌───────────────────────────────────────┐
│ ③ 挿入後の通常エロ攻撃                │
│    → poseProfiles（挿入版）を使用     │
└───────────────────────────────────────┘
```

### 絶頂イベントの詳細フロー

```
MP が 0% に到達
        │
        ▼
┌───────────────────────────────────────┐
│ ① 絶頂前（プレイヤー選択）            │
│    「耐える」or「身を委ねる」          │
│                                        │
│    → この選択が _resolveHistory に保存│
│    → 以降のセリフ分岐(resist/fall)に影響│
└───────────────────────────────────────┘
        │
        ├── 耐える(resist)を選択 ───────┐
        │                                ▼
        │                    ┌──────────────────┐
        │                    │ sequence (resist)│
        │                    │ 強がりながら絶頂 │
        │                    │ 「くっ…負けない」│
        │                    └──────────────────┘
        │
        ├── 身を委ねる(fall)を選択 ─────┐
        │                                ▼
        │                    │ sequence (fall)  │
        │                    │ 快感に屈して絶頂 │
        │                    │ 「もうだめぇ♡」 │
        │                    └──────────────────┘
        │
        ▼
┌───────────────────────────────────────┐
│ ② 絶頂シーケンス再生                  │
│    orgasmDetailProfiles の sequence   │
│    複数行が順番に表示される            │
└───────────────────────────────────────┘
        │
        ▼
┌───────────────────────────────────────┐
│ ③ 絶頂後（aftermath）                 │
│    「はぁ…はぁ…っ」                  │
│    → 絶頂回数 +1                      │
│    → Stage が進行する可能性           │
└───────────────────────────────────────┘
```

---

## 📝 セリフ行数・分岐の仕様

### poseProfiles（通常エロ攻撃）

#### Stage1（分岐なし）

**構造**:
```json
"react": {
  "pussy": {
    "stage1": {
      "low": [
        {
          "dialogueSequence": [
            { "text": "1行目" },
            { "text": "2行目" },
            { "text": "3行目" }
          ]
        }
      ]
    }
  }
}
```

**行数目安**: 2〜4行
**バリエーション**: 1パターン以上（配列で複数可）

#### Stage2/Stage3（resist/fall 分岐あり）

**構造**:
```json
"danger": {
  "pussy": {
    "stage2": {
      "low": {
        "resist": [
          {
            "dialogueSequence": [
              { "text": "くっ…負けない…！" },
              { "text": "んっ…でも…屈しない…！" }
            ],
            "log": "強がりを崩さない。"
          }
        ],
        "fall": [
          {
            "dialogueSequence": [
              { "text": "やだ…気持ちいい…っ♡" },
              { "text": "もう…だめ…っ♡" }
            ],
            "log": "快感に屈していく。"
          }
        ]
      }
    }
  }
}
```

**行数目安**: 2〜4行（各分岐）
**分岐**: resist と fall の2パターン必須

---

### orgasmDetailProfiles（絶頂イベント）

**構造**:
```json
"sequence": {
  "stage2": {
    "low": [
      { "dialogue": "1行目（絶頂前）", "expression": "endure" },
      { "dialogue": "2行目（高まり）", "expression": "confused" },
      { "dialogue": "3行目（絶頂）", "expression": "ahe" }
    ]
  }
},
"after_resist": {
  "stage2": {
    "low": [
      { "dialogue": "絶頂後セリフ1", "expression": "endure" },
      { "dialogue": "絶頂後セリフ2", "expression": "confused" }
    ]
  }
},
"after_fall": {
  "stage2": {
    "low": [
      { "dialogue": "絶頂後セリフ（屈服）", "expression": "ahe" }
    ]
  }
}
```

**行数目安**:
- sequence: 3〜5行（段階的な高まりを表現）
- after_resist / after_fall: 1〜3行

---

### introProfiles（挿入イベント）

**構造**:
```json
"insert": {
  "stage2": {
    "low": {
      "pre_first": [
        {
          "dialogueSequence": [
            { "text": "やっ…入ってくる…！" },
            { "text": "やだっ…やめてぇ…！" }
          ]
        }
      ],
      "pre_repeat": [
        {
          "dialogueSequence": [
            { "text": "また…入れられる…っ" }
          ]
        }
      ],
      "sequence_resist_success": [
        {
          "dialogueSequence": [
            { "text": "はぁ…防げた…！" }
          ]
        }
      ],
      "sequence_resist_fail": [
        {
          "dialogueSequence": [
            { "text": "あっ…入っちゃった…！" },
            { "text": "んぅっ…っ！" }
          ]
        }
      ],
      "sequence_accept": [
        {
          "dialogueSequence": [
            { "text": "んっ…あぁ…っ♡" }
          ]
        }
      ]
    }
  }
}
```

**行数目安**:
- pre_first: 2〜3行（恐怖・拒絶）
- pre_repeat: 1〜2行（短め）
- sequence_resist_success: 1〜2行（安堵）
- sequence_resist_fail: 2〜3行（衝撃・屈辱）
- sequence_accept: 1〜2行（身体反応）

---

### restraintProfiles（拘束イベント）

**構造**:
```json
"lines": {
  "default": {
    "stage1": {
      "low": {
        "first": [
          "きゃっ！拘束された…！",
          "やだ…動けない…っ！"
        ],
        "repeat": [
          "また拘束されちゃった…",
          "くそ…また捕まって…"
        ]
      }
    }
  }
}
```

**行数目安**: 各1〜2行（短いセリフ）
**分岐**: first（初回）と repeat（2回目以降）

---

## 📊 セリフ数サマリー（1モンスター分）

### 最低限（Low堕落度のみ）

| ファイル | イベント | Stage | 分岐 | 行数目安 | パターン数 |
|---------|---------|-------|------|---------|-----------|
| **poseProfiles** |||||
| | react | stage1 | なし | 3行 | ×1 |
| | danger | stage1 | なし | 3行 | ×1 |
| | danger | stage2 | resist/fall | 3行×2 | ×2 |
| | climax | stage1 | なし | 4行 | ×1 |
| | climax | stage2 | resist/fall | 4行×2 | ×2 |
| | climax | stage3 | resist/fall | 4行×2 | ×2 |
| | down_attack | stage2 | なし | 3行 | ×1 |
| | down_attack | stage3 | resist/fall | 3行×2 | ×2 |
| **小計** ||| | | **約12パターン** |
| **restraintProfiles** |||||
| | 拘束 | stage1-3 | first/repeat | 2行×2 | ×6 |
| **小計** ||| | | **約6パターン** |
| **orgasmDetailProfiles** |||||
| | sequence | stage1-3 | なし | 4行 | ×3 |
| | after | stage1-3 | なし | 2行 | ×3 |
| **小計** ||| | | **約6パターン** |
| **introProfiles（挿入系のみ）** |||||
| | pre_first | stage2-3 | なし | 2行 | ×2 |
| | pre_repeat | stage2-3 | なし | 1行 | ×2 |
| | resist_success | stage2-3 | なし | 1行 | ×2 |
| | resist_fail | stage2-3 | なし | 2行 | ×2 |
| | accept | stage2-3 | なし | 1行 | ×2 |
| **小計** ||| | | **約10パターン** |

### 合計: 約 **34パターン** （Low のみ）

**Low + High で約 68パターン** が必要です。

---

## 🎭 resist / fall 分岐の書き分け

### resist（抵抗）のセリフ特徴

- **姿勢**: 強がり、意地
- **声**: 歯を食いしばる、我慢
- **内容**: 「負けない」「屈しない」「こんなの…」
- **♡使用**: 控えめ（あっても1個）
- **log**: 「強がりを崩さない」「意志を保っている」

**例**:
```
"くっ…負けない…っ！"
"んっ…こんなの…感じてない…！"
"絶対…屈しないんだから…！"
```

### fall（屈服）のセリフ特徴

- **姿勢**: 抗えない、流される
- **声**: 甘い、力が抜ける
- **内容**: 「気持ちいい」「だめ」「もう」
- **♡使用**: 多め（2〜3個）
- **log**: 「快感に屈していく」「理性が崩れる」

**例**:
```
"やだ…気持ちいい…っ♡"
"もう…だめ…止まらない…っ♡"
"あぁ…っ♡ 身体が…勝手に…っ♡"
```

---

## ⚡ クイックリファレンス

### 「今どのセリフを書けばいい？」チャート

```
Q1: 何のイベント？
│
├─ 通常エロ攻撃 → poseProfiles
│   │
│   └─ Q2: MP残量はどのくらいの想定？
│       ├─ 100〜61% → react
│       ├─ 60〜31% → danger
│       ├─ 30〜1% → climax
│       └─ 絶頂直後 → down_attack
│
├─ 拘束された時 → restraintProfiles
│   └─ first / repeat で分ける
│
├─ 絶頂の瞬間 → orgasmDetailProfiles
│   └─ sequence（絶頂中）/ after（絶頂後）
│
└─ 挿入される時 → introProfiles
    └─ pre_first / pre_repeat / resist系 / accept
```

### 「分岐は必要？」チャート

```
Q: どのStage？
│
├─ Stage1 → 分岐なし（シンプル）
│
├─ Stage2 → danger / climax / down_attack で分岐必要
│           resist と fall の2パターン
│
└─ Stage3 → climax / down_attack で分岐必要
            resist と fall の2パターン
```

---

## 📁 ファイル配置早見表

```
dataEx/
├── poseProfiles/
│   ├── {monster}_restrained_low.json    ← 通常エロ（低堕落）
│   └── {monster}_restrained_high.json   ← 通常エロ（高堕落）
│
├── restraintProfiles/
│   ├── {monster}_restrained_low.json    ← 拘束イベント（低堕落）
│   └── {monster}_restrained_high.json   ← 拘束イベント（高堕落）
│
├── orgasmDetailProfiles/
│   ├── {monster}_restrained_low.json    ← 絶頂イベント（低堕落）
│   └── {monster}_restrained_high.json   ← 絶頂イベント（高堕落）
│
└── introProfiles/insert/
    ├── {monster}_restrained_low.json    ← 挿入イベント（低堕落）
    └── {monster}_restrained_high.json   ← 挿入イベント（高堕落）
```

---

## ✏️ セリフ作成の優先順位

### 第1優先（最低限動作に必要）

1. poseProfiles の **climax.stage2**（resist/fall）
2. poseProfiles の **danger.stage2**（resist/fall）
3. poseProfiles の **react.stage1**
4. orgasmDetailProfiles の **sequence.stage2**

### 第2優先（一通りの体験に必要）

5. poseProfiles の **climax.stage1**
6. poseProfiles の **climax.stage3**（resist/fall）
7. poseProfiles の **down_attack.stage2**
8. restraintProfiles の **stage1.first/repeat**

### 第3優先（充実させる）

9. introProfiles の全イベント（挿入系の場合）
10. poseProfiles の **standby**
11. その他のバリエーション追加

---

## 💡 よくある質問

### Q: stage3 の react / danger は書かなくていい？

**A**: 書かなくてOKです。システムが自動的に stage2 のセリフにフォールバックします。

### Q: resist と fall、どちらから書けばいい？

**A**: **resist から先に書く**のがおすすめです。  
resist を書いてから、それを♡多めに崩すと fall が書きやすいです。

### Q: バリエーションはいくつ必要？

**A**: 最低1パターン。理想は2〜3パターン。  
同じ状況で同じセリフが出ると飽きるので、余裕があれば複数用意してください。

### Q: dialogueSequence の行数に上限はある？

**A**: 技術的な上限はありませんが、**3〜5行が読みやすい**です。  
10行以上になると冗長に感じる可能性があります。

### Q: log は必須？

**A**: 必須ではありませんが、**あると雰囲気が出ます**。  
特に resist/fall の違いを説明するのに効果的です。

---

## 📚 参考ファイル

実際のセリフ例として参照してください：

- `slime_restrained_low.json` - シンプルな構造
- `slime_restrained_high.json` - 堕落度高の表現
- `goblin_restrained_insert_low.json` - 挿入系の例

---

## 🔄 更新履歴

- 2024-XX-XX: 初版作成

