# エロ演出JSON構造仕様書

## 概要

ProjectEstのエロ演出システムは、以下の2種類のJSONファイルで構成されています：

1. **poseProfiles** - ポーズ＋セリフ統合プロファイル（リアクション全般）
2. **orgasmDetailProfiles** - 絶頂専用詳細台本プロファイル

---

## 1. poseProfiles（ポーズプロファイル）

戦闘中のエロ演出全般（react、danger、climax、down_attack、standby）を管理するプロファイル。

### ファイル命名規則

```
{enemyKey}_{state}_{corruptionStage}.json
```

- `enemyKey`: 敵キー（例: `reider`, `goblin`, `aphrodisiacSlime`）
- `state`: 状態（`restrained`, `restrained_insert`など）
- `corruptionStage`: 堕落度（`low`, `high`）

### JSON構造

```json
{
  "meta": {
    "profileName": "string",      // プロファイル名（ファイル名と一致）
    "enemyKey": "string",          // 敵キー
    "state": ["string"],           // 状態配列 ["restrained"] または ["restrained", "inserted"]
    "corruptionStage": "string",   // "low" または "high"
    "notes": "string"              // 説明・備考
  },
  "visuals": {
    "stage1": { /* フェーズ1のビジュアル設定 */ },
    "stage2": { /* フェーズ2のビジュアル設定 */ },
    "stage3": { /* フェーズ3のビジュアル設定 */ }
  },
  "lines": {
    "react": { /* リアクションセリフ */ },
    "danger": { /* デンジャーセリフ */ },
    "climax": { /* 絶頂セリフ */ },
    "down_attack": { /* ダウン攻撃セリフ */ }
  }
}
```

### meta（メタ情報）

| フィールド | 型 | 説明 |
|-----------|-----|------|
| profileName | string | プロファイル識別名（ファイル名と一致させる） |
| enemyKey | string | 敵の種類（reider, goblin等） |
| state | string[] | 状態配列。`["restrained"]`（拘束のみ）または`["restrained", "inserted"]`（挿入あり） |
| corruptionStage | string | 堕落度。`"low"`または`"high"` |
| notes | string | プロファイルの説明文 |

### visuals（ビジュアル設定）

各ステージ（stage1〜3）ごとに、各アクション（react/danger/climax/standby/down_attack）の表示設定を定義。

```json
"visuals": {
  "stage1": {
    "react": {
      "pre": { "pose": "auto" },
      "main": { "pose": "auto" }
    },
    "danger": {
      "pre": { "pose": "auto" },
      "main": { "pose": "auto" }
    },
    "climax": {
      "pre": { "pose": "auto" },
      "main": { "pose": "auto" }
    },
    "standby": {
      "pre": { "pose": "auto" },
      "main": { "pose": "auto" }
    },
    "down_attack": {
      "pre": { "pose": "auto" },
      "main": { "pose": "auto" }
    }
  },
  "stage2": { /* 同様の構造 */ },
  "stage3": { /* 同様の構造 */ }
}
```

**構造:**
- `stage1` / `stage2` / `stage3`: 絶頂カウント段階
- `react` / `danger` / `climax` / `standby` / `down_attack`: アクション種別
- `pre` / `main`: 演出のフェーズ
- `pose`: `"auto"` で自動選択（現在は全て`"auto"`を推奨）

### lines（セリフデータ）

各アクション種別ごとに、攻撃部位・ステージ・堕落度に応じたセリフを定義。

#### 構造階層

```
lines
├── react (リアクション)
├── danger (デンジャー)
├── climax (絶頂)
└── down_attack (ダウン攻撃)
    └── breast / pussy (攻撃部位)
        └── stage1 / stage2 / stage3 (絶頂カウント)
            └── high / low (堕落度)
                └── resist / fall (stage2以降: 抵抗/堕落分岐)
                    └── dialogueSequence[] (会話シーケンス配列)
```

#### 非挿入系（breast攻撃）の例

```json
"lines": {
  "react": {
    "breast": {
      "stage1": {
        "high": [
          {
            "dialogueSequence": [
              { "text": "なっ…！あ゛っ♡　離し゛っ♡" },
              { "text": "おいおい、そう睨むなよ。ちょっと…" }
            ]
          }
        ]
      },
      "stage2": {
        "high": {
          "resist": [
            {
              "dialogueSequence": [
                { "text": "や゛っ♡　まだ゛っ♡　やめ゛っ♡" },
                { "text": "お前、さっきメスって認めたよな？" }
              ]
            }
          ],
          "fall": [
            {
              "dialogueSequence": [
                { "text": "もう゛っ♡　あ゛っ♡　やめ゛っ♡" },
                { "text": "お前、さっきメスになったって言ったよな？" }
              ]
            }
          ]
        }
      }
    }
  }
}
```

#### 挿入系（pussy攻撃）の例

```json
"lines": {
  "react": {
    "pussy": {
      "stage1": {
        "high": [
          {
            "dialogueSequence": [
              { "text": "くっ…あ゛っ♡　動かないで゛っ♡" },
              { "text": "動くなって？それじゃあ意味ねえだろ" }
            ]
          }
        ]
      },
      "stage2": {
        "high": {
          "resist": [
            {
              "dialogueSequence": [
                { "text": "や゛っ♡　また゛っ♡　動いて゛っ♡" }
              ]
            }
          ],
          "fall": [
            {
              "dialogueSequence": [
                { "text": "もう゛っ♡　また゛っ♡　動いて゛っ♡" }
              ]
            }
          ]
        }
      }
    }
  }
}
```

#### stage1とstage2以降の違い

- **stage1**: 配列直接形式 `"high": [ {...} ]`
- **stage2/3**: resist/fall分岐あり `"high": { "resist": [...], "fall": [...] }`

---

## 2. orgasmDetailProfiles（絶頂詳細プロファイル）

絶頂シーンの選択肢と詳細台本を管理するプロファイル。

### ファイル命名規則

```
{enemyKey}_{state}_{corruptionStage}.json
```

（poseProfilesと同じ命名規則）

### JSON構造

```json
{
  "meta": {
    "profileName": "string",
    "enemyKey": "string",
    "corruptionStage": "string",
    "notes": "string",
    "state": ["string"]
  },
  "choices": { /* 選択肢 */ },
  "sequence": { /* 絶頂前台本 */ },
  "after_resist": { /* 抵抗後台本 */ },
  "after_fall": { /* 堕落後台本 */ },
  "sequence_inserted": { /* 挿入時絶頂前台本 */ },
  "after_resist_inserted": { /* 挿入時抵抗後台本 */ },
  "after_fall_inserted": { /* 挿入時堕落後台本 */ }
}
```

### meta（メタ情報）

poseProfilesと同様の構造。

### choices（選択肢）

絶頂前にプレイヤーに提示される選択肢。

```json
"choices": {
  "stage1": {
    "low": [
      "まだ…イかない…！",
      "もう…イっちゃう…"
    ],
    "high": [
      "まだ…イかない…！",
      "もう…イっちゃう…"
    ]
  },
  "stage2": { /* 同様 */ },
  "stage3": { /* 同様 */ }
}
```

- 最初の選択肢: **抵抗**（resist）
- 2番目の選択肢: **堕落**（fall）

### sequence（絶頂前台本）

絶頂直前の会話シーケンス。

```json
"sequence": {
  "stage1": {
    "low": [
      { "dialogue": "や…んっ…やだ…あっ…来ちゃ…！" },
      { "dialogue": "ククク…イくのか？" },
      { "dialogue": "ちが…っ！んっ…そんな…あっ…" },
      { "dialogue": "違わねえよ。ほら、言ってみろ" }
    ],
    "high": [ /* 同様 */ ]
  },
  "stage2": { /* 同様 */ },
  "stage3": { /* 同様 */ }
}
```

### after_resist（抵抗後台本）

「まだイかない」を選択した後の台本。

```json
"after_resist": {
  "stage1": {
    "low": [
      { "dialogue": "い…いや…あっ…！んっ…絶対…言わ…ない…！" },
      { "dialogue": "言わねえか。強情だな" },
      { "dialogue": "くっ…あっ…！んっ…やだ…ふあっ…でも…イっ…" },
      { "dialogue": "んああああっ♥♥♥　いや…なのに…あっ♥♥" },
      { "dialogue": "はぁ…はぁ…くっ…認め…ない…" },
      { "dialogue": "へへっ、口では強がってもよ…" }
    ]
  }
}
```

### after_fall（堕落後台本）

「もうイっちゃう」を選択した後の台本。

```json
"after_fall": {
  "stage1": {
    "low": [
      { "dialogue": "…き…きもち…あっ…" },
      { "dialogue": "ん？何だ？ほら、ちゃんと言ってみろよ" },
      { "dialogue": "それは…あっ♥　んっ♥　ふあっ♥♥" },
      { "dialogue": "それは？どうした、言えねえのか？" },
      { "dialogue": "やっ…あっ♥　んっ♥　ーーーっっっ♥♥" },
      { "dialogue": "んああああっ♥♥♥　あっ♥　んっ♥♥" },
      { "dialogue": "はぁ…はぁ…" },
      { "dialogue": "へへっ、図星かよ…" }
    ]
  }
}
```

### 挿入時専用フィールド

挿入状態（`state: ["restrained", "inserted"]`）の場合、以下の追加フィールドが必要。

#### sequence_inserted

```json
"sequence_inserted": {
  "stage1": {
    "low": [
      { "dialogue": "だめ…んっ…中で…あっ…来ちゃ…！" },
      { "dialogue": "中でイくのか？へへっ…" }
    ]
  },
  "stage2": { /* 同様 */ }
}
```

#### after_resist_inserted

```json
"after_resist_inserted": {
  "stage1": {
    "low": [
      { "dialogue": "い…いや…あっ…！んっ…そんなこと…絶対…！" },
      { "dialogue": "言えねえか。まあいい、どうせもうすぐイくんだろ？" },
      { "dialogue": "くっ…あっ…！中で…んっ…やだ…でも…イっちゃ…ふあっ♥" },
      { "dialogue": "んああああっ♥♥♥　中で…いや…なのに…あっ♥♥" },
      { "dialogue": "はぁ…はぁ…まだ…負けて…ない…" },
      { "dialogue": "ククク…膣内でイかされて、まだ強がるのか" }
    ]
  }
}
```

#### after_fall_inserted

```json
"after_fall_inserted": {
  "stage1": {
    "low": [
      { "dialogue": "…中…あっ…きもち…" },
      { "dialogue": "ん？何だって？ほら、ちゃんと言ってみろよ" },
      { "dialogue": "それは…あっ♥　んっ♥　ふあっ♥♥" },
      { "dialogue": "やっ…あっ♥　中で…んっ♥　ーーーっっっ♥♥" },
      { "dialogue": "んああああっ♥♥♥　中で…あっ♥　んっ♥♥" },
      { "dialogue": "はぁ…はぁ…" },
      { "dialogue": "へへっ、答えられねえってことは、図星ってことだな" }
    ]
  }
}
```

---

## 3. データ構造の対応関係

### poseProfiles ⇔ orgasmDetailProfiles

| 要素 | poseProfiles | orgasmDetailProfiles |
|------|--------------|---------------------|
| 使用タイミング | react, danger, climax, down_attack全般 | climax時の詳細台本 |
| ビジュアル管理 | ✅ あり (`visuals`) | ❌ なし |
| セリフ形式 | dialogueSequence形式 | dialogue形式 |
| 選択肢 | ❌ なし | ✅ あり (`choices`) |
| 抵抗/堕落分岐 | stage2以降にresist/fall | 選択肢によりafter_resist/after_fall |

### state配列の意味

| state配列 | 意味 | 攻撃部位 |
|-----------|------|---------|
| `["restrained"]` | 拘束のみ（非挿入） | `breast`（胸） |
| `["restrained", "inserted"]` | 拘束＋挿入 | `pussy`（膣） |

---

## 4. データ作成のガイドライン

### 必須ペアリング

1つの敵・状態・堕落度の組み合わせには、以下の2ファイルが必要：

```
poseProfiles/reider_restrained_low.json
orgasmDetailProfiles/reider_restrained_low.json
```

### ファイル命名の一貫性

- **enemyKey**: 敵の種類（例: reider, goblin, aphrodisiacSlime）
- **state**: 状態（restrained, restrained_insert）
- **corruptionStage**: low/high

この3要素の組み合わせで、poseProfilesとorgasmDetailProfilesのファイル名を一致させる。

### stage1とstage2/3の違い

#### poseProfiles

- **stage1**: 配列直接 `"high": [ {...} ]`
- **stage2/3**: resist/fall分岐 `"high": { "resist": [...], "fall": [...] }`

#### orgasmDetailProfiles

- 全stageで構造は同じだが、stageが進むにつれて堕落度が上がる内容にする

### 挿入系の追加要件

`state: ["restrained", "inserted"]`の場合：

**poseProfiles:**
- `lines`内で`pussy`を使用

**orgasmDetailProfiles:**
- `sequence_inserted`
- `after_resist_inserted`
- `after_fall_inserted`

を追加定義。

---

## 5. 特殊記号の使用

### セリフ内の記号

- `♡` / `♥`: ハートマーク（快感表現）
- `…`: 三点リーダー（間・余韻）
- `゛`: 濁点（息遣い・荒い呼吸）
- `っ`: 促音（途切れる声）
- `んっ` / `あっ` / `ふあっ`: 喘ぎ声
- `ーーーっっっ♥♥`: 絶頂時の長い喘ぎ

---

## 6. バリデーションチェックリスト

新規ファイル作成時には以下を確認：

- [ ] ファイル名が規則に従っているか
- [ ] meta情報が正しく記載されているか
- [ ] poseProfilesとorgasmDetailProfilesがペアで存在するか
- [ ] state配列と攻撃部位（breast/pussy）が一致しているか
- [ ] stage1は配列形式、stage2/3はresist/fall分岐形式か（poseProfiles）
- [ ] 挿入系の場合、_insertedフィールドが存在するか（orgasmDetailProfiles）
- [ ] JSONの構文エラーがないか

---

## 7. サンプルファイルパス

### 非挿入系（breast）

```
poseProfiles/reider_restrained_low.json
poseProfiles/reider_restrained_high.json
orgasmDetailProfiles/reider_restrained_low.json
orgasmDetailProfiles/reider_restrained_high.json
```

### 挿入系（pussy）

```
poseProfiles/reider_restrained_insert_low.json
poseProfiles/reider_restrained_insert_high.json
orgasmDetailProfiles/reider_restrained_insert_low.json
orgasmDetailProfiles/reider_restrained_insert_high.json
```

---

## 更新履歴

- 2025-12-15: 初版作成

