# 新規モンスター追加ガイド

## 概要

このガイドでは、新しいモンスター（敵キャラクター）を ProjectEst に追加する際に必要な要素と手順を説明します。

---

## 📋 必要な要素一覧

新規モンスターを追加するには、以下の要素が必要です：

### 1. **コード側の設定**
- [ ] `PleasurePoseController.js` のフォールバックマップへの登録
- [ ] `monsterTraits.json` への特性登録

### 2. **画像ファイル**
- [ ] ベース画像（体）
- [ ] 表情画像（フェイスレイヤー）
- [ ] オーバーレイ画像（状態エフェクト）
- [ ] 擬音バブル画像（オプション）

### 3. **データファイル（JSON）**
- [ ] `poseProfiles/` - ビジュアル・セリフ定義（必須）
- [ ] `restraintProfiles/` - 拘束イベント定義（拘束系のみ）
- [ ] `orgasmDetailProfiles/` - 絶頂イベント定義（必須）
- [ ] `introProfiles/insert/` - 挿入イベント定義（挿入系のみ）
- [ ] `overlays/overlaySets_*.json` - オーバーレイマッピング（必須）

---

## 🔧 手順1: コード側の設定

### 1.1 敵名マッピングの登録

**ファイル**: `js/plugins/PleasurePoseController.js`

```javascript
const fallbackMap = {
  // DB表示名 : 内部ベース名（英字）
  "スライム": "slime",
  "ゴブリン": "goblin",
  "触手": "tentacle",
  // ↓ 新規追加
  "新モンスター名": "newmonster"  // ← 英数字のみ推奨
};
```

**ルール**:
- キー: RPGツクールMZのデータベースで設定した敵キャラ名（日本語可）
- 値: 内部で使用する英数字の識別子（小文字推奨）

### 1.2 モンスター特性の登録

**ファイル**: `dataEx/monsterTraits.json`

```json
{
  "newmonster": {
    "allowStage1Insert": false,
    "displayName": "新モンスター",
    "description": "通常モンスター。stage2から挿入可能。"
  }
}
```

**パラメータ**:
- `allowStage1Insert`: stage1から挿入可能か（通常は `false`）
- `displayName`: 表示用の名前
- `description`: 説明（開発用メモ）

---

## 🎨 手順2: 画像ファイルの準備

### 2.1 フォルダ構造

画像は `img/pictures/busts/` 配下に配置します：

```
img/pictures/busts/
└── newmonster_restrained/          # モンスター名_状態
    ├── uniform_react_base.png      # ベース画像
    ├── uniform_danger_base.png
    ├── uniform_climax_base.png
    ├── default_pose_face_normal.png    # 表情
    ├── default_pose_face_endure.png
    ├── default_pose_face_confused.png
    ├── default_pose_face_ahe.png
    ├── default_pose_overlay_restrain.png   # オーバーレイ
    ├── default_pose_overlay_blush_low.png
    ├── default_pose_overlay_blush_mid.png
    ├── default_pose_overlay_blush_high.png
    ├── default_pose_overlay_あっ_a.png     # 擬音（オプション）
    └── default_pose_overlay_んっ_a.png
```

### 2.2 命名規則

#### ベース画像
```
{pose}_base.png
```

**poseの例**:
- `uniform_react` - 通常反応
- `uniform_danger` - 危機状態
- `uniform_climax` - 絶頂
- `uniform_standby` - 待機
- `uniform_down_attack` - ダウン攻撃

#### 表情画像
```
default_pose_face_{expression}.png
```

**必須の表情**:
- `normal` - 通常
- `endure` - 耐える
- `confused` - 困惑
- `ahe` - 恍惚

**オプション表情**:
- `surprised` - 驚愕
- `angry` - 怒り
- `crying` - 泣き

#### オーバーレイ画像
```
default_pose_overlay_{key}.png
```

**必須オーバーレイ**:
- `restrain` - 拘束具（拘束系の場合）
- `blush_low` - 頬の赤み（低）
- `blush_mid` - 頬の赤み（中）
- `blush_high` - 頬の赤み（高）

**攻撃エフェクト**（モンスター固有）:
- `attack_pussy_soft` - 弱攻撃
- `attack_pussy_hard` - 強攻撃
- `insert_pussy_soft` - 挿入（弱）
- `insert_pussy_hard` - 挿入（強）

#### 擬音画像（オプション）
```
default_pose_overlay_{soundText}_{variant}.png
```

**例**:
- `あっ_a.png` / `あっ_b.png`
- `んっ_a.png` / `んっ_b.png`
- `はぁ_a.png` / `はぁ_b.png`

### 2.3 プロファイル名→フォルダ名の変換ルール

システムは以下のルールでフォルダ名を決定します：

```javascript
// 基本形式: {enemyKey}_{state}_{corruptionStage}
"newmonster_restrained_low" → "newmonster_restrained"  // _low/_mid/_high を除去

// 挿入系
"newmonster_restrained_insert_high" → "newmonster_restrained_insert"
```

**推奨**: `_low/_mid/_high` のサフィックスを持たない統合フォルダを使う

---

## 📄 手順3: プロファイルファイルの作成

### 3.1 poseProfiles（必須）

**ファイル名**: `dataEx/poseProfiles/newmonster_restrained_low.json`

**最小構成**:

```json
{
  "meta": {
    "profileName": "newmonster_restrained_low",
    "enemyKey": "newmonster",
    "state": ["restrained"],
    "corruptionStage": "low",
    "notes": "新モンスター・拘束状態・堕落度低"
  },
  "visuals": {
    "stage1": {
      "react": {
        "pre": {
          "pose": "auto",
          "overlays": ["restrain", "blush_low"]
        },
        "main": {
          "pose": "auto",
          "overlays": ["restrain", "blush_low"]
        }
      },
      "danger": { /* 同様の構造 */ },
      "climax": { /* 同様の構造 */ },
      "standby": { /* 同様の構造 */ },
      "down_attack": { /* 同様の構造 */ }
    },
    "stage2": { /* stage1と同様の構造 */ },
    "stage3": { /* stage1と同様の構造 */ }
  },
  "lines": {
    "react": {
      "pussy": {
        "stage1": {
          "low": [
            {
              "dialogueSequence": [
                { "text": "やっ…触らないで…！" },
                { "text": "んっ…くぅ…っ…やだ…！" }
              ]
            }
          ]
        }
      }
    },
    "danger": { /* reactと同様の構造 */ },
    "climax": { /* reactと同様の構造 */ }
  }
}
```

**堕落度バリエーション**:
- `newmonster_restrained_low.json` - 堕落度低
- `newmonster_restrained_mid.json` - 堕落度中（オプション）
- `newmonster_restrained_high.json` - 堕落度高

### 3.2 restraintProfiles（拘束系のみ）

**ファイル名**: `dataEx/restraintProfiles/newmonster_restrained_low.json`

```json
{
  "meta": {
    "profileName": "newmonster_restrained_low",
    "enemyKey": "newmonster",
    "corruptionStage": "low"
  },
  "visuals": {
    "stage1": {
      "react": {
        "pre": {
          "pose": "auto",
          "expression": "surprised",
          "overlays": ["restrain", "blush_low"],
          "underOverlays": ["under_attack"]
        }
      }
    }
  },
  "lines": {
    "default": {
      "stage1": {
        "low": {
          "first": [
            "きゃっ！拘束された…！",
            "やだ…動けない…っ！"
          ],
          "repeat": [
            "また拘束されちゃった…",
            "くそ…また捕まって…"
          ]
        }
      }
    }
  }
}
```

### 3.3 orgasmDetailProfiles（必須）

**ファイル名**: `dataEx/orgasmDetailProfiles/newmonster_restrained_low.json`

```json
{
  "meta": {
    "profileName": "newmonster_restrained_low",
    "enemyKey": "newmonster",
    "state": ["restrained"],
    "corruptionStage": "low"
  },
  "orgasmDetails": {
    "stage2": {
      "low": {
        "sequence": [
          {
            "text": "やっ…だめ…っ！",
            "expression": "endure"
          },
          {
            "text": "んんっ♡ あっ…イっちゃう…っ♡",
            "expression": "confused"
          },
          {
            "text": "ああぁっ♡",
            "expression": "ahe",
            "overlays": ["restrain", "blush_high"]
          }
        ],
        "aftermath": [
          {
            "text": "はぁ…はぁ…っ",
            "expression": "confused"
          }
        ]
      }
    }
  }
}
```

### 3.4 introProfiles（挿入系のみ）

**ファイル名**: `dataEx/introProfiles/insert/newmonster_restrained_low.json`

```json
{
  "meta": {
    "profileName": "newmonster_restrained_insert_low",
    "enemyKey": "newmonster",
    "state": ["restrained", "inserted"],
    "corruptionStage": "low"
  },
  "insert": {
    "stage2": {
      "low": {
        "pre_first": [
          {
            "dialogueSequence": [
              { "text": "やっ…入ってくる…！" },
              { "text": "やだっ…やめてぇ…！" }
            ]
          }
        ],
        "pre_repeat": [
          {
            "dialogueSequence": [
              { "text": "また…入れられる…っ" }
            ]
          }
        ],
        "sequence_resist_success": [
          {
            "dialogueSequence": [
              { "text": "はぁ…はぁ…防げた…" }
            ]
          }
        ],
        "sequence_resist_fail": [
          {
            "dialogueSequence": [
              { "text": "あっ…入っちゃった…っ！" }
            ]
          }
        ],
        "sequence_accept": [
          {
            "dialogueSequence": [
              { "text": "んっ…あぁ…っ♡" }
            ]
          }
        ]
      }
    }
  }
}
```

### 3.5 overlaySets（必須）

**ファイル名**: `dataEx/overlays/overlaySets_newmonster.json`

```json
{
  "mapping": {
    "attack": {
      "pussy": {
        "soft": "attack_pussy_soft",
        "hard": "attack_pussy_hard",
        "layer": "underOverlay"
      },
      "breasts": {
        "soft": "attack_breast_soft",
        "hard": "attack_breast_hard",
        "layer": "underOverlay"
      }
    },
    "insert": {
      "pussy": {
        "soft": "insert_pussy_soft",
        "hard": "insert_pussy_hard",
        "layer": "underOverlay"
      }
    },
    "restrain": "restrain",
    "layer": "overlay"
  },

  "newmonster": {
    "base": ["newmonster_bind_base"],
    "under_attack": ["newmonster_under_attack"]
  },

  "sets": {
    "newmonster": {
      "touch_basic": ["newmonster.base", "newmonster.under_attack"]
    }
  },

  "single": {
    "L": {
      "ah_soft": ["あっ_a"],
      "ah_strong": ["あっ_b"],
      "breath_calm1": ["はぁ_a"],
      "breath_calm2": ["はぁ_b"]
    },
    "R": {
      "ah_soft": ["あっ_a"],
      "ah_strong": ["あっ_b"]
    }
  }
}
```

**mapping セクション**:
- システムが自動的にオーバーレイを解決する際のマッピング定義
- `attack` / `insert` の各攻撃タイプと部位に対応する画像キーを指定

**sets セクション**:
- 複数のオーバーレイをセットで扱う場合の定義

**single セクション**:
- 擬音の左右配置用定義
- `L`: 左側配置, `R`: 右側配置

---

## 🔄 プロファイル名の命名規則

システムは以下のパターンでプロファイル名を自動生成します：

```
{enemyKey}[_restrained][_insert]_{corruptionStage}
```

**例**:
| 状態 | プロファイル名 |
|------|---------------|
| 通常・低堕落 | `newmonster_low` |
| 拘束・低堕落 | `newmonster_restrained_low` |
| 拘束+挿入・低堕落 | `newmonster_restrained_insert_low` |
| 拘束+挿入・高堕落 | `newmonster_restrained_insert_high` |

**対応するフォルダ名**:
- `newmonster_restrained` (拘束系)
- `newmonster_restrained_insert` (挿入系)

---

## 🎯 pose の自動解決

`"pose": "auto"` を指定すると、システムが以下のルールで自動決定します：

```javascript
// 基本形式: {clothingType}_{eventType}
"uniform_react"      // 通常反応
"uniform_danger"     // 危機
"uniform_climax"     // 絶頂
"uniform_standby"    // 待機
"uniform_down_attack" // ダウン攻撃
```

**clothingType** は衣服状態で変化:
- `uniform` - 無傷
- `damaged` - 破損
- `destroyed` - 破壊

---

## 🧪 expression / overlays の自動補完

### VisualAutoFill システム

`expression` や `overlays` を省略すると、**VisualAutoFill** が自動補完します。

#### 表情の自動決定

```json
{
  "pose": "auto"
  // expression は stage・eventType から確率的に決定される
  // stage2-climax の場合: endure(25%), confused(40%), ahe(35%)
}
```

#### オーバーレイの自動構築

```json
{
  "pose": "auto"
  // overlays は以下を自動追加:
  // - 頬の赤み (stage1→blush_low, stage2→blush_mid, stage3→blush_high)
  // - 拘束 (state:["restrained"] → "restrain")
  // - 攻撃エフェクト (enemyKey・targetPart・isInserted から選択)
}
```

詳細は `dataEx/poseProfiles/README_VisualAutoFill.md` を参照。

---

## ✅ チェックリスト

新規モンスター追加時の最終チェックリスト：

### コード
- [ ] `PleasurePoseController.js` の `fallbackMap` に登録済み
- [ ] `monsterTraits.json` に特性を追加済み

### 画像
- [ ] `img/pictures/busts/{monster}_restrained/` フォルダ作成済み
- [ ] ベース画像（各pose）を配置済み
- [ ] 表情画像（normal, endure, confused, ahe）を配置済み
- [ ] オーバーレイ画像（restrain, blush系）を配置済み
- [ ] 攻撃エフェクト画像を配置済み

### データファイル
- [ ] `poseProfiles/{monster}_restrained_low.json` 作成済み
- [ ] `poseProfiles/{monster}_restrained_high.json` 作成済み
- [ ] `restraintProfiles/{monster}_restrained_low.json` 作成済み（拘束系）
- [ ] `orgasmDetailProfiles/{monster}_restrained_low.json` 作成済み
- [ ] `introProfiles/insert/{monster}_restrained_low.json` 作成済み（挿入系）
- [ ] `overlays/overlaySets_{monster}.json` 作成済み

### テスト
- [ ] ゲーム内で敵が正しく認識されるか確認
- [ ] 立ち絵が正しく表示されるか確認
- [ ] セリフが正しく表示されるか確認
- [ ] 拘束イベントが正しく動作するか確認（拘束系）
- [ ] 挿入イベントが正しく動作するか確認（挿入系）
- [ ] オーバーレイが正しく表示されるか確認

---

## 🔍 トラブルシューティング

### 立ち絵が表示されない

**原因1**: フォールバックマップに登録されていない
- `PleasurePoseController.js` の `fallbackMap` を確認

**原因2**: 画像ファイルが見つからない
- コンソールログで `[BBM-LOAD] Loading image from path:` を確認
- パスが正しいか確認

**原因3**: プロファイルが読み込まれていない
- コンソールログで `[PPC] Profile Name Determined:` を確認

### セリフが表示されない

**原因1**: プロファイルファイルのパスミス
- ファイル名が `{enemyKey}_restrained_{corruptionStage}.json` になっているか確認

**原因2**: JSONの構造ミス
- `lines.{eventType}.{targetPart}.{stageKey}.{corruptionStage}` の階層が正しいか確認

### オーバーレイが表示されない

**原因1**: `overlaySets_*.json` の mapping が不完全
- `mapping.attack` / `mapping.insert` セクションが定義されているか確認

**原因2**: 画像ファイル名の不一致
- `default_pose_overlay_{key}.png` の命名規則に従っているか確認

---

## 📚 参考資料

- `dataEx/poseProfiles/README_VisualAutoFill.md` - 自動補完システムの詳細
- `dataEx/introProfiles/insert/WRITING_GUIDE.md` - 挿入イベントの書き方
- `dataEx/overlays/overlayMappings.json` - オーバーレイの基本定義
- `js/plugins/BattleBustManager.js` - 立ち絵表示システムの実装

---

## 📝 補足: 既存モンスターを参考にする

既存のモンスターファイルを参考にすることを推奨します：

**シンプルな例**:
- `slime_restrained_low.json` - 基本構造
- `overlaySets_slime.json` - オーバーレイ定義

**複雑な例**:
- `goblin_restrained_insert_high.json` - 挿入系の完全版
- `tentacle_restrained_high.json` - 高堕落の表現

コピーして命名を変更し、セリフを書き換えるのが最も効率的です。

