# 挿入プロファイル ライティングガイド（堕落度：Low）

## 📚 全体像

挿入プロファイルは、敵キャラクターによる**挿入イベント**のセリフと演出を定義するファイルです。
プレイヤーの行動（抵抗・受容）によって、異なるストーリー分岐が展開されます。

---

## 🗂️ ファイル構造

### メタ情報 (`meta`)
プロファイルの基本設定を記述します。

```json
{
  "profileName": "tentacle_restrained_insert_low",
  "enemyKey": "tentacle",
  "state": ["restrained", "inserted"],
  "corruptionStage": "low",
  "notes": "ライター向けメモ"
}
```

---

## 📖 各ブロックの演出内容

### 1. **`pre_first`** - 初回挿入前の描写
**タイミング**: 戦闘中、初めて挿入が試みられる直前  
**演出内容**: 
- 主人公が挿入される危険に気づき、恐怖や拒絶を示す
- 「入ってくる！」という緊張感と焦燥
- 抵抗しようとする意思を見せる段階
- まだ挿入されていない状態
- 恐怖・驚愕・拒絶の感情を表現

---

### 2. **`pre_repeat`** - 2回目以降の挿入前描写
**タイミング**: 既に一度挿入を経験した後、再度挿入が試みられる直前  
**演出内容**:
- 「また…」という既視感と恐怖
- 前回の経験によるトラウマ反応
- より切実な拒絶または諦めの兆し
- 懇願と拒否の感情

---

### 3. **`sequence_resist_success`** - 抵抗成功
**タイミング**: プレイヤーが抵抗判定に成功し、挿入を防いだ時  
**演出内容**:
- 必死の抵抗が実を結び、挿入を防ぐ
- 一時的な安堵と勝利感
- 荒い呼吸、緊張からの解放
- 純粋な安堵感

---

### 4. **`sequence_resist_fail`** - 抵抗失敗
**タイミング**: 抵抗判定に失敗し、挿入されてしまった時  
**演出内容**:
- 抵抗むなしく、挿入が貫通する瞬間
- 痛み、衝撃、屈辱の混在
- 敗北感と身体的苦痛の表現
- 貫通の衝撃と動揺

---

### 5. **`sequence_accept`** - 受容
**タイミング**: プレイヤーが抵抗せず、または受け入れた時  
**演出内容**:
- 抵抗を諦め、または無意識に受け入れる
- 心理的防衛の揺らぎ
- 身体の反応と心の葛藤
- 無意識の身体反応と困惑

---

## 🎭 堕落度Low の表現特徴

### **感情表現**
- 恥じらい、戸惑い、拒否、無垢な反応
- 純粋な恐怖と困惑

### **台詞の特徴**
- 「やだ」「いや」といった素直な拒絶
- 「ドキドキする」など初々しい身体反応
- 比較的文法的に正しいセリフ

### **記号の使用**
- **❤︎マーク**: 控えめ（acceptブロックでたまに1個）
- **濁音**: ほぼなし
- **三点リーダー（…）**: 戸惑いや言葉の詰まりに使用
- **促音（っ）**: 驚きや息の詰まりに使用

---

## 🎬 Stage2 と Stage3 の違い

### **Stage2 (興奮度：中程度)**
- まだ理性がしっかり残っている段階
- 拒絶が言葉として明確に成立している
- 身体反応は現れ始めているが、自覚は薄い

### **Stage3 (興奮度：高)**
- 理性の制御が少し弱まっている
- 台詞がやや感情的になる
- 身体反応が自覚され始める
- ♡ マークが少し増える傾向

---

## 🎨 よく使う Overlays

### 挿入前（未貫通）
- `ぐちゅっ1-6_left`, `ぬちゃっ1-6_right` - ぬるぬる、準備段階の音

### 挿入時（貫通）
- `ズプッ1-6_left`, `ズポ1-6_right` - ズブズブ、挿入の音

### 拘束状態
- `restrain` - 拘束状態の表現

### 紅潮
- `blush_mid` - 中程度の赤面（Stage2）
- `blush_high` - 強い赤面（Stage3）

### 下層エフェクト
- `under_attack` - 攻撃を受けている状態

---

## 📐 表情 (expression) の種類

- `confuse` - 困惑
- `endure` - 耐える
- `ahe` - 恍惚（Stage3のacceptで使用）
- `surprised` - 驚愕
- `normal` - 通常

---

## 🔗 関連ファイル

- **poseProfiles**: ポーズ・表情の定義
- **orgasmDetailProfiles**: 絶頂時の詳細描写
- **VisualAutoFill.js**: 自動補完ロジック

---

## ⚠️ 注意事項

1. **命名規則の厳守**: `pre_first`, `pre_repeat`, `sequence_*` の形式を守る
2. **JSON 構文**: カンマやクォートの閉じ忘れに注意
3. **一貫性**: 同じ敵キャラの low/high で世界観を統一
4. **パッチサイズ**: 1ファイルあたり200行以内の修正を推奨

