# VisualAutoFill システム使用ガイド

## 概要

**VisualAutoFill** は、表情とオーバーレイを自動決定するシステムです。
JSONに手入力しなくても、stageやeventTypeからロジックで適切な表情とエフェクトを自動生成します。

## 主な機能

### 1. 表情の自動決定
- **3つの基本表情**: `endure`（耐える）/ `confused`（混乱）/ `ahe`（快楽に屈する）
- **重み付きランダム**: stage・eventTypeに応じた出現確率
- **自然な遷移**: 前の表情から自然に変化（endure → confused → ahe）
- **段階的エスカレート**: dialogueSequence内で徐々に激しくなる

### 2. オーバーレイの自動構築
- **頬の赤み**: stage に応じて自動（stage1=blush_low, stage2=blush_mid, stage3=blush_high）
- **拘束エフェクト**: isRestrained フラグで自動追加
- **エロ攻撃エフェクト**: enemyKey・targetPart・isInserted から自動選択
- **擬音**: 台詞の内容から適切な擬音を自動選択（オプション）

### 3. dialogueSequence の自動補完
- 各行の表情とオーバーレイを自動補完
- シーケンス内での自然な感情の流れを生成

---

## 使い方

### パターンA: 完全自動（最小記述）

```json
{
  "meta": {
    "profileName": "slime_restrained_insert_low",
    "enemyKey": "slime",
    "state": ["restrained", "inserted"],
    "corruptionStage": "low"
  },
  "visuals": {
    "stage2": {
      "danger": {
        "main": {
          "pose": "auto"
          // expression と overlays は自動決定
        }
      }
    }
  }
}
```

### パターンB: 部分的な上書き

```json
{
  "visuals": {
    "stage2": {
      "climax": {
        "main": {
          "pose": "auto",
          "expression": "ahe"  // ← 特定の表情を明示指定
          // overlays は自動
        }
      }
    }
  }
}
```

### パターンC: dialogueSequence の自動補完

```json
{
  "visuals": {
    "stage2": {
      "danger": {
        "main": {
          "dialogueSequence": [
            {
              "text": "やっ…だめぇ…！"
              // expression と overlays は自動
            },
            {
              "text": "んっ…あっ…やめてぇ…！",
              "expression": "confused"  // ← 特定行のみ指定も可能
              // overlays は自動
            },
            {
              "text": "あっ♡ もう…だめ…っ♡"
              // 自動で ahe になりやすい
            }
          ]
        }
      }
    }
  }
}
```

---

## 自動決定のルール

### 表情の出現確率（例：stage2-climax）

| 表情 | 確率 |
|------|------|
| endure | 25% |
| confused | 40% |
| ahe | 35% |

※ stage や eventType により確率が変化

### 表情の遷移ルール

| 前の表情 | 次の表情（確率） |
|----------|------------------|
| endure | endure(45%) / confused(40%) / ahe(10%) |
| confused | confused(35%) / ahe(38%) / endure(25%) |
| ahe | ahe(68%) / confused(25%) / endure(5%) |

### オーバーレイの構成要素

1. **頬の赤み**: stageで決定
   - stage1 → `blush_low`
   - stage2 → `blush_mid`
   - stage3 → `blush_high`

2. **拘束**: `restrained` が含まれる場合
   - → `restraint`

3. **エロ攻撃エフェクト**: enemyKey・targetPart・isInsertedで決定
   - slime + pussy + inserted → `slime.pussy.front.soft/hard`
   - goblin + inserted → `insert_1/2`
   - tentacle → `tentacle.under_attack`

---

## meta情報の推奨設定

```json
{
  "meta": {
    "profileName": "goblin_restrained_insert_low",
    "enemyKey": "goblin",           // 敵の種類（slime/goblin/tentacle等）
    "state": ["restrained", "inserted"],  // 状態フラグ
    "corruptionStage": "low"        // 堕落度（low/mid/high）
  }
}
```

### state フラグ

- `"inserted"`: 挿入状態（挿入エフェクトを自動追加）
- `"restrained"`: 拘束状態（restraintエフェクトを自動追加）

---

## カスタマイズ

### 表情の確率を調整したい場合

`js/plugins/VisualAutoFill.js` の `EXPRESSION_WEIGHTS` を編集：

```javascript
const EXPRESSION_WEIGHTS = {
  stage2: {
    climax: { 
      endure: 25,    // ← この値を変更
      confused: 40, 
      ahe: 35 
    }
  }
};
```

### 遷移ルールを調整したい場合

`EXPRESSION_TRANSITIONS` を編集：

```javascript
const EXPRESSION_TRANSITIONS = {
  confused: {
    endure: 25,
    confused: 35,
    ahe: 38  // ← confused から ahe への遷移確率
  }
};
```

---

## トラブルシューティング

### 表情が "normal" になってしまう

- `meta.enemyKey` が正しく設定されているか確認
- `expression` を明示的に指定することで回避可能

### オーバーレイが自動追加されない

- `overlays` を `null` または未指定にしていますか？
- `overlays: []` と明示すると自動補完されません

### ログで確認

コンソールログで以下を確認できます：
- `[PPC] Auto-filled expression: ...`
- `[PPC] Auto-filled overlays: ...`
- `[PPC] Auto-filling dialogueSequence...`

---

## バージョン

- **v1.0** (2024-11-19): 初版リリース
  - 重み付きランダム表情選択
  - 遷移ルールによる自然な感情変化
  - dialogueSequence 自動補完
  - オーバーレイ自動構築

---

## 関連ファイル

- `js/plugins/VisualAutoFill.js`: 自動決定システム本体
- `js/plugins/PleasurePoseController.js`: 統合処理
- `js/plugins/OverlayResolver.js`: オーバーレイ解決
- `dataEx/overlays/overlaySets_*.json`: 敵ごとのオーバーレイ定義

