# JSON変換ガイド：セリフをJSONファイルに記述する方法

このガイドでは、記入したセリフを実際のJSONファイルに変換する方法を説明します。

---

## 📋 目次

1. [基本的なJSON構造](#基本的なjson構造)
2. [拘束イベントのJSON例](#拘束イベントのjson例)
3. [挿入イベントのJSON例](#挿入イベントのjson例)
4. [絶頂イベントのJSON例](#絶頂イベントのjson例)
5. [通常戦闘反応のJSON例](#通常戦闘反応のjson例)
6. [よくあるエラーと解決方法](#よくあるエラーと解決方法)

---

## 基本的なJSON構造

### JSON記法の基本ルール

1. **文字列は必ずダブルクォート（`"`）で囲む**
2. **配列は `[...]` で囲む**
3. **オブジェクトは `{...}` で囲む**
4. **要素の間はカンマ（`,`）で区切る**
5. **最後の要素の後ろにはカンマを付けない**
6. **インデントは2スペースまたは4スペース（統一する）**

---

## 拘束イベントのJSON例

### ファイル名
```
dataEx/restraintProfiles/[敵名]_restrained_[堕落度].json
例: slime_restrained_low.json
```

### 完全な例

```json
{
  "meta": {
    "profileName": "slime_restrained_low",
    "enemyKey": "slime",
    "notes": "スライム拘束・堕落度Low"
  },
  "visuals": {
    "default": {
      "low": {
        "stage1": {
          "pre": {
            "pose": "auto",
            "expression": "surprised",
            "overlays": [
              "blush_low",
              "slime_bind_base"
            ]
          },
          "main": {
            "pose": "auto",
            "expression": "surprised",
            "overlays": [
              "blush_low",
              "slime_bind_base"
            ]
          }
        },
        "stage2": {
          "pre": {
            "pose": "auto",
            "expression": "endure_1",
            "overlays": [
              "blush_low",
              "slime_bind_base"
            ]
          },
          "main": {
            "pose": "auto",
            "expression": "endure_1",
            "overlays": [
              "blush_low",
              "slime_bind_base"
            ]
          }
        },
        "stage3": {
          "pre": {
            "pose": "auto",
            "expression": "endure_2",
            "overlays": [
              "blush_low",
              "slime_bind_base"
            ]
          },
          "main": {
            "pose": "auto",
            "expression": "endure_2",
            "overlays": [
              "blush_low",
              "slime_bind_base"
            ]
          }
        }
      }
    }
  },
  "lines": {
    "default": {
      "stage1": {
        "low": {
          "first": [
            "なっ…！？動けな…いっ！？",
            "ぴり…ぴりしてる…なに…？このスライム…！"
          ],
          "repeat": [
            "また拘束…っ！？いや…離してってば…！",
            "もしかして…これで何度も…？"
          ]
        }
      },
      "stage2": {
        "low": {
          "first": [
            "いや…やめっ…もう…イかされて……",
            "またこの拘束…今度こそ抜けなきゃ…！"
          ],
          "repeat": [
            "くっ…まだ続くの…？また…縛られて…！",
            "身体…変になる…のに…"
          ]
        }
      },
      "stage3": {
        "low": {
          "first": [
            "やだ…これ以上…動けないなんて…っ！",
            "身体が…勝手に疼いてる…！？"
          ],
          "repeat": [
            "もう…ダメ…動けなくされるの、わかってたのに…",
            "また…このビリビリ…来るって…"
          ]
        }
      }
    }
  }
}
```

### ポイント

- `"visuals"` セクション: 表情・オーバーレイの定義（通常は `"auto"` でOK）
- `"lines"` セクション: 実際のセリフを記述
- `"first"` / `"repeat"`: 配列形式でセリフを列挙

---

## 挿入イベントのJSON例

### ファイル名
```
dataEx/introProfiles/insert/[敵名]_restrained_[堕落度].json
例: slime_restrained_low.json
```

### 完全な例

```json
{
  "meta": {
    "profileName": "slime_restrained_insert_low",
    "enemyKey": "slime",
    "state": [
      "restrained",
      "inserted"
    ],
    "corruptionStage": "low",
    "notes": "スライム挿入イベント・堕落度Low"
  },
  "pre_first": {
    "stage2": {
      "low": [
        {
          "pose": "auto",
          "dialogueSequence": [
            {
              "text": "ひっ…な、なに…するつもり…っ！？"
            },
            {
              "text": "まさか…や、やめなさいよっ…！"
            },
            {
              "text": "やだっ…いやぁっ…近づかないでっ！"
            }
          ]
        }
      ]
    },
    "stage3": {
      "low": [
        {
          "pose": "auto",
          "dialogueSequence": [
            {
              "text": "やっ…だめ…やだ…また…くるのっ…！？"
            },
            {
              "text": "お願い…もう…こないでぇぇっ！"
            },
            {
              "text": "あっ…っ…怖い…いやぁぁっ！"
            }
          ]
        }
      ]
    }
  },
  "pre_repeat": {
    "stage2": {
      "low": [
        {
          "pose": "auto",
          "dialogueSequence": [
            {
              "text": "やだっ…また…来る気なの…っ！？"
            },
            {
              "text": "お願い…もう…やめてってばぁ…っ！"
            }
          ]
        }
      ]
    },
    "stage3": {
      "low": [
        {
          "pose": "auto",
          "dialogueSequence": [
            {
              "text": "やだ…また…っ…中…に…！"
            },
            {
              "text": "あっ…お願い…もう…やめてっ！"
            }
          ]
        }
      ]
    }
  },
  "sequence_resist_success": {
    "stage2": {
      "low": [
        {
          "pose": "auto",
          "dialogueSequence": [
            {
              "text": "くっ…離してっ…入れさせないっ！"
            },
            {
              "text": "いやぁっ…そんなの…絶対いやっ！"
            }
          ]
        }
      ]
    },
    "stage3": {
      "low": [
        {
          "pose": "auto",
          "dialogueSequence": [
            {
              "text": "くそっ…離して…まだ…戦える…！"
            },
            {
              "text": "やめろっ…触るなぁっ…！"
            }
          ]
        }
      ]
    }
  },
  "sequence_resist_fail": {
    "stage2": {
      "low": [
        {
          "pose": "auto",
          "dialogueSequence": [
            {
              "text": "やぁっ…っ…うそっ…なにこれっ…！"
            },
            {
              "text": "あっ…やだ…っ…奥…までぇっ！？"
            },
            {
              "text": "やめっ…ぬ、抜いてぇぇっ…っ！"
            },
            {
              "text": "ひゃあぁっ…っ…あぁぁぁっ！"
            },
            {
              "text": "くぅっ…はぁっ…っ…だめぇ…っ…"
            }
          ]
        }
      ]
    },
    "stage3": {
      "low": [
        {
          "pose": "auto",
          "dialogueSequence": [
            {
              "text": "いやっ…やっ…だめ…やめ…てぇっ！"
            },
            {
              "text": "ひっ…あっ…ぬるぬる…あぁぁっ！"
            },
            {
              "text": "うそっ…っ…そこ…まで…っ！？"
            },
            {
              "text": "あぁぁっ…っ…いやぁぁぁぁっ！"
            },
            {
              "text": "やだ…やだっ…もうやだぁっ！"
            }
          ]
        }
      ]
    }
  },
  "sequence_accept": {
    "stage2": {
      "low": [
        {
          "pose": "auto",
          "dialogueSequence": [
            {
              "text": "んっ…あっ…さっきの…感覚が…っ…！"
            },
            {
              "text": "わかんない…どうして…熱くて…！"
            },
            {
              "text": "やだ…やだのに…奥…まで…っ！"
            },
            {
              "text": "ひゃぁぁっ…っ…あぁっ…いやぁっ！"
            },
            {
              "text": "んっ…っ…涙…止まら…ないっ…！"
            }
          ]
        }
      ]
    },
    "stage3": {
      "low": [
        {
          "pose": "auto",
          "dialogueSequence": [
            {
              "text": "んっ…あっ…だめ…なのに…熱くて…！"
            },
            {
              "text": "怖い…はずなのに…体が…動く…！"
            },
            {
              "text": "ひっ…あぁっ…やぁぁっ…ぬるっ…！"
            },
            {
              "text": "あぁっ…っ…あぁぁぁぁっ！"
            },
            {
              "text": "だめ…止め…てよぉっ…！"
            }
          ]
        }
      ]
    }
  }
}
```

### ポイント

- 各ブロック（`pre_first`, `sequence_resist_fail` など）ごとに構造化
- `dialogueSequence`: セリフの配列。各セリフは `{ "text": "..." }` の形式
- `pose` は `"auto"` で自動決定

---

## 絶頂イベントのJSON例

### ファイル名
```
dataEx/orgasmDetailProfiles/[敵名]_restrained_insert_[堕落度].json
例: slime_restrained_insert_low.json
```

### 完全な例

```json
{
  "meta": {
    "profileName": "slime_restrained_insert_low",
    "enemyKey": "slime",
    "corruptionStage": "low",
    "notes": "スライム挿入絶頂・堕落度Low",
    "state": [
      "restrained",
      "inserted"
    ]
  },
  "choices": {
    "stage2": {
      "low": [
        "まだ…イかない…！",
        "もう…イっちゃう…"
      ]
    },
    "stage3": {
      "low": [
        "まだ…イかない…！",
        "もう…イっちゃう…"
      ]
    }
  },
  "sequence": {
    "stage2": {
      "low": [
        {
          "pose": "auto",
          "dialogue": "あっ…んっ…だめ…熱くて…っ…！"
        },
        {
          "pose": "auto",
          "dialogue": "はぁ…っ…奥…に…当たって…っ…！"
        },
        {
          "pose": "auto",
          "dialogue": "やめ…て…こわい…のに…っ！"
        }
      ]
    },
    "stage3": {
      "low": [
        {
          "pose": "auto",
          "dialogue": "はぁ…っ…はぁっ…もう…動かないで…っ！"
        },
        {
          "pose": "auto",
          "dialogue": "あっ…ぅっ…息…できない…っ…！"
        },
        {
          "pose": "auto",
          "dialogue": "だめ…もう…限界…なのに…っ！"
        }
      ]
    }
  },
  "after_resist": {
    "stage2": {
      "low": [
        {
          "pose": "auto",
          "dialogue": "だめ…っ…止めて…お願い…っ！"
        },
        {
          "pose": "auto",
          "dialogue": "ひっ…っ…息…できない…っ！"
        },
        {
          "pose": "auto",
          "dialogue": "あっ…んっ…奥…あたって…っ！"
        },
        {
          "pose": "auto",
          "dialogue": "あぁぁっ…っ…あぁぁぁぁっ！"
        },
        {
          "pose": "auto",
          "dialogue": "やだ…やだっ…もうやだぁっ！"
        },
        {
          "pose": "auto",
          "dialogue": "はぁっ…はぁっ…中…熱い…っ…"
        },
        {
          "pose": "auto",
          "dialogue": "だめ…抜けない…のに…まだ…！"
        }
      ]
    },
    "stage3": {
      "low": [
        {
          "pose": "auto",
          "dialogue": "やっ…あっ…んっ…やめ…っ…！"
        },
        {
          "pose": "auto",
          "dialogue": "ひゃあっ…っ…奥…当たって…っ！"
        },
        {
          "pose": "auto",
          "dialogue": "はぁ…っ…涙…止まら…ない…っ！"
        },
        {
          "pose": "auto",
          "dialogue": "あぁっ…あぁぁぁぁっ…あぁぁぁっ！"
        },
        {
          "pose": "auto",
          "dialogue": "だめ…っ…こんな…のに…っ！"
        },
        {
          "pose": "auto",
          "dialogue": "はぁ…っ…ひくっ…体…動く…っ…"
        },
        {
          "pose": "auto",
          "dialogue": "もう…お願い…ゆるして…っ…"
        }
      ]
    }
  },
  "after_fall": {
    "stage2": {
      "low": [
        {
          "pose": "auto",
          "dialogue": "んっ…ぅっ…やだ…止まらない…っ！"
        },
        {
          "pose": "auto",
          "dialogue": "こわい…のに…声…出ちゃう…っ！"
        },
        {
          "pose": "auto",
          "dialogue": "ひゃぁっ…っ…あぁぁぁぁっ！"
        },
        {
          "pose": "auto",
          "dialogue": "あぁ…っ…っ…やだぁぁぁっ！"
        },
        {
          "pose": "auto",
          "dialogue": "はぁっ…はぁぁ…涙…止まら…ない…"
        },
        {
          "pose": "auto",
          "dialogue": "怖い…のに…また…震えて…る…っ…"
        }
      ]
    },
    "stage3": {
      "low": [
        {
          "pose": "auto",
          "dialogue": "んっ…はぁっ…ぅっ…怖い…のに…！"
        },
        {
          "pose": "auto",
          "dialogue": "体…止まら…ない…のぉっ…！"
        },
        {
          "pose": "auto",
          "dialogue": "あっ…っ…あぁぁぁっ…あぁぁぁっ！"
        },
        {
          "pose": "auto",
          "dialogue": "ひぃっ…っ…涙…止まら…ないっ…！"
        },
        {
          "pose": "auto",
          "dialogue": "こわい…のに…体…熱くて…っ…"
        },
        {
          "pose": "auto",
          "dialogue": "だめ…もう…壊れ…ちゃう…っ…"
        }
      ]
    }
  }
}
```

### ポイント

- `choices`: プレイヤーの選択肢（文字列の配列）
- `sequence`: 絶頂前の描写
- `after_resist`: 我慢を選んだ後
- `after_fall`: 受容を選んだ後
- `dialogue` キーで1行ずつセリフを定義

---

## 通常戦闘反応のJSON例

### ファイル名
```
dataEx/poseProfiles/[敵名]_restrained_[堕落度].json
例: slime_restrained_low.json
```

### 完全な例（一部抜粋）

```json
{
  "meta": {
    "profileName": "slime_restrained_low",
    "enemyKey": "slime",
    "state": [
      "restrained"
    ],
    "corruptionStage": "low",
    "notes": "スライム拘束中の通常反応・堕落度Low"
  },
  "visuals": {
    "stage1": {
      "react": {
        "pre": {
          "pose": "auto"
        },
        "main": {
          "pose": "auto"
        }
      },
      "danger": {
        "pre": {
          "pose": "auto"
        },
        "main": {
          "pose": "auto"
        }
      },
      "climax": {
        "pre": {
          "pose": "auto"
        },
        "main": {
          "pose": "auto"
        }
      }
    }
  },
  "lines": {
    "react": {
      "breast": {
        "stage1": {
          "low": [
            {
              "dialogueSequence": [
                {
                  "text": "ひっ…ぬ、ぬるぬるして気持ち悪い…っ！"
                },
                {
                  "text": "んっ…くぅ…っ…やだ…触るなぁ…！"
                },
                {
                  "text": "離せってば…っ、この変態スライム！"
                }
              ]
            }
          ]
        }
      }
    },
    "danger": {
      "breast": {
        "stage1": {
          "low": [
            {
              "dialogueSequence": [
                {
                  "text": "やっ…いやぁ…っ、そんなとこ…！"
                },
                {
                  "text": "んんっ…うぅ…っ…だめっ…気持ち悪い…！"
                },
                {
                  "text": "くそ…ふざけるな…絶対負けないっ！"
                }
              ]
            }
          ]
        },
        "stage2": {
          "low": {
            "resist": [
              {
                "dialogueSequence": [
                  {
                    "text": "ひっ…そんなに…こすられたら…！"
                  },
                  {
                    "text": "んんっ♡　や…っだめ♡　あぁんっ♡"
                  },
                  {
                    "text": "スライム風情に…屈するもんかっ！"
                  }
                ],
                "log": "拒絶の言葉を叫び続け、まだ強がりを崩さない。"
              }
            ],
            "fall": [
              {
                "dialogueSequence": [
                  {
                    "text": "ひっ…ぬるぬるで…やだのに…熱い…っ"
                  },
                  {
                    "text": "ひゃぁあっ♡　んあぁっ♡　止まんないっ♡"
                  },
                  {
                    "text": "やだ…っ…こんな反応…したくないのに…！"
                  }
                ],
                "log": "抗うほどに声は甘く、否定が弱くなっていく。"
              }
            ]
          }
        }
      }
    },
    "climax": {
      "breast": {
        "stage1": {
          "low": [
            {
              "dialogueSequence": [
                {
                  "text": "やだ…やめろ…っ、ぞわぞわして…っ！"
                },
                {
                  "text": "んっ…くぅっ…っ…だめだってば…っ！"
                },
                {
                  "text": "スライムごときに…屈するもんかっ！"
                }
              ]
            }
          ]
        },
        "stage2": {
          "low": {
            "resist": [
              {
                "dialogueSequence": [
                  {
                    "text": "だめっ…気持ちよくなんて…なるわけ…！"
                  },
                  {
                    "text": "あぁんっ♡ひゃあっ♡やっ…♡"
                  },
                  {
                    "text": "くそ…絶対…認めたりしない…っ！"
                  }
                ],
                "log": "快感に追い込まれても強がりを崩さない。"
              }
            ],
            "fall": [
              {
                "dialogueSequence": [
                  {
                    "text": "や…だめ…もう…身体が熱くて…っ"
                  },
                  {
                    "text": "んあぁっ♡あっ♡止まらないぃっ♡"
                  },
                  {
                    "text": "も、もうムリ…っ♡ また来ちゃうっ♡"
                  }
                ],
                "log": "言葉は拒絶し続けるが、甘声が理性を裏切っていた。"
              }
            ]
          }
        }
      }
    }
  }
}
```

### ポイント

- `lines` の中に `react`, `danger`, `climax`, `down_attack` などの状況別セクション
- 各状況に `breast`（部位）のセクション
- `resist` / `fall` で分岐（Stage2以降）
- `log` フィールドで状況説明を追加可能（オプション）

---

## よくあるエラーと解決方法

### ❌ エラー1：カンマの付け忘れ

**間違い**:
```json
{
  "text": "やだっ…いやぁっ…！"
  "text": "近づかないでっ！"
}
```

**正しい**:
```json
{
  "text": "やだっ…いやぁっ…！"
},
{
  "text": "近づかないでっ！"
}
```

---

### ❌ エラー2：最後の要素の後にカンマがある

**間違い**:
```json
[
  "セリフ1",
  "セリフ2",
]
```

**正しい**:
```json
[
  "セリフ1",
  "セリフ2"
]
```

---

### ❌ エラー3：ダブルクォートが閉じていない

**間違い**:
```json
{
  "text": "やだっ…いやぁっ…！
}
```

**正しい**:
```json
{
  "text": "やだっ…いやぁっ…！"
}
```

---

### ❌ エラー4：セリフ内にダブルクォートを使いたい場合

セリフ内で引用符を使いたい場合は、バックスラッシュ（`\`）でエスケープします。

**例**:
```json
{
  "text": "彼女は「やめて」と叫んだ"
}
```

ただし、日本語の場合は `「」` を使えば問題ありません。

---

### ❌ エラー5：改行を入れたい場合

**間違い**:
```json
{
  "text": "やだっ…
いやぁっ…！"
}
```

JSONでは実際の改行は使えません。改行を表現したい場合は `\n` を使います。

**正しい**:
```json
{
  "text": "やだっ…\nいやぁっ…！"
}
```

ただし、**このゲームシステムでは基本的にセリフ内改行は不要**です。

---

## 🛠️ JSON検証ツール

作成したJSONファイルが正しいかチェックするツール：

1. **オンラインツール**: [JSONLint](https://jsonlint.com/)
2. **VSCode拡張機能**: JSON Tools
3. **コマンドライン**: `node -e "require('./ファイル名.json')"`

---

## ✅ 作成後のチェックリスト

- [ ] 全てのダブルクォートが閉じられている
- [ ] カンマが正しく配置されている
- [ ] 最後の要素の後にカンマがない
- [ ] 括弧 `{}` `[]` が正しく対応している
- [ ] ファイル名が正しい（命名規則に従っている）
- [ ] `meta` セクションが正しく記述されている
- [ ] セリフの数が仕様書通りである

---

## 📞 サポート

JSON変換で困った場合は、既存の正常なファイル（例: `slime_restrained_low.json`）を参考にしてください。

**作成日**: 2025-11-25  
**バージョン**: 1.0

