# 命名規則ガイドライン

## 概要

本プロジェクトにおける画像ファイルとコードの命名規則を定義します。
統一された命名規則により、保守性・拡張性・可読性が向上します。

---

## 📋 目次

1. [Overlay画像の命名規則](#overlay画像の命名規則)
2. [SFX画像の命名規則](#sfx画像の命名規則)
3. [表情画像の命名規則](#表情画像の命名規則)
4. [ベース画像の命名規則](#ベース画像の命名規則)
5. [フォルダ構造](#フォルダ構造)
6. [コード定義の命名規則](#コード定義の命名規則)
7. [新規モンスター追加時のチェックリスト](#新規モンスター追加時のチェックリスト)

---

## 1. Overlay画像の命名規則

### 基本フォーマット

```
default_pose_overlay_{type}_{part}_{intensity}.png
```

### パラメータ定義

| パラメータ | 説明 | 使用可能な値 |
|-----------|------|-------------|
| `{type}` | エフェクトの種類 | `attack`, `insert`, `restrain` |
| `{part}` | 対象部位 | `breast`, `pussy`, `hip` |
| `{intensity}` | 強度 | `soft`, `hard` |

### 具体例

#### 攻撃エフェクト（非挿入時）

```
default_pose_overlay_attack_breast_soft.png   // 胸攻撃（弱）
default_pose_overlay_attack_breast_hard.png   // 胸攻撃（強）
default_pose_overlay_attack_pussy_soft.png    // 膣攻撃（弱）
default_pose_overlay_attack_pussy_hard.png    // 膣攻撃（強）
default_pose_overlay_attack_hip_soft.png      // 腰攻撃（弱）※将来用
default_pose_overlay_attack_hip_hard.png      // 腰攻撃（強）※将来用
```

#### 挿入エフェクト

```
default_pose_overlay_insert_pussy_soft.png    // 挿入（弱）
default_pose_overlay_insert_pussy_hard.png    // 挿入（強）
```

#### 拘束エフェクト

```
default_pose_overlay_restrain.png             // 拘束（強度なし）
```

### 特殊なケース

#### モンスター固有のエフェクト

デフォルトの命名規則に従いつつ、モンスター名をプレフィックスとして追加可能：

```
default_pose_overlay_slime_special_soft.png   // スライム専用エフェクト
default_pose_overlay_dragon_fire_hard.png     // ドラゴン専用エフェクト
```

**注意**: 可能な限りデフォルト命名規則を使用し、特殊なケースのみ個別命名を使用してください。

---

## 2. SFX画像の命名規則

### 基本フォーマット

```
default_pose_overlay_{sfx_name}_{direction}.png
```

### パラメータ定義

| パラメータ | 説明 | 使用可能な値 |
|-----------|------|-------------|
| `{sfx_name}` | 擬音の種類 | `ズプッ1-6`, `ぬちょっ1-6`, `ぐちゃ1-6` など |
| `{direction}` | 表示位置 | `left`, `right` |

### 具体例

```
default_pose_overlay_ズプッ1-6_left.png        // 挿入音（左）
default_pose_overlay_ズプッ1-6_right.png       // 挿入音（右）
default_pose_overlay_ぬちょっ1-6_left.png      // ピストン音（左）
default_pose_overlay_ぬちょっ1-6_right.png     // ピストン音（右）
default_pose_overlay_ズポ1-6_left.png          // 深い挿入音（左）
default_pose_overlay_ズポ1-6_right.png         // 深い挿入音（右）
default_pose_overlay_ぬちゃっ1-6_left.png      // 愛撫音（左）
default_pose_overlay_ぬちゃっ1-6_right.png     // 愛撫音（右）
default_pose_overlay_ぐちゃ1-6_left.png        // 絶頂音（左）
default_pose_overlay_ぐちゃ1-6_right.png       // 絶頂音（右）
```

### SFXの種類

| SFXタイプ | ファイル名 | 用途 |
|----------|-----------|------|
| `insert_entry` | `ズプッ1-6` | 挿入直後 |
| `insert_piston` | `ぬちょっ1-6` | ピストン（弱） |
| `insert_deep` | `ズポ1-6` | ピストン（強） |
| `rub_pussy` | `ぬちゃっ1-6` | 膣愛撫 |
| `rub_breast` | `ぬちゃっ1-6` | 胸愛撫 |
| `orgasm` | `ぐちゃ1-6` | 絶頂 |
| `liquid` | `ぐちゃ1-6` | 液体音 |

**注意**: SFX画像は全モンスター共通です。各モンスターのフォルダに同じファイル名で配置してください。

---

## 3. 表情画像の命名規則

### 基本フォーマット

```
default_pose_face_{expression}.png
default_pose_face_{expression}_{variant}.png
```

### パラメータ定義

| パラメータ | 説明 | 使用可能な値 |
|-----------|------|-------------|
| `{expression}` | 表情の種類 | `normal`, `endure`, `confused`, `ahe`, `surprised`, `embarrassed` など |
| `{variant}` | バリエーション番号 | `2`, `3` など（オプション） |

### 具体例

#### 拘束時の表情

```
default_pose_face_normal.png        // 通常
default_pose_face_endure.png        // 耐える
default_pose_face_endure_2.png      // 耐える（バリエーション2）
default_pose_face_endure_3.png      // 耐える（バリエーション3）
default_pose_face_confused.png      // 混乱
default_pose_face_ahe.png           // アヘ顔
default_pose_face_ahe_2.png         // アヘ顔（バリエーション2）
default_pose_face_surprised.png     // 驚き
```

#### 非拘束時の表情

```
default_pose_face_normal.png        // 通常
default_pose_face_embarrassed.png   // 恥ずかしい
```

### 表情の種類

| 表情タイプ | 用途 | 使用状況 |
|----------|------|---------|
| `normal` | 通常 | 非拘束時 |
| `embarrassed` | 恥ずかしい | 非拘束時 |
| `endure` | 耐える | 拘束時・Stage1 |
| `confused` | 混乱 | 拘束時・Stage2 |
| `ahe` | アヘ顔 | 拘束時・Stage3 |
| `surprised` | 驚き | 拘束時・挿入時 |
| `angry` | 怒り | 特殊 |
| `crying` | 泣き | 特殊 |

---

## 4. ベース画像の命名規則

### 基本フォーマット

```
{clothing_state}_base.png
```

### パラメータ定義

| パラメータ | 説明 | 使用可能な値 |
|-----------|------|-------------|
| `{clothing_state}` | 服の状態 | `uniform_intact`, `uniform_damaged`, `uniform_destroyed` |

### 具体例

```
uniform_intact_base.png      // 服が無傷
uniform_damaged_base.png     // 服が破損
uniform_destroyed_base.png   // 服が破壊
```

### ポーズバリエーション

```
restrained_pose1_base.png    // 拘束ポーズ1
restrained_pose2_base.png    // 拘束ポーズ2
restrained_pose6_base.png    // 拘束ポーズ6
```

---

## 5. フォルダ構造

### 標準的なフォルダ構造

```
img/pictures/busts/
  ├── {monster}_restrained/
  │   ├── default_pose_face_*.png           // 表情
  │   ├── default_pose_overlay_*.png        // オーバーレイ・SFX
  │   ├── uniform_*_base.png                // ベース画像
  │   └── restrained_pose*_base.png         // ポーズバリエーション
  │
  ├── slime_restrained/
  ├── goblin_restrained/
  └── tentacle_restrained/
```

### モンスター名の命名規則

```
{monster_name}_restrained
```

**例**:
- `slime_restrained`
- `goblin_restrained`
- `tentacle_restrained`
- `dragon_restrained`（将来）

---

## 6. コード定義の命名規則

### OverlaySets のキー名

```javascript
window.OverlaySets = {
  slime: { /* ... */ },      // モンスター名（小文字、アンダースコアなし）
  goblin: { /* ... */ },
  tentacle: { /* ... */ }
};
```

**ルール**:
- 小文字のみ
- アンダースコア不使用
- フォルダ名の `_restrained` を除いた部分

### マッピング定義

```javascript
mapping: {
  restrain: "restrain",
  attack: {
    breast: {
      soft: "attack_breast_soft",
      hard: "attack_breast_hard",
      layer: "overlay"
    }
  },
  insert: {
    pussy: {
      soft: "insert_pussy_soft",
      hard: "insert_pussy_hard",
      layer: "underOverlay"
    }
  }
}
```

**ルール**:
- キー名: 小文字、アンダースコア使用
- 値: 画像ファイル名（拡張子・プレフィックス除く）

### SFX定義

```javascript
sfx: {
  insert_entry:  "default_pose_overlay_ズプッ1-6",
  insert_piston: "default_pose_overlay_ぬちょっ1-6",
  insert_deep:   "default_pose_overlay_ズポ1-6",
  rub_pussy:     "default_pose_overlay_ぬちゃっ1-6",
  rub_breast:    "default_pose_overlay_ぬちゃっ1-6",
  orgasm:        "default_pose_overlay_ぐちゃ1-6",
  liquid:        "default_pose_overlay_ぐちゃ1-6"
}
```

**ルール**:
- キー名: 小文字、アンダースコア使用
- 値: 画像ファイル名（`_left`/`_right` と拡張子を除く）

---

## 7. 新規モンスター追加時のチェックリスト

### ステップ1: フォルダ作成

```
img/pictures/busts/{monster}_restrained/
```

### ステップ2: 必須画像の配置

#### 表情（6-8ファイル）

- [ ] `default_pose_face_normal.png`
- [ ] `default_pose_face_endure.png`
- [ ] `default_pose_face_confused.png`
- [ ] `default_pose_face_ahe.png`
- [ ] `default_pose_face_surprised.png`
- [ ] `default_pose_face_embarrassed.png`（非拘束用）

#### オーバーレイ（6ファイル）

- [ ] `default_pose_overlay_attack_breast_soft.png`
- [ ] `default_pose_overlay_attack_breast_hard.png`
- [ ] `default_pose_overlay_attack_pussy_soft.png`
- [ ] `default_pose_overlay_attack_pussy_hard.png`
- [ ] `default_pose_overlay_insert_pussy_soft.png`
- [ ] `default_pose_overlay_insert_pussy_hard.png`

#### 拘束（1ファイル）

- [ ] `default_pose_overlay_restrain.png`

#### 頬染め（3ファイル）

- [ ] `default_pose_overlay_blush_low.png`
- [ ] `default_pose_overlay_blush_mid.png`
- [ ] `default_pose_overlay_blush_high.png`

#### SFX（10ファイル）

- [ ] `default_pose_overlay_ズプッ1-6_left.png`
- [ ] `default_pose_overlay_ズプッ1-6_right.png`
- [ ] `default_pose_overlay_ぬちょっ1-6_left.png`
- [ ] `default_pose_overlay_ぬちょっ1-6_right.png`
- [ ] `default_pose_overlay_ズポ1-6_left.png`
- [ ] `default_pose_overlay_ズポ1-6_right.png`
- [ ] `default_pose_overlay_ぬちゃっ1-6_left.png`
- [ ] `default_pose_overlay_ぬちゃっ1-6_right.png`
- [ ] `default_pose_overlay_ぐちゃ1-6_left.png`
- [ ] `default_pose_overlay_ぐちゃ1-6_right.png`

#### ベース画像（3ファイル）

- [ ] `uniform_intact_base.png`
- [ ] `uniform_damaged_base.png`
- [ ] `uniform_destroyed_base.png`

### ステップ3: コード追加

```javascript
// js/plugins/VisualOverlayData.js
window.OverlaySets = {
  // ... 既存のモンスター
  
  newMonster: {
    // mappingは省略 = DEFAULT_OVERLAYを使用
    // sfxは省略 = DEFAULT_SFXを使用
  }
};
```

**必要なコード**: **0行**（デフォルトを使用）

### ステップ4: 動作確認

- [ ] ゲームを起動
- [ ] コンソールでエラーがないか確認
- [ ] 戦闘開始
- [ ] 拘束される
- [ ] エロ攻撃を受ける
- [ ] 表情が変化するか確認
- [ ] オーバーレイが表示されるか確認
- [ ] SFXが表示されるか確認

---

## 8. 命名規則違反の例

### ❌ 悪い例

```
// モンスター固有の名前を使用
slime_breast_low.png          // NG: モンスター名を含む
rub_1.png                     // NG: 意味が不明確
insert_1.png                  // NG: 部位が不明

// プレフィックスの欠落
attack_breast_soft.png        // NG: default_pose_overlay_ がない

// 不統一な命名
attack_breast_weak.png        // NG: soft/hard ではなく weak を使用
breast_attack_soft.png        // NG: 順序が逆
```

### ✅ 良い例

```
default_pose_overlay_attack_breast_soft.png   // OK: 統一された命名
default_pose_overlay_attack_pussy_hard.png    // OK: 統一された命名
default_pose_overlay_insert_pussy_soft.png    // OK: 統一された命名
```

---

## 9. 例外ケース

### 特殊なエフェクトが必要な場合

```javascript
// コードで個別定義
dragon: {
  mapping: {
    attack: {
      breast: {
        soft: "dragon_fire_weak",   // ドラゴン専用
        hard: "dragon_fire_strong"
      }
    }
    // 他はDEFAULT_OVERLAYを使用
  }
}
```

**画像ファイル名**:
```
default_pose_overlay_dragon_fire_weak.png
default_pose_overlay_dragon_fire_strong.png
```

---

## 10. 参考資料

- `docs/OVERLAY_NAMING_CONVENTION.md` - リネーム記録
- `docs/SFX_ABSTRACTION_GUIDE.md` - SFX抽象化ガイド
- `docs/VISUAL_AUTOFILL_ARCHITECTURE.md` - システム全体のアーキテクチャ
- `js/plugins/VisualOverlayData.js` - データ定義
- `js/plugins/OverlayBuilder.js` - オーバーレイ構築ロジック

---

## 11. バージョン履歴

| バージョン | 日付 | 変更内容 |
|-----------|------|---------|
| 1.0 | 2025-11-25 | 初版作成 |
| 1.1 | 2025-11-25 | Goblin の pussy 画像追加に対応 |

---

## 12. まとめ

### 命名規則の3原則

1. **統一性**: 全てのファイルが同じパターンに従う
2. **明確性**: ファイル名から用途が明確に分かる
3. **拡張性**: 新しいモンスターやエフェクトを追加しやすい

### 統一された命名規則のメリット

- ✅ 新モンスター追加が容易（コード0行）
- ✅ ファイル管理が簡単
- ✅ バグが減る
- ✅ チーム開発がしやすい
- ✅ 将来の自分が理解しやすい

**この命名規則を守ることで、プロジェクトの保守性が大幅に向上します！**

