# Overlay命名規則とリネーム記録

## 概要

2025年11月25日、Overlayファイル名を統一し、コードの抽象化を実施しました。

## 統一命名規則

### 攻撃エフェクト（非挿入時）

```
default_pose_overlay_attack_breast_soft.png   // 胸攻撃（弱）
default_pose_overlay_attack_breast_hard.png   // 胸攻撃（強）
default_pose_overlay_attack_pussy_soft.png    // 膣攻撃（弱）※将来用
default_pose_overlay_attack_pussy_hard.png    // 膣攻撃（強）※将来用
```

### 挿入エフェクト

```
default_pose_overlay_insert_pussy_soft.png    // 挿入（弱）
default_pose_overlay_insert_pussy_hard.png    // 挿入（強）
```

### 拘束エフェクト

```
default_pose_overlay_restrain.png             // 拘束（既に統一済み）
```

---

## リネーム記録

### Slime（4ファイル）

| 旧ファイル名 | 新ファイル名 | 日付 |
|-------------|-------------|------|
| `default_pose_overlay_slime_breast_low.png` | `default_pose_overlay_attack_breast_soft.png` | 2025-11-25 |
| `default_pose_overlay_slime_breast_high.png` | `default_pose_overlay_attack_breast_hard.png` | 2025-11-25 |
| `default_pose_overlay_slime_pussy_back_1.png` | `default_pose_overlay_insert_pussy_soft.png` | 2025-11-25 |
| `default_pose_overlay_slime_pussy_all.png` | `default_pose_overlay_insert_pussy_hard.png` | 2025-11-25 |

### Goblin（4ファイル）

| 旧ファイル名 | 新ファイル名 | 日付 |
|-------------|-------------|------|
| `default_pose_overlay_rub_1.png` | `default_pose_overlay_attack_breast_soft.png` | 2025-11-25 |
| `default_pose_overlay_rub_2.png` | `default_pose_overlay_attack_breast_hard.png` | 2025-11-25 |
| `default_pose_overlay_insert_1.png` | `default_pose_overlay_insert_pussy_soft.png` | 2025-11-25 |
| `default_pose_overlay_insert_2.png` | `default_pose_overlay_insert_pussy_hard.png` | 2025-11-25 |

### Tentacle（未実装）

Tentacleの画像は未整備のため、リネーム対象外。

---

## コード変更

### DEFAULT_OVERLAY 定義

`js/plugins/VisualOverlayData.js` に追加：

```javascript
const DEFAULT_OVERLAY = {
  restrain: "restrain",
  attack: {
    breast: {
      soft: "attack_breast_soft",
      hard: "attack_breast_hard",
      layer: "overlay"
    },
    pussy: {
      soft: "attack_breast_soft",  // 非挿入時は胸と同じ画像を使用
      hard: "attack_breast_hard",
      layer: "overlay"
    }
  },
  insert: {
    pussy: {
      soft: "insert_pussy_soft",
      hard: "insert_pussy_hard",
      layer: "underOverlay"
    }
  },
  layer: "overlay"
};

window.DEFAULT_OVERLAY = DEFAULT_OVERLAY;
```

### Goblin の簡略化

```javascript
// Before（18行）
goblin: {
  mapping: {
    restrain: "restrain",
    attack: {
      breast: { soft: "rub_1", hard: "rub_2", layer: "overlay" },
      pussy: { soft: "rub_1", hard: "rub_2", layer: "overlay" }
    },
    insert: {
      pussy: { soft: "insert_1", hard: "insert_2", layer: "underOverlay" }
    },
    layer: "overlay"
  }
}

// After（2行）
goblin: {
  // mappingは省略 = DEFAULT_OVERLAYを使用
}
```

**コード削減**: 16行削減（89%削減）

### OverlayBuilder.js の修正

```javascript
// デフォルトマッピングとのマージ機能を追加
const enemyMapping = enemySets?.mapping;
const defaultMapping = window.DEFAULT_OVERLAY;
const mapping = enemyMapping || defaultMapping;
```

---

## 効果

### コード削減

| モンスター | Before | After | 削減 |
|-----------|--------|-------|------|
| Slime | 70行 | 70行 | 0行（sequence含むため） |
| Goblin | 18行 | 2行 | **16行（89%削減）** |
| Tentacle | 16行 | 2行 | **14行（88%削減）** |
| **合計** | **104行** | **74行** | **30行（29%削減）** |

### 新モンスター追加コスト

- **Before**: 15-20行のコピペ
- **After**: **0行**（画像をコピーするだけ）

### 画像修正コスト

- **Before**: 各モンスターのフォルダで修正（3箇所）
- **After**: 各モンスターのフォルダで修正（3箇所）※変わらず

**注**: 画像は各モンスターのフォルダに配置されるため、修正コストは変わらない。
ただし、ファイル名が統一されているため、どのファイルを修正すべきか明確。

---

## 将来の拡張

### 新モンスター追加手順

1. 画像フォルダ作成: `img/pictures/busts/newMonster_restrained/`
2. 画像をコピー:
   - `default_pose_overlay_attack_breast_soft.png`
   - `default_pose_overlay_attack_breast_hard.png`
   - `default_pose_overlay_insert_pussy_soft.png`
   - `default_pose_overlay_insert_pussy_hard.png`
   - `default_pose_overlay_restrain.png`
   - SFX画像（10ファイル）
3. コード追加: **0行**（自動的にDEFAULT_OVERLAYを使用）

### 特殊な画像が必要な場合

```javascript
dragon: {
  mapping: {
    attack: {
      breast: {
        soft: "dragon_fire_weak",  // ドラゴン専用
        hard: "dragon_fire_strong"
      }
    }
    // 他はDEFAULT_OVERLAYを使用
  }
}
```

---

## 注意事項

### Tentacle について

Tentacleの画像は未整備のため、今回のリネーム対象外です。
将来的にTentacleの画像を整備する際は、以下の命名規則に従ってください：

```
default_pose_overlay_attack_breast_soft.png
default_pose_overlay_attack_breast_hard.png
default_pose_overlay_insert_pussy_soft.png
default_pose_overlay_insert_pussy_hard.png
```

### 既存のコード

既存のコード（Slime）は、互換性のため個別定義を残しています。
将来的に削除して `DEFAULT_OVERLAY` に統一することも可能です。

---

## 参考資料

- `docs/SFX_ABSTRACTION_GUIDE.md` - SFX抽象化ガイド
- `docs/VISUAL_AUTOFILL_ARCHITECTURE.md` - システム全体のアーキテクチャ
- `js/plugins/VisualOverlayData.js` - データ定義
- `js/plugins/OverlayBuilder.js` - オーバーレイ構築ロジック

