# ライター向けドキュメント一覧

このフォルダには、エロ演出のセリフ作成に必要なすべてのドキュメントが含まれています。

---

## 📚 ドキュメント構成

### 1. **システムフローとセリフ仕様** ⭐ 必読
**ファイル名**: `WRITER_GUIDE_システムフローとセリフ仕様.md`

**内容**:
- システム全体の流れ
- 堕落度システムの説明
- 必要なセリフの種類と行数
- 各イベントの詳細仕様
- セリフ作成ガイドライン

**こんな人におすすめ**:
- 初めてセリフを作成する人
- システム全体を理解したい人
- 必要なセリフ数を知りたい人

---

### 2. **セリフ記入用テンプレート** ⭐ 作業用
**ファイル名**: `TEMPLATE_セリフ記入用テンプレート.md`

**内容**:
- セリフを記入するための空のテンプレート
- チェックリスト付き

**使い方**:
1. このファイルをコピーして作業用ファイルを作成
2. 各セクションにセリフを記入
3. 完成したら JSON 変換ガイドを参考に JSON ファイル化

**こんな人におすすめ**:
- 実際にセリフを書く人
- 整理しながら作業したい人

---

### 3. **JSON変換ガイド**
**ファイル名**: `JSON変換ガイド.md`

**内容**:
- セリフをJSONファイルに変換する方法
- 完全なJSONサンプル
- よくあるエラーと解決方法

**こんな人におすすめ**:
- テンプレートに記入したセリフをJSONにする人
- JSONの書き方がわからない人
- エラーが出て困っている人

---

## 🚀 作業の流れ

```
【ステップ1】理解する
    ↓
WRITER_GUIDE_システムフローとセリフ仕様.md を読む
    ↓
システムの全体像、必要なセリフの種類・量を把握

【ステップ2】セリフを書く
    ↓
TEMPLATE_セリフ記入用テンプレート.md をコピー
    ↓
各セクションにセリフを記入
    ↓
堕落度・Stage別の表現ルールに従う

【ステップ3】JSON化する
    ↓
JSON変換ガイド.md を参照
    ↓
記入したセリフをJSONファイルに変換
    ↓
JSONLintなどで文法チェック

【ステップ4】確認・提出
    ↓
チェックリストで確認
    ↓
完成！
```

---

## 📊 セリフ作成の全体像

### 作成するファイル

1キャラクター × 1敵 × 1堕落度あたり、以下の4種類のファイルが必要です：

| ファイル種別 | 保存先 | 行数目安 |
|--------------|--------|----------|
| **拘束イベント** | `dataEx/restraintProfiles/` | 36行 |
| **挿入イベント** | `dataEx/introProfiles/insert/` | 54行 |
| **絶頂イベント** | `dataEx/orgasmDetailProfiles/` | 36行 |
| **通常戦闘反応** | `dataEx/poseProfiles/` | 37行 |
| **フレーバー** | `dataEx/flavor/` | 4テキスト |
| **合計** | | **約163行 + 4テキスト** |

### 堕落度3段階（Low / Mid / High）全て対応する場合

**約490行 + 12テキスト**

---

## 🎨 セリフ作成のポイント

### 堕落度別の特徴

| 堕落度 | 感情 | 記号 | 例 |
|--------|------|------|-----|
| **Low** | 拒絶・恐怖・戸惑い | ♡控えめ | 「やだっ…いやぁっ…！」 |
| **Mid** | 葛藤・心身の矛盾 | ♡中程度 | 「いや…なのに…気持ちいい…♡」 |
| **High** | 受容・恍惚・渇望 | ♡多用 | 「もっとぉ♡もっと♡」 |

### Stage別の特徴

| Stage | 状態 | 特徴 |
|-------|------|------|
| **Stage1** | 平常時 | 冷静、長文OK |
| **Stage2** | 興奮中 | やや感情的、理性残る |
| **Stage3** | 興奮高 | 感情的、途切れがち、喘ぎ多い |

---

## 🔍 参考資料

### 既存のサンプルファイル

実際のJSONファイルを見たい場合は、以下を参照してください：

#### 拘束イベント
- `dataEx/restraintProfiles/slime_restrained_low.json`
- `dataEx/restraintProfiles/goblin_restrained_low.json`

#### 挿入イベント
- `dataEx/introProfiles/insert/slime_restrained_low.json`
- `dataEx/introProfiles/insert/goblin_restrained_low.json`

#### 絶頂イベント
- `dataEx/orgasmDetailProfiles/slime_restrained_insert_low.json`
- `dataEx/orgasmDetailProfiles/goblin_restrained_insert_low.json`

#### 通常戦闘反応
- `dataEx/poseProfiles/slime_restrained_low.json`
- `dataEx/poseProfiles/goblin_restrained_low.json`

#### フレーバーテキスト
- `dataEx/flavor/flavorRules.json`

### 既存のライティングガイド

プロジェクト内にある既存のガイドも参考になります：

- `dataEx/introProfiles/insert/WRITING_GUIDE.md` - 挿入イベント専用ガイド
- `dataEx/poseProfiles/README_VisualAutoFill.md` - ビジュアル自動補完の説明

---

## ⚠️ 重要な注意事項

### JSON構文ルール

1. **文字列は必ずダブルクォート（`"`）で囲む**
2. **要素の間はカンマ（`,`）で区切る**
3. **最後の要素の後にカンマを付けない**
4. **括弧の対応を確認する**

### リポジトリルール

- **パッチサイズ**: 1ファイルあたり200行以内の修正推奨
- **編集可能**: `**/*.js`, `dataEx/**/*.json`, `tools/**/*.*`
- **編集禁止**: `img/**`, `www/audio/**`, `www/movies/**`, `www/save/**`

---

## 📞 質問・サポート

### よくある質問

**Q1: セリフの長さはどのくらいが適切ですか？**  
A: Stage1は20〜40文字、Stage2は15〜30文字、Stage3は10〜25文字程度が目安です。興奮度が高いほど短く途切れがちに。

**Q2: ♡マークはどのくらい使えばいいですか？**  
A: Low（0〜2個/行）、Mid（1〜3個/行）、High（3〜5個以上/行）が目安です。

**Q3: 濁音はどう使いますか？**  
A: Low（ほぼなし）、Mid（たまに）、High（頻繁）。恍惚状態を表現します。

**Q4: resist（抵抗）と fall（受容）の違いは？**  
A: resist = 「やめろ！負けない！」など強がり・拒絶。fall = 「やだのに…感じちゃう…」など葛藤・降伏。

**Q5: 既存のファイルを編集してもいいですか？**  
A: はい、ただし1ファイルあたり200行以内の修正を推奨します。大きな変更は複数回に分けてください。

---

## 🎯 チェックリスト

セリフ作成完了後、以下を確認してください：

### 内容面
- [ ] 堕落度による表現の違いが明確
- [ ] Stage別の興奮度が反映されている
- [ ] ♡マークの使用頻度が適切
- [ ] キャラクター性が一貫している
- [ ] 各ブロックの内容が適切（例：resist_failは痛み・衝撃）

### 技術面
- [ ] JSON構文が正しい（JSONLintでチェック）
- [ ] ファイル名が命名規則に従っている
- [ ] 必要なセリフ数が揃っている
- [ ] ダブルクォートが全て閉じている
- [ ] カンマが正しく配置されている

---

## 📅 更新履歴

| 日付 | バージョン | 内容 |
|------|------------|------|
| 2025-11-25 | 1.0 | 初版作成 |

---

## 🎉 作成完了したら

セリフ作成が完了したら、以下の情報と共にファイルを提出してください：

- 作成したJSONファイル（4種類）
- キャラクター名・敵名・堕落度
- 総行数
- 特記事項（こだわった点、確認してほしい点など）

**お疲れさまでした！** 🎊

