# 演出シーケンスパターン実装ガイド

## 概要

エロ演出のオーバーレイ表示を、イベントタイプと台詞行数に応じて自動的に最適化するシステムです。

## システム構成

### 1. SEQUENCE_PATTERNS（演出パターン定義）

`js/plugins/VisualOverlayData.js` で定義されている、再利用可能な演出パターンのテンプレートです。

```javascript
const SEQUENCE_PATTERNS = {
  quick: [/* 1-2行用 */],
  standard: [/* 2-3行用 */],
  medium: [/* 3-5行用 */],
  long: [/* 4-6行以上用 */],
  intense: [/* 激しい演出用 */]
};
```

各パターンは `{ frame: number, intensity: "soft"|"hard"|null }` の配列です。

### 2. sequences（イベントタイプ別パターン割り当て）

各モンスターの `mapping` 内で、イベントタイプごとに使用するパターンを指定します。

```javascript
slime: {
  mapping: {
    attack: {
      breast: {
        soft: "attack_breast_soft",
        hard: "attack_breast_hard",
        layer: "overlay",
        sequences: {
          danger: SEQUENCE_PATTERNS.standard,      // 通常エロ攻撃
          climax: SEQUENCE_PATTERNS.standard,
          down_attack: SEQUENCE_PATTERNS.standard,
          orgasm: SEQUENCE_PATTERNS.long           // 絶頂は長い演出
        }
      }
    },
    insert: {
      pussy: {
        soft: "insert_pussy_soft",
        hard: "insert_pussy_hard",
        layer: "underOverlay",
        sequences: {
          "insert:pre": SEQUENCE_PATTERNS.quick,   // 挿入前（抵抗・受け入れ）
          "insert:main": SEQUENCE_PATTERNS.medium  // 挿入シーン
        }
      }
    }
  }
}
```

## イベントタイプとパターンの対応

### 通常エロ攻撃（非挿入・挿入）

- **イベントタイプ**: `danger`, `climax`, `down_attack`
- **推奨パターン**: `standard`（2-3行）
- **特徴**: 短めの台詞で、2行目でクライマックス

### 絶頂演出

- **イベントタイプ**: `orgasm`
- **推奨パターン**: `long`（4-6行以上）
- **特徴**: 長めの台詞で、中盤に複数の `hard` フレーム

### 挿入演出

- **イベントタイプ**: `insert`
- **phase**: `pre` または `main`
- **推奨パターン**:
  - `insert:pre` → `quick`（1-2行）
  - `insert:main` → `medium`（3-5行）

### 拘束演出

- **イベントタイプ**: `restrain`
- **推奨パターン**: なし（単発表示のため）

## 解決ロジック（OverlayBuilder.js）

`getAttackOverlayForFrame` 関数は以下の優先順位でシーケンスパターンを解決します：

1. **`eventType:phase`** で検索（例: `"insert:pre"`, `"insert:main"`）
2. **`eventType`** のみで検索（例: `"danger"`, `"orgasm"`）
3. **旧形式の `sequence`**（後方互換）
4. **progressベースのフォールバック**（シーケンスがない場合）

## パターンの追加方法

### 新しいパターンを追加

```javascript
// VisualOverlayData.js
const SEQUENCE_PATTERNS = {
  // ... 既存のパターン
  
  // 新しいパターン
  gentle: [
    { frame: 0, intensity: "soft" },
    { frame: 1, intensity: "soft" },
    { frame: 2, intensity: "soft" },
    { frame: 3, intensity: "hard" },
    { frame: 4, intensity: "soft" }
  ]
};
```

### モンスターに適用

```javascript
tentacle: {
  mapping: {
    attack: {
      breast: {
        sequences: {
          danger: SEQUENCE_PATTERNS.gentle,  // 触手は優しい演出
          orgasm: SEQUENCE_PATTERNS.long
        }
      }
    }
  }
}
```

## モンスター別のカスタマイズ

### Slime（スライム）

- 非挿入攻撃: 胸を狙う（`attack_breast_soft/hard`）
- 挿入攻撃: 膣内（`insert_pussy_soft/hard`）
- 全イベントタイプで `sequences` を定義

### Goblin（ゴブリン）

- `DEFAULT_OVERLAY` の画像名を使用
- `sequences` のみ定義（画像定義は省略）

### Tentacle（触手）

- 独自の画像名（`tentacle_soft/hard`, `tentacle_insert_soft/hard`）
- `sequences` を定義

## デバッグ

### コンソールログ

シーケンス解決時に以下のログが出力されます：

```
[OverlayBuilder-Sequence] Resolved by "insert:pre"
[OverlayBuilder-Sequence] Frame 1/2 (progress=0.00) → pattern[0] intensity=soft
```

### 確認コマンド

```javascript
// パターン一覧を確認
console.log(window.SEQUENCE_PATTERNS);

// 特定モンスターの設定を確認
console.log(window.OverlaySets.slime.mapping.attack.breast.sequences);
```

## トラブルシューティング

### シーケンスが適用されない

1. `eventType` が正しく渡されているか確認
   - `InsertEventHandler.js`: `eventType: "insert"`
   - `OrgasmEventHandler.js`: `eventType: "orgasm"`
   - `PleasurePoseController.js`: 動的に設定

2. `phase` が正しく渡されているか確認（挿入イベントのみ）
   - `InsertEventHandler.js`: `phase: "pre"` または `"main"`

3. コンソールログで解決状況を確認

### パターンが短すぎる/長すぎる

1. 台詞行数を確認
2. 適切なパターンを選択（`quick`, `standard`, `medium`, `long`）
3. 必要に応じて新しいパターンを作成

### 特定のイベントだけ変えたい

```javascript
sequences: {
  danger: SEQUENCE_PATTERNS.standard,
  climax: SEQUENCE_PATTERNS.intense,  // climaxだけ激しく
  down_attack: SEQUENCE_PATTERNS.standard,
  orgasm: SEQUENCE_PATTERNS.long
}
```

## パフォーマンス最適化

### キャッシュ機構

システムは初期化時にオーバーレイマッピングをキャッシュします：

```javascript
// VisualOverlayData.js で自動的に実行
window._mergedOverlaySets = {
  slime: { /* マージ済みマッピング */ },
  goblin: { /* マージ済みマッピング */ },
  tentacle: { /* マージ済みマッピング */ }
};
```

**メリット**:
- ✅ 戦闘中の処理時間: 90%以上削減
- ✅ `deepMerge` は初期化時に1回だけ実行
- ✅ 戦闘中はキャッシュから高速取得

詳細は [`docs/PERFORMANCE_OPTIMIZATION.md`](PERFORMANCE_OPTIMIZATION.md) を参照してください。

---

## まとめ

- **SEQUENCE_PATTERNS**: 再利用可能な演出テンプレート
- **sequences**: イベントタイプごとにパターンを割り当て
- **自動解決**: `eventType` と `phase` に基づいて最適なパターンを選択
- **拡張性**: 新しいパターンやモンスター固有の設定を簡単に追加可能
- **パフォーマンス**: キャッシュ機構により高速動作を実現

