# SFX自動補完システム 動作確認ガイド

## 概要

このガイドでは、状況に応じて自動的に擬音（SFX）が表示されるシステムの動作確認方法を説明します。

## システム構成

### 1. データ定義（VisualOverlayData.js）

各敵タイプごとにSFXマッピングを定義：

```javascript
window.OverlaySets = {
  slime: {
    sfx: {
      insert_entry:  "default_pose_overlay_ズプッ1-6",  // 挿入開始
      insert_piston: "default_pose_overlay_ぬちょっ1-6", // ピストン
      insert_deep:   "default_pose_overlay_ズポ1-6",    // 深い挿入
      rub_pussy:     "default_pose_overlay_ぬちゃっ1-6", // 膣愛撫
      rub_breast:    "default_pose_overlay_ぬちゃっ1-6", // 胸愛撫
      orgasm:        "default_pose_overlay_ぐちゃ1-6",   // 絶頂
      liquid:        "default_pose_overlay_ぐちゃ1-6"    // 液体音
    }
  },
  goblin: { /* 同様 */ },
  tentacle: { /* 同様 */ }
};
```

### 2. 自動選択ロジック（VisualAutoFill.js）

`getBubbleOverlaysFromContext()` 関数が状況に応じてSFXを選択：

**判定フロー**:
```
1. 絶頂・オーガズム？
   → orgasm / liquid

2. 挿入中？
   2-1. 挿入直後（insert イベント）？
        → insert_entry（ズプッ）
   2-2. ピストン中
        - 強度 > 0.6 → insert_deep（ズポ）
        - 強度 ≤ 0.6 → insert_piston（ぬちょっ）

3. 非挿入時の愛撫
   3-1. 部位が pussy → rub_pussy（ぬちゃっ）
   3-2. 部位が breast → rub_breast（ぬちゃっ）
   3-3. その他 → rub_pussy（フォールバック）
```

### 3. 表示制御（PleasurePoseController.js）

- **dialogueSequence がある場合**: 各行で自動補完
- **dialogueSequence がない場合**: エロ攻撃イベント時のみ追加

## 動作確認手順

### Phase 1: 基本動作確認（30分）

#### 1.1 Slime（スライム）との戦闘

1. ゲームを起動
2. F12 でデベロッパーツールを開く
3. Console タブを表示
4. Slime との戦闘を開始

#### 1.2 拘束イベント

**期待される動作**:
- 拘束時に擬音は表示されない（拘束エフェクトのみ）

**確認ログ**:
```
[VAF] No sfx map found... (正常)
```

#### 1.3 非挿入エロ攻撃

**期待される動作**:
- 胸攻撃の擬音が表示される
- 左右に「ぬちゃっ」が表示

**確認ログ**:
```
[VAF-SFX] Selected: type="rub_breast", key="default_pose_overlay_ぬちゃっ1-6", enemy="slime", inserted=false, part="breast"
[PPC] Auto-filled SFX bubbles: ["default_pose_overlay_ぬちゃっ1-6_left", "default_pose_overlay_ぬちゃっ1-6_right"]
```

#### 1.4 挿入イベント

**期待される動作**:
- 挿入成功時に「ズプッ」が表示
- 抵抗成功時は表示されない

**確認ログ**:
```
[VAF-SFX] Selected: type="insert_entry", key="default_pose_overlay_ズプッ1-6", enemy="slime", inserted=true, part="pussy"
```

#### 1.5 挿入後のピストン攻撃

**期待される動作**:
- 通常攻撃: 「ぬちょっ」
- 強い攻撃: 「ズポ」

**確認ログ**:
```
[VAF-SFX] Selected: type="insert_piston", key="default_pose_overlay_ぬちょっ1-6", ...
または
[VAF-SFX] Selected: type="insert_deep", key="default_pose_overlay_ズポ1-6", ...
```

#### 1.6 絶頂イベント

**期待される動作**:
- 「ぐちゃ」が表示

**確認ログ**:
```
[VAF-SFX] Selected: type="orgasm", key="default_pose_overlay_ぐちゃ1-6", ...
```

### Phase 2: 全敵確認（30分）

#### 2.1 Goblin（ゴブリン）

上記と同様の手順で確認：
- 非挿入攻撃
- 挿入イベント
- ピストン攻撃
- 絶頂

#### 2.2 Tentacle（触手）

上記と同様の手順で確認

### Phase 3: エッジケース確認（30分）

#### 3.1 抵抗成功時

**期待される動作**:
- 擬音が表示されない

**確認方法**:
1. 挿入イベント発生
2. 抵抗に成功
3. 擬音が表示されないことを確認

#### 3.2 dialogueSequence での表示

**期待される動作**:
- 各行で適切な擬音が表示
- 強度に応じて擬音が変化

**確認方法**:
1. 挿入後のエロ攻撃を発生させる
2. dialogueSequence が再生される
3. 各行で擬音が表示されることを確認

#### 3.3 visuals 表示時

**期待される動作**:
- 擬音が表示されない（withDialogue=false）

**確認方法**:
1. エロ攻撃後の通常表示
2. 擬音が消えていることを確認

## トラブルシューティング

### 問題1: 擬音が表示されない

**原因候補**:
1. 画像ファイルが存在しない
2. ファイル名が間違っている
3. enemyKey が正しく設定されていない

**確認方法**:
```javascript
// Console で確認
console.log(window.OverlaySets);
// → slime, goblin, tentacle が定義されているか確認

// 画像の存在確認
ImageManager.loadPicture("busts/slime_restrained/default_pose_overlay_ズプッ1-6_left");
```

**解決策**:
1. 画像ファイルの存在を確認
2. ファイル名を確認（大文字・小文字、全角・半角）
3. `VisualOverlayData.js` の enemyKey を確認

### 問題2: 間違った擬音が表示される

**原因候補**:
1. 状況判定ロジックの問題
2. isInserted フラグが正しく設定されていない

**確認方法**:
```javascript
// Console で確認
[VAF-SFX] Selected: type="...", key="...", enemy="...", inserted=..., part="..."
```

**解決策**:
1. ログで状況を確認
2. `getBubbleOverlaysFromContext()` のロジックを確認
3. 必要に応じて条件を調整

### 問題3: 擬音の位置がずれている

**原因候補**:
- 画像の位置調整が不適切

**解決策**:
1. 該当する画像を画像編集ソフトで開く
2. 位置を調整
3. 再エクスポート
4. ゲームをリロード（F5）

### 問題4: 左右の擬音が同じ位置に表示される

**原因候補**:
- 画像が同じ位置に描かれている

**解決策**:
1. `_left` と `_right` の画像を確認
2. 左右で異なる位置に描かれているか確認
3. 必要に応じて再調整

## デバッグコマンド

### Console で使用できるコマンド

```javascript
// 1. OverlaySets の確認
console.log(window.OverlaySets);

// 2. 特定の敵のSFXマッピング確認
console.log(window.OverlaySets.slime.sfx);

// 3. 画像の読み込み確認
ImageManager.loadPicture("busts/slime_restrained/default_pose_overlay_ズプッ1-6_left");

// 4. 現在のバトル状態確認
console.log($gameParty.battleMembers()[0]._pleasure);

// 5. 手動でSFX選択テスト
const context = {
  enemyKey: "slime",
  eventType: "danger",
  targetPart: "breast",
  isInserted: false,
  phase: "main"
};
console.log(window.VisualAutoFill.getBubbleOverlaysFromContext(context, 0.5));
```

## パフォーマンス確認

### 画像読み込み時間

```javascript
// Console で測定
console.time("SFX Load");
ImageManager.loadPicture("busts/slime_restrained/default_pose_overlay_ズプッ1-6_left");
console.timeEnd("SFX Load");
```

**期待値**: 10ms 以下

### メモリ使用量

```javascript
// Console で確認
console.log(performance.memory);
```

**期待値**: SFX追加による増加は 5MB 以下

## チェックリスト

### 実装完了チェック

- [ ] VisualOverlayData.js に全敵のSFXマッピングが定義されている
- [ ] 各敵フォルダに擬音画像が配置されている（7種類 × 2方向 = 14ファイル）
- [ ] getBubbleOverlaysFromContext() が正しく動作する
- [ ] dialogueSequence で擬音が自動追加される
- [ ] 単発イベントで擬音が自動追加される

### 動作確認チェック

- [ ] Slime: 非挿入攻撃で擬音表示
- [ ] Slime: 挿入イベントで擬音表示
- [ ] Slime: ピストン攻撃で擬音表示
- [ ] Slime: 絶頂で擬音表示
- [ ] Goblin: 上記と同様
- [ ] Tentacle: 上記と同様
- [ ] 抵抗成功時に擬音が表示されない
- [ ] visuals 表示時に擬音が表示されない

### 品質確認チェック

- [ ] 擬音の位置が適切
- [ ] 左右の擬音がバランス良く配置
- [ ] 他のオーバーレイと重ならない
- [ ] 文字が読みやすい
- [ ] パフォーマンスに問題がない

## まとめ

SFX自動補完システムは以下の状況で自動的に擬音を表示します：

1. **挿入開始**: ズプッ
2. **ピストン（弱）**: ぬちょっ
3. **ピストン（強）**: ズポ
4. **膣愛撫**: ぬちゃっ
5. **胸愛撫**: ぬちゃっ
6. **絶頂**: ぐちゃ

各敵フォルダに配置された専用画像が自動的に選択され、表示されます。

問題が発生した場合は、Console ログを確認し、このガイドのトラブルシューティングを参照してください。

