# 敵ごとの専用SFX画像作成ガイド

## 概要

このガイドでは、各敵タイプに最適化された擬音（SFX）画像を作成する手順を説明します。

## 方針

**専用画像方式**: 各敵フォルダに位置調整済みの擬音画像を配置することで、システム側の座標計算を不要にし、ピクセルパーフェクトな配置を実現します。

### メリット
- ✅ 最高品質の配置
- ✅ 角度・大きさも調整可能
- ✅ システムがシンプル
- ✅ 画像を差し替えるだけで調整完了

## 必要なツール

- **画像編集ソフト**: Photoshop, GIMP, Krita など
- **テンプレート**: 共通の擬音デザイン（PSD/XCF形式）
- **参考画像**: 各敵のベース立ち絵

## ファイル構造

```
img/pictures/busts/
├── slime_restrained/
│   ├── default_pose_overlay_ズプッ1-6_left.png   ← スライム用に調整済み
│   ├── default_pose_overlay_ズプッ1-6_right.png
│   ├── default_pose_overlay_ぬちょっ1-6_left.png
│   └── ...
├── slime_restrained_insert/
│   ├── default_pose_overlay_ズプッ1-6_left.png
│   └── ...
├── goblin_restrained/
│   ├── default_pose_overlay_ズプッ1-6_left.png  ← ゴブリン用に調整済み
│   └── ...
└── tentacle_restrained/
    ├── default_pose_overlay_ズプッ1-6_left.png ← 触手用に調整済み
    └── ...
```

## 作成手順

### Phase 1: テンプレート作成（1時間）

#### 1.1 共通デザインを決定

擬音の基本デザインを作成します：

- **フォント**: 太めの明朝体またはゴシック体
- **サイズ**: 約80-120px
- **エフェクト**: 
  - 白い縁取り（3-5px）
  - 軽い影
  - 必要に応じてモーションブラー

#### 1.2 テンプレートファイル作成

```
templates/
├── sfx_template.psd  (Photoshop)
│   ├── レイヤー1: 擬音テキスト
│   ├── レイヤー2: 縁取り
│   ├── レイヤー3: 影
│   └── レイヤー4: 背景（透明）
└── sfx_variations/
    ├── ズプッ.psd
    ├── ぬちょっ.psd
    ├── ぐちゃ.psd
    └── ...
```

#### 1.3 擬音バリエーション作成

以下の擬音を作成：

| 擬音 | 用途 | 推奨サイズ |
|-----|------|----------|
| ズプッ | 挿入開始 | 100px |
| ぬちょっ | ピストン | 90px |
| ズポ | 深い挿入 | 110px |
| ぬちゃっ | 愛撫 | 85px |
| ぐちゃ | 絶頂 | 95px |

### Phase 2: 敵ごとに調整（3時間）

#### 2.1 ベース画像を参照レイヤーとして読み込む

```
1. Photoshop/GIMPでテンプレートを開く
2. ファイル → 配置 → uniform_intact_base.png を読み込み
3. 参照レイヤーとして設定（不透明度50%）
4. 擬音の位置を調整
```

#### 2.2 敵ごとの調整ポイント

**Slime（スライム）**:
- 体が低めなので、擬音も少し下に配置
- 液体っぽい雰囲気に合わせて、少し流れるような角度をつける
- 推奨位置: 膣攻撃は画像下部、胸攻撃は中央やや上

**Goblin（ゴブリン）**:
- 標準的な体型
- 荒々しい雰囲気に合わせて、角度をつけない
- 推奨位置: 膣攻撃は画像中央やや下、胸攻撃は中央

**Tentacle（触手）**:
- 触手の位置に合わせて配置
- 複数の触手がある場合、擬音も複数配置を検討
- 推奨位置: 触手の先端付近

#### 2.3 左右の配置

- **Left（左側）**: 画像の左側 1/3 あたり
- **Right（右側）**: 画像の右側 1/3 あたり
- 左右でバランスを取る

#### 2.4 キャンバスサイズの統一

全ての画像を同じキャンバスサイズにします：

```
推奨サイズ: 816 x 624 px（バスト画像と同じ）
基準点: 中央下（anchor 0.5, 1.0）
```

### Phase 3: エクスポート（30分）

#### 3.1 エクスポート設定

- **形式**: PNG-24
- **透明度**: 有効
- **圧縮**: 最高品質
- **ファイル名**: `default_pose_overlay_[擬音]_[left/right].png`

#### 3.2 一括エクスポート（Photoshopスクリプト例）

```javascript
// export_sfx.jsx
var enemies = ["slime_restrained", "slime_restrained_insert", "goblin_restrained", "goblin_restrained_insert", "tentacle_restrained", "tentacle_restrained_insert"];
var sfxTypes = ["ズプッ1-6", "ぬちょっ1-6", "ズポ1-6", "ぬちゃっ1-6", "ぐちゃ1-6"];
var sides = ["left", "right"];

for (var e = 0; e < enemies.length; e++) {
  for (var s = 0; s < sfxTypes.length; s++) {
    for (var d = 0; d < sides.length; d++) {
      var fileName = "default_pose_overlay_" + sfxTypes[s] + "_" + sides[d] + ".png";
      var filePath = "C:/Users/kouko/Downloads/ProjectEst/img/pictures/busts/" + enemies[e] + "/" + fileName;
      
      // 現在のドキュメントをPNGとして保存
      var saveOptions = new PNGSaveOptions();
      saveOptions.compression = 9;
      saveOptions.interlaced = false;
      
      var file = new File(filePath);
      activeDocument.saveAs(file, saveOptions, true);
    }
  }
}
```

### Phase 4: ゲーム内確認（1時間）

#### 4.1 テストプレイ

1. ゲームを起動
2. 各敵との戦闘を開始
3. エロ攻撃イベントを発生させる
4. 擬音の位置を確認

#### 4.2 確認ポイント

- ✅ 擬音が敵の攻撃位置に合っているか
- ✅ 左右の擬音がバランス良く配置されているか
- ✅ 他のオーバーレイ（頬染め、拘束など）と重ならないか
- ✅ 文字が読みやすいか

#### 4.3 微調整

位置がずれている場合：

1. 該当する画像を画像編集ソフトで開く
2. 擬音の位置を調整
3. 再エクスポート
4. ゲームをリロード（F5）して確認

### Phase 5: 最終調整（1時間）

#### 5.1 全敵での確認

- Slime（非挿入・挿入）
- Goblin（非挿入・挿入）
- Tentacle（非挿入・挿入）

#### 5.2 統一感の確認

- 擬音のサイズが統一されているか
- フォント・エフェクトが統一されているか
- 全体的なバランスが取れているか

## 効率化テクニック

### テクニック1: レイヤーコンポを活用

```
master_composition.psd
├── [グループ] Slime
│   ├── ベース画像（参照）
│   └── 擬音レイヤー（調整）
├── [グループ] Goblin
│   ├── ベース画像（参照）
│   └── 擬音レイヤー（調整）
└── [グループ] Tentacle
    ├── ベース画像（参照）
    └── 擬音レイヤー（調整）
```

### テクニック2: スマートオブジェクト

擬音をスマートオブジェクト化することで、元のデザインを変更したときに全ての配置が自動更新されます。

### テクニック3: アクション記録

Photoshopのアクション機能で、エクスポート作業を自動化します。

## トラブルシューティング

### 問題1: 擬音が表示されない

**原因**: ファイル名が間違っている

**解決策**: 
- ファイル名を確認: `default_pose_overlay_[擬音]_[left/right].png`
- 大文字・小文字を確認
- 全角・半角を確認

### 問題2: 位置がずれている

**原因**: キャンバスサイズが異なる

**解決策**:
- 全ての画像を 816 x 624 px に統一
- anchor を (0.5, 1.0) に設定

### 問題3: 画像が荒い

**原因**: 圧縮設定が低い

**解決策**:
- PNG-24 で保存
- 圧縮レベルを最高に設定

## 新しい敵を追加する場合

1. 新しい敵のフォルダを作成
2. テンプレートから擬音画像をコピー
3. 敵のベース画像を参照して位置調整
4. エクスポート
5. ゲームで確認

## 参考情報

- 画像サイズ: 816 x 624 px
- 基準点: (408, 624) - 画像の中央下
- Anchor: (0.5, 1.0)
- フォーマット: PNG-24（透明度あり）

## 作業時間見積もり

| フェーズ | 時間 | 詳細 |
|---------|------|------|
| Phase 1 | 1時間 | テンプレート作成 |
| Phase 2 | 3時間 | 敵ごとに調整（6敵 × 7擬音 × 2方向 = 84ファイル） |
| Phase 3 | 30分 | エクスポート |
| Phase 4 | 1時間 | ゲーム内確認 |
| Phase 5 | 1時間 | 最終調整 |
| **合計** | **6.5時間** | |

## まとめ

専用画像方式では、初期作成コストはかかりますが、一度作成すれば：

- ✅ システムがシンプルで安定
- ✅ 最高品質の配置
- ✅ 後から画像を差し替えるだけで調整可能
- ✅ 角度・大きさも自由に調整可能

長期的には最もメンテナンスしやすい方式です。

