# VisualAutoFill システム動作確認ガイド

## 概要

VisualAutoFillシステムをファイル分割した後の動作確認手順です。

## 前提条件

以下のファイルが正しく配置されていること：

- `js/plugins/VisualOverlayData.js` (既存)
- `js/plugins/ExpressionSelector.js` (新規)
- `js/plugins/OverlayBuilder.js` (新規)
- `js/plugins/VisualAutoFill.js` (リファクタリング済み)

`js/plugins.js` で正しい順序で読み込まれていること：

```javascript
{"name":"VisualOverlayData","status":true},
{"name":"ExpressionSelector","status":true},
{"name":"OverlayBuilder","status":true},
{"name":"VisualAutoFill","status":true}
```

---

## テスト手順

### 1. ゲーム起動確認

1. ゲームを起動
2. F12でコンソールを開く
3. 以下のログが表示されることを確認：

```
[VisualOverlayData] Loaded
[ExpressionSelector] Loading...
[ExpressionSelector] Ready
[OverlayBuilder] Loading...
[OverlayBuilder] Ready
[VisualAutoFill] Loading (integration layer)...
[VisualAutoFill] Ready - Integration layer initialized
[VisualAutoFill] Loaded modules: ExpressionSelector, OverlayBuilder
```

**エラーが出る場合**:
- `ExpressionSelector not loaded` → `plugins.js` の読み込み順序を確認
- `OverlayBuilder not loaded` → `plugins.js` の読み込み順序を確認

---

### 2. API存在確認

コンソールで以下を実行：

```javascript
// モジュールが存在するか確認
console.log("ExpressionSelector:", typeof window.ExpressionSelector);
console.log("OverlayBuilder:", typeof window.OverlayBuilder);
console.log("VisualAutoFill:", typeof window.VisualAutoFill);
```

**期待結果**: 全て `"object"` と表示される

---

### 3. 表情選択テスト

コンソールで以下を実行：

```javascript
// 表情選択テスト
const expr1 = window.ExpressionSelector.weightedRandomExpression("stage1", "danger", null, true);
console.log("Stage1 Danger:", expr1); // → "endure" または "confused" など

const expr2 = window.ExpressionSelector.weightedRandomExpression("stage3", "climax", null, true);
console.log("Stage3 Climax:", expr2); // → "ahe" または "confused" など

// 台詞解析テスト
const hint = window.ExpressionSelector._internal.analyzeDialogueEmotion("やめて...！");
console.log("Emotion Hint:", hint); // → { resist: 40, confused: 0, pleasure: 0 }
```

**期待結果**: 
- Stage1では主に "endure" または "confused"
- Stage3では主に "ahe" または "confused"
- 台詞解析で正しい感情スコアが返る

---

### 4. オーバーレイ構築テスト

コンソールで以下を実行：

```javascript
// オーバーレイ構築テスト
const context = {
  stage: "stage2",
  targetPart: "breast",
  enemyKey: "slime",
  isInserted: false,
  isRestrained: true
};

const overlays = window.OverlayBuilder.buildOverlaysForLine(context, 0.5);
console.log("Overlays:", overlays);
// → { overlays: ["restrain", "blush_mid", "slime_breast_low"], underOverlays: [] }
```

**期待結果**: 
- `overlays` に拘束、頬染め、攻撃エフェクトが含まれる
- `underOverlays` は空（breastは通常overlayに配置）

---

### 5. SFX選択テスト

コンソールで以下を実行：

```javascript
// SFX選択テスト（非挿入・胸攻撃）
const context1 = {
  enemyKey: "slime",
  eventType: "danger",
  targetPart: "breast",
  isInserted: false,
  phase: "main"
};

const sfx1 = window.OverlayBuilder.getBubbleOverlaysFromContext(context1, 0.5);
console.log("SFX (non-inserted breast):", sfx1);
// → ["default_pose_overlay_ぬちゃっ1-6_left", "default_pose_overlay_ぬちゃっ1-6_right"]

// SFX選択テスト（挿入・膣攻撃）
const context2 = {
  enemyKey: "slime",
  eventType: "danger",
  targetPart: "pussy",
  isInserted: true,
  phase: "main"
};

const sfx2 = window.OverlayBuilder.getBubbleOverlaysFromContext(context2, 0.8);
console.log("SFX (inserted pussy, high intensity):", sfx2);
// → ["default_pose_overlay_ズポ1-6_left", "default_pose_overlay_ズポ1-6_right"]
```

**期待結果**: 
- 非挿入時は `rub_breast` 系のSFX
- 挿入時（高強度）は `insert_deep` 系のSFX

---

### 6. 統合API テスト

コンソールで以下を実行：

```javascript
// dialogueSequence 自動補完テスト
const sequence = [
  { text: "やめて...！" },
  { text: "んっ...！" },
  { text: "あっ...♡" }
];

const context = {
  stage: "stage2",
  eventType: "danger",
  targetPart: "breast",
  enemyKey: "slime",
  isInserted: false,
  isRestrained: true
};

const filled = window.VisualAutoFill.autoFillDialogueSequence(sequence, context);
console.log("Filled Sequence:", filled);
```

**期待結果**: 
- 各行に `expression`, `overlays`, `underOverlays` が自動補完される
- 表情は台詞内容に応じて変化する
- オーバーレイには拘束、頬染め、攻撃エフェクトが含まれる

---

### 7. 実戦テスト（戦闘）

1. ニューゲームを開始
2. スライムと戦闘開始
3. 拘束されるまで待つ
4. エロ攻撃を受ける

**確認項目**:
- ✅ 表情が自動的に変化する
- ✅ 頬染めが表示される
- ✅ 攻撃エフェクト（スライム）が表示される
- ✅ SFX（擬音）が表示される
- ✅ コンソールにエラーが出ない

**ログ例**:
```
[ExpressionSelector] Selected: "confused" (weights: {...})
[OverlayBuilder-Layer] enemyKey=slime, targetPart=breast, ...
[OverlayBuilder-SFX] Selected: type="rub_breast", key="...", ...
```

---

### 8. 挿入イベントテスト

1. 戦闘を続けて挿入イベントを発生させる
2. 挿入成功後のエロ攻撃を確認

**確認項目**:
- ✅ 挿入時のSFX（ズプッ）が表示される
- ✅ ピストン時のSFX（ぬちょっ/ズポ）が表示される
- ✅ 攻撃エフェクトが `underOverlay` に配置される（服の下）
- ✅ 表情が適切に変化する

---

### 9. 絶頂イベントテスト

1. 快楽ゲージを満タンにして絶頂させる

**確認項目**:
- ✅ 絶頂時の表情（stage依存）が表示される
- ✅ 絶頂時のSFX（ぐちゃ）が表示される
- ✅ オーバーレイが適切に表示される

---

### 10. 他の敵でテスト

1. ゴブリン、触手でも同様にテスト
2. 各敵で適切なオーバーレイが表示されることを確認

**確認項目**:
- ✅ ゴブリン用のオーバーレイが表示される
- ✅ 触手用のオーバーレイが表示される
- ✅ SFXが正しく表示される

---

## トラブルシューティング

### 問題: 表情が自動補完されない

**原因**: `context.isRestrained` が設定されていない

**解決策**: 
```javascript
// PleasurePoseController.js などで isRestrained を追加
const context = {
  // ...
  isRestrained: window.PleasureStateManager?.isActorRestrained?.(actor) || false
};
```

### 問題: オーバーレイが表示されない

**原因**: `VisualOverlayData.js` にマッピングが定義されていない

**解決策**: 
1. `window.OverlaySets[enemyKey]` が存在するか確認
2. 必要に応じてマッピングを追加

### 問題: SFXが表示されない

**原因**: 画像ファイルが配置されていない

**解決策**: 
1. `img/pictures/busts/[enemyKey]/` フォルダに画像があるか確認
2. ファイル名が正しいか確認（例: `default_pose_overlay_ズプッ1-6_left.png`）

### 問題: コンソールエラー "XXX not loaded"

**原因**: プラグインの読み込み順序が間違っている

**解決策**: 
1. `js/plugins.js` を開く
2. 以下の順序になっているか確認：
   - VisualOverlayData
   - ExpressionSelector
   - OverlayBuilder
   - VisualAutoFill

---

## パフォーマンステスト

### メモリ使用量確認

コンソールで以下を実行：

```javascript
// 各モジュールのサイズを確認
console.log("ExpressionSelector keys:", Object.keys(window.ExpressionSelector).length);
console.log("OverlayBuilder keys:", Object.keys(window.OverlayBuilder).length);
console.log("VisualAutoFill keys:", Object.keys(window.VisualAutoFill).length);
```

**期待結果**: 
- ExpressionSelector: 4-5個のキー
- OverlayBuilder: 5-6個のキー
- VisualAutoFill: 10-12個のキー（再エクスポート含む）

### 実行速度確認

コンソールで以下を実行：

```javascript
// 表情選択の速度テスト
console.time("Expression Selection");
for (let i = 0; i < 1000; i++) {
  window.ExpressionSelector.weightedRandomExpression("stage2", "danger", null, true);
}
console.timeEnd("Expression Selection");

// オーバーレイ構築の速度テスト
console.time("Overlay Building");
const context = {
  stage: "stage2",
  targetPart: "breast",
  enemyKey: "slime",
  isInserted: false,
  isRestrained: true
};
for (let i = 0; i < 1000; i++) {
  window.OverlayBuilder.buildOverlaysForLine(context, 0.5);
}
console.timeEnd("Overlay Building");
```

**期待結果**: 
- Expression Selection: < 10ms
- Overlay Building: < 20ms

---

## 成功基準

全てのテストが以下の条件を満たすこと：

1. ✅ ゲームが正常に起動する
2. ✅ コンソールにエラーが出ない
3. ✅ 全てのAPIが存在する
4. ✅ 表情が自動選択される
5. ✅ オーバーレイが自動構築される
6. ✅ SFXが自動選択される
7. ✅ 戦闘中に正常に動作する
8. ✅ 挿入イベントで正常に動作する
9. ✅ 絶頂イベントで正常に動作する
10. ✅ 全ての敵で正常に動作する

---

## 次のステップ

動作確認が完了したら：

1. Git にコミット
2. 詳細なドキュメントを読む（`VISUAL_AUTOFILL_ARCHITECTURE.md`）
3. 必要に応じて機能拡張

---

## 参考資料

- `docs/VISUAL_AUTOFILL_ARCHITECTURE.md` - システム全体のアーキテクチャ
- `docs/SFX_AUTO_COMPLETION_GUIDE.md` - SFX自動補完の詳細
- `js/plugins/ExpressionSelector.js` - 表情選択ロジック
- `js/plugins/OverlayBuilder.js` - オーバーレイ構築ロジック
- `js/plugins/VisualAutoFill.js` - 統合層

