# ライター向け：エロ演出システムフローとセリフ仕様書

## 📋 目次
1. [システム全体の流れ](#システム全体の流れ)
2. [堕落度システム](#堕落度システム)
3. [必要なセリフ一覧](#必要なセリフ一覧)
4. [各イベントの詳細仕様](#各イベントの詳細仕様)
5. [セリフ作成ガイドライン](#セリフ作成ガイドライン)

---

## システム全体の流れ

### 🎮 エロ演出の基本フロー

```
戦闘開始
    ↓
【1】拘束イベント発生
    ├→ 拘束成功：動けなくなる
    │   └→ restraintProfiles のセリフ表示
    └→ 拘束失敗：次の行動へ
    ↓
【2】挿入イベント発生（拘束中）
    ├→ 挿入前の描写（pre_first / pre_repeat）
    ├→ プレイヤー選択
    │   ├→ 抵抗成功：sequence_resist_success
    │   ├→ 抵抗失敗：sequence_resist_fail
    │   └→ 受容：sequence_accept / sequence_first / sequence_repeat
    └→ introProfiles のセリフ表示
    ↓
【3】挿入中の攻撃（繰り返し）
    ├→ 快感値上昇
    ├→ Stage2（興奮度：中）→ Stage3（興奮度：高）
    └→ orgasmDetailProfiles のセリフ表示（挿入絶頂前）
    ↓
【4】絶頂イベント
    ├→ プレイヤー選択
    │   ├→ 「まだイかない」：after_resist（抵抗）
    │   └→ 「もうイっちゃう」：after_fall（受容）
    └→ orgasmDetailProfiles のセリフ表示
    ↓
【5】通常戦闘中の反応
    └→ poseProfiles のセリフ表示（部位×状態別）
    ↓
繰り返し or 戦闘終了
```

---

## 堕落度システム

### 📊 堕落度の3段階

| 堕落度 | 範囲 | キャラクター状態 | セリフの特徴 |
|--------|------|------------------|--------------|
| **Low** | 0-39% | 純粋・無垢・初体験レベル | 拒絶・恐怖・戸惑い。♡マーク控えめ |
| **Mid** | 40-79% | 快感を覚え始めている | 葛藤・心身の矛盾。♡マーク増加 |
| **High** | 80-100% | 快楽に溺れている | 受容・要求・恍惚。♡マーク多用 |

### 🎭 興奮段階（Stage）

| Stage | 状態 | セリフの特徴 |
|-------|------|--------------|
| **Stage1** | 平常時 | 冷静、文法的に正しい |
| **Stage2** | 興奮中程度 | やや感情的、理性が残る |
| **Stage3** | 興奮高 | 感情的、喘ぎが多い、途切れがち |

---

## 必要なセリフ一覧

### 📝 セリフ総数の目安

1つのキャラクター×1体の敵×堕落度1段階あたり、**約150〜200行**のセリフが必要です。

---

## 各イベントの詳細仕様

### 【1】拘束イベント（restraintProfiles）

**ファイル例**: `dataEx/restraintProfiles/slime_restrained_low.json`

#### 構造
```
stage1 / stage2 / stage3
  └─ low / mid / high（堕落度）
      ├─ first（初回拘束時）
      └─ repeat（2回目以降）
```

#### 必要セリフ数

| Stage | 堕落度 | 初回/繰り返し | 1パターンあたり | 小計 |
|-------|--------|---------------|----------------|------|
| Stage1 | Low | first | 2行 | 2行 |
| Stage1 | Low | repeat | 2行 | 2行 |
| Stage1 | Mid | first | 2行 | 2行 |
| Stage1 | Mid | repeat | 2行 | 2行 |
| Stage1 | High | first | 2行 | 2行 |
| Stage1 | High | repeat | 2行 | 2行 |
| Stage2 | (同様) | ... | ... | 12行 |
| Stage3 | (同様) | ... | ... | 12行 |
| **合計** | | | | **36行** |

#### セリフの内容指針

- **first（初回）**: 拘束への驚き、恐怖、戸惑い
- **repeat（繰り返し）**: 既視感、諦め、または受容

**堕落度別の表現**
- **Low**: 「動けない！？」「いや、離して！」
- **Mid**: 「また拘束…気持ちいい…？」「なんで…体が…」
- **High**: 「また縛られちゃう♡」「動けないの好き♡」

---

### 【2】挿入イベント（introProfiles/insert）

**ファイル例**: `dataEx/introProfiles/insert/slime_restrained_low.json`

#### 構造
```
├─ pre_first（初回挿入前）
│   ├─ stage2 / stage3
│   └─ low（堕落度）: 3行
├─ pre_repeat（2回目以降挿入前）
│   ├─ stage2 / stage3
│   └─ low: 2行
├─ sequence_resist_success（抵抗成功）
│   ├─ stage2 / stage3
│   └─ low: 2行
├─ sequence_resist_fail（抵抗失敗）
│   ├─ stage2 / stage3
│   └─ low: 5行
└─ sequence_accept（受容）
    ├─ stage2 / stage3
    └─ low: 5行
```

#### 必要セリフ数

| ブロック名 | Stage2 | Stage3 | 小計 |
|------------|--------|--------|------|
| pre_first | 3行 | 3行 | 6行 |
| pre_repeat | 2行 | 2行 | 4行 |
| sequence_resist_success | 2行 | 2行 | 4行 |
| sequence_resist_fail | 5行 | 5行 | 10行 |
| sequence_accept | 5行 | 5行 | 10行 |
| sequence_first | 5行 | 5行 | 10行 |
| sequence_repeat | 5行 | 5行 | 10行 |
| **合計（堕落度1段階あたり）** | | | **54行** |

#### セリフの内容指針

| ブロック | タイミング | 内容 |
|----------|------------|------|
| **pre_first** | 初めて挿入される直前 | 恐怖・拒絶・緊張感「入ってくる！」 |
| **pre_repeat** | 2回目以降の挿入直前 | 既視感・トラウマ「また…来る…！」 |
| **sequence_resist_success** | 抵抗に成功した時 | 安堵・勝利感「防いだ…！」 |
| **sequence_resist_fail** | 抵抗に失敗した時 | 貫通の衝撃・痛み・屈辱「入って…っ！？」 |
| **sequence_accept** | 受け入れた時 | 心身の葛藤・無意識の反応「熱い…」 |
| **sequence_first** | 初回挿入完了時 | 初体験の衝撃・混乱 |
| **sequence_repeat** | 2回目以降挿入完了時 | 慣れと恐怖の混在 |

---

### 【3】絶頂イベント（orgasmDetailProfiles）

**ファイル例**: `dataEx/orgasmDetailProfiles/slime_restrained_insert_low.json`

#### 構造
```
├─ choices（プレイヤー選択肢）
│   ├─ stage2 / stage3
│   └─ low: 2つの選択肢
├─ sequence（絶頂前の描写）
│   ├─ stage2 / stage3
│   └─ low: 3行
├─ after_resist（抵抗を選んだ後）
│   ├─ stage2 / stage3
│   └─ low: 7行
└─ after_fall（受容を選んだ後）
    ├─ stage2 / stage3
    └─ low: 6行
```

#### 必要セリフ数

| ブロック名 | Stage2 | Stage3 | 小計 |
|------------|--------|--------|------|
| choices（選択肢） | 2つ | 2つ | 4つ |
| sequence | 3行 | 3行 | 6行 |
| after_resist | 7行 | 7行 | 14行 |
| after_fall | 6行 | 6行 | 12行 |
| **合計（堕落度1段階あたり）** | | | **36行** |

#### セリフの内容指針

| ブロック | 内容 |
|----------|------|
| **choices** | 「まだ…イかない…！」「もう…イっちゃう…」 |
| **sequence** | 絶頂の予兆・息遣いが荒くなる |
| **after_resist** | 我慢の苦しみ・限界に耐える描写 |
| **after_fall** | 絶頂を受け入れる・理性が飛ぶ描写 |

---

### 【4】通常戦闘中の反応（poseProfiles）

**ファイル例**: `dataEx/poseProfiles/slime_restrained_low.json`

#### 構造
```
lines:
  ├─ react（反応）
  ├─ danger（危機）
  ├─ climax（絶頂寸前）
  └─ down_attack（ダウン中攻撃）
      └─ breast（部位：胸）
          ├─ stage1 / stage2 / stage3
          └─ low（堕落度）
              ├─ resist（抵抗）: 3〜5行
              └─ fall（受容）: 3〜5行
```

#### 必要セリフ数

| 状況 | Stage | 堕落度Low resist | 堕落度Low fall | 小計 |
|------|-------|------------------|----------------|------|
| react | stage1 | 3行 | - | 3行 |
| danger | stage1 | 3行 | - | 3行 |
| danger | stage2 | 3行 | 3行 | 6行 |
| climax | stage1 | 3行 | - | 3行 |
| climax | stage2 | 3行 | 3行 | 6行 |
| climax | stage3 | 5行 | 5行 | 10行 |
| down_attack | stage1 | 3行 | - | 3行 |
| down_attack | stage2 | 3行 | - | 3行 |
| **合計（部位1つ・堕落度1段階）** | | | | **37行** |

※ 部位は `breast`（胸）だけでなく、他の部位も追加可能ですが、現状はbreastのみ実装

#### セリフの内容指針

| 状況 | 内容 |
|------|------|
| **react** | 初期反応・驚き・拒否 |
| **danger** | 快感の波が来ている・必死の抵抗 |
| **climax** | 絶頂寸前・限界・イく直前 |
| **down_attack** | ダウン状態で攻撃される屈辱 |

**resist（抵抗）**: 「やめろ！」「絶対負けない！」など強がり・拒絶  
**fall（受容）**: 「やだのに…感じちゃう…」「もう…限界…」など葛藤・降伏

---

### 【5】フレーバーテキスト（flavor）

**ファイル例**: `dataEx/flavor/flavorRules.json`

#### 構造
```
├─ character_intro（キャラクター紹介）: 1つ
├─ low_corruption（堕落度Low時の説明）: 1つ
├─ mid_corruption（堕落度Mid時の説明）: 1つ
└─ high_corruption（堕落度High時の説明）: 1つ
```

#### 必要テキスト数

| 種類 | 必要数 | 文字数目安 |
|------|--------|------------|
| character_intro | 1つ | 60〜100文字 |
| low_corruption | 1つ | 60〜100文字 |
| mid_corruption | 1つ | 60〜100文字 |
| high_corruption | 1つ | 60〜100文字 |
| **合計** | **4つ** | - |

#### 内容指針

- **character_intro**: キャラクターの背景・性格・設定
- **low_corruption**: 清純・無垢な状態の描写
- **mid_corruption**: 快感に目覚め始めた状態
- **high_corruption**: 完全に快楽に溺れた状態

---

## セリフ作成ガイドライン

### ✍️ 堕落度別の表現ルール

#### 【Low（低堕落度）】

**感情**: 恥じらい、戸惑い、拒絶、恐怖、無垢な反応

**台詞の特徴**:
- 「やだ」「いや」など素直な拒絶
- 「ドキドキする」など初々しい身体反応
- 比較的文法的に正しい
- 涙や震えの描写

**記号の使用**:
- **♡マーク**: 控えめ（acceptブロックで1〜2個程度）
- **濁音**: ほぼなし
- **三点リーダー（…）**: 戸惑い、言葉の詰まり
- **促音（っ）**: 驚き、息の詰まり

**例**:
```
「ひっ…な、なに…するつもり…っ！？」
「やだっ…いやぁっ…近づかないでっ！」
「やだ…やだのに…奥…まで…っ！」
```

---

#### 【Mid（中堕落度）】

**感情**: 葛藤、心と体の矛盾、無意識の反応、恥じらいと快感の混在

**台詞の特徴**:
- 「でも…」「なのに…」など矛盾の表現
- 体の反応を自覚し始める
- 理性と本能の戦い

**記号の使用**:
- **♡マーク**: 中程度（1行に1〜3個）
- **濁音**: 少し出始める
- **三点リーダー**: 逡巡、葛藤

**例**:
```
「いや…なのに…気持ちいい…♡」
「体が…勝手に…反応しちゃう…！」
「またビリビリ…っ、なんで…気持ちいいの…？」
```

---

#### 【High（高堕落度）】

**感情**: 受容、恍惚、快楽への渇望、羞恥心の崩壊

**台詞の特徴**:
- 「もっと」「気持ちいい」など肯定的
- 自ら求める、催促する
- 喘ぎ声が増える

**記号の使用**:
- **♡マーク**: 多用（1行に3〜5個以上も可）
- **濁音**: 頻繁に使用
- **延ばし棒（ー）**: 恍惚の表現

**例**:
```
「んあぁ♡また縛られてるぅ♡うれし…♡」
「もっとぉ♡もっと縛ってぇ♡動けないまま♡イかせてぇ♡」
「拘束…だいすき♡おまんこ痺れて…ふるえちゃう♡」
```

---

### 🎨 Stage別の表現ルール

#### Stage1（平常時）

- 冷静、文法的に正しい
- 長めの文章も可
- 状況認識がはっきりしている

**例**:
```
「なっ…！？動けな…いっ！？」
「ぴり…ぴりしてる…なに…？このスライム…！」
```

---

#### Stage2（興奮中程度）

- やや感情的
- 理性が残っているが揺らいでいる
- 身体反応が現れ始める

**例**:
```
「はぁっ…んんっ…やだ…また…っ…！」
「怖い…のに…息…止まら…ない…！」
```

---

#### Stage3（興奮高）

- 非常に感情的
- 台詞が途切れがち
- 喘ぎ声が多い
- 理性が薄れている

**例**:
```
「ひゃあっ…っ…また…入って…っ！」
「あっ…熱い…中で…動かないで…っ！」
「ひぃあっ…っ…あぁぁぁぁっ！」
```

---

### 📏 よく使うOverlays（視覚演出）

システムが自動的に適用しますが、参考として：

| 種類 | 説明 |
|------|------|
| `blush_low` / `mid` / `high` | 赤面レベル |
| `ぐちゅっ1-6_left` / `_right` | ぬるぬる音（挿入前） |
| `ズプッ1-6_left` / `_right` | ズブズブ音（挿入時） |
| `slime_bind_base` | スライム拘束の視覚 |
| `restrain` | 一般拘束状態 |
| `under_attack` | 攻撃を受けている状態 |

---

### 😊 表情（expression）の種類

システムが自動的に適用しますが、参考として：

| 表情 | 使用場面 |
|------|----------|
| `normal` | 通常 |
| `surprised` | 驚愕 |
| `confuse` | 困惑 |
| `endure` / `endure_1` / `endure_2` | 耐える |
| `ahe` / `ahe_1` / `ahe_2` / `ahe_3` | 恍惚（トロ顔） |

---

## 📊 まとめ：1キャラ×1敵×1堕落度あたりの総セリフ数

| イベント種別 | 必要行数 |
|--------------|----------|
| 拘束イベント（restraintProfiles） | 36行 |
| 挿入イベント（introProfiles） | 54行 |
| 絶頂イベント（orgasmDetailProfiles） | 36行 |
| 通常戦闘反応（poseProfiles） | 37行 |
| フレーバーテキスト（flavor） | 4つ |
| **合計** | **約163行 + 4テキスト** |

### 全堕落度対応の場合

1キャラ×1敵で **Low / Mid / High** の3段階対応する場合：

**約163行 × 3段階 = 約490行 + 12テキスト**

---

## ⚠️ 重要な注意事項

1. **JSON構文**: カンマ、クォート、括弧の閉じ忘れに注意
2. **命名規則**: `pre_first`, `sequence_resist_fail` など厳守
3. **一貫性**: 同じ敵×堕落度で世界観を統一
4. **パッチサイズ**: 1ファイルあたり200行以内の修正推奨（リポジトリルール）
5. **改行禁止**: セリフ内に実際の改行を入れない（`\n`も不要）
6. **自動補完**: `"pose": "auto"` と記述すればシステムが自動で表情・オーバーレイを決定

---

## 🔗 関連ファイル

- **既存ガイド**: `dataEx/introProfiles/insert/WRITING_GUIDE.md`
- **ビジュアル自動補完**: `dataEx/poseProfiles/README_VisualAutoFill.md`
- **サンプルファイル**: `dataEx/introProfiles/insert/slime_restrained_low.json`

---

## 📞 質問・確認事項

セリフ作成中に不明点があれば、既存の `slime_restrained_low.json` などのサンプルファイルを参考にしてください。

**作成日**: 2025-11-25  
**バージョン**: 1.0

