# 媚薬スライム 最小必要画像リスト（自動補完対応版）

**最終更新**: 2025-12-09  
**重要**: 媚薬スライムは独立したモンスターのため、全画像の新規作成が必要  
**特徴**: 表情は`ExpressionSelector`の自動補完システムが拘束時に使用する3種類に絞り込み  
**NEW!**: 差分少数モンスター向け`hardonly`パターンを使用可能（画像枚数を削減）

---

## ⚠️ 重要な前提

### 媚薬スライムは通常スライムとは別モンスター
- ❌ 通常スライムの画像を流用することは**できません**
- ✅ 専用フォルダに全画像を配置する必要があります
- ✅ キャラクターのベース（ポーズ・体型）が異なるため、全て新規作成

### システムの自動補完機能
1. ✅ **SFXの left/right**: **1枚の画像に左右両方描かれている想定**
   - 例: `default_pose_overlay_ぬちょっ1-6.png` に左右両方の擬音が含まれる
   - left版とright版を別々に作る必要はなし
2. ✅ **制服の状態選択**: システムが自動で intact/damaged/destroyed を選択
3. ✅ **表情の選択**: システムがイベントに応じて自動選択
4. ✅ **頬染めの強度**: 絶頂回数に応じて自動選択
5. ✅ **NEW! hardonly パターン**: soft/hard差分が不要になり、画像枚数を削減可能
   - 詳細は「コスト削減オプション」セクション参照

---

## 📁 必要なフォルダ

```
img/pictures/busts/aphrodisiacSlime_restrained/
img/pictures/busts/aphrodisiacSlime_restrained_insert/
```

---

## 🎯 必要な画像（全て新規作成）

### A. キャラクターベース画像（最重要）

媚薬スライムに拘束されたセリアの基本ポーズ・体型

#### 制服状態（3枚 × 2フォルダ = 6枚）
1. **`uniform_intact_base.png`** - 制服（無傷）
2. **`uniform_damaged_base.png`** - 制服（破損）
3. **`uniform_destroyed_base.png`** - 制服（破壊）

**配置先**: 非挿入・挿入フォルダの両方

---

### B. 表情画像（拘束時自動補完対応：3枚 × 2フォルダ = 6枚）

**⚠️ 注意**: 表情自動補完システム（ExpressionSelector）が拘束時に使用する表情のみ

4. **`default_pose_face_endure.png`** - 耐える（Stage1で多用）
5. **`default_pose_face_confused.png`** - 困惑（全Stageで使用）
6. **`default_pose_face_ahe.png`** - アヘ顔（Stage3で多用）

**配置先**: 非挿入・挿入フォルダの両方

#### 💡 補足
- `normal`と`embarrassed`は拘束時には自動選択されません（非拘束時のみ）
- システムが対応していない表情（crying, angry, surprised等）は手動JSON指定時のみ使用可能ですが、通常は不要です

---

### C. 頬染め画像（3枚 × 2フォルダ = 6枚）

絶頂回数に応じた頬の赤み

12. **`default_pose_overlay_blush_low.png`** - 頬染め（弱）
13. **`default_pose_overlay_blush_mid.png`** - 頬染め（中）
14. **`default_pose_overlay_blush_high.png`** - 頬染め（強）

**配置先**: 非挿入・挿入フォルダの両方

---

### D. 媚薬スライム専用エフェクト

#### 拘束エフェクト（1枚 × 2フォルダ = 2枚）
15. **`default_pose_overlay_restrain.png`** - 拘束状態のスライム

**特徴**: ピンク/紫色のスライム、媚薬効果の視覚表現

#### 非挿入時エフェクト（非挿入フォルダ用：2枚）★重要
16. **`default_pose_overlay_slime_fullbody_soft.png`** - 全身スライム（弱）
17. **`default_pose_overlay_slime_fullbody_hard.png`** - 全身スライム（強）

**特徴**: 胸と陰部の両方を覆うスライムが**1枚の画像**に描かれている

#### 挿入時エフェクト（挿入フォルダ用：4枚）★重要
18. **`default_pose_overlay_insert_mouth_pre.png`** - 口挿入pre（挿入前・受け入れ）★専用
19. **`default_pose_overlay_insert_mouth_main.png`** - 口挿入main（挿入完了・攻撃中）★専用
20. **`default_pose_overlay_slime_fullbody_soft.png`** - 全身スライム（弱）※挿入時も継続
21. **`default_pose_overlay_slime_fullbody_hard.png`** - 全身スライム（強）※挿入時も継続

**特徴**: 挿入時も非挿入攻撃が継続する（口挿入 + 全身スライム攻撃）

---

### E. SFX擬音画像

#### ⚠️ 重要な注意
SFX画像は**1枚に左右両方の擬音が描かれている形式**です。

つまり：
- ❌ `ぬちょっ1-6_left.png` と `ぬちょっ1-6_right.png` を別々に用意
- ✅ `default_pose_overlay_ぬちょっ1-6.png` 1枚に左右両方を描画

#### 複数部位SFX対応（★媚薬スライム専用システム）

媚薬スライムは複数の部位を同時に攻撃するため、各部位のSFXが適切な位置に表示されます：

**非挿入時**: 膣SFX（other）+ 胸SFX（breast）= 2つ同時表示  
**挿入時**: 口SFX（inserted）+ 胸SFX（breast）+ 膣SFX（other）= 3つ同時表示

#### 必要なSFX（1枚に左右両方を描く形式）

##### 非挿入フォルダ用（6種類）

**膣用（otherカテゴリ）- 膣の位置に配置**
21. **`default_pose_overlay_ぬちゃっ1-6.png`** - ぬちゃっ（1～6段階）
22. **`default_pose_overlay_ヌポッ1-6.png`** - ヌポッ（1～6段階）
23. **`default_pose_overlay_ぐちゃ1-6.png`** - ぐちゃ（1～6段階）
24. **`default_pose_overlay_ずぶ3-6.png`** - ずぶ（3～6段階）

**胸用（breastカテゴリ）- 胸の位置に配置**
25. **`default_pose_overlay_ちゅぱ1-6.png`** - ちゅぱ（1～6段階）
26. **`default_pose_overlay_むぎゅ1-6.png`** - むぎゅ（1～6段階）

##### 挿入フォルダ用（12種類）

**口挿入用（insertedカテゴリ）- 口の位置に配置**
27. **`default_pose_overlay_ぬちょっ1-6.png`** - ぬちょっ（1～6段階）
28. **`default_pose_overlay_ズプッ1-6.png`** - ズプッ（1～6段階）
29. **`default_pose_overlay_ヌプッ1-6.png`** - ヌプッ（1～6段階）
30. **`default_pose_overlay_ズポ1-6.png`** - ズポ（1～6段階）
31. **`default_pose_overlay_ぐちゅっ1-6.png`** - ぐちゅっ（1～6段階）
32. **`default_pose_overlay_ズン1-6.png`** - ズン（1～6段階）

**胸用（breastカテゴリ）- 胸の位置に配置**
33. **`default_pose_overlay_ちゅぱ1-6.png`**
34. **`default_pose_overlay_むぎゅ1-6.png`**

**膣用（otherカテゴリ）- 膣の位置に配置**
35. **`default_pose_overlay_ぬちゃっ1-6.png`**
36. **`default_pose_overlay_ヌポッ1-6.png`**
37. **`default_pose_overlay_ぐちゃ1-6.png`**
38. **`default_pose_overlay_ずぶ3-6.png`**

**注**: 各SFXは絶頂回数（1～6回）に応じて6段階の変化があります

---

## 📊 最終集計

### 必要画像総数: **48枚**（複数部位SFX対応版 + 挿入時継続攻撃）

| カテゴリ | 枚数 | 内訳 |
|---------|------|------|
| 制服 | **6枚** | 3種類 × 2フォルダ |
| 表情 | **6枚** | 3種類 × 2フォルダ（自動補完対応） |
| 頬染め | **6枚** | 3種類 × 2フォルダ |
| 拘束エフェクト | **2枚** | restrain × 2フォルダ |
| 攻撃エフェクト | **2枚** | 非挿入用（fullbody） |
| 挿入エフェクト | **4枚** | 挿入用（口pre/main + fullbody継続） |
| SFX擬音 | **18枚** | 非挿入6種 + 挿入12種 |
| **合計** | **48枚** | 全て新規作成 |

#### SFX内訳（重要）
- **非挿入フォルダ**: 6種類（膣4種 + 胸2種）
- **挿入フォルダ**: 12種類（口6種 + 胸2種 + 膣4種）

### ⚠️ 重要
- **全て新規作成が必要**（通常スライムからの流用不可）
- キャラクターのポーズ・体型が異なるため、ベース画像から作成
- 媚薬効果の視覚表現（ピンク/紫色、ハートマーク等）を追加

---

## 🚀 作成手順

### Step 1: フォルダ作成
```powershell
mkdir img\pictures\busts\aphrodisiacSlime_restrained
mkdir img\pictures\busts\aphrodisiacSlime_restrained_insert
```

### Step 2: ベース画像の作成（最優先）

#### 2-1. キャラクターポーズを作成
媚薬スライムに拘束されたセリアの基本ポーズを描く

**必要な要素**:
- 拘束姿勢（四つん這い、または立ち拘束）
- ピンク/紫色のスライムに絡まれている状態
- 媚薬効果の視覚表現（頬の赤み、汗、湯気など）

#### 2-2. 制服状態（3パターン）
- `uniform_intact_base.png` - 制服無傷
- `uniform_damaged_base.png` - 制服破損（一部破れ）
- `uniform_destroyed_base.png` - 制服破壊（大きく破れ）

#### 2-3. 表情（3種類）
基本ポーズに合わせて各表情を作成（自動補完対応のみ）：
- **endure**（耐える） - Stage1で頻出
- **confused**（困惑） - 全Stageで使用
- **ahe**（アヘ顔） - Stage3で頻出

#### 2-4. 頬染め（3段階）
透過PNGで頬の赤みのみを描画：
- blush_low, blush_mid, blush_high

**配置**: 上記全てを非挿入・挿入の両フォルダに配置

---

### Step 3: エフェクト画像の作成

#### 3-1. 拘束エフェクト
- `default_pose_overlay_restrain.png`
  - ピンク/紫色のスライムが身体に絡みつく様子
  - 媚薬の霧やキラキラエフェクト

#### 3-2. 攻撃エフェクト（非挿入用）
- `default_pose_overlay_attack_pussy_soft.png` - 陰部攻撃（弱）
- `default_pose_overlay_attack_pussy_hard.png` - 陰部攻撃（強）
- `default_pose_overlay_slime_breast.png` - 胸へのスライム
- `default_pose_overlay_slime_pussy.png` - 陰部へのスライム

#### 3-3. 挿入エフェクト（挿入用）
- `default_pose_overlay_insert_mouth_pre.png` - **口挿入pre（挿入前・受け入れ）★専用**
- `default_pose_overlay_insert_mouth_main.png` - **口挿入main（挿入完了・攻撃中）★専用**
- `default_pose_overlay_slime_fullbody_soft.png` - **全身スライム（弱）※挿入時も継続**
- `default_pose_overlay_slime_fullbody_hard.png` - **全身スライム（強）※挿入時も継続**

---

### Step 4: SFX擬音画像の作成（10種類）

**重要**: 1枚の画像に左右両方の擬音を描く

#### 非挿入用（6種類）
1. `default_pose_overlay_ぬちょっ1-6.png`
2. `default_pose_overlay_ぐちゅっ1-6.png`
3. `default_pose_overlay_ぐちゃ1-6.png`
4. `default_pose_overlay_ぬちゃっ1-6.png`
5. `default_pose_overlay_ヌポッ1-6.png`
6. `default_pose_overlay_ずぶ3-6.png`

#### 挿入用（上記6種 + 4種）
7. `default_pose_overlay_ズプッ1-6.png`
8. `default_pose_overlay_ズポ1-6.png`
9. `default_pose_overlay_ヌプッ1-6.png`
10. `default_pose_overlay_ズン1-6.png`

**各SFXの段階**:
- `1-6`: 絶頂回数1～6回に対応する6段階のバリエーション
- 絶頂回数が増えるほど、文字が大きく/濃く/崩れるなど

---

## ⚠️ 重要な注意事項

### 1. 独立したモンスター
- 媚薬スライムは通常スライムとは**完全に別のモンスター**
- 他のモンスターの画像を流用することはできません
- キャラクターのベースポーズから全て新規作成が必要

### 2. SFX画像の形式
- **1枚の画像に左右両方の擬音を描く**形式
- ファイル名に `_left` や `_right` をつけない
- 例: `default_pose_overlay_ぬちょっ1-6.png`（1枚に左右両方）

### 3. 絶頂段階による変化
- SFXは `1-6` の段階があり、絶頂回数に応じて変化
- Stage1（絶頂0-1回）→ 控えめな擬音
- Stage2（絶頂2-4回）→ やや激しい擬音
- Stage3（絶頂5回以上）→ 激しく崩れた擬音

### 4. 媚薬スライムの視覚的特徴
- **色**: ピンク系/紫系（通常スライムの青緑とは異なる）
- **エフェクト**: ハートマーク、キラキラ、ピンク色の霧
- **透明度**: やや透明感（媚薬が浸透する様子を表現）

---

## 📝 まとめ

### 必要画像総数: **48枚**（複数部位SFX対応版 + 挿入時継続攻撃）
- 制服: 6枚
- 表情: 6枚（**自動補完対応の3種のみ**）
- 頬染め: 6枚
- エフェクト: 8枚（拘束2枚・fullbody攻撃2枚・挿入4枚）
- SFX: 18枚（擬音）
  - 非挿入: 6枚（膣4枚 + 胸2枚）
  - 挿入: 12枚（口6枚 + 胸2枚 + 膣4枚）
- **全て新規作成**

### 作業の優先順位
1. **最優先**: 制服・表情・頬染め（18枚）- ゲーム動作に必須
2. **高優先**: 拘束・攻撃・挿入エフェクト（8枚）- 演出の核
3. **中優先**: SFX擬音（18枚）- 臨場感を高める（複数部位対応）

### 媚薬スライムの特徴
- ✅ 複数部位同時攻撃に対応
- ✅ 各SFXが適切な位置に表示される
- ✅ 非挿入時: 2部位（膣 + 胸）
- ✅ **挿入時: 3部位（口 + 胸 + 膣）+ 挿入中も全身攻撃を継続**
- ✅ 口挿入は pre/main の2段階（挿入前/攻撃中）

---

## 💰 コスト削減オプション: `hardonly` パターンの使用

### 概要
画像差分を減らしてコストを削減したい場合、`hardonly`パターンを使用できます。

### 削減できる画像

#### 通常版（soft/hard両方必要）
- `slime_fullbody_soft.png` + `slime_fullbody_hard.png` = **2枚**
- `insert_mouth_pre.png` + `insert_mouth_main.png` = **2枚**
- **合計**: 4枚 × 2フォルダ = **8枚**

#### hardonly版（hardのみ）
- `slime_fullbody.png`（1枚のみ）
- `insert_mouth.png`（1枚のみ）
- **合計**: 2枚 × 2フォルダ = **4枚**

#### 削減効果
- **48枚 → 44枚**（約8%削減）
- **制作時間**: 差分作業が不要になる分、さらに削減

### 実装方法

`VisualOverlayData.js`の媚薬スライム設定で、以下のように変更：

```javascript
// 非挿入攻撃
breast: {
  soft: "slime_fullbody",  // ← 同じ画像を指定
  hard: "slime_fullbody",  // ← 同じ画像を指定
  sequences: {
    react: SEQUENCE_PATTERNS.hardonlyShort,    // ← hardonlyパターンを使用
    danger: SEQUENCE_PATTERNS.hardonlyMedium,  // ← hardonlyパターンを使用
    // ...
  }
},

// 挿入攻撃
mouth: {
  soft: "insert_mouth",  // ← 同じ画像を指定
  hard: "insert_mouth",  // ← 同じ画像を指定
  sequences: {
    ...SEQUENCE_PATTERNS.insertionHardOnly,  // ← insertionHardOnlyを使用
    danger: SEQUENCE_PATTERNS.hardonlyMedium
    // ...
  }
}
```

### メリット・デメリット

#### メリット
- ✅ 画像枚数を削減（8枚 → 4枚）
- ✅ 差分作業が不要で制作コスト削減
- ✅ メモリ使用量削減
- ✅ 読み込み時間短縮

#### デメリット
- ❌ 演出の緩急が減る（常に激しい表現のみ）
- ❌ ビジュアルバリエーションが少なくなる

### 推奨
- **媚薬スライム**: 差分があった方が媚薬効果の段階的な表現ができるため、通常版推奨
- **その他の差分少数モンスター**: 予算・時間が限られている場合は`hardonly`推奨

---

## 更新履歴
- 2025-12-08: 初版作成（システムの自動補完を考慮）
- 2025-12-08: 修正版 - 全画像が新規作成必要であることを明記
- 2025-12-08: 表情を自動補完システム対応版に絞り込み（3種類のみ: endure, confused, ahe）
- 2025-12-08: 複数部位SFX対応システム実装完了
  - エフェクト画像をfullbody形式に変更
  - SFX配置を部位別に整理（膣・胸・口）
  - 非挿入時2部位、挿入時3部位の同時表示に対応
- 2025-12-08: **最終版** - 挿入時継続攻撃対応
  - 口挿入をpre/main形式に変更（soft/hardから変更）
  - 挿入時も非挿入攻撃（fullbody）を継続表示
  - 合計48枚（46枚→48枚に増加）
- 2025-12-09: **hardonlyパターン追加**
  - 差分少数モンスター向けのコスト削減オプション追加
  - hardonlyShort/Medium/Long パターン実装
  - insertionHardOnly パターン実装
  - 画像枚数を最大8枚削減可能（48枚 → 40枚）

